/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.gui.pt;

import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.html.HTMLDocument;

public class TextPaneCellRenderer
extends JTextPane
implements TableCellRenderer {
    public TextPaneCellRenderer() {
        this.setContentType("text/html");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.validate();
        String texto = (String)value;
        texto = texto.replaceAll("[ \t]+", " ");
        this.setText(texto);
        ((HTMLDocument)this.getDocument()).getStyleSheet().addRule("body{font-family: " + this.getFont().getFamily() + "; font-size: " + this.getFont().getSize() + ";}");
        this.setFont(table.getFont());
        int width = table.getColumnModel().getColumn(0).getWidth() - 2 * table.getIntercellSpacing().width - this.getMargin().left - this.getMargin().right;
        int lines = this.getNumLines(texto.replaceAll("<.*>", ""), this.getFontMetrics(this.getFont()), width);
        int fontHeight = this.getFontMetrics(this.getFont()).getHeight();
        table.setRowHeight(row, fontHeight * lines + this.getMargin().bottom + this.getMargin().top + table.getIntercellSpacing().height);
        return this;
    }

    private int getNumLines(String texto, FontMetrics metric, int width) {
        String[] palabras = texto.split(" ");
        int numLines = 1;
        String linea = "";
        boolean hayTag = false;
        int i = 0;
        while (i < palabras.length) {
            if (linea.length() > 0) {
                linea = String.valueOf(linea) + " ";
            }
            if (palabras[i].indexOf("<") >= 0) {
                hayTag = true;
            }
            if (!hayTag && metric.stringWidth(linea = String.valueOf(linea) + palabras[i]) > width) {
                ++numLines;
                linea = palabras[i];
            }
            if (palabras[i].indexOf(">") >= 0) {
                hayTag = true;
            }
            ++i;
        }
        return numLines;
    }
}

