/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.gui.pt;

import es.gob.aeat.dit.ov.renta.Enviroment;
import es.gob.aeat.dit.ov.renta.gui.pt.AvisosPanel;
import es.gob.aeat.dit.ov.renta.gui.pt.PTOkDialog;
import es.gob.aeat.dit.ov.renta.gui.pt.RealizadaPanelIF;
import es.gob.aeat.dit.ov.renta.http.PTHttpResponse;
import es.gob.aeat.dit.ov.renta.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class RealizadaPanel
extends JPanel
implements RealizadaPanelIF {
    private String textDateStr;
    private JLabel lblOk;
    private JTextPane textPaneFecha;
    private AvisosPanel panelAvisos;
    private JPanel panelPdf;
    private JTextPane textPanePDF;
    private JButton btnVer;
    private JLabel lblPdf;
    private File pathPdf;
    private JTextPane textPaneCotejo;
    private int authMethod;

    public RealizadaPanel(HyperlinkListener linkListener, int authMethod) {
        this.authMethod = authMethod;
        this.setOpaque(false);
        Enviroment env = Enviroment.getInstance();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        gridBagLayout2.columnWidths = new int[2];
        gridBagLayout2.rowHeights = new int[6];
        gridBagLayout2.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout2.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout2);
        this.lblOk = new JLabel();
        this.lblOk.setForeground(SystemColor.textHighlight);
        this.lblOk.setFont(new Font("Tahoma", 1, 14));
        this.lblOk.setText(env.getString("PTOkDialog.Info"));
        this.lblOk.setIcon(new ImageIcon(PTOkDialog.class.getResource("/es/gob/aeat/dit/ov/renta/resources/continuar.png")));
        GridBagConstraints gbc_lblOk = new GridBagConstraints();
        gbc_lblOk.fill = 3;
        gbc_lblOk.insets = new Insets(10, 0, 0, 0);
        gbc_lblOk.gridx = 0;
        gbc_lblOk.gridy = 0;
        this.add((Component)this.lblOk, gbc_lblOk);
        JPanel panelFecha = new JPanel();
        panelFecha.setOpaque(false);
        GridBagConstraints gbc_panelFecha = new GridBagConstraints();
        gbc_panelFecha.insets = new Insets(5, 0, 10, 0);
        gbc_panelFecha.fill = 1;
        gbc_panelFecha.gridx = 0;
        gbc_panelFecha.gridy = 1;
        this.add((Component)panelFecha, gbc_panelFecha);
        GridBagLayout gbl_panelFecha = new GridBagLayout();
        gbl_panelFecha.columnWidths = new int[2];
        gbl_panelFecha.rowHeights = new int[2];
        gbl_panelFecha.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_panelFecha.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelFecha.setLayout(gbl_panelFecha);
        this.textPaneFecha = new JTextPane();
        this.textPaneFecha.setEditable(false);
        this.textPaneFecha.setRequestFocusEnabled(false);
        this.textPaneFecha.setFocusable(false);
        this.textPaneFecha.setFocusCycleRoot(false);
        this.textPaneFecha.setContentType("text/html");
        ((HTMLDocument)this.textPaneFecha.getDocument()).getStyleSheet().addRule("body{font-family: " + this.textPaneFecha.getFont().getFamily() + "; font-size: " + this.textPaneFecha.getFont().getSize() + ";}");
        this.textPaneFecha.setOpaque(false);
        GridBagConstraints gbc_textPaneFecha = new GridBagConstraints();
        gbc_textPaneFecha.fill = 3;
        gbc_textPaneFecha.gridx = 0;
        gbc_textPaneFecha.gridy = 0;
        panelFecha.add((Component)this.textPaneFecha, gbc_textPaneFecha);
        this.panelAvisos = new AvisosPanel();
        this.panelAvisos.addHyperlinkListener(linkListener);
        this.panelAvisos.setVisible(false);
        this.panelAvisos.setMinimumSize(new Dimension(400, 225));
        this.panelAvisos.setPreferredSize(new Dimension(400, 225));
        GridBagConstraints gbc_panelAvisos = new GridBagConstraints();
        gbc_panelAvisos.insets = new Insets(0, 0, 10, 0);
        gbc_panelAvisos.fill = 1;
        gbc_panelAvisos.gridx = 0;
        gbc_panelAvisos.gridy = 2;
        this.add((Component)this.panelAvisos, gbc_panelAvisos);
        this.panelPdf = new JPanel();
        this.panelPdf.setBackground(Color.WHITE);
        this.panelPdf.setBorder(new LineBorder(UIManager.getColor("textHighlight"), 4, false));
        GridBagConstraints gbc_panelPdf = new GridBagConstraints();
        gbc_panelPdf.insets = new Insets(5, 0, 5, 0);
        gbc_panelPdf.fill = 1;
        gbc_panelPdf.gridx = 0;
        gbc_panelPdf.gridy = 3;
        this.add((Component)this.panelPdf, gbc_panelPdf);
        GridBagLayout gbl_panelPdf = new GridBagLayout();
        gbl_panelPdf.columnWidths = new int[3];
        gbl_panelPdf.rowHeights = new int[3];
        gbl_panelPdf.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_panelPdf.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.panelPdf.setLayout(gbl_panelPdf);
        this.textPanePDF = new JTextPane();
        this.textPanePDF.setOpaque(false);
        this.textPanePDF.setEditable(false);
        this.textPanePDF.addHyperlinkListener(linkListener);
        this.textPanePDF.setContentType("text/html");
        ((HTMLDocument)this.textPanePDF.getDocument()).getStyleSheet().addRule("body{font-family: " + this.textPanePDF.getFont().getFamily() + "; font-size: " + this.textPanePDF.getFont().getSize() + ";}");
        GridBagConstraints gbc_textPanePDF = new GridBagConstraints();
        gbc_textPanePDF.anchor = 11;
        gbc_textPanePDF.fill = 2;
        gbc_textPanePDF.gridwidth = 2;
        gbc_textPanePDF.insets = new Insets(0, 0, 10, 5);
        gbc_textPanePDF.gridx = 0;
        gbc_textPanePDF.gridy = 0;
        this.panelPdf.add((Component)this.textPanePDF, gbc_textPanePDF);
        this.btnVer = new JButton();
        this.btnVer.setText(env.getString("PTOkDialog.PDFVer"));
        this.btnVer.setMnemonic('P');
        this.btnVer.setBackground(Enviroment.COLOR_BASE);
        this.btnVer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RealizadaPanel.this.showPDF();
            }
        });
        GridBagConstraints gbc_btnVer = new GridBagConstraints();
        gbc_btnVer.anchor = 16;
        gbc_btnVer.insets = new Insets(0, 5, 5, 0);
        gbc_btnVer.gridx = 0;
        gbc_btnVer.gridy = 1;
        this.panelPdf.add((Component)this.btnVer, gbc_btnVer);
        this.lblPdf = new JLabel();
        this.lblPdf.setHorizontalTextPosition(4);
        this.lblPdf.setIcon(new ImageIcon(PTOkDialog.class.getResource("/es/gob/aeat/dit/ov/renta/resources/pdflogo.png")));
        this.lblPdf.setFont(new Font("Tahoma", 1, 11));
        GridBagConstraints gbc_lblPdf = new GridBagConstraints();
        gbc_lblPdf.anchor = 17;
        gbc_lblPdf.insets = new Insets(0, 5, 5, 5);
        gbc_lblPdf.gridx = 1;
        gbc_lblPdf.gridy = 1;
        this.panelPdf.add((Component)this.lblPdf, gbc_lblPdf);
        GridBagConstraints gbc_textPaneCotejo = new GridBagConstraints();
        gbc_textPaneCotejo.insets = new Insets(10, 0, 0, 0);
        gbc_textPaneCotejo.fill = 1;
        gbc_textPaneCotejo.gridx = 0;
        gbc_textPaneCotejo.gridy = 4;
        this.textPaneCotejo = new JTextPane();
        this.textPaneCotejo.addHyperlinkListener(linkListener);
        this.textPaneCotejo.setOpaque(false);
        this.textPaneCotejo.setEditable(false);
        this.textPaneCotejo.setContentType("text/html");
        ((HTMLDocument)this.textPaneCotejo.getDocument()).getStyleSheet().addRule("body{font-family: " + this.textPaneCotejo.getFont().getFamily() + "; font-size: " + this.textPaneCotejo.getFont().getSize() + ";}");
        this.add((Component)this.textPaneCotejo, gbc_textPaneCotejo);
    }

    @Override
    public void setResponse(PTHttpResponse response, File pathPdf) {
        String message;
        this.setPathPdf(pathPdf);
        Enviroment env = Enviroment.getInstance();
        String urlCotejo = null;
        try {
            urlCotejo = env.getURLDistribuidor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String txtCotejo = env.getString("PTOkDialog.Cotejo").replaceAll("&amp;URL;", urlCotejo);
        txtCotejo = txtCotejo.replaceAll("&amp;CSV;", response.getCSV());
        txtCotejo = txtCotejo.replaceAll("&amp;PARAM;", Enviroment.urlEncode("CSV=" + response.getCSV()));
        this.textPaneCotejo.setText(txtCotejo);
        if (this.pathPdf == null) {
            String message2 = Enviroment.getInstance().getString("PTOkDialog.NoPDF");
            message2 = message2.replaceAll("&amp;URL;", urlCotejo);
            message2 = message2.replaceAll("&amp;PARAM;", Enviroment.urlEncode("CSV=" + response.getCSV()));
            this.textPanePDF.setText(message2);
        }
        String mod = response.getVariable("MOD");
        String tia = response.getVariable("TIA");
        String ico = response.getVariable("ICO");
        String cll = response.getVariable("CLL");
        String cer = response.getVariable("CER");
        String ndc = response.getVariable("NDC");
        String rfd = response.getVariable("RFD");
        String msg = response.getVariable("MSG");
        String fec = response.getVariable("FEC");
        String hor = response.getVariable("HOR");
        String cym = response.getVariable("CYM");
        String mct = response.getVariable("MCT");
        if (fec != null && hor != null) {
            String fecha = env.getString("PTOkDialog.Fecha");
            fecha = fecha.replaceAll("&amp;FEC;", fec);
            this.textDateStr = fecha = fecha.replaceAll("&amp;HOR;", hor);
            this.textPaneFecha.setText(fecha);
        }
        if (tia != null && tia.trim().length() > 0 && (message = this.getTiaMsg(mod.trim(), tia.trim().toUpperCase().charAt(0), cym.trim())) != null) {
            String urlDeuda = "";
            try {
                urlDeuda = Enviroment.getInstance().getURLDistribuidor();
            }
            catch (Exception e) {
                urlDeuda = e.getMessage();
            }
            String auth = "CER";
            if (this.authMethod == 1) {
                auth = "PIN";
            } else if (this.authMethod == 2) {
                auth = "REF";
            }
            message = message.replaceAll("&amp;AUT;", auth);
            String ext = "nif=" + ndc + "&liq=" + cll;
            if (!"S".equals(cer)) {
                ext = String.valueOf(ext) + "&ref=" + rfd + "&ejf=" + 2014;
            }
            message = message.replaceAll("&amp;PARAM;", Enviroment.urlEncode(ext));
            message = message.replaceAll("&amp;ICO;", ico);
            message = message.replaceAll("&amp;CLL;", cll);
            message = message.replaceAll("&amp;IDI;", env.getIdioma());
            message = message.replaceAll("&amp;URL;", urlDeuda);
            this.panelAvisos.addWarning(message);
            this.panelAvisos.setVisible(true);
        }
        if (msg != null) {
            if (msg.indexOf("A") >= 0) {
                this.panelAvisos.addWarning(env.getString("PTOkDialog.CTA_A"));
                this.panelAvisos.setVisible(true);
            }
            if (msg.indexOf("B") >= 0) {
                this.panelAvisos.addWarning(env.getString("PTOkDialog.CTA_B"));
                this.panelAvisos.setVisible(true);
            }
            if (msg.indexOf("C") >= 0) {
                this.panelAvisos.addWarning(env.getString("PTOkDialog.CTA_C"));
                this.panelAvisos.setVisible(true);
            }
            if (msg.indexOf("D") >= 0) {
                this.panelAvisos.addWarning(env.getString("PTOkDialog.CTA_D"));
                this.panelAvisos.setVisible(true);
            }
            if ((msg.equals("A") || msg.equals("B") || msg.equals("C")) && ("100".equals(mod) || "714".equals(mod) && this.authMethod != 2)) {
                String msgRect = env.getString("PTOkDialog.CTA_Rec");
                String urlRectCCC = this.getUrlRectCCC(response);
                msgRect = msgRect.replaceAll("&amp;URL;", urlRectCCC);
                this.panelAvisos.addWarning(msgRect);
                this.panelAvisos.setVisible(true);
            }
        }
        if (mct != null) {
            if ((mct = mct.trim()).indexOf("A") >= 0) {
                this.panelAvisos.addWarning(env.getString("PTOkDialog.CancelCita_A"));
                this.panelAvisos.setVisible(true);
            }
            if (mct.indexOf("B") >= 0) {
                this.panelAvisos.addWarning(env.getString("PTOkDialog.CancelCita_B"));
                this.panelAvisos.setVisible(true);
            }
            if (mct.indexOf("C") >= 0) {
                this.panelAvisos.addWarning(env.getString("PTOkDialog.CancelCita_C"));
                this.panelAvisos.setVisible(true);
            }
            if (mct.indexOf("D") >= 0) {
                this.panelAvisos.addWarning(env.getString("PTOkDialog.CancelCita_D"));
                this.panelAvisos.setVisible(true);
            }
        }
    }

    private void setPathPdf(File pathPdf) {
        this.pathPdf = pathPdf;
        if (pathPdf != null) {
            this.textPanePDF.setText(Enviroment.getInstance().getString("PTOkDialog.PDFInfo"));
            this.lblPdf.setText(pathPdf.getAbsolutePath());
            this.lblPdf.setToolTipText(pathPdf.getAbsolutePath());
            this.lblPdf.setVisible(true);
            this.btnVer.setVisible(true);
        } else {
            this.textPanePDF.setText("");
            this.lblPdf.setVisible(false);
            this.btnVer.setVisible(false);
        }
    }

    private String getTiaMsg(String modelo, char tia, String cym) {
        if ("X".equals(cym) && "714".equals(modelo) || "100".equals(modelo)) {
            if (tia == 'M' || tia == 'F') {
                return Enviroment.getInstance().getString("PTOkDialog.TIA_MF");
            }
            if (tia == 'A' || tia == 'E') {
                return Enviroment.getInstance().getString("PTOkDialog.TIA_AE");
            }
            if (tia == 'P' || tia == 'Z') {
                return Enviroment.getInstance().getString("PTOkDialog.TIA_PZ");
            }
            if (tia == 'H' || tia == 'J') {
                String urlPatri = "";
                try {
                    urlPatri = Enviroment.getInstance().getURLDistribuidor();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String message = Enviroment.getInstance().getString("PTOkDialog.TIA_HJ");
                message = message.replaceAll("&amp;URL;", urlPatri);
                message = message.replaceAll("&amp;AUT;", this.authMethod == 1 ? "PIN" : "CER");
                return message;
            }
        } else if ("714".equals(modelo) && (tia == 'M' || tia == 'F' || tia == 'A' || tia == 'E' || tia == 'P' || tia == 'Z' || tia == 'H' || tia == 'J')) {
            return Enviroment.getInstance().getString("PTOkDialog.TIA_714");
        }
        return null;
    }

    private String getUrlRectCCC(PTHttpResponse response) {
        Enviroment env = Enviroment.getInstance();
        String mod = response.getVariable("MOD");
        String idi = response.getVariable("IDI");
        String ndc = response.getVariable("NDC");
        String a11 = response.getVariable("A11");
        String rfd = response.getVariable("RFD");
        String ejf = response.getVariable("EJF");
        String cel = response.getVariable("CEL");
        String jus = response.getVariable("JUS");
        String niu = response.getVariable("NIU");
        String fec = response.getVariable("FEC");
        String exp = response.getVariable("REG");
        String ice = response.getVariable("ICE");
        String ics = response.getVariable("ICS");
        String icd = response.getVariable("ICD");
        String icc = response.getVariable("ICC");
        String urlRectCCC = "";
        try {
            int am = this.authMethod;
            if ("714".equals(mod) && this.authMethod == 2) {
                am = 0;
            }
            urlRectCCC = env.getURLRectCCC(am);
        }
        catch (Exception e) {
            urlRectCCC = e.getMessage();
        }
        if (this.authMethod == 2 && !"714".equals(mod)) {
            urlRectCCC = String.valueOf(urlRectCCC) + "?HID=BOR210CC";
            urlRectCCC = String.valueOf(urlRectCCC) + "&IDI=" + idi;
            urlRectCCC = String.valueOf(urlRectCCC) + "&NIF=" + ndc;
            urlRectCCC = String.valueOf(urlRectCCC) + "&APE=" + Enviroment.urlEncode(a11);
            urlRectCCC = String.valueOf(urlRectCCC) + "&REF=" + Enviroment.urlEncode(rfd);
            urlRectCCC = String.valueOf(urlRectCCC) + "&EJF=" + ejf;
        } else {
            urlRectCCC = String.valueOf(urlRectCCC) + "?HID=IE5RECMC";
            urlRectCCC = String.valueOf(urlRectCCC) + "&IDI=" + idi;
            urlRectCCC = String.valueOf(urlRectCCC) + "&MOD=" + mod;
            urlRectCCC = String.valueOf(urlRectCCC) + "&NIF=" + ndc;
            urlRectCCC = String.valueOf(urlRectCCC) + "&APE=" + Enviroment.urlEncode(a11);
            urlRectCCC = String.valueOf(urlRectCCC) + "&EJF=" + ejf;
            urlRectCCC = String.valueOf(urlRectCCC) + "&PER=0A";
            urlRectCCC = String.valueOf(urlRectCCC) + "&CEL=" + Enviroment.urlEncode(cel);
            urlRectCCC = String.valueOf(urlRectCCC) + "&JUS=" + Enviroment.urlEncode(jus);
            urlRectCCC = String.valueOf(urlRectCCC) + "&NIU=" + Enviroment.urlEncode(niu);
            urlRectCCC = String.valueOf(urlRectCCC) + "&ICE=" + ice;
            urlRectCCC = String.valueOf(urlRectCCC) + "&ICS=" + ics;
            urlRectCCC = String.valueOf(urlRectCCC) + "&ICD=" + icd;
            urlRectCCC = String.valueOf(urlRectCCC) + "&ICC=" + icc;
            urlRectCCC = String.valueOf(urlRectCCC) + "&FEC=" + Enviroment.urlEncode(fec);
            urlRectCCC = String.valueOf(urlRectCCC) + "&EXP=" + Enviroment.urlEncode(exp);
        }
        return urlRectCCC;
    }

    public void showPDF() {
        if (this.pathPdf != null) {
            Util.showPDF(this, this.pathPdf.getAbsolutePath());
        }
    }

    @Override
    public String getDateText() {
        return this.textDateStr;
    }
}

