/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.gui.pt;

import es.gob.aeat.dit.ov.renta.Enviroment;
import es.gob.aeat.dit.ov.renta.gui.RentaDialog;
import es.gob.aeat.dit.ov.renta.gui.pt.RealizadaPanel;
import es.gob.aeat.dit.ov.renta.gui.pt.RealizadaPanelIF;
import es.gob.aeat.dit.ov.renta.gui.pt.YaRealizadaPanel;
import es.gob.aeat.dit.ov.renta.http.PTHttpResponse;
import es.gob.aeat.dit.ov.renta.util.Util;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class PTOkDialog
extends RentaDialog
implements HyperlinkListener {
    private static final long serialVersionUID = 1L;
    private RealizadaPanelIF panelData;
    private int authMethod;
    private boolean esDuplicada;

    public PTOkDialog(Dialog owner, int authMethod) {
        super(owner);
        this.authMethod = authMethod;
        this.esDuplicada = false;
        Enviroment env = Enviroment.getInstance();
        this.setTitle(env.getString("PTOkDialog.Title"));
        this.setModal(true);
        this.setResizable(false);
        this.getContentPane().setBackground(Enviroment.COLOR_BASE);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[2];
        gridBagLayout.rowHeights = new int[3];
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(gridBagLayout);
        JButton btnCerrar = new JButton(env.getString("PTOkDialog.Aceptar"));
        btnCerrar.setIconTextGap(8);
        btnCerrar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PTOkDialog.this.dispose();
            }
        });
        btnCerrar.setMnemonic('F');
        btnCerrar.setOpaque(false);
        btnCerrar.setIcon(new ImageIcon(PTOkDialog.class.getResource("/es/gob/aeat/dit/ov/renta/resources/finish.png")));
        GridBagConstraints gbc_btnCerrar = new GridBagConstraints();
        gbc_btnCerrar.insets = new Insets(0, 0, 5, 5);
        gbc_btnCerrar.anchor = 13;
        gbc_btnCerrar.gridx = 0;
        gbc_btnCerrar.gridy = 1;
        this.getContentPane().add((Component)btnCerrar, gbc_btnCerrar);
        this.setFocusComponent(btnCerrar);
    }

    @Override
    public JPanel getPanelData() {
        return (JPanel)((Object)this.panelData);
    }

    public void setResponse(PTHttpResponse response, File pathPdf) {
        this.esDuplicada = response.isYaPresentada();
        this.panelData = this.esDuplicada ? new YaRealizadaPanel(this) : new RealizadaPanel(this, this.authMethod);
        GridBagConstraints gbc_panelData = new GridBagConstraints();
        gbc_panelData.gridx = 0;
        gbc_panelData.gridy = 0;
        gbc_panelData.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)((JPanel)((Object)this.panelData)), gbc_panelData);
        this.panelData.setResponse(response, pathPdf);
    }

    public boolean esDuplicada() {
        return this.esDuplicada;
    }

    public String getDateText() {
        return this.panelData.getDateText();
    }

    private void showURL(String url) {
        Util.showLinkInBrowser(this, url);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && e.getURL() != null) {
            this.showURL(e.getURL().toString());
        }
    }

    public void showDialog(boolean showPdf) {
        if (this.panelData instanceof RealizadaPanel) {
            ((RealizadaPanel)this.panelData).showPDF();
        }
        super.showDialog();
    }
}

