/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.gui.pt;

import es.gob.aeat.dit.ov.renta.Enviroment;
import es.gob.aeat.dit.ov.renta.gui.RentaDialog;
import es.gob.aeat.dit.ov.renta.gui.pt.TextPaneCellRenderer;
import es.gob.aeat.dit.ov.renta.util.Util;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.DefaultTableModel;

public class PTErrorDialog
extends RentaDialog
implements HyperlinkListener {
    private static final long serialVersionUID = 1L;
    private JTable tableErrores;
    private JPanel panelData;

    public PTErrorDialog(Dialog owner) {
        super(owner);
        Enviroment env = Enviroment.getInstance();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.getContentPane().setBackground(Enviroment.COLOR_BASE);
        this.setTitle(env.getString("PTErrorDialog.Title"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[2];
        gridBagLayout.rowHeights = new int[3];
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, 0.0, 0.0};
        this.getContentPane().setLayout(gridBagLayout);
        this.panelData = new JPanel();
        this.panelData.setOpaque(false);
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.insets = new Insets(0, 0, 5, 0);
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 0;
        this.getContentPane().add((Component)this.panelData, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[2];
        gbl_panel.rowHeights = new int[3];
        gbl_panel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        this.panelData.setLayout(gbl_panel);
        JLabel lblSeProdujeronErrores = new JLabel();
        lblSeProdujeronErrores.setText(env.getString("PTErrorDialog.Info"));
        lblSeProdujeronErrores.setIcon(new ImageIcon(PTErrorDialog.class.getResource("/es/gob/aeat/dit/ov/renta/resources/borrar.png")));
        GridBagConstraints gbc_lblSeProdujeronErrores = new GridBagConstraints();
        gbc_lblSeProdujeronErrores.insets = new Insets(5, 0, 5, 0);
        gbc_lblSeProdujeronErrores.gridx = 0;
        gbc_lblSeProdujeronErrores.gridy = 0;
        this.panelData.add((Component)lblSeProdujeronErrores, gbc_lblSeProdujeronErrores);
        Object[][] data = new String[1][1];
        Object[] columnName = new String[]{env.getString("PTErrorDialog.Column")};
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(400, 200));
        scrollPane.setMinimumSize(new Dimension(350, 200));
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.insets = new Insets(0, 5, 0, 5);
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 1;
        this.panelData.add((Component)scrollPane, gbc_scrollPane);
        this.tableErrores = new JTable(data, columnName);
        this.tableErrores.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object obj;
                Point p = e.getPoint();
                int column = PTErrorDialog.this.tableErrores.columnAtPoint(p);
                int row = PTErrorDialog.this.tableErrores.rowAtPoint(p);
                if (column >= 0 && row >= 0 && (obj = PTErrorDialog.this.tableErrores.getValueAt(row, column)) instanceof String) {
                    String texto = (String)obj;
                    PTErrorDialog.this.findLink(texto);
                }
            }
        });
        this.tableErrores.setEnabled(false);
        this.tableErrores.setIntercellSpacing(new Dimension(25, 1));
        this.tableErrores.setRowMargin(5);
        TextPaneCellRenderer cellRenderer = new TextPaneCellRenderer();
        cellRenderer.addHyperlinkListener(this);
        this.tableErrores.setDefaultRenderer(this.tableErrores.getColumnClass(0), cellRenderer);
        scrollPane.setViewportView(this.tableErrores);
        JButton btnAceptar = new JButton(env.getString("PTErrorDialog.Cerrar"));
        btnAceptar.setIcon(new ImageIcon(PTErrorDialog.class.getResource("/es/gob/aeat/dit/ov/renta/resources/cancel.png")));
        btnAceptar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PTErrorDialog.this.setVisible(false);
                PTErrorDialog.this.dispose();
            }
        });
        btnAceptar.setMnemonic('C');
        btnAceptar.setBackground(Enviroment.COLOR_BASE);
        GridBagConstraints gbc_btnAceptar = new GridBagConstraints();
        gbc_btnAceptar.anchor = 11;
        gbc_btnAceptar.insets = new Insets(0, 0, 5, 0);
        gbc_btnAceptar.gridx = 0;
        gbc_btnAceptar.gridy = 2;
        this.getContentPane().add((Component)btnAceptar, gbc_btnAceptar);
        this.pack();
        this.setFocusComponent(btnAceptar);
        this.setMinimumSize(this.getSize());
    }

    public void setErrores(String[] errores) {
        Object[][] data = new String[errores.length][1];
        int i = 0;
        while (i < errores.length) {
            data[i][0] = errores[i];
            ++i;
        }
        Object[] columnName = new String[]{Enviroment.getInstance().getString("PTErrorDialog.Column")};
        this.tableErrores.setModel(new DefaultTableModel(data, columnName));
    }

    @Override
    public JPanel getPanelData() {
        return this.panelData;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && e.getURL() != null) {
            Util.showLinkInBrowser(this, e.getURL().toString());
        }
    }

    private void findLink(String texto) {
        int fin;
        String url = null;
        String str = texto.replaceAll("[ \t]+", " ");
        String iniLink = "<a ";
        String iniHRef = " href=";
        int ini = str.indexOf(iniLink);
        if (ini >= 0 && (fin = str.indexOf(">", ini)) > ini && (ini = str.indexOf(iniHRef, ini)) > 0 && ini < fin) {
            char comillas = str.charAt(ini + iniHRef.length());
            ini = ini + iniHRef.length() + 1;
            int finComillas = str.indexOf("" + comillas, ini);
            if (finComillas > ini && finComillas < fin) {
                url = str.substring(ini, finComillas);
                int iniParams = url.indexOf("?");
                if (iniParams > 0) {
                    String params = url.substring(iniParams + 1);
                    url = String.valueOf(url.substring(0, iniParams + 1)) + params.replaceAll("\\+", "%2B");
                }
                Util.showLinkInBrowser(this, url);
            }
        }
    }
}

