/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.gui.pt;

import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;

public class LineWrapCellRenderer
extends JTextArea
implements TableCellRenderer {
    public LineWrapCellRenderer() {
        this.setWrapStyleWord(true);
        this.setLineWrap(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.validate();
        String texto = (String)value;
        texto = texto.replaceAll("[ \t]+", " ");
        this.setText(texto);
        this.setFont(table.getFont());
        int width = table.getColumnModel().getColumn(0).getWidth() - 2 * table.getIntercellSpacing().width - this.getMargin().left - this.getMargin().right;
        int lines = this.getNumLines(texto, this.getFontMetrics(this.getFont()), width);
        int fontHeight = this.getFontMetrics(this.getFont()).getHeight();
        table.setRowHeight(row, fontHeight * lines + this.getMargin().bottom + this.getMargin().top + table.getIntercellSpacing().height);
        return this;
    }

    private int getNumLines(String texto, FontMetrics metric, int width) {
        String[] palabras = texto.split(" ");
        int numLines = 1;
        String linea = "";
        int i = 0;
        while (i < palabras.length) {
            if (linea.length() > 0) {
                linea = String.valueOf(linea) + " ";
            }
            if (metric.stringWidth(linea = String.valueOf(linea) + palabras[i]) > width) {
                ++numLines;
                linea = palabras[i];
            }
            ++i;
        }
        return numLines;
    }
}

