/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.gui.pt;

import es.gob.aeat.dit.ov.renta.Enviroment;
import es.gob.aeat.dit.ov.renta.gui.AuthMethodChangeListener;
import es.gob.aeat.dit.ov.renta.gui.PTDialog;
import es.gob.aeat.dit.ov.renta.gui.WarningDialog;
import es.gob.aeat.dit.ov.renta.gui.pt.HelpButton;
import es.gob.aeat.dit.ov.renta.gui.pt.LabelRayado;
import es.gob.aeat.dit.ov.renta.gui.pt.LabelTitle;
import es.gob.aeat.dit.ov.renta.pt.Declaracion;
import es.gob.aeat.dit.ov.renta.util.FixedLengthTextField;
import es.gob.aeat.dit.ov.renta.util.NumericTextField;
import es.gob.aeat.dit.ov.renta.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import java.util.logging.Level;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.LineBorder;
import javax.swing.text.html.HTMLDocument;

public class IngresoPanel
extends JPanel
implements AuthMethodChangeListener {
    private static final long serialVersionUID = 1L;
    private JRadioButton rdbtnEfectivo;
    private JRadioButton rdbtnAdeudo;
    private JLabel lblInfo;
    private JTextField textImporte;
    private FixedLengthTextField textNRC;
    private LabelRayado lblImporteIngresado;
    private LabelRayado lblReco;
    private NumericTextField textIngresado;
    private JTextField textReco;
    private JRadioButton rdbtnRIP;
    private JRadioButton rdbtnRSA;
    private JRadioButton rdbtnRSC;
    private JRadioButton rdbtnRPH;
    private JRadioButton rdbtnIRIP;
    private JRadioButton rdbtnIRSA;
    private JRadioButton rdbtnIRSC;
    private JRadioButton rdbtnIRPH;
    private JPanel panelIngreso;
    private JTextPane tpw;
    private PTDialog owner;
    private Enviroment env;
    private JRadioButton rdbtnCargoCuenta;
    private JRadioButton rdbtnTarjeta;
    private JButton btnObtenerNrc;
    private Declaracion decla;
    private JLabel lblPlazo;
    private JPanel panelPago;
    private JButton btnLeeNRC;
    private int authMethod;
    private int tipoPadre;
    private JButton btnHelp;

    public IngresoPanel(int tipoPadre) {
        this.tipoPadre = tipoPadre;
        this.authMethod = -1;
        this.env = Enviroment.getInstance();
        this.setOpaque(false);
        this.setVisible(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[2];
        gridBagLayout.rowHeights = new int[15];
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        LabelTitle lblTipoDeIngreso = new LabelTitle();
        lblTipoDeIngreso.setText(this.env.getString("IngresoPanel.Title"));
        GridBagConstraints gbc_lblTipoDeIngreso = new GridBagConstraints();
        gbc_lblTipoDeIngreso.fill = 2;
        gbc_lblTipoDeIngreso.insets = new Insets(0, 0, 5, 0);
        gbc_lblTipoDeIngreso.gridx = 0;
        gbc_lblTipoDeIngreso.gridy = 0;
        this.add((Component)lblTipoDeIngreso, gbc_lblTipoDeIngreso);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.rdbtnEfectivo = new JRadioButton();
        this.rdbtnEfectivo.setText(this.env.getString("IngresoPanel.Efectivo"));
        this.rdbtnEfectivo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IngresoPanel.this.mostrarSelecci\u00f3n();
            }
        });
        buttonGroup.add(this.rdbtnEfectivo);
        this.rdbtnEfectivo.setMargin(new Insets(0, 2, 0, 2));
        this.rdbtnEfectivo.setVisible(false);
        this.rdbtnEfectivo.setOpaque(false);
        GridBagConstraints gbc_rdbtnEfectivo = new GridBagConstraints();
        gbc_rdbtnEfectivo.anchor = 17;
        gbc_rdbtnEfectivo.gridx = 0;
        gbc_rdbtnEfectivo.gridy = 1;
        this.add((Component)this.rdbtnEfectivo, gbc_rdbtnEfectivo);
        this.rdbtnAdeudo = new JRadioButton();
        this.rdbtnAdeudo.setText(this.env.getString("IngresoPanel.Adeudo"));
        this.rdbtnAdeudo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IngresoPanel.this.mostrarSelecci\u00f3n();
            }
        });
        buttonGroup.add(this.rdbtnAdeudo);
        this.rdbtnAdeudo.setMargin(new Insets(0, 2, 0, 2));
        this.rdbtnAdeudo.setVisible(false);
        this.rdbtnAdeudo.setOpaque(false);
        GridBagConstraints gbc_rdbtnAdeudo = new GridBagConstraints();
        gbc_rdbtnAdeudo.anchor = 17;
        gbc_rdbtnAdeudo.gridx = 0;
        gbc_rdbtnAdeudo.gridy = 2;
        this.add((Component)this.rdbtnAdeudo, gbc_rdbtnAdeudo);
        this.rdbtnRIP = new JRadioButton();
        this.rdbtnRIP.setVisible(false);
        this.rdbtnRIP.setText(this.env.getString("IngresoPanel.RecoImp"));
        this.rdbtnRIP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IngresoPanel.this.lblInfo.setText(IngresoPanel.this.rdbtnRIP.getText());
                IngresoPanel.this.mostrarSelecci\u00f3n();
            }
        });
        buttonGroup.add(this.rdbtnRIP);
        this.rdbtnRIP.setMargin(new Insets(0, 2, 0, 2));
        this.rdbtnRIP.setOpaque(false);
        GridBagConstraints gbc_rdbtnRIP = new GridBagConstraints();
        gbc_rdbtnRIP.anchor = 17;
        gbc_rdbtnRIP.gridx = 0;
        gbc_rdbtnRIP.gridy = 3;
        this.add((Component)this.rdbtnRIP, gbc_rdbtnRIP);
        this.rdbtnRSA = new JRadioButton();
        this.rdbtnRSA.setVisible(false);
        this.rdbtnRSA.setText(this.env.getString("IngresoPanel.RecoApla"));
        this.rdbtnRSA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IngresoPanel.this.lblInfo.setText(IngresoPanel.this.rdbtnRSA.getText());
                IngresoPanel.this.mostrarSelecci\u00f3n();
            }
        });
        buttonGroup.add(this.rdbtnRSA);
        this.rdbtnRSA.setMargin(new Insets(0, 2, 0, 2));
        this.rdbtnRSA.setOpaque(false);
        GridBagConstraints gbc_rdbtnRSA = new GridBagConstraints();
        gbc_rdbtnRSA.anchor = 17;
        gbc_rdbtnRSA.gridx = 0;
        gbc_rdbtnRSA.gridy = 4;
        this.add((Component)this.rdbtnRSA, gbc_rdbtnRSA);
        this.rdbtnRSC = new JRadioButton();
        this.rdbtnRSC.setVisible(false);
        this.rdbtnRSC.setText(this.env.getString("IngresoPanel.RecoComp"));
        this.rdbtnRSC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IngresoPanel.this.lblInfo.setText(IngresoPanel.this.rdbtnRSC.getText());
                IngresoPanel.this.mostrarSelecci\u00f3n();
            }
        });
        buttonGroup.add(this.rdbtnRSC);
        this.rdbtnRSC.setMargin(new Insets(0, 2, 0, 2));
        this.rdbtnRSC.setOpaque(false);
        GridBagConstraints gbc_rdbtnRSC = new GridBagConstraints();
        gbc_rdbtnRSC.anchor = 17;
        gbc_rdbtnRSC.gridx = 0;
        gbc_rdbtnRSC.gridy = 5;
        this.add((Component)this.rdbtnRSC, gbc_rdbtnRSC);
        this.rdbtnRPH = new JRadioButton();
        this.rdbtnRPH.setVisible(false);
        this.rdbtnRPH.setText(this.env.getString("IngresoPanel.RecoPatr"));
        this.rdbtnRPH.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IngresoPanel.this.lblInfo.setText(IngresoPanel.this.rdbtnRPH.getText());
                IngresoPanel.this.mostrarSelecci\u00f3n();
            }
        });
        buttonGroup.add(this.rdbtnRPH);
        this.rdbtnRPH.setMargin(new Insets(0, 2, 0, 2));
        this.rdbtnRPH.setOpaque(false);
        GridBagConstraints gbc_rdbtnRPH = new GridBagConstraints();
        gbc_rdbtnRPH.anchor = 17;
        gbc_rdbtnRPH.gridx = 0;
        gbc_rdbtnRPH.gridy = 6;
        this.add((Component)this.rdbtnRPH, gbc_rdbtnRPH);
        this.rdbtnIRIP = new JRadioButton();
        this.rdbtnIRIP.setVisible(false);
        this.rdbtnIRIP.setText(this.env.getString("IngresoPanel.IngImp"));
        this.rdbtnIRIP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IngresoPanel.this.mostrarSelecci\u00f3n();
            }
        });
        buttonGroup.add(this.rdbtnIRIP);
        this.rdbtnIRIP.setMargin(new Insets(0, 2, 0, 2));
        this.rdbtnIRIP.setOpaque(false);
        GridBagConstraints gbc_rdbtnIRIP = new GridBagConstraints();
        gbc_rdbtnIRIP.anchor = 17;
        gbc_rdbtnIRIP.gridx = 0;
        gbc_rdbtnIRIP.gridy = 7;
        this.add((Component)this.rdbtnIRIP, gbc_rdbtnIRIP);
        this.rdbtnIRSA = new JRadioButton();
        this.rdbtnIRSA.setVisible(false);
        this.rdbtnIRSA.setText(this.env.getString("IngresoPanel.IngApla"));
        this.rdbtnIRSA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IngresoPanel.this.mostrarSelecci\u00f3n();
            }
        });
        buttonGroup.add(this.rdbtnIRSA);
        this.rdbtnIRSA.setMargin(new Insets(0, 2, 0, 2));
        this.rdbtnIRSA.setOpaque(false);
        GridBagConstraints gbc_rdbtnIRSA = new GridBagConstraints();
        gbc_rdbtnIRSA.anchor = 17;
        gbc_rdbtnIRSA.gridx = 0;
        gbc_rdbtnIRSA.gridy = 8;
        this.add((Component)this.rdbtnIRSA, gbc_rdbtnIRSA);
        this.rdbtnIRSC = new JRadioButton();
        this.rdbtnIRSC.setVisible(false);
        this.rdbtnIRSC.setText(this.env.getString("IngresoPanel.IngComp"));
        this.rdbtnIRSC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IngresoPanel.this.mostrarSelecci\u00f3n();
            }
        });
        buttonGroup.add(this.rdbtnIRSC);
        this.rdbtnIRSC.setMargin(new Insets(0, 2, 0, 2));
        this.rdbtnIRSC.setOpaque(false);
        GridBagConstraints gbc_rdbtnIRSC = new GridBagConstraints();
        gbc_rdbtnIRSC.anchor = 17;
        gbc_rdbtnIRSC.gridx = 0;
        gbc_rdbtnIRSC.gridy = 9;
        this.add((Component)this.rdbtnIRSC, gbc_rdbtnIRSC);
        this.rdbtnIRPH = new JRadioButton();
        this.rdbtnIRPH.setVisible(false);
        this.rdbtnIRPH.setText(this.env.getString("IngresoPanel.IngPatr"));
        this.rdbtnIRPH.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IngresoPanel.this.mostrarSelecci\u00f3n();
            }
        });
        buttonGroup.add(this.rdbtnIRPH);
        this.rdbtnIRPH.setMargin(new Insets(0, 2, 0, 2));
        this.rdbtnIRPH.setOpaque(false);
        GridBagConstraints gbc_rdbtnIRPH = new GridBagConstraints();
        gbc_rdbtnIRPH.anchor = 17;
        gbc_rdbtnIRPH.gridx = 0;
        gbc_rdbtnIRPH.gridy = 10;
        this.add((Component)this.rdbtnIRPH, gbc_rdbtnIRPH);
        LabelTitle lblIngreso = new LabelTitle();
        lblIngreso.setText(this.env.getString("IngresoPanel.Ingreso"));
        GridBagConstraints gbc_lblIngreso = new GridBagConstraints();
        gbc_lblIngreso.insets = new Insets(5, 0, 5, 0);
        gbc_lblIngreso.fill = 2;
        gbc_lblIngreso.gridx = 0;
        gbc_lblIngreso.gridy = 11;
        this.add((Component)lblIngreso, gbc_lblIngreso);
        this.lblInfo = new JLabel();
        this.lblInfo.setText(this.env.getString("IngresoPanel.NoTipoIngr"));
        GridBagConstraints gbc_lblInfo = new GridBagConstraints();
        gbc_lblInfo.insets = new Insets(0, 0, 5, 0);
        gbc_lblInfo.anchor = 17;
        gbc_lblInfo.gridx = 0;
        gbc_lblInfo.gridy = 12;
        this.add((Component)this.lblInfo, gbc_lblInfo);
        this.panelIngreso = new JPanel();
        this.panelIngreso.setVisible(false);
        this.panelIngreso.setOpaque(false);
        GridBagConstraints gbc_panelIngreso = new GridBagConstraints();
        gbc_panelIngreso.fill = 2;
        gbc_panelIngreso.gridx = 0;
        gbc_panelIngreso.gridy = 13;
        this.add((Component)this.panelIngreso, gbc_panelIngreso);
        GridBagLayout gbl_panelIngreso = new GridBagLayout();
        gbl_panelIngreso.columnWidths = new int[3];
        gbl_panelIngreso.rowHeights = new int[2];
        gbl_panelIngreso.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_panelIngreso.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panelIngreso.setLayout(gbl_panelIngreso);
        JPanel panelImportes = new JPanel();
        panelImportes.setOpaque(false);
        GridBagConstraints gbc_panelImportes = new GridBagConstraints();
        gbc_panelImportes.anchor = 11;
        gbc_panelImportes.insets = new Insets(0, 0, 0, 5);
        gbc_panelImportes.fill = 2;
        gbc_panelImportes.gridx = 0;
        gbc_panelImportes.gridy = 0;
        this.panelIngreso.add((Component)panelImportes, gbc_panelImportes);
        GridBagLayout gbl_panelImportes = new GridBagLayout();
        int[] nArray = new int[4];
        nArray[0] = 170;
        gbl_panelImportes.columnWidths = nArray;
        gbl_panelImportes.rowHeights = new int[6];
        gbl_panelImportes.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelImportes.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panelImportes.setLayout(gbl_panelImportes);
        this.lblPlazo = new JLabel();
        this.lblPlazo.setHorizontalAlignment(2);
        this.lblPlazo.setText(this.env.getString("IngresoPanel.Plazo1"));
        this.lblPlazo.setVisible(false);
        GridBagConstraints gbc_lblPlazo = new GridBagConstraints();
        gbc_lblPlazo.gridwidth = 2;
        gbc_lblPlazo.fill = 2;
        gbc_lblPlazo.insets = new Insets(0, 0, 5, 5);
        gbc_lblPlazo.gridx = 0;
        gbc_lblPlazo.gridy = 0;
        panelImportes.add((Component)this.lblPlazo, gbc_lblPlazo);
        LabelRayado lblImporte = new LabelRayado();
        lblImporte.setText(this.env.getString("IngresoPanel.Importe"));
        GridBagConstraints gbc_lblImporte = new GridBagConstraints();
        gbc_lblImporte.fill = 2;
        gbc_lblImporte.insets = new Insets(0, 0, 5, 5);
        gbc_lblImporte.gridx = 0;
        gbc_lblImporte.gridy = 1;
        panelImportes.add((Component)lblImporte, gbc_lblImporte);
        this.textImporte = new JTextField();
        this.textImporte.setRequestFocusEnabled(false);
        this.textImporte.setFocusable(false);
        this.textImporte.setHorizontalAlignment(4);
        this.textImporte.setEditable(false);
        GridBagConstraints gbc_textImporte = new GridBagConstraints();
        gbc_textImporte.anchor = 17;
        gbc_textImporte.insets = new Insets(0, 0, 5, 5);
        gbc_textImporte.gridx = 1;
        gbc_textImporte.gridy = 1;
        panelImportes.add((Component)this.textImporte, gbc_textImporte);
        this.textImporte.setColumns(15);
        this.lblImporteIngresado = new LabelRayado();
        this.lblImporteIngresado.setText(this.env.getString("IngresoPanel.ImpIngre"));
        GridBagConstraints gbc_lblImporteIngresado = new GridBagConstraints();
        gbc_lblImporteIngresado.fill = 2;
        gbc_lblImporteIngresado.insets = new Insets(0, 0, 5, 5);
        gbc_lblImporteIngresado.gridx = 0;
        gbc_lblImporteIngresado.gridy = 2;
        panelImportes.add((Component)this.lblImporteIngresado, gbc_lblImporteIngresado);
        this.textIngresado = new NumericTextField();
        this.textIngresado.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                IngresoPanel.this.importeIngresadoFocuLost();
            }
        });
        this.textIngresado.setHorizontalAlignment(4);
        GridBagConstraints gbc_textIngresado = new GridBagConstraints();
        gbc_textIngresado.anchor = 17;
        gbc_textIngresado.insets = new Insets(0, 0, 5, 5);
        gbc_textIngresado.gridx = 1;
        gbc_textIngresado.gridy = 2;
        panelImportes.add((Component)this.textIngresado, gbc_textIngresado);
        this.textIngresado.setColumns(15);
        LabelRayado lblNrc = new LabelRayado();
        lblNrc.setText("NRC");
        GridBagConstraints gbc_lblNrc = new GridBagConstraints();
        gbc_lblNrc.fill = 2;
        gbc_lblNrc.insets = new Insets(0, 0, 5, 5);
        gbc_lblNrc.gridx = 0;
        gbc_lblNrc.gridy = 3;
        panelImportes.add((Component)lblNrc, gbc_lblNrc);
        this.textNRC = new FixedLengthTextField(22);
        GridBagConstraints gbc_textNRC = new GridBagConstraints();
        gbc_textNRC.insets = new Insets(0, 0, 5, 5);
        gbc_textNRC.fill = 2;
        gbc_textNRC.gridx = 1;
        gbc_textNRC.gridy = 3;
        panelImportes.add((Component)this.textNRC, gbc_textNRC);
        this.textNRC.setColumns(22);
        this.btnLeeNRC = new JButton();
        this.btnLeeNRC.setVisible(false);
        this.btnLeeNRC.setBackground(Enviroment.COLOR_BASE);
        this.btnLeeNRC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IngresoPanel.this.leerNRC();
            }
        });
        this.btnLeeNRC.setText(this.env.getString("IngresoPanel.ButLeeNRC"));
        GridBagConstraints gbc_btnLeeNRC = new GridBagConstraints();
        gbc_btnLeeNRC.insets = new Insets(0, 0, 5, 0);
        gbc_btnLeeNRC.gridx = 2;
        gbc_btnLeeNRC.gridy = 3;
        panelImportes.add((Component)this.btnLeeNRC, gbc_btnLeeNRC);
        this.lblReco = new LabelRayado();
        this.lblReco.setText(this.env.getString("IngresoPanel.ImpReco"));
        GridBagConstraints gbc_lblReco = new GridBagConstraints();
        gbc_lblReco.insets = new Insets(0, 0, 0, 5);
        gbc_lblReco.fill = 2;
        gbc_lblReco.gridx = 0;
        gbc_lblReco.gridy = 4;
        panelImportes.add((Component)this.lblReco, gbc_lblReco);
        this.textReco = new JTextField();
        this.textReco.setRequestFocusEnabled(false);
        this.textReco.setFocusable(false);
        this.textReco.setHorizontalAlignment(4);
        this.textReco.setEditable(false);
        GridBagConstraints gbc_textReco = new GridBagConstraints();
        gbc_textReco.insets = new Insets(0, 0, 0, 5);
        gbc_textReco.anchor = 17;
        gbc_textReco.gridx = 1;
        gbc_textReco.gridy = 4;
        panelImportes.add((Component)this.textReco, gbc_textReco);
        this.textReco.setColumns(15);
        this.panelPago = new JPanel();
        this.panelPago.setOpaque(false);
        this.panelPago.setBorder(new LineBorder(lblTipoDeIngreso.getBackground()));
        GridBagConstraints gbc_panelPago = new GridBagConstraints();
        gbc_panelPago.anchor = 14;
        gbc_panelPago.gridx = 1;
        gbc_panelPago.gridy = 0;
        this.panelIngreso.add((Component)this.panelPago, gbc_panelPago);
        GridBagLayout gbl_panelPago = new GridBagLayout();
        gbl_panelPago.columnWidths = new int[5];
        gbl_panelPago.rowHeights = new int[3];
        gbl_panelPago.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelPago.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.panelPago.setLayout(gbl_panelPago);
        LabelTitle lblPagoDeImpuestos = new LabelTitle();
        lblPagoDeImpuestos.setText(this.env.getString("IngresoPanel.PagoImp"));
        GridBagConstraints gbc_lblPagoDeImpuestos = new GridBagConstraints();
        gbc_lblPagoDeImpuestos.fill = 2;
        gbc_lblPagoDeImpuestos.gridwidth = 4;
        gbc_lblPagoDeImpuestos.insets = new Insets(0, 0, 5, 0);
        gbc_lblPagoDeImpuestos.gridx = 0;
        gbc_lblPagoDeImpuestos.gridy = 0;
        this.panelPago.add((Component)lblPagoDeImpuestos, gbc_lblPagoDeImpuestos);
        ButtonGroup buttonGroup_1 = new ButtonGroup();
        this.rdbtnCargoCuenta = new JRadioButton();
        this.rdbtnCargoCuenta.setText(this.env.getString("IngresoPanel.CargoCue"));
        this.rdbtnCargoCuenta.setOpaque(false);
        buttonGroup_1.add(this.rdbtnCargoCuenta);
        GridBagConstraints gbc_rdbtnCargoCuenta = new GridBagConstraints();
        gbc_rdbtnCargoCuenta.anchor = 17;
        gbc_rdbtnCargoCuenta.insets = new Insets(0, 5, 0, 5);
        gbc_rdbtnCargoCuenta.gridx = 0;
        gbc_rdbtnCargoCuenta.gridy = 1;
        this.panelPago.add((Component)this.rdbtnCargoCuenta, gbc_rdbtnCargoCuenta);
        this.rdbtnTarjeta = new JRadioButton();
        this.rdbtnTarjeta.setText(this.env.getString("IngresoPanel.PagoTar"));
        this.rdbtnTarjeta.setOpaque(false);
        buttonGroup_1.add(this.rdbtnTarjeta);
        GridBagConstraints gbc_rdbtnTarjeta = new GridBagConstraints();
        gbc_rdbtnTarjeta.anchor = 17;
        gbc_rdbtnTarjeta.insets = new Insets(0, 0, 0, 5);
        gbc_rdbtnTarjeta.gridx = 1;
        gbc_rdbtnTarjeta.gridy = 1;
        this.panelPago.add((Component)this.rdbtnTarjeta, gbc_rdbtnTarjeta);
        String urlDist = "";
        try {
            urlDist = this.env.getURLDistribuidor();
        }
        catch (Exception e) {
            urlDist = e.getMessage();
        }
        String msg = this.env.getString("Ayuda.Pago");
        msg = msg.replaceAll("&amp;URL;", urlDist);
        this.btnHelp = new HelpButton(this.owner, msg, this.env.getString("Ayuda.TipPI"), false);
        GridBagConstraints gbc_btnHelp = new GridBagConstraints();
        gbc_btnHelp.insets = new Insets(0, 0, 5, 5);
        gbc_btnHelp.gridx = 2;
        gbc_btnHelp.gridy = 1;
        this.panelPago.add((Component)this.btnHelp, gbc_btnHelp);
        this.btnObtenerNrc = new JButton();
        this.btnObtenerNrc.setBackground(Enviroment.COLOR_BASE);
        this.btnObtenerNrc.setText(this.env.getString("IngresoPanel.ButNRC"));
        this.btnObtenerNrc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IngresoPanel.this.obtenerNRC();
            }
        });
        GridBagConstraints gbc_btnObtenerNrc = new GridBagConstraints();
        gbc_btnObtenerNrc.insets = new Insets(0, 0, 5, 5);
        gbc_btnObtenerNrc.gridx = 3;
        gbc_btnObtenerNrc.gridy = 1;
        this.panelPago.add((Component)this.btnObtenerNrc, gbc_btnObtenerNrc);
        this.tpw = new JTextPane();
        this.tpw.setContentType("text/html");
        ((HTMLDocument)this.tpw.getDocument()).getStyleSheet().addRule("body{font-family: " + this.tpw.getFont().getFamily() + "; font-size: " + this.tpw.getFont().getSize() + ";}");
        this.tpw.setOpaque(false);
        this.tpw.setEditable(false);
    }

    private void leerNRC() {
    }

    private void obtenerNRC() {
        if (!this.rdbtnCargoCuenta.isSelected() && !this.rdbtnTarjeta.isSelected()) {
            WarningDialog.showMessageDialog(this.owner, this.env.getString("IngresoPanel.ErrSelPago"), this.env.getString("ContriPanel.ErrTitle"));
        } else {
            int formaPago = this.rdbtnCargoCuenta.isSelected() ? 0 : 1;
            String params = "mod=" + this.decla.getModelo();
            params = String.valueOf(params) + "&sol=" + this.decla.getModelo();
            params = String.valueOf(params) + "&mov=01";
            params = String.valueOf(params) + "&ejf=2014";
            params = String.valueOf(params) + "&per=0A";
            params = String.valueOf(params) + "&div=E";
            params = String.valueOf(params) + "&nif=" + this.decla.getNifDeclarante();
            params = String.valueOf(params) + "&let=" + this.decla.getAnagrama();
            if (this.isIngresoParcial()) {
                if (!this.checkImporteIngresado()) {
                    return;
                }
                params = String.valueOf(params) + "&fra=1";
                if (this.decla.getImporteResultado() != 0.0) {
                    params = String.valueOf(params) + "&itd=" + this.formateaPago(this.textIngresado.getText());
                }
                params = String.valueOf(params) + "&imp=" + this.formateaPago(this.textIngresado.getText());
            } else {
                String ccc;
                params = String.valueOf(params) + "&fra=" + (this.decla.isFracciona() ? "2" : "1");
                params = String.valueOf(params) + "&imp=" + this.formateaPago(this.textImporte.getText());
                if (this.decla.getImporteResultado() != 0.0) {
                    params = String.valueOf(params) + "&itd=" + this.formateaPago(Util.formatNumericData("" + this.decla.getImporteResultado(), 2));
                }
                if ((ccc = this.decla.getCCC()) != null && ccc.trim().length() >= 20) {
                    params = String.valueOf(params) + "&ccc=" + ccc.trim();
                }
            }
            params = String.valueOf(params) + "&men=s";
            try {
                String url = this.env.getURLPago(this.authMethod, formaPago);
                url = String.valueOf(url) + Enviroment.urlEncode(params);
                Util.showLinkInBrowser(null, url);
            }
            catch (Exception e) {
                this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "obtenerNRC", "No se pudo abrir el navegador", e);
            }
        }
    }

    private void importeIngresadoFocuLost() {
        this.textIngresado.setText(Util.formatNumericData(this.textIngresado.getText().replace(',', '.'), 2));
        if (this.textIngresado.getText().length() <= 0) {
            this.textReco.setText("");
            return;
        }
        double ingresado = Double.parseDouble(this.textIngresado.getText().replace(',', '.'));
        double deuda = Double.parseDouble(this.textImporte.getText().replace(',', '.'));
        if (ingresado == 0.0) {
            WarningDialog.showMessageDialog(this.owner, this.env.getString("IngresoPanel.ErrIng0"), this.env.getString("ContriPanel.ErrTitle"));
            this.textIngresado.setText("");
            this.textReco.setText("");
        } else if (ingresado >= deuda) {
            WarningDialog.showMessageDialog(this.owner, this.env.getString("IngresoPanel.ErrIng"), this.env.getString("ContriPanel.ErrTitle"));
            this.textIngresado.setText("");
            this.textReco.setText("");
        } else {
            this.textReco.setText(Util.formatNumericData("" + (deuda - ingresado), 2));
        }
    }

    public boolean checkData() {
        if (this.isVisible()) {
            if (!(this.rdbtnAdeudo.isVisible() && (!this.rdbtnAdeudo.isVisible() || this.rdbtnAdeudo.isSelected()) || this.rdbtnEfectivo.isVisible() && (!this.rdbtnEfectivo.isVisible() || this.rdbtnEfectivo.isSelected()) || this.rdbtnIRIP.isVisible() && (!this.rdbtnIRIP.isVisible() || this.rdbtnIRIP.isSelected()) || this.rdbtnIRPH.isVisible() && (!this.rdbtnIRPH.isVisible() || this.rdbtnIRPH.isSelected()) || this.rdbtnIRSA.isVisible() && (!this.rdbtnIRSA.isVisible() || this.rdbtnIRSA.isSelected()) || this.rdbtnIRSC.isVisible() && (!this.rdbtnIRSC.isVisible() || this.rdbtnIRSC.isSelected()) || this.rdbtnRIP.isVisible() && (!this.rdbtnRIP.isVisible() || this.rdbtnRIP.isSelected()) || this.rdbtnRPH.isVisible() && (!this.rdbtnRPH.isVisible() || this.rdbtnRPH.isSelected()) || this.rdbtnRSA.isVisible() && (!this.rdbtnRSA.isVisible() || this.rdbtnRSA.isSelected()) || this.rdbtnRSC.isVisible() && (!this.rdbtnRSC.isVisible() || this.rdbtnRSC.isSelected()))) {
                WarningDialog.showMessageDialog(this.owner, this.env.getString("IngresoPanel.ErrNoSelec"), this.env.getString("ContriPanel.ErrTitle"));
                return false;
            }
            if (this.panelIngreso.isVisible()) {
                if (this.textIngresado.isVisible() && !this.checkImporteIngresado()) {
                    return false;
                }
                if (this.textNRC.isVisible()) {
                    String nrc = this.textNRC.getText().trim();
                    if (nrc.length() <= 0) {
                        if (this.panelPago.isVisible()) {
                            this.tpw.setText(this.env.getString("IngresoPanel.ErrVoidNRC"));
                        } else {
                            this.tpw.setText(this.env.getString("IngresoPanel.ErrVoidNRC_Ref"));
                        }
                        WarningDialog.showMessageDialog(this.owner, this.tpw, this.env.getString("ContriPanel.ErrTitle"));
                        return false;
                    }
                    if (nrc.length() < 22 || !nrc.startsWith("" + this.decla.getModelo())) {
                        WarningDialog.showMessageDialog(this.owner, this.env.getString("IngresoPanel.ErrNRC"), this.env.getString("ContriPanel.ErrTitle"));
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean checkImporteIngresado() {
        if (this.textIngresado.getText().length() <= 0) {
            WarningDialog.showMessageDialog(this.owner, this.env.getString("IngresoPanel.ErrIng1"), this.env.getString("ContriPanel.ErrTitle"));
            return false;
        }
        Double valueIng = 0.0;
        try {
            valueIng = Double.parseDouble(this.textIngresado.getText().trim().replace(',', '.'));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (valueIng <= 0.0) {
            WarningDialog.showMessageDialog(this.owner, this.env.getString("IngresoPanel.ErrIng0"), this.env.getString("ContriPanel.ErrTitle"));
            return false;
        }
        return true;
    }

    public void setOwner(PTDialog diag) {
        this.owner = diag;
    }

    public void setDeclaracion(Declaracion decla) {
        this.decla = decla;
        if (decla.getImporteNRC() > 0.0) {
            DecimalFormat df = new DecimalFormat("0.00");
            this.textImporte.setText(df.format(decla.getImporteNRC()));
            this.setVisible(true);
            if (decla.getFormaPago() == 1) {
                this.rdbtnEfectivo.setVisible(true);
                this.rdbtnEfectivo.setSelected(true);
            } else if (decla.getFormaPago() == 2) {
                this.rdbtnAdeudo.setVisible(true);
                this.rdbtnAdeudo.setSelected(true);
                this.rdbtnCargoCuenta.setSelected(true);
            }
            if (decla.isNoFracciona() && this.tipoPadre != 3) {
                this.rdbtnIRIP.setVisible(true);
                this.rdbtnIRPH.setVisible(true);
                this.rdbtnIRSA.setVisible(true);
                this.rdbtnIRSC.setVisible(true);
                this.rdbtnRIP.setVisible(true);
                this.rdbtnRPH.setVisible(true);
                this.rdbtnRSA.setVisible(true);
                this.rdbtnRSC.setVisible(true);
            }
            if (decla.isFracciona() && this.tipoPadre != 3) {
                this.lblPlazo.setVisible(true);
            }
        }
        this.mostrarSelecci\u00f3n();
    }

    private void mostrarSelecci\u00f3n() {
        if (this.rdbtnRIP.isSelected() || this.rdbtnRPH.isSelected() || this.rdbtnRSA.isSelected() || this.rdbtnRSC.isSelected()) {
            this.lblInfo.setVisible(true);
            this.panelIngreso.setVisible(false);
        } else {
            if (this.rdbtnAdeudo.isSelected() || this.rdbtnEfectivo.isSelected()) {
                this.lblImporteIngresado.setVisible(false);
                this.textIngresado.setVisible(false);
                this.lblReco.setVisible(false);
                this.textReco.setVisible(false);
            } else {
                this.lblImporteIngresado.setVisible(true);
                this.textIngresado.setVisible(true);
                this.lblReco.setVisible(true);
                this.textReco.setVisible(true);
            }
            this.lblInfo.setVisible(false);
            this.panelIngreso.setVisible(true);
        }
        if (this.owner != null) {
            this.owner.validate();
        }
        if (this.owner != null) {
            this.owner.pack();
        }
    }

    public boolean isIngresoParcial() {
        return this.rdbtnIRIP.isSelected() || this.rdbtnIRPH.isSelected() || this.rdbtnIRSA.isSelected() || this.rdbtnIRSC.isSelected();
    }

    private String formateaPago(String texto) {
        String pago = "";
        try {
            Double valueIng = Double.parseDouble(texto.trim().replace(',', '.'));
            DecimalFormat df = new DecimalFormat("###,###,###,###,##0.00");
            return df.format(valueIng);
        }
        catch (NumberFormatException numberFormatException) {
            return pago;
        }
    }

    public String getTIA() {
        String TIA = null;
        if (this.isVisible()) {
            if (this.rdbtnRIP.isVisible() && this.rdbtnRIP.isSelected()) {
                TIA = "M";
            }
            if (this.rdbtnRSA.isVisible() && this.rdbtnRSA.isSelected()) {
                TIA = "A";
            }
            if (this.rdbtnRSC.isVisible() && this.rdbtnRSC.isSelected()) {
                TIA = "P";
            }
            if (this.rdbtnRPH.isVisible() && this.rdbtnRPH.isSelected()) {
                TIA = "H";
            }
            if (this.rdbtnIRIP.isVisible() && this.rdbtnIRIP.isSelected()) {
                TIA = "F";
            }
            if (this.rdbtnIRSA.isVisible() && this.rdbtnIRSA.isSelected()) {
                TIA = "E";
            }
            if (this.rdbtnIRSC.isVisible() && this.rdbtnIRSC.isSelected()) {
                TIA = "Z";
            }
            if (this.rdbtnIRPH.isVisible() && this.rdbtnIRPH.isSelected()) {
                TIA = "J";
            }
        }
        return TIA;
    }

    public String getING() {
        if (this.isVisible() && this.isIngresoYReco()) {
            return this.textIngresado.getText().trim().replaceAll(",", "");
        }
        return "";
    }

    public String getICO() {
        if (this.isIngresoYReco()) {
            return this.textReco.getText().trim().replaceAll(",", "");
        }
        if (this.rdbtnRIP.isVisible() && this.rdbtnRIP.isSelected() || this.rdbtnRSA.isVisible() && this.rdbtnRSA.isSelected() || this.rdbtnRSC.isVisible() && this.rdbtnRSC.isSelected() || this.rdbtnRPH.isVisible() && this.rdbtnRPH.isSelected()) {
            DecimalFormat df = new DecimalFormat("0.00");
            String value = df.format(this.decla.getImporteNRC());
            return value.replaceAll(",", "");
        }
        return "";
    }

    public String getNRC() {
        if (this.isVisible() && (this.isIngresoYReco() || this.rdbtnAdeudo.isVisible() && this.rdbtnAdeudo.isSelected() || this.rdbtnEfectivo.isVisible() && this.rdbtnEfectivo.isSelected())) {
            return this.textNRC.getText().trim();
        }
        return "";
    }

    private boolean isIngresoYReco() {
        return this.rdbtnIRIP.isVisible() && this.rdbtnIRIP.isSelected() || this.rdbtnIRSA.isVisible() && this.rdbtnIRSA.isSelected() || this.rdbtnIRSC.isVisible() && this.rdbtnIRSC.isSelected() || this.rdbtnIRPH.isVisible() && this.rdbtnIRPH.isSelected();
    }

    @Override
    public void authMethodChanged(int authMethod) {
        this.authMethod = authMethod;
        this.panelPago.setVisible(this.authMethod != 2 && this.tipoPadre != 3);
        if (this.authMethod == 1) {
            this.rdbtnTarjeta.setVisible(false);
            this.rdbtnCargoCuenta.setSelected(true);
        } else {
            this.rdbtnTarjeta.setVisible(true);
        }
        if (this.owner != null) {
            this.owner.validate();
            this.owner.pack();
        }
    }
}

