/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.gui.pt;

import es.gob.aeat.dit.ov.renta.Enviroment;
import es.gob.aeat.dit.ov.renta.gui.HelpDialog;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class HelpButton
extends JButton {
    private String message = null;
    private Dialog owner = null;

    public HelpButton() {
        this(true);
    }

    public HelpButton(boolean hasTitle) {
        this.setContentAreaFilled(false);
        this.setBackground(Enviroment.COLOR_BASE);
        if (hasTitle) {
            this.setText(Enviroment.getInstance().getString("Ayuda.Tip"));
        }
        this.setToolTipText(Enviroment.getInstance().getString("Ayuda.Tip"));
        this.setMargin(new Insets(2, 2, 2, 2));
        this.setIcon(new ImageIcon(HelpButton.class.getResource("/es/gob/aeat/dit/ov/renta/resources/ayuda.png")));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent arg0) {
                HelpButton.this.setContentAreaFilled(false);
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                HelpButton.this.setContentAreaFilled(true);
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
                HelpButton.this.showHelpDialog();
            }
        });
    }

    public HelpButton(Dialog owner, String message, String tip, boolean hasTitle) {
        this(hasTitle);
        this.message = message;
        this.setToolTipText(tip);
    }

    public void showHelpDialog() {
        HelpDialog hd = new HelpDialog(this.owner);
        hd.showDialog(this.message);
    }
}

