/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.gui.pt;

import es.gob.aeat.dit.ov.renta.Enviroment;
import es.gob.aeat.dit.ov.renta.gui.RentaDialog;
import es.gob.aeat.dit.ov.renta.gui.WarningDialog;
import es.gob.aeat.dit.ov.renta.gui.pt.AvisoDialog;
import es.gob.aeat.dit.ov.renta.pt.Declaracion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.UnsupportedEncodingException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class FirmaBasicaDialog
extends RentaDialog {
    private static final long serialVersionUID = 1L;
    public static final int SHOW_INFO_LENGTH = 2000;
    public static final int CANCELADO = 0;
    public static final int CONTINUAR = 1;
    private int resultado;
    private JCheckBox chckbxConforme;
    private Declaracion declaracion;
    private String certNif;
    private String certNom;

    public FirmaBasicaDialog(String certNif, String certNom, Declaracion decla) {
        this.declaracion = decla;
        this.certNif = certNif;
        this.certNom = certNom;
        this.init();
    }

    public FirmaBasicaDialog(Frame frm, String certNif, String certNom, Declaracion decla) {
        super(frm);
        this.declaracion = decla;
        this.certNif = certNif;
        this.certNom = certNom;
        this.init();
    }

    public FirmaBasicaDialog(Window win, String certNif, String certNom, Declaracion decla) {
        super(win);
        this.declaracion = decla;
        this.certNif = certNif;
        this.certNom = certNom;
        this.init();
    }

    public FirmaBasicaDialog(Dialog diag, String certNif, String certNom, Declaracion decla) {
        super(diag);
        this.declaracion = decla;
        this.certNif = certNif;
        this.certNom = certNom;
        this.init();
    }

    private void init() {
        Enviroment env = Enviroment.getInstance();
        this.resultado = 0;
        this.setModal(true);
        this.setBackground(Enviroment.COLOR_BASE);
        this.setTitle(String.valueOf(env.getString("FirmaBasicaDialog.Title")) + " " + this.declaracion.getModelo());
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                FirmaBasicaDialog.this.resultado = 0;
            }
        });
        this.setBounds(100, 100, 450, 300);
        this.getContentPane().setBackground(Enviroment.COLOR_BASE);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[4];
        gridBagLayout.rowHeights = new int[7];
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(gridBagLayout);
        JLabel lblConfirmacinPresentacinModelo = new JLabel(String.valueOf(env.getString("FirmaBasicaDialog.Info")) + " " + this.declaracion.getModelo());
        lblConfirmacinPresentacinModelo.setForeground(SystemColor.textHighlight);
        lblConfirmacinPresentacinModelo.setFont(new Font("Tahoma", 1, 14));
        GridBagConstraints gbc_lblConfirmacinPresentacinModelo = new GridBagConstraints();
        gbc_lblConfirmacinPresentacinModelo.gridwidth = 3;
        gbc_lblConfirmacinPresentacinModelo.insets = new Insets(10, 0, 5, 0);
        gbc_lblConfirmacinPresentacinModelo.gridx = 0;
        gbc_lblConfirmacinPresentacinModelo.gridy = 0;
        this.getContentPane().add((Component)lblConfirmacinPresentacinModelo, gbc_lblConfirmacinPresentacinModelo);
        String certNomAux = null;
        try {
            certNomAux = new String(this.certNom.getBytes("iso-8859-15"), "iso-8859-1");
        }
        catch (UnsupportedEncodingException e1) {
            certNomAux = this.certNom;
        }
        JLabel lblkCertificadoUno = new JLabel(String.valueOf(this.certNif) + " " + certNomAux);
        lblkCertificadoUno.setIcon(new ImageIcon(FirmaBasicaDialog.class.getResource("/es/gob/aeat/dit/ov/renta/resources/cert.png")));
        lblkCertificadoUno.setFont(new Font("Tahoma", 1, 12));
        GridBagConstraints gbc_lblkCertificadoUno = new GridBagConstraints();
        gbc_lblkCertificadoUno.gridwidth = 3;
        gbc_lblkCertificadoUno.fill = 2;
        gbc_lblkCertificadoUno.insets = new Insets(15, 10, 5, 0);
        gbc_lblkCertificadoUno.gridx = 0;
        gbc_lblkCertificadoUno.gridy = 1;
        this.getContentPane().add((Component)lblkCertificadoUno, gbc_lblkCertificadoUno);
        JLabel lblEnNombreDe = new JLabel(env.getString("FirmaBasicaDialog.EnNombre"));
        GridBagConstraints gbc_lblEnNombreDe = new GridBagConstraints();
        gbc_lblEnNombreDe.fill = 3;
        gbc_lblEnNombreDe.anchor = 17;
        gbc_lblEnNombreDe.insets = new Insets(0, 10, 5, 5);
        gbc_lblEnNombreDe.gridx = 0;
        gbc_lblEnNombreDe.gridy = 2;
        this.getContentPane().add((Component)lblEnNombreDe, gbc_lblEnNombreDe);
        JLabel lblrDeclarante = new JLabel(String.valueOf(this.declaracion.getNifDeclarante()) + " " + this.declaracion.getApeNomDeclarante().trim());
        lblrDeclarante.setFont(new Font("Tahoma", 1, 12));
        GridBagConstraints gbc_lblrDeclarante = new GridBagConstraints();
        gbc_lblrDeclarante.gridwidth = 2;
        gbc_lblrDeclarante.fill = 1;
        gbc_lblrDeclarante.insets = new Insets(0, 0, 5, 0);
        gbc_lblrDeclarante.gridx = 1;
        gbc_lblrDeclarante.gridy = 2;
        this.getContentPane().add((Component)lblrDeclarante, gbc_lblrDeclarante);
        if (this.declaracion.isConjunta()) {
            JLabel lblEnNombreDe2 = new JLabel(env.getString("FirmaBasicaDialog.EnNombre"));
            gbc_lblEnNombreDe = new GridBagConstraints();
            gbc_lblEnNombreDe.anchor = 17;
            gbc_lblEnNombreDe.insets = new Insets(0, 10, 5, 5);
            gbc_lblEnNombreDe.gridx = 0;
            gbc_lblEnNombreDe.gridy = 3;
            this.getContentPane().add((Component)lblEnNombreDe2, gbc_lblEnNombreDe);
            JLabel lblrConyuge = new JLabel(String.valueOf(this.declaracion.getNifConyuge()) + " " + this.declaracion.getApeNomConyuge().trim());
            lblrConyuge.setFont(new Font("Tahoma", 1, 12));
            GridBagConstraints gbc_lblrConyuge = new GridBagConstraints();
            gbc_lblrConyuge.gridwidth = 2;
            gbc_lblrConyuge.fill = 2;
            gbc_lblrConyuge.insets = new Insets(0, 0, 5, 0);
            gbc_lblrConyuge.gridx = 1;
            gbc_lblrConyuge.gridy = 3;
            this.getContentPane().add((Component)lblrConyuge, gbc_lblrConyuge);
        }
        JPanel panelBotonera = new JPanel();
        panelBotonera.setOpaque(false);
        GridBagConstraints gbc_panelBotonera = new GridBagConstraints();
        gbc_panelBotonera.insets = new Insets(0, 0, 5, 0);
        gbc_panelBotonera.gridwidth = 3;
        gbc_panelBotonera.fill = 1;
        gbc_panelBotonera.gridx = 0;
        gbc_panelBotonera.gridy = 4;
        this.getContentPane().add((Component)panelBotonera, gbc_panelBotonera);
        GridBagLayout gbl_panelBotonera = new GridBagLayout();
        gbl_panelBotonera.columnWidths = new int[3];
        gbl_panelBotonera.rowHeights = new int[3];
        gbl_panelBotonera.columnWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        gbl_panelBotonera.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panelBotonera.setLayout(gbl_panelBotonera);
        JButton btnCancel = new JButton();
        btnCancel.setMnemonic('a');
        btnCancel.setText(env.getString("AvisoDialog.Cancela"));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FirmaBasicaDialog.this.resultado = 0;
                FirmaBasicaDialog.this.setVisible(false);
            }
        });
        this.chckbxConforme = new JCheckBox(env.getString("FirmaBasicaDialog.Conforme"));
        this.chckbxConforme.setMargin(new Insets(2, 0, 2, 2));
        GridBagConstraints gbc_chckbxConforme = new GridBagConstraints();
        gbc_chckbxConforme.gridwidth = 2;
        gbc_chckbxConforme.insets = new Insets(10, 10, 0, 0);
        gbc_chckbxConforme.anchor = 17;
        gbc_chckbxConforme.gridx = 0;
        gbc_chckbxConforme.gridy = 0;
        panelBotonera.add((Component)this.chckbxConforme, gbc_chckbxConforme);
        this.chckbxConforme.setMnemonic('C');
        this.chckbxConforme.setOpaque(false);
        btnCancel.setIcon(new ImageIcon(AvisoDialog.class.getResource("/es/gob/aeat/dit/ov/renta/resources/cancel.png")));
        btnCancel.setBackground(Enviroment.COLOR_BASE);
        GridBagConstraints gbc_btnCancel = new GridBagConstraints();
        gbc_btnCancel.anchor = 17;
        gbc_btnCancel.fill = 3;
        gbc_btnCancel.insets = new Insets(0, 0, 0, 10);
        gbc_btnCancel.gridx = 1;
        gbc_btnCancel.gridy = 1;
        panelBotonera.add((Component)btnCancel, gbc_btnCancel);
        JButton btnContinue = new JButton();
        btnContinue.setMnemonic('F');
        btnContinue.setBackground(Enviroment.COLOR_BASE);
        btnContinue.setText(env.getString("FirmaBasicaDialog.Firma"));
        btnContinue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FirmaBasicaDialog.this.continuar();
            }
        });
        btnContinue.setIcon(new ImageIcon(FirmaBasicaDialog.class.getResource("/es/gob/aeat/dit/ov/renta/resources/apply.png")));
        GridBagConstraints gbc_btnContinue = new GridBagConstraints();
        gbc_btnContinue.insets = new Insets(0, 10, 0, 0);
        gbc_btnContinue.anchor = 17;
        gbc_btnContinue.gridx = 0;
        gbc_btnContinue.gridy = 1;
        panelBotonera.add((Component)btnContinue, gbc_btnContinue);
        this.setFocusComponent(btnCancel);
        JLabel lblSiDeseaVer = new JLabel(env.getString("FirmaBasicaDialog.verInfo"));
        GridBagConstraints gbc_lblSiDeseaVer = new GridBagConstraints();
        gbc_lblSiDeseaVer.gridwidth = 2;
        gbc_lblSiDeseaVer.anchor = 17;
        gbc_lblSiDeseaVer.insets = new Insets(15, 10, 10, 5);
        gbc_lblSiDeseaVer.gridx = 0;
        gbc_lblSiDeseaVer.gridy = 5;
        this.getContentPane().add((Component)lblSiDeseaVer, gbc_lblSiDeseaVer);
        JButton btnVerInformacin = new JButton(env.getString("FirmaBasicaDialog.verInfoBut"));
        btnVerInformacin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FirmaBasicaDialog.this.showEnvio();
            }
        });
        btnVerInformacin.setMargin(new Insets(1, 5, 1, 5));
        btnVerInformacin.setMnemonic('V');
        btnVerInformacin.setOpaque(false);
        GridBagConstraints gbc_btnVerInformacin = new GridBagConstraints();
        gbc_btnVerInformacin.insets = new Insets(15, 0, 10, 0);
        gbc_btnVerInformacin.anchor = 17;
        gbc_btnVerInformacin.gridx = 2;
        gbc_btnVerInformacin.gridy = 5;
        this.getContentPane().add((Component)btnVerInformacin, gbc_btnVerInformacin);
    }

    private void showEnvio() {
        Enviroment env = Enviroment.getInstance();
        String fich = this.declaracion.getDeclaracion();
        if (fich.length() > 2000) {
            fich = String.valueOf(fich.substring(0, 2000)) + "...";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("HID=" + this.declaracion.getHID(env.isIntranet()) + "&\n");
        sb.append("FIRNIF=" + this.certNif + "&\n");
        sb.append("FIRNOMBRE=" + this.certNom + "&\n");
        sb.append("CMN=&\n");
        sb.append("LOT=0&\n");
        sb.append("IDI=" + env.getIdioma().toUpperCase() + "&\n");
        sb.append("LEV=000000000000&\n");
        sb.append("F01=" + fich + "&\n");
        sb.append("PUN=00000000&\n");
        sb.append("RFD=" + (this.declaracion.getNumRefD() == null ? "" : this.declaracion.getNumRefD()) + "&\n");
        if (this.declaracion.getModelo() == 100) {
            sb.append("RFC=" + (this.declaracion.getNumRefC() == null ? "" : this.declaracion.getNumRefC()) + "&\n");
        }
        sb.append("TXT=&\n");
        sb.append("FD1=FirmaBasica&\n");
        if (this.declaracion.getModelo() == 100) {
            sb.append("FD2=FirmaBasica&\n");
        }
        sb.append("NRC=" + this.declaracion.getNRC() + "&\n");
        sb.append("TIA=" + this.declaracion.getTIA() + "&\n");
        sb.append("ING=" + this.declaracion.getING() + "&\n");
        sb.append("ICO=" + this.declaracion.getICO() + "&\n");
        sb.append("ENT=GRABA&\n");
        sb.append("FIN=&\n");
        JTextPane texto = new JTextPane();
        texto.setEditable(false);
        texto.setText(sb.toString());
        texto.setCaretPosition(0);
        JScrollPane scroll = new JScrollPane(texto);
        scroll.setPreferredSize(new Dimension(600, 400));
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BorderLayout(5, 5));
        panel.add((Component)scroll, "Center");
        panel.add((Component)new JLabel(String.valueOf(env.getString("FirmaBasicaDialog.infoSend")) + ":"), "North");
        WarningDialog.showMessageDialog(this, panel, String.valueOf(env.getString("FirmaBasicaDialog.infoModelo")) + " " + this.declaracion.getModelo(), 1);
    }

    public int getResultado() {
        return this.resultado;
    }

    private void continuar() {
        if (this.chckbxConforme.isSelected()) {
            this.resultado = 1;
            this.setVisible(false);
        } else {
            WarningDialog.showMessageDialog(this, Enviroment.getInstance().getString("FirmaBasicaDialog.warn"), Enviroment.getInstance().getString("ContriPanel.ErrTitle"));
        }
    }
}

