/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.gui;

import es.gob.aeat.dit.ov.renta.Enviroment;
import es.gob.aeat.dit.ov.renta.gui.RentaDialog;
import es.gob.aeat.dit.ov.renta.util.Util;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class WarningDialog
extends RentaDialog {
    private static final long serialVersionUID = 1L;
    public static final int ICON_WARNING = 0;
    public static final int ICON_INFO = 1;
    private final JPanel contentPanel = new JPanel();
    private JLabel lblIcon;
    private JButton btnAceptar;
    private JTextPane lblInfo;
    private ImageIcon warnIcon;
    private ImageIcon infoIcon;

    public WarningDialog() {
        this.initDialog();
    }

    public WarningDialog(Dialog owner) {
        super(owner);
        this.initDialog();
    }

    public WarningDialog(Frame owner) {
        super(owner);
        this.initDialog();
    }

    public WarningDialog(Window owner) {
        super(owner);
        this.initDialog();
    }

    private void initDialog() {
        this.warnIcon = new ImageIcon(WarningDialog.class.getResource("/es/gob/aeat/dit/ov/renta/resources/warning.png"));
        this.infoIcon = new ImageIcon(WarningDialog.class.getResource("/es/gob/aeat/dit/ov/renta/resources/info.png"));
        this.getContentPane().setBackground(Enviroment.COLOR_BASE);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setModal(true);
        this.setTitle(Enviroment.getInstance().getString("ContriPanel.ErrTitle"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[2];
        gridBagLayout.rowHeights = new int[3];
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(gridBagLayout);
        this.contentPanel.setOpaque(false);
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagConstraints gbc_contentPanel = new GridBagConstraints();
        gbc_contentPanel.insets = new Insets(15, 15, 15, 15);
        gbc_contentPanel.fill = 1;
        gbc_contentPanel.gridx = 0;
        gbc_contentPanel.gridy = 0;
        this.getContentPane().add((Component)this.contentPanel, gbc_contentPanel);
        GridBagLayout gbl_contentPanel = new GridBagLayout();
        gbl_contentPanel.columnWidths = new int[3];
        gbl_contentPanel.rowHeights = new int[2];
        gbl_contentPanel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_contentPanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.contentPanel.setLayout(gbl_contentPanel);
        this.lblIcon = new JLabel();
        this.lblIcon.setIcon(this.warnIcon);
        GridBagConstraints gbc_lblIcon = new GridBagConstraints();
        gbc_lblIcon.anchor = 11;
        gbc_lblIcon.insets = new Insets(0, 0, 0, 15);
        gbc_lblIcon.gridx = 0;
        gbc_lblIcon.gridy = 0;
        this.contentPanel.add((Component)this.lblIcon, gbc_lblIcon);
        this.lblInfo = new JTextPane();
        this.lblInfo.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && e.getURL() != null) {
                    WarningDialog.this.showURL(e.getURL().toString());
                }
            }
        });
        this.lblInfo.setOpaque(false);
        this.lblInfo.setEditable(false);
        this.lblInfo.setContentType("text/html");
        ((HTMLDocument)this.lblInfo.getDocument()).getStyleSheet().addRule("body{font-family: " + this.lblIcon.getFont().getFamily() + "; font-size: " + this.lblIcon.getFont().getSize() + ";}");
        GridBagConstraints gbc_lblInfo = new GridBagConstraints();
        gbc_lblInfo.gridx = 1;
        gbc_lblInfo.gridy = 0;
        this.contentPanel.add((Component)this.lblInfo, gbc_lblInfo);
        this.btnAceptar = new JButton(Enviroment.getInstance().getString("PTErrorDialog.Aceptar"));
        this.btnAceptar.setMnemonic('A');
        this.btnAceptar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WarningDialog.this.dispose();
            }
        });
        this.btnAceptar.setIcon(new ImageIcon(WarningDialog.class.getResource("/es/gob/aeat/dit/ov/renta/resources/apply.png")));
        GridBagConstraints gbc_btnAceptar = new GridBagConstraints();
        gbc_btnAceptar.insets = new Insets(0, 0, 15, 0);
        gbc_btnAceptar.gridx = 0;
        gbc_btnAceptar.gridy = 1;
        this.getContentPane().add((Component)this.btnAceptar, gbc_btnAceptar);
    }

    private static Dialog getParentDialog(Component owner) {
        if (owner == null) {
            return null;
        }
        if (owner instanceof Dialog) {
            return (Dialog)owner;
        }
        return WarningDialog.getParentDialog(owner.getParent());
    }

    public void showDialog(Object message) {
        this.showDialog(message, 0);
    }

    public void showDialog(Object message, int icon) {
        if (message != null) {
            if (message instanceof String) {
                this.lblInfo.setText((String)message);
            } else {
                this.contentPanel.remove(this.lblInfo);
                GridBagConstraints gbc_lblInfo = new GridBagConstraints();
                gbc_lblInfo.insets = new Insets(0, 0, 0, 15);
                gbc_lblInfo.gridx = 1;
                gbc_lblInfo.gridy = 0;
                this.contentPanel.add((Component)message, gbc_lblInfo);
            }
            this.lblIcon.setIcon(icon == 0 ? this.warnIcon : this.infoIcon);
        } else {
            this.lblIcon.setText("");
        }
        this.pack();
        this.btnAceptar.requestFocusInWindow();
        super.showDialog();
    }

    public static void showMessageDialog(Component owner, Object message, String title) {
        WarningDialog.showMessageDialog(owner, message, title, 0);
    }

    public static void showMessageDialog(Component owner, Object message, String title, int icon) {
        Dialog diag = WarningDialog.getParentDialog(owner);
        WarningDialog wd = new WarningDialog(diag);
        if (title != null) {
            wd.setTitle(title);
        }
        wd.showDialog(message, icon);
    }

    public void showURL(String url) {
        Util.showLinkInBrowser(this, url);
    }
}

