/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.gui;

import es.gob.aeat.dit.ov.renta.Enviroment;
import es.gob.aeat.dit.ov.renta.PIN24HId;
import es.gob.aeat.dit.ov.renta.RentaException;
import es.gob.aeat.dit.ov.renta.gui.PTDialog;
import es.gob.aeat.dit.ov.renta.gui.RentaDialog;
import es.gob.aeat.dit.ov.renta.gui.pt.PTErrorDialog;
import es.gob.aeat.dit.ov.renta.gui.pt.PTLevesDialog;
import es.gob.aeat.dit.ov.renta.gui.pt.PTOkDialog;
import es.gob.aeat.dit.ov.renta.pt.Declaracion;
import es.gob.aeat.dit.ov.renta.pt.RentaSender;
import es.gob.aeat.dit.ov.renta.util.Util;
import java.awt.Dialog;
import java.io.File;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.SwingWorker;

public class PTSender
extends SwingWorker<JDialog, String> {
    public static final String CONJUNTA = "conjunta";
    private PTDialog dlg;
    private RentaDialog result;
    private Declaracion decla;
    private String dir;
    private PIN24HId pinId;
    private String aliasCertIntranet;
    private boolean firmaBasica;
    private String firNif;
    private String firNombre;

    public PTSender(PTDialog dlg, String aliasCertIntranet) {
        this.dlg = dlg;
        this.decla = null;
        this.dir = null;
        this.pinId = null;
        this.aliasCertIntranet = aliasCertIntranet;
    }

    public void setData(Declaracion decla, String dir, PIN24HId pinId, boolean firmaBasica, String firNif, String firNombre) {
        this.decla = decla;
        this.dir = dir;
        this.pinId = pinId;
        this.firmaBasica = firmaBasica;
        this.firNif = firNif;
        this.firNombre = firNombre;
    }

    @Override
    protected JDialog doInBackground() throws Exception {
        RentaSender rs = new RentaSender();
        PTErrorDialog errDiag = new PTErrorDialog(this.dlg);
        PTLevesDialog levesDiag = new PTLevesDialog(this.dlg);
        if (this.decla.isConjunta()) {
            this.publish(CONJUNTA);
        } else {
            this.publish(this.decla.getNifDeclarante());
        }
        try {
            if (this.decla.getSignatureType() == 2) {
                rs.sendRentaByRef(this.dlg, this.decla);
            } else if (this.decla.getSignatureType() == 0) {
                rs.sendRentaByCert(this.dlg, this.decla, this.aliasCertIntranet, this.firmaBasica, this.firNif, this.firNombre);
            } else if (this.decla.getSignatureType() == 1) {
                rs.sendRentaByPIN24H(this.dlg, this.decla, this.pinId, this.firmaBasica, this.firNif, this.firNombre);
            }
            PTOkDialog okDiag = new PTOkDialog((Dialog)this.dlg, this.decla.getSignatureType());
            File pathPdf = null;
            if (!rs.getResponse().isYaPresentada()) {
                pathPdf = this.downloadPdf(rs, this.decla.getNifDeclarante());
            }
            okDiag.setResponse(rs.getResponse(), pathPdf);
            if (Enviroment.getInstance().isIntranet()) {
                Util.callAteneo(rs.getResponse().getVariable("REG"));
            }
            this.result = okDiag;
        }
        catch (RentaException re) {
            if (rs.getErrores() != null) {
                if (rs.getResponse() != null && rs.getResponse().isErrorLeve()) {
                    levesDiag.setDeclarante(this.decla.getNifDeclarante(), this.decla.getApeNomDeclarante());
                    levesDiag.setErrores(rs.getErrores());
                    this.result = levesDiag;
                } else {
                    errDiag.setErrores(rs.getErrores());
                    this.result = errDiag;
                }
            } else {
                String[] errores = new String[]{re.toString()};
                errDiag.setErrores(errores);
                this.result = errDiag;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            String[] errores = new String[]{e.getMessage()};
            errDiag.setErrores(errores);
            this.result = errDiag;
        }
        return this.result;
    }

    @Override
    protected void process(List<String> nifs) {
        for (String nif : nifs) {
            this.dlg.updateProgress(nif);
        }
    }

    @Override
    protected void done() {
        this.dlg.setResultDialog(this.result);
    }

    private File downloadPdf(RentaSender rs, String nif) {
        String csv = rs.getCsv().trim();
        if (csv != null && csv.length() > 0) {
            File dest = new File(String.valueOf(this.dir) + "/" + nif + "_" + csv + ".pdf");
            try {
                rs.downloadPdfWithToken(dest);
                return dest;
            }
            catch (RentaException rentaException) {
                // empty catch block
            }
        }
        return null;
    }
}

