/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.gui;

import es.gob.aeat.dit.ov.renta.Enviroment;
import es.gob.aeat.dit.ov.renta.PIN24HId;
import es.gob.aeat.dit.ov.renta.gui.AuthMethodChangeListener;
import es.gob.aeat.dit.ov.renta.gui.CertificateSelectionListener;
import es.gob.aeat.dit.ov.renta.gui.PTSender;
import es.gob.aeat.dit.ov.renta.gui.RentaDialog;
import es.gob.aeat.dit.ov.renta.gui.WarningDialog;
import es.gob.aeat.dit.ov.renta.gui.pt.AvisosPanel;
import es.gob.aeat.dit.ov.renta.gui.pt.FPPanel;
import es.gob.aeat.dit.ov.renta.gui.pt.FirmaBasicaDialog;
import es.gob.aeat.dit.ov.renta.gui.pt.HelpButton;
import es.gob.aeat.dit.ov.renta.gui.pt.IngresoPanel;
import es.gob.aeat.dit.ov.renta.gui.pt.LabelTitle;
import es.gob.aeat.dit.ov.renta.gui.pt.PTErrorDialog;
import es.gob.aeat.dit.ov.renta.gui.pt.PTLevesDialog;
import es.gob.aeat.dit.ov.renta.gui.pt.PTOkDialog;
import es.gob.aeat.dit.ov.renta.gui.pt.ProgressDialog;
import es.gob.aeat.dit.ov.renta.gui.pt.ResumenPanel;
import es.gob.aeat.dit.ov.renta.gui.pt.UserPanel;
import es.gob.aeat.dit.ov.renta.http.HttpHandler;
import es.gob.aeat.dit.ov.renta.http.HttpResponse;
import es.gob.aeat.dit.ov.renta.http.PIN24HAuthenticator;
import es.gob.aeat.dit.ov.renta.pt.Declaracion;
import es.gob.aeat.dit.ov.renta.signature.PIN24HSigner;
import es.gob.aeat.dit.ov.renta.signature.RentaKeyManager;
import es.gob.afirma.core.AOException;
import es.gob.afirma.keystores.main.common.AOKeystoreAlternativeException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.text.DecimalFormat;
import java.util.logging.Level;
import javax.security.cert.CertificateException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLDocument;

public class PTDialog
extends RentaDialog
implements AuthMethodChangeListener,
CertificateSelectionListener {
    private static final long serialVersionUID = 1L;
    public static final int CMD_CANCEL = 0;
    public static final int CMD_CONTINUAR = 1;
    public static final int CMD_SALIR = 2;
    private UserPanel[] userPanels;
    private FPPanel panelFP;
    private Enviroment env;
    private JTextPane textPaneResultado;
    private Declaracion decla;
    private ResumenPanel panelDatosResumen;
    private LabelTitle lblAbrir;
    private IngresoPanel panelIngreso;
    private AvisosPanel panelAvisos;
    private JButton btnPresentar;
    private JButton btnCancelar;
    private ProgressDialog prgDialog;
    private String versionPadre;
    private String dir;
    private PTDialog siguiente;
    private PTDialog anterior;
    private boolean listaPresentar;
    private int selectedCommand;
    private RentaDialog resultDialog;
    private int tipoPadre;
    private JButton btnHelp;
    private ImageIcon mas;
    private ImageIcon menos;
    private String authNombre;
    private String authNif;
    private String authAliasCert;

    public PTDialog(Frame owner, int dim, int tipoPadre, String versionPadre) {
        super(owner);
        this.init(dim, tipoPadre, versionPadre);
    }

    public PTDialog(Dialog owner, int dim, int tipoPadre, String versionPadre) {
        super(owner);
        this.init(dim, tipoPadre, versionPadre);
    }

    public PTDialog(Window owner, int dim, int tipoPadre, String versionPadre) {
        super(owner);
        this.init(dim, tipoPadre, versionPadre);
    }

    public PTDialog(int dim, int tipoPadre, String versionPadre) {
        this.init(dim, tipoPadre, versionPadre);
    }

    private void init(int dim, int tipoPadre, String versionPadre) {
        this.tipoPadre = tipoPadre;
        this.selectedCommand = 0;
        this.siguiente = null;
        this.anterior = null;
        this.listaPresentar = false;
        this.decla = null;
        this.versionPadre = versionPadre;
        this.env = Enviroment.getInstance();
        this.userPanels = new UserPanel[dim];
        this.authNif = null;
        this.authNombre = null;
        this.authAliasCert = null;
        this.getContentPane().setBackground(Enviroment.COLOR_BASE);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                PTDialog.this.selectedCommand = 2;
            }
        });
        this.setResizable(false);
        this.setModal(true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[2];
        gridBagLayout.rowHeights = new int[6];
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(gridBagLayout);
        JPanel panelDatosIdenti = new JPanel();
        panelDatosIdenti.setBackground(Enviroment.COLOR_BASE);
        GridBagConstraints gbc_panelDatosIdenti = new GridBagConstraints();
        gbc_panelDatosIdenti.insets = new Insets(0, 0, 5, 5);
        gbc_panelDatosIdenti.fill = 2;
        gbc_panelDatosIdenti.gridx = 0;
        gbc_panelDatosIdenti.gridy = 0;
        this.getContentPane().add((Component)panelDatosIdenti, gbc_panelDatosIdenti);
        GridBagLayout gbl_panelDatosIdenti = new GridBagLayout();
        gbl_panelDatosIdenti.columnWidths = new int[2];
        gbl_panelDatosIdenti.rowHeights = new int[3];
        gbl_panelDatosIdenti.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_panelDatosIdenti.rowWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        panelDatosIdenti.setLayout(gbl_panelDatosIdenti);
        this.panelFP = new FPPanel(tipoPadre);
        this.panelFP.addAuthMethodChangeListener(this);
        GridBagConstraints gbc_panelFP = new GridBagConstraints();
        gbc_panelFP.insets = new Insets(0, 5, 5, 0);
        gbc_panelFP.fill = 1;
        gbc_panelFP.gridx = 0;
        gbc_panelFP.gridy = 0;
        panelDatosIdenti.add((Component)this.panelFP, gbc_panelFP);
        int i = 0;
        while (i < this.userPanels.length) {
            UserPanel panelId = new UserPanel(this.tipoPadre == 3);
            panelId.addCertificateSelectionListener(this);
            GridBagConstraints gbc_panelId = new GridBagConstraints();
            gbc_panelId.fill = 2;
            gbc_panelId.insets = new Insets(0, 5, 0, 0);
            gbc_panelId.gridx = 0;
            gbc_panelId.gridy = i + 1;
            panelDatosIdenti.add((Component)panelId, gbc_panelId);
            panelId.setFormaPresentacion(this.panelFP.getFormaPresentacion());
            if (tipoPadre == 3) {
                RentaKeyManager rkm;
                if (i > 0) {
                    panelId.disableCertButon();
                }
                if ((rkm = RentaKeyManager.getInstance()).getDefaultAlias() != null && rkm.getDefaultCertInfo() != null) {
                    panelId.setAliasCert(rkm.getDefaultAlias(), rkm.getDefaultCertInfo());
                }
            }
            this.userPanels[i] = panelId;
            ++i;
        }
        JPanel panelResumen = new JPanel();
        panelResumen.setBackground(Enviroment.COLOR_BASE);
        GridBagConstraints gbc_panelResumen = new GridBagConstraints();
        gbc_panelResumen.insets = new Insets(0, 5, 5, 5);
        gbc_panelResumen.fill = 1;
        gbc_panelResumen.gridx = 0;
        gbc_panelResumen.gridy = 1;
        this.getContentPane().add((Component)panelResumen, gbc_panelResumen);
        GridBagLayout gbl_panelResumen = new GridBagLayout();
        gbl_panelResumen.columnWidths = new int[2];
        gbl_panelResumen.rowHeights = new int[3];
        gbl_panelResumen.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_panelResumen.rowWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        panelResumen.setLayout(gbl_panelResumen);
        LabelTitle lblResumen = new LabelTitle();
        lblResumen.setText(this.env.getString("PTDialog.Resumen"));
        GridBagConstraints gbc_lblResumen = new GridBagConstraints();
        gbc_lblResumen.insets = new Insets(0, 0, 5, 0);
        gbc_lblResumen.fill = 2;
        gbc_lblResumen.gridx = 0;
        gbc_lblResumen.gridy = 0;
        panelResumen.add((Component)lblResumen, gbc_lblResumen);
        this.mas = new ImageIcon(PTDialog.class.getResource("/es/gob/aeat/dit/ov/renta/resources/mas.png"));
        this.menos = new ImageIcon(PTDialog.class.getResource("/es/gob/aeat/dit/ov/renta/resources/menos.png"));
        this.lblAbrir = new LabelTitle();
        this.lblAbrir.setIconTextGap(-2);
        this.lblAbrir.setIcon(this.mas);
        this.lblAbrir.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PTDialog.this.lblAbrir.getIcon().equals(PTDialog.this.mas)) {
                    PTDialog.this.lblAbrir.setIcon(PTDialog.this.menos);
                    PTDialog.this.panelDatosResumen.setVisible(true);
                    PTDialog.this.pack();
                    PTDialog.this.repaint();
                } else {
                    PTDialog.this.lblAbrir.setIcon(PTDialog.this.mas);
                    PTDialog.this.panelDatosResumen.setVisible(false);
                    PTDialog.this.pack();
                    PTDialog.this.repaint();
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                PTDialog.this.lblAbrir.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                PTDialog.this.lblAbrir.setCursor(Cursor.getDefaultCursor());
            }
        });
        GridBagConstraints gbc_lblAbrir = new GridBagConstraints();
        gbc_lblAbrir.insets = new Insets(0, 0, 5, 0);
        gbc_lblAbrir.fill = 2;
        gbc_lblAbrir.gridx = 1;
        gbc_lblAbrir.gridy = 0;
        panelResumen.add((Component)this.lblAbrir, gbc_lblAbrir);
        this.panelDatosResumen = new ResumenPanel();
        this.panelDatosResumen.setVisible(false);
        GridBagConstraints gbc_panelDatosResumen = new GridBagConstraints();
        gbc_panelDatosResumen.fill = 3;
        gbc_panelDatosResumen.gridwidth = 2;
        gbc_panelDatosResumen.gridx = 0;
        gbc_panelDatosResumen.gridy = 1;
        panelResumen.add((Component)this.panelDatosResumen, gbc_panelDatosResumen);
        JPanel panelResultado = new JPanel();
        panelResultado.setOpaque(false);
        GridBagConstraints gbc_panelResultado = new GridBagConstraints();
        gbc_panelResultado.insets = new Insets(0, 5, 5, 5);
        gbc_panelResultado.fill = 1;
        gbc_panelResultado.gridx = 0;
        gbc_panelResultado.gridy = 2;
        this.getContentPane().add((Component)panelResultado, gbc_panelResultado);
        GridBagLayout gbl_panelResultado = new GridBagLayout();
        gbl_panelResultado.columnWidths = new int[1];
        gbl_panelResultado.rowHeights = new int[2];
        gbl_panelResultado.columnWeights = new double[]{1.0};
        gbl_panelResultado.rowWeights = new double[]{Double.MIN_VALUE, 1.0};
        panelResultado.setLayout(gbl_panelResultado);
        LabelTitle lblResultado = new LabelTitle();
        lblResultado.setText(this.env.getString("PTDialog.Resultado"));
        GridBagConstraints gbc_lblResultado = new GridBagConstraints();
        gbc_lblResultado.fill = 2;
        gbc_lblResultado.gridx = 0;
        gbc_lblResultado.gridy = 0;
        panelResultado.add((Component)lblResultado, gbc_lblResultado);
        this.textPaneResultado = new JTextPane();
        this.textPaneResultado.setRequestFocusEnabled(false);
        this.textPaneResultado.setFocusable(false);
        this.textPaneResultado.setFocusCycleRoot(false);
        this.textPaneResultado.setContentType("text/html");
        ((HTMLDocument)this.textPaneResultado.getDocument()).getStyleSheet().addRule("body{font-family: " + lblResultado.getFont().getFamily() + "; font-size: " + lblResultado.getFont().getSize() + ";}");
        this.textPaneResultado.setOpaque(false);
        this.textPaneResultado.setEditable(false);
        GridBagConstraints gbc_textPaneResultado = new GridBagConstraints();
        gbc_textPaneResultado.fill = 1;
        gbc_textPaneResultado.gridx = 0;
        gbc_textPaneResultado.gridy = 1;
        panelResultado.add((Component)this.textPaneResultado, gbc_textPaneResultado);
        this.panelIngreso = new IngresoPanel(this.tipoPadre);
        this.panelFP.addAuthMethodChangeListener(this.panelIngreso);
        this.panelIngreso.authMethodChanged(this.panelFP.getFormaPresentacion());
        this.panelIngreso.setOwner(this);
        GridBagConstraints gbc_panelIngreso = new GridBagConstraints();
        gbc_panelIngreso.insets = new Insets(0, 5, 5, 5);
        gbc_panelIngreso.fill = 1;
        gbc_panelIngreso.gridx = 0;
        gbc_panelIngreso.gridy = 3;
        this.getContentPane().add((Component)this.panelIngreso, gbc_panelIngreso);
        this.panelAvisos = new AvisosPanel();
        GridBagConstraints gbc_panelAvisos = new GridBagConstraints();
        gbc_panelAvisos.insets = new Insets(0, 5, 5, 5);
        gbc_panelAvisos.fill = 1;
        gbc_panelAvisos.gridx = 0;
        gbc_panelAvisos.gridy = 4;
        this.getContentPane().add((Component)this.panelAvisos, gbc_panelAvisos);
        JPanel panelBotones = new JPanel();
        panelBotones.setOpaque(false);
        GridBagConstraints gbc_panelBotones = new GridBagConstraints();
        gbc_panelBotones.insets = new Insets(10, 10, 10, 10);
        gbc_panelBotones.fill = 1;
        gbc_panelBotones.gridx = 0;
        gbc_panelBotones.gridy = 5;
        this.getContentPane().add((Component)panelBotones, gbc_panelBotones);
        GridBagLayout gbl_panelBotones = new GridBagLayout();
        gbl_panelBotones.columnWidths = new int[4];
        gbl_panelBotones.rowHeights = new int[2];
        gbl_panelBotones.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_panelBotones.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelBotones.setLayout(gbl_panelBotones);
        this.btnCancelar = new JButton(this.env.getString("PTDialog.ButCancel"));
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setBackground(Enviroment.COLOR_BASE);
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PTDialog.this.selectedCommand = 0;
                PTDialog.this.closeDialog();
            }
        });
        this.btnCancelar.setIcon(new ImageIcon(PTDialog.class.getResource("/es/gob/aeat/dit/ov/renta/resources/cancel.png")));
        GridBagConstraints gbc_btnCancelar = new GridBagConstraints();
        gbc_btnCancelar.insets = new Insets(0, 0, 0, 5);
        gbc_btnCancelar.fill = 3;
        gbc_btnCancelar.anchor = 17;
        gbc_btnCancelar.gridx = 0;
        gbc_btnCancelar.gridy = 0;
        panelBotones.add((Component)this.btnCancelar, gbc_btnCancelar);
        String urlDist = "";
        try {
            urlDist = this.env.getURLDistribuidor();
        }
        catch (Exception e) {
            urlDist = e.getMessage();
        }
        String msg = this.env.getString("Ayuda.PT");
        msg = msg.replaceAll("&amp;URL;", urlDist);
        this.btnHelp = new HelpButton(this, msg, this.env.getString("Ayuda.TipPT"), true);
        GridBagConstraints gbc_btnHelp = new GridBagConstraints();
        gbc_btnHelp.anchor = 17;
        gbc_btnHelp.insets = new Insets(0, 0, 0, 5);
        gbc_btnHelp.gridx = 1;
        gbc_btnHelp.gridy = 0;
        panelBotones.add((Component)this.btnHelp, gbc_btnHelp);
        this.btnPresentar = new JButton(this.env.getString("PTDialog.ButPresen"));
        this.btnPresentar.setMnemonic('P');
        this.btnPresentar.setBackground(Enviroment.COLOR_BASE);
        this.btnPresentar.setIcon(new ImageIcon(PTDialog.class.getResource("/es/gob/aeat/dit/ov/renta/resources/apply.png")));
        this.btnPresentar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PTDialog.this.selectedCommand = 1;
                PTDialog.this.realizarPresentacion();
            }
        });
        GridBagConstraints gbc_btnPresentar = new GridBagConstraints();
        gbc_btnPresentar.fill = 3;
        gbc_btnPresentar.anchor = 13;
        gbc_btnPresentar.gridx = 2;
        gbc_btnPresentar.gridy = 0;
        panelBotones.add((Component)this.btnPresentar, gbc_btnPresentar);
        this.setFocusComponent(this.btnCancelar);
    }

    public void setSiguienteDialogo(PTDialog dialogo) {
        this.siguiente = dialogo;
        if (this.siguiente != null) {
            this.btnPresentar.setText(this.env.getString("PTDialog.ButSiguiente"));
            this.btnPresentar.setMnemonic('S');
            this.btnPresentar.setIcon(new ImageIcon(PTDialog.class.getResource("/es/gob/aeat/dit/ov/renta/resources/next2.png")));
        } else {
            this.btnPresentar.setText(this.env.getString("PTDialog.ButPresen"));
            this.btnPresentar.setMnemonic('P');
            this.btnPresentar.setIcon(new ImageIcon(PTDialog.class.getResource("/es/gob/aeat/dit/ov/renta/resources/apply.png")));
        }
    }

    public void setAnteriorDialogo(PTDialog dialogo) {
        this.anterior = dialogo;
        if (this.anterior != null) {
            this.btnCancelar.setText(this.env.getString("PTDialog.ButAnterior"));
            this.btnCancelar.setMnemonic('A');
            this.btnCancelar.setIcon(new ImageIcon(PTDialog.class.getResource("/es/gob/aeat/dit/ov/renta/resources/prev2.png")));
        } else {
            this.btnCancelar.setText(this.env.getString("PTDialog.ButCancel"));
            this.btnCancelar.setMnemonic('C');
            this.btnCancelar.setIcon(new ImageIcon(PTDialog.class.getResource("/es/gob/aeat/dit/ov/renta/resources/cancel.png")));
        }
    }

    public int getSeletedCommand() {
        return this.selectedCommand;
    }

    public void closeDialog() {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.setVisible(false);
    }

    public void enableDialog() {
        this.btnCancelar.setEnabled(true);
        this.btnPresentar.setEnabled(true);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void disableDialog() {
        this.btnCancelar.setEnabled(false);
        this.btnPresentar.setEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void updateDecla() throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableEntryException, AOKeystoreAlternativeException, IOException, CertificateException, AOException {
        PIN24HSigner p24Signer = new PIN24HSigner();
        this.decla.setTIA(this.panelIngreso.getTIA());
        this.decla.setING(this.panelIngreso.getING());
        this.decla.setICO(this.panelIngreso.getICO());
        this.decla.setNRC(this.panelIngreso.getNRC());
        this.decla.setSignatureType(this.panelFP.getFormaPresentacion());
        int i = 0;
        while (i < this.userPanels.length) {
            PIN24HId id = this.userPanels[i].getPinID();
            if (i == 0) {
                this.decla.setNumRefD(this.userPanels[i].getNumRef());
                if (this.panelFP.getFormaPresentacion() == 1) {
                    this.decla.setSignatureD(p24Signer.sign(this.decla.getFichero(), id));
                } else if (this.panelFP.getFormaPresentacion() != 0) {
                    this.decla.setSignatureD(null);
                }
            } else {
                this.decla.setNumRefC(this.userPanels[i].getNumRef());
                if (this.panelFP.getFormaPresentacion() == 1) {
                    this.decla.setSignatureC(p24Signer.sign(this.decla.getFichero(), id));
                } else if (this.panelFP.getFormaPresentacion() != 0) {
                    this.decla.setSignatureC(null);
                }
            }
            ++i;
        }
    }

    private void realizarPresentacion() {
        this.listaPresentar = false;
        if (this.checkData()) {
            PIN24HId pinId;
            PIN24HAuthenticator pa;
            try {
                this.updateDecla();
            }
            catch (Exception e) {
                this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "realizarPresentacion", "Error actualizando declaracion", e);
                WarningDialog.showMessageDialog(this, String.valueOf(this.env.getString("PTErrorDialog.Info")) + "\n\n" + e.getMessage(), this.env.getString("ContriPanel.ErrTitle"));
                return;
            }
            if (this.userPanels.length == 2 && this.panelFP.getFormaPresentacion() == 0 && !this.checkCertificates()) {
                return;
            }
            if (this.panelFP.getFormaPresentacion() == 1 && !(pa = new PIN24HAuthenticator()).authenticate((pinId = this.userPanels[0].getPinID()).getNif(), pinId.getClave(), pinId.getPin())) {
                WarningDialog.showMessageDialog(this, String.valueOf(this.env.getString("PTDialog.ErrClavePIN")) + pa.getError(), this.env.getString("ContriPanel.ErrTitle"));
                return;
            }
            this.listaPresentar = true;
            if (this.isFirmaBasica()) {
                this.getAutenticationInfo();
                if (this.authNif == null || this.authNombre == null) {
                    this.enableDialog();
                    return;
                }
                FirmaBasicaDialog fbd = new FirmaBasicaDialog((Dialog)this, this.authNif, this.authNombre, this.decla);
                fbd.showDialog();
                if (fbd.getResultado() == 0) {
                    this.enableDialog();
                    return;
                }
            }
            ProgressDialog progreso = new ProgressDialog(this);
            if (this.siguiente == null && this.anterior == null) {
                this.disableDialog();
                this.presentar(progreso);
            } else if (this.siguiente != null) {
                this.closeDialog();
            } else {
                this.disableDialog();
                progreso.setNumToClose(2);
                this.anterior.presentar(progreso);
            }
        }
    }

    private boolean checkCertificates() {
        String nifD = this.decla.getNifDeclarante().toUpperCase();
        String nifC = this.decla.getNifConyuge().toUpperCase();
        if (this.decla.getSignatureD() != null && nifD.equals(this.decla.getSignatureD().getNif()) && this.decla.getSignatureC() == null) {
            WarningDialog.showMessageDialog(this, this.env.getString("PTDialog.ErrCertConyu"), this.env.getString("ContriPanel.ErrTitle"));
            return false;
        }
        if (this.decla.getSignatureC() != null && nifC.equals(this.decla.getSignatureC().getNif()) && this.decla.getSignatureD() == null) {
            WarningDialog.showMessageDialog(this, this.env.getString("PTDialog.ErrCertDecla"), this.env.getString("ContriPanel.ErrTitle"));
            return false;
        }
        if (!(this.decla.getSignatureD() == null || this.decla.getSignatureC() == null || nifD.equals(this.decla.getSignatureD().getNif()) && nifC.equals(this.decla.getSignatureC().getNif()) || this.decla.getSignatureD().getNif() == null || this.decla.getSignatureD().getNif().equals(this.decla.getSignatureC().getNif()))) {
            WarningDialog.showMessageDialog(this, this.env.getString("PTDialog.ErrCertAmbos"), this.env.getString("ContriPanel.ErrTitle"));
            return false;
        }
        return true;
    }

    private void presentar(ProgressDialog progreso) {
        if (this.listaPresentar) {
            this.prgDialog = progreso == null ? new ProgressDialog(this) : progreso;
            this.prgDialog.showDialog();
            String aliasCertIntranet = null;
            if (this.tipoPadre == 3) {
                if (this.userPanels[0].getAliasCert() != null) {
                    aliasCertIntranet = this.userPanels[0].getAliasCert();
                } else if (this.userPanels.length > 1 && this.userPanels[1].getAliasCert() != null) {
                    aliasCertIntranet = this.userPanels[1].getAliasCert();
                }
                if (aliasCertIntranet != null) {
                    RentaKeyManager.getInstance().setAliasSSL(aliasCertIntranet);
                }
            } else if (this.isFirmaBasica()) {
                RentaKeyManager.getInstance().setAliasSSL(this.authAliasCert);
            }
            PTSender sender = new PTSender(this, aliasCertIntranet);
            sender.setData(this.decla, this.dir, this.userPanels[0].getPinID(), this.isFirmaBasica(), this.authNif, this.authNombre);
            sender.execute();
        }
    }

    private boolean checkData() {
        int i = 0;
        while (i < this.userPanels.length) {
            switch (this.panelFP.getFormaPresentacion()) {
                case -1: {
                    WarningDialog.showMessageDialog(this, this.env.getString("PTDialog.ErrForma"), this.env.getString("ContriPanel.ErrTitle"));
                    return false;
                }
                case 0: {
                    if (this.userPanels[i].getAliasCert() != null || i != 0) break;
                    WarningDialog.showMessageDialog(this, String.valueOf(this.env.getString("ContriPanel.ErrNoCert")) + " " + this.userPanels[i].getNIF(), this.env.getString("ContriPanel.ErrTitle"));
                    return false;
                }
                case 2: {
                    if (this.userPanels[i].getNumRef().trim().length() > 0) break;
                    WarningDialog.showMessageDialog(this, String.valueOf(this.env.getString("ContriPanel.ErrNoRef")) + " " + this.userPanels[i].getNIF(), this.env.getString("ContriPanel.ErrTitle"));
                    return false;
                }
                case 1: {
                    if (this.userPanels[i].getClave().trim().length() <= 0) {
                        WarningDialog.showMessageDialog(this, String.valueOf(this.env.getString("ContriPanel.ErrNoClave")) + " " + this.userPanels[i].getNIF(), this.env.getString("ContriPanel.ErrTitle"));
                        return false;
                    }
                    if (this.userPanels[i].getPIN().trim().length() > 0) break;
                    WarningDialog.showMessageDialog(this, String.valueOf(this.env.getString("ContriPanel.ErrNoPIN")) + " " + this.userPanels[i].getNIF(), this.env.getString("ContriPanel.ErrTitle"));
                    return false;
                }
            }
            ++i;
        }
        return this.panelIngreso.checkData();
    }

    public void setData(String[] nifs, String[] apeNom, String[] desc, Declaracion decla, String dir) {
        this.dir = dir;
        this.decla = decla;
        this.setTitle(String.valueOf(this.env.getString("PTDialog.Title")) + " " + this.decla.getModelo());
        int i = 0;
        while (i < this.userPanels.length) {
            this.userPanels[i].setNIF(nifs[i]);
            this.userPanels[i].setApeNom(apeNom[i]);
            this.userPanels[i].setDesc(desc[i]);
            ++i;
        }
        this.textPaneResultado.setText(decla.getResultadoTxt());
        if (this.decla.getImporteResultado() > 0.0 && this.decla.getFormaPago() == 3) {
            this.panelAvisos.addWarning(this.env.getString("ResumenPanel.WarnDomic"));
        }
        this.fillResumen2014();
        this.panelIngreso.setDeclaracion(decla);
        this.panelAvisos.setVisible(!this.panelAvisos.isEmpty());
        this.panelFP.setWidthIdPart(this.userPanels[0].getWidthIdPart());
    }

    private void fillResumen2014() {
        DecimalFormat df = new DecimalFormat("0.00");
        if (this.decla.getModelo() == 100) {
            this.panelDatosResumen.setPartida(0, this.env.getString("ResumenPanel.Part_00"), "490", df.format(this.decla.getValuePartida(490)));
            this.panelDatosResumen.setPartida(1, this.env.getString("ResumenPanel.Part_01"), "495", df.format(this.decla.getValuePartida(495)));
            this.panelDatosResumen.setPartida(2, this.env.getString("ResumenPanel.Part_02"), "527", df.format(this.decla.getValuePartida(527)));
            this.panelDatosResumen.setPartida(3, this.env.getString("ResumenPanel.Part_03"), "531", df.format(this.decla.getValuePartida(531)));
            this.panelDatosResumen.setPartida(7, this.env.getString("ResumenPanel.Part_07"), "589", df.format(this.decla.getValuePartida(589)));
            this.panelDatosResumen.setPartida(8, this.env.getString("ResumenPanel.Part_08"), "601", df.format(this.decla.getValuePartida(601)));
            if (this.decla.getValuePartida(582) == 0.0) {
                this.panelDatosResumen.setPartida(4, this.env.getString("ResumenPanel.Part_04_1"), "570", df.format(this.decla.getValuePartida(570)));
                this.panelDatosResumen.setPartida(5, this.env.getString("ResumenPanel.Part_05_1"), "571", df.format(this.decla.getValuePartida(571)));
                this.panelDatosResumen.setPartida(6, this.env.getString("ResumenPanel.Part_06_1"), "610", df.format(this.decla.getValuePartida(610)));
            } else {
                this.panelDatosResumen.setPartida(4, this.env.getString("ResumenPanel.Part_04_2"), "580", df.format(this.decla.getValuePartida(580)));
                this.panelDatosResumen.setPartida(5, this.env.getString("ResumenPanel.Part_05_2"), "581", df.format(this.decla.getValuePartida(581)));
                this.panelDatosResumen.setPartida(6, this.env.getString("ResumenPanel.Part_06_2"), "582", df.format(this.decla.getValuePartida(582)));
            }
            if (this.decla.getDoubleValue("26", 24, 13, 2) == 0.0) {
                this.panelDatosResumen.setPartida(9, this.env.getString("ResumenPanel.Part_09_1"), "605", df.format(this.decla.getValuePartida(605)));
                if ("1".equals(this.decla.getStringValue("26", 23, 1))) {
                    this.panelDatosResumen.setPartida(10, this.env.getString("ResumenPanel.Part_10_1"), "620", df.format(this.decla.getValuePartida(620)));
                    this.panelAvisos.addWarning(this.env.getString("ResumenPanel.WarnCompe"));
                } else {
                    this.panelDatosResumen.setPartida(10, this.env.getString("ResumenPanel.Part_10_2"), "620", df.format(this.decla.getValuePartida(620)));
                }
            } else {
                this.panelDatosResumen.setPartida(9, this.env.getString("ResumenPanel.Part_09_2"), "615", df.format(this.decla.getValuePartida(615)));
            }
        } else if (this.decla.getModelo() == 714) {
            this.panelDatosResumen.setPartida(0, this.env.getString("ResumenPanel.714_01"), "23", df.format(this.decla.getValuePartida(23)));
            if (this.decla.getDoubleValue("11", 62, 13, 2) > 0.0) {
                this.panelDatosResumen.setPartida(2, this.env.getString("ResumenPanel.714_02"), "25", df.format(this.decla.getValuePartida(25)));
                this.panelDatosResumen.setPartida(4, this.env.getString("ResumenPanel.714_03"), "40", df.format(this.decla.getValuePartida(40)));
            } else if (this.decla.getDoubleValue("11", 62, 13, 2) == 0.0) {
                this.panelDatosResumen.setPartida(2, this.env.getString("ResumenPanel.714_04"), "24", df.format(this.decla.getValuePartida(24)));
                this.panelDatosResumen.setPartida(4, this.env.getString("ResumenPanel.714_02"), "25", df.format(this.decla.getValuePartida(25)));
            }
        }
    }

    private void fillResumen2013() {
        DecimalFormat df = new DecimalFormat("0.00");
        if (this.decla.getModelo() == 100) {
            this.panelDatosResumen.setPartida(0, this.env.getString("ResumenPanel.Part_00"), "415", df.format(this.decla.getValuePartida(415)));
            this.panelDatosResumen.setPartida(1, this.env.getString("ResumenPanel.Part_01"), "419", df.format(this.decla.getValuePartida(419)));
            this.panelDatosResumen.setPartida(2, this.env.getString("ResumenPanel.Part_02"), "449", df.format(this.decla.getValuePartida(449)));
            this.panelDatosResumen.setPartida(3, this.env.getString("ResumenPanel.Part_03"), "453", df.format(this.decla.getValuePartida(453)));
            this.panelDatosResumen.setPartida(7, this.env.getString("ResumenPanel.Part_07"), "511", df.format(this.decla.getValuePartida(511)));
            this.panelDatosResumen.setPartida(8, this.env.getString("ResumenPanel.Part_08"), "524", df.format(this.decla.getValuePartida(524)));
            if (this.decla.getValuePartida(504) == 0.0) {
                this.panelDatosResumen.setPartida(4, this.env.getString("ResumenPanel.Part_04_1"), "492", df.format(this.decla.getValuePartida(492)));
                this.panelDatosResumen.setPartida(5, this.env.getString("ResumenPanel.Part_05_1"), "493", df.format(this.decla.getValuePartida(493)));
                this.panelDatosResumen.setPartida(6, this.env.getString("ResumenPanel.Part_06_1"), "530", df.format(this.decla.getValuePartida(530)));
            } else {
                this.panelDatosResumen.setPartida(4, this.env.getString("ResumenPanel.Part_04_2"), "502", df.format(this.decla.getValuePartida(502)));
                this.panelDatosResumen.setPartida(5, this.env.getString("ResumenPanel.Part_05_2"), "503", df.format(this.decla.getValuePartida(503)));
                this.panelDatosResumen.setPartida(6, this.env.getString("ResumenPanel.Part_06_2"), "504", df.format(this.decla.getValuePartida(504)));
            }
            if (this.decla.getDoubleValue("23", 24, 13, 2) == 0.0) {
                this.panelDatosResumen.setPartida(9, this.env.getString("ResumenPanel.Part_09_1"), "525", df.format(this.decla.getValuePartida(525)));
                if ("1".equals(this.decla.getStringValue("23", 23, 1))) {
                    this.panelDatosResumen.setPartida(10, this.env.getString("ResumenPanel.Part_10_1"), "540", df.format(this.decla.getValuePartida(540)));
                    this.panelAvisos.addWarning(this.env.getString("ResumenPanel.WarnCompe"));
                } else {
                    this.panelDatosResumen.setPartida(10, this.env.getString("ResumenPanel.Part_10_2"), "540", df.format(this.decla.getValuePartida(540)));
                }
            } else {
                this.panelDatosResumen.setPartida(9, this.env.getString("ResumenPanel.Part_09_2"), "535", df.format(this.decla.getValuePartida(535)));
            }
        } else if (this.decla.getModelo() == 714) {
            this.panelDatosResumen.setPartida(0, this.env.getString("ResumenPanel.714_01"), "23", df.format(this.decla.getValuePartida(23)));
            if (this.decla.getDoubleValue("11", 62, 13, 2) > 0.0) {
                this.panelDatosResumen.setPartida(2, this.env.getString("ResumenPanel.714_02"), "25", df.format(this.decla.getValuePartida(25)));
                this.panelDatosResumen.setPartida(4, this.env.getString("ResumenPanel.714_03"), "40", df.format(this.decla.getValuePartida(40)));
            } else if (this.decla.getDoubleValue("11", 62, 13, 2) == 0.0) {
                this.panelDatosResumen.setPartida(2, this.env.getString("ResumenPanel.714_04"), "24", df.format(this.decla.getValuePartida(24)));
                this.panelDatosResumen.setPartida(4, this.env.getString("ResumenPanel.714_02"), "25", df.format(this.decla.getValuePartida(25)));
            }
        }
    }

    public boolean isByRefSelected() {
        return this.panelFP.getFormaPresentacion() == 2;
    }

    public String getRefForNIF(String nif) {
        int i = 0;
        while (i < this.userPanels.length) {
            if (this.userPanels[i].getNIF().equalsIgnoreCase(nif)) {
                return this.userPanels[i].getNumRef().trim();
            }
            ++i;
        }
        return null;
    }

    public void updateProgress(String nif) {
        if (nif != null) {
            if (nif.equals("conjunta")) {
                this.prgDialog.setText(this.env.getString("IngresoPanel.MsgEnv1"));
            } else {
                this.prgDialog.setText(String.valueOf(this.env.getString("IngresoPanel.MsgEnv2")) + " " + nif + "...");
            }
        }
    }

    private int showFirmaBasicaLeves() {
        int out = 1;
        if (this.isFirmaBasica()) {
            FirmaBasicaDialog fbd = new FirmaBasicaDialog((Dialog)this, this.authNif, this.authNombre, this.decla);
            fbd.showDialog();
            if (fbd.getResultado() == 0) {
                out = 0;
            }
        }
        return out;
    }

    public void setResultDialog(RentaDialog dialog) {
        PTLevesDialog ptl;
        this.resultDialog = dialog;
        this.prgDialog.dispose();
        if (dialog instanceof PTOkDialog && this.tipoPadre == 3) {
            RentaKeyManager rkm = RentaKeyManager.getInstance();
            rkm.setDefaultCert(this.userPanels[0].getAliasCert(), this.userPanels[0].getInfoCert());
        }
        if (this.anterior == null && this.siguiente == null) {
            if (dialog instanceof PTOkDialog) {
                ((PTOkDialog)dialog).showDialog(true);
                this.closeDialog();
            } else if (dialog instanceof PTLevesDialog) {
                dialog.showDialog();
                ptl = (PTLevesDialog)dialog;
                if (ptl.getResult() == 1 || this.showFirmaBasicaLeves() == 0) {
                    this.enableDialog();
                } else {
                    this.decla.setErroresLeves(true);
                    this.presentar(this.prgDialog);
                }
            } else {
                dialog.showDialog();
                this.enableDialog();
            }
        } else if (this.anterior != null) {
            if (dialog instanceof PTLevesDialog) {
                dialog.showDialog();
                ptl = (PTLevesDialog)dialog;
                if (ptl.getResult() == 1 || this.showFirmaBasicaLeves() == 0) {
                    PTErrorDialog ptderr = new PTErrorDialog(this);
                    ptderr.setErrores(new String[]{this.env.getString("PTLevesDialog.ErrLeve")});
                    this.resultDialog = ptderr;
                    this.closeDialog();
                } else {
                    this.decla.setErroresLeves(true);
                    this.presentar(this.prgDialog);
                }
            } else {
                this.closeDialog();
            }
        } else if (this.siguiente != null) {
            if (dialog instanceof PTLevesDialog) {
                dialog.showDialog();
                ptl = (PTLevesDialog)dialog;
                if (ptl.getResult() == 1 || this.showFirmaBasicaLeves() == 0) {
                    PTErrorDialog ptderr = new PTErrorDialog(this);
                    ptderr.setErrores(new String[]{this.env.getString("PTLevesDialog.ErrLeve")});
                    this.resultDialog = ptderr;
                    this.siguiente.presentar(this.prgDialog);
                } else {
                    this.decla.setErroresLeves(true);
                    this.presentar(this.prgDialog);
                }
            } else {
                this.siguiente.presentar(this.prgDialog);
            }
        }
    }

    public RentaDialog getResultDialog() {
        return this.resultDialog;
    }

    @Override
    public void authMethodChanged(int authMethod) {
        int i = 0;
        while (i < this.userPanels.length) {
            switch (authMethod) {
                case 0: {
                    this.userPanels[i].showCert();
                    break;
                }
                case 1: {
                    this.userPanels[i].showPIN();
                    break;
                }
                case 2: {
                    this.userPanels[i].showRef();
                }
            }
            ++i;
        }
        this.panelIngreso.validate();
        this.validate();
        this.pack();
    }

    @Override
    public void preShow() {
        this.setMinimumSize(this.getSize());
    }

    @Override
    public void certificateSelected(String alias, String nif, String certInfo) {
        int userPanelIndex = -1;
        int i = 0;
        while (i < this.userPanels.length) {
            if (this.userPanels[i].getNIF().equalsIgnoreCase(nif)) {
                userPanelIndex = i;
            }
            ++i;
        }
        if (userPanelIndex >= 0) {
            try {
                if (userPanelIndex == 0) {
                    if (this.panelFP.getFormaPresentacion() == 0 && alias != null && this.tipoPadre != 3) {
                        this.decla.setSignatureD(RentaKeyManager.getInstance().sign(this, this.decla.getFichero().getBytes(), alias));
                    }
                    if (this.tipoPadre == 3 && this.userPanels.length > 1) {
                        this.userPanels[1].setAliasCert(alias, certInfo);
                    }
                } else if (userPanelIndex == 1 && this.panelFP.getFormaPresentacion() == 0 && alias != null && this.tipoPadre != 3) {
                    this.decla.setSignatureC(RentaKeyManager.getInstance().sign(this, this.decla.getFichero().getBytes(), alias));
                }
            }
            catch (Exception e) {
                this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "certificateSelected", "Error generando firma con certificado", e);
                this.userPanels[userPanelIndex].resetCert();
                WarningDialog.showMessageDialog(this, String.valueOf(this.env.getString("PTErrorDialog.Info")) + "\n\n" + e.getMessage(), this.env.getString("ContriPanel.ErrTitle"));
            }
        }
    }

    private void getAutenticationInfo() {
        String error = null;
        String aliasCert = null;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.authNif = null;
        this.authNombre = null;
        this.authAliasCert = null;
        try {
            String url = this.env.getURLCertInfo(0);
            if (this.panelFP.getFormaPresentacion() == 1) {
                url = this.env.getURLCertInfo(1);
            } else {
                int i = 0;
                while (i < this.userPanels.length) {
                    if (this.userPanels[i].getAliasCert() != null) {
                        aliasCert = this.userPanels[i].getAliasCert();
                        RentaKeyManager.getInstance().setAliasSSL(aliasCert);
                    }
                    ++i;
                }
            }
            HttpHandler hh = new HttpHandler(url);
            hh.addRequestProperty("Referer", url);
            HttpResponse resp = hh.doGet();
            if (resp.getContentTypeStr().indexOf("text/plain") < 0) {
                error = "Respuesta erronea (" + resp.getContentTypeStr() + ")";
                this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "getCertificateInfo", resp.getContentAsText());
            } else if (resp.getResponseCode() != 200) {
                error = "Response code " + resp.getResponseCode();
            } else {
                String content = resp.getContentAsText();
                int ind = content.indexOf("|");
                if (ind > 0 && ind < content.length() - 1) {
                    this.authNif = content.substring(0, ind).trim();
                    this.authNombre = content.substring(ind + 1).trim();
                    this.authAliasCert = aliasCert;
                } else {
                    error = "Respuesta erronea (" + content + ")";
                }
            }
        }
        catch (Exception e) {
            this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "getCertificateInfo", "Error llamando al servicio", e);
            this.authNif = null;
            this.authNombre = null;
            this.authAliasCert = null;
            error = "Error llamando al servicio (" + e.getMessage() + ")";
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (error != null) {
            int i = 0;
            while (i < this.userPanels.length) {
                this.userPanels[i].resetCert();
                ++i;
            }
            String errorInfo = this.panelFP.getFormaPresentacion() == 0 ? this.env.getString("FirmaBasicaDialog.errorInfoCert") : this.env.getString("FirmaBasicaDialog.errorInfoPIN");
            errorInfo = errorInfo.replaceAll("&amp;error;", error);
            WarningDialog.showMessageDialog(this, errorInfo, this.env.getString("ContriPanel.ErrTitle"));
        }
    }

    private boolean isFirmaBasica() {
        if (this.tipoPadre != 3) {
            if (this.userPanels.length == 2 && this.panelFP.getFormaPresentacion() == 0) {
                String nifD = this.decla.getNifDeclarante().toUpperCase();
                if (this.decla.getSignatureD() != null && !nifD.equals(this.decla.getSignatureD().getNif()) && this.decla.getSignatureC() == null) {
                    return true;
                }
            }
            if (this.userPanels.length == 1 && (this.panelFP.getFormaPresentacion() == 0 || this.panelFP.getFormaPresentacion() == 1)) {
                return true;
            }
        }
        return false;
    }
}

