/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.gui;

import es.gob.aeat.dit.ov.renta.PIN24HId;
import es.gob.aeat.dit.ov.renta.df.DFRetriever;
import es.gob.aeat.dit.ov.renta.gui.DFDialog;
import java.io.File;
import java.util.List;
import javax.swing.SwingWorker;

public class DFDownloader
extends SwingWorker<String[][], String> {
    private DFDialog dlg;
    private String[] nif;
    private String[] apeNom;
    private String[] numRef;
    private String[] clave;
    private String[] pin;
    private String[] dfp;
    private String[] aliasCert;
    private String directorio;
    private int[] tipo;
    private boolean[] isDNIeAut;

    public DFDownloader(DFDialog dlg) {
        this.dlg = dlg;
        this.nif = null;
        this.apeNom = null;
        this.tipo = null;
        this.dfp = null;
        this.aliasCert = null;
        this.numRef = null;
        this.clave = null;
        this.pin = null;
        this.isDNIeAut = null;
        this.directorio = "./";
    }

    public void setData(String[] nif, String[] apeNom, int[] tipo, String[] dfp, String[] aliasCert, boolean[] isDNIeAut, String[] numRef, String[] clave, String[] pin, String directorio) {
        this.nif = nif;
        this.apeNom = apeNom;
        this.tipo = tipo;
        this.dfp = dfp;
        this.aliasCert = aliasCert;
        this.numRef = numRef;
        this.clave = clave;
        this.pin = pin;
        this.isDNIeAut = isDNIeAut;
        this.directorio = directorio;
    }

    @Override
    protected String[][] doInBackground() throws Exception {
        String filename;
        DFRetriever dfr = new DFRetriever(this.dlg);
        String[][] result = new String[this.nif.length][2];
        int i = 0;
        while (i < this.nif.length) {
            result[i][0] = this.nif[i];
            this.publish(this.nif[i]);
            try {
                filename = "--";
                if (this.tipo[i] == 2) {
                    filename = dfr.getDFbyNumRef(this.nif[i], this.apeNom[i], this.numRef[i], this.dfp[i].equals("DFP"), new File(this.directorio));
                } else if (this.tipo[i] == 0) {
                    filename = dfr.getDFbyCert(this.nif[i], this.apeNom[i], this.dfp[i].equals("DFP"), this.aliasCert[i], this.isDNIeAut[i], false, new File(this.directorio));
                } else if (this.tipo[i] == 1) {
                    filename = dfr.getDFbyPIN24H(new PIN24HId(this.nif[i], this.clave[i], this.pin[i]), this.apeNom[i], this.dfp[i].equals("DFP"), new File(this.directorio));
                }
                result[i][1] = "00:" + filename;
            }
            catch (Throwable e) {
                result[i][1] = "02:" + e;
            }
            ++i;
        }
        i = 0;
        while (i < this.nif.length) {
            filename = "--";
            try {
                if (this.tipo[i] == 0 && this.isDNIeAut[i] && result[i][1].equals("02:ERROR_DNIE")) {
                    this.publish(this.nif[i]);
                    filename = dfr.getDFbyCert(this.nif[i], this.apeNom[i], this.dfp[i].equals("DFP"), this.aliasCert[i], this.isDNIeAut[i], true, new File(this.directorio));
                    result[i][1] = "00:" + filename;
                }
            }
            catch (Throwable e) {
                result[i][1] = "02:" + e;
            }
            ++i;
        }
        this.dlg.setResult(result);
        return result;
    }

    @Override
    protected void done() {
        this.dlg.exitForm();
    }

    @Override
    protected void process(List<String> nifs) {
        for (String nif : nifs) {
            this.dlg.updateProgress(nif);
        }
    }
}

