/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.gui;

import es.gob.aeat.dit.ov.renta.Enviroment;
import es.gob.aeat.dit.ov.renta.gui.CertificateSelectionListener;
import es.gob.aeat.dit.ov.renta.gui.ContriPanel;
import es.gob.aeat.dit.ov.renta.gui.DFDownloader;
import es.gob.aeat.dit.ov.renta.gui.PTDialog;
import es.gob.aeat.dit.ov.renta.gui.pt.HelpButton;
import es.gob.aeat.dit.ov.renta.signature.RentaKeyManager;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DFDialog
extends JDialog
implements ActionListener,
CertificateSelectionListener {
    public static final String CANCELADO_STR = "01:Cancelado";
    private static final String CANCEL_CMD = "cancel";
    private static final String DESCARGAR_CMD = "descargar";
    private static final long serialVersionUID = -9065903090376916487L;
    private ContriPanel[] jPNifs;
    private JLabel progress;
    private JButton jButCancel;
    private JButton jButDescarga;
    private HelpButton btnHelp;
    private JPanel botonera;
    private int dimension;
    private String[][] result;
    private String[] dfp;
    private String directorio;
    private int tipoPadre;

    public DFDialog(int dim, int tipoPadre) {
        this.init(dim, tipoPadre);
    }

    public DFDialog(Frame owner, int dim, int tipoPadre) {
        super(owner);
        this.init(dim, tipoPadre);
    }

    public DFDialog(Dialog owner, int dim, int tipoPadre) {
        super(owner);
        this.init(dim, tipoPadre);
    }

    public DFDialog(Window owner, int dim, int tipoPadre) {
        super(owner);
        this.init(dim, tipoPadre);
    }

    private void init(int dim, int tipoPadre) {
        this.tipoPadre = tipoPadre;
        this.dimension = dim;
        this.jPNifs = new ContriPanel[this.dimension];
        this.result = new String[this.dimension][2];
        this.dfp = new String[this.dimension];
        this.directorio = "./";
        int i = 0;
        while (i < this.dimension) {
            this.jPNifs[i] = new ContriPanel(this, tipoPadre);
            this.jPNifs[i].setBackground(Enviroment.COLOR_LIGHT);
            if (tipoPadre == 3) {
                if (i == 0) {
                    this.jPNifs[i].addCertificateSelectionListener(this);
                } else {
                    this.jPNifs[i].disableCertButon();
                }
            }
            ++i;
        }
        this.initComponents();
        this.getContentPane().setBackground(Enviroment.COLOR_BASE);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                DFDialog.this.cancelOperation();
            }
        });
    }

    public String[][] getResult() {
        return this.result;
    }

    public void setResult(String[][] result) {
        if (this.tipoPadre == 3) {
            boolean ok = false;
            int i = 0;
            while (i < result.length) {
                if (result[i][1].startsWith("00:")) {
                    ok = true;
                }
                ++i;
            }
            if (ok) {
                RentaKeyManager rkm = RentaKeyManager.getInstance();
                rkm.setDefaultCert(this.jPNifs[0].getAliasCert(), this.jPNifs[0].getInfoCert());
            }
        }
        this.result = result;
    }

    public void exitForm() {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.setVisible(false);
        this.dispose();
    }

    private void disableAll() {
        this.jButCancel.setEnabled(false);
        this.jButDescarga.setEnabled(false);
        int i = 0;
        while (i < this.dimension) {
            this.jPNifs[i].disableAll();
            ++i;
        }
    }

    private void initComponents() {
        Enviroment env = Enviroment.getInstance();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(PTDialog.class.getResource("/es/gob/aeat/dit/ov/renta/resources/aeatlogo.png")));
        this.setName("PinDlg@DFDialog");
        this.setTitle(env.getString("DFDialog.title"));
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLBlabel0 = new JLabel();
        jLBlabel0.setName("label0");
        jLBlabel0.setText(env.getString("DFDialog.jLBlabel0"));
        jLBlabel0.setFocusCycleRoot(false);
        jLBlabel0.setFocusable(false);
        jLBlabel0.setRequestFocusEnabled(false);
        jLBlabel0.setOpaque(false);
        jLBlabel0.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.bottom = 10;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.insets.top = 10;
        this.getContentPane().add((Component)jLBlabel0, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets.bottom = 10;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.insets.top = 0;
        int i = 0;
        while (i < this.dimension) {
            gridBagConstraints.gridy = i + 1;
            this.getContentPane().add((Component)this.jPNifs[i], gridBagConstraints);
            ++i;
        }
        this.botonera = new JPanel();
        this.botonera.setOpaque(false);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = this.dimension + 1;
        this.getContentPane().add((Component)this.botonera, gridBagConstraints);
        GridBagLayout gbl_panelBotonera = new GridBagLayout();
        gbl_panelBotonera.columnWidths = new int[4];
        gbl_panelBotonera.rowHeights = new int[2];
        gbl_panelBotonera.columnWeights = new double[]{0.0, 0.0, 1.0, 0.0};
        gbl_panelBotonera.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.botonera.setLayout(gbl_panelBotonera);
        ImageIcon imgCancel = new ImageIcon(this.getClass().getResource("/es/gob/aeat/dit/ov/renta/resources/cancel.png"));
        this.jButCancel = new JButton(env.getString("DFDialog.jButCancelar"), imgCancel);
        this.jButCancel.setActionCommand(CANCEL_CMD);
        this.jButCancel.addActionListener(this);
        this.jButCancel.setMnemonic(67);
        this.jButCancel.setDisplayedMnemonicIndex(0);
        this.jButCancel.setBackground(Enviroment.COLOR_BASE);
        ImageIcon imgDescarga = new ImageIcon(this.getClass().getResource("/es/gob/aeat/dit/ov/renta/resources/apply.png"));
        this.jButDescarga = new JButton(env.getString("DFDialog.jButDescarga"), imgDescarga);
        this.jButDescarga.setActionCommand(DESCARGAR_CMD);
        this.jButDescarga.addActionListener(this);
        this.jButDescarga.setMnemonic(68);
        this.jButDescarga.setDisplayedMnemonicIndex(0);
        this.jButDescarga.setBackground(Enviroment.COLOR_BASE);
        String urlDist = "";
        try {
            urlDist = env.getURLDistribuidor();
        }
        catch (Exception e) {
            urlDist = e.getMessage();
        }
        String msg = env.getString("Ayuda.DF");
        msg = msg.replaceAll("&amp;URL;", urlDist);
        this.btnHelp = new HelpButton(this, msg, env.getString("Ayuda.TipDF"), true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.botonera.add((Component)this.jButCancel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.left = 5;
        this.botonera.add((Component)this.btnHelp, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.botonera.add((Component)this.jButDescarga, gridBagConstraints);
        this.progress = new JLabel();
        msg = env.getString("DFDialog.progress1");
        msg = String.valueOf(msg) + ". ";
        msg = String.valueOf(msg) + env.getString("DFDialog.progress2");
        this.progress.setText(msg);
        this.progress.setFont(new Font(null, 0, 12));
    }

    public void showDialog() {
        this.setResizable(false);
        this.pack();
        this.jButCancel.requestFocusInWindow();
        Dimension dim = this.getToolkit().getScreenSize();
        Rectangle abounds = this.getBounds();
        this.setLocation((dim.width - abounds.width) / 2, (dim.height - abounds.height) / 2);
        this.setVisible(true);
    }

    public void setData(String[] nifs, String[] apellidos, String[] desc, String[] dfp, String dir) {
        int i = 0;
        while (i < this.dimension) {
            if (nifs.length > i) {
                this.jPNifs[i].setNif(nifs[i].toUpperCase());
                this.result[i][0] = nifs[i].toUpperCase();
            }
            if (apellidos.length > i) {
                this.jPNifs[i].setApeNom(apellidos[i].toUpperCase());
            }
            if (desc != null && desc.length > i) {
                this.jPNifs[i].setTitle(desc[i]);
            }
            this.dfp[i] = dfp.length > i ? dfp[i] : "DF";
            ++i;
        }
        this.directorio = dir;
    }

    private boolean checkData() {
        int i = 0;
        while (i < this.dimension) {
            if (!this.jPNifs[i].checkData()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void cancelOperation() {
        int i = 0;
        while (i < this.dimension) {
            this.result[i][1] = CANCELADO_STR;
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals(CANCEL_CMD)) {
            this.cancelOperation();
            this.exitForm();
        } else if (ev.getActionCommand().equals(DESCARGAR_CMD) && this.checkData()) {
            this.disableAll();
            this.showProgress();
            this.setCursor(Cursor.getPredefinedCursor(3));
            DFDownloader dfd = new DFDownloader(this);
            String[] nif = new String[this.dimension];
            String[] apeNom = new String[this.dimension];
            String[] numRef = new String[this.dimension];
            String[] clave = new String[this.dimension];
            String[] pin = new String[this.dimension];
            String[] aliasCert = new String[this.dimension];
            boolean[] isDNIeAut = new boolean[this.dimension];
            int[] tipo = new int[this.dimension];
            int i = 0;
            while (i < this.dimension) {
                nif[i] = this.jPNifs[i].getNif();
                apeNom[i] = this.jPNifs[i].getApeNom();
                numRef[i] = this.jPNifs[i].getNumRef();
                clave[i] = this.jPNifs[i].getClave();
                pin[i] = this.jPNifs[i].getPIN();
                tipo[i] = this.jPNifs[i].getAuthType();
                aliasCert[i] = this.jPNifs[i].getAliasCert();
                isDNIeAut[i] = this.jPNifs[i].isDNIeAut();
                ++i;
            }
            dfd.setData(nif, apeNom, tipo, this.dfp, aliasCert, isDNIeAut, numRef, clave, pin, this.directorio);
            dfd.execute();
        }
    }

    private void showProgress() {
        this.getContentPane().remove(this.botonera);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.dimension + 1;
        gridBagConstraints.insets.bottom = 25;
        this.getContentPane().add((Component)this.progress, gridBagConstraints);
        this.getContentPane().validate();
        this.getContentPane().repaint();
        this.pack();
    }

    public void updateProgress(String nif) {
        Enviroment env = Enviroment.getInstance();
        String msg = env.getString("DFDialog.progress1");
        msg = String.valueOf(msg) + " " + nif + ". ";
        msg = String.valueOf(msg) + env.getString("DFDialog.progress2");
        this.progress.setText(msg);
        this.getContentPane().validate();
        this.getContentPane().repaint();
        this.pack();
    }

    @Override
    public void certificateSelected(String alias, String nif, String certInfo) {
        if (this.jPNifs.length > 1 && this.tipoPadre == 3) {
            int i = 1;
            while (i < this.jPNifs.length) {
                this.jPNifs[i].setAliasCert(alias, certInfo);
                ++i;
            }
        }
    }
}

