/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.gui;

import es.gob.aeat.dit.ov.renta.Enviroment;
import es.gob.aeat.dit.ov.renta.PIN24HId;
import es.gob.aeat.dit.ov.renta.gui.CertificateSelectionListener;
import es.gob.aeat.dit.ov.renta.gui.WarningDialog;
import es.gob.aeat.dit.ov.renta.signature.RentaKeyManager;
import es.gob.aeat.dit.ov.renta.util.FixedLengthTextField;
import es.gob.aeat.dit.ov.renta.util.PinTextField;
import es.gob.aeat.dit.ov.renta.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.security.cert.CertificateException;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;

public class ContriPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String CHANGE_CERT_CMD = "cert";
    private static final String GET_PIN_CMD = "pin";
    private JTextField jTFNIF;
    private JTextField jTFAPENOM;
    private JRadioButton jRBBCERT;
    private JRadioButton jRBBREF;
    private JRadioButton jRBBPIN;
    private JTextPane jTPTPREFERENCIA;
    private FixedLengthTextField jTFREF;
    private JTextPane jTPTPPIN;
    private PinTextField jTFPIN;
    private JTextPane jTPCLAVE;
    private PinTextField jTFCLAVE;
    private JButton jButPIN;
    private JLabel jLblCert;
    private JButton jButCert;
    private String title;
    private String aliasCert;
    private boolean isDNIeAut;
    private int tipoPadre;
    private ArrayList<CertificateSelectionListener> csl;
    private JDialog owner;

    public ContriPanel(JDialog owner, int tipoPadre) {
        this.owner = owner;
        this.tipoPadre = tipoPadre;
        this.csl = new ArrayList();
        this.title = "";
        this.aliasCert = null;
        this.isDNIeAut = false;
        this.initComponents();
        this.jTPTPREFERENCIA.setVisible(false);
        this.jTFREF.setVisible(false);
        this.jTPTPPIN.setVisible(false);
        this.jTFPIN.setVisible(false);
        this.jTFCLAVE.setVisible(false);
        this.jTPCLAVE.setVisible(false);
        this.jButPIN.setVisible(false);
        this.jLblCert.setVisible(false);
        this.jButCert.setVisible(false);
        this.jRBBREF.setOpaque(false);
        this.jRBBCERT.setOpaque(false);
        this.jRBBPIN.setOpaque(false);
        if (tipoPadre == 3) {
            this.jRBBREF.setEnabled(false);
            this.jRBBPIN.setEnabled(false);
            this.jRBBCERT.setSelected(true);
            this.logicaRadio();
            RentaKeyManager rkm = RentaKeyManager.getInstance();
            if (rkm.getDefaultAlias() != null && rkm.getDefaultCertInfo() != null) {
                this.setAliasCert(rkm.getDefaultAlias(), rkm.getDefaultCertInfo());
            }
        }
        if (tipoPadre == 2) {
            this.jRBBCERT.setEnabled(false);
            this.jRBBPIN.setEnabled(false);
        }
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.jRBBCERT);
        bg.add(this.jRBBREF);
        bg.add(this.jRBBPIN);
        this.jRBBCERT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContriPanel.this.logicaRadio();
            }
        });
        this.jRBBREF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContriPanel.this.logicaRadio();
            }
        });
        this.jRBBPIN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContriPanel.this.logicaRadio();
            }
        });
    }

    public void addCertificateSelectionListener(CertificateSelectionListener listener) {
        this.csl.add(listener);
    }

    public void disableCertButon() {
        this.jButCert.setEnabled(false);
    }

    public void setNif(String nif) {
        if (nif == null) {
            this.jTFNIF.setText("");
        } else {
            this.jTFNIF.setText(nif.trim());
        }
    }

    public void setApeNom(String apenom) {
        if (apenom == null) {
            this.jTFAPENOM.setText("");
        } else {
            this.jTFAPENOM.setText(apenom.trim());
        }
    }

    public void setTitle(String title) {
        if (title != null && title.trim().length() > 0) {
            this.title = title.trim();
            ((TitledBorder)this.getBorder()).setTitle(this.title);
        }
    }

    public int getAuthType() {
        if (this.jRBBCERT.isSelected()) {
            return 0;
        }
        if (this.jRBBPIN.isSelected()) {
            return 1;
        }
        if (this.jRBBREF.isSelected()) {
            return 2;
        }
        return -1;
    }

    public String getNumRef() {
        return this.jTFREF.getText().trim();
    }

    public String getClave() {
        return this.jTFCLAVE.getText().trim();
    }

    public String getPIN() {
        return this.jTFPIN.getText().trim();
    }

    public String getNif() {
        return this.jTFNIF.getText().trim();
    }

    public PIN24HId getPIN24HId() {
        return new PIN24HId(this.getNif(), this.getClave(), this.getPIN());
    }

    public String getApeNom() {
        return this.jTFAPENOM.getText().trim();
    }

    public String getAliasCert() {
        return this.aliasCert;
    }

    public String getInfoCert() {
        return this.jLblCert.getText().trim();
    }

    public void setAliasCert(String alias, String certStr) {
        RentaKeyManager rkm = RentaKeyManager.getInstance();
        this.aliasCert = alias;
        this.isDNIeAut = this.tipoPadre == 3 ? false : rkm.isCertDNIEAuthentication(alias);
        this.jLblCert.setText(certStr);
        this.jLblCert.setToolTipText(certStr);
    }

    public boolean checkData() {
        Enviroment env = Enviroment.getInstance();
        if (!(this.jRBBCERT.isSelected() || this.jRBBPIN.isSelected() || this.jRBBREF.isSelected())) {
            WarningDialog.showMessageDialog(this, String.valueOf(env.getString("ContriPanel.ErrNoSelec")) + " " + this.jTFNIF.getText(), env.getString("ContriPanel.ErrTitle"));
            return false;
        }
        if (this.jRBBPIN.isSelected()) {
            if (this.jTFCLAVE.getText().trim().length() <= 0) {
                WarningDialog.showMessageDialog(this, String.valueOf(env.getString("ContriPanel.ErrNoClave")) + " " + this.jTFNIF.getText(), env.getString("ContriPanel.ErrTitle"));
                return false;
            }
            if (this.jTFPIN.getText().trim().length() <= 0) {
                WarningDialog.showMessageDialog(this, String.valueOf(env.getString("ContriPanel.ErrNoPIN")) + " " + this.jTFNIF.getText(), env.getString("ContriPanel.ErrTitle"));
                return false;
            }
        } else {
            if (this.jRBBREF.isSelected() && this.jTFREF.getText().trim().length() <= 0) {
                WarningDialog.showMessageDialog(this, String.valueOf(env.getString("ContriPanel.ErrNoRef")) + " " + this.jTFNIF.getText(), env.getString("ContriPanel.ErrTitle"));
                return false;
            }
            if (this.jRBBCERT.isSelected() && this.aliasCert == null) {
                WarningDialog.showMessageDialog(this, String.valueOf(env.getString("ContriPanel.ErrNoCert")) + " " + this.jTFNIF.getText(), env.getString("ContriPanel.ErrTitle"));
                return false;
            }
        }
        return true;
    }

    public void clearCert() {
        this.aliasCert = null;
        this.jLblCert.setText(Enviroment.getInstance().getString("ContriPanel.cert"));
    }

    private void logicaRadio() {
        boolean bREF = this.jRBBREF.isSelected();
        boolean bPIN = this.jRBBPIN.isSelected();
        this.jTPTPREFERENCIA.setVisible(false);
        this.jTFREF.setVisible(false);
        this.jTPTPPIN.setVisible(false);
        this.jTFPIN.setVisible(false);
        this.jTFCLAVE.setVisible(false);
        this.jTPCLAVE.setVisible(false);
        this.jButPIN.setVisible(false);
        this.jLblCert.setVisible(false);
        this.jButCert.setVisible(false);
        if (bREF) {
            this.jTPTPREFERENCIA.setVisible(true);
            this.jTFREF.setVisible(true);
        } else if (bPIN) {
            this.jTPTPPIN.setVisible(true);
            this.jTFPIN.setVisible(true);
            this.jTFCLAVE.setVisible(true);
            this.jTPCLAVE.setVisible(true);
            this.jButPIN.setVisible(true);
        } else {
            this.jLblCert.setVisible(true);
            this.jButCert.setVisible(true);
        }
        this.validate();
        this.owner.pack();
    }

    private void initComponents() {
        this.setName("PinDlg@ContriPanel");
        TitledBorder borde = new TitledBorder(this.title);
        this.setBorder(borde);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        Enviroment env = Enviroment.getInstance();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel lblNIF = new JLabel();
        lblNIF.setText(env.getString("ContriPanel.jTPNIF"));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.bottom = 5;
        this.add((Component)lblNIF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jTFNIF = new JTextField("");
        this.jTFNIF.setName("NIF");
        this.jTFNIF.setColumns(8);
        this.jTFNIF.setToolTipText(env.getString("ContriPanel.jTPNIF"));
        this.jTFNIF.getAccessibleContext().setAccessibleName(env.getString("ContriPanel.jTPNIF"));
        this.jTFNIF.getAccessibleContext().setAccessibleDescription(env.getString("ContriPanel.jTPNIF"));
        this.jTFNIF.setEditable(false);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.right = 20;
        this.add((Component)this.jTFNIF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        JLabel lblApeNom = new JLabel();
        lblApeNom.setText(env.getString("ContriPanel.jTPAPENOM"));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.bottom = 5;
        this.add((Component)lblApeNom, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jTFAPENOM = new JTextField("");
        this.jTFAPENOM.setName("APENOM");
        this.jTFAPENOM.setColumns(30);
        this.jTFAPENOM.setToolTipText(env.getString("ContriPanel.jTPAPENOM"));
        this.jTFAPENOM.getAccessibleContext().setAccessibleName(env.getString("ContriPanel.jTPAPENOM"));
        this.jTFAPENOM.getAccessibleContext().setAccessibleDescription(env.getString("ContriPanel.jTPAPENOM"));
        this.jTFAPENOM.setEditable(false);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.right = 20;
        this.add((Component)this.jTFAPENOM, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        JLabel lblAuten = new JLabel();
        lblAuten.setText(env.getString("ContriPanel.jTPtextpane2"));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.bottom = 5;
        this.add((Component)lblAuten, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jRBBCERT = new JRadioButton(env.getString("ContriPanel.jRBBCERT"));
        this.jRBBCERT.setName("BCERT");
        this.jRBBCERT.setToolTipText(env.getString("ContriPanel.jRBBCERT"));
        this.jRBBCERT.getAccessibleContext().setAccessibleName(env.getString("ContriPanel.jRBBCERT"));
        this.jRBBCERT.getAccessibleContext().setAccessibleDescription(env.getString("ContriPanel.jRBBCERT"));
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.jRBBCERT, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jRBBREF = new JRadioButton(env.getString("ContriPanel.jRBBREF"));
        this.jRBBREF.setName("BREF");
        this.jRBBREF.setToolTipText(env.getString("ContriPanel.jRBBREF"));
        this.jRBBREF.getAccessibleContext().setAccessibleName(env.getString("ContriPanel.jRBBREF"));
        this.jRBBREF.getAccessibleContext().setAccessibleDescription(env.getString("ContriPanel.jRBBREF"));
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.jRBBREF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jRBBPIN = new JRadioButton("Cl@ve PIN");
        this.jRBBPIN.setName("BPIN");
        this.jRBBPIN.setToolTipText(env.getString("ContriPanel.jRBBPIN"));
        this.jRBBPIN.getAccessibleContext().setAccessibleName(env.getString("ContriPanel.jRBBPIN"));
        this.jRBBPIN.getAccessibleContext().setAccessibleDescription(env.getString("ContriPanel.jRBBPIN"));
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.jRBBPIN, gridBagConstraints);
        JPanel panelRef = new JPanel();
        panelRef.setOpaque(false);
        panelRef.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets.bottom = 5;
        this.add((Component)panelRef, gridBagConstraints);
        this.jTPTPREFERENCIA = new JTextPane();
        this.jTPTPREFERENCIA.setName("TPREFERENCIA");
        this.jTPTPREFERENCIA.setText(env.getString("ContriPanel.jTPREFERENCIA"));
        this.jTPTPREFERENCIA.setEditable(false);
        this.jTPTPREFERENCIA.setFocusCycleRoot(false);
        this.jTPTPREFERENCIA.setFocusable(false);
        this.jTPTPREFERENCIA.setRequestFocusEnabled(false);
        this.jTPTPREFERENCIA.setOpaque(false);
        this.jTPTPREFERENCIA.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        panelRef.add((Component)this.jTPTPREFERENCIA, gridBagConstraints);
        this.jTFREF = new FixedLengthTextField(12);
        this.jTFREF.setName("REF");
        this.jTFREF.setColumns(12);
        this.jTFREF.setToolTipText(env.getString("ContriPanel.jTFREFERENCIA"));
        this.jTFREF.getAccessibleContext().setAccessibleName(env.getString("ContriPanel.jTFREFERENCIA"));
        this.jTFREF.getAccessibleContext().setAccessibleDescription(env.getString("ContriPanel.jTFREFERENCIA"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.right = 30;
        panelRef.add((Component)this.jTFREF, gridBagConstraints);
        JPanel panelPin = new JPanel();
        panelPin.setOpaque(false);
        panelPin.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets.bottom = 5;
        this.add((Component)panelPin, gridBagConstraints);
        this.jButPIN = new JButton(env.getString("ContriPanel.linkPin"));
        this.jButPIN.setActionCommand(GET_PIN_CMD);
        this.jButPIN.addActionListener(this);
        this.jButPIN.setOpaque(false);
        Insets margin = this.jButPIN.getMargin();
        margin.bottom = 1;
        margin.top = 1;
        margin.left /= 2;
        margin.right = margin.left / 2;
        this.jButPIN.setMargin(margin);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.right = 10;
        panelPin.add((Component)this.jButPIN, gridBagConstraints);
        this.jTPCLAVE = new JTextPane();
        this.jTPCLAVE.setName("TPCLAVE");
        this.jTPCLAVE.setText(env.getString("ContriPanel.jTPCLAVE"));
        this.jTPCLAVE.setEditable(false);
        this.jTPCLAVE.setFocusCycleRoot(false);
        this.jTPCLAVE.setFocusable(false);
        this.jTPCLAVE.setRequestFocusEnabled(false);
        this.jTPCLAVE.setOpaque(false);
        this.jTPCLAVE.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        panelPin.add((Component)this.jTPCLAVE, gridBagConstraints);
        this.jTFCLAVE = new PinTextField(4);
        this.jTFCLAVE.setName("CLAVE");
        this.jTFCLAVE.setColumns(4);
        this.jTFCLAVE.setToolTipText(env.getString("ContriPanel.jTFCLAVE"));
        this.jTFCLAVE.getAccessibleContext().setAccessibleName(env.getString("ContriPanel.jTFCLAVE"));
        this.jTFCLAVE.getAccessibleContext().setAccessibleDescription(env.getString("ContriPanel.jTFCLAVE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.right = 2;
        panelPin.add((Component)this.jTFCLAVE, gridBagConstraints);
        this.jTPTPPIN = new JTextPane();
        this.jTPTPPIN.setName("TPPIN");
        this.jTPTPPIN.setText(env.getString("ContriPanel.jTPPIN"));
        this.jTPTPPIN.setEditable(false);
        this.jTPTPPIN.setFocusCycleRoot(false);
        this.jTPTPPIN.setFocusable(false);
        this.jTPTPPIN.setRequestFocusEnabled(false);
        this.jTPTPPIN.setOpaque(false);
        this.jTPTPPIN.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        panelPin.add((Component)this.jTPTPPIN, gridBagConstraints);
        this.jTFPIN = new PinTextField(3);
        this.jTFPIN.setName("PIN");
        this.jTFPIN.setColumns(3);
        this.jTFPIN.setToolTipText(env.getString("ContriPanel.jTFPIN"));
        this.jTFPIN.getAccessibleContext().setAccessibleName(env.getString("ContriPanel.jTFPIN"));
        this.jTFPIN.getAccessibleContext().setAccessibleDescription(env.getString("ContriPanel.jTFPIN"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.right = 10;
        panelPin.add((Component)this.jTFPIN, gridBagConstraints);
        JPanel panelCert = new JPanel();
        panelCert.setOpaque(false);
        panelCert.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets.bottom = 5;
        this.add((Component)panelCert, gridBagConstraints);
        ImageIcon img = new ImageIcon(this.getClass().getResource("/es/gob/aeat/dit/ov/renta/resources/cert.png"));
        this.jLblCert = new JLabel(env.getString("ContriPanel.cert"), img, 0);
        this.jLblCert.setVerticalTextPosition(0);
        this.jLblCert.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.right = 10;
        panelCert.add((Component)this.jLblCert, gridBagConstraints);
        this.jButCert = new JButton(env.getString("ContriPanel.JButCert"));
        this.jButCert.setOpaque(false);
        margin = this.jButCert.getMargin();
        margin.bottom = 1;
        margin.top = 1;
        margin.left /= 2;
        margin.right = margin.left / 2;
        this.jButCert.setMargin(margin);
        this.jButCert.setVisible(false);
        this.jButCert.setActionCommand(CHANGE_CERT_CMD);
        this.jButCert.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.right = 5;
        panelCert.add((Component)this.jButCert, gridBagConstraints);
    }

    public void disableAll() {
        this.jRBBCERT.setEnabled(false);
        this.jRBBPIN.setEnabled(false);
        this.jRBBREF.setEnabled(false);
        this.jTFCLAVE.setEnabled(false);
        this.jTFPIN.setEnabled(false);
        this.jTFREF.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block8: {
            Enviroment env;
            block7: {
                env = Enviroment.getInstance();
                if (!e.getActionCommand().equals(CHANGE_CERT_CMD)) break block7;
                RentaKeyManager rkm = RentaKeyManager.getInstance();
                String alias = null;
                try {
                    alias = rkm.selectAlias();
                }
                catch (CertificateException e1) {
                    String msg = env.getString("RentaKeyManager.EmptyKS");
                    msg = String.valueOf(msg) + Util.getDefaultBrowserString();
                    WarningDialog.showMessageDialog(this, msg, env.getString("ContriPanel.ErrTitle"));
                }
                if (alias == null) break block8;
                if (rkm.isCertDNIEFirma(alias)) {
                    WarningDialog.showMessageDialog(this, env.getString("RentaKeyManager.ErrDniF"), env.getString("ContriPanel.ErrTitle"));
                } else {
                    String certStr = rkm.getCertCN(alias);
                    this.isDNIeAut = rkm.isCertDNIEAuthentication(alias);
                    this.aliasCert = alias;
                    this.jLblCert.setText(certStr);
                    this.jLblCert.setToolTipText(certStr);
                    int i = 0;
                    while (i < this.csl.size()) {
                        this.csl.get(i).certificateSelected(this.aliasCert, this.getNif(), certStr);
                        ++i;
                    }
                }
                break block8;
            }
            if (!e.getActionCommand().equals(GET_PIN_CMD)) break block8;
            try {
                String url = "#";
                url = env.getURL(3);
                url = String.valueOf(url) + "nif=" + this.jTFNIF.getText().trim();
                Util.showLinkInBrowser(this, url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setAuthMethod(int authMethod) {
        if (authMethod == 0 && !this.jRBBCERT.isSelected()) {
            this.jRBBCERT.setSelected(true);
            this.logicaRadio();
        } else if (authMethod == 1 && !this.jRBBPIN.isSelected()) {
            this.jRBBPIN.setSelected(true);
            this.logicaRadio();
        } else if (authMethod == 2 && !this.jRBBREF.isSelected()) {
            this.jRBBREF.setSelected(true);
            this.logicaRadio();
        }
    }

    public boolean isDNIeAut() {
        return this.isDNIeAut;
    }
}

