/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta.df;

import es.gob.aeat.dit.ov.renta.Enviroment;
import es.gob.aeat.dit.ov.renta.PIN24HId;
import es.gob.aeat.dit.ov.renta.RentaException;
import es.gob.aeat.dit.ov.renta.gui.DFDialog;
import es.gob.aeat.dit.ov.renta.gui.pt.DNIeDialog;
import es.gob.aeat.dit.ov.renta.http.DFHttpResponse;
import es.gob.aeat.dit.ov.renta.http.HttpHandler;
import es.gob.aeat.dit.ov.renta.http.HttpResponse;
import es.gob.aeat.dit.ov.renta.http.IntranetAuthenticator;
import es.gob.aeat.dit.ov.renta.http.PIN24HAuthenticator;
import es.gob.aeat.dit.ov.renta.signature.RentaKeyManager;
import java.awt.Dialog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.util.logging.Level;

public class DFRetriever {
    private Enviroment env;
    private DFDialog owner;
    public static final String ERROR_DNIE = "ERROR_DNIE";

    public DFRetriever(DFDialog dlg) {
        this.owner = dlg;
        this.env = Enviroment.getInstance();
    }

    public String getDFbyCert(String nif, String apellido1, boolean dfp, String aliasCert, boolean isDNIeAut, boolean reintentarDNIe, File dir) throws RentaException {
        String filename = this.getFileForDF(nif, dfp);
        this.getDFbyCertificate(nif, apellido1, dfp, aliasCert, isDNIeAut, reintentarDNIe, new File(dir, filename));
        return filename;
    }

    public String getDFbyCert(String nif, String apellido1, boolean dfp, String aliasCert, boolean isDNIeAut, boolean reintentarDNIe) throws RentaException {
        return this.getDFbyCertificate(nif, apellido1, dfp, aliasCert, isDNIeAut, reintentarDNIe, null);
    }

    private String getDFbyCertificate(String nif, String apellido1, boolean dfp, String aliasCert, boolean isDNIeAut, boolean reintentarDNIe, File destFile) throws RentaException {
        String out;
        String url;
        IntranetAuthenticator ia;
        if (!this.isSet(nif)) {
            throw new RentaException(this.env.getString("DFRetriever.ErrNifVacio"));
        }
        boolean continuar = true;
        while (continuar) {
            RentaKeyManager.INIT_CAPI = true;
            PrivateKey pk = RentaKeyManager.getInstance().getPrivateKey(aliasCert);
            RentaKeyManager.INIT_CAPI = false;
            if (pk != null) {
                continuar = false;
                continue;
            }
            if (isDNIeAut) {
                if (reintentarDNIe) {
                    DNIeDialog dnied = new DNIeDialog((Dialog)this.owner, nif);
                    dnied.showDialog();
                    if (dnied.getResult() != 1) continue;
                    throw new RentaException(this.env.getString("DFRetriever.ErrCancelar"));
                }
                throw new RentaException(ERROR_DNIE);
            }
            continuar = false;
        }
        RentaKeyManager.getInstance().setAliasSSL(aliasCert);
        String msgCert = "Certificado seleccionado para descarga DF para el nif: " + nif + System.getProperty("line.separator");
        msgCert = String.valueOf(msgCert) + RentaKeyManager.getInstance().getCertInfo(aliasCert);
        this.env.getLog().logp(Level.INFO, this.getClass().getName(), "getDFbyCert", msgCert);
        if (this.env.isIntranet() && !(ia = new IntranetAuthenticator()).authenticate(aliasCert, this.owner)) {
            throw new RentaException("Intranet: " + ia.getError());
        }
        try {
            url = this.env.getURL(0, this.env.isIntranet() ? 3 : 0, 100);
        }
        catch (FileNotFoundException e) {
            throw new RentaException(this.env.getString("Enviroment.ErrFileEnt1"));
        }
        catch (IOException e) {
            throw new RentaException(this.env.getString("Enviroment.ErrFileEnt2"), e.getMessage());
        }
        catch (Exception e) {
            throw new RentaException(this.env.getString("Enviroment.ErrFileEnt3"), "DF_CER");
        }
        try {
            HttpHandler hh = new HttpHandler(url);
            this.setPostParamsCert(hh, nif, apellido1, dfp);
            this.env.getLog().logp(Level.INFO, this.getClass().getName(), "getDFbyCertificate", hh.toString());
            HttpResponse resp = hh.doPost();
            Object dest = destFile != null ? destFile : new StringWriter();
            this.processResponse(dest, new DFHttpResponse(resp));
            out = destFile != null ? destFile.getName() : dest.toString();
        }
        catch (MalformedURLException e) {
            throw new RentaException(String.valueOf(this.env.getString("DFRetriever.ErrConexion")) + " (-1)");
        }
        catch (UnknownHostException uhe) {
            this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "getDFbyCertificate", "Error en comunicaci\u00f3n", uhe);
            throw new RentaException(this.env.getString("DFRetriever.ErrProxy"));
        }
        catch (IOException e) {
            this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "getDFbyCertificate", "Error en comunicaci\u00f3n", e);
            throw new RentaException(String.valueOf(this.env.getString("DFRetriever.ErrConexion")) + ": ", e.getMessage());
        }
        return out;
    }

    private void setPostParamsCert(HttpHandler hh, String nif, String apellido1, boolean dfp) {
        if (this.env.isIntranet()) {
            hh.addPOSTParam("MIC", "PLC");
            hh.addPOSTParam("IDI", "ES");
            hh.addPOSTParam("PDP", dfp ? "S" : " ");
            hh.addPOSTParam("REF", "");
            hh.addPOSTParam("NIF", nif);
            hh.addPOSTParam("APE", apellido1);
            hh.addPOSTParam("DIR", "");
            hh.addPOSTParam("FIN", "");
        } else {
            hh.addPOSTParam("MIC", "PIC");
            hh.addPOSTParam("IDI", this.env.getIdioma().toUpperCase());
            hh.addPOSTParam("PDP", dfp ? "S" : "");
            hh.addPOSTParam("EJF", "2014");
            hh.addPOSTParam("NIF", nif);
            hh.addPOSTParam("APE", apellido1);
            hh.addPOSTParam("REF", "");
            hh.addPOSTParam("DIR", "");
            hh.addPOSTParam("FIN", "F");
        }
    }

    public String getDFbyPIN24H(PIN24HId pinId, String apellido1, boolean dfp, File dir) throws RentaException {
        String filename = this.getFileForDF(pinId.getNif(), dfp);
        this.getDFbyPIN(pinId, apellido1, dfp, new File(dir, filename));
        return filename;
    }

    public String getDFbyPIN24H(PIN24HId pinId, String apellido1, boolean dfp) throws RentaException {
        return this.getDFbyPIN(pinId, apellido1, dfp, null);
    }

    private String getDFbyPIN(PIN24HId pinId, String apellido1, boolean dfp, File destFile) throws RentaException {
        String out;
        String url;
        if (!this.isSet(pinId.getNif())) {
            throw new RentaException(this.env.getString("DFRetriever.ErrNifVacio"));
        }
        if (!this.isSet(apellido1)) {
            throw new RentaException(this.env.getString("DFRetriever.ErrApeVacio"));
        }
        if (!this.isSet(pinId.getClave())) {
            throw new RentaException(this.env.getString("DFRetriever.ErrClaVacio"));
        }
        if (!this.isSet(pinId.getPin())) {
            throw new RentaException(this.env.getString("DFRetriever.ErrPinVacio"));
        }
        PIN24HAuthenticator pa = new PIN24HAuthenticator();
        if (!pa.authenticate(pinId.getNif(), pinId.getClave(), pinId.getPin())) {
            throw new RentaException("PIN24H: " + pa.getError());
        }
        try {
            url = this.env.getURL(0, 1, 100);
        }
        catch (FileNotFoundException e) {
            throw new RentaException(this.env.getString("Enviroment.ErrFileEnt1"));
        }
        catch (IOException e) {
            throw new RentaException(this.env.getString("Enviroment.ErrFileEnt2"), e.getMessage());
        }
        catch (Exception e) {
            throw new RentaException(this.env.getString("Enviroment.ErrFileEnt3"), "DF_PIN");
        }
        try {
            HttpHandler hh = new HttpHandler(url);
            hh.addPOSTParam("MIC", "PIF");
            hh.addPOSTParam("IDI", this.env.getIdioma().toUpperCase());
            hh.addPOSTParam("PDP", dfp ? "S" : "");
            hh.addPOSTParam("EJF", "2014");
            hh.addPOSTParam("NIF", pinId.getNif());
            hh.addPOSTParam("APE", apellido1);
            hh.addPOSTParam("REF", "");
            hh.addPOSTParam("DIR", "");
            hh.addPOSTParam("FIN", "F");
            this.env.getLog().logp(Level.INFO, this.getClass().getName(), "getDFbyPIN", hh.toString());
            HttpResponse resp = hh.doPost();
            Object dest = destFile != null ? destFile : new StringWriter();
            this.processResponse(dest, new DFHttpResponse(resp));
            out = destFile != null ? destFile.getName() : dest.toString();
        }
        catch (MalformedURLException e) {
            throw new RentaException(String.valueOf(this.env.getString("DFRetriever.ErrConexion")) + " (-1)");
        }
        catch (UnknownHostException uhe) {
            this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "getDFbyPIN", "Error en comunicaci\u00f3n", uhe);
            throw new RentaException(this.env.getString("DFRetriever.ErrProxy"));
        }
        catch (IOException e) {
            this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "getDFbyPIN", "Error en comunicaci\u00f3n", e);
            throw new RentaException(String.valueOf(this.env.getString("DFRetriever.ErrConexion")) + ": ", e.getMessage());
        }
        return out;
    }

    public String getDFbyNumRef(String nif, String apellido1, String numRef, boolean dfp, File dir) throws RentaException {
        String filename = this.getFileForDF(nif, dfp);
        this.getDFbyRef(nif, apellido1, numRef, dfp, new File(dir, filename));
        return filename;
    }

    public String getDFbyNumRef(String nif, String apellido1, String numRef, boolean dfp) throws RentaException {
        return this.getDFbyRef(nif, apellido1, numRef, dfp, null);
    }

    private String getDFbyRef(String nif, String apellido1, String numRef, boolean dfp, File destFile) throws RentaException {
        String out;
        String url;
        if (!this.isSet(nif)) {
            throw new RentaException(this.env.getString("DFRetriever.ErrNifVacio"));
        }
        if (!this.isSet(apellido1)) {
            throw new RentaException(this.env.getString("DFRetriever.ErrApeVacio"));
        }
        if (!this.isSet(numRef)) {
            throw new RentaException(this.env.getString("DFRetriever.ErrRefVacio"));
        }
        try {
            url = this.env.getURL(0, 2, 100);
        }
        catch (FileNotFoundException e) {
            throw new RentaException(this.env.getString("Enviroment.ErrFileEnt1"));
        }
        catch (IOException e) {
            throw new RentaException(this.env.getString("Enviroment.ErrFileEnt2"), e.getMessage());
        }
        catch (Exception e) {
            throw new RentaException(this.env.getString("Enviroment.ErrFileEnt3"), "DF_REF");
        }
        try {
            HttpHandler hh = new HttpHandler(url);
            hh.addPOSTParam("MIC", "PIS");
            hh.addPOSTParam("IDI", this.env.getIdioma().toUpperCase());
            hh.addPOSTParam("PDP", dfp ? "S" : "");
            hh.addPOSTParam("EJF", "2014");
            hh.addPOSTParam("NIF", nif);
            hh.addPOSTParam("APE", apellido1);
            hh.addPOSTParam("REF", numRef);
            hh.addPOSTParam("DIR", "");
            hh.addPOSTParam("FIN", "F");
            this.env.getLog().logp(Level.INFO, this.getClass().getName(), "getDFbyRef", hh.toString());
            HttpResponse resp = hh.doPost();
            Object dest = destFile != null ? destFile : new StringWriter();
            this.processResponse(dest, new DFHttpResponse(resp));
            out = destFile != null ? destFile.getName() : dest.toString();
        }
        catch (MalformedURLException e) {
            throw new RentaException(String.valueOf(this.env.getString("DFRetriever.ErrConexion")) + " (-1)");
        }
        catch (UnknownHostException uhe) {
            this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "getDFbyRef", "Error en comunicaci\u00f3n", uhe);
            throw new RentaException(this.env.getString("DFRetriever.ErrProxy"));
        }
        catch (IOException e) {
            this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "getDFbyRef", "Error en comunicaci\u00f3n", e);
            throw new RentaException(String.valueOf(this.env.getString("DFRetriever.ErrConexion")) + ": ", e.getMessage());
        }
        return out;
    }

    private String getFileForDF(String nif, boolean dfp) {
        String ext = ".df";
        if (dfp) {
            ext = ".dfp";
        }
        return String.valueOf(nif.toUpperCase()) + ext;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processResponse(Object dest, DFHttpResponse resp) throws RentaException {
        if (resp.getResponseCode() != 200) {
            throw new RentaException(this.env.getString("DFRetriever.ErrConexion"), "HTTP " + resp.getResponseCode());
        }
        if (resp.isCICSError()) {
            this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "processResponse - Error CICS", resp.getContentAsText());
            throw new RentaException(this.env.getString("DFRetriever.ErrResp"), "Error CICS: " + resp.getCICSError());
        }
        if (resp.isError()) {
            throw new RentaException(resp.getError());
        }
        if (!resp.isOK()) {
            this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "processResponse", resp.getContentAsText());
            throw new RentaException(this.env.getString("DFRetriever.ErrResp"), this.env.getString("DFRetriever.ErrResp2"));
        }
        String df = resp.getDF();
        if (df == null) {
            this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "processResponse", "No se encuentra el tag de cierre de datos fiscales");
            throw new RentaException(this.env.getString("DFRetriever.ErrRespOk"));
        }
        if (dest instanceof File) {
            this.writeToFile((File)dest, df.getBytes(Charset.forName("iso-8859-15")));
            return;
        }
        this.writeToString((StringWriter)dest, df);
    }

    private void writeToFile(File f, byte[] data) throws RentaException {
        try {
            FileOutputStream fout = new FileOutputStream(f);
            fout.write(data);
            fout.close();
        }
        catch (FileNotFoundException e) {
            this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "writeToFile", "Fichero no encontrado " + f.getAbsolutePath(), e);
            throw new RentaException(this.env.getString("DFRetriever.ErrPath"));
        }
        catch (IOException e) {
            this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "writeToFile", "Error escribiendo en fichero " + f.getAbsolutePath(), e);
            throw new RentaException(this.env.getString("DFRetriever.ErrWriFile"));
        }
    }

    private void writeToString(StringWriter w, String df) throws RentaException {
        try {
            w.write(df);
            w.close();
        }
        catch (IOException e) {
            this.env.getLog().logp(Level.SEVERE, this.getClass().getName(), "writeToString", "Error escribiendo en string", e);
            throw new RentaException(this.env.getString("DFRetriever.ErrWriFile"), e.getMessage());
        }
    }

    private boolean isSet(String param) {
        return param != null && param.trim().length() > 0;
    }
}

