/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta;

import es.gob.aeat.dit.ov.renta.Enviroment;
import es.gob.aeat.dit.ov.renta.RentaException;
import es.gob.aeat.dit.ov.renta.gui.DFDialog;
import es.gob.aeat.dit.ov.renta.gui.PTDialog;
import es.gob.aeat.dit.ov.renta.gui.pt.AvisoDialog;
import es.gob.aeat.dit.ov.renta.gui.pt.PTOkDialog;
import es.gob.aeat.dit.ov.renta.gui.pt.PTTwinDialog;
import es.gob.aeat.dit.ov.renta.pt.Declaracion;
import es.gob.aeat.dit.ov.renta.signature.RentaKeyManager;
import es.gob.aeat.dit.ov.renta.util.Util;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.util.logging.Level;

public class RentaDFPT {
    public static final String MODULE_VERSION = "1.02";
    private static final int MAX_NIFS_DF = 6;
    private static final int MAX_NIFS_PT = 2;
    public static final int PADRE_CONTRIBUYENTE = 1;
    public static final int PADRE_EECC_EXT = 2;
    public static final int PADRE_EECC_INT = 3;

    public String[][] getDatosFiscales(Object owner, Color color, String[] nifs, String[] apeNom, String[] tipo, String[] desc, String directorioDF, int tipoPADRE, String idioma) throws IllegalArgumentException {
        if (color != null) {
            Enviroment.setColorBase(color);
        }
        Enviroment.getInstance().setIntranet(tipoPADRE == 3);
        if (nifs == null || nifs.length < 1 || nifs.length > 6) {
            throw new IllegalArgumentException("N\u00famero de nifs err\u00f3neo");
        }
        if (apeNom == null || apeNom.length != nifs.length) {
            throw new IllegalArgumentException("N\u00famero de apellidos err\u00f3neo");
        }
        if (tipo == null || tipo.length != nifs.length) {
            throw new IllegalArgumentException("N\u00famero de tipo de datos fiscales err\u00f3neo");
        }
        if (directorioDF == null || directorioDF.trim().length() <= 0) {
            throw new IllegalArgumentException("Directorio de destino err\u00f3neo");
        }
        File dir = new File(directorioDF.trim());
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IllegalArgumentException("Directorio de destino no existe");
        }
        this.setIdioma(idioma);
        this.setLogDir(dir);
        String info = "\n---- Version 1.02";
        info = String.valueOf(info) + "\n  owner: " + owner;
        info = String.valueOf(info) + "\n color: " + color;
        info = String.valueOf(info) + "\n  nifs: {";
        int i = 0;
        while (i < nifs.length) {
            if (i != 0) {
                info = String.valueOf(info) + ", ";
            }
            info = String.valueOf(info) + nifs[i];
            ++i;
        }
        info = String.valueOf(info) + "}";
        info = String.valueOf(info) + "\napeNom: {";
        i = 0;
        while (i < apeNom.length) {
            if (i != 0) {
                info = String.valueOf(info) + ", ";
            }
            info = String.valueOf(info) + apeNom[i];
            ++i;
        }
        info = String.valueOf(info) + "}";
        info = String.valueOf(info) + "\n   tipo: {";
        i = 0;
        while (i < tipo.length) {
            if (i != 0) {
                info = String.valueOf(info) + ", ";
            }
            info = String.valueOf(info) + tipo[i];
            ++i;
        }
        info = String.valueOf(info) + "}";
        info = String.valueOf(info) + "\n   desc: {";
        i = 0;
        while (i < desc.length) {
            if (i != 0) {
                info = String.valueOf(info) + ", ";
            }
            info = String.valueOf(info) + desc[i];
            ++i;
        }
        info = String.valueOf(info) + "}";
        info = String.valueOf(info) + "\ndirectorioDF: " + directorioDF;
        info = String.valueOf(info) + "\ntipoPADRE: " + tipoPADRE;
        info = String.valueOf(info) + "\nidioma: " + idioma + "\n";
        Enviroment.getInstance().getLog().log(Level.INFO, info);
        DFDialog diag = owner == null ? new DFDialog(nifs.length, tipoPADRE) : (owner instanceof Frame ? new DFDialog((Frame)owner, nifs.length, tipoPADRE) : (owner instanceof Dialog ? new DFDialog((Dialog)owner, nifs.length, tipoPADRE) : (owner instanceof Window ? new DFDialog((Window)owner, nifs.length, tipoPADRE) : new DFDialog(nifs.length, tipoPADRE))));
        diag.setData(nifs, apeNom, desc, tipo, directorioDF);
        diag.showDialog();
        String[][] result = diag.getResult();
        if (result != null && !result[0][1].equals("01:Cancelado")) {
            String msg = "Resultado DF:" + System.getProperty("line.separator");
            int i2 = 0;
            while (i2 < result.length) {
                msg = String.valueOf(msg) + result[i2][0] + " --> " + result[i2][1] + System.getProperty("line.separator");
                ++i2;
            }
            Enviroment.getInstance().getLog().log(Level.INFO, msg);
        }
        return result;
    }

    public boolean[] doPresentacion(Object owner, Color color, String[] nifs, String[] apeNom, String[] desc, String[] pathDeclas, String versionPADRE, int tipoPADRE, String idioma) throws IllegalArgumentException {
        if (color != null) {
            Enviroment.setColorBase(color);
        }
        Enviroment.getInstance().setIntranet(tipoPADRE == 3);
        if (nifs == null || nifs.length < 1 || nifs.length > 2) {
            throw new IllegalArgumentException("N\u00famero de nifs err\u00f3neo");
        }
        if (apeNom == null || apeNom.length != nifs.length) {
            throw new IllegalArgumentException("N\u00famero de apellidos err\u00f3neo");
        }
        if (pathDeclas == null || pathDeclas.length > nifs.length) {
            throw new IllegalArgumentException("N\u00famero de declaraciones mayor que el n\u00famero de nifs");
        }
        this.setIdioma(idioma);
        if (pathDeclas.length >= 1) {
            File logDir = new File(pathDeclas[0]);
            this.setLogDir(logDir.getParentFile());
        }
        String info = "\n---- Version 1.02";
        info = String.valueOf(info) + "\n  owner: " + owner;
        info = String.valueOf(info) + "\n color: " + color;
        info = String.valueOf(info) + "\n  nifs: {";
        int i = 0;
        while (i < nifs.length) {
            if (i != 0) {
                info = String.valueOf(info) + ", ";
            }
            info = String.valueOf(info) + nifs[i];
            ++i;
        }
        info = String.valueOf(info) + "}";
        info = String.valueOf(info) + "\napeNom: {";
        i = 0;
        while (i < apeNom.length) {
            if (i != 0) {
                info = String.valueOf(info) + ", ";
            }
            info = String.valueOf(info) + apeNom[i];
            ++i;
        }
        info = String.valueOf(info) + "}";
        info = String.valueOf(info) + "\n   desc: {";
        i = 0;
        while (i < desc.length) {
            if (i != 0) {
                info = String.valueOf(info) + ", ";
            }
            info = String.valueOf(info) + desc[i];
            ++i;
        }
        info = String.valueOf(info) + "}";
        info = String.valueOf(info) + "\n   pathDeclas: {";
        i = 0;
        while (i < pathDeclas.length) {
            if (i != 0) {
                info = String.valueOf(info) + ", ";
            }
            info = String.valueOf(info) + pathDeclas[i];
            ++i;
        }
        info = String.valueOf(info) + "}";
        info = String.valueOf(info) + "\nversionPADRE: " + versionPADRE;
        info = String.valueOf(info) + "\ntipoPADRE: " + tipoPADRE;
        info = String.valueOf(info) + "\nidioma: " + idioma + "\n";
        Enviroment.getInstance().getLog().log(Level.INFO, info);
        Declaracion[] declaraciones = new Declaracion[pathDeclas.length];
        String[] paths = new String[pathDeclas.length];
        int i2 = 0;
        while (i2 < pathDeclas.length) {
            File f = new File(pathDeclas[i2]);
            if (!f.exists() || !f.isFile()) {
                throw new IllegalArgumentException("Fichero de declaraci\u00f3n no exite: " + f.getAbsolutePath());
            }
            paths[i2] = f.getParentFile().getAbsolutePath();
            try {
                declaraciones[i2] = Declaracion.getDeclaraci\u00f3n(new String(Util.readFile(f), "iso-8859-15"), 2014, 100);
                if (!declaraciones[i2].validate()) {
                    throw new RentaException("Declaraci\u00f3n no cumple las validaciones m\u00ednimas.");
                }
            }
            catch (Exception e) {
                Enviroment.getInstance().getLog().logp(Level.SEVERE, this.getClass().getName(), "doPresentacion", "Error leyendo declaracion (" + f.getAbsolutePath() + ")", e);
                throw new IllegalArgumentException("Fichero de declaraci\u00f3n no v\u00e1lido: " + f.getAbsolutePath() + ".\n\n" + e.getMessage());
            }
            ++i2;
        }
        RentaKeyManager.getInstance().setParentComponent(owner);
        boolean[] result = new boolean[pathDeclas.length];
        if (declaraciones.length == 1) {
            result[0] = this.presentaIndividual(owner, versionPADRE, tipoPADRE, declaraciones[0], paths[0]);
        } else {
            result = this.presentaCompensar(owner, versionPADRE, tipoPADRE, declaraciones, paths);
        }
        info = "Resultado presentaci\u00f3n 100: {";
        int i3 = 0;
        while (i3 < result.length) {
            if (i3 != 0) {
                info = String.valueOf(info) + ", ";
            }
            info = String.valueOf(info) + result[i3];
            ++i3;
        }
        info = String.valueOf(info) + "}\n";
        Enviroment.getInstance().getLog().log(Level.INFO, info);
        return result;
    }

    public boolean doPresentacion714(Object owner, Color color, String nif, String apeNom, String desc, String pathDecla, String versionPADRE, int tipoPADRE, String idioma) throws IllegalArgumentException {
        Declaracion declaracion;
        if (color != null) {
            Enviroment.setColorBase(color);
        }
        Enviroment.getInstance().setIntranet(tipoPADRE == 3);
        if (nif == null) {
            throw new IllegalArgumentException("No se proporcion\u00f3 el nif");
        }
        if (apeNom == null) {
            throw new IllegalArgumentException("No se proporcion\u00f3 el apellido");
        }
        if (pathDecla == null) {
            throw new IllegalArgumentException("No se proporcion\u00f3 el path de la declaraci\u00f3n");
        }
        this.setIdioma(idioma);
        File f = new File(pathDecla);
        if (!f.exists() || !f.isFile()) {
            throw new IllegalArgumentException("Fichero de declaraci\u00f3n no exite: " + f.getAbsolutePath());
        }
        String path = f.getParentFile().getAbsolutePath();
        this.setLogDir(f.getParentFile());
        String info = "\n---- Version 1.02";
        info = String.valueOf(info) + "\n  owner: " + owner;
        info = String.valueOf(info) + "\n color: " + color;
        info = String.valueOf(info) + "\n  nif: " + nif;
        info = String.valueOf(info) + "\napeNom: " + apeNom;
        info = String.valueOf(info) + "\n   desc: " + desc;
        info = String.valueOf(info) + "\n   pathDeclas: " + pathDecla;
        info = String.valueOf(info) + "\nversionPADRE: " + versionPADRE;
        info = String.valueOf(info) + "\ntipoPADRE: " + tipoPADRE;
        info = String.valueOf(info) + "\nidioma: " + idioma + "\n";
        Enviroment.getInstance().getLog().log(Level.INFO, info);
        try {
            declaracion = Declaracion.getDeclaraci\u00f3n(new String(Util.readFile(f), "iso-8859-15"), 2014, 714);
            if (!declaracion.validate()) {
                throw new RentaException("Declaraci\u00f3n no cumple las validaciones m\u00ednimas.");
            }
        }
        catch (Exception e) {
            Enviroment.getInstance().getLog().logp(Level.SEVERE, this.getClass().getName(), "doPresentacion", "Error leyendo declaracion (" + f.getAbsolutePath() + ")", e);
            throw new IllegalArgumentException("Fichero de declaraci\u00f3n no v\u00e1lido: " + f.getAbsolutePath() + ".\n\n" + e.getMessage());
        }
        RentaKeyManager.getInstance().setParentComponent(owner);
        boolean resultado = this.presentaIndividual(owner, versionPADRE, tipoPADRE, declaracion, path);
        Enviroment.getInstance().getLog().log(Level.INFO, "Resultado presentaci\u00f3n 714: " + resultado + "\n");
        return resultado;
    }

    private boolean presentaIndividual(Object owner, String versionPADRE, int tipoPADRE, Declaracion decla, String path) {
        int dimension = 1;
        if (decla.isConjunta()) {
            dimension = 2;
        }
        String[] cNifs = new String[dimension];
        String[] cApeNom = new String[dimension];
        String[] cDesc = new String[dimension];
        cNifs[0] = decla.getNifDeclarante();
        cApeNom[0] = decla.getApeNomDeclarante();
        cDesc[0] = "Declarante";
        if (dimension == 2) {
            cNifs[1] = decla.getNifConyuge();
            cApeNom[1] = decla.getApeNomConyuge();
            cDesc[1] = "C\u00f3nyuge";
        }
        PTDialog diag = this.getDialogPT(owner, versionPADRE, tipoPADRE, dimension);
        diag.setData(cNifs, cApeNom, cDesc, decla, path);
        diag.showDialog(2);
        return diag.getResultDialog() instanceof PTOkDialog;
    }

    private boolean[] presentaCompensar(Object owner, String versionPADRE, int tipoPADRE, Declaracion[] declaraciones, String[] paths) {
        boolean[] result = new boolean[2];
        AvisoDialog avisoDia = this.getDialogAviso(owner);
        avisoDia.addContribuyentes(String.valueOf(declaraciones[0].getNifDeclarante()) + " - " + declaraciones[0].getApeNomDeclarante(), String.valueOf(declaraciones[1].getNifDeclarante()) + " - " + declaraciones[1].getApeNomDeclarante());
        avisoDia.showDialog();
        if (avisoDia.getResultado() == 1) {
            PTDialog diagDeclarante = this.getDialogPT(owner, versionPADRE, tipoPADRE, 1);
            diagDeclarante.setData(new String[]{declaraciones[0].getNifDeclarante()}, new String[]{declaraciones[0].getApeNomDeclarante()}, new String[]{"Declarante"}, declaraciones[0], paths[0]);
            PTDialog diagConyuge = this.getDialogPT(owner, versionPADRE, tipoPADRE, 1);
            diagConyuge.setData(new String[]{declaraciones[1].getNifDeclarante()}, new String[]{declaraciones[1].getApeNomDeclarante()}, new String[]{"C\u00f3nyuge"}, declaraciones[1], paths[1]);
            diagDeclarante.setSiguienteDialogo(diagConyuge);
            diagConyuge.setAnteriorDialogo(diagDeclarante);
            boolean presentado = false;
            boolean salir = false;
            do {
                diagDeclarante.showDialog(2);
                if (diagDeclarante.getSeletedCommand() == 0 || diagDeclarante.getSeletedCommand() == 2) {
                    salir = true;
                    continue;
                }
                diagConyuge.showDialog(2);
                switch (diagConyuge.getSeletedCommand()) {
                    case 0: {
                        presentado = false;
                        break;
                    }
                    case 2: {
                        presentado = false;
                        salir = true;
                        break;
                    }
                    default: {
                        presentado = true;
                    }
                }
            } while (!presentado && !salir);
            if (presentado) {
                result[0] = diagDeclarante.getResultDialog() instanceof PTOkDialog;
                result[1] = diagConyuge.getResultDialog() instanceof PTOkDialog;
                PTTwinDialog resultDialog = this.getTwinDialog(owner);
                resultDialog.setResultData(0, diagDeclarante.getResultDialog(), declaraciones[0].getNifDeclarante(), declaraciones[0].getApeNomDeclarante());
                resultDialog.setResultData(1, diagConyuge.getResultDialog(), declaraciones[1].getNifDeclarante(), declaraciones[1].getApeNomDeclarante());
                resultDialog.showDialog();
            }
        }
        return result;
    }

    private PTDialog getDialogPT(Object owner, String versionPADRE, int tipoPADRE, int dim) {
        PTDialog diag = owner == null ? new PTDialog(dim, tipoPADRE, versionPADRE) : (owner instanceof Frame ? new PTDialog((Frame)owner, dim, tipoPADRE, versionPADRE) : (owner instanceof Dialog ? new PTDialog((Dialog)owner, dim, tipoPADRE, versionPADRE) : (owner instanceof Window ? new PTDialog((Window)owner, dim, tipoPADRE, versionPADRE) : new PTDialog(dim, tipoPADRE, versionPADRE))));
        return diag;
    }

    private PTTwinDialog getTwinDialog(Object owner) {
        PTTwinDialog diag = new PTTwinDialog();
        if (owner instanceof Frame) {
            diag = new PTTwinDialog((Frame)owner);
        } else if (owner instanceof Dialog) {
            diag = new PTTwinDialog((Dialog)owner);
        } else if (owner instanceof Window) {
            diag = new PTTwinDialog((Window)owner);
        }
        return diag;
    }

    private AvisoDialog getDialogAviso(Object owner) {
        AvisoDialog diag = owner == null ? new AvisoDialog() : (owner instanceof Frame ? new AvisoDialog((Frame)owner) : (owner instanceof Dialog ? new AvisoDialog((Dialog)owner) : (owner instanceof Window ? new AvisoDialog((Window)owner) : new AvisoDialog())));
        return diag;
    }

    private void setIdioma(String idioma) {
        String idi = idioma.toLowerCase().trim();
        if (idi.equals("ct")) {
            idi = "ca";
        }
        if (idi.equals("ga")) {
            idi = "gl";
        }
        if (!(idi.equals("es") || idi.equals("ca") || idi.equals("gl") || idi.equals("va"))) {
            idi = "es";
        }
        Enviroment.getInstance().setIdioma(idi);
    }

    private void setLogDir(File dir) {
        File log = dir;
        Enviroment.getInstance().setLogDir(log.getAbsolutePath());
    }
}

