/*
 * Decompiled with CFR 0.152.
 */
package es.gob.aeat.dit.ov.renta;

import es.gob.aeat.dit.ov.renta.RentaException;
import es.gob.aeat.dit.ov.renta.http.HttpHandler;
import es.gob.aeat.dit.ov.renta.http.HttpResponse;
import java.awt.Color;
import java.awt.SystemColor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class Enviroment {
    public static Color COLOR_BASE = SystemColor.info;
    public static Color COLOR_DARK = SystemColor.info;
    public static Color COLOR_LIGHT = SystemColor.info;
    public static final int EJERCICIO_DF = 2014;
    public static final int EJERCICIO_PT = 2014;
    private static final String LOG_FILE = "dfpt.log";
    private String motivo = null;
    private boolean intranet = false;
    public static final int DATOS_FISCALES = 0;
    public static final int PRESE_TELEMATI = 1;
    public static final int LOGIN_PIN24H = 2;
    public static final int NEW_PIN24H = 3;
    public static final int RECT_CCC_SERVICE = 10;
    public static final int LOGIN_INTRANET = 11;
    public static final int PAGO_CUENTA = 0;
    public static final int PAGO_TARJETA = 1;
    public static final int PAGO_REFERENCIA = 2;
    public static final int AUTH_UNKNOWN = -1;
    public static final int AUTH_CER = 0;
    public static final int AUTH_PIN = 1;
    public static final int AUTH_REF = 2;
    public static final int AUTH_CER_INTRA = 3;
    public static final int INTERNET = 0;
    public static final int INTRANET = 1;
    private static final String HOST_INTER_DESA = "www2.agenciatributaria.gob.aeat";
    private static final String HOST_INTER_PREE = "www6.aeat.es";
    private static final String HOST_INTER_PREI = "prewww2.agenciatributaria.gob.aeat";
    private static final String HOST_INTER_PROD = "www2.agenciatributaria.gob.es";
    private static final String HOST_INTRA_DESA = "mvsdesa1.dit.aeat";
    private static final String HOST_INTRA_PROD = "www.aeat";
    private static final String FILE_INTER_URLS = "/static_files/common/internet/dep/aplicaciones/ov/irpf2014.txt";
    private static final String FILE_INTRA_URLS = "/static_files/common/intranet/dep/aplicaciones/ov/irpf2014.txt";
    private static final String FILE_CONF = "/es/gob/aeat/dit/ov/renta/resources/env.conf";
    private static final String FILE_IDIS = "/es/gob/aeat/dit/ov/renta/resources/messages";
    private String[] SERVICES_DF = new String[2];
    private String[] SERVICES_PT_100 = new String[2];
    private String[] SERVICES_PT_714 = new String[2];
    private static final String SERVICE_AUTH_PIN24H = "/es12/l/es02genp24h1";
    private static final String SERVICE_NEW_PIN24H = "/es13/h/p24obp01.html";
    private static final String SERVICE_AUTH_INTRANET = "/ES98/L/GEN2GENPRO20";
    private String SERVICE_RECT_CCC;
    private String SERVICE_CERT_INFO;
    private String[] HOSTS_DF = new String[4];
    private String[] HOSTS_PT = new String[4];
    private String HOST_AUTH_PIN24H;
    private String HOST_NEW_PIN24H;
    private boolean loadedURLS = false;
    private String idioma = "es";
    private Properties messages = new Properties();
    private Logger log = Logger.getLogger("RentaDFPT");
    private static Enviroment instance;

    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    public boolean isIntranet() {
        return this.intranet;
    }

    public void setIntranet(boolean intranet) {
        this.intranet = intranet;
    }

    public static Enviroment getInstance() {
        if (instance == null) {
            instance = new Enviroment();
        }
        return instance;
    }

    private Enviroment() {
        this.log.setUseParentHandlers(false);
        this.loadIdiomas("es");
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLogDir(String dir) {
        if (dir != null) {
            Handler[] handlers;
            File dirFile;
            if (!(dir = dir.replace('\\', '/')).endsWith("/")) {
                dir = String.valueOf(dir) + "/";
            }
            if (!(dirFile = new File(dir = String.valueOf(dir) + "log/")).exists()) {
                dirFile.mkdir();
            }
            if ((handlers = this.log.getHandlers()) != null) {
                int i = 0;
                while (i < handlers.length) {
                    try {
                        this.log.removeHandler(handlers[i]);
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            try {
                FileHandler fh = new FileHandler(String.valueOf(dir) + LOG_FILE + ".%g", 0x100000, 2, true);
                fh.setFormatter(new SimpleFormatter());
                this.log.addHandler(fh);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getIdioma() {
        return this.idioma;
    }

    public void setIdioma(String idioma) {
        idioma = idioma == null ? "es" : idioma.trim().toLowerCase();
        if (!((idioma = idioma.length() < 2 ? "es" : idioma.substring(0, 2)).equals("es") || idioma.equals("ca") || idioma.equals("gl") || idioma.equals("va"))) {
            idioma = "es";
        }
        if (!this.idioma.equals(idioma)) {
            this.loadIdiomas(idioma);
        }
        this.idioma = idioma.toLowerCase();
    }

    public String getString(String key) {
        if (this.idioma.equals("-")) {
            return "Idioma no establecido";
        }
        return this.messages.getProperty(key);
    }

    public String getHost(int tipoPeticion, int formaAutenticacion) throws FileNotFoundException, IOException {
        if (!this.loadedURLS) {
            this.loadURLS();
        }
        String[] hosts = null;
        switch (tipoPeticion) {
            case 0: {
                hosts = this.HOSTS_DF;
                break;
            }
            default: {
                hosts = this.HOSTS_PT;
            }
        }
        return hosts[formaAutenticacion];
    }

    public String getURL(int tipoPeticion) throws FileNotFoundException, IOException, Exception {
        if (!this.loadedURLS) {
            this.loadURLS();
        }
        switch (tipoPeticion) {
            case 3: {
                if (this.HOST_NEW_PIN24H == null) {
                    throw new Exception(this.getString("Enviroment.Err01"));
                }
                return "https://" + this.HOST_NEW_PIN24H + SERVICE_NEW_PIN24H + "?idi=" + this.getIdioma() + "&";
            }
            case 2: {
                if (this.HOST_AUTH_PIN24H == null) {
                    throw new Exception(this.getString("Enviroment.Err01"));
                }
                return "https://" + this.HOST_AUTH_PIN24H + SERVICE_AUTH_PIN24H;
            }
            case 11: {
                return "https://" + this.HOSTS_DF[3] + SERVICE_AUTH_INTRANET;
            }
        }
        throw new Exception("Clave solicitada no valida");
    }

    public String getURL(int tipoPeticion, int formaDescarga, int modelo) throws FileNotFoundException, IOException, RentaException {
        String[] services;
        if (!this.loadedURLS) {
            this.loadURLS();
        }
        String[] hosts = null;
        switch (tipoPeticion) {
            case 0: {
                hosts = this.HOSTS_DF;
                break;
            }
            case 1: {
                hosts = this.HOSTS_PT;
            }
        }
        if (tipoPeticion == 0) {
            services = this.SERVICES_DF;
        } else if (tipoPeticion == 1) {
            services = this.SERVICES_PT_100;
            if (modelo == 714) {
                services = this.SERVICES_PT_714;
            }
        } else {
            throw new RentaException(String.valueOf(this.getString("Enviroment.ErrFileEnt4")) + " (" + tipoPeticion + ")");
        }
        String dominio = hosts[formaDescarga];
        if (dominio == null) {
            throw new RentaException(String.valueOf(this.getString("Enviroment.ErrFileEnt4")) + " (" + tipoPeticion + ", " + formaDescarga + ")");
        }
        return "https://" + dominio + services[formaDescarga == 3 ? 1 : 0];
    }

    public String getURLRectCCC(int authMethod) throws FileNotFoundException, IOException, RentaException {
        String service;
        if (!this.loadedURLS) {
            this.loadURLS();
        }
        if ((service = this.SERVICE_RECT_CCC) == null) {
            throw new RentaException(this.getString("Enviroment.Err01"));
        }
        return "https://" + this.HOSTS_DF[authMethod] + service;
    }

    public String getURLPago(int authMethod, int formaPago) throws FileNotFoundException, IOException, RentaException {
        if (!this.loadedURLS) {
            this.loadURLS();
        }
        String url = String.valueOf(this.getURLDistribuidor()) + "&HID=PAGO&";
        switch (authMethod) {
            case 0: 
            case 3: {
                url = String.valueOf(url) + "AUT=CER&";
                break;
            }
            case 1: {
                url = String.valueOf(url) + "AUT=PIN&";
                break;
            }
            case 2: {
                url = String.valueOf(url) + "AUT=REF&";
            }
        }
        switch (formaPago) {
            case 0: {
                url = String.valueOf(url) + "TIP=CCC&EXT=";
                break;
            }
            case 1: {
                url = String.valueOf(url) + "TIP=TAR&EXT=";
            }
        }
        return url;
    }

    private void loadURLS() throws FileNotFoundException, IOException {
        HttpHandler hh;
        HttpResponse resp;
        Properties envProp = new Properties();
        envProp.load(this.getClass().getResourceAsStream(FILE_CONF));
        String entorno = envProp.getProperty("ENV");
        String url = "https://www2.agenciatributaria.gob.es/static_files/common/internet/dep/aplicaciones/ov/irpf2014.txt";
        if (this.intranet) {
            url = "https://www.aeat/static_files/common/intranet/dep/aplicaciones/ov/irpf2014.txt";
            if ("DESA".equals(entorno)) {
                url = "https://mvsdesa1.dit.aeat/static_files/common/intranet/dep/aplicaciones/ov/irpf2014.txt";
            }
        } else {
            url = "https://www2.agenciatributaria.gob.es/static_files/common/internet/dep/aplicaciones/ov/irpf2014.txt";
            if ("DESA".equals(entorno)) {
                url = "https://www2.agenciatributaria.gob.aeat/static_files/common/internet/dep/aplicaciones/ov/irpf2014.txt";
            } else if ("PREE".equals(entorno)) {
                url = "https://www6.aeat.es/static_files/common/internet/dep/aplicaciones/ov/irpf2014.txt";
            } else if ("PREI".equals(entorno)) {
                url = "https://prewww2.agenciatributaria.gob.aeat/static_files/common/internet/dep/aplicaciones/ov/irpf2014.txt";
            }
        }
        if ((resp = (hh = new HttpHandler(url)).doGet()).getResponseCode() != 200) {
            throw new IOException(this.getString("Enviroment.ErrFileEnt2"));
        }
        Properties conf = new Properties();
        conf.load(new StringReader(resp.getContentAsText()));
        if (conf.containsKey("DF_CER")) {
            this.HOSTS_DF[0] = conf.getProperty("DF_CER").trim();
        }
        if (conf.containsKey("DF_PIN")) {
            this.HOSTS_DF[1] = conf.getProperty("DF_PIN").trim();
        }
        if (conf.containsKey("DF_REF")) {
            this.HOSTS_DF[2] = conf.getProperty("DF_REF").trim();
        }
        if (conf.containsKey("DF_INT")) {
            this.HOSTS_DF[3] = conf.getProperty("DF_INT").trim();
        }
        if (conf.containsKey("PT_CER")) {
            this.HOSTS_PT[0] = conf.getProperty("PT_CER").trim();
        }
        if (conf.containsKey("PT_PIN")) {
            this.HOSTS_PT[1] = conf.getProperty("PT_PIN").trim();
        }
        if (conf.containsKey("PT_REF")) {
            this.HOSTS_PT[2] = conf.getProperty("PT_REF").trim();
        }
        if (conf.containsKey("PT_INT")) {
            this.HOSTS_PT[3] = conf.getProperty("PT_INT").trim();
        }
        if (conf.containsKey("DF_INTERNET")) {
            this.SERVICES_DF[0] = conf.getProperty("DF_INTERNET").trim();
        }
        if (conf.containsKey("DF_INTRANET")) {
            this.SERVICES_DF[1] = conf.getProperty("DF_INTRANET").trim();
        }
        if (conf.containsKey("100_INTERNET")) {
            this.SERVICES_PT_100[0] = conf.getProperty("100_INTERNET").trim();
        }
        if (conf.containsKey("100_INTRANET")) {
            this.SERVICES_PT_100[1] = conf.getProperty("100_INTRANET").trim();
        }
        if (conf.containsKey("714_INTERNET")) {
            this.SERVICES_PT_714[0] = conf.getProperty("714_INTERNET").trim();
        }
        if (conf.containsKey("714_INTRANET")) {
            this.SERVICES_PT_714[1] = conf.getProperty("714_INTRANET").trim();
        }
        if (conf.containsKey("PIN_AUTH")) {
            this.HOST_AUTH_PIN24H = conf.getProperty("PIN_AUTH").trim();
        }
        if (conf.containsKey("PIN_NEW")) {
            this.HOST_NEW_PIN24H = conf.getProperty("PIN_NEW").trim();
        }
        if (conf.containsKey("SERVICE_RECT_CCC")) {
            this.SERVICE_RECT_CCC = conf.getProperty("SERVICE_RECT_CCC").trim();
        }
        if (conf.containsKey("SERVICE_CERT_INFO")) {
            this.SERVICE_CERT_INFO = conf.getProperty("SERVICE_CERT_INFO").trim();
        }
        this.loadedURLS = true;
    }

    private void loadIdiomas(String idioma) {
        this.messages = new Properties();
        try {
            this.messages.load(this.getClass().getResourceAsStream("/es/gob/aeat/dit/ov/renta/resources/messages." + idioma));
        }
        catch (IOException e) {
            this.log.logp(Level.SEVERE, this.getClass().getName(), "loadIdiomas", "No se cargaron los idiomas", e);
            this.idioma = "-";
        }
    }

    public static void setColorBase(Color color) {
        COLOR_BASE = color;
        int rLight = color.getRed() + (int)((double)color.getRed() * 0.1);
        int gLight = color.getGreen() + (int)((double)color.getGreen() * 0.1);
        int bLight = color.getBlue() + (int)((double)color.getBlue() * 0.1);
        if (rLight > 255) {
            rLight = 255;
        }
        if (gLight > 255) {
            gLight = 255;
        }
        if (bLight > 255) {
            bLight = 255;
        }
        int rDark = color.getRed() - (int)((double)color.getRed() * 0.3);
        int gDark = color.getGreen() - (int)((double)color.getGreen() * 0.3);
        int bDark = color.getBlue() - (int)((double)color.getBlue() * 0.3);
        if (rDark < 0) {
            rDark = 0;
        }
        if (gDark < 0) {
            gDark = 0;
        }
        if (bDark < 0) {
            bDark = 0;
        }
        COLOR_DARK = new Color(rDark, gDark, bDark);
        COLOR_LIGHT = new Color(rLight, gLight, bLight);
    }

    public String getHostDistribuidor() throws FileNotFoundException, IOException {
        return this.getHost(1, 2);
    }

    public String getURLDistribuidor() throws FileNotFoundException, IOException {
        String url = "https://" + this.getHostDistribuidor() + "/static_files/common/internet/dep/aplicaciones/ov/dismodpt.html?IDI=" + this.getIdioma() + "&EJE=" + 2014;
        return url;
    }

    public String getURLCertInfo(int authMethod) throws FileNotFoundException, IOException, RentaException {
        String service;
        if (!this.loadedURLS) {
            this.loadURLS();
        }
        if ((service = this.SERVICE_CERT_INFO) == null) {
            throw new RentaException(this.getString("Enviroment.Err01"));
        }
        return "https://" + this.HOSTS_DF[authMethod] + service;
    }

    public static String urlEncode(String txt) {
        try {
            return URLEncoder.encode(txt, "ISO-8859-15");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return txt;
        }
    }
}

