/*
 * Decompiled with CFR 0.152.
 */
package com.aeat.component.jcombotbl;

import com.aeat.component.jcombotbl.ContDatosTabla;
import com.aeat.component.jcombotbl.DatdelRend;
import com.aeat.component.jcombotbl.DatosTabla;
import com.aeat.component.jcombotbl.ICompJtbl;
import com.aeat.component.jcombotbl.IHelpJCombo;
import com.aeat.component.jcombotbl.JComboTbl;
import com.aeat.component.jcombotbl.ModeloTablaJ;
import com.aeat.component.jcombotbl.RenderCelda;
import com.aeat.component.jcombotbl.TablaSorter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class DialogoTbl
extends JDialog {
    private static final int MAX_ANCHO = 360;
    private static final int MAX_ALTO = 40;
    private JPanel jContentPane = null;
    private JLabel cabeceraDlg = null;
    private JTable jTable = null;
    private JPanel jPanel = null;
    private JButton jbutAcep = null;
    private JButton jbutCancel = null;
    private JButton jbutHelp = null;
    private JPanel jPanel1 = null;
    private JTextArea pieDlg = null;
    private ModeloTablaJ modeloTabl;
    private JScrollPane scrollTabla;
    private int rowSelect;
    private int rowSelectOld;
    private Dimension screenSize;
    private ICompJtbl icomp;
    private ResourceBundle rb = null;
    private IHelpJCombo helpJCombo;
    private JComboTbl combo = null;
    private Frame fr;

    public DialogoTbl(Frame frame, ResourceBundle resourceBundle) {
        super(frame, true);
        this.fr = frame;
        this.initialize();
    }

    public DialogoTbl(Frame frame, JComboTbl jComboTbl, ResourceBundle resourceBundle) {
        super(frame, true);
        this.fr = frame;
        this.rb = resourceBundle;
        this.initialize();
        this.combo = jComboTbl;
    }

    private void initialize() {
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.getJContentPane());
        this.getJContentPane().add((Component)this.getCabeceraDlg(), "North");
        this.getJContentPane().add((Component)this.getJPanel(), "South");
        this.getJContentPane().add((Component)this.getElScrollPane(), "Center");
        this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DialogoTbl.this.selecciona(DialogoTbl.this.rowSelectOld);
                DialogoTbl.this.cierraDlg(null, false);
            }

            public void windowOpened(WindowEvent windowEvent) {
                DialogoTbl.this.pintaColumnas();
            }

            public void windowActivated(WindowEvent windowEvent) {
                ListSelectionModel listSelectionModel = DialogoTbl.this.getJTable().getSelectionModel();
                listSelectionModel.setSelectionInterval(DialogoTbl.this.rowSelect, DialogoTbl.this.rowSelect);
                Runnable runnable = new Runnable(){

                    public void run() {
                        DialogoTbl.this.colocateEnElVisible();
                    }
                };
                EventQueue.invokeLater(runnable);
            }
        });
    }

    protected void colocateEnElVisible() {
        Rectangle rectangle;
        double d = 0.0;
        for (int i = 0; i <= this.rowSelect; ++i) {
            rectangle = this.getJTable().getCellRect(i, 0, true);
            d += rectangle.getHeight();
        }
        Double d2 = new Double(d);
        rectangle = this.getJTable().getCellRect(this.rowSelect, 0, true);
        rectangle.setSize(rectangle.width, d2.intValue());
        this.getJTable().scrollRectToVisible(rectangle);
    }

    private JScrollPane getElScrollPane() {
        if (this.scrollTabla == null) {
            this.scrollTabla = new JScrollPane(this.getJTable(), 20, 30);
        }
        return this.scrollTabla;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
        }
        return this.jContentPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            try {
                this.jTable = new JTable();
                this.jTable.addKeyListener(new KeyAdapter(){

                    public void keyPressed(KeyEvent keyEvent) {
                        if (keyEvent.getKeyCode() == 27) {
                            DialogoTbl.this.selecciona(DialogoTbl.this.rowSelectOld);
                            DialogoTbl.this.cierraDlg(null, false);
                        } else if (keyEvent.getKeyCode() == 10) {
                            DialogoTbl.this.selecciona(DialogoTbl.this.rowSelect);
                            keyEvent.consume();
                            DialogoTbl.this.cierraDlg(null, false);
                        }
                    }
                });
                this.jTable.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (mouseEvent.getClickCount() == 2) {
                            DialogoTbl.this.cierraDlg(null, true);
                        }
                    }
                });
                ListSelectionModel listSelectionModel = this.jTable.getSelectionModel();
                listSelectionModel.setSelectionMode(0);
                listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        DialogoTbl.this.cambiaSelect(listSelectionEvent);
                    }
                });
                this.jTable.setDefaultRenderer(DatdelRend.class, new RenderCelda());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jTable;
    }

    private void cambiaSelect(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = this.getJTable().getSelectionModel();
        if (!listSelectionEvent.getValueIsAdjusting() && !listSelectionModel.isSelectionEmpty()) {
            int n = listSelectionEvent.getLastIndex();
            for (int i = listSelectionEvent.getFirstIndex(); i <= n; ++i) {
                if (!listSelectionModel.isSelectedIndex(i)) continue;
                this.rowSelect = ((TablaSorter)this.getJTable().getModel()).getRealIndex(i);
                break;
            }
        }
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            try {
                this.jPanel = new JPanel();
                this.jPanel.setLayout(new BorderLayout());
                this.jPanel.add((Component)this.getJPanel1(), "South");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jPanel;
    }

    private void ponComponente(Component component) {
        this.getJPanel().add(component, "Center");
    }

    private JButton getJbutAcep() {
        if (this.jbutAcep == null) {
            try {
                this.jbutAcep = new JButton();
                String string = "Aceptar";
                string = this.obtenerTextoIdioma(string, "boton.aceptar");
                this.jbutAcep.setText(string);
                this.jbutAcep.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        DialogoTbl.this.cierraDlg(actionEvent, true);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jbutAcep;
    }

    private String obtenerTextoIdioma(String string, String string2) {
        try {
            String string3;
            if (this.rb != null && (string3 = this.rb.getString(string2)) != null) {
                string = string3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private JButton getJbutHelp() {
        if (this.jbutHelp == null) {
            try {
                this.jbutHelp = new JButton();
                String string = "Ayuda";
                string = this.obtenerTextoIdioma(string, "boton.ayuda");
                this.jbutHelp.setText(string);
                this.jbutHelp.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        DialogoTbl.this.pulsaAyuda(actionEvent);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jbutHelp;
    }

    protected void pulsaAyuda(ActionEvent actionEvent) {
        this.helpJCombo.pulsaBoton(this);
    }

    protected void cierraDlg(ActionEvent actionEvent, boolean bl) {
        if (bl && this.icomp != null && !this.icomp.isOK()) {
            return;
        }
        this.dispose();
    }

    private JButton getJbutCancel() {
        if (this.jbutCancel == null) {
            try {
                this.jbutCancel = new JButton();
                String string = "Cancelar";
                string = this.obtenerTextoIdioma(string, "boton.cancelar");
                this.jbutCancel.setText(string);
                this.jbutCancel.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        DialogoTbl.this.selecciona(DialogoTbl.this.rowSelectOld);
                        DialogoTbl.this.cierraDlg(actionEvent, false);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jbutCancel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            try {
                this.jPanel1 = new JPanel();
                this.jPanel1.add((Component)this.getJbutAcep(), null);
                this.jPanel1.add((Component)this.getJbutCancel(), null);
                if (this.helpJCombo != null) {
                    this.jPanel1.add((Component)this.getJbutHelp(), null);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jPanel1;
    }

    public void setDatos(ContDatosTabla contDatosTabla) {
        this.modeloTabl = new ModeloTablaJ();
        this.modeloTabl.setDatos(contDatosTabla);
        TablaSorter tablaSorter = new TablaSorter(this.modeloTabl);
        this.getJTable().setModel(tablaSorter);
        tablaSorter.addMouseListenerToHeaderInTable(this.getJTable());
        tablaSorter.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DialogoTbl.this.pintaColumnas();
            }
        });
    }

    private void pintaColumnas() {
        int n;
        int n2;
        int n3;
        String string = null;
        Graphics2D graphics2D = (Graphics2D)this.getJTable().getGraphics();
        graphics2D.setFont(new Font("Courier", 0, 16));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        TableModel tableModel = this.getJTable().getModel();
        TableColumn tableColumn = null;
        int n4 = 0;
        for (n3 = 0; n3 < tableModel.getColumnCount(); ++n3) {
            tableColumn = this.getJTable().getColumnModel().getColumn(n3);
            n2 = this.getMaxTamColumn(fontMetrics, ((TablaSorter)tableModel).getDatos(), n3);
            n = fontMetrics.stringWidth(tableModel.getColumnName(n3));
            n4 += Math.max(n2, n);
        }
        if ((double)n4 >= this.screenSize.getSize().getWidth()) {
            n4 = (int)this.screenSize.getSize().getWidth() - 100;
        }
        n3 = 0;
        for (n2 = 0; n2 < tableModel.getColumnCount(); ++n2) {
            tableColumn = this.getJTable().getColumnModel().getColumn(n2);
            n = this.getMaxTamColumn(fontMetrics, ((TablaSorter)tableModel).getDatos(), n2);
            int n5 = fontMetrics.stringWidth(tableModel.getColumnName(n2));
            int n6 = Math.max(n, n5);
            if (n2 != 0) {
                int n7 = n4 - n3 - 50;
                for (int i = 0; i < tableModel.getRowCount(); ++i) {
                    Object object = tableModel.getValueAt(i, n2);
                    if (object instanceof DatdelRend) {
                        DatdelRend datdelRend = (DatdelRend)tableModel.getValueAt(i, n2);
                        string = datdelRend.getDatos();
                    } else {
                        string = (String)object;
                    }
                    int n8 = fontMetrics.stringWidth(string);
                    if (n8 > n7) {
                        int n9 = this.obtenNumFilas(n8, n7);
                        this.getJTable().setRowHeight(i, fontMetrics.getHeight() * n9 + 10);
                        continue;
                    }
                    this.getJTable().setRowHeight(i, fontMetrics.getHeight() + 6);
                }
                continue;
            }
            n3 = n6 + 6;
            tableColumn.setMaxWidth(n3);
        }
        n2 = (int)this.getElScrollPane().getPreferredSize().getSize().getHeight();
        Dimension dimension = new Dimension(n4, n2);
        this.getElScrollPane().setPreferredSize(dimension);
        this.pack();
    }

    private int getMaxTamColumn(FontMetrics fontMetrics, ContDatosTabla contDatosTabla, int n) {
        int n2 = 0;
        int n3 = contDatosTabla.getFilas();
        int n4 = 0;
        String string = null;
        for (int i = 0; i < n3; ++i) {
            string = contDatosTabla.getDato(i, n);
            n4 = fontMetrics.stringWidth(string);
            if (n4 <= n2) continue;
            n2 = n4;
        }
        return n2;
    }

    private int obtenNumFilas(int n, int n2) {
        BigDecimal bigDecimal = new BigDecimal((double)n);
        BigDecimal bigDecimal2 = new BigDecimal((double)n2);
        BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, 0);
        int n3 = bigDecimal3.intValue();
        return n3;
    }

    private void pintaColumnas2() {
        String string = null;
        Graphics graphics = this.getJTable().getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        TableModel tableModel = this.getJTable().getModel();
        TableColumn tableColumn = null;
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            int n;
            int n2;
            tableColumn = this.getJTable().getColumnModel().getColumn(i);
            int n3 = this.getMaxTamColumn(((TablaSorter)tableModel).getDatos(), i);
            int n4 = Math.max(n3, n2 = fontMetrics.stringWidth(tableModel.getColumnName(i)));
            if (n4 > (n = 225)) {
                if (i == 0) continue;
                for (int j = 0; j < tableModel.getRowCount(); ++j) {
                    Object object = tableModel.getValueAt(j, i);
                    if (object instanceof DatdelRend) {
                        DatdelRend datdelRend = (DatdelRend)tableModel.getValueAt(j, i);
                        string = datdelRend.getDatos();
                    } else {
                        string = (String)object;
                    }
                    int n5 = fontMetrics.stringWidth(string);
                    if (n5 > n) {
                        int n6 = n5 / n;
                        this.getJTable().setRowHeight(j, fontMetrics.getHeight() * (n6 += 2) + 10);
                        continue;
                    }
                    this.getJTable().setRowHeight(j, fontMetrics.getHeight() + 10);
                }
                continue;
            }
            if (i == 0) {
                tableColumn.setMaxWidth(n4 + 20);
            }
            this.getJTable().setRowHeight(fontMetrics.getHeight() + 6);
        }
        Dimension dimension = this.getJTable().getPreferredSize();
        if (dimension.getHeight() > 700.0) {
            dimension.setSize(dimension.getWidth(), 600.0);
        }
        Dimension dimension2 = this.getElScrollPane().getPreferredSize();
        dimension2.setSize(dimension2.getWidth() + 300.0, dimension.getHeight() + 30.0);
        this.getElScrollPane().setPreferredSize(dimension2);
        this.pack();
    }

    private JLabel getCabeceraDlg() {
        if (this.cabeceraDlg == null) {
            this.cabeceraDlg = new JLabel();
        }
        return this.cabeceraDlg;
    }

    public void setCabeceraDlg(String string) {
        this.cabeceraDlg.setText(string);
    }

    private JTextArea getPieDlg() {
        if (this.pieDlg == null) {
            this.pieDlg = new JTextArea(1, 20);
            this.pieDlg.setBorder(new CompoundBorder(BorderFactory.createLoweredBevelBorder(), new LineBorder(Color.BLACK, 1)));
            this.pieDlg.setLineWrap(true);
            this.pieDlg.setWrapStyleWord(true);
            this.pieDlg.setEditable(false);
            this.pieDlg.setBackground(Color.LIGHT_GRAY);
            this.pieDlg.setHighlighter(null);
            this.pieDlg.setFont(new Font("Arial", 1, 14));
        }
        return this.pieDlg;
    }

    public void setPieDlg(String string) {
        this.getPieDlg().setText(string);
        this.ponComponente(this.getPieDlg());
    }

    public void setTitulo(String string) {
        this.setTitle(string);
    }

    public void selecciona(int n) {
        this.rowSelect = n;
        this.rowSelectOld = n;
        if (this.combo != null) {
            ContDatosTabla contDatosTabla = ((TablaSorter)this.getJTable().getModel()).getDatos();
            DatosTabla datosTabla = null;
            List list = contDatosTabla.getDatosTbl();
            for (int i = 0; i < list.size(); ++i) {
                if (i != n) continue;
                datosTabla = (DatosTabla)list.get(i);
                this.combo.setSelectItem(datosTabla);
                break;
            }
        }
    }

    public int getSeleccion() {
        return this.rowSelect;
    }

    public void setSeleccion(int n) {
        this.rowSelect = n;
        this.rowSelectOld = n;
    }

    public ICompJtbl getComponente() {
        return this.icomp;
    }

    public void setComponente(ICompJtbl iCompJtbl) {
        this.icomp = iCompJtbl;
        this.ponComponente(this.icomp.getComponente());
    }

    public void setHelpDlg(IHelpJCombo iHelpJCombo) {
        this.helpJCombo = iHelpJCombo;
    }

    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogoTbl.this.rowSelect = DialogoTbl.this.rowSelectOld;
                DialogoTbl.this.cierraDlg(null, false);
            }
        };
        JRootPane jRootPane = new JRootPane();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
        return jRootPane;
    }

    public int getMaxTamColumn(ContDatosTabla contDatosTabla, int n) {
        int n2 = 0;
        FontMetrics fontMetrics = this.getGraphics().getFontMetrics();
        int n3 = contDatosTabla.getFilas();
        int n4 = 0;
        String string = null;
        for (int i = 0; i < n3; ++i) {
            string = contDatosTabla.getDato(i, n);
            n4 = fontMetrics.stringWidth(string);
            if (n4 <= n2) continue;
            n2 = n4;
        }
        return n2;
    }
}

