/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.re14.motor;

import es.aeat.pare.aplicacion.Aplicacion;
import es.aeat.pare.componentes.AEATLogger;
import es.aeat.pare.comunDF.FuncionesDF;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class FuncionesECR {
    private static final int MILISEGUNDOSPORDIA = 86400000;
    public static Calendar FECHAINICIOCAMPANYAECR = new GregorianCalendar(2015, 4, 7);
    public static Calendar FECHAFINALCAMPANYAECR = new GregorianCalendar(2015, 5, 30);

    public static void main(String[] stringArray) {
        FuncionesECR.indiceDiaCampanya();
    }

    public static long indiceDiaCampanya() {
        String string = FuncionesECR.dameFechaSistema();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Integer.parseInt(string.substring(4)), Integer.parseInt(string.substring(2, 4)) - 1, Integer.parseInt(string.substring(0, 2)));
        if (gregorianCalendar.before(FECHAINICIOCAMPANYAECR)) {
            return 0L;
        }
        if (gregorianCalendar.after(FECHAFINALCAMPANYAECR)) {
            return 99L;
        }
        long l = gregorianCalendar.getTimeInMillis() - FECHAINICIOCAMPANYAECR.getTimeInMillis();
        return 1L + l / 86400000L;
    }

    public static String dameFechaSistema() {
        String string = "";
        try {
            Date date = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMyyyy");
            string = simpleDateFormat.format(date);
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)"Error al ejecutar UtilidadesECR::diaCampa\u00f1a", (Throwable)exception);
        }
        return string;
    }

    public static boolean generaReferenciaECR() throws Exception {
        String string = "";
        try {
            String string2 = "";
            String string3 = Aplicacion.getEcrCFG().dameEntrada("Entidad").trim();
            String string4 = Aplicacion.getEcrCFG().dameEntrada("Sucursal").trim();
            String string5 = Aplicacion.getEcrCFG().dameEntrada("NumInst").trim();
            Integer n = new Integer(Aplicacion.getDiaECR());
            String string6 = String.format("%02d", (int)n);
            Integer n2 = new Integer(Aplicacion.getOrdenECR());
            String string7 = String.format("%04d", (int)n2);
            String string8 = "1";
            String string9 = Aplicacion.getMotor().getCurrentPtr();
            if (string9.equalsIgnoreCase("Conjunta")) {
                string8 = "0";
            } else if (string9.equalsIgnoreCase("Conyuge")) {
                string8 = "2";
            } else if (string9.equalsIgnoreCase("Hijo1")) {
                string8 = "3";
            } else if (string9.equalsIgnoreCase("Hijo2")) {
                string8 = "4";
            } else if (string9.equalsIgnoreCase("Hijo3")) {
                string8 = "5";
            } else if (string9.equalsIgnoreCase("Hijo4")) {
                string8 = "6";
            }
            String string10 = new String(FuncionesECR.formateaPartidaDouble(new String(Aplicacion.getMotor().obtenerPartidaString("BLGGRAV"))));
            string10 = string10.replace(",", "");
            string10 = string10.substring(string10.length() - 3, string10.length());
            string = string3 + string4 + string5 + string6 + string7 + string8 + string10;
            int n3 = FuncionesECR.modulo7(string);
            string2 = Integer.toString(n3);
            string2 = string2.substring(0, 1);
            string = string + string2;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
        }
        return Aplicacion.getMotor().establecerPartida("NUMREFERENCIA", string);
    }

    public static int modulo7(String string) {
        int n = 0;
        int n2 = 1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.substring(i, i + 1).equals(".")) continue;
            int n3 = n2 * n + Integer.parseInt(string.substring(i, i + 1));
            n = n3 % 7;
            n2 = 10;
        }
        if (n != 0) {
            n = 7 - n;
            return n;
        }
        return 0;
    }

    public static String formateaPartidaDouble(String string) {
        FuncionesDF funcionesDF;
        String string2 = string;
        int n = string.indexOf(46);
        String string3 = string.substring(n + 1, string.length());
        if (string3.length() < 2) {
            string2 = string2 + "0";
        }
        String string4 = string2.replaceAll("\\.", "");
        try {
            funcionesDF = new FuncionesDF();
        }
        catch (Exception exception) {
            AEATLogger.getLogger().warn((Object)"FuncionesECR.formateaPartidaDouble", (Throwable)exception);
            return string;
        }
        return funcionesDF.formateaNumeros(string4, 2);
    }
}

