/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.re14.motor;

import es.aeat.pare.aplicacion.Aplicacion;
import es.aeat.pare.aplicacion.Constantes;
import es.aeat.pare.cc14.Declarantes;
import es.aeat.pare.componentes.AEATHerramientas;
import es.aeat.pare.componentes.AEATLogger;
import es.aeat.pare.comunDF.FuncionesDF;
import es.aeat.pare.re14.motor.FuncionesRenta;
import es.aeat.pare.re14.motor.FuncionesRentaComun;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import net.sf.saxon.trans.XPathException;
import org.w3c.dom.Document;

public final class DatosPersonales {
    private static final int CTENASC = 4;
    private static final int CTENHIJOS = 12;
    private static final int EJERCICIO = 2014;
    FuncionesRenta funcrenta;

    public FuncionesRenta getFuncrenta() {
        return this.funcrenta;
    }

    public void setFuncrenta(FuncionesRenta funcionesRenta) {
        this.funcrenta = funcionesRenta;
    }

    public DatosPersonales() {
        this.setFuncrenta(new FuncionesRenta());
    }

    public String aceptacionT() throws ExceptionMotor {
        return this.aceptacion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean trasladarADeclaracion() throws Exception {
        Declarantes declarantes = null;
        boolean bl = true;
        try {
            declarantes = this.funcrenta.cualDeclaracion();
            this.trasladarDescendientesDelDeclarante();
            if (FuncionesRentaComun.isBConyuge()) {
                this.trasladarDescendientesDelConyuge();
            }
            if (FuncionesRentaComun.isBConjunta()) {
                this.trasladarDescendientesAConjunta();
            }
            this.trasladarAscendientes();
        }
        catch (Exception exception) {
            AEATLogger.getLogger().error((Object)("Error en DatosPersonales.trasladarADeclaracion()[" + exception.getMessage() + "]"));
        }
        finally {
            this.funcrenta.irDeclaracion(declarantes);
        }
        return bl;
    }

    private boolean trasladarDescendientesDelDeclarante() throws Exception {
        String string = "DESCENDIENTES";
        String string2 = "";
        int n = 1;
        int n2 = 1;
        this.funcrenta.irDeclaracion(Declarantes.Declarante);
        long l = Aplicacion.getMotor().obtenerClaveActiva("DESCENDIENTESRENTAS");
        int n3 = 1;
        while ((long)n3 <= Aplicacion.getMotor().recordCount("DESCENDIENTESRENTAS") && n <= 12) {
            if (FuncionesRenta.isBHijos(n3)) {
                Aplicacion.getMotor().move("DESCENDIENTESRENTAS", n3);
                String string3 = Aplicacion.getMotor().obtenerPartidaString("VINCUHR");
                String string4 = Aplicacion.getMotor().obtenerPartidaString("DEVOLHR");
                String string5 = Aplicacion.getMotor().obtenerPartidaString("R8000HR");
                if ((string3.equalsIgnoreCase("A") || string3.equalsIgnoreCase("B") || string3.equalsIgnoreCase("D")) && string4.equalsIgnoreCase("false") && string5.equalsIgnoreCase("false")) {
                    Aplicacion.getMotor().establecerPartida("ZDNIU" + n, Aplicacion.getMotor().obtenerPartidaString("NIFHR"));
                    Aplicacion.getMotor().establecerPartida("ZAPENU" + n, this.dameNombreHijo("APE1DLGHR", "APE2DLGHR", "NOMDLGHR"));
                    Aplicacion.getMotor().establecerPartida("ZANOU" + n, Aplicacion.getMotor().obtenerPartidaString("FNACHR"));
                    Aplicacion.getMotor().establecerPartida("ZACOG" + n, Aplicacion.getMotor().obtenerPartidaString("FADOPHR"));
                    Aplicacion.getMotor().establecerPartida("PCTMINU" + n, Aplicacion.getMotor().obtenerPartidaString("MINUSHR"));
                    Aplicacion.getMotor().partidaModificada("OTRSU" + n, Aplicacion.getMotor().obtenerPartidaString("OTRSHR"));
                    n = DatosPersonales.vinculacionD(string3, n);
                }
            }
            ++n3;
        }
        Aplicacion.getMotor().move("DESCENDIENTESRENTAS", l);
        n3 = 1;
        while ((long)n3 <= Aplicacion.getMotor().recordCount(string) && n <= 12) {
            Aplicacion.getMotor().move(string, n3);
            string2 = Aplicacion.getMotor().obtenerPartidaString("VINCU");
            if (string2.equalsIgnoreCase("A") || string2.equalsIgnoreCase("B") || string2.equalsIgnoreCase("D")) {
                Aplicacion.getMotor().establecerPartida("ZDNIU" + n, Aplicacion.getMotor().obtenerPartidaString("NIFH"));
                Aplicacion.getMotor().establecerPartida("ZAPENU" + n, this.dameNombreHijo("APE1DLG", "APE2DLG", "NOMDLG"));
                Aplicacion.getMotor().establecerPartida("ZANOU" + n, Aplicacion.getMotor().obtenerPartidaString("FNAC"));
                Aplicacion.getMotor().establecerPartida("ZACOG" + n, Aplicacion.getMotor().obtenerPartidaString("FADOP"));
                Aplicacion.getMotor().establecerPartida("PCTMINU" + n, Aplicacion.getMotor().obtenerPartidaString("MINUS"));
                Aplicacion.getMotor().partidaModificada("OTRSU" + n, Aplicacion.getMotor().obtenerPartidaString("OTRS"));
                if (!Aplicacion.getMotor().obtenerPartidaString("FALLDLG").equals("") && n2 <= 2) {
                    Aplicacion.getMotor().establecerPartida("ORD" + n2, "" + n);
                    Aplicacion.getMotor().establecerPartida("FECHORD" + n2, Aplicacion.getMotor().obtenerPartidaString("FALLDLG"));
                    ++n2;
                }
                n = DatosPersonales.vinculacionD(string2, n);
            }
            ++n3;
        }
        this.blanquearRestoDescendientes(n, n2);
        return true;
    }

    private boolean trasladarDescendientesDelConyuge() throws Exception {
        String string = "DESCENDIENTES";
        String string2 = "";
        int n = 1;
        int n2 = 1;
        this.funcrenta.irDeclaracion(Declarantes.Conyuge);
        long l = Aplicacion.getMotor().obtenerClaveActiva("DESCENDIENTESRENTAS");
        int n3 = 1;
        while ((long)n3 <= Aplicacion.getMotor().recordCount("DESCENDIENTESRENTAS") && n <= 12) {
            if (FuncionesRenta.isBHijos(n3)) {
                Aplicacion.getMotor().move("DESCENDIENTESRENTAS", n3);
                String string3 = Aplicacion.getMotor().obtenerPartidaString("VINCUHR");
                String string4 = Aplicacion.getMotor().obtenerPartidaString("DEVOLHR");
                String string5 = Aplicacion.getMotor().obtenerPartidaString("R8000HR");
                if ((string3.equalsIgnoreCase("A") || string3.equalsIgnoreCase("C") || string3.equalsIgnoreCase("E")) && string4.equalsIgnoreCase("false") && string5.equalsIgnoreCase("false")) {
                    Aplicacion.getMotor().establecerPartida("ZDNIU" + n, Aplicacion.getMotor().obtenerPartidaString("NIFHR"));
                    Aplicacion.getMotor().establecerPartida("ZAPENU" + n, this.dameNombreHijo("APE1DLGHR", "APE2DLGHR", "NOMDLGHR"));
                    Aplicacion.getMotor().establecerPartida("ZANOU" + n, Aplicacion.getMotor().obtenerPartidaString("FNACHR"));
                    Aplicacion.getMotor().establecerPartida("ZACOG" + n, Aplicacion.getMotor().obtenerPartidaString("FADOPHR"));
                    Aplicacion.getMotor().establecerPartida("PCTMINU" + n, Aplicacion.getMotor().obtenerPartidaString("MINUSHR"));
                    Aplicacion.getMotor().establecerPartida("OTRSU" + n, Aplicacion.getMotor().obtenerPartidaString("OTRSHR"));
                    n = DatosPersonales.vinculacionC(n, string3);
                }
            }
            ++n3;
        }
        Aplicacion.getMotor().move("DESCENDIENTESRENTAS", l);
        n3 = 1;
        while ((long)n3 <= Aplicacion.getMotor().recordCount(string) && n <= 12) {
            Aplicacion.getMotor().move(string, n3);
            string2 = Aplicacion.getMotor().obtenerPartidaString("VINCU");
            if (string2.equalsIgnoreCase("A") || string2.equalsIgnoreCase("C") || string2.equalsIgnoreCase("E")) {
                Aplicacion.getMotor().establecerPartida("ZDNIU" + n, Aplicacion.getMotor().obtenerPartidaString("NIFH"));
                Aplicacion.getMotor().establecerPartida("ZAPENU" + n, this.dameNombreHijo("APE1DLG", "APE2DLG", "NOMDLG"));
                Aplicacion.getMotor().establecerPartida("ZANOU" + n, Aplicacion.getMotor().obtenerPartidaString("FNAC"));
                Aplicacion.getMotor().establecerPartida("ZACOG" + n, Aplicacion.getMotor().obtenerPartidaString("FADOP"));
                Aplicacion.getMotor().establecerPartida("PCTMINU" + n, Aplicacion.getMotor().obtenerPartidaString("MINUS"));
                Aplicacion.getMotor().establecerPartida("OTRSU" + n, Aplicacion.getMotor().obtenerPartidaString("OTRS"));
                if (!Aplicacion.getMotor().obtenerPartidaString("FALLDLG").equals("") && n2 <= 2) {
                    Aplicacion.getMotor().establecerPartida("ORD" + n2, "" + n);
                    Aplicacion.getMotor().establecerPartida("FECHORD" + n2, Aplicacion.getMotor().obtenerPartidaString("FALLDLG"));
                    ++n2;
                }
                n = DatosPersonales.vinculacionC(n, string2);
            }
            ++n3;
        }
        this.blanquearRestoDescendientes(n, n2);
        return true;
    }

    private boolean trasladarDescendientesAConjunta() throws Exception {
        String string = "DESCENDIENTES";
        String string2 = "";
        int n = 1;
        int n2 = 1;
        this.funcrenta.irDeclaracion(Declarantes.UnidadFamiliar);
        long l = Aplicacion.getMotor().obtenerClaveActiva("DESCENDIENTESRENTAS");
        int n3 = 1;
        while ((long)n3 <= Aplicacion.getMotor().recordCount("DESCENDIENTESRENTAS") && n <= 12) {
            if (FuncionesRenta.isBHijos(n3)) {
                Aplicacion.getMotor().move("DESCENDIENTESRENTAS", n3);
                String string3 = Aplicacion.getMotor().obtenerPartidaString("VINCUHR");
                Aplicacion.getMotor().establecerPartida("ZDNIU" + n, Aplicacion.getMotor().obtenerPartidaString("NIFHR"));
                Aplicacion.getMotor().establecerPartida("ZAPENU" + n, this.dameNombreHijo("APE1DLGHR", "APE2DLGHR", "NOMDLGHR"));
                Aplicacion.getMotor().establecerPartida("ZANOU" + n, Aplicacion.getMotor().obtenerPartidaString("FNACHR"));
                Aplicacion.getMotor().establecerPartida("ZACOG" + n, Aplicacion.getMotor().obtenerPartidaString("FADOPHR"));
                Aplicacion.getMotor().establecerPartida("PCTMINU" + n, Aplicacion.getMotor().obtenerPartidaString("MINUSHR"));
                Aplicacion.getMotor().establecerPartida("OTRSU" + n, Aplicacion.getMotor().obtenerPartidaString("OTRSHR"));
                DatosPersonales.vinculacionO(n, string3);
                ++n;
            }
            ++n3;
        }
        Aplicacion.getMotor().move("DESCENDIENTESRENTAS", l);
        n3 = 1;
        while ((long)n3 <= Aplicacion.getMotor().recordCount(string) && n <= 12) {
            Aplicacion.getMotor().move(string, n3);
            string2 = Aplicacion.getMotor().obtenerPartidaString("VINCU");
            if (string2.equalsIgnoreCase("A") || string2.equalsIgnoreCase("B") || string2.equalsIgnoreCase("C") || string2.equalsIgnoreCase("D") || string2.equalsIgnoreCase("E")) {
                Aplicacion.getMotor().establecerPartida("ZDNIU" + n, Aplicacion.getMotor().obtenerPartidaString("NIFH"));
                Aplicacion.getMotor().establecerPartida("ZAPENU" + n, this.dameNombreHijo("APE1DLG", "APE2DLG", "NOMDLG"));
                Aplicacion.getMotor().establecerPartida("ZANOU" + n, Aplicacion.getMotor().obtenerPartidaString("FNAC"));
                Aplicacion.getMotor().establecerPartida("ZACOG" + n, Aplicacion.getMotor().obtenerPartidaString("FADOP"));
                Aplicacion.getMotor().establecerPartida("PCTMINU" + n, Aplicacion.getMotor().obtenerPartidaString("MINUS"));
                Aplicacion.getMotor().establecerPartida("OTRSU" + n, Aplicacion.getMotor().obtenerPartidaString("OTRS"));
                if (!Aplicacion.getMotor().obtenerPartidaString("FALLDLG").equals("") && n2 <= 2) {
                    Aplicacion.getMotor().establecerPartida("ORD" + n2, "" + n);
                    Aplicacion.getMotor().establecerPartida("FECHORD" + n2, Aplicacion.getMotor().obtenerPartidaString("FALLDLG"));
                    ++n2;
                }
                DatosPersonales.vinculacionO(n, string2);
                ++n;
            }
            ++n3;
        }
        this.blanquearRestoDescendientes(n, n2);
        return true;
    }

    private Object dameNombreHijo(String string, String string2, String string3) throws ExceptionMotor {
        String string4 = Aplicacion.getMotor().obtenerPartidaString(string3);
        String string5 = Aplicacion.getMotor().obtenerPartidaString(string);
        String string6 = Aplicacion.getMotor().obtenerPartidaString(string2);
        if (string6.length() == 0) {
            return string5 + ", " + string4;
        }
        return string5 + " " + string6 + ", " + string4;
    }

    private void blanquearRestoDescendientes(int n, int n2) throws ExceptionMotor {
        for (int i = n; i <= 12; ++i) {
            Aplicacion.getMotor().establecerPartida("ZDNIU" + i, "");
            Aplicacion.getMotor().establecerPartida("ZAPENU" + i, "");
            Aplicacion.getMotor().establecerPartida("ZANOU" + i, "");
            Aplicacion.getMotor().establecerPartida("ZACOG" + i, "");
            Aplicacion.getMotor().establecerPartida("PCTMINU" + i, "");
            Aplicacion.getMotor().establecerPartida("OTRSU" + i, "");
            Aplicacion.getMotor().establecerPartida("VINCU" + i, "");
        }
        for (int i = n2; i <= 2; ++i) {
            Aplicacion.getMotor().establecerPartida("ORD" + i, "");
            Aplicacion.getMotor().establecerPartida("FECHORD" + i, "");
        }
    }

    private boolean trasladarAscendientes() throws Exception {
        String string = "ASCENDIENTES";
        String string2 = "";
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        String string3 = "";
        String string4 = "";
        String string5 = "";
        int n4 = 1;
        while ((long)n4 <= Aplicacion.getMotor().recordCount(string)) {
            Aplicacion.getMotor().move(string, n4);
            string2 = Aplicacion.getMotor().obtenerPartidaString("VINAS");
            string3 = "APENAS;PCTMINAS;VINAS;CONVAS;ANOAS;DNIAS";
            string4 = "ZAPENAS;ZPCTMINAS;ZVINAS;ZCONVAS;ZANOAS;ZDNIAS";
            string5 = this.funcrenta.obtenerValores(string3);
            String[] stringArray = string5.split("~");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(" ") || !stringArray[i].substring(stringArray[i].length() - 1, stringArray[i].length()).equals(" ")) continue;
                stringArray[i] = stringArray[i].substring(0, stringArray[i].length() - 1);
            }
            if (stringArray[2].equalsIgnoreCase("D")) {
                stringArray[2] = "1";
            } else if (stringArray[2].equalsIgnoreCase("C")) {
                stringArray[2] = "2";
            }
            if (string2.equalsIgnoreCase("D")) {
                string4 = "ZAPENAS" + n + ";ZPCTMINAS" + n + ";VINAS" + n + ";CONVAS" + n + ";ZANOAS" + n + ";ZDNIAS" + n;
                this.funcrenta.copiarValoresAPartidas2(stringArray, string4, Declarantes.Declarante);
                ++n;
                n3 = this.paraConjunta(n3, stringArray);
            } else if (string2.equalsIgnoreCase("C")) {
                stringArray[2] = "1";
                string4 = "ZAPENAS" + n2 + ";ZPCTMINAS" + n2 + ";VINAS" + n2 + ";CONVAS" + n2 + ";ZANOAS" + n2 + ";ZDNIAS" + n2;
                this.funcrenta.copiarValoresAPartidas2(stringArray, string4, Declarantes.Conyuge);
                ++n2;
                stringArray[2] = "2";
                string4 = "ZAPENAS" + n3 + ";ZPCTMINAS" + n3 + ";VINAS" + n3 + ";CONVAS" + n3 + ";ZANOAS" + n3 + ";ZDNIAS" + n3;
                this.funcrenta.copiarValoresAPartidas2(stringArray, string4, Declarantes.UnidadFamiliar);
                ++n3;
            }
            ++n4;
        }
        string5 = " ~ ~ ~ ~ ~ ";
        while (n <= 4) {
            string4 = "ZAPENAS" + n + ";ZPCTMINAS" + n + ";VINAS" + n + ";CONVAS" + n + ";ZANOAS" + n + ";ZDNIAS" + n;
            this.funcrenta.copiarValoresAPartidas(string5, string4, Declarantes.Declarante);
            ++n;
        }
        if (FuncionesRentaComun.isBConyuge()) {
            while (n2 <= 4) {
                string4 = "ZAPENAS" + n2 + ";ZPCTMINAS" + n2 + ";VINAS" + n2 + ";CONVAS" + n2 + ";ZANOAS" + n2 + ";ZDNIAS" + n2;
                this.funcrenta.copiarValoresAPartidas(string5, string4, Declarantes.Conyuge);
                ++n2;
            }
        }
        if (FuncionesRentaComun.isBConjunta()) {
            while (n3 <= 4) {
                string4 = "ZAPENAS" + n3 + ";ZPCTMINAS" + n3 + ";VINAS" + n3 + ";CONVAS" + n3 + ";ZANOAS" + n3 + ";ZDNIAS" + n3;
                this.funcrenta.copiarValoresAPartidas(string5, string4, Declarantes.UnidadFamiliar);
                ++n3;
            }
        }
        return true;
    }

    public String aceptacion() throws ExceptionMotor {
        FuncionesDF funcionesDF = null;
        try {
            Aplicacion.getMotor().establecerEstado("ECIVIL", 254);
            Aplicacion.getMotor().establecerEstado("CASADO", 254);
            Aplicacion.getMotor().establecerEstado("SOLTERO", 254);
            Aplicacion.getMotor().establecerEstado("VIUDO", 254);
            Aplicacion.getMotor().establecerEstado("SEPARADO", 254);
            Aplicacion.getMotor().establecerEstado("PH18", 254);
            Aplicacion.getMotor().establecerEstado("NORESIDENTE", 254);
            Aplicacion.getMotor().establecerEstado("DECFAL", 254);
            Aplicacion.getMotor().establecerEstado("HIJREN", 254);
            boolean bl = Boolean.parseBoolean(Aplicacion.getMotor().obtenerPartidaString("INDV"));
            boolean bl2 = Aplicacion.getMotor().obtenerPartidaString("CASADO").equalsIgnoreCase("true") && !bl;
            String string = Aplicacion.getMotor().obtenerPartidaString("HIJREN");
            String string2 = Aplicacion.getMotor().obtenerPartidaString("PH18");
            int n = DatosPersonales.numeroHijos(string);
            Document document = (Document)Aplicacion.getMotor().getDatos();
            int n2 = Aplicacion.getMotor().obtenerEstadoPartida("DPACEPTADOS");
            if (n2 == 255) {
                int n3;
                int n4;
                int n5;
                DatosPersonales.aceptarDeclarante(document);
                this.aceptarConyuge(document, bl2);
                for (n5 = 1; n5 <= Constantes.getNumhijosrentas(); ++n5) {
                    if (n <= n5 - 1 || FuncionesRentaComun.isBHijos(n5)) continue;
                    this.aceptarHijo(document, n5);
                }
                this.aceptarConjunta(document, bl2, n, string2, bl);
                n5 = 0;
                if (!bl2 && AEATHerramientas.localizacionNodoIRPFConTitular(document, Declarantes.Conyuge) > 0) {
                    FuncionesRentaComun.setBConyuge(false);
                    DatosPersonales.colocateEnDeclaracion(Declarantes.Conyuge);
                    Aplicacion.getMotor().borrarRegistro("IRPF2014");
                    Aplicacion.getMotor().moveFirst("IRPF2014");
                    Aplicacion.getMotor().removePtr("CONYUGE");
                    n5 = 1;
                }
                for (n4 = 1; n4 <= Constantes.getNumhijosrentas(); ++n4) {
                    if (n != n4 - 1 || AEATHerramientas.localizacionNodoIRPFConTitular(document, Declarantes.parseInt(20 + (n4 + 1) * 10)) <= 0) continue;
                    for (n3 = n + 1; n3 <= Constantes.getNumhijosrentas(); ++n3) {
                        FuncionesRentaComun.setBHijos(false, n3);
                        DatosPersonales.colocateEnDeclaracion(Declarantes.parseInt(20 + n3 * 10));
                        Aplicacion.getMotor().borrarRegistro("IRPF2014");
                        Aplicacion.getMotor().moveFirst("IRPF2014");
                        Aplicacion.getMotor().removePtr("HIJO" + n3);
                    }
                    n5 = 1;
                }
                int n6 = n4 = !bl && (FuncionesRentaComun.isBConyuge() || n > 0 || string2.equals("1")) ? 1 : 0;
                if (n5 == 0 && n4 == 0) {
                    n5 = 1;
                }
                this.paraBorrarConjunta(n5 != 0, n, string2, bl);
                this.initMotores();
                n3 = Aplicacion.getMotor().obtenerPartidaString("CASADO").equalsIgnoreCase("true") ? 1 : 0;
                boolean bl3 = Aplicacion.getMotor().obtenerPartidaString("SOLTERO").equalsIgnoreCase("true");
                boolean bl4 = Aplicacion.getMotor().obtenerPartidaString("SEPARADO").equalsIgnoreCase("true");
                boolean bl5 = Aplicacion.getMotor().obtenerPartidaString("VIUDO").equalsIgnoreCase("true");
                this.segunEstado(n3 != 0, bl5, bl3, bl4);
                this.funcrenta.irDeclaracion(Declarantes.Declarante);
                Aplicacion.getMotor().establecerEstado("DPACEPTADOS", 254);
                if (FuncionesRenta.isBConjunta()) {
                    funcionesDF = new FuncionesDF();
                    funcionesDF.copiarViviendaAConjunta();
                }
                return Boolean.TRUE.toString();
            }
            return Boolean.FALSE.toString();
        }
        catch (Exception exception) {
            return Boolean.FALSE.toString();
        }
    }

    public void initMotores() throws Exception {
        if (FuncionesRentaComun.isBConyuge()) {
            DatosPersonales.colocateEnDeclaracion(Declarantes.Conyuge);
            Aplicacion.getMotor().createPtr("CONYUGE", "IRPF2014");
            Aplicacion.getMotor().setCurrentPtr("DEFAULT");
        }
        int n = 1;
        while ((long)n <= Aplicacion.getMotor().recordCount("DESCENDIENTESRENTAS")) {
            if (FuncionesRenta.isBHijos(n)) {
                DatosPersonales.colocateEnDeclaracion(Declarantes.parseInt(20 + n * 10));
                Aplicacion.getMotor().createPtr("HIJO" + n, "IRPF2014");
                Aplicacion.getMotor().setCurrentPtr("DEFAULT");
            }
            ++n;
        }
        if (FuncionesRentaComun.isBConjunta()) {
            DatosPersonales.colocateEnDeclaracion(Declarantes.UnidadFamiliar);
            Aplicacion.getMotor().createPtr("CONJUNTA", "IRPF2014");
            Aplicacion.getMotor().setCurrentPtr("DEFAULT");
        }
        Aplicacion.getMotor().setCurrentPtr("DEFAULT");
        Aplicacion.getMotor().moveFirst("IRPF2014");
    }

    public static boolean colocateEnDeclaracion(Declarantes declarantes) throws ExceptionMotor {
        long l = Aplicacion.getMotor().obtenerClaveActiva("IRPF2014");
        long l2 = Aplicacion.getMotor().recordCount("IRPF2014");
        long l3 = Aplicacion.getMotor().moveFirst("IRPF2014");
        long l4 = -1L;
        while (l3 != l4) {
            String string = declarantes.getNombreUnico();
            if (declarantes.equals(Declarantes.Conyuge)) {
                string = "Conyuge";
            }
            if (Aplicacion.getMotor().obtenerPartidaString("TITULAR").equalsIgnoreCase(string)) {
                return true;
            }
            if (l3 == l2) {
                return false;
            }
            l4 = l3;
            l3 = Aplicacion.getMotor().moveNext("IRPF2014");
        }
        Aplicacion.getMotor().move("IRPF2014", l);
        return true;
    }

    private static int vinculacionD(String string, int n) throws ExceptionMotor {
        int n2 = n;
        if (string.equalsIgnoreCase("A")) {
            Aplicacion.getMotor().establecerPartida("VINCU" + n, " ");
        } else if (string.equalsIgnoreCase("B")) {
            Aplicacion.getMotor().establecerPartida("VINCU" + n, "1");
        } else if (string.equalsIgnoreCase("D")) {
            Aplicacion.getMotor().establecerPartida("VINCU" + n, "3");
        }
        return ++n2;
    }

    private static int vinculacionC(int n, String string) throws ExceptionMotor {
        int n2 = n;
        if (string.equalsIgnoreCase("A")) {
            Aplicacion.getMotor().establecerPartida("VINCU" + n, " ");
        } else if (string.equalsIgnoreCase("C")) {
            Aplicacion.getMotor().establecerPartida("VINCU" + n, "1");
        } else if (string.equalsIgnoreCase("E")) {
            Aplicacion.getMotor().establecerPartida("VINCU" + n, "3");
        }
        return ++n2;
    }

    private static void vinculacionO(int n, String string) throws ExceptionMotor {
        if (string.equalsIgnoreCase("A")) {
            Aplicacion.getMotor().establecerPartida("VINCU" + n, " ");
        } else if (string.equalsIgnoreCase("B")) {
            Aplicacion.getMotor().establecerPartida("VINCU" + n, "1");
        } else if (string.equalsIgnoreCase("C")) {
            Aplicacion.getMotor().establecerPartida("VINCU" + n, "2");
        } else if (string.equalsIgnoreCase("D")) {
            Aplicacion.getMotor().establecerPartida("VINCU" + n, "3");
        } else if (string.equalsIgnoreCase("E")) {
            Aplicacion.getMotor().establecerPartida("VINCU" + n, "4");
        }
    }

    private int paraConjunta(int n, String[] stringArray) throws Exception {
        int n2 = n;
        if (FuncionesRentaComun.isBConjunta()) {
            String string = "ZAPENAS" + n + ";ZPCTMINAS" + n + ";VINAS" + n + ";CONVAS" + n + ";ZANOAS" + n + ";ZDNIAS" + n;
            this.funcrenta.copiarValoresAPartidas2(stringArray, string, Declarantes.UnidadFamiliar);
            ++n2;
        }
        return n2;
    }

    private static void aceptarDeclarante(Document document) throws ExceptionMotor, XPathException {
        if (AEATHerramientas.localizacionNodoIRPFConTitular(document, Declarantes.Declarante) < 0) {
            Aplicacion.getMotor().anniadirRegistro("IRPF2014");
            Aplicacion.getMotor().establecerPartida("TITULAR", "DECLARANTE");
            Aplicacion.getMotor().moveFirst("IRPF2014");
        }
    }

    private void aceptarConyuge(Document document, boolean bl) throws Exception {
        if (bl) {
            if (AEATHerramientas.localizacionNodoIRPFConTitular(document, Declarantes.Conyuge) < 0) {
                Aplicacion.getMotor().anniadirRegistro("IRPF2014");
                Aplicacion.getMotor().establecerPartida("TITULAR", "CONYUGE");
                Aplicacion.getMotor().moveFirst("IRPF2014");
            }
            FuncionesRentaComun.setBConyuge(true);
        }
    }

    private void aceptarHijo(Document document, int n) throws Exception {
        if (AEATHerramientas.localizacionNodoIRPFConTitular(document, Declarantes.parseInt(20 + n * 10)) < 0) {
            Aplicacion.getMotor().anniadirRegistro("IRPF2014");
            Aplicacion.getMotor().establecerPartida("TITULAR", "HIJO" + n);
            Aplicacion.getMotor().moveFirst("IRPF2014");
        }
        FuncionesRentaComun.setBHijos(true, n);
    }

    private void aceptarConjunta(Document document, boolean bl, int n, String string, boolean bl2) throws Exception {
        if ((bl || n > 0 || string.equals("1")) && !bl2 && !FuncionesRentaComun.isBConjunta()) {
            if (AEATHerramientas.localizacionNodoIRPFConTitular(document, Declarantes.UnidadFamiliar) < 0) {
                Aplicacion.getMotor().anniadirRegistro("IRPF2014");
                Aplicacion.getMotor().establecerPartida("TITULAR", "CONJUNTA");
                Aplicacion.getMotor().moveFirst("IRPF2014");
            }
            FuncionesRentaComun.setBConjunta(true);
        }
    }

    private void paraBorrarConjunta(boolean bl, int n, String string, boolean bl2) throws Exception {
        if (bl) {
            FuncionesRentaComun.setBConjunta(false);
            if (DatosPersonales.colocateEnDeclaracion(Declarantes.UnidadFamiliar)) {
                Aplicacion.getMotor().borrarRegistro("IRPF2014");
            }
            Aplicacion.getMotor().moveFirst("IRPF2014");
            if (Aplicacion.getMotor().existsPtr("CONJUNTA")) {
                Aplicacion.getMotor().removePtr("CONJUNTA");
            }
            if (!bl2 && (FuncionesRentaComun.isBConyuge() || n > 0 || string.equals("1"))) {
                FuncionesRentaComun.setBConjunta(true);
                Aplicacion.getMotor().anniadirRegistro("IRPF2014");
                Aplicacion.getMotor().establecerPartida("TITULAR", "CONJUNTA");
                Aplicacion.getMotor().moveFirst("IRPF2014");
            }
        }
    }

    private void segunEstado(boolean bl, boolean bl2, boolean bl3, boolean bl4) throws Exception {
        if (bl || bl2 || bl4) {
            this.funcrenta.irDeclaracion(Declarantes.Declarante);
            Aplicacion.getMotor().establecerEstado("DECCT6", true);
            if (FuncionesRentaComun.isBConyuge()) {
                this.funcrenta.irDeclaracion(Declarantes.Conyuge);
                Aplicacion.getMotor().establecerEstado("DECCT6", true);
            }
            if (FuncionesRentaComun.isBConjunta()) {
                this.funcrenta.irDeclaracion(Declarantes.UnidadFamiliar);
                Aplicacion.getMotor().establecerEstado("DECCT6", true);
            }
        } else if (bl3) {
            this.funcrenta.irDeclaracion(Declarantes.Declarante);
            Aplicacion.getMotor().establecerEstado("DECCT6", false);
        }
    }

    private static int numeroHijos(String string) {
        int n = 0;
        if (string != null && string.length() > 0) {
            n = Integer.parseInt(string);
        }
        return n;
    }
}

