/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.re14.gui.df;

import es.aeat.pare.aplicacion.Aplicacion;
import es.aeat.pare.aplicacion.Constantes;
import es.aeat.pare.cc14.Declarantes;
import es.aeat.pare.componentes.AEATHerramientas;
import es.aeat.pare.componentes.JMensajesProperties;
import es.aeat.pare.comunDF.ControladorDF;
import es.aeat.pare.comunDF.DatosGlobalesDF;
import es.aeat.pare.comunDF.FuncionesDF;
import es.aeat.pare.re14.AEAT100j;
import es.aeat.pare.re14.gui.Dialogos.JDlgSelIndividual;
import es.aeat.pare.re14.gui.JPanelVacio;
import es.aeat.pare.re14.gui.df.AccesoDatosDFescritorio;
import es.aeat.pare.re14.gui.df.JDlgDFInicio;
import es.aeat.pare.re14.gui.df.JDlgDFIrDeclaracion;
import es.aeat.pare.re14.gui.df.JDlgDFPSelDeclarantes;
import es.aeat.pare.re14.gui.df.JDlgDFPropuestaColectiva;
import es.aeat.pare.re14.gui.df.JDlgDFTrataUF;
import es.aeat.pare.re14.gui.df.JPanelCarruselDF;
import es.aeat.pare.re14.motor.DatosPersonales;
import es.aeat.pare.re14.motor.FuncionesRenta;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.gob.aeat.dit.ov.renta.RentaDFPT;
import java.awt.Cursor;
import java.io.File;
import javax.swing.table.DefaultTableModel;

public class NavegadorDF {
    private JDlgDFInicio inicio;
    private JDlgDFPSelDeclarantes selDecla;
    private boolean bSalidaSelDecla = false;
    private JDlgDFTrataUF trataUF;
    private JPanelCarruselDF carrusel;
    private JDlgDFPropuestaColectiva propCole;
    private JDlgDFIrDeclaracion irDecla;
    private final ControladorDF ctrDF = new ControladorDF();
    private final FuncionesDF fDF;
    private final FuncionesRenta fr;
    private final AccesoDatosDFescritorio mAcc;
    private String mMensajeErrorPieza;

    public NavegadorDF() throws Exception {
        this.ctrDF.setModoTraslado(1);
        this.fDF = new FuncionesDF();
        this.fr = new FuncionesRenta();
        this.mAcc = new AccesoDatosDFescritorio();
        this.ctrDF.setAccesoDatos(this.mAcc);
        this.lanzarDfInicio();
    }

    private void lanzarDfInicio() throws ExceptionMotor {
        this.inicio = new JDlgDFInicio(this);
        AEATHerramientas.traducirDlg(this.inicio, Aplicacion.getmResource());
        if (Aplicacion.isECR()) {
            this.inicio.traducirEspecial();
        }
        this.inicio.pack();
        this.inicio.setResizable(false);
        AEATHerramientas.centrarVentana(this.inicio);
        this.inicio.setVisible(true);
    }

    public void empezarDatosFiscales() throws Exception {
        this.inicio.setVisible(false);
        String string = Aplicacion.getmResourceAyuda().getString("manejodelprograma");
        JDlgSelIndividual jDlgSelIndividual = new JDlgSelIndividual();
        AEATHerramientas.visualizarDialogo(jDlgSelIndividual, string);
        Aplicacion.getMotor().partidaModificada("DF_ESTADO_TAM", 0);
        this.lanzarSelDecla();
    }

    public void salidaSelDecla(boolean bl) throws Exception {
        if (bl) {
            this.ctrDF.construirUnidadFamiliar();
        }
        this.bSalidaSelDecla = bl;
    }

    private void mostrarAvisosDespuesDeIncorporar() throws Exception {
        JMensajesProperties jMensajesProperties = null;
        String string = "";
        if (this.ctrDF.getDeclaranteActual().equals(Declarantes.Declarante) && !this.ctrDF.getAnalizador(10).hayAnulacionDatosPersonales()) {
            if (!this.ctrDF.getDG().hayHijoNacidoEnEjercicio()) {
                string = JMensajesProperties.dameMensaje("DFP_OK1");
            } else if (this.ctrDF.getDG().hayHijoNacidoEnEjercicio()) {
                string = JMensajesProperties.dameMensaje("DFP_OK2");
            }
            jMensajesProperties = new JMensajesProperties(string, 16, true);
            jMensajesProperties.muestraMensaje();
            if (this.ctrDF.getAnalizador(10).hayCaso4()) {
                jMensajesProperties = new JMensajesProperties("DFERR25", 16, true);
                jMensajesProperties.muestraMensaje();
            }
        }
    }

    private void lanzarSelDecla() throws Exception {
        this.selDecla = new JDlgDFPSelDeclarantes(this);
        String string = Aplicacion.getmResourceAyuda().getString("incorporacindedatosfiscales");
        AEATHerramientas.visualizarDialogo(this.selDecla, string, true);
        if (this.bSalidaSelDecla) {
            this.salidaSelDeclaAceptando();
        } else {
            this.salidaSelDeclaCancelando();
        }
    }

    public void salidaSelDeclaAceptando() throws Exception {
        this.selDecla.setVisible(false);
        if (this.ctrDF.getMapaUnidadFamiliar().size() > 1 && DatosGlobalesDF.OS_WINDOWS) {
            this.lanzarPropuestaColectiva();
        } else {
            this.lanzarTrataUF();
        }
    }

    public void salidaSelDeclaCancelando() throws Exception {
        this.selDecla.setVisible(false);
        Aplicacion.getMotor().partidaModificada("DF_ESTADO_TAM", 0);
        this.terminarDatosFiscalesRentaEscritorio();
    }

    public void salidaPropuestaColectivaBotonIndividual() throws Exception {
        this.propCole.setVisible(false);
        try {
            this.lanzarTrataUF();
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.printStackTrace();
        }
    }

    private void lanzarPropuestaColectiva() throws ExceptionMotor {
        if (null == this.propCole) {
            this.propCole = new JDlgDFPropuestaColectiva(this, this.ctrDF.getMapaUnidadFamiliar().size());
        }
        this.propCole.pack();
        this.propCole.setResizable(false);
        AEATHerramientas.centrarVentana(this.propCole);
        this.propCole.setVisible(true);
    }

    private void lanzarTrataUF() throws Exception {
        if (null == this.trataUF) {
            this.trataUF = new JDlgDFTrataUF(this.ctrDF, this);
        }
        this.trataUF.habilitaComponentes();
        if (!this.ctrDF.hayDeclaracionIndividualSobrevenida()) {
            this.trataUF.pack();
            this.trataUF.setResizable(false);
            AEATHerramientas.centrarVentana(this.trataUF);
            this.trataUF.setCursor(new Cursor(0));
            this.trataUF.setVisible(true);
        }
    }

    public void salidaPropuestaColectivaBotonMagic() throws Exception {
        this.propCole.setVisible(false);
        this.lanzarPiezaExternaUnidadFamiliar();
    }

    public void lanzarPiezaExternaUnidadFamiliar() throws Exception {
        String string;
        String[] stringArray = new String[this.ctrDF.getMapaUnidadFamiliar().size()];
        String[] stringArray2 = new String[this.ctrDF.getMapaUnidadFamiliar().size()];
        String[] stringArray3 = new String[this.ctrDF.getMapaUnidadFamiliar().size()];
        String[] stringArray4 = new String[this.ctrDF.getMapaUnidadFamiliar().size()];
        int n = 0;
        if (this.ctrDF.getMapaUnidadFamiliar().containsKey(10)) {
            stringArray[n] = this.ctrDF.getMapaUnidadFamiliar().get(10);
            stringArray2[n] = this.ctrDF.getMapaApellidosUnidadFamiliar().get(10);
            stringArray3[n] = "DFP";
            stringArray4[n] = Declarantes.parseInt(10).getNombreUnico();
            ++n;
        }
        if (this.ctrDF.getMapaUnidadFamiliar().containsKey(20)) {
            stringArray[n] = this.ctrDF.getMapaUnidadFamiliar().get(20);
            stringArray2[n] = this.ctrDF.getMapaApellidosUnidadFamiliar().get(20);
            stringArray3[n] = "DF";
            stringArray4[n] = Declarantes.parseInt(20).getNombreUnico();
            ++n;
        }
        int n2 = 0;
        int n3 = 30;
        while (n2 < Constantes.getNumhijosrentas()) {
            if (this.ctrDF.getMapaUnidadFamiliar().containsKey(n3)) {
                stringArray[n] = this.ctrDF.getMapaUnidadFamiliar().get(n3);
                stringArray2[n] = this.ctrDF.getMapaApellidosUnidadFamiliar().get(n3);
                stringArray3[n] = "DF";
                stringArray4[n] = Declarantes.parseInt(n3).getNombreUnico();
                ++n;
            }
            ++n2;
            n3 += 10;
        }
        RentaDFPT rentaDFPT = new RentaDFPT();
        boolean bl = false;
        if (Aplicacion.isECR() && Aplicacion.isEntornoIca()) {
            string = Aplicacion.getDirectorioRed();
            if (!(string = string.replace('\\', '/')).endsWith("/")) {
                string = string + "/";
            }
            string = string + "aeat/";
        } else {
            string = Aplicacion.configuracion().dameEntrada("rutaDF");
            if (null == string || string.length() < 1) {
                string = AEATHerramientas.dameRutaParaDescargaDF();
            }
        }
        String[][] stringArray5 = null;
        if (Aplicacion.isECR()) {
            int n4;
            if (Aplicacion.getCoddef().getCodigoDF() == 58176) {
                n4 = 2;
            } else if (Aplicacion.getCoddef().getCodigoDF() == 62880) {
                n4 = 3;
            } else {
                throw new IllegalStateException("Tipo de Entidad desconocida");
            }
            stringArray5 = rentaDFPT.getDatosFiscales(null, Constantes.getColorBK(), stringArray, stringArray2, stringArray3, stringArray4, string, n4, Aplicacion.getsIdioma().substring(1));
        } else {
            try {
                stringArray5 = rentaDFPT.getDatosFiscales(null, Constantes.getColorBK(), stringArray, stringArray2, stringArray3, stringArray4, string, 1, Aplicacion.getsIdioma().substring(1));
            }
            catch (Exception exception) {
                bl = true;
                this.mMensajeErrorPieza = exception.getMessage();
                exception.printStackTrace();
            }
        }
        this.salidaPiezaExterna(stringArray5, string, true, bl);
    }

    private void catchSalidaPiezaExterna() throws Exception {
        for (int i = 10; i < 100; i += 10) {
            if (!this.ctrDF.getMapaUnidadFamiliar().containsKey(i)) continue;
            this.ctrDF.getMapaErroresPieza().put(i, "Error DFRetriever, " + this.mMensajeErrorPieza);
        }
        this.lanzarTrataUF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void salidaPiezaExterna(String[][] stringArray, String string, boolean bl, boolean bl2) throws ExceptionMotor, Exception {
        if (bl2) {
            this.catchSalidaPiezaExterna();
        } else {
            boolean bl3 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i][1].toString().toLowerCase().indexOf("cancelado") == -1) continue;
                bl3 = true;
                break;
            }
            if (bl3) {
                if (bl) {
                    this.lanzarPropuestaColectiva();
                } else {
                    this.lanzarTrataUF();
                }
            } else {
                File file = null;
                try {
                    AEAT100j.getFrame().setCursor(new Cursor(3));
                    block6: for (int i = 0; i < stringArray.length; ++i) {
                        for (int j = 10; j < 100; j += 10) {
                            String string2;
                            if (!this.ctrDF.getMapaUnidadFamiliar().containsKey(j) || !this.ctrDF.getMapaUnidadFamiliar().get(j).equals(stringArray[i][0])) continue;
                            if (stringArray[i][1].toString().substring(0, 2).equals("00")) {
                                string2 = stringArray[i][1].toString().substring(3, stringArray[i][1].length());
                                file = new File(string + string2);
                                if (null == Aplicacion.configuracion().dameEntrada("rutaDF")) {
                                    Aplicacion.configuracion().escribeEntrada("rutaDF", string);
                                }
                                this.ctrDF.setFichero(file, j);
                                continue block6;
                            }
                            string2 = this.dameErrorConSaltos(stringArray[i][1].toString());
                            this.ctrDF.borrarFichero(j);
                            this.ctrDF.setDatosCorrectos(j, false);
                            this.ctrDF.getMapaErroresPieza().put(j, string2);
                            continue block6;
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    if (null != file) {
                        file.setReadable(true);
                        file.setWritable(true);
                        file = null;
                    }
                    AEAT100j.getFrame().setCursor(new Cursor(0));
                }
                this.lanzarTrataUF();
            }
        }
    }

    private String dameErrorConSaltos(String string) {
        int n = 70;
        String string2 = "Error en la descarga de datos fiscales";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        if (string.length() > 3 && (string2 = string.substring(3, string.length())).length() > n) {
            int n2 = string2.substring(n - 1).indexOf(" ");
            string3 = string2.substring(0, n - 1 + n2);
            string4 = string2.substring(n + n2);
            if (string4.length() > n) {
                n2 = string4.substring(n - 1).indexOf(" ");
                string5 = string4.substring(0, n - 1 + n2);
                string6 = string4.substring(n + n2);
                string4 = string5 + "\n" + string6;
            }
            string2 = string3 + "\n" + string4;
        }
        return string2;
    }

    private void lanzarPiezaExternaIndividual(int n) throws Exception {
        String string;
        String[] stringArray = new String[]{this.ctrDF.getMapaUnidadFamiliar().get(n)};
        String[] stringArray2 = new String[]{this.ctrDF.getMapaApellidosUnidadFamiliar().get(n)};
        String[] stringArray3 = new String[]{"DF"};
        if (n == 10) {
            stringArray3[0] = "DFP";
        }
        String[] stringArray4 = new String[]{Declarantes.parseInt(n).getNombreUnico()};
        RentaDFPT rentaDFPT = new RentaDFPT();
        boolean bl = false;
        if (Aplicacion.isECR() && Aplicacion.isEntornoIca()) {
            string = Aplicacion.getDirectorioRed();
            if (!(string = string.replace('\\', '/')).endsWith("/")) {
                string = string + "/";
            }
            string = string + "aeat/";
        } else {
            string = Aplicacion.configuracion().dameEntrada("rutaDF");
            if (null == string || string.length() < 1) {
                string = AEATHerramientas.dameRutaParaDescargaDF();
            }
        }
        String[][] stringArray5 = null;
        if (Aplicacion.isECR()) {
            int n2;
            if (Aplicacion.getCoddef().getCodigoDF() == 58176) {
                n2 = 2;
            } else if (Aplicacion.getCoddef().getCodigoDF() == 62880) {
                n2 = 3;
            } else {
                throw new IllegalStateException("Tipo de Entidad desconocida");
            }
            stringArray5 = rentaDFPT.getDatosFiscales(null, Constantes.getColorBK(), stringArray, stringArray2, stringArray3, stringArray4, string, n2, Aplicacion.getsIdioma().substring(1));
        } else {
            try {
                stringArray5 = rentaDFPT.getDatosFiscales(null, Constantes.getColorBK(), stringArray, stringArray2, stringArray3, stringArray4, string, 1, Aplicacion.getsIdioma().substring(1));
            }
            catch (Exception exception) {
                bl = true;
                this.mMensajeErrorPieza = exception.getMessage();
                exception.printStackTrace();
            }
        }
        this.salidaPiezaExterna(stringArray5, string, false, bl);
    }

    public void salidaTrataUfBotonInternet(int n) throws Exception {
        this.lanzarPiezaExternaIndividual(n);
    }

    public void salidaTrataUfBotonLocal() throws Exception {
        this.trataUF.setCursor(new Cursor(3));
        AEAT100j.getFrame().setCursor(new Cursor(3));
        AEATHerramientas.centrarVentana(this.trataUF);
        this.trataUF.habilitaComponentes();
        this.trataUF.setResizable(false);
        this.trataUF.setCursor(new Cursor(0));
        AEAT100j.getFrame().setCursor(new Cursor(0));
    }

    public void salidaTrataUfCancelando() throws Exception {
        this.trataUF.setVisible(false);
        this.terminarDatosFiscalesRentaEscritorio();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void salidaTrataUfIncorporarTodo() throws Exception {
        if (null != this.trataUF) {
            this.trataUF.setVisible(false);
        }
        this.ctrDF.controlRegistrosEAX();
        Aplicacion.getMotor().partidaModificada("DF_ESTADO_TAM", 2);
        this.ctrDF.arreglarHijosConRentasNoValidos();
        if (this.ctrDF.getNumHRdeclarados() > 0 && !Aplicacion.getMotor().obtenerPartidaString("PH18").equals(Aplicacion.getMotor().obtenerPartidaString("DF_PH18"))) {
            Aplicacion.getMotor().partidaModificada("PH18", Aplicacion.getMotor().obtenerPartidaString("DF_PH18"));
        }
        this.ctrDF.abirRamasXML();
        this.ctrDF.generaMapaPreguntasUrbana();
        try {
            AEAT100j.getFrame().setCursor(new Cursor(3));
            for (int i = 10; i < 100; i += 10) {
                if (!this.ctrDF.getMapaDatosCorrectos().containsKey(i) || !this.ctrDF.getMapaDatosCorrectos().get(i).booleanValue()) continue;
                this.ctrDF.setDeclarante(Declarantes.parseInt(i));
                if (i == 10) {
                    this.mostrarMensajesSituacionFamiliar();
                }
                if (this.ctrDF.getTienePreguntaUrbana(i)) {
                    this.lanzarPreguntaUrbana(i);
                }
                if (this.hayQueLanzarCarrusel(i)) {
                    this.lanzarCarrusel(i);
                    continue;
                }
                this.ctrDF.generaMapasRegistrosMarcados(i);
                this.ctrDF.lanzarTrasladoUnDeclarante(this.ctrDF.getTransformador(this.ctrDF.getDeclaranteActual().toInt()));
                this.mostrarAvisosDespuesDeIncorporar();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.ctrDF.setDeclarante(Declarantes.Declarante);
            AEAT100j.getFrame().setCursor(new Cursor(0));
        }
        this.terminarDatosFiscalesRentaEscritorio();
    }

    private boolean hayQueLanzarCarrusel(int n) throws Exception {
        boolean bl = false;
        for (int i = 0; i < this.ctrDF.getAnalizador(n).getListaClavesPresentes().size(); ++i) {
            if (!this.ctrDF.conceptoDebeMostrarseEnCarrusel(this.ctrDF.getAnalizador(n).getListaClavesPresentes().get(i), Declarantes.parseInt(n))) continue;
            return true;
        }
        return bl;
    }

    private void lanzarPreguntaUrbana(int n) throws Exception {
        String string = Declarantes.parseInt(n).getNombreUnicoTraducido();
        String string2 = "Datos del " + string + ":\n" + JMensajesProperties.dameMensaje("DFUR024");
        JMensajesProperties jMensajesProperties = new JMensajesProperties(30, string2, 8, 16, true);
        if (jMensajesProperties.muestraMensaje() == 0) {
            this.ctrDF.setRespuestaUrbana(n, Boolean.TRUE);
        } else {
            this.ctrDF.setRespuestaUrbana(n, Boolean.FALSE);
        }
        this.ctrDF.setUrbanaPreguntada(n);
    }

    public void salidaCarruselFinCorrecto() throws Exception {
        this.carrusel.getTablaRegDatos().setVisible(false);
        AEAT100j.getFrame().setCursor(new Cursor(3));
        this.ctrDF.generaMapasRegistrosMarcados(this.ctrDF.getDeclaranteActual().toInt());
        this.ctrDF.lanzarTrasladoUnDeclarante(this.ctrDF.getTransformador(this.ctrDF.getDeclaranteActual().toInt()));
        this.mostrarAvisosDespuesDeIncorporar();
    }

    public void salidaCarruselCancelando() {
        System.out.println("\nSe ha cancelado el carrusel del " + this.ctrDF.getDeclaranteActual().getNombreUnico());
        this.carrusel.getTablaRegDatos().setVisible(false);
    }

    private void lanzarResumenYAvisos() throws Exception {
        AEAT100j.getFrame().verDFP(1);
    }

    private void lanzarCarrusel(int n) throws Exception {
        this.mostrarMensajesFecha();
        this.carrusel = new JPanelCarruselDF(this.ctrDF, this);
        this.carrusel.visualizarTablaRegDatos();
    }

    private void mostrarMensajesSituacionFamiliar() throws Exception {
        JMensajesProperties jMensajesProperties;
        String string = "";
        if (this.ctrDF.getAnalizador(10).hayAnulacionDatosPersonales()) {
            string = JMensajesProperties.dameMensaje("DFP_ERR");
            jMensajesProperties = new JMensajesProperties(string, true);
            jMensajesProperties.muestraMensaje();
        }
        if (this.ctrDF.getAnalizador(10).hayCaso11()) {
            string = JMensajesProperties.dameMensaje("DF_ERR5");
            jMensajesProperties = new JMensajesProperties(string, true);
            jMensajesProperties.muestraMensaje();
        }
    }

    private void mostrarMensajesFecha() throws ExceptionMotor {
        if (null != this.ctrDF.getTransformador(this.ctrDF.getDeclaranteActual().toInt()).seleccionaTabla("DI")) {
            String string = "";
            String string2 = this.ctrDF.getTransformador(this.ctrDF.getDeclaranteActual().toInt()).seleccionaTabla("DI")[0][3];
            String string3 = this.ctrDF.getTransformador(this.ctrDF.getDeclaranteActual().toInt()).seleccionaTabla("DI")[0][4];
            boolean bl = !"".equals(string2);
            boolean bl2 = this.ctrDF.getDeclaranteActual().equals(Declarantes.Declarante);
            if (Aplicacion.isECR() && bl2 && bl) {
                string = "DFECH3";
            } else if (Aplicacion.isECR() && bl2 && !bl) {
                string = "DFECH1";
            } else if (Aplicacion.isECR() && !bl2 && bl) {
                string = "DFECH4";
            } else if (Aplicacion.isECR() && !bl2 && !bl) {
                string = "DFECH2";
            } else if (!Aplicacion.isECR() && bl2) {
                string = "DFECH1";
            } else if (!Aplicacion.isECR() && !bl2) {
                string = "DFECH2";
            }
            String string4 = JMensajesProperties.dameMensaje(string);
            string4 = string4 + " " + string3;
            if (string4.endsWith(".")) {
                string4 = string4.substring(0, string4.length() - 2);
            }
            string4 = string4 + ".\n" + Aplicacion.getmResource().getString("df.mensaje.ficheroCorresponde") + " " + this.ctrDF.getDeclaranteActual().getNombreUnico();
            JMensajesProperties jMensajesProperties = new JMensajesProperties(string4, 16, true);
            jMensajesProperties.muestraMensaje();
        }
    }

    public boolean[] dameMarcadosTableModel(DefaultTableModel defaultTableModel) {
        boolean[] blArray = new boolean[defaultTableModel.getDataVector().size()];
        for (int i = 0; i < defaultTableModel.getDataVector().size(); ++i) {
            blArray[i] = this.fDF.estaMarcado(defaultTableModel, i);
        }
        return blArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminarDatosFiscalesRentaEscritorio() throws Exception {
        this.fr.irDeclaracion(Declarantes.Declarante);
        try {
            AEAT100j.getFrame().setCursor(new Cursor(3));
            String string = Aplicacion.getMotor().obtenerPartidaString("DF_ESTADO_TAM");
            this.ctrDF.guardarDatosFiscales();
            this.ctrDF.operacionesDespuesDeGuardarDatosFiscales();
            if (this.fDF.hayDatosFiscalesIncorporados()) {
                this.lanzarResumenYAvisos();
                AEAT100j.getFrame().setCursor(new Cursor(3));
                this.ctrDF.ultimasOperacionesDF();
                this.ctrDF.lanzaCaluclosYValidaciones();
                this.ctrDF.trasladarIBAN();
                AEAT100j.getFrame().setCursor(new Cursor(0));
            }
            if (!this.ctrDF.getSalidaFuncionValidaDatosPersonales()) {
                this.salidaIrDeclaracionBotonIrDP();
            } else if ("1".equals(string)) {
                this.salidaIrDeclaracionBotonIrDecla();
            } else if ("0".equals(string) || "2".equals(string)) {
                this.lanzarPreguntaIrDeclaracion();
            }
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.printStackTrace();
            System.out.println("Error en m\u00e9todo terminarDatosFiscales()");
        }
        finally {
            AEAT100j.getFrame().setCursor(new Cursor(0));
        }
    }

    private void lanzarPreguntaIrDeclaracion() throws ExceptionMotor {
        if (null == this.irDecla) {
            this.irDecla = new JDlgDFIrDeclaracion(this);
        }
        this.irDecla.setResizable(false);
        this.irDecla.pack();
        AEATHerramientas.centrarVentana(this.irDecla);
        this.irDecla.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void salidaIrDeclaracionBotonIrDP() throws ExceptionMotor {
        try {
            AEAT100j.getFrame().setCursor(new Cursor(3));
            Aplicacion.getMotor().partidaModificada("DF_DP", "false");
            if (null != this.irDecla) {
                this.irDecla.setVisible(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            AEAT100j.getFrame().setCursor(new Cursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void salidaIrDeclaracionBotonIrDecla() throws Exception {
        if (null != this.irDecla) {
            this.irDecla.setVisible(false);
        }
        try {
            AEAT100j.getFrame().setCursor(new Cursor(3));
            Aplicacion.getMotor().partidaModificada("DF_DP", "true");
            Aplicacion.getMotor().partidaModificada("DPACEPTADOS", "true");
            DatosPersonales datosPersonales = new DatosPersonales();
            datosPersonales.aceptacion();
            AEAT100j.getFrame().finalizarCarruselDatosPersonales(new JPanelVacio(), true);
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.printStackTrace();
        }
        finally {
            AEAT100j.getFrame().setCursor(new Cursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buscarTodosFicherosEnLocal() throws Exception {
        boolean bl = true;
        File file = null;
        try {
            int n;
            int n2;
            AEAT100j.getFrame().setCursor(new Cursor(3));
            String string = AEATHerramientas.compruebaRutaParaFicherosSinoEstablecerPorDefecto(null);
            String string2 = this.ctrDF.getMapaUnidadFamiliar().get(10);
            String string3 = "";
            if (this.ctrDF.getMapaUnidadFamiliar().containsKey(20)) {
                string3 = this.ctrDF.getMapaUnidadFamiliar().get(20);
            }
            String[] stringArray = new String[this.ctrDF.getNumHRdeclarados()];
            for (n2 = 0; n2 < this.ctrDF.getNumHRdeclarados(); ++n2) {
                n = 20 + (n2 + 1) * 10;
                if (!this.ctrDF.getMapaUnidadFamiliar().containsKey(n)) continue;
                stringArray[n2] = this.ctrDF.getMapaUnidadFamiliar().get(n);
            }
            file = new File(string + string2.substring(0, string2.length() - 1) + ".dfp");
            if (file.exists()) {
                this.ctrDF.setFichero(file, 10);
            } else {
                this.ctrDF.borrarFichero(10);
                bl = false;
            }
            if (this.ctrDF.getMapaUnidadFamiliar().containsKey(20)) {
                file = new File(string + string3.substring(0, string3.length() - 1) + ".df");
                if (file.exists()) {
                    this.ctrDF.setFichero(file, 20);
                } else {
                    this.ctrDF.borrarFichero(20);
                    bl = false;
                }
            }
            n2 = 0;
            n = 30;
            while (n2 < this.ctrDF.getNumHRdeclarados()) {
                if (this.ctrDF.getMapaUnidadFamiliar().containsKey(n)) {
                    file = new File(string + stringArray[n2].substring(0, stringArray[n2].length() - 1) + ".df");
                    if (file.exists()) {
                        this.ctrDF.setFichero(file, n);
                    } else {
                        this.ctrDF.borrarFichero(n);
                        bl = false;
                    }
                }
                ++n2;
                n += 10;
            }
        }
        catch (Exception exception) {
            System.out.println("Error en m\u00e9todo ControladorDatosFiscales::buscarTodosFicherosEnLocal()");
            exception.printStackTrace();
        }
        finally {
            if (null != file) {
                file.setReadable(true);
                file.setWritable(true);
                file = null;
            }
            AEAT100j.getFrame().setCursor(new Cursor(0));
        }
        return bl;
    }
}

