/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.re14.gui.df;

import es.aeat.pare.aplicacion.Aplicacion;
import es.aeat.pare.aplicacion.Constantes;
import es.aeat.pare.cc14.Declarantes;
import es.aeat.pare.componentes.AEATHerramientas;
import es.aeat.pare.componentes.AEATLogger;
import es.aeat.pare.componentes.JDialogo;
import es.aeat.pare.componentes.JMensajesProperties;
import es.aeat.pare.componentes.JTituloPag;
import es.aeat.pare.comunDF.AnalizadorDF;
import es.aeat.pare.comunDF.ControladorDF;
import es.aeat.pare.comunDF.DatosGlobalesDF;
import es.aeat.pare.comunDF.FuncionesDF;
import es.aeat.pare.comunDF.TransformardorDF;
import es.aeat.pare.re14.gui.Dialogos.JDlgMatMeses;
import es.aeat.pare.re14.gui.df.AccesoDatosDFescritorio;
import es.aeat.pare.re14.gui.df.JDlgDF4ImportesEAA;
import es.aeat.pare.re14.gui.df.JDlgDF4ImportesEAD;
import es.aeat.pare.re14.gui.df.JDlgDFActividades;
import es.aeat.pare.re14.gui.df.JDlgDFDonacionesCyL;
import es.aeat.pare.re14.gui.df.JDlgDFGastos;
import es.aeat.pare.re14.gui.df.JDlgDFInmuebles;
import es.aeat.pare.re14.gui.df.JDlgDFPremios;
import es.aeat.pare.re14.gui.df.JDlgDFPrestamosHipotecarios;
import es.aeat.pare.re14.gui.df.JDlgDFSubvenciones;
import es.aeat.pare.re14.gui.df.JPanelDFAvanza;
import es.aeat.pare.re14.gui.df.NavegadorDF;
import es.aeat.pare.re14.gui.df.RenderCarrusel;
import es.aeat.pare.re14.gui.df.TraduccionesFicheroTabla;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class JPanelCarruselDF
extends JPanel
implements TableModelListener {
    private static final long serialVersionUID = 8458897840649397208L;
    private static final int MAX_LONG_TITULO_CARRUSEUL = 40;
    private TraduccionesFicheroTabla tft;
    private ControladorDF ctrDF;
    private NavegadorDF nave;
    private DatosGlobalesDF mDG;
    private AccesoDatosDFescritorio mAcc;
    private AnalizadorDF ana;
    private TransformardorDF trans;
    private FuncionesDF fDF;
    private Declarantes mDeclaranteActual;
    private JLabel jLBlabelAncla;
    private JPanelDFAvanza jPadf;
    private JTituloPag tituloDatos;
    private JScrollPane jSPscrollpane;
    private JDialog tablaRegDatos;
    private JTable jTableEntradas = new JTable();
    private DefaultTableModel[] modeloTabla;
    private int numModeloActual = 0;
    private int numModeloConDatosActual = 0;
    private int numTotalModelosConDatos;
    private Map<String, Boolean> mapaPrimeraVez = null;
    private JTextPane jTextNota1;
    private JPanel jPanelNota1;
    private JTextPane jTextNota2;
    private JPanel jPanelNota2;
    private boolean detenerTableModelListener = false;

    public JDialog getTablaRegDatos() {
        return this.tablaRegDatos;
    }

    public DefaultTableModel[] getModeloTabla() {
        return this.modeloTabla;
    }

    public int getNumModeloActual() {
        return this.numModeloActual;
    }

    public int getNumModeloConDatosActual() {
        return this.numModeloConDatosActual;
    }

    public int getTotalModelosConDatos() {
        return this.numTotalModelosConDatos;
    }

    private void calcularNumModelosConDatos() {
        int n = 0;
        for (int i = 0; i < this.modeloTabla.length; ++i) {
            if (null == this.modeloTabla[i]) continue;
            ++n;
        }
        this.numTotalModelosConDatos = n;
    }

    private void setNota1(String string) {
        this.jPanelNota1.setVisible(true);
        this.jTextNota1.setText(string);
        this.jPanelNota1.repaint();
    }

    private void setNota2(String string) {
        this.jPanelNota2.setVisible(true);
        this.jTextNota2.setText(string);
        this.jPanelNota2.repaint();
    }

    private void ponerNotas(String string) throws Exception {
        if (string.equalsIgnoreCase("TI")) {
            String string2 = "";
            if (null != this.mDG.getTablaTIdeclarante()) {
                string2 = this.mDG.getTablaTIdeclarante()[0][this.mDG.getColumnasTI().get("FechFal")];
                if (string2.equals("31/12/" + Constantes.getEjercicioString())) {
                    this.setNota1(Aplicacion.getmResource().getString("df.nota1.fall.31Dic"));
                    this.jPanelNota2.setVisible(false);
                } else {
                    this.jPanelNota1.setVisible(false);
                    this.jPanelNota2.setVisible(false);
                }
            }
        } else if (string.equalsIgnoreCase("DE")) {
            String string3 = "";
            boolean bl = false;
            boolean bl2 = this.trans.seleccionaTabla("DE").length > DatosGlobalesDF.MAX_DE;
            for (int i = 0; i < this.mDG.getTablaDE().length; ++i) {
                string3 = this.mDG.getTablaDE()[i][this.mDG.getColumnasDE().get("FechFal")];
                if (!string3.equals("31/12/" + Constantes.getEjercicioString())) continue;
                bl = true;
                break;
            }
            if (bl && !bl2) {
                this.setNota1(Aplicacion.getmResource().getString("df.nota1.fall.31Dic"));
                this.jPanelNota2.setVisible(false);
            } else if (bl2 && !bl) {
                this.setNota1(Aplicacion.getmResource().getString("df.nota2.de.max"));
                this.jPanelNota2.setVisible(false);
            } else if (bl && bl2) {
                this.setNota1(Aplicacion.getmResource().getString("df.nota1.fall.31Dic"));
                this.setNota2(Aplicacion.getmResource().getString("df.nota2.de.max"));
            } else {
                this.jPanelNota1.setVisible(false);
                this.jPanelNota2.setVisible(false);
            }
        } else if (string.equalsIgnoreCase("AS")) {
            boolean bl;
            boolean bl3 = bl = this.trans.seleccionaTabla("AS").length > DatosGlobalesDF.MAX_AS;
            if (bl) {
                this.setNota1(Aplicacion.getmResource().getString("df.nota1.as"));
                this.setNota2(Aplicacion.getmResource().getString("df.nota2.as.max"));
            } else if (!bl) {
                this.setNota1(Aplicacion.getmResource().getString("df.nota1.as"));
                this.jPanelNota2.setVisible(false);
            }
        } else if (string.equalsIgnoreCase("RTD")) {
            this.setNota1(Aplicacion.getmResource().getString("df.nota1.rtd"));
            this.jPanelNota2.setVisible(false);
        } else if (string.equalsIgnoreCase("CB")) {
            this.setNota1(Aplicacion.getmResource().getString("df.nota1.cb"));
            this.jPanelNota2.setVisible(false);
        } else if (string.equalsIgnoreCase("REA")) {
            this.setNota1(Aplicacion.getmResource().getString("df.nota1.rea"));
            this.jPanelNota2.setVisible(false);
        } else if (string.equalsIgnoreCase("RI")) {
            this.setNota1(Aplicacion.getmResource().getString("df.nota1.ri"));
            this.jPanelNota2.setVisible(false);
        } else if (string.equalsIgnoreCase("AE")) {
            this.setNota1(Aplicacion.getmResource().getString("df.nota1.ae"));
            this.jPanelNota2.setVisible(false);
        } else if (string.equalsIgnoreCase("SG")) {
            int n = 4;
            int n2 = 5;
            double d = 0.0;
            double d2 = 0.0;
            String[][] stringArray = this.trans.seleccionaTabla(string);
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                d = Double.parseDouble(stringArray[i][n]);
                d2 = Double.parseDouble(stringArray[i][n2]);
                if (d == 0.0 || d2 == 0.0) continue;
                bl = true;
                break;
            }
            if (bl) {
                this.setNota1(Aplicacion.getmResource().getString("df.nota1.sg"));
                this.jPanelNota2.setVisible(false);
            } else {
                this.jPanelNota1.setVisible(false);
                this.jPanelNota2.setVisible(false);
            }
        } else if (string.equalsIgnoreCase("CC")) {
            String[][] stringArray = this.trans.seleccionaTabla(string);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.ctrDF.registroObligatorio(stringArray[i], "CC")) continue;
                this.setNota1(Aplicacion.getmResource().getString("df.nota1.cc"));
                this.jPanelNota2.setVisible(false);
                break;
            }
        } else if (string.equalsIgnoreCase("CT")) {
            int n = 4;
            String[][] stringArray = this.trans.seleccionaTabla(string);
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i][n];
                if (null == string4 || "".equals(string4) || string4.toUpperCase().indexOf("S") == -1) continue;
                bl = true;
                break;
            }
            if (bl) {
                this.setNota1(Aplicacion.getmResource().getString("df.nota1.ct"));
                this.jPanelNota2.setVisible(false);
            } else {
                this.jPanelNota1.setVisible(false);
                this.jPanelNota2.setVisible(false);
            }
        } else if (string.equalsIgnoreCase("PH")) {
            this.setNota1(Aplicacion.getmResource().getString("df.nota1.ph"));
        } else if (string.equalsIgnoreCase("RTC")) {
            this.setNota1(Aplicacion.getmResource().getString("df.nota1.rtc"));
            this.jPanelNota2.setVisible(false);
        } else {
            this.jPanelNota1.setVisible(false);
            this.jPanelNota2.setVisible(false);
        }
    }

    public JPanelCarruselDF() throws ExceptionMotor {
        this.initComponents();
    }

    public JPanelCarruselDF(ControladorDF controladorDF, NavegadorDF navegadorDF) throws Exception {
        this.setName("@JPanelDFIncorporacionDatosFiscales");
        this.ctrDF = controladorDF;
        this.mDeclaranteActual = controladorDF.getDeclaranteActual();
        this.nave = navegadorDF;
        this.trans = controladorDF.getTransformador(controladorDF.getDeclaranteActual().toInt());
        this.mAcc = (AccesoDatosDFescritorio)controladorDF.getAccesoDatos();
        this.ana = controladorDF.getAnalizador(controladorDF.getDeclaranteActual().toInt());
        this.mDG = controladorDF.getDG();
        this.fDF = new FuncionesDF();
        this.tft = new TraduccionesFicheroTabla();
        this.initComponents();
        AEATHerramientas.ponColorBkGround(this, Constantes.getColorBK(), Constantes.getColorBkOscuro());
        try {
            this.estableceModelosTabla();
            this.crearTabla();
            this.calcularNumModelosConDatos();
            this.initRestComponents();
            this.generarMapaPrimeraVez(this.ana.getListaClavesPresentes());
            this.ponerTitulosAlModeloActual(this.getClaveActual());
        }
        catch (Exception exception) {
            AEATLogger.getLogger().debug((Object)exception);
        }
    }

    public void setDetenerTableModelListener(boolean bl) {
        this.detenerTableModelListener = bl;
    }

    @Override
    public synchronized void tableChanged(final TableModelEvent tableModelEvent) {
        if (this.detenerTableModelListener) {
            return;
        }
        if (tableModelEvent.getType() == 0 && tableModelEvent.getColumn() == 0 && tableModelEvent.getFirstRow() == tableModelEvent.getLastRow()) {
            final int n = tableModelEvent.getColumn();
            final int n2 = tableModelEvent.getFirstRow();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        JPanelCarruselDF.this.jTableEntradasMouseReleased(tableModelEvent.getSource(), n2, n);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
    }

    private void initComponents() throws ExceptionMotor {
        this.setLayout(new GridBagLayout());
        this.setBackground(Constantes.getColorDlgBk());
        AEATHerramientas.ponColorBkGround(this, Constantes.getColorBK(), Constantes.getColorBkOscuro());
        this.jTextNota1 = new JTextPane();
        this.jTextNota1.setEditable(false);
        this.jTextNota1.setFocusCycleRoot(false);
        this.jTextNota1.setFocusable(false);
        this.jTextNota1.setRequestFocusEnabled(false);
        this.jTextNota1.setOpaque(false);
        this.jTextNota1.setVerifyInputWhenFocusTarget(false);
        this.jPanelNota1 = new JPanel();
        this.jPanelNota1.setLayout(new GridLayout());
        this.jPanelNota1.setBorder(new TitledBorder(Aplicacion.getmResource().getString("df.nota1")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.jPanelNota1.add((Component)this.jTextNota1, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.gridheight = 2;
        gridBagConstraints2.insets = new Insets(15, 40, 5, 0);
        this.add((Component)this.jPanelNota1, gridBagConstraints2);
        this.jPanelNota1.setVisible(false);
        this.jTextNota2 = new JTextPane();
        this.jTextNota2.setEditable(false);
        this.jTextNota2.setFocusCycleRoot(false);
        this.jTextNota2.setFocusable(false);
        this.jTextNota2.setRequestFocusEnabled(false);
        this.jTextNota2.setOpaque(false);
        this.jTextNota2.setVerifyInputWhenFocusTarget(false);
        this.jPanelNota2 = new JPanel();
        this.jPanelNota2.setLayout(new GridLayout());
        this.jPanelNota2.setBackground(Constantes.getColorDlgBk());
        this.jPanelNota2.setBorder(new TitledBorder(Aplicacion.getmResource().getString("df.nota2")));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
        this.jPanelNota2.add(this.jTextNota2);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.anchor = 11;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridy = 5;
        gridBagConstraints4.gridwidth = 2;
        gridBagConstraints4.insets = new Insets(0, 40, 0, 0);
        this.add((Component)this.jPanelNota2, gridBagConstraints4);
        this.jPanelNota2.setVisible(false);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        this.tituloDatos = new JTituloPag("", "", "");
        this.tituloDatos.setName("tituloDatos");
        this.tituloDatos.setFocusCycleRoot(false);
        this.tituloDatos.setFocusable(false);
        this.tituloDatos.setRequestFocusEnabled(false);
        this.tituloDatos.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints5.anchor = 11;
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.gridheight = 1;
        gridBagConstraints5.gridwidth = 0;
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.ipadx = 0;
        gridBagConstraints5.ipady = 0;
        gridBagConstraints5.weightx = 0.0;
        gridBagConstraints5.weighty = 0.0;
        gridBagConstraints5.insets.bottom = 0;
        gridBagConstraints5.insets.left = 0;
        gridBagConstraints5.insets.right = 0;
        gridBagConstraints5.insets.top = 20;
        this.add((Component)this.tituloDatos, gridBagConstraints5);
        gridBagConstraints5 = new GridBagConstraints();
        this.jSPscrollpane = new JScrollPane(20, 30);
        this.jSPscrollpane.setName("jSPscrollpane");
        this.jSPscrollpane.setFocusCycleRoot(false);
        this.jSPscrollpane.setFocusable(false);
        this.jSPscrollpane.setRequestFocusEnabled(false);
        this.jSPscrollpane.setEnabled(false);
        this.jSPscrollpane.setOpaque(false);
        this.jSPscrollpane.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints5.anchor = 10;
        gridBagConstraints5.fill = 3;
        gridBagConstraints5.gridheight = 1;
        gridBagConstraints5.gridwidth = 3;
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.insets.top = 100;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width;
        int n2 = dimension.height;
        gridBagConstraints5.ipadx = n - (int)((double)n * 0.15);
        gridBagConstraints5.ipady = n2 - (int)((double)n2 * 0.79);
        this.add((Component)this.jSPscrollpane, gridBagConstraints5);
        gridBagConstraints5 = new GridBagConstraints();
        if (null == this.jPadf) {
            this.jPadf = new JPanelDFAvanza(this, this.nave, this.mDeclaranteActual);
        }
        this.jPadf.getBotonCancelar().setVisible(false);
        this.jPadf.setName("jPadf");
        this.jPadf.setFocusCycleRoot(false);
        this.jPadf.setFocusable(false);
        this.jPadf.setRequestFocusEnabled(false);
        this.jPadf.setEnabled(false);
        this.jPadf.setOpaque(false);
        this.jPadf.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints5.anchor = 13;
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.gridheight = 1;
        gridBagConstraints5.gridwidth = 3;
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 7;
        gridBagConstraints5.ipadx = 0;
        gridBagConstraints5.ipady = 0;
        gridBagConstraints5.insets.bottom = 25;
        gridBagConstraints5.insets.left = 0;
        gridBagConstraints5.insets.right = 0;
        gridBagConstraints5.insets.top = 0;
        this.add((Component)this.jPadf, gridBagConstraints5);
        this.tablaRegDatos = new JDialog();
        this.tablaRegDatos.setBackground(Constantes.getColorDlgBk());
        AEATHerramientas.ponColorBkGround(this.tablaRegDatos, Constantes.getColorBK(), Constantes.getColorBkOscuro());
        this.tablaRegDatos.setUndecorated(true);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        this.jLBlabelAncla = new JLabel(" ");
        this.jLBlabelAncla.setName("labelAncla");
        this.jLBlabelAncla.setFocusCycleRoot(false);
        this.jLBlabelAncla.setFocusable(false);
        this.jLBlabelAncla.setRequestFocusEnabled(false);
        this.jLBlabelAncla.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints6.anchor = 10;
        gridBagConstraints6.fill = 0;
        gridBagConstraints6.gridheight = 1;
        gridBagConstraints6.gridwidth = 0;
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 6;
        gridBagConstraints6.weightx = 0.0;
        gridBagConstraints6.weighty = 1.0;
        gridBagConstraints6.insets.bottom = 0;
        gridBagConstraints6.insets.left = 0;
        gridBagConstraints6.insets.right = 0;
        gridBagConstraints6.insets.top = 0;
        this.add((Component)this.jLBlabelAncla, gridBagConstraints6);
    }

    public void visualizarTablaRegDatos() throws Exception {
        this.tablaRegDatos.setTitle(Aplicacion.getmResource().getString("df.pasoCarrusel") + " 1 de " + this.numTotalModelosConDatos);
        this.tablaRegDatos.setModal(true);
        this.tablaRegDatos.getContentPane().add(this);
        this.tablaRegDatos.setDefaultCloseOperation(0);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width;
        int n2 = dimension.height;
        this.tablaRegDatos.setSize(new Dimension((int)((double)n * 0.95), (int)((double)n2 * 0.8)));
        this.tablaRegDatos.setResizable(true);
        AEATHerramientas.centrarVentana(this.tablaRegDatos);
        this.prepararVistaModeloActual(this.getClaveActual());
        this.jPadf.getBotonRetroceder().setEnabled(false);
        this.tablaRegDatos.setVisible(true);
    }

    private int primerNumModeloConDatos() {
        for (int i = 0; i < this.modeloTabla.length; ++i) {
            if (null == this.modeloTabla[i]) continue;
            return i;
        }
        AEATLogger.getLogger().error((Object)"M\u00e9todo primerNumModeloConDatos(), no se ha encontrado un modeloTabla con datos");
        return -1;
    }

    private void crearTabla() throws Exception {
        RenderCarrusel renderCarrusel = new RenderCarrusel(this, this.mDG, this.ctrDF);
        try {
            this.jTableEntradas.setDefaultRenderer(Class.forName("java.lang.String"), renderCarrusel);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.jTableEntradas.setModel(this.modeloTabla[this.primerNumModeloConDatos()]);
        this.numModeloActual = this.primerNumModeloConDatos();
        JCheckBox jCheckBox = new JCheckBox();
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jCheckBox){
            private static final long serialVersionUID = 2909307030371757112L;

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
                ((JCheckBox)component).setHorizontalTextPosition(0);
                ((JCheckBox)component).setText("                                ");
                ((JCheckBox)component).addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        JTable jTable = JPanelCarruselDF.this.jTableEntradas;
                        DefaultTableModel defaultTableModel = (DefaultTableModel)jTable.getModel();
                        for (int i = 0; i < JPanelCarruselDF.this.modeloTabla.length && JPanelCarruselDF.this.modeloTabla[i] != defaultTableModel; ++i) {
                        }
                    }
                });
                return component;
            }
        };
        this.jTableEntradas.setDefaultEditor(Boolean.class, defaultCellEditor);
        this.formatoTabla();
    }

    private void estableceModelosTabla() throws NumberFormatException, Exception {
        String string = "";
        this.modeloTabla = new DefaultTableModel[this.mAcc.getListaTodasClaves().size()];
        for (int i = 0; i < this.ana.getListaClavesPresentes().size(); ++i) {
            int n;
            string = this.ana.getListaClavesPresentes().get(i);
            boolean bl = this.mAcc.esClaveTrasladable(string);
            if (!this.ctrDF.conceptoDebeMostrarseEnCarrusel(string, this.mDeclaranteActual) || null == this.trans.seleccionaTabla(string)) continue;
            int n2 = this.mAcc.getMapaIndicesCodigoDF().get(string);
            int n3 = this.mAcc.cuantosCamposVisiblesTieneLaClave(string);
            Object[][] objectArray = this.mAcc.getDfCamposX().get(string);
            String[] stringArray = this.mAcc.getDfCamposE().get(string);
            if (n3 < stringArray.length) {
                stringArray = this.mAcc.getDfCamposEvisibles(string, stringArray.length - n3);
            }
            String[][] stringArray2 = this.trans.seleccionaTabla(string);
            Object[] objectArray2 = null;
            Object[] objectArray3 = null;
            objectArray2 = new String[n3 + 1];
            objectArray3 = new Object[n3 + 1];
            objectArray2[0] = Aplicacion.getmResource().getString("df.columnaTrasladar");
            for (n = 0; n < stringArray.length; ++n) {
                objectArray2[n + 1] = stringArray[n];
            }
            objectArray3[0] = Boolean.FALSE;
            this.modeloTabla[n2] = new DefaultTableModel(objectArray2, 0){
                private static final long serialVersionUID = -6204544165651310971L;

                public Class getColumnClass(int n) {
                    switch (n) {
                        case 0: {
                            return Boolean.class;
                        }
                    }
                    return String.class;
                }

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return n2 == 0;
                }

                @Override
                public void setValueAt(Object object, int n, int n2) {
                    if (this.getValueAt(n, n2) != object) {
                        super.setValueAt(object, n, n2);
                    }
                }

                class columna {
                    columna() {
                    }
                }
            };
            this.modeloTabla[n2].addTableModelListener(this);
            for (n = 0; n < stringArray2.length; ++n) {
                if (!this.ctrDF.registroDebeMostrarseEnCarrusel(stringArray2[n], string)) continue;
                int n4 = 0;
                if (bl) {
                    n4 = 1;
                }
                for (int j = 0; j < stringArray2[n].length; ++j) {
                    boolean bl2;
                    if (j >= objectArray.length || !(bl2 = ((Boolean)objectArray[j][7]).booleanValue())) continue;
                    String string2 = stringArray2[n][j];
                    String string3 = (String)objectArray[j][2];
                    int n5 = (Integer)objectArray[j][1];
                    if (string3.equalsIgnoreCase("N") && n5 > 0) {
                        string2 = this.fDF.formateaDoubleParaTableModel(string2);
                    }
                    objectArray3[n4] = string2;
                    ++n4;
                }
                this.modeloTabla[n2].addRow(objectArray3);
            }
        }
    }

    private void ponerTitulosAlModeloActual(String string) {
        boolean bl;
        String string2 = this.mDeclaranteActual.getNombreUnico() + " - " + (String)this.mAcc.getDfListas().get(string)[0];
        boolean bl2 = bl = string2.length() > 40;
        if (bl) {
            string2 = string2 + ":\n  ";
        }
        this.tituloDatos.setTit(string2 + Aplicacion.getmResource().getString("df.TrasladablesAzules"));
        if (bl) {
            this.tituloDatos.setTit(string2 + Aplicacion.getmResource().getString("df.TrasladablesAzules").substring(2, Aplicacion.getmResource().getString("df.TrasladablesAzules").length()));
        }
        String string3 = String.valueOf(this.numModeloConDatosActual + 1);
        String string4 = String.valueOf(this.numTotalModelosConDatos);
        this.tituloDatos.setPag(Aplicacion.getmResource().getString("df.paso") + " " + string3 + " de " + string4);
        this.tablaRegDatos.setTitle(Aplicacion.getmResource().getString("df.pasoCarrusel") + " " + string3 + " de " + string4);
    }

    private void formatoTabla() {
        int n = this.jTableEntradas.getModel().getColumnCount();
        int n2 = this.jTableEntradas.getFont().getSize();
        this.jTableEntradas.setRowHeight(n2 + 4);
        int n3 = 6 * n2;
        int n4 = 9 * n2;
        this.jTableEntradas.getColumnModel().getColumn(0).setPreferredWidth(n3);
        this.jTableEntradas.getColumnModel().getColumn(0).setResizable(false);
        this.jTableEntradas.getColumnModel().getColumn(1).setPreferredWidth(n3);
        this.jTableEntradas.getColumnModel().getColumn(1).setResizable(false);
        for (int i = 2; i < n; ++i) {
            this.jTableEntradas.getColumnModel().getColumn(i).setPreferredWidth(n4);
            this.jTableEntradas.getColumnModel().getColumn(i).setResizable(true);
        }
        this.jSPscrollpane.setViewportView(this.jTableEntradas);
        this.jTableEntradas.setSelectionBackground(Color.GREEN);
        this.jTableEntradas.setSelectionMode(0);
        this.jTableEntradas.setAutoResizeMode(0);
        this.jTableEntradas.setDragEnabled(false);
        this.jTableEntradas.getTableHeader().setReorderingAllowed(false);
    }

    public String getClaveActual() {
        return this.mAcc.getClavePorIndice(this.numModeloActual);
    }

    private void generarMapaPrimeraVez(ArrayList<String> arrayList) {
        this.mapaPrimeraVez = new HashMap<String, Boolean>();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.mapaPrimeraVez.put(arrayList.get(i), true);
        }
    }

    public void cambiarDeModeloParaAvanzar() throws Exception {
        for (int i = this.numModeloActual; i < this.modeloTabla.length; ++i) {
            ++this.numModeloActual;
            if (null == this.modeloTabla[this.numModeloActual]) continue;
            this.jTableEntradas.setModel(this.modeloTabla[this.numModeloActual]);
            ++this.numModeloConDatosActual;
            this.prepararVistaModeloActual(this.getClaveActual());
            break;
        }
    }

    public void cambiarDeModeloParaRetroceder() throws Exception {
        for (int i = this.numModeloActual; i > -1; --i) {
            --this.numModeloActual;
            if (null == this.modeloTabla[this.numModeloActual]) continue;
            this.jTableEntradas.setModel(this.modeloTabla[this.numModeloActual]);
            --this.numModeloConDatosActual;
            this.prepararVistaModeloActual(this.getClaveActual());
            break;
        }
    }

    private void prepararVistaModeloActual(String string) throws Exception {
        this.ponerNotas(string);
        this.formatoTabla();
        this.ponerTitulosAlModeloActual(string);
        this.jPadf.repintarBotones();
        if (this.mapaPrimeraVez.get(string).booleanValue()) {
            this.primeraVisualizacionConcepto(string, this.numModeloActual);
            this.mapaPrimeraVez.put(string, false);
        }
    }

    public void salidaVentanaAzulAceptando(String string, String[] stringArray, int n) throws Exception {
        int n2 = this.mAcc.getMapaIndicesCodigoDF().get(string);
        int n3 = this.mAcc.dameNumeroPrimeraColumnaLibreEnTablaDatos(string);
        int n4 = this.mAcc.dameNumeroPrimeraColumnaLibreEnTableModel(string);
        int n5 = 0;
        int n6 = this.ctrDF.getFilaReal(string, n, this.mDeclaranteActual.toInt());
        this.trans.aniadirCamposExtraTabla(string, stringArray, n6, n3);
        boolean[] blArray = this.ctrDF.getMapaRegistrosMarcados(this.mDeclaranteActual.toInt(), string);
        blArray[n6] = Boolean.TRUE;
        this.ctrDF.setMapaRegistrosMarcados(this.mDeclaranteActual.toInt(), string, blArray);
        if (null != this.modeloTabla[n2]) {
            this.modeloTabla[n2].setValueAt(true, n, 0);
            this.modeloTabla[n2].removeTableModelListener(this);
            if ("CT".equals(string) && "No".equalsIgnoreCase(stringArray[0])) {
                this.modeloTabla[n2].setValueAt(false, n, 0);
            }
            for (int i = n4; i < n4 + stringArray.length; ++i) {
                boolean bl = false;
                try {
                    Double.parseDouble(stringArray[n5]);
                    bl = true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (bl) {
                    this.modeloTabla[n2].setValueAt(this.fDF.formateaDoubleParaTableModel(stringArray[n5]), n, i);
                } else {
                    this.modeloTabla[n2].setValueAt(stringArray[n5], n, i);
                }
                ++n5;
            }
            this.modeloTabla[n2].addTableModelListener(this);
            this.ponerNotas(string);
        }
    }

    public void salidaVentanaAzulCancelando(String string, int n) throws Exception {
        int n2 = this.mAcc.getMapaIndicesCodigoDF().get(string);
        int n3 = this.mAcc.dameNumeroPrimeraColumnaLibreEnTablaDatos(string);
        int n4 = this.mAcc.dameNumeroPrimeraColumnaLibreEnTableModel(string);
        int n5 = this.ctrDF.getFilaReal(string, n, this.mDeclaranteActual.toInt());
        this.modeloTabla[n2].removeTableModelListener(this);
        this.modeloTabla[n2].setValueAt(false, n, 0);
        this.trans.quitarCamposExtraTabla(string, n5, n3);
        boolean[] blArray = this.ctrDF.getMapaRegistrosMarcados(this.mDeclaranteActual.toInt(), string);
        blArray[n5] = Boolean.FALSE;
        this.ctrDF.setMapaRegistrosMarcados(this.mDeclaranteActual.toInt(), string, blArray);
        int n6 = n4 + this.fDF.cuantosCamposExtraTieneLaClave(string);
        for (int i = n4; i < n6; ++i) {
            this.modeloTabla[n2].setValueAt("", n, i);
        }
        this.modeloTabla[n2].addTableModelListener(this);
    }

    public void salidaVentanaAzulCancelandoConDatos(String string, String[] stringArray, int n) throws Exception {
        int n2 = this.mAcc.getMapaIndicesCodigoDF().get(string);
        int n3 = this.mAcc.dameNumeroPrimeraColumnaLibreEnTablaDatos(string);
        int n4 = this.mAcc.dameNumeroPrimeraColumnaLibreEnTableModel(string);
        int n5 = 0;
        int n6 = this.ctrDF.getFilaReal(string, n, this.mDeclaranteActual.toInt());
        this.trans.aniadirCamposExtraTabla(string, stringArray, n6, n3);
        boolean[] blArray = this.ctrDF.getMapaRegistrosMarcados(this.mDeclaranteActual.toInt(), string);
        blArray[n6] = Boolean.FALSE;
        this.ctrDF.setMapaRegistrosMarcados(this.mDeclaranteActual.toInt(), string, blArray);
        if (null != this.modeloTabla[n2]) {
            this.modeloTabla[n2].setValueAt(false, n, 0);
            this.modeloTabla[n2].removeTableModelListener(this);
            for (int i = n4; i < n4 + stringArray.length; ++i) {
                boolean bl = false;
                try {
                    Double.parseDouble(stringArray[n5]);
                    bl = true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (bl) {
                    this.modeloTabla[n2].setValueAt(this.fDF.formateaDoubleParaTableModel(stringArray[n5]), n, i);
                } else {
                    this.modeloTabla[n2].setValueAt(stringArray[n5], n, i);
                }
                ++n5;
            }
            this.modeloTabla[n2].addTableModelListener(this);
            this.ponerNotas(string);
        }
    }

    private void initRestComponents() {
    }

    private synchronized void jTableEntradasMouseReleased(Object object, int n, int n2) throws Exception {
        DefaultTableModel defaultTableModel = this.modeloTabla[this.numModeloActual];
        String string = this.getClaveActual();
        boolean bl = (Boolean)defaultTableModel.getValueAt(n, 0);
        boolean bl2 = (Boolean)defaultTableModel.getValueAt(n, 0) == false;
        boolean bl3 = this.mAcc.esClaveAzul(string);
        int n3 = this.ctrDF.getFilaReal(string, n, this.mDeclaranteActual.toInt());
        String[] stringArray = this.trans.seleccionaTabla(string)[n3];
        if (n2 != 0) {
            return;
        }
        if (!this.mAcc.esClaveTrasladable(string)) {
            return;
        }
        if (this.ctrDF.registroObligatorio(stringArray, string)) {
            defaultTableModel.setValueAt(Boolean.TRUE, n, 0);
            return;
        }
        if (string.equals("UR") && this.ctrDF.registroInmuebleComun(stringArray)) {
            defaultTableModel.setValueAt(Boolean.TRUE, n, 0);
            return;
        }
        if (string.equals("RTC") && bl2 && null != stringArray[9] && stringArray[9].indexOf("ACT") != -1) {
            return;
        }
        if (string.equals("IP") && bl2 && null != stringArray[4] && (stringArray[4].indexOf("ACT") != -1 || stringArray[4].indexOf("EXEN") != -1)) {
            return;
        }
        if (bl3 && this.ctrDF.dameColorRegistro(stringArray, string) == 2) {
            this.clickRegistroAzul(defaultTableModel, stringArray, string, n3, n, bl, bl2);
        }
    }

    private boolean controlOcurrenciasFIE(DefaultTableModel defaultTableModel, int n, boolean bl) throws ExceptionMotor {
        String[][] stringArray;
        int n2;
        boolean[] blArray = this.nave.dameMarcadosTableModel(defaultTableModel);
        int n3 = this.fDF.cuantosMarcados(blArray);
        if (n3 > 54 && (n2 = this.fDF.cuantosFIEsMarcadosDistintoNIF(stringArray = this.trans.seleccionaTabla("FIE"), blArray, n3)) > 54) {
            if (bl) {
                JMensajesProperties jMensajesProperties = new JMensajesProperties("DFFIE01", 11, true);
                jMensajesProperties.muestraMensaje();
            }
            defaultTableModel.removeTableModelListener(this);
            defaultTableModel.setValueAt(Boolean.FALSE, n, 0);
            defaultTableModel.addTableModelListener(this);
            return true;
        }
        return false;
    }

    private void controlPrimeraVezOcurrenciasFIE(DefaultTableModel defaultTableModel) throws ExceptionMotor {
        String[][] stringArray;
        int n;
        boolean[] blArray = this.nave.dameMarcadosTableModel(defaultTableModel);
        int n2 = this.fDF.cuantosMarcados(blArray);
        if (n2 > 54 && (n = this.fDF.cuantosFIEsMarcadosDistintoNIF(stringArray = this.trans.seleccionaTabla("FIE"), blArray, n2)) > 54) {
            JMensajesProperties jMensajesProperties = new JMensajesProperties("DFFIE01", true);
            jMensajesProperties.muestraMensaje();
            defaultTableModel.removeTableModelListener(this);
            for (int i = defaultTableModel.getRowCount() - 1; i >= 0; --i) {
                if (!this.fDF.estaMarcado(defaultTableModel, i)) continue;
                defaultTableModel.setValueAt(Boolean.FALSE, i, 0);
                if (!this.controlOcurrenciasFIE(defaultTableModel, i, false)) break;
            }
            defaultTableModel.addTableModelListener(this);
        }
    }

    private void clickRegistroAzul(DefaultTableModel defaultTableModel, String[] stringArray, String string, int n, int n2, boolean bl, boolean bl2) throws Exception {
        if (bl) {
            this.clickMarcarRegistroAzul(stringArray, string, n2);
        } else if (bl2) {
            this.clickDesmarcarRegistroAzul(defaultTableModel, stringArray, string, n, n2);
        }
    }

    private void clickMarcarRegistroAzul(String[] stringArray, String string, int n) throws Exception {
        if ("DN".equals(string)) {
            String string2 = "";
            if (null != this.mDG.getTablaTIdeclarante()) {
                if (this.mDeclaranteActual.equals(Declarantes.Declarante)) {
                    string2 = this.mDG.getTablaTIdeclarante()[0][this.mDG.getColumnasTI().get("CA")];
                } else if (this.mDeclaranteActual.equals(Declarantes.Conyuge) && this.mDG.hayLineaConyuge()) {
                    string2 = this.mDG.getTablaTIdeclarante()[1][this.mDG.getColumnasTI().get("CA")];
                }
                if ("08".equalsIgnoreCase(string2)) {
                    String string3 = Aplicacion.getmResourceAyuda().getString("incorporacindedatosfiscales");
                    JDlgDFDonacionesCyL jDlgDFDonacionesCyL = new JDlgDFDonacionesCyL(this, n);
                    AEATHerramientas.visualizarDialogo(jDlgDFDonacionesCyL, string3, true);
                    jDlgDFDonacionesCyL.dispose();
                    jDlgDFDonacionesCyL = null;
                }
            }
        } else if ("UR".equals(string)) {
            JDlgDFInmuebles jDlgDFInmuebles = new JDlgDFInmuebles(this, this.ctrDF, n, stringArray);
            jDlgDFInmuebles.inicializarPartidas();
            String string4 = Aplicacion.getmResourceAyuda().getString("incorporacindedatosfiscales");
            AEATHerramientas.visualizarDialogo(jDlgDFInmuebles, string4, true);
            jDlgDFInmuebles.dispose();
            jDlgDFInmuebles = null;
        } else if ("PH".equals(string)) {
            String string5 = JMensajesProperties.dameMensaje("DFPH000");
            JMensajesProperties jMensajesProperties = new JMensajesProperties(22, string5, 1, 16, true);
            jMensajesProperties.muestraMensaje();
            JDlgDFPrestamosHipotecarios jDlgDFPrestamosHipotecarios = new JDlgDFPrestamosHipotecarios(this, this.mDG, n, stringArray, this.mDeclaranteActual);
            String string6 = Aplicacion.getmResourceAyuda().getString("incorporacindedatosfiscales");
            AEATHerramientas.visualizarDialogo(jDlgDFPrestamosHipotecarios, string6, true);
            jDlgDFPrestamosHipotecarios.dispose();
            jDlgDFPrestamosHipotecarios = null;
        } else if ("RI".equals(string) || "LT".equals(string) || "REG".equals(string)) {
            String string7 = "";
            string7 = "REG".equals(string) ? "Gastos de administraci\u00f3n y dep\u00f3sito de valores" : "Gastos de adquisici\u00f3n y enajenaci\u00f3n";
            JDlgDFGastos jDlgDFGastos = new JDlgDFGastos(this, string, n, string7);
            JDialogo.setsSufijo(string);
            Aplicacion.getMotor().partidaModificada("DF_GASTOS", 0.0);
            String string8 = Aplicacion.getmResourceAyuda().getString("incorporacindedatosfiscales");
            AEATHerramientas.visualizarDialogo(jDlgDFGastos, string8, true);
            jDlgDFGastos.dispose();
            jDlgDFGastos = null;
        } else if ("IP".equals(string)) {
            JDlgDFSubvenciones jDlgDFSubvenciones = new JDlgDFSubvenciones(this, n);
            String string9 = Aplicacion.getmResourceAyuda().getString("incorporacindedatosfiscales");
            AEATHerramientas.visualizarDialogo(jDlgDFSubvenciones, string9, true);
            jDlgDFSubvenciones.dispose();
            jDlgDFSubvenciones = null;
        } else if ("RTC".equals(string)) {
            if (stringArray[3].contains("G")) {
                JDlgDFActividades jDlgDFActividades = new JDlgDFActividades(this, n);
                String string10 = Aplicacion.getmResourceAyuda().getString("incorporacindedatosfiscales");
                AEATHerramientas.visualizarDialogo(jDlgDFActividades, string10, true);
                jDlgDFActividades.dispose();
                jDlgDFActividades = null;
            }
        } else if ("RTB".equals(string)) {
            if (stringArray[3].equalsIgnoreCase("K1")) {
                JDlgDFPremios jDlgDFPremios = new JDlgDFPremios(this, n);
                String string11 = Aplicacion.getmResourceAyuda().getString("incorporacindedatosfiscales");
                AEATHerramientas.visualizarDialogo(jDlgDFPremios, string11, true);
                jDlgDFPremios.dispose();
                jDlgDFPremios = null;
            }
        } else if ("EAA".equals(string)) {
            JDlgDF4ImportesEAA jDlgDF4ImportesEAA = new JDlgDF4ImportesEAA(this, n);
            jDlgDF4ImportesEAA.setImporte(stringArray[5]);
            String string12 = Aplicacion.getmResourceAyuda().getString("incorporacindedatosfiscales");
            AEATHerramientas.visualizarDialogo(jDlgDF4ImportesEAA, string12, true);
            jDlgDF4ImportesEAA.dispose();
            jDlgDF4ImportesEAA = null;
        } else if ("EAD".equals(string)) {
            JDlgDF4ImportesEAD jDlgDF4ImportesEAD = new JDlgDF4ImportesEAD(this, n);
            jDlgDF4ImportesEAD.setSubclave(stringArray[5]);
            jDlgDF4ImportesEAD.setImporte(stringArray[6]);
            String string13 = Aplicacion.getmResourceAyuda().getString("incorporacindedatosfiscales");
            AEATHerramientas.visualizarDialogo(jDlgDF4ImportesEAD, string13, true);
            jDlgDF4ImportesEAD.dispose();
            jDlgDF4ImportesEAD = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void clickDesmarcarRegistroAzul(DefaultTableModel defaultTableModel, String[] stringArray, String string, int n, int n2) throws Exception {
        int n3;
        int n4;
        block17: {
            block16: {
                n4 = this.fDF.cuantosCamposExtraTieneLaClave(string);
                if (!"UR".equals(string)) break block16;
                String string2 = "";
                if (null != stringArray[this.mDG.getColumnasUR().get("Uso")]) {
                    string2 = stringArray[this.mDG.getColumnasUR().get("Uso")];
                }
                int n5 = 0;
                if (string2 != "" && string2.length() > 0) {
                    n5 = Integer.parseInt(string2);
                }
                boolean bl = false;
                if (null != stringArray[this.mDG.getColumnasUR().get("Habitual")]) {
                    bl = stringArray[this.mDG.getColumnasUR().get("Habitual")].contains("S");
                }
                if (bl) {
                    this.mDG.setContadorHabituales(this.mDeclaranteActual, false);
                }
                if (n5 == 7 || n5 == 8) {
                    this.mDG.setContadorAfectos(false);
                    break block17;
                } else if (n5 > 0 && n5 < 7) {
                    this.mDG.setContadorNoAfectos(this.mDeclaranteActual, false);
                }
                break block17;
            }
            if ("PH".equals(string)) {
                int n6 = this.trans.getTablaContRegistros().get(string);
                boolean[] blArray = new boolean[n6];
                blArray = this.nave.dameMarcadosTableModel(defaultTableModel);
                if (!this.fDF.hayAlgunMarcado(blArray)) {
                    Aplicacion.getMotor().partidaModificada("DF_PH_FADQ", "");
                }
                if (n2 != this.mDG.getFilaPermisoModifFechAdq(this.mDeclaranteActual)) {
                    // empty if block
                }
            } else if ("PP".equals(string)) {
                String string3 = this.fDF.comprobarCadenaNula(stringArray[this.mDG.getColumnasPP().get("Opcion")]);
                String string4 = this.fDF.comprobarNIFnulo(stringArray[this.mDG.getColumnasPP().get("NIF")]);
                double d = Double.parseDouble(this.fDF.comprobarCadenaNula(stringArray[this.mDG.getColumnasPP().get("Aportacion")]));
                if (string3.indexOf("3") != -1) {
                    if ("".equals(string4)) {
                        string4 = "VACIO";
                    }
                    this.mDG.quitarPPdiscapacitados(string4, d);
                }
            }
        }
        int n7 = this.mAcc.dameNumeroPrimeraColumnaLibreEnTablaDatos(string);
        this.trans.quitarCamposExtraTabla(string, n, n7);
        int n8 = n3 = this.mAcc.dameNumeroPrimeraColumnaLibreEnTableModel(string);
        while (true) {
            if (n8 >= n3 + n4) {
                this.ponerNotas(string);
                return;
            }
            defaultTableModel.setValueAt("", n2, n8);
            ++n8;
        }
    }

    private void primeraVisualizacionConcepto(String string, int n) throws Exception {
        block68: {
            String[][] stringArray;
            int n2;
            Vector vector;
            block75: {
                block74: {
                    block73: {
                        block72: {
                            block71: {
                                block70: {
                                    block69: {
                                        block67: {
                                            vector = new Vector();
                                            n2 = this.getModeloTabla()[n].getRowCount();
                                            stringArray = this.ctrDF.seleccionaTablaSoloConRegistrosQueDebenMostrarse(string, this.mDeclaranteActual.toInt());
                                            if (!string.equalsIgnoreCase("PP")) break block67;
                                            for (int i = 0; i < n2; ++i) {
                                                vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                                                vector.setElementAt(this.tft.pp_clave(stringArray[i][this.mDG.getColumnasPP().get("Clave")]), this.mDG.getColumnasPP().get("Clave") + 1);
                                                vector.setElementAt(this.tft.pp_subclave(stringArray[i][this.mDG.getColumnasPP().get("Subclave")], stringArray[i][this.mDG.getColumnasPP().get("Clave")]), this.mDG.getColumnasPP().get("Subclave") + 1);
                                            }
                                            break block68;
                                        }
                                        if (!string.equalsIgnoreCase("CC")) break block69;
                                        int n3 = 4;
                                        for (int i = 0; i < n2; ++i) {
                                            vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                                            String string2 = this.tft.cc_tipo(stringArray[i][3]);
                                            vector.setElementAt(string2, n3);
                                        }
                                        break block68;
                                    }
                                    if (!string.equalsIgnoreCase("RTA")) break block70;
                                    int n4 = 3;
                                    for (int i = 0; i < n2; ++i) {
                                        vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                                        String string3 = stringArray[i][n4];
                                        String string4 = this.tft.rta_clave(string3);
                                        vector.setElementAt(string4, n4 + 1);
                                    }
                                    break block68;
                                }
                                if (!string.equalsIgnoreCase("RTD")) break block71;
                                int n5 = 4;
                                for (int i = 0; i < n2; ++i) {
                                    vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                                    String string5 = this.tft.rtd_clave(stringArray[i][3]);
                                    vector.setElementAt(string5, n5);
                                }
                                break block68;
                            }
                            if (!string.equalsIgnoreCase("RTB")) break block72;
                            int n6 = 4;
                            for (int i = 0; i < n2; ++i) {
                                vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                                String string6 = this.tft.rtb_clave(stringArray[i][3]);
                                vector.setElementAt(string6, n6);
                            }
                            break block68;
                        }
                        if (!string.equalsIgnoreCase("RI")) break block73;
                        int n7 = 6;
                        for (int i = 0; i < n2; ++i) {
                            vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                            String string7 = this.tft.ri_origen(stringArray[i][5]);
                            vector.setElementAt(string7, n7);
                        }
                        break block68;
                    }
                    if (!string.equalsIgnoreCase("UR")) break block74;
                    for (int i = 0; i < n2; ++i) {
                        vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                        if (this.ctrDF.registroInmuebleComun(stringArray[i])) {
                            vector.setElementAt(Boolean.TRUE, 0);
                        }
                        vector.setElementAt(this.tft.ur_claseBien(stringArray[i][this.mDG.getColumnasUR().get("ClaseBien")]), this.mDG.getColumnasUR().get("ClaseBien") + 1);
                        vector.setElementAt(this.tft.ur_clave(stringArray[i][this.mDG.getColumnasUR().get("Clave")], stringArray[i][this.mDG.getColumnasUR().get("Clave")]), this.mDG.getColumnasUR().get("Clave") + 1);
                        vector.setElementAt(this.tft.ur_clasificacionAlmacen(stringArray[i][this.mDG.getColumnasUR().get("ClasAlmacen")]), this.mDG.getColumnasUR().get("ClasAlmacen") + 1);
                        vector.setElementAt(this.tft.ur_revisado(stringArray[i][this.mDG.getColumnasUR().get("Revisado")]), this.mDG.getColumnasUR().get("Revisado") + 1);
                        vector.setElementAt(this.tft.ur_codigoDerecho(stringArray[i][this.mDG.getColumnasUR().get("CodDer")]), this.mDG.getColumnasUR().get("CodDer") + 1);
                        vector.setElementAt(this.tft.ur_marcaUso(stringArray[i][this.mDG.getColumnasUR().get("MarcaUso")]), this.mDG.getColumnasUR().get("MarcaUso") + 1);
                        vector.setElementAt(this.tft.ur_situacion(stringArray[i][this.mDG.getColumnasUR().get("Situacion")]), this.mDG.getColumnasUR().get("Situacion") + 1);
                        vector.setElementAt(this.fDF.dameCadenaOpcionMarcadaVentanaUrbana(stringArray[i][this.mDG.getColumnasUR().get("Uso")]), this.mDG.getColumnasUR().get("Uso") + 1);
                    }
                    break block68;
                }
                if (!string.equalsIgnoreCase("DM")) break block75;
                for (int i = 0; i < n2; ++i) {
                    vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                    vector.setElementAt(Boolean.TRUE, 0);
                }
                if (this.mDG.getYaSeHaTrasladadoDM()) break block68;
                JDialogo.setsSufijo("DF");
                JDlgMatMeses jDlgMatMeses = new JDlgMatMeses();
                jDlgMatMeses.estoyEnDF(true);
                String string8 = Aplicacion.getmResourceAyuda().getString("incorporacindedatosfiscales");
                AEATHerramientas.visualizarDialogo(jDlgMatMeses, string8, true);
                jDlgMatMeses.dispose();
                jDlgMatMeses = null;
                break block68;
            }
            if (string.equalsIgnoreCase("FIE")) {
                DefaultTableModel defaultTableModel = this.getModeloTabla()[n];
                this.controlPrimeraVezOcurrenciasFIE(defaultTableModel);
            } else if (string.equalsIgnoreCase("DG")) {
                int n8 = 2;
                int n9 = 3;
                int n10 = 4;
                for (int i = 0; i < n2; ++i) {
                    vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                    String string9 = this.tft.dg_estadoCivil(stringArray[0][1]);
                    String string10 = this.tft.dg_conyugeNoResidente(stringArray[0][2]);
                    String string11 = this.tft.dg_hijosEnEjercicio(stringArray[0][3]);
                    vector.setElementAt(string9, n8);
                    vector.setElementAt(string10, n9);
                    vector.setElementAt(string11, n10);
                }
            } else if (string.equalsIgnoreCase("TI")) {
                int n11 = this.mDG.getColumnasTI().get("Tipo");
                int n12 = this.mDG.getColumnasTI().get("Minus");
                int n13 = this.mDG.getColumnasTI().get("Sexo");
                int n14 = this.mDG.getColumnasTI().get("CA");
                int n15 = this.mDG.getColumnasTI().get("PrViLa");
                int n16 = this.mDG.getColumnasTI().get("MobGeo");
                int n17 = this.mDG.getColumnasTI().get("TrAcMinus");
                int n18 = this.mDG.getColumnasTI().get("NoNifOp");
                int n19 = this.mDG.getColumnasTI().get("SeDedujo");
                for (int i = 0; i < n2; ++i) {
                    vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                    vector.setElementAt(this.tft.ti_tipoPersona(stringArray[i][n11]), 2);
                    vector.setElementAt(this.tft.ti_minusvalia(stringArray[i][n12]), 5);
                    vector.setElementAt(this.tft.ti_sexo(stringArray[i][n13]), 7);
                    vector.setElementAt(this.mAcc.dameComunidadAutonomaString(stringArray[i][n14]), 9);
                    vector.setElementAt(this.tft.ti_mobilidad_y_prolongacion(stringArray[i][n15]), 10);
                    vector.setElementAt(this.tft.ti_mobilidad_y_prolongacion(stringArray[i][n16]), 11);
                    vector.setElementAt(this.tft.ti_trabajadorActivoDiscapacitado(stringArray[i][n17]), 12);
                    vector.setElementAt(this.tft.ti_OpSinNif(stringArray[i][n18]), 16);
                    vector.setElementAt(this.tft.ti_deduccionVivienda(stringArray[i][n19]), 20);
                    if (i != 0) continue;
                    vector.setElementAt(this.trans.seleccionaTabla("DI")[0][5], 21);
                    vector.setElementAt(this.trans.seleccionaTabla("DI")[0][6], 22);
                    vector.setElementAt(this.trans.seleccionaTabla("DI")[0][7], 23);
                }
            } else if (string.equalsIgnoreCase("DE")) {
                int n20 = this.mDG.getColumnasDE().get("NumDes");
                int n21 = this.mDG.getColumnasDE().get("Minus");
                int n22 = this.mDG.getColumnasDE().get("Vincu");
                int n23 = this.mDG.getColumnasDE().get("OtrSitu");
                int n24 = this.mDG.getColumnasDE().get("CA");
                int n25 = this.mDG.getColumnasDE().get("Pertenece");
                int n26 = this.mDG.getColumnasDE().get("MobGeo");
                int n27 = this.mDG.getColumnasDE().get("TrAcDis");
                for (int i = 0; i < n2; ++i) {
                    vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                    vector.setElementAt(this.fDF.dameNumeroContadorAsDe(stringArray[i][n20]), n20 + 1);
                    vector.setElementAt(this.tft.ti_minusvalia(stringArray[i][n21]), n21);
                    vector.setElementAt(this.tft.de_vinculacion(stringArray[i][n22]), n22);
                    vector.setElementAt(this.tft.de_otrasSituaciones(stringArray[i][n23]), n23);
                    vector.setElementAt(this.mAcc.dameComunidadAutonomaString(stringArray[i][n24]), n24);
                    vector.setElementAt(this.tft.de_unidadFamiliar(stringArray[i][n25]), n25);
                    vector.setElementAt(this.tft.ti_mobilidad_y_prolongacion(stringArray[i][n26]), n26);
                    vector.setElementAt(this.tft.ti_trabajadorActivoDiscapacitado(stringArray[i][n27]), n27);
                }
            } else if (string.equalsIgnoreCase("AS")) {
                int n28 = 2;
                int n29 = 5;
                int n30 = 7;
                for (int i = 0; i < n2; ++i) {
                    vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                    String string12 = this.fDF.dameNumeroContadorAsDe(stringArray[i][1]);
                    String string13 = this.tft.ti_minusvalia(stringArray[i][5]);
                    String string14 = this.tft.as_vinculacion(stringArray[i][7]);
                    vector.setElementAt(string12, n28);
                    vector.setElementAt(string13, n29);
                    vector.setElementAt(string14, n30);
                }
            } else if (string.equalsIgnoreCase("REA")) {
                int n31 = 6;
                int n32 = 7;
                for (int i = 0; i < n2; ++i) {
                    vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                    String string15 = this.tft.rea_clave(stringArray[i][5]);
                    String string16 = this.tft.rea_tipo(stringArray[i][6]);
                    vector.setElementAt(string15, n31);
                    vector.setElementAt(string16, n32);
                }
            } else if (string.equalsIgnoreCase("REG")) {
                int n33 = 6;
                int n34 = 7;
                for (int i = 0; i < n2; ++i) {
                    vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                    String string17 = this.tft.reg_clave(stringArray[i][5]);
                    String string18 = this.tft.reg_tipo(stringArray[i][6]);
                    vector.setElementAt(string17, n33);
                    vector.setElementAt(string18, n34);
                }
            } else if (string.equalsIgnoreCase("CB")) {
                int n35 = 5;
                for (int i = 0; i < n2; ++i) {
                    vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                    String string19 = this.tft.cb_tipo(stringArray[i][4]);
                    vector.setElementAt(string19, n35);
                }
            } else if (string.equalsIgnoreCase("AG")) {
                int n36 = 3;
                for (int i = 0; i < n2; ++i) {
                    vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                    String string20 = this.tft.ag_tipo(stringArray[i][3]);
                    vector.setElementAt(string20, n36);
                }
            } else if (string.equalsIgnoreCase("TV")) {
                int n37 = 6;
                int n38 = 10;
                for (int i = 0; i < n2; ++i) {
                    vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                    String string21 = this.tft.tv_valor(stringArray[i][6]);
                    String string22 = this.tft.tv_declarado(stringArray[i][10]);
                    vector.setElementAt(string21, n37);
                    vector.setElementAt(string22, n38);
                }
            } else if (string.equalsIgnoreCase("RTC")) {
                int n39 = 3;
                for (int i = 0; i < n2; ++i) {
                    vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                    String string23 = this.tft.rtc_clave(stringArray[i][3]);
                    vector.setElementAt(string23, n39);
                }
            } else if (string.equalsIgnoreCase("SG")) {
                int n40 = 4;
                for (int i = 0; i < n2; ++i) {
                    vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                    String string24 = this.tft.sg_modalidad(stringArray[i][3]);
                    vector.setElementAt(string24, n40);
                }
            } else if (string.equalsIgnoreCase("AR")) {
                int n41 = 3;
                for (int i = 0; i < n2; ++i) {
                    vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                    String string25 = this.tft.ar_clave(stringArray[i][3]);
                    vector.setElementAt(string25, n41);
                }
            } else if (string.equalsIgnoreCase("PF")) {
                int n42 = 2;
                int n43 = 3;
                for (int i = 0; i < n2; ++i) {
                    vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                    String string26 = this.tft.pf_modelo(stringArray[i][1]);
                    String string27 = this.tft.pf_tipo(stringArray[i][2]);
                    vector.setElementAt(string26, n42);
                    vector.setElementAt(string27, n43);
                }
            } else if (string.equalsIgnoreCase("DN")) {
                int n44 = 4;
                int n45 = 5;
                int n46 = 7;
                for (int i = 0; i < n2; ++i) {
                    vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                    String string28 = stringArray[i][3];
                    String string29 = stringArray[i][4];
                    String string30 = stringArray[i][6];
                    String string31 = this.tft.dn_tipo(string28);
                    vector.setElementAt(string31, n44);
                    String string32 = this.tft.dn_clave(string29);
                    vector.setElementAt(string32, n45);
                    String string33 = this.mAcc.dameComunidadAutonomaString(string30);
                    vector.setElementAt(string33, n46);
                }
            } else if (string.equalsIgnoreCase("CT")) {
                int n47 = 2;
                for (int i = 0; i < n2; ++i) {
                    vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                    String string34 = this.tft.ct_regimen(this.tft.ct_regimen(stringArray[i][2]));
                    vector.setElementAt(string34, n47);
                }
            } else if (string.equalsIgnoreCase("FIC")) {
                int n48 = 6;
                for (int i = 0; i < n2; ++i) {
                    vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                    String string35 = this.tft.fic_tipo(stringArray[i][6]);
                    vector.setElementAt(string35, n48);
                }
            } else if (string.equalsIgnoreCase("AA")) {
                int n49 = 5;
                for (int i = 0; i < n2; ++i) {
                    vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                    String string36 = this.tft.aa_clave(stringArray[i][3]);
                    vector.setElementAt(string36, n49);
                }
            } else if (string.equalsIgnoreCase("EAD")) {
                int n50 = 5;
                int n51 = 6;
                for (int i = 0; i < n2; ++i) {
                    vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                    String string37 = this.tft.ead_clave(stringArray[i][4]);
                    String string38 = this.tft.ead_subClave(stringArray[i][5]);
                    vector.setElementAt(string37, n50);
                    vector.setElementAt(string38, n51);
                }
            } else if (string.equalsIgnoreCase("EAE")) {
                int n52 = 5;
                for (int i = 0; i < n2; ++i) {
                    vector = this.getModeloTabla()[n].getDataVector().elementAt(i);
                    String string39 = this.tft.eae_subClave(stringArray[i][4]);
                    vector.setElementAt(string39, n52);
                }
            }
        }
    }
}

