/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.re14.gui.df;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.PageSize;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPTableEvent;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import es.aeat.pare.aplicacion.Aplicacion;
import es.aeat.pare.componentes.AEATConfiguracion;
import es.aeat.pare.componentes.AEATHerramientas;
import es.aeat.pare.componentes.AEATLogger;
import es.aeat.pare.comunDF.InterfazAccesoDatosDF;
import es.aeat.pare.re14.AEAT100j;
import es.aeat.pare.re14.Irpf2014;
import es.aeat.pare.re14.gui.df.AccesoDatosDFescritorio;
import es.aeat.pare.re14.gui.df.MyPdfConstants;
import es.aeat.pare.re14.gui.df.MyPdfPTableEvent;
import es.aeat.pare.re14.gui.df.MyPdfPageEvent;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTable;

public final class ImprimirDF {
    private int numRowsTabla = 0;
    private int totalPaginas = 0;
    private int totalPdfRows = 0;
    private int paginaActual = 1;
    private float[] porcentajes = null;
    private String direccion = null;
    private PdfPTable table = null;
    private String tituloHeader = null;
    private Document document = null;
    private AccesoDatosDFescritorio mAcc;

    public ImprimirDF(JTable jTable, String string, boolean bl, InterfazAccesoDatosDF interfazAccesoDatosDF) {
        try {
            if (jTable.getRowCount() == 0) {
                return;
            }
            this.mAcc = (AccesoDatosDFescritorio)interfazAccesoDatosDF;
            String[] stringArray = new String[]{"Ficheros PDF"};
            String[] stringArray2 = new String[]{"PDF"};
            String string2 = AEATHerramientas.compruebaRutaParaFicherosSinoEstablecerPorDefecto(Aplicacion.configuracion().dameEntrada("ruta PDFs"));
            File file = AEATHerramientas.seleccionarFicheroParaGuardar(AEAT100j.getFrame(), "Seleccione un nombre para el fichero PDF.", stringArray, stringArray2, string2, null, null);
            if (file == null) {
                return;
            }
            this.direccion = file.toString();
            Aplicacion.configuracion().escribeEntrada("ruta PDFs", this.direccion);
            this.tituloHeader = string.toUpperCase();
            this.tituloHeader = bl ? string.concat(Aplicacion.getmResource().getString("df.imprimir.si")) : string.concat(Aplicacion.getmResource().getString("df.imprimir.no"));
            this.document = new Document(PageSize.A4.rotate());
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)new FileOutputStream(this.direccion));
            int n = jTable.getRowCount();
            int n2 = jTable.getColumnCount();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                if (jTable.getValueAt(n3, 0) != null) continue;
                this.totalPdfRows += 4;
                for (n4 = 2; n4 < n2; ++n4) {
                    if (jTable.getValueAt(n5 + 1, n4) == null) continue;
                    ++this.totalPdfRows;
                }
                n5 = n3 + 1;
            }
            Double d = Math.floor(this.totalPdfRows / 26);
            int n6 = d.intValue();
            Double d2 = (double)this.totalPdfRows / new Double(26.0);
            this.totalPaginas = d.doubleValue() != d2.doubleValue() ? n6 + 1 : n6;
            this.document.open();
            ++this.paginaActual;
            n5 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                String string3;
                int n7;
                Object object;
                if (jTable.getValueAt(n3, 0) != null) continue;
                String string4 = (String)jTable.getValueAt(n5, 0);
                String string5 = this.mAcc.dameClaveMedianteTitulo(string4);
                boolean[] blArray = this.mAcc.listaCamposParaImprimir(string5);
                int n8 = n3 - n5 - 1;
                this.porcentajes = null;
                this.porcentajes = new float[n8];
                int n9 = 0;
                for (int i = n5 + 1; i < n3; ++i) {
                    object = (String)jTable.getValueAt(i, 0);
                    if (((String)object).equalsIgnoreCase("tipo")) {
                        object = ((String)object).concat("  ");
                    }
                    if (!blArray[n9]) {
                        object = "";
                    }
                    this.porcentajes[n9] = ((String)object).length();
                    ++n9;
                }
                this.table = new PdfPTable(this.porcentajes);
                this.table.setWidthPercentage(108.0f);
                this.table.getDefaultCell().setBorder(0);
                this.table.getDefaultCell().setFixedHeight(19.0f);
                MyPdfPTableEvent myPdfPTableEvent = new MyPdfPTableEvent();
                this.table.setTableEvent((PdfPTableEvent)myPdfPTableEvent);
                object = new MyPdfPageEvent(this.tituloHeader, this.totalPaginas);
                pdfWriter.setPageEvent((PdfPageEvent)object);
                PdfPCell pdfPCell = new PdfPCell(new Phrase(string4, MyPdfConstants.fontTitulo));
                pdfPCell.setFixedHeight(19.0f);
                pdfPCell.setColspan(n8);
                pdfPCell.setBorderWidth(0.02f);
                pdfPCell.setNoWrap(false);
                pdfPCell.setVerticalAlignment(5);
                this.table.addCell(pdfPCell);
                ++this.numRowsTabla;
                this.compruebaFinPagina();
                for (n7 = n5 + 1; n7 < n3; ++n7) {
                    String string6 = (String)jTable.getValueAt(n7, 0);
                    if (!blArray[n7 - n5 - 1]) {
                        string6 = "";
                    }
                    if (string6.compareTo("null") == 0) {
                        string6 = "";
                    }
                    pdfPCell = new PdfPCell(new Phrase(string6, MyPdfConstants.fontConcepto));
                    pdfPCell.setFixedHeight(19.0f);
                    if (n7 == n3 - 1) {
                        pdfPCell.setPaddingRight(-10.0f);
                    } else {
                        pdfPCell.setPaddingRight(-5.0f);
                    }
                    pdfPCell.setPaddingLeft(1.0f);
                    pdfPCell.setNoWrap(true);
                    pdfPCell.setBorder(0);
                    pdfPCell.setVerticalAlignment(5);
                    pdfPCell.setHorizontalAlignment(1);
                    this.table.addCell(pdfPCell);
                }
                ++this.numRowsTabla;
                this.compruebaFinPagina();
                for (n4 = 2; n4 < n2; ++n4) {
                    n7 = 0;
                    boolean bl2 = false;
                    int n10 = -1;
                    if ((String)jTable.getValueAt(n5 + 1, n4) == null) break;
                    for (int i = n5 + 1; i < n3; ++i) {
                        String string7 = (String)jTable.getValueAt(i, n4);
                        if (!blArray[i - n5 - 1]) {
                            string7 = "";
                        }
                        if (string7.compareTo("null") == 0) {
                            string7 = "";
                        }
                        if (null != string7) {
                            if (string7.startsWith("UR") && string7.length() == 7) {
                                n7 = 1;
                            } else if (string7.startsWith("TI") && string7.length() == 7) {
                                bl2 = true;
                            }
                            if (n7 != 0 && string7.contains(".-")) {
                                string7 = string7.substring(0, string7.indexOf(".-"));
                            } else if (bl2 && ++n10 == 12 && string7.length() > 5) {
                                string7 = "...." + string7.substring(string7.length() - 4, string7.length());
                            }
                            pdfPCell = new PdfPCell(new Phrase(string7, MyPdfConstants.fontDatos));
                        }
                        pdfPCell.setFixedHeight(19.0f);
                        if (i == n3 - 1) {
                            pdfPCell.setPaddingRight(-10.0f);
                        } else {
                            pdfPCell.setPaddingRight(-5.0f);
                        }
                        pdfPCell.setPaddingLeft(0.0f);
                        pdfPCell.setNoWrap(false);
                        pdfPCell.setBorder(0);
                        pdfPCell.setHorizontalAlignment(1);
                        pdfPCell.setVerticalAlignment(5);
                        this.table.addCell(pdfPCell);
                    }
                    ++this.numRowsTabla;
                    this.compruebaFinPagina();
                }
                pdfPCell = new PdfPCell(new Phrase("", MyPdfConstants.fontDatos));
                pdfPCell.setColspan(n8);
                pdfPCell.setFixedHeight(19.0f);
                pdfPCell.setBorderWidth(0.02f);
                pdfPCell.setPadding(0.0f);
                this.table.addCell(pdfPCell);
                ++this.numRowsTabla;
                this.compruebaFinPagina();
                n7 = n5 + 1;
                for (n7 = n5 + 1; n7 < n3 && (string3 = (String)jTable.getValueAt(n7, 1)) == null; ++n7) {
                }
                if (n7 != n3) {
                    String string8 = jTable.getColumnName(1);
                    pdfPCell = new PdfPCell(new Phrase(string8, MyPdfConstants.fontTotales));
                    pdfPCell.setFixedHeight(19.0f);
                    pdfPCell.setNoWrap(false);
                    pdfPCell.setBorder(0);
                    pdfPCell.setVerticalAlignment(5);
                    pdfPCell.setHorizontalAlignment(1);
                    this.table.addCell(pdfPCell);
                    for (n7 = n5 + 2; n7 < n3; ++n7) {
                        string8 = (String)jTable.getValueAt(n7, 1);
                        if (string8 == null) {
                            string8 = "";
                        }
                        pdfPCell = new PdfPCell(new Phrase(string8, MyPdfConstants.fontTotales));
                        pdfPCell.setFixedHeight(19.0f);
                        pdfPCell.setNoWrap(false);
                        pdfPCell.setBorder(0);
                        pdfPCell.setVerticalAlignment(5);
                        pdfPCell.setHorizontalAlignment(1);
                        this.table.addCell(pdfPCell);
                    }
                } else {
                    pdfPCell = new PdfPCell(new Phrase("", MyPdfConstants.fontDatos));
                    pdfPCell.setColspan(n8);
                    pdfPCell.setFixedHeight(19.0f);
                    pdfPCell.setBorderWidth(0.02f);
                    this.table.addCell(pdfPCell);
                }
                ++this.numRowsTabla;
                this.compruebaFinPagina();
                n5 = n3 + 1;
                this.document.add((Element)this.table);
            }
            this.document.close();
            JOptionPane.showMessageDialog(null, "PDF guardado en " + this.direccion, "Imprimir", 1);
            this.abrePdf();
        }
        catch (Exception exception) {
            AEATLogger.getLogger().debug((Object)exception);
            JOptionPane.showMessageDialog(null, "Error al generar el PDF", "Imprimir", 1);
        }
    }

    private void abrePdf() throws ExceptionMotor {
        AEATConfiguracion aEATConfiguracion = Aplicacion.configuracion();
        String string = aEATConfiguracion.dameEntradaSinNull("abrir PDFs");
        if (!string.equals("0")) {
            if (string.equals("") || string.equals("2")) {
                if (!AEATHerramientas.visorPredeterminadoSistemaNuevo(this.direccion)) {
                    AEATHerramientas.visorPredeterminado(this.direccion);
                }
            } else {
                String string2 = Aplicacion.configuracion().dameEntrada("programa PDFs");
                if (string2 == null || string2.equals("")) {
                    AEAT100j.getFrame().configurarImpresion();
                }
                if ((string2 = Aplicacion.configuracion().dameEntrada("programa PDFs")) != null && !string2.equals("") && !AEATHerramientas.abrirVisor(aEATConfiguracion.dameEntrada("programa PDFs"), this.direccion)) {
                    JOptionPane.showMessageDialog(AEAT100j.getFrame(), "Error al abrir el visor PDF,\ncambie los par\u00e1metros en el menu Archivo", "\u00a1Atenci\u00f3n!", -1, new ImageIcon(Irpf2014.class.getResource(Aplicacion.DIRECTORIO_IMAGES + "iconaeat.gif")));
                }
            }
        }
    }

    private void compruebaFinPagina() {
        try {
            if (this.numRowsTabla == 26 && this.paginaActual <= this.totalPaginas) {
                this.document.add((Element)this.table);
                this.table = null;
                this.table = new PdfPTable(this.porcentajes);
                this.table.setWidthPercentage(108.0f);
                this.table.getDefaultCell().setBorder(0);
                this.table.getDefaultCell().setFixedHeight(19.0f);
                MyPdfPTableEvent myPdfPTableEvent = new MyPdfPTableEvent();
                this.table.setTableEvent((PdfPTableEvent)myPdfPTableEvent);
                this.document.newPage();
                ++this.paginaActual;
                this.numRowsTabla = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

