/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.re14.gui;

import es.aeat.pare.aplicacion.Aplicacion;
import es.aeat.pare.re14.Declaraciones;
import es.aeat.pare.re14.ICambioListaDeclaraciones;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.table.DefaultTableModel;

public final class TableModelIndiceDeclaraciones
extends DefaultTableModel
implements ICambioListaDeclaraciones {
    public static final int ORDEN_COLUMN = 0;
    public static final int CLAVE_COLUMN = 1;
    public static final int MODELO_COLUMN = 2;
    public static final int DESCRIPCION_COLUMN = 3;
    public static final int COLUMN_COUNT = 3;
    private final Vector<Declaraciones.TablaFila> declaraciones = new Vector();
    private String[] nomRow;
    private static final long serialVersionUID = 1L;

    public void add(List<Declaraciones.TablaFila> list) {
        int n = this.getDeclaraciones().size();
        int n2 = n + list.size() - 1;
        this.getDeclaraciones().addAll(list);
        this.fireTableRowsInserted(n, n2);
    }

    public void add(Declaraciones.TablaFila tablaFila) {
        int n = this.getDeclaraciones().size();
        this.getDeclaraciones().add(tablaFila);
        this.fireTableRowsInserted(n, n);
    }

    public TableModelIndiceDeclaraciones() {
        this.setDeclaraciones(Declaraciones.getDeclaraciones());
        Declaraciones.addListener(this);
    }

    @Override
    public void actualizarListaDeclaraciones(Vector<Declaraciones.TablaFila> vector) {
        this.setDeclaraciones(vector);
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.getNomRow() != null ? this.getNomRow().length : 0;
    }

    @Override
    public String getColumnName(int n) {
        return this.getNomRow()[n] != null ? this.getNomRow()[n] : "noName";
    }

    @Override
    public void setColumnIdentifiers(Object[] objectArray) {
        super.setColumnIdentifiers(objectArray);
    }

    @Override
    public int getRowCount() {
        return this.getDeclaraciones() != null ? this.getDeclaraciones().size() : 0;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.getDeclaraciones().size() < n) {
            return null;
        }
        Declaraciones.TablaFila tablaFila = this.getDeclaraciones().get(n);
        if (!Aplicacion.isECR()) {
            if (tablaFila != null) {
                switch (n2) {
                    case 1: {
                        return tablaFila.getClave();
                    }
                    case 0: {
                        return n + 1;
                    }
                    case 2: {
                        return tablaFila.getModelo();
                    }
                    case 3: {
                        return tablaFila.getDescripcion();
                    }
                }
            }
        } else if (tablaFila != null) {
            switch (n2) {
                case 0: {
                    return n + 1;
                }
                case 1: {
                    return String.format("%02d", tablaFila.getDiaECR());
                }
                case 2: {
                    return tablaFila.getDeclaracionECR();
                }
                case 3: {
                    return tablaFila.getNifECR();
                }
                case 4: {
                    String string = tablaFila.getFechaECR();
                    return String.format("%s/%s/%s", string.substring(0, 2), string.substring(2, 4), string.substring(4));
                }
                case 5: {
                    return tablaFila.getTipoECR();
                }
                case 6: {
                    return this.getIcono(tablaFila.getConjECR());
                }
                case 7: {
                    return this.getIcono(tablaFila.getDeclECR());
                }
                case 8: {
                    return this.getIcono(tablaFila.getConyECR());
                }
                case 9: {
                    return this.getIcono(tablaFila.getHijo1ECR());
                }
                case 10: {
                    return this.getIcono(tablaFila.getHijo2ECR());
                }
                case 11: {
                    return this.getIcono(tablaFila.getHijo3ECR());
                }
                case 12: {
                    return this.getIcono(tablaFila.getHijo4ECR());
                }
                case 13: {
                    return tablaFila.getModECR();
                }
                case 14: {
                    return tablaFila.getClave();
                }
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (Aplicacion.isECR()) {
            switch (n) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    return ImageIcon.class;
                }
            }
        }
        return super.getColumnClass(n);
    }

    private ImageIcon getIcono(String string) {
        ImageIcon imageIcon = null;
        if ("I".equals(string)) {
            imageIcon = new ImageIcon(this.getClass().getResource("/es/aeat/pare/aplicacion/images/imprimir.png"));
        } else if ("F".equals(string)) {
            imageIcon = new ImageIcon(this.getClass().getResource("/es/aeat/pare/aplicacion/images/guardar.png"));
        } else if ("P".equals(string)) {
            imageIcon = new ImageIcon(this.getClass().getResource("/es/aeat/pare/aplicacion/images/mundo.png"));
        }
        return imageIcon;
    }

    public void setDeclaraciones(Vector<Declaraciones.TablaFila> vector) {
        this.declaraciones.removeAllElements();
        this.declaraciones.addAll(vector);
    }

    public Vector<Declaraciones.TablaFila> getDeclaraciones() {
        return this.declaraciones;
    }

    public String[] getNomRow() {
        this.nomRow = new String[]{" ", Aplicacion.getmResource() != null ? Aplicacion.getmResource().getString("dec.tabla.dec") : "Declaraci\u00f3n", Aplicacion.getmResource() != null ? Aplicacion.getmResource().getString("dec.tabla.modelo") : "modelo", Aplicacion.getmResource() != null ? Aplicacion.getmResource().getString("menu.descripcion") : "Descripici\u00f3n", Aplicacion.getmResource() != null ? Aplicacion.getmResource().getString("dec.tabla.captura") : "captura"};
        return this.nomRow;
    }
}

