/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.re14.gui;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import es.aeat.pare.aplicacion.Aplicacion;
import es.aeat.pare.aplicacion.Constantes;
import es.aeat.pare.cc14.Declarantes;
import es.aeat.pare.componentes.AEATHerramientas;
import es.aeat.pare.componentes.AEATListaConMotor;
import es.aeat.pare.componentes.AEATLogger;
import es.aeat.pare.componentes.AEATlistaComponentes;
import es.aeat.pare.componentes.JMensajesProperties;
import es.aeat.pare.componentes.JTextPaneRaya;
import es.aeat.pare.re14.AEAT100j;
import es.aeat.pare.re14.Irpf2014;
import es.aeat.pare.re14.gui.Dialogos.JListaErrores;
import es.aeat.pare.re14.gui.Dialogos.ObjetoResumen;
import es.aeat.pare.re14.motor.FuncionesRenta;
import es.aeat.pare.re14.motor.FuncionesRentaComun;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.imp.utilidades.FuncionesUtiles;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public final class JPanelResumen
extends JPanel {
    private static final long serialVersionUID = 1L;
    private AEATlistaComponentes mlComponentes = new AEATListaConMotor();
    private JEditorPane jEditorPane;
    private final JTextPaneRaya tpTitulo = new JTextPaneRaya();
    private ArrayList<ObjetoResumen> objetosResumen;
    private HashMap<String, Boolean> objetosTitulo = new HashMap();
    private int registros;
    private boolean bHayConjunta;
    private static final String TABULADOR = "&nbsp;&nbsp;&nbsp;";
    private static final int CARACTERES_POR_FILA = 90;
    private static final int CARACTERES_ADD_COL = 15;
    private static final float TAM_FUENTE = 9.0f;
    private static final float MARGEN = 3.0f;
    private String[] sRTIT;
    private String[] sTitular;
    String estiloTit = "style='padding-top:10px; white-space: nowrap;'";
    String estilotdLe = "style='text-align:left; white-space: nowrap;'";
    String estilotdRi = "border='1px' style='width: 90px; text-align:right;'";
    String estiloNIF = "style='width: 90px; text-align:center;'";
    private String LINEAOCULTA = "LINEAOCULTA";
    private PdfPTable datatable;
    private String rutaTemp;

    public JPanelResumen() {
        try {
            this.initComponents();
            this.initResComponents();
            AEATHerramientas.ponColorBkGround(this, Constantes.getColorBK(), Constantes.getColorBkOscuro());
            this.iniciarArrayList();
            this.cargar();
            this.rellenaDatos();
            this.tpTitulo.setText(Aplicacion.getmResource().getString("JPanelResumen.RESDECLA.texto"));
            Aplicacion.getmPanelBotones().setEstoyEnResumen(true);
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)("Error controlado si estamos en herramientas " + exception));
        }
    }

    private void iniciarArrayList() {
        this.objetosTitulo.put("NIF", Boolean.TRUE);
        this.objetosTitulo.put("A", Boolean.TRUE);
        this.objetosTitulo.put("B1", Boolean.TRUE);
        this.objetosTitulo.put("B2", Boolean.TRUE);
        this.objetosTitulo.put("C", Boolean.TRUE);
        this.objetosTitulo.put("E1", Boolean.TRUE);
        this.objetosTitulo.put("E2", Boolean.TRUE);
        this.objetosTitulo.put("E3", Boolean.TRUE);
        this.objetosTitulo.put("F1", Boolean.TRUE);
        this.objetosTitulo.put("G1", Boolean.TRUE);
        this.objetosTitulo.put("G2A", Boolean.TRUE);
        this.objetosTitulo.put("G2B", Boolean.TRUE);
        this.objetosTitulo.put("G2C", Boolean.TRUE);
        this.objetosTitulo.put("G3A", Boolean.TRUE);
        this.objetosTitulo.put("G3B", Boolean.TRUE);
        this.objetosTitulo.put("G3C", Boolean.TRUE);
        this.objetosTitulo.put("G3D", Boolean.TRUE);
        this.objetosTitulo.put("G4A", Boolean.TRUE);
        this.objetosTitulo.put("G4B", Boolean.TRUE);
        this.objetosTitulo.put("G5", Boolean.TRUE);
        this.objetosTitulo.put("J1", Boolean.TRUE);
        this.objetosTitulo.put("J2", Boolean.TRUE);
        this.objetosTitulo.put("J3", Boolean.TRUE);
        this.objetosTitulo.put("J4", Boolean.TRUE);
        this.objetosTitulo.put("J5", Boolean.TRUE);
        this.objetosTitulo.put("J6", Boolean.TRUE);
        this.objetosTitulo.put("J7", Boolean.TRUE);
        this.objetosTitulo.put("L", Boolean.TRUE);
        this.objetosTitulo.put("M", Boolean.TRUE);
        this.objetosTitulo.put("N1", Boolean.TRUE);
        this.objetosTitulo.put("N2", Boolean.TRUE);
        this.objetosTitulo.put("N3", Boolean.TRUE);
        this.objetosTitulo.put("N4", Boolean.TRUE);
        this.objetosTitulo.put("N5", Boolean.TRUE);
        this.objetosTitulo.put("N6", Boolean.TRUE);
        this.objetosTitulo.put("N7", Boolean.TRUE);
        this.objetosTitulo.put("N8", Boolean.TRUE);
        this.objetosTitulo.put("N9", Boolean.TRUE);
        this.objetosResumen = new ArrayList();
        this.objetosResumen.add(new ObjetoResumen("R_SPNIF", true, "NIF", 1));
        this.objetosResumen.add(new ObjetoResumen("R_TPING", false, "A"));
        this.objetosResumen.add(new ObjetoResumen("R_TPGASTO", false, "A"));
        this.objetosResumen.add(new ObjetoResumen("R_TPSUMA", false, "A"));
        this.objetosResumen.add(new ObjetoResumen("R_TPTOTAL", false, "A"));
        this.objetosResumen.add(new ObjetoResumen("R_B1II", false, "B1"));
        this.objetosResumen.add(new ObjetoResumen("R_B1GD", false, "B1"));
        this.objetosResumen.add(new ObjetoResumen("R_B1RED", false, "B1"));
        this.objetosResumen.add(new ObjetoResumen("R_B1RNR", false, "B1"));
        this.objetosResumen.add(new ObjetoResumen("R_B2II", false, "B2"));
        this.objetosResumen.add(new ObjetoResumen("R_B2GD", false, "B2"));
        this.objetosResumen.add(new ObjetoResumen("R_B2RED", false, "B2"));
        this.objetosResumen.add(new ObjetoResumen("R_B2RNR", false, "B2"));
        this.objetosResumen.add(new ObjetoResumen("R_IRIM", false, "C"));
        this.objetosResumen.add(new ObjetoResumen("R_RNCIT", false, "C"));
        this.objetosResumen.add(new ObjetoResumen("R_E1TRNR", false, "E1", true, "R_DF_HAYRTCAE"));
        this.objetosResumen.add(new ObjetoResumen("R_E1RED1", false, "E1"));
        this.objetosResumen.add(new ObjetoResumen("R_E1RED2", false, "E1"));
        this.objetosResumen.add(new ObjetoResumen("R_E1RED3", false, "E1"));
        this.objetosResumen.add(new ObjetoResumen("R_E1TOTAL", false, "E1"));
        this.objetosResumen.add(new ObjetoResumen("R_E4SUMA", false, "E2"));
        this.objetosResumen.add(new ObjetoResumen("R_E4REDU", false, "E2"));
        this.objetosResumen.add(new ObjetoResumen("R_E4TOTAL", false, "E2"));
        this.objetosResumen.add(new ObjetoResumen("R_E5SUMA", false, "E3"));
        this.objetosResumen.add(new ObjetoResumen("R_E5REDU", false, "E3"));
        this.objetosResumen.add(new ObjetoResumen("R_E5TOTAL", false, "E3"));
        this.objetosResumen.add(new ObjetoResumen("R_F1CMG", false, "F1"));
        this.objetosResumen.add(new ObjetoResumen("R_F1CMAH", false, "F1"));
        this.objetosResumen.add(new ObjetoResumen("R_F1PFPT", false, "F1"));
        this.objetosResumen.add(new ObjetoResumen("R_F1PFNT", false, "F1"));
        this.objetosResumen.add(new ObjetoResumen("R_F1CIM", false, "F1"));
        this.objetosResumen.add(new ObjetoResumen("R_F1AAEE", false, "F1", true, "R_DF_HAYEARAE"));
        this.objetosResumen.add(new ObjetoResumen("R_F1GG", false, "F1"));
        this.objetosResumen.add(new ObjetoResumen("R_F1GGT", false, "F1"));
        this.objetosResumen.add(new ObjetoResumen("R_F1PG", false, "F1"));
        this.objetosResumen.add(new ObjetoResumen("R_F1GAH", false, "F1"));
        this.objetosResumen.add(new ObjetoResumen("R_F1EMPFT", false, "F1"));
        this.objetosResumen.add(new ObjetoResumen("R_F1PAH", false, "F1"));
        this.objetosResumen.add(new ObjetoResumen("R_F1EAHPFT", false, "F1"));
        this.objetosResumen.add(new ObjetoResumen("R_RET5", false, "F1", "F1EO"));
        this.objetosResumen.add(new ObjetoResumen("R_G1RT4", false, "G1"));
        this.objetosResumen.add(new ObjetoResumen("R_G1RT5", false, "G1"));
        this.objetosResumen.add(new ObjetoResumen("R_G1RT6", false, "G1"));
        this.objetosResumen.add(new ObjetoResumen("R_G1RT8", false, "G1"));
        this.objetosResumen.add(new ObjetoResumen("R_G1RT9", false, "G1"));
        this.objetosResumen.add(new ObjetoResumen("R_G11", false, "G1"));
        this.objetosResumen.add(new ObjetoResumen("R_G12", false, "G1"));
        this.objetosResumen.add(new ObjetoResumen("R_G15", false, "G1"));
        this.objetosResumen.add(new ObjetoResumen("R_G13", false, "G1"));
        this.objetosResumen.add(new ObjetoResumen("R_G14", false, "G1"));
        this.objetosResumen.add(new ObjetoResumen("R_G2A_RT0", false, "G2A"));
        this.objetosResumen.add(new ObjetoResumen("R_G2A_RT1", false, "G2A"));
        this.objetosResumen.add(new ObjetoResumen("R_G2B_RT0", false, "G2B"));
        this.objetosResumen.add(new ObjetoResumen("R_G2B_RT1", false, "G2B"));
        this.objetosResumen.add(new ObjetoResumen("R_G2T3", false, "G2C"));
        this.objetosResumen.add(new ObjetoResumen("R_G2T4", false, "G2C"));
        this.objetosResumen.add(new ObjetoResumen("R_G2T5", false, "G2C"));
        this.objetosResumen.add(new ObjetoResumen("R_G3A_RT0", false, "G3A"));
        this.objetosResumen.add(new ObjetoResumen("R_G3A_RT1", false, "G3A"));
        this.objetosResumen.add(new ObjetoResumen("R_G3B_RT0", false, "G3B"));
        this.objetosResumen.add(new ObjetoResumen("R_G3B_RT1", false, "G3B"));
        this.objetosResumen.add(new ObjetoResumen("R_G3C_RT0", false, "G3C"));
        this.objetosResumen.add(new ObjetoResumen("R_G3C_RT1", false, "G3C"));
        this.objetosResumen.add(new ObjetoResumen("R_G3T3", false, "G3D"));
        this.objetosResumen.add(new ObjetoResumen("R_G3T4", false, "G3D"));
        this.objetosResumen.add(new ObjetoResumen("R_G3T5", false, "G3D"));
        this.objetosResumen.add(new ObjetoResumen("R_G4D_T0", false, "G4A"));
        this.objetosResumen.add(new ObjetoResumen("R_G4D_T1", false, "G4A"));
        this.objetosResumen.add(new ObjetoResumen("R_G4D_T1PF", false, "G4A"));
        this.objetosResumen.add(new ObjetoResumen("R_G5D_T0", false, "G5"));
        this.objetosResumen.add(new ObjetoResumen("R_G5D_T1", false, "G5"));
        this.objetosResumen.add(new ObjetoResumen("R_G5D_T2", false, "G5"));
        this.objetosResumen.add(new ObjetoResumen("R_BIGRALH", true, "J1", 1));
        this.objetosResumen.add(new ObjetoResumen("R_JREDU11", false, "J2"));
        this.objetosResumen.add(new ObjetoResumen("R_JREDU12", false, "J2", "RGEA0"));
        this.objetosResumen.add(new ObjetoResumen("R_JREDU13", false, "J2", "APORTOT"));
        this.objetosResumen.add(new ObjetoResumen("R_JREDU14", false, "J2", "IPPMINIF"));
        this.objetosResumen.add(new ObjetoResumen("R_JREDU15", false, "J2", "PPRONIF0"));
        this.objetosResumen.add(new ObjetoResumen("R_JREDU16", false, "J2", "IPCNIF0"));
        this.objetosResumen.add(new ObjetoResumen("R_JREDU17", false, "J2"));
        this.objetosResumen.add(new ObjetoResumen("R_JREDU18", false, "J2", "MDEX0"));
        this.objetosResumen.add(new ObjetoResumen("R_BLGRAL", false, "J3", 1));
        this.objetosResumen.add(new ObjetoResumen("R_JCOMPE", false, "J3"));
        this.objetosResumen.add(new ObjetoResumen("R_BLGGRAV", true, "J4", 1));
        this.objetosResumen.add(new ObjetoResumen("R_BIAHOJ", true, "J5", 1));
        this.objetosResumen.add(new ObjetoResumen("R_JREDU21", false, "J6"));
        this.objetosResumen.add(new ObjetoResumen("R_JREDU22", false, "J6"));
        this.objetosResumen.add(new ObjetoResumen("R_JREDU23", false, "J6"));
        this.objetosResumen.add(new ObjetoResumen("R_BLAHOJ", true, "J7", 1));
        this.objetosResumen.add(new ObjetoResumen("R_MPER", true, "L"));
        this.objetosResumen.add(new ObjetoResumen("R_MPERAU", true, "L"));
        this.objetosResumen.add(new ObjetoResumen("R_MDES", false, "L"));
        this.objetosResumen.add(new ObjetoResumen("R_MDESAU", false, "L"));
        this.objetosResumen.add(new ObjetoResumen("R_MASC", false, "L"));
        this.objetosResumen.add(new ObjetoResumen("R_MASCAU", false, "L"));
        this.objetosResumen.add(new ObjetoResumen("R_MDIS", false, "L"));
        this.objetosResumen.add(new ObjetoResumen("R_MDISAU", false, "L"));
        this.objetosResumen.add(new ObjetoResumen("R_REXBLGRAL", false, "M"));
        this.objetosResumen.add(new ObjetoResumen("R_REXBLAHO", false, "M"));
        this.objetosResumen.add(new ObjetoResumen("R_IMPALIM", false, "M"));
        this.objetosResumen.add(new ObjetoResumen("R_TME", true, "N1"));
        this.objetosResumen.add(new ObjetoResumen("R_TMA", true, "N1"));
        this.objetosResumen.add(new ObjetoResumen("R_CINTEST", true, "N1"));
        this.objetosResumen.add(new ObjetoResumen("R_CINTAUT", true, "N1"));
        this.objetosResumen.add(new ObjetoResumen("R_DED1E", false, "N2", "VHADQ"));
        this.objetosResumen.add(new ObjetoResumen("R_DED1A", false, "N2", "VHADQ"));
        this.objetosResumen.add(new ObjetoResumen("R_DED0E", false, "N2", "CANTRC"));
        this.objetosResumen.add(new ObjetoResumen("R_DED2E", false, "N2", "MDIC"));
        this.objetosResumen.add(new ObjetoResumen("R_DED2A", false, "N2", "MDIC"));
        this.objetosResumen.add(new ObjetoResumen("R_DED3E", false, "N2", "MDCD"));
        this.objetosResumen.add(new ObjetoResumen("R_DED3A", false, "N2", "MDCD"));
        this.objetosResumen.add(new ObjetoResumen("R_DED4E", false, "N2", "M21RGS"));
        this.objetosResumen.add(new ObjetoResumen("R_DED4A", false, "N2", "M21RGS"));
        this.objetosResumen.add(new ObjetoResumen("R_DED5E", false, "N2", "M2414S"));
        this.objetosResumen.add(new ObjetoResumen("R_DED5A", false, "N2", "M2414S"));
        this.objetosResumen.add(new ObjetoResumen("R_DED6E", false, "N2"));
        this.objetosResumen.add(new ObjetoResumen("R_DED6A", false, "N2"));
        this.objetosResumen.add(new ObjetoResumen("R_DED7E", false, "N2", "DEDCM"));
        this.objetosResumen.add(new ObjetoResumen("R_DED7A", false, "N2", "DEDCM"));
        this.objetosResumen.add(new ObjetoResumen("R_DED8E", false, "N2", "CAHOE"));
        this.objetosResumen.add(new ObjetoResumen("R_DED8A", false, "N2", "CAHOE"));
        this.objetosResumen.add(new ObjetoResumen("R_DED9E", false, "N2", "IMPAL"));
        this.objetosResumen.add(new ObjetoResumen("R_DED9A", false, "N2", "IMPAL"));
        this.objetosResumen.add(new ObjetoResumen("R_DED10E", false, "N2", "CANTM3"));
        this.objetosResumen.add(new ObjetoResumen("R_DED11E", false, "N2", "CANTM1"));
        this.objetosResumen.add(new ObjetoResumen("R_SUMADEDAUT", true, "N3", "ANEXOB"));
        this.objetosResumen.add(new ObjetoResumen("R_CLIQEST", true, "N4"));
        this.objetosResumen.add(new ObjetoResumen("R_CLIQAUT", true, "N4"));
        this.objetosResumen.add(new ObjetoResumen("R_CLEIN", true, "N4"));
        this.objetosResumen.add(new ObjetoResumen("R_CLAIN", true, "N4"));
        this.objetosResumen.add(new ObjetoResumen("R_CLIQT", true, "N4"));
        this.objetosResumen.add(new ObjetoResumen("R_CLDED1", false, "N5"));
        this.objetosResumen.add(new ObjetoResumen("R_CLDED2", false, "N5"));
        this.objetosResumen.add(new ObjetoResumen("R_CLDED3", false, "N5"));
        this.objetosResumen.add(new ObjetoResumen("R_CLDED4", false, "N5"));
        this.objetosResumen.add(new ObjetoResumen("R_CLDED5", false, "N5"));
        this.objetosResumen.add(new ObjetoResumen("R_CLDED6", false, "N5"));
        this.objetosResumen.add(new ObjetoResumen("R_CAUTLIQ", true, "N6", 1));
        this.objetosResumen.add(new ObjetoResumen("R_PAGOS", true, "N7", 1));
        this.objetosResumen.add(new ObjetoResumen("R_RET1", false, "N7", "TPDIN"));
        this.objetosResumen.add(new ObjetoResumen("R_RET2", false, "N7", "B11"));
        this.objetosResumen.add(new ObjetoResumen("R_RET3", false, "N7", "PC"));
        this.objetosResumen.add(new ObjetoResumen("R_RET4", false, "N7"));
        this.objetosResumen.add(new ObjetoResumen("R_RET5", false, "N7", "F1EO"));
        this.objetosResumen.add(new ObjetoResumen("R_RET6", false, "N7", "F2EG"));
        this.objetosResumen.add(new ObjetoResumen("R_RET7", false, "N7", "F4TOTAL"));
        this.objetosResumen.add(new ObjetoResumen("R_RET8", false, "N7"));
        this.objetosResumen.add(new ObjetoResumen("R_RET9", false, "N7"));
        this.objetosResumen.add(new ObjetoResumen("R_RET10", false, "N7"));
        this.objetosResumen.add(new ObjetoResumen("R_RET11", false, "N7"));
        this.objetosResumen.add(new ObjetoResumen("R_CDIF", true, "N8", 1));
        this.objetosResumen.add(new ObjetoResumen("R_MATER", false, "N8"));
        this.objetosResumen.add(new ObjetoResumen("R_ABONO", false, "N8"));
        double d = 0.0;
        try {
            d = Double.parseDouble(Aplicacion.getMotor().obtenerPartidaString("RESDECCOMP"));
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.printStackTrace();
        }
        if (d == 0.0) {
            this.objetosResumen.add(new ObjetoResumen("R_RESULTADO", true, "N9", 1, "RESINGDEV"));
        } else {
            this.objetosResumen.add(new ObjetoResumen("R_RESULTADO", true, "N9", 1, "RESDECCOMP"));
        }
    }

    private String generaHTML() throws ExceptionMotor {
        int n;
        Object object;
        int n2;
        Object object2;
        String string = "Presentar declaraci\u00f3n";
        String string2 = "Vista previa";
        String string3 = "Imprime resumen de declaraciones";
        try {
            string = Aplicacion.getmResource().getString("JPanelResumen.pd");
            string2 = Aplicacion.getmResource().getString("JPanelResumen.vp");
            string3 = Aplicacion.getmResource().getString("JPanelResumen.re");
            this.registros = (int)Aplicacion.getMotor().recordCount("RESUMEN");
            this.bHayConjunta = false;
            if (this.registros > 1) {
                this.bHayConjunta = true;
            }
            this.sRTIT = new String[this.registros];
            this.sTitular = new String[this.registros];
            for (int i = 0; i < this.registros; ++i) {
                Aplicacion.getMotor().move("RESUMEN", i + 1);
                this.sRTIT[i] = Aplicacion.getMotor().obtenerPartidaString("R_TIT");
                this.sTitular[i] = this.obtenerTituloTitular(this.sRTIT[i]);
            }
        }
        catch (ExceptionMotor exceptionMotor) {
            AEATLogger.getLogger().fatal((Object)"Error generaHTML: ", (Throwable)exceptionMotor);
        }
        String string4 = "<html><head></head><body>";
        string4 = string4 + "<table style='cellspacing:0; cellpadding:3; font-size:12; font-family: arial, sans-serif;'><tr>";
        string4 = this.bHayConjunta ? string4 + "<th rowspan='2'></th>" : string4 + "<th></th>";
        if (this.registros > 1) {
            string4 = string4 + "<th></th>";
            Color color = Constantes.getColorBkOscuro();
            object2 = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
            string4 = string4 + "<th colspan='" + (this.registros - 1) + "' style='background-color:" + (String)object2 + ";'>" + Aplicacion.getmResource().getString("JDlgResumen.ind") + "</th></tr><tr>";
        }
        for (int i = 0; i < this.registros; ++i) {
            string4 = string4 + "<th>" + this.sTitular[i] + "</th>";
        }
        Declarantes declarantes = null;
        object2 = new FuncionesRenta();
        try {
            declarantes = ((FuncionesRentaComun)((Object)object2)).cualDeclaracion();
            ((FuncionesRentaComun)((Object)object2)).irDeclaracion(Declarantes.Declarante);
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
        }
        boolean bl = false;
        try {
            if (Aplicacion.getMotor().obtenerPartidaString("ZCOMPE").equalsIgnoreCase("true")) {
                bl = true;
            }
        }
        catch (ExceptionMotor exceptionMotor) {
            AEATLogger.getLogger().fatal((Object)"Error generaHTML: ", (Throwable)exceptionMotor);
        }
        string4 = string4 + "</tr><tr>";
        string4 = string4 + "<td></td>";
        String string5 = "' height='16' width='16'";
        URL uRL = this.getClass().getResource(Constantes.getDirectorioImagenes() + "mundo.png");
        for (n2 = 0; n2 < this.registros; ++n2) {
            String string6;
            if (bl) {
                if (n2 == 1) {
                    string6 = "href=\"http://fakeurl1.com:" + n2 + "\"";
                    string4 = string4 + "<td colspan = '2' style='text-align:center'><a " + string6 + "><img src='" + uRL + string5 + " border='0'/></a>&nbsp;<a " + string6 + ">" + string + "</a></td>";
                    continue;
                }
                if (n2 <= 2 && n2 != 0) continue;
                string6 = "href=\"http://fakeurl1.com:" + n2 + "\"";
                string4 = string4 + "<td style='text-align:left'><a " + string6 + "><img src='" + uRL + string5 + " border='0'/></a>&nbsp;<a " + string6 + ">" + string + "</a></td>";
                continue;
            }
            string6 = "href=\"http://fakeurl1.com:" + n2 + "\"";
            string4 = string4 + "<td style='text-align:left'><a " + string6 + "><img src='" + uRL + string5 + " border='0'/></a>&nbsp;<a " + string6 + ">" + string + "</a></td>";
        }
        string4 = string4 + "</tr><tr>";
        string4 = string4 + "<td></td>";
        uRL = this.getClass().getResource(Constantes.getDirectorioImagenes() + "imprimir.png");
        for (n2 = 0; n2 < this.registros; ++n2) {
            int n3;
            boolean bl2;
            if (bl) {
                if (n2 == 1) {
                    bl2 = false;
                    try {
                        if (((FuncionesRentaComun)((Object)object2)).esNifReal(Aplicacion.getMotor().obtenerPartidaString("DPNIF_D"))) {
                            bl2 = true;
                        }
                        if (!((FuncionesRentaComun)((Object)object2)).esNifReal(Aplicacion.getMotor().obtenerPartidaString("DPNIF_C"))) continue;
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    continue;
                }
                if (n2 <= 2 && n2 != 0) continue;
                bl2 = false;
                try {
                    long l;
                    if (this.bHayConjunta && n2 == 0) {
                        if (((FuncionesRentaComun)((Object)object2)).esNifReal(Aplicacion.getMotor().obtenerPartidaString("DPNIF_D"))) {
                            bl2 = true;
                        }
                        if (((FuncionesRentaComun)((Object)object2)).esNifReal(Aplicacion.getMotor().obtenerPartidaString("DPNIF_C"))) {
                            bl2 = true;
                        }
                        l = Aplicacion.getMotor().obtenerClaveActiva("DESCENDIENTESRENTAS");
                        n3 = 1;
                        while ((long)n3 <= Aplicacion.getMotor().recordCount("DESCENDIENTESRENTAS")) {
                            Aplicacion.getMotor().move("DESCENDIENTESRENTAS", n3);
                            if (((FuncionesRentaComun)((Object)object2)).esNifReal(Aplicacion.getMotor().obtenerPartidaString("NIFHR"))) {
                                bl2 = true;
                                break;
                            }
                            ++n3;
                        }
                        Aplicacion.getMotor().move("DESCENDIENTESRENTAS", l);
                        continue;
                    }
                    l = Aplicacion.getMotor().obtenerClaveActiva("DESCENDIENTESRENTAS");
                    n3 = 1;
                    while ((long)n3 <= Aplicacion.getMotor().recordCount("DESCENDIENTESRENTAS")) {
                        if (this.sRTIT[n2].equalsIgnoreCase(Declarantes.parseInt(20 + n3 * 10).toString())) {
                            Aplicacion.getMotor().move("DESCENDIENTESRENTAS", n3);
                            if (((FuncionesRentaComun)((Object)object2)).esNifReal(Aplicacion.getMotor().obtenerPartidaString("NIFHR"))) {
                                bl2 = true;
                                break;
                            }
                        }
                        ++n3;
                    }
                    Aplicacion.getMotor().move("DESCENDIENTESRENTAS", l);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            bl2 = false;
            try {
                if (this.bHayConjunta && n2 == 0) {
                    if (((FuncionesRentaComun)((Object)object2)).esNifReal(Aplicacion.getMotor().obtenerPartidaString("DPNIF_D"))) {
                        bl2 = true;
                    }
                    if (((FuncionesRentaComun)((Object)object2)).esNifReal(Aplicacion.getMotor().obtenerPartidaString("DPNIF_C"))) {
                        bl2 = true;
                    }
                    long l = Aplicacion.getMotor().obtenerClaveActiva("DESCENDIENTESRENTAS");
                    n3 = 1;
                    while ((long)n3 <= Aplicacion.getMotor().recordCount("DESCENDIENTESRENTAS")) {
                        Aplicacion.getMotor().move("DESCENDIENTESRENTAS", n3);
                        if (((FuncionesRentaComun)((Object)object2)).esNifReal(Aplicacion.getMotor().obtenerPartidaString("NIFHR"))) {
                            bl2 = true;
                            break;
                        }
                        ++n3;
                    }
                    Aplicacion.getMotor().move("DESCENDIENTESRENTAS", l);
                    continue;
                }
                if (this.sRTIT[n2].equalsIgnoreCase(Declarantes.Declarante.toString())) {
                    if (!((FuncionesRentaComun)((Object)object2)).esNifReal(Aplicacion.getMotor().obtenerPartidaString("DPNIF_D"))) continue;
                    bl2 = true;
                    continue;
                }
                if (this.sRTIT[n2].equalsIgnoreCase(Declarantes.Conyuge.toString())) {
                    if (!((FuncionesRentaComun)((Object)object2)).esNifReal(Aplicacion.getMotor().obtenerPartidaString("DPNIF_C"))) continue;
                    bl2 = true;
                    continue;
                }
                long l = Aplicacion.getMotor().obtenerClaveActiva("DESCENDIENTESRENTAS");
                n3 = 1;
                while ((long)n3 <= Aplicacion.getMotor().recordCount("DESCENDIENTESRENTAS")) {
                    if (this.sRTIT[n2].equalsIgnoreCase(Declarantes.parseInt(20 + n3 * 10).toString())) {
                        Aplicacion.getMotor().move("DESCENDIENTESRENTAS", n3);
                        if (((FuncionesRentaComun)((Object)object2)).esNifReal(Aplicacion.getMotor().obtenerPartidaString("NIFHR"))) {
                            bl2 = true;
                            break;
                        }
                    }
                    ++n3;
                }
                Aplicacion.getMotor().move("DESCENDIENTESRENTAS", l);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        string4 = string4 + "</tr><tr>";
        string4 = string4 + "<td></td>";
        uRL = this.getClass().getResource(Constantes.getDirectorioImagenes() + "imprimirE.png");
        for (n2 = 0; n2 < this.registros; ++n2) {
            String string7 = "href=\"http://fakeurl3.com:" + n2 + "\"";
            string4 = string4 + "<td style='text-align:left'><a " + string7 + "><img src='" + uRL + string5 + " border='0'/></a>&nbsp;<a " + string7 + ">" + string2 + "</a></td>";
        }
        string4 = string4 + "</tr>";
        string4 = string4 + "</tr><tr>";
        string4 = string4 + "<td></td>";
        uRL = this.getClass().getResource(Constantes.getDirectorioImagenes() + "resumen.gif");
        String string8 = "href=\"http://fakeurl4.com\"";
        string4 = string4 + "<td colspan='" + this.registros + "' style='text-align:center'><a " + string8 + "><img src='" + uRL + string5 + " border='0'/></a>&nbsp;<a " + string8 + ">" + string3 + "</a></td>";
        string4 = string4 + "</tr>";
        Rectangle rectangle = PageSize.A4;
        if (this.registros > 5) {
            rectangle = rectangle.rotate();
        }
        Document document = new Document(rectangle);
        this.rutaTemp = AEATHerramientas.compruebaRutaParaFicherosSinoEstablecerPorDefecto(null);
        this.rutaTemp = this.rutaTemp + File.separator + "~resumen.pdf";
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(this.rutaTemp));
        }
        catch (FileNotFoundException fileNotFoundException) {
            AEATLogger.getLogger().fatal((Object)fileNotFoundException);
        }
        catch (DocumentException documentException) {
            AEATLogger.getLogger().fatal((Object)documentException);
        }
        HeaderFooter headerFooter = new HeaderFooter(new Phrase(""), true);
        headerFooter.setBorder(0);
        headerFooter.setAlignment(1);
        document.setFooter(headerFooter);
        HeaderFooter headerFooter2 = new HeaderFooter((Phrase)new Paragraph(this.tpTitulo.getText()), false);
        headerFooter2.setBorder(2);
        headerFooter2.setAlignment(1);
        document.setHeader(headerFooter2);
        document.open();
        try {
            document.add((Element)new Paragraph(" "));
            this.datatable = new PdfPTable(this.registros + 1);
            this.datatable.getDefaultCell().setHorizontalAlignment(0);
            this.datatable.addCell("");
            for (int i = 0; i < this.registros; ++i) {
                Paragraph paragraph = new Paragraph(this.sTitular[i]);
                paragraph.font().setSize(10.0f);
                paragraph.font().setStyle("bold");
                PdfPCell pdfPCell = new PdfPCell((Phrase)paragraph);
                pdfPCell.setHorizontalAlignment(1);
                this.datatable.addCell(pdfPCell);
            }
            object = new int[this.registros + 1];
            object[0] = 10;
            for (n = 1; n <= this.registros; ++n) {
                object[n] = 3;
            }
            this.datatable.setWidths((int[])object);
            this.datatable.setWidthPercentage(100.0f);
            this.datatable.getDefaultCell().setPadding(3.0f);
            this.datatable.setHeaderRows(2);
            this.datatable.getDefaultCell().setBorderWidth(1.0f);
        }
        catch (DocumentException documentException) {
            AEATLogger.getLogger().fatal((Object)documentException);
        }
        object = "";
        n = 0;
        for (int i = 0; i < this.objetosResumen.size(); ++i) {
            if (!((String)object).equals(this.objetosResumen.get(i).getApartado())) {
                n = 0;
            }
            if (this.objetosResumen.get(i).getIndentar() == 1) {
                n = 1;
            }
            String string9 = this.imprimeLineaPartida(this.objetosResumen.get(i), this.sRTIT, this.registros, false);
            if (this.objetosResumen.get(i).getIndentar() != 1 && !string9.trim().equals("") && n == 0) {
                n = 1;
                string4 = string4 + this.imprimeLineaTit(this.objetosResumen.get(i).getApartado(), this.registros);
            }
            if (!string9.equals(this.LINEAOCULTA)) {
                string4 = string4 + string9;
                this.imprimeLineaPartida(this.objetosResumen.get(i), this.sRTIT, this.registros, true);
            }
            object = this.objetosResumen.get(i).getApartado();
        }
        string4 = string4 + "</tr></table>";
        string4 = string4 + "</body></html>";
        try {
            document.add((Element)this.datatable);
            document.close();
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
        }
        try {
            ((FuncionesRentaComun)((Object)object2)).irDeclaracion(declarantes);
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
        }
        AEATLogger.getLogger().debug((Object)string4);
        return string4;
    }

    private void rellenaDatos() throws ExceptionMotor, MalformedURLException {
        this.jEditorPane.setText(this.generaHTML());
        this.jEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    AEAT100j.getFrame().setCursor(Cursor.getPredefinedCursor(12));
                } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    AEAT100j.getFrame().setCursor(Cursor.getDefaultCursor());
                }
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String string = hyperlinkEvent.getURL().getHost();
                    if (string.contains("titulo")) {
                        int n = string.indexOf("titulo") + "titulo".length();
                        int n2 = string.indexOf(".com");
                        String string2 = string.substring(n, n2);
                        boolean bl = new Boolean((Boolean)JPanelResumen.this.objetosTitulo.get(string2));
                        JPanelResumen.this.objetosTitulo.put(string2, !bl);
                        try {
                            JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                            jEditorPane.setText(JPanelResumen.this.generaHTML());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        return;
                    }
                    int n = hyperlinkEvent.getURL().getPort();
                    if (n == -1) {
                        this.guardarPDF();
                        return;
                    }
                    String string3 = JPanelResumen.this.sRTIT[n];
                    try {
                        Object object;
                        Aplicacion.getmPanelBotones().jButtonAceptarActionPerformed(true, true);
                        boolean bl = false;
                        Declarantes declarantes = null;
                        declarantes = Declarantes.parseString(string3);
                        if (declarantes.equals(Declarantes.Declarante)) {
                            object = null;
                            FuncionesRenta funcionesRenta = new FuncionesRenta();
                            try {
                                object = funcionesRenta.cualDeclaracion();
                                funcionesRenta.irDeclaracion(Declarantes.Declarante);
                                if (Aplicacion.getMotor().obtenerPartidaString("ZCOMPE").equalsIgnoreCase("true")) {
                                    bl = true;
                                }
                                funcionesRenta.irDeclaracion((Declarantes)object);
                            }
                            catch (Exception exception) {
                                AEATLogger.getLogger().fatal((Object)exception);
                            }
                        }
                        if (string.contains("fakeurl1")) {
                            AEAT100j.getFrame().presTelematica(declarantes, bl);
                        } else if (string.contains("fakeurl2")) {
                            if (JPanelResumen.this.existeAlgunNifMenorQue100()) {
                                bl = false;
                            }
                            AEAT100j.getFrame().imprimir(1, declarantes, bl);
                        } else if (string.contains("fakeurl3")) {
                            AEAT100j.getFrame().imprimir(2, Declarantes.parseString(string3), false);
                        } else if (string.contains("partida")) {
                            Object object2;
                            object = string.substring(7, string.length() - 4);
                            if (((String)object).equals("TPSUMA")) {
                                object = "TPRRT";
                            } else if (((String)object).equals("ANEXOB")) {
                                object = this.damePrimerCampoDeducAutonomicas(declarantes);
                            }
                            int n3 = 0;
                            JComboBox jComboBox = Irpf2014.getmPanelcabnif().jCBdeclarante;
                            for (int i = 0; i < jComboBox.getItemCount(); ++i) {
                                object2 = JPanelResumen.this.dameModalidadCombo(jComboBox.getItemAt(i).toString());
                                if (!((String)object2).equals(string3)) continue;
                                n3 = i;
                                break;
                            }
                            Irpf2014.getmPanelcabnif().jCBdeclarante.setSelectedIndex(n3);
                            Object[] objectArray = JListaErrores.buscarPartida((String)object, 0);
                            if (objectArray != null) {
                                object2 = (Component)objectArray[0];
                                Aplicacion.getmPanelBotones().cambiarDialogo((Integer)objectArray[1]);
                                Aplicacion.getmPanelBotones().jButtonAceptarDesdeResumen((Integer)objectArray[1]);
                                ((Component)object2).requestFocusInWindow();
                            }
                        }
                    }
                    catch (Exception exception) {
                        AEATLogger.getLogger().fatal((Object)("Error en JDlgResumen al imprimir. Titular: " + string3 + " Elemento: " + n));
                    }
                }
            }

            private void guardarPDF() {
                String string = "Resumen";
                String[] stringArray = new String[]{"Fichero Pdf; *.pdf"};
                String[] stringArray2 = new String[]{"pdf"};
                String string2 = AEATHerramientas.compruebaRutaParaFicherosSinoEstablecerPorDefecto(Aplicacion.getAeatCFG().dameEntrada("ruta PDFs"));
                try {
                    File file = AEATHerramientas.seleccionarFicheroParaGuardar(Aplicacion.getInstancia(), null, stringArray, stringArray2, string2, null, null, string);
                    if (file == null) {
                        return;
                    }
                    String string3 = file.toString();
                    Aplicacion.getAeatCFG().escribeEntrada("ruta PDFs", string3);
                    if (!FuncionesUtiles.getFuncionesUtiles().copyFile(JPanelResumen.this.rutaTemp, string3)) {
                        String string4 = "Error al guardar el archivo.";
                        JMensajesProperties jMensajesProperties = new JMensajesProperties(string4);
                        jMensajesProperties.muestraMensaje();
                        return;
                    }
                    AEATHerramientas.visorPredeterminado(string3);
                }
                catch (ExceptionMotor exceptionMotor) {
                    exceptionMotor.printStackTrace();
                }
            }

            private String damePrimerCampoDeducAutonomicas(Declarantes declarantes) throws NumberFormatException, ExceptionMotor {
                int n = 0;
                if (declarantes.equals(Declarantes.Declarante)) {
                    n = Integer.parseInt(Aplicacion.getMotor().obtenerPartidaString("CAC_D"));
                } else if (declarantes.equals(Declarantes.Conyuge)) {
                    n = Integer.parseInt(Aplicacion.getMotor().obtenerPartidaString("CAC_C"));
                } else if (declarantes.equals(Declarantes.UnidadFamiliar)) {
                    n = Integer.parseInt(Aplicacion.getMotor().obtenerPartidaString("CAOC"));
                } else {
                    long l = Aplicacion.getMotor().obtenerClaveActiva("DESCENDIENTESRENTAS");
                    int n2 = 1;
                    while ((long)n2 <= Aplicacion.getMotor().recordCount("DESCENDIENTESRENTAS")) {
                        if (declarantes.equals(Declarantes.parseInt(20 + 10 * n2))) {
                            Aplicacion.getMotor().move("DESCENDIENTESRENTAS", n2);
                            n = Integer.parseInt(Aplicacion.getMotor().obtenerPartidaString("CACHR"));
                        }
                        ++n2;
                    }
                    Aplicacion.getMotor().move("DESCENDIENTESRENTAS", l);
                }
                switch (n) {
                    case 1: {
                        return "A1";
                    }
                    case 2: {
                        return "AR1";
                    }
                    case 3: {
                        return "PA1";
                    }
                    case 4: {
                        return "IB1";
                    }
                    case 5: {
                        return "CAN1";
                    }
                    case 6: {
                        return "CANT1";
                    }
                    case 7: {
                        return "CM1EA";
                    }
                    case 8: {
                        return "CL1";
                    }
                    case 9: {
                        return "CT1";
                    }
                    case 10: {
                        return "E1";
                    }
                    case 11: {
                        return "GA1";
                    }
                    case 12: {
                        return "M1";
                    }
                    case 13: {
                        return "MU1";
                    }
                    case 16: {
                        return "LR1";
                    }
                    case 17: {
                        return "VA1";
                    }
                }
                return "";
            }
        });
    }

    private String obtenerTituloTitular(String string) throws ExceptionMotor {
        String string2 = Aplicacion.getmResource().getString("JDlgResumen.dec");
        if (string.equalsIgnoreCase(Declarantes.Declarante.getNombreUnico())) {
            string2 = Aplicacion.getmResource().getString("JDlgResumen.dec");
        } else if (string.equalsIgnoreCase(Declarantes.Conyuge.getNombreUnico())) {
            string2 = Aplicacion.getmResource().getString("JDlgResumen.con");
        } else if (string.equalsIgnoreCase(Declarantes.UnidadFamiliar.getNombreUnico())) {
            string2 = Aplicacion.getmResource().getString("JDlgResumen.cj");
        } else {
            int n = 1;
            while ((long)n <= Aplicacion.getMotor().recordCount("DESCENDIENTESRENTAS")) {
                if (string.equalsIgnoreCase(Declarantes.parseInt(20 + 10 * n).getNombreUnico())) {
                    string2 = Aplicacion.getmResource().getString("JDlgResumen.hijA");
                    string2 = string2 + " " + n;
                    string2 = string2 + Aplicacion.getmResource().getString("JDlgResumen.hijB");
                }
                ++n;
            }
        }
        return string2;
    }

    private String dameModalidadCombo(String string) {
        String string2 = Declarantes.Declarante.getNombreUnico();
        if (string.equals(Aplicacion.getmResource().getString("menu.unidadf").toUpperCase())) {
            string2 = Declarantes.UnidadFamiliar.getNombreUnico();
        } else if (string.equals(Aplicacion.getmResource().getString("menu.declarante").toUpperCase())) {
            string2 = Declarantes.Declarante.getNombreUnico();
        } else if (string.equals(Aplicacion.getmResource().getString("menu.conyuge").toUpperCase())) {
            string2 = Declarantes.Conyuge.getNombreUnico();
        } else if (string.startsWith(Aplicacion.getmResource().getString("menu.hijo").toUpperCase())) {
            int n = Integer.parseInt(string.substring(string.length() - 1));
            string2 = Declarantes.parseInt(20 + n * 10).getNombreUnico();
        }
        return string2;
    }

    private String imprimeLineaTit(String string, int n) {
        String string2 = "";
        String string3 = "JDlgResumen." + string;
        string2 = string2 + "<tr>";
        String string4 = "' height='16' width='16'";
        boolean bl = new Boolean(this.objetosTitulo.get(string));
        String string5 = "";
        string5 = bl ? "menos.jpg" : "mas.jpg";
        String string6 = Aplicacion.getmResource().getString(string3);
        int n2 = 90 + 15 * n;
        if (string6.length() > n2 && string6.substring(n2).indexOf(32) != -1) {
            int n3 = n2 + string6.substring(n2).indexOf(32);
            string6 = string6.substring(0, n3) + "<br>" + TABULADOR + string6.substring(n3 + 1);
        }
        URL uRL = this.getClass().getResource(Constantes.getDirectorioImagenes() + string5);
        String string7 = "href=\"http://titulo" + string + ".com:" + 1 + "\"";
        string2 = string2 + "<td " + this.estiloTit + " colspan=" + (n + 1) + "><a " + string7 + "><img src='" + uRL + string4 + " border='0'/></a><b>" + TABULADOR + string6 + "</b></td>";
        string2 = string2 + "</tr>";
        this.datatable.getDefaultCell().setHorizontalAlignment(0);
        string6 = string6.replaceAll("<br>", " ").replaceAll("&nbsp;", "");
        Paragraph paragraph = new Paragraph(string6);
        paragraph.font().setSize(10.0f);
        paragraph.font().setStyle("bold");
        PdfPCell pdfPCell = new PdfPCell((Phrase)paragraph);
        pdfPCell.setColspan(n + 1);
        pdfPCell.setPadding(3.0f);
        this.datatable.addCell(pdfPCell);
        return string2;
    }

    private String imprimeLineaPartida(ObjetoResumen objetoResumen, String[] stringArray, int n, boolean bl) throws ExceptionMotor {
        int n2;
        int n3;
        Object object;
        double[] dArray = new double[n];
        String[] stringArray2 = new String[n];
        String[] stringArray3 = new String[n];
        boolean bl2 = new Boolean(this.objetosTitulo.get(objetoResumen.getApartado()));
        String string = "' height='16' width='16'";
        String string2 = "";
        String string3 = "";
        string3 = string3 + "<tr>";
        String string4 = "JDlgResumen." + objetoResumen.getPartida();
        if (objetoResumen.getPartida().equalsIgnoreCase("R_RET5") && objetoResumen.getApartado().equalsIgnoreCase("F1")) {
            string4 = "JDlgResumen.R_RET5.F1EO";
        }
        for (int i = 0; i < this.registros; ++i) {
            try {
                Aplicacion.getMotor().move("RESUMEN", i + 1);
                try {
                    if (objetoResumen.getPartida().equalsIgnoreCase("R_SPNIF")) {
                        stringArray3[i] = Aplicacion.getMotor().obtenerPartidaString(objetoResumen.getPartida());
                        continue;
                    }
                    dArray[i] = Double.parseDouble(Aplicacion.getMotor().obtenerPartidaString(objetoResumen.getPartida()));
                    if (!objetoResumen.isEsPendiente()) continue;
                    if (dArray[i] == 0.0 && Boolean.parseBoolean(Aplicacion.getMotor().obtenerPartidaString(objetoResumen.getPartidaPendiente()))) {
                        stringArray2[i] = Aplicacion.getmResource().getString("JPanelResumen.pendiente");
                        continue;
                    }
                    stringArray2[i] = this.formateaPartidaDoble("" + dArray[i]);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            catch (ExceptionMotor exceptionMotor) {
                AEATLogger.getLogger().fatal((Object)exceptionMotor);
            }
        }
        String string5 = "";
        String string6 = "";
        String string7 = "";
        if (objetoResumen.getIndentar() == 1) {
            string2 = bl2 ? "menos.jpg" : "mas.jpg";
            bl2 = true;
            object = this.getClass().getResource(Constantes.getDirectorioImagenes() + string2);
            String string8 = "href=\"http://titulo" + objetoResumen.getApartado() + ".com:" + 1 + "\"";
            string7 = "<a " + string8 + "><img src='" + object + string + " border='0'/></a>";
            string5 = "<b>";
            string6 = "</b>";
        }
        object = "";
        for (int i = 0; i < objetoResumen.getIndentar(); ++i) {
            object = (String)object + TABULADOR;
        }
        String string9 = Aplicacion.getmResource().getString(string4);
        if (string9.length() > 90 && string9.substring(90).indexOf(32) != -1) {
            n3 = 90 + string9.substring(90).indexOf(32);
            string9 = string9.substring(0, n3) + "<br>" + (String)object + string9.substring(n3 + 1);
        }
        string3 = string3 + "<td " + this.estilotdLe + ">" + string7 + string5 + (String)object + string9 + string6 + "</td>";
        n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            if (objetoResumen.getPartida().equalsIgnoreCase("R_SPNIF")) {
                if ("".equalsIgnoreCase(stringArray3[n2])) continue;
                n3 = 1;
                break;
            }
            if (dArray[n2] == 0.0 && (!objetoResumen.isEsPendiente() || !Boolean.parseBoolean(Aplicacion.getMotor().obtenerPartidaString(objetoResumen.getPartidaPendiente())))) continue;
            n3 = 1;
            break;
        }
        if (n3 == 0 && !objetoResumen.isObligatorio()) {
            return "";
        }
        for (n2 = 0; n2 < n; ++n2) {
            try {
                if (objetoResumen.getPartida().equalsIgnoreCase("R_SPNIF")) {
                    if (n == 1 || n > 1 && n2 > 0) {
                        string3 = string3 + "<td " + this.estiloNIF + "><b>" + this.formateaNIF(stringArray3[n2]) + "</b></td>";
                        continue;
                    }
                    string3 = string3 + "<td></td>";
                    continue;
                }
                if (objetoResumen.isEsPendiente()) {
                    string3 = string3 + "<td " + this.estilotdRi + "><a href=\"http://partida" + objetoResumen.getPartidaIrA() + ".com:" + n2 + "\">" + stringArray2[n2] + "</a></td>";
                    continue;
                }
                string3 = string3 + "<td " + this.estilotdRi + "><a href=\"http://partida" + objetoResumen.getPartidaIrA() + ".com:" + n2 + "\">" + this.formateaPartidaDoble("" + dArray[n2]) + "</a></td>";
                continue;
            }
            catch (ExceptionMotor exceptionMotor) {
                AEATLogger.getLogger().fatal((Object)exceptionMotor);
            }
        }
        string3 = string3 + "</tr>";
        if (!bl2 && !string3.equals("")) {
            return this.LINEAOCULTA;
        }
        if (bl) {
            this.datatable.getDefaultCell().setHorizontalAlignment(0);
            string9 = string9.replaceAll("<br>", " ").replaceAll("&nbsp;", "");
            Paragraph paragraph = new Paragraph(string9);
            paragraph.font().setSize(9.0f);
            if (objetoResumen.getIndentar() == 1) {
                paragraph.font().setStyle("bold");
            }
            PdfPCell pdfPCell = new PdfPCell((Phrase)paragraph);
            pdfPCell.setPadding(3.0f);
            this.datatable.addCell(pdfPCell);
            for (int i = 0; i < dArray.length; ++i) {
                try {
                    PdfPCell pdfPCell2;
                    Paragraph paragraph2;
                    if (objetoResumen.getPartida().equalsIgnoreCase("R_SPNIF")) {
                        if (n == 1 || n > 1 && i > 0) {
                            paragraph2 = new Paragraph(this.formateaNIF(stringArray3[i]));
                            paragraph2.font().setSize(9.0f);
                            pdfPCell2 = new PdfPCell((Phrase)paragraph2);
                            pdfPCell2.setHorizontalAlignment(1);
                            pdfPCell2.setPadding(3.0f);
                            this.datatable.addCell(pdfPCell2);
                            continue;
                        }
                        this.datatable.addCell("");
                        continue;
                    }
                    paragraph2 = new Paragraph(this.formateaPartidaDoble("" + dArray[i]));
                    if (objetoResumen.isEsPendiente() && dArray[i] == 0.0 && Boolean.parseBoolean(Aplicacion.getMotor().obtenerPartidaString(objetoResumen.getPartidaPendiente()))) {
                        paragraph2 = new Paragraph("" + stringArray2[i]);
                    }
                    paragraph2.font().setSize(9.0f);
                    pdfPCell2 = new PdfPCell((Phrase)paragraph2);
                    pdfPCell2.setHorizontalAlignment(2);
                    pdfPCell2.setPadding(3.0f);
                    this.datatable.addCell(pdfPCell2);
                    continue;
                }
                catch (ExceptionMotor exceptionMotor) {
                    AEATLogger.getLogger().fatal((Object)exceptionMotor);
                }
            }
            return "";
        }
        return string3;
    }

    private String formateaNIF(String string) throws ExceptionMotor {
        String string2 = string;
        String string3 = "";
        if (string2.equals("")) {
            string3 = "";
        } else {
            char c = string2.charAt(0);
            if (Character.isLetter(c)) {
                string3 = string2.substring(0, 1);
                for (int i = 0; i < 9 - string2.length(); ++i) {
                    string3 = string3 + "0";
                }
                string3 = string3 + string2.substring(1, string2.length());
            } else {
                for (int i = 0; i < 9 - string2.length(); ++i) {
                    string3 = string3 + "0";
                }
                string3 = string3 + string2;
            }
        }
        return string3;
    }

    private String formateaPartidaDoble(String string) throws ExceptionMotor {
        double d = Double.parseDouble(string);
        Locale locale = new Locale("es", "ES");
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
        String string2 = "#,###,###,###,##0.00";
        DecimalFormat decimalFormat = new DecimalFormat(string2, decimalFormatSymbols);
        String string3 = decimalFormat.format(d);
        return string3;
    }

    public final void initComponents() {
        this.setName("Resumen de las declaraciones@JDlgResumen");
        this.putClientProperty("tamx", "1");
        this.putClientProperty("tamy", "5");
        this.putClientProperty("gestorlistener", "false");
        this.putClientProperty("listalistener", "true");
        this.putClientProperty("titulopagina", "false");
        this.putClientProperty("indLabel", "0");
        this.putClientProperty("indText", "0");
        this.setLayout(new GridBagLayout());
        this.tpTitulo.setOpaque(false);
        this.tpTitulo.setText("Resumen de declaraciones");
        this.tpTitulo.setName("RESDECLA");
        this.tpTitulo.setFormato(1, true, false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 25;
        gridBagConstraints.insets.right = 25;
        gridBagConstraints.insets.top = 5;
        this.add((Component)this.tpTitulo, gridBagConstraints);
    }

    private void initResComponents() {
        this.jEditorPane = new JEditorPane();
        this.jEditorPane.setContentType("text/html");
        this.jEditorPane.setEditable(false);
        this.jEditorPane.setFocusable(false);
        this.jEditorPane.setBorder(new LineBorder(Constantes.getColorBkClaro()));
        this.jEditorPane.setBackground(Constantes.getColorBkClaro());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        this.add((Component)this.jEditorPane, gridBagConstraints);
    }

    private void obtenerValores() throws ExceptionMotor {
        Aplicacion.getMotor().establecerPartida("R_DF_HAYRTCAE", Aplicacion.getMotor().obtenerPartidaString("DF_HAYRTCAE"));
        Aplicacion.getMotor().establecerPartida("R_DF_HAYEARAE", Aplicacion.getMotor().obtenerPartidaString("DF_HAYEARAE"));
        try {
            String string = "";
            String string2 = "";
            for (int i = 0; i < this.objetosResumen.size(); ++i) {
                string = this.objetosResumen.get(i).getPartida();
                string2 = this.objetosResumen.get(i).getPartida().substring(2);
                if (string.equals("R_TPSUMA") || string.equals("R_RESULTADO")) continue;
                Aplicacion.getMotor().establecerPartida(string, Aplicacion.getMotor().obtenerPartidaString(string2));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        double d = Double.parseDouble(Aplicacion.getMotor().obtenerPartidaString("TPRRT")) + Double.parseDouble(Aplicacion.getMotor().obtenerPartidaString("TPPRO")) + Double.parseDouble(Aplicacion.getMotor().obtenerPartidaString("TPMV")) + Double.parseDouble(Aplicacion.getMotor().obtenerPartidaString("TPTAD"));
        Aplicacion.getMotor().establecerPartida("R_TPSUMA", "" + d);
        double d2 = Double.parseDouble(Aplicacion.getMotor().obtenerPartidaString("RESDECCOMP"));
        double d3 = Double.parseDouble(Aplicacion.getMotor().obtenerPartidaString("RESULTADO"));
        if (d2 == 0.0) {
            Aplicacion.getMotor().establecerPartida("R_RESULTADO", "" + d3);
        } else {
            Aplicacion.getMotor().establecerPartida("R_RESULTADO", "" + d2);
        }
    }

    public final boolean cargar() {
        FuncionesRenta funcionesRenta = new FuncionesRenta();
        boolean bl = true;
        Declarantes declarantes = null;
        try {
            declarantes = (Declarantes)Aplicacion.getMotor().ejecutarFuncion("cualDeclaracion", null);
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
        }
        try {
            Aplicacion.getMotor().borrarRegistros("RESUMEN");
            if (FuncionesRenta.isBConjunta()) {
                Aplicacion.getMotor().anniadirRegistro("RESUMEN");
                Aplicacion.getMotor().establecerPartida("R_TIT", Declarantes.UnidadFamiliar.toString());
                funcionesRenta.irDeclaracion(Declarantes.UnidadFamiliar);
                this.obtenerValores();
            }
            Aplicacion.getMotor().anniadirRegistro("RESUMEN");
            Aplicacion.getMotor().establecerPartida("R_TIT", Declarantes.Declarante.toString());
            funcionesRenta.irDeclaracion(Declarantes.Declarante);
            this.obtenerValores();
            if (FuncionesRenta.isBConyuge()) {
                Aplicacion.getMotor().anniadirRegistro("RESUMEN");
                Aplicacion.getMotor().establecerPartida("R_TIT", Declarantes.Conyuge.toString());
                funcionesRenta.irDeclaracion(Declarantes.Conyuge);
                this.obtenerValores();
            }
            int n = 1;
            while ((long)n <= Aplicacion.getMotor().recordCount("DESCENDIENTESRENTAS")) {
                if (FuncionesRenta.isBHijos(n)) {
                    Aplicacion.getMotor().anniadirRegistro("RESUMEN");
                    Aplicacion.getMotor().establecerPartida("R_TIT", Declarantes.parseInt(20 + n * 10).toString());
                    funcionesRenta.irDeclaracion(Declarantes.parseInt(20 + n * 10));
                    this.obtenerValores();
                }
                ++n;
            }
            funcionesRenta.irDeclaracion(declarantes);
        }
        catch (ExceptionMotor exceptionMotor) {
            AEATLogger.getLogger().fatal((Object)"Error cargar JPanelResumen: ", (Throwable)exceptionMotor);
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)"Error cargar JPanelResumen: ", (Throwable)exception);
        }
        bl = this.mlComponentes.cargar();
        this.tieneContenido();
        return bl;
    }

    public final void setInitialFocus() {
    }

    public final String raiz() {
        return this.mlComponentes.raiz();
    }

    public boolean getError() {
        return this.mlComponentes.getError();
    }

    public boolean tieneContenido() {
        return this.mlComponentes.tieneContenido();
    }

    public String devolucion() {
        return null;
    }

    public void setParametro(String string, Object object) {
    }

    private boolean existeAlgunNifMenorQue100() throws Exception {
        boolean bl = false;
        FuncionesRenta funcionesRenta = new FuncionesRenta();
        if (funcionesRenta.esNifReal(Aplicacion.getMotor().obtenerPartidaString("DPNIF_D"))) {
            bl = true;
        }
        if (funcionesRenta.esNifReal(Aplicacion.getMotor().obtenerPartidaString("DPNIF_C"))) {
            bl = true;
        }
        long l = Aplicacion.getMotor().obtenerClaveActiva("DESCENDIENTESRENTAS");
        int n = 1;
        while ((long)n <= Aplicacion.getMotor().recordCount("DESCENDIENTESRENTAS")) {
            Aplicacion.getMotor().move("DESCENDIENTESRENTAS", n);
            if (funcionesRenta.esNifReal(Aplicacion.getMotor().obtenerPartidaString("NIFHR"))) {
                bl = true;
                break;
            }
            ++n;
        }
        Aplicacion.getMotor().move("DESCENDIENTESRENTAS", l);
        return bl;
    }
}

