/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.re14.gui;

import es.aeat.pare.aplicacion.Aplicacion;
import es.aeat.pare.cc14.Declarantes;
import es.aeat.pare.componentes.AEATGestorConMotor;
import es.aeat.pare.componentes.AEATHerramientas;
import es.aeat.pare.componentes.AEATLVIrpf;
import es.aeat.pare.componentes.AEATLanzaVentana;
import es.aeat.pare.componentes.AEATLogger;
import es.aeat.pare.componentes.AEATcontgestor;
import es.aeat.pare.componentes.AEATgestorComponentes;
import es.aeat.pare.componentes.AEATmotorCtrlDocument;
import es.aeat.pare.componentes.AEATmotorListener;
import es.aeat.pare.componentes.JAEATToolBar;
import es.aeat.pare.componentes.JMensajesProperties;
import es.aeat.pare.componentes.JPanelRenta;
import es.aeat.pare.componentes.JTextPaneRaya;
import es.aeat.pare.componentes.JTituloPag;
import es.aeat.pare.re14.motor.FuncionesRenta;
import es.aeat.pare.re14.motor.motorComun.CalculosG2;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public final class JPanelG2GPFondos
extends JPanelRenta
implements AEATcontgestor {
    private static final long serialVersionUID = 1L;
    private JAEATToolBar toolBar;
    private AEATgestorComponentes mgComponentes = new AEATGestorConMotor("G2GPFONDOS");
    private static final int MAXIMO = 60;
    private static final int MAXIMOHIJOS = 45;
    private JTituloPag jPTituloPag;
    private JPanel caja;
    private JLabel jLBlabelAncla;
    private JTextPaneRaya jTPtextpane4;
    private JTextPaneRaya jTPtextpane5;
    private JLabel jLBlabel0;
    private JLabel jLBlabel1;
    private JTextField jTFG2ANIF;
    private JTextField jTFG2AT;
    private JTextPaneRaya jTPtextpane6;
    private JTextPaneRaya jTPtextpane13;
    private JTextPaneRaya jTPtextpane14;
    private JLabel jLBlabel2;
    private JLabel jLBlabel3;
    private JLabel jLBlabel4;
    private JLabel jLBlabel5;
    private JTextField jTFG2ART0;
    private JTextField jTFG2ART1;
    private JTextPaneRaya jTPtextpane15;
    private AEATLanzaVentana lvG2AR1;
    private AEATLanzaVentana lvG2AR2;
    private JTextField jTFOCURREG2FONDO;
    private JTextPaneRaya jTPtextpane17;
    private JTextPaneRaya jTPtextpane18;

    public JPanelG2GPFondos() {
        this.initComponents();
        this.setSize(783, 420);
        try {
            this.initResComponents();
            this.mgComponentes.contenedor(this);
            FuncionesRenta funcionesRenta = new FuncionesRenta();
            Declarantes declarantes = funcionesRenta.cualDeclaracion();
            if (declarantes.getNombreUnico().startsWith("HIJO")) {
                this.mgComponentes.setMaximo(45);
            } else {
                this.mgComponentes.setMaximo(60);
            }
            this.mgComponentes.ordenarSegun("ORDEN_G2_FONDO");
        }
        catch (Exception exception) {
            AEATLogger.getLogger().info((Object)"----------Error controlado si estamos utilizando HerramientasXML:-------", (Throwable)exception);
        }
        this.establecerAyuda();
        AEATmotorCtrlDocument.annadirDocument(this);
        AEATmotorListener.annadirListeners(this);
    }

    @Override
    public void traducirPanel() {
        this.establecerAyuda();
    }

    public void establecerAyuda() {
        try {
            this.jTFG2ANIF.putClientProperty("HELPTOPIC", Aplicacion.getmResourceAyuda().getString("gananciasyprdidasderivadasdetransmisionesoreembolsosdeaccionesoparticipacionesensociedadesyfondosdeinversin"));
            this.lvG2AR1.putClientProperty("HELPTOPIC", Aplicacion.getmResourceAyuda().getString("gananciasyprdidasderivadasdetransmisionesoreembolsosdeaccionesoparticipacionesensociedadesyfondosdeinversin"));
            this.lvG2AR2.putClientProperty("HELPTOPIC", Aplicacion.getmResourceAyuda().getString("gananciasyprdidasderivadasdetransmisionesoreembolsosdeaccionesoparticipacionesensociedadesyfondosdeinversin"));
            AEATHerramientas.initHelp(this);
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)"Error en el ayuda");
        }
    }

    private void initResComponents() throws Exception {
        this.toolBar = new JAEATToolBar(Aplicacion.getmResource().getString("toolbar.sociedad"), this, this.mgComponentes);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        this.caja.add((Component)this.toolBar.getToolBar(), gridBagConstraints);
    }

    private void initComponents() {
        this.setName("Ganancias y p\u00e9rdidas sometidas a retenci\u00f3n derivadas de transmisiones o reembolsos de acciones o participaciones de sociedades y fondos de inversi\u00f3n@JPanelG2GPFondos");
        this.putClientProperty("tamx", "6");
        this.putClientProperty("tamy", "15");
        this.putClientProperty("gestorlistener", "true");
        this.putClientProperty("listalistener", "false");
        this.putClientProperty("titulopagina", "true");
        this.putClientProperty("indLabel", "6");
        this.putClientProperty("indText", "19");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.jPTituloPag = new JTituloPag("G2.", "Ganancias y p\u00e9rdidas patrimoniales derivadas de la transmisi\u00f3n de elementos \npatrimoniales adquiridos con UN A\u00d1O O MENOS de antelaci\u00f3n a la fecha de \ntransmisi\u00f3n (a integrar en la base imponible general)", "P\u00e1gina 9 (II)");
        this.jPTituloPag.setName("titulopag");
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.left = 25;
        gridBagConstraints.insets.right = 25;
        gridBagConstraints.insets.top = 5;
        this.add((Component)this.jPTituloPag, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.caja = new JPanel();
        this.caja.setLayout(new GridBagLayout());
        this.caja.setBorder(new TitledBorder("Ganancias y p\u00e9rdidas patrimoniales sometidas a retenci\u00f3n o ingreso a cuenta derivadas de transmisiones o reembolsos "));
        this.caja.setName("caja");
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 25;
        gridBagConstraints.insets.right = 25;
        gridBagConstraints.insets.top = 0;
        this.add((Component)this.caja, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jLBlabelAncla = new JLabel(" ");
        this.jLBlabelAncla.setName("labelAncla");
        this.jLBlabelAncla.setFocusCycleRoot(false);
        this.jLBlabelAncla.setFocusable(false);
        this.jLBlabelAncla.setRequestFocusEnabled(false);
        this.jLBlabelAncla.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 100;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 10;
        this.add((Component)this.jLBlabelAncla, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jTPtextpane4 = new JTextPaneRaya();
        this.jTPtextpane4.setFormato(3, true, false, false, false);
        this.jTPtextpane4.setName("textpane4");
        this.jTPtextpane4.setText("Acciones o participaciones transmitidas y titulares:");
        this.jTPtextpane4.setEditable(false);
        this.jTPtextpane4.setFocusCycleRoot(false);
        this.jTPtextpane4.setFocusable(false);
        this.jTPtextpane4.setRequestFocusEnabled(false);
        this.jTPtextpane4.setOpaque(false);
        this.jTPtextpane4.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        this.caja.add((Component)this.jTPtextpane4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jTPtextpane5 = new JTextPaneRaya();
        this.jTPtextpane5.setFormato(0, false, true, false, false);
        this.jTPtextpane5.setName("textpane5");
        this.jTPtextpane5.setText("Contribuyente titular de las acciones o participaciones");
        this.jTPtextpane5.setEditable(false);
        this.jTPtextpane5.setFocusCycleRoot(false);
        this.jTPtextpane5.setFocusable(false);
        this.jTPtextpane5.setRequestFocusEnabled(false);
        this.jTPtextpane5.setOpaque(false);
        this.jTPtextpane5.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        this.caja.add((Component)this.jTPtextpane5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jLBlabel0 = new JLabel("268");
        this.jLBlabel0.setName("label0");
        this.jLBlabel0.setHorizontalAlignment(0);
        this.jLBlabel0.setFocusCycleRoot(false);
        this.jLBlabel0.setFocusable(false);
        this.jLBlabel0.setRequestFocusEnabled(false);
        this.jLBlabel0.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        this.jLBlabel0.setBorder(new LineBorder(Color.black));
        this.caja.add((Component)this.jLBlabel0, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jLBlabel1 = new JLabel("269");
        this.jLBlabel1.setName("label1");
        this.jLBlabel1.setHorizontalAlignment(0);
        this.jLBlabel1.setFocusCycleRoot(false);
        this.jLBlabel1.setFocusable(false);
        this.jLBlabel1.setRequestFocusEnabled(false);
        this.jLBlabel1.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        this.jLBlabel1.setBorder(new LineBorder(Color.black));
        this.caja.add((Component)this.jLBlabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jTFG2ANIF = new JTextField("");
        this.jTFG2ANIF.setName("G2A_NIF");
        this.jTFG2ANIF.setColumns(12);
        this.jTFG2ANIF.setToolTipText("Sociedades y fondos de inversi\u00f3n: NIF de la sociedad o fondo de inversi\u00f3n");
        this.jTFG2ANIF.getAccessibleContext().setAccessibleName("Sociedades y fondos de inversi\u00f3n: NIF de la sociedad o fondo de inversi\u00f3n");
        this.jTFG2ANIF.getAccessibleContext().setAccessibleDescription("Sociedades y fondos de inversi\u00f3n: NIF de la sociedad o fondo de inversi\u00f3n");
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        this.caja.add((Component)this.jTFG2ANIF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jTFG2AT = new JTextField("");
        this.jTFG2AT.setName("G2A_T");
        this.jTFG2AT.setColumns(12);
        this.jTFG2AT.setToolTipText("Sociedades y fondos de inversi\u00f3n: contribuyente  titular de las acciones");
        this.jTFG2AT.getAccessibleContext().setAccessibleName("Sociedades y fondos de inversi\u00f3n: contribuyente  titular de las acciones");
        this.jTFG2AT.getAccessibleContext().setAccessibleDescription("Sociedades y fondos de inversi\u00f3n: contribuyente  titular de las acciones");
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        this.caja.add((Component)this.jTFG2AT, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jTPtextpane6 = new JTextPaneRaya();
        this.jTPtextpane6.setFormato(0, false, true, false, false);
        this.jTPtextpane6.setName("textpane6");
        this.jTPtextpane6.setText("NIF de la sociedad o fondo de inversi\u00f3n");
        this.jTPtextpane6.setEditable(false);
        this.jTPtextpane6.setFocusCycleRoot(false);
        this.jTPtextpane6.setFocusable(false);
        this.jTPtextpane6.setRequestFocusEnabled(false);
        this.jTPtextpane6.setOpaque(false);
        this.jTPtextpane6.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        this.caja.add((Component)this.jTPtextpane6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jTPtextpane13 = new JTextPaneRaya();
        this.jTPtextpane13.setFormato(0, false, true, false, false);
        this.jTPtextpane13.setName("textpane13");
        this.jTPtextpane13.setText("Positivos: Ganancias patrimoniales");
        this.jTPtextpane13.setEditable(false);
        this.jTPtextpane13.setFocusCycleRoot(false);
        this.jTPtextpane13.setFocusable(false);
        this.jTPtextpane13.setRequestFocusEnabled(false);
        this.jTPtextpane13.setOpaque(false);
        this.jTPtextpane13.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        this.caja.add((Component)this.jTPtextpane13, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jTPtextpane14 = new JTextPaneRaya();
        this.jTPtextpane14.setFormato(0, false, true, false, false);
        this.jTPtextpane14.setName("textpane14");
        this.jTPtextpane14.setText("Negativos: P\u00e9rdidas patrimoniales");
        this.jTPtextpane14.setEditable(false);
        this.jTPtextpane14.setFocusCycleRoot(false);
        this.jTPtextpane14.setFocusable(false);
        this.jTPtextpane14.setRequestFocusEnabled(false);
        this.jTPtextpane14.setOpaque(false);
        this.jTPtextpane14.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        this.caja.add((Component)this.jTPtextpane14, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jLBlabel2 = new JLabel("270");
        this.jLBlabel2.setName("label2");
        this.jLBlabel2.setHorizontalAlignment(0);
        this.jLBlabel2.setFocusCycleRoot(false);
        this.jLBlabel2.setFocusable(false);
        this.jLBlabel2.setRequestFocusEnabled(false);
        this.jLBlabel2.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        this.jLBlabel2.setBorder(new LineBorder(Color.black));
        this.caja.add((Component)this.jLBlabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jLBlabel3 = new JLabel("271");
        this.jLBlabel3.setName("label3");
        this.jLBlabel3.setHorizontalAlignment(0);
        this.jLBlabel3.setFocusCycleRoot(false);
        this.jLBlabel3.setFocusable(false);
        this.jLBlabel3.setRequestFocusEnabled(false);
        this.jLBlabel3.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        this.jLBlabel3.setBorder(new LineBorder(Color.black));
        this.caja.add((Component)this.jLBlabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jLBlabel4 = new JLabel("274");
        this.jLBlabel4.setName("label4");
        this.jLBlabel4.setHorizontalAlignment(0);
        this.jLBlabel4.setFocusCycleRoot(false);
        this.jLBlabel4.setFocusable(false);
        this.jLBlabel4.setRequestFocusEnabled(false);
        this.jLBlabel4.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 20;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        this.jLBlabel4.setBorder(new LineBorder(Color.black));
        this.caja.add((Component)this.jLBlabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jLBlabel5 = new JLabel("275");
        this.jLBlabel5.setName("label5");
        this.jLBlabel5.setHorizontalAlignment(0);
        this.jLBlabel5.setFocusCycleRoot(false);
        this.jLBlabel5.setFocusable(false);
        this.jLBlabel5.setRequestFocusEnabled(false);
        this.jLBlabel5.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        this.jLBlabel5.setBorder(new LineBorder(Color.black));
        this.caja.add((Component)this.jLBlabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jTFG2ART0 = new JTextField("");
        this.jTFG2ART0.setName("G2A_RT0");
        this.jTFG2ART0.setColumns(12);
        this.jTFG2ART0.setToolTipText("Ganancias patrimoniales totales");
        this.jTFG2ART0.getAccessibleContext().setAccessibleName("Ganancias patrimoniales totales");
        this.jTFG2ART0.getAccessibleContext().setAccessibleDescription("Ganancias patrimoniales totales");
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        this.caja.add((Component)this.jTFG2ART0, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jTFG2ART1 = new JTextField("");
        this.jTFG2ART1.setName("G2A_RT1");
        this.jTFG2ART1.setColumns(12);
        this.jTFG2ART1.setToolTipText("P\u00e9rdidas patrimoniales");
        this.jTFG2ART1.getAccessibleContext().setAccessibleName("P\u00e9rdidas patrimoniales");
        this.jTFG2ART1.getAccessibleContext().setAccessibleDescription("P\u00e9rdidas patrimoniales");
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        this.caja.add((Component)this.jTFG2ART1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jTPtextpane15 = new JTextPaneRaya();
        this.jTPtextpane15.setFormato(0, false, false, false, false);
        this.jTPtextpane15.setName("textpane15");
        this.jTPtextpane15.setText("Totales");
        this.jTPtextpane15.setEditable(false);
        this.jTPtextpane15.setFocusCycleRoot(false);
        this.jTPtextpane15.setFocusable(false);
        this.jTPtextpane15.setRequestFocusEnabled(false);
        this.jTPtextpane15.setOpaque(false);
        this.jTPtextpane15.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        this.caja.add((Component)this.jTPtextpane15, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.lvG2AR1 = new AEATLVIrpf(true);
        this.lvG2AR1.setName("G2A_R1");
        this.lvG2AR1.setColumns(12);
        this.lvG2AR1.setToolTipText("Sociedades y fondos de inversi\u00f3n: ganancias patrimoniales");
        this.lvG2AR1.getAccessibleContext().setAccessibleName("Sociedades y fondos de inversi\u00f3n: ganancias patrimoniales");
        this.lvG2AR1.getAccessibleContext().setAccessibleDescription("Sociedades y fondos de inversi\u00f3n: ganancias patrimoniales");
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        this.caja.add((Component)this.lvG2AR1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.lvG2AR2 = new AEATLVIrpf(true);
        this.lvG2AR2.setName("G2A_R2");
        this.lvG2AR2.setColumns(12);
        this.lvG2AR2.setToolTipText("Sociedades y fondos de inversi\u00f3n: p\u00e9rdidas patrimoniales");
        this.lvG2AR2.getAccessibleContext().setAccessibleName("Sociedades y fondos de inversi\u00f3n: p\u00e9rdidas patrimoniales");
        this.lvG2AR2.getAccessibleContext().setAccessibleDescription("Sociedades y fondos de inversi\u00f3n: p\u00e9rdidas patrimoniales");
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        this.caja.add((Component)this.lvG2AR2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jTFOCURREG2FONDO = new JTextField("");
        this.jTFOCURREG2FONDO.setName("OCURRE_G2_FONDO");
        this.jTFOCURREG2FONDO.setColumns(12);
        this.jTFOCURREG2FONDO.setToolTipText("");
        this.jTFOCURREG2FONDO.getAccessibleContext().setAccessibleName("");
        this.jTFOCURREG2FONDO.getAccessibleContext().setAccessibleDescription("");
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        this.caja.add((Component)this.jTFOCURREG2FONDO, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jTPtextpane17 = new JTextPaneRaya();
        this.jTPtextpane17.setFormato(3, true, false, false, false);
        this.jTPtextpane17.setName("textpane17");
        this.jTPtextpane17.setText("Resultados:");
        this.jTPtextpane17.setEditable(false);
        this.jTPtextpane17.setFocusCycleRoot(false);
        this.jTPtextpane17.setFocusable(false);
        this.jTPtextpane17.setRequestFocusEnabled(false);
        this.jTPtextpane17.setOpaque(false);
        this.jTPtextpane17.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        this.caja.add((Component)this.jTPtextpane17, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.jTPtextpane18 = new JTextPaneRaya();
        this.jTPtextpane18.setFormato(3, false, false, false, false);
        this.jTPtextpane18.setName("textpane18");
        this.jTPtextpane18.setText(" de acciones o participaciones de instituciones de inversi\u00f3n colectiva (sociedades y fondos de inversi\u00f3n)");
        this.jTPtextpane18.setEditable(false);
        this.jTPtextpane18.setFocusCycleRoot(false);
        this.jTPtextpane18.setFocusable(false);
        this.jTPtextpane18.setRequestFocusEnabled(false);
        this.jTPtextpane18.setOpaque(false);
        this.jTPtextpane18.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 0;
        this.caja.add((Component)this.jTPtextpane18, gridBagConstraints);
    }

    public String raiz() {
        return this.mgComponentes.raiz();
    }

    @Override
    public void restaurarValoresIniciales() {
    }

    @Override
    public void liberaRecursos() {
    }

    private void actualizarOcurrenciasEnConjunta() throws Exception {
        FuncionesRenta funcionesRenta = new FuncionesRenta();
        if (Aplicacion.getMotor().existsPtr("CONJUNTA")) {
            Declarantes declarantes = funcionesRenta.cualDeclaracion();
            funcionesRenta.irDeclaracion(Declarantes.UnidadFamiliar);
            int n = this.mgComponentes.cuantas();
            Aplicacion.getMotor().establecerPartida("OCURRE_G2_FONDO", n);
            if (n > 60) {
                Aplicacion.getMotor().establecerEstado("OCURRE_G2_FONDO", 254);
            } else {
                Aplicacion.getMotor().establecerEstado("OCURRE_G2_FONDO", 253);
            }
            funcionesRenta.irDeclaracion(declarantes);
        }
    }

    @Override
    public boolean cargar() throws Exception {
        boolean bl = true;
        Aplicacion.getMotor().ejecutarFuncion("calculoRenta", new Object[]{"Habilitaciones", "habilitaG2GPFondos"});
        bl = this.mgComponentes.cargar();
        this.toolBar.contadorRegistros.setText(this.toolBar.getTextoContadorRegistros());
        this.actualizarOcurrenciasEnConjunta();
        this.tieneContenido();
        this.cambiaBotones();
        return bl;
    }

    @Override
    public void setInitialFocus() throws Exception {
        FuncionesRenta funcionesRenta = new FuncionesRenta();
        Declarantes declarantes = funcionesRenta.cualDeclaracion();
        if (declarantes.getNombreUnico().startsWith("HIJO")) {
            this.mgComponentes.setMaximo(45);
        } else {
            this.mgComponentes.setMaximo(60);
        }
        this.jTFG2ANIF.requestFocus();
    }

    @Override
    public boolean retroceder() throws Exception {
        int n = this.mgComponentes.retroceder();
        this.cargar();
        if (n != -1) {
            this.cambiaBotones();
            return true;
        }
        return false;
    }

    @Override
    public boolean avanzar() throws Exception {
        int n = this.mgComponentes.avanzar();
        this.cargar();
        if (n != -1) {
            this.cambiaBotones();
            return true;
        }
        return false;
    }

    @Override
    public boolean borrar() throws Exception {
        boolean bl;
        FuncionesRenta funcionesRenta = new FuncionesRenta();
        if (this.getRootPane() != null) {
            CalculosG2 calculosG2 = new CalculosG2();
            JMensajesProperties jMensajesProperties = new JMensajesProperties("DEC005");
            if (jMensajesProperties.muestraMensaje() == 0) {
                String string = Aplicacion.getMotor().obtenerPartidaString("INDICE_G2F");
                int n = Integer.parseInt(string);
                bl = this.mgComponentes.borrar();
                if (FuncionesRenta.isBConjunta()) {
                    String string2 = "G2GPFONDOS";
                    Declarantes declarantes = funcionesRenta.cualDeclaracion();
                    long l = Aplicacion.getMotor().obtenerClaveActiva(string2);
                    funcionesRenta.irDeclaracion(Declarantes.UnidadFamiliar);
                    if (funcionesRenta.colocaMotorDeTablaEnPosicion(string2, "INDICE_G2F", String.valueOf(n))) {
                        bl = this.mgComponentes.borrar();
                    }
                    funcionesRenta.irDeclaracion(declarantes);
                    Aplicacion.getMotor().move(string2, l);
                }
                calculosG2.calculosG2Fondos("true", "true");
                this.cargar();
                this.cambiaBotones();
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void nueva() throws Exception {
        Declarantes declarantes = new FuncionesRenta().cualDeclaracion();
        if (!declarantes.equals(Declarantes.UnidadFamiliar)) {
            if (this.mgComponentes.hay(1)) {
                this.mgComponentes.nueva();
            }
            this.cargar();
            this.cambiaBotones();
            this.setInitialFocus();
        }
    }

    @Override
    public int cambiaBotones() throws ExceptionMotor {
        int n = this.mgComponentes.cuantas();
        return n;
    }

    @Override
    public boolean irA(int n) throws Exception {
        boolean bl = this.mgComponentes.irA(n);
        this.cargar();
        return bl;
    }

    @Override
    public boolean primera() throws Exception {
        int n = this.mgComponentes.primera();
        this.cargar();
        return n != -1;
    }

    @Override
    public boolean ultima() throws Exception {
        int n = this.mgComponentes.ultima();
        this.cargar();
        return n != -1;
    }

    @Override
    public boolean getError() {
        return this.mgComponentes.getError();
    }

    @Override
    public boolean tieneContenido() {
        this.setTieneDatos(this.mgComponentes.tieneContenido());
        return this.isTieneDatos();
    }
}

