/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.re14.datos.ecr;

public class CodDef {
    public static final int TE_EECC = 32768;
    public static final int TE_EECC_INTEGRA = 32769;
    public static final int TE_EECC_INMEDIATA = 33024;
    public static final int TE_AEAT_Y_AEAT_CITRIX = 16640;
    public static final int TE_CCAA_Y_CCAA_CITRIX = 8448;
    public static final int DF_EECC_Y_CCAA = 58176;
    public static final int DF_CCAA_CITRIX_Y_NUEVA_Y_AEAT_Y_AEAT_CITRIX = 62880;
    public static final int PT_EECC_Y_EECC_INTEGRA = 16647170;
    public static final int PT_EECC_INMEDIATA = 16761874;
    public static final int PT_AEAT = 12272149;
    public static final int PT_CCAA = 16761362;
    public static final int PT_CCAA_CITRIX_Y_AEAT_CITRIX_Y_NUEVA = 9126421;
    private final String coddef;
    private String codigoDFAsString = null;
    private int codigoDF = -1;
    private String codigoPTAsString = null;
    private int codigoPT = -1;
    private String codigoTipoEntidadAsString;
    private int codigoTipoEntidad = -1;
    private String codigoVariosAsString;
    private int codigoVarios;

    public CodDef(String string) {
        this.coddef = string;
    }

    public int getCodigoDF() {
        if (this.codigoDF == -1) {
            this.codigoDF = Integer.parseInt(this.getCodigoDFAsString(), 16);
        }
        return this.codigoDF;
    }

    public String getCodigoDFAsString() {
        if (this.codigoDFAsString == null) {
            this.codigoDFAsString = this.coddef.substring(4, 8);
        }
        return this.codigoDFAsString;
    }

    public int getCodigoPT() {
        if (this.codigoPT == -1) {
            this.codigoPT = Integer.parseInt(this.getCodigoPTAsString(), 16);
        }
        return this.codigoPT;
    }

    public String getCodigoPTAsString() {
        if (this.codigoPTAsString == null) {
            this.codigoPTAsString = this.coddef.substring(8, 14);
        }
        return this.codigoPTAsString;
    }

    public String getCodigoTipoEntidadAsString() {
        if (this.codigoTipoEntidadAsString == null) {
            this.codigoTipoEntidadAsString = this.coddef.substring(0, 4);
        }
        return this.codigoTipoEntidadAsString;
    }

    public int getCodigoTipoEntidad() {
        if (this.codigoTipoEntidad == -1) {
            this.codigoTipoEntidad = Integer.parseInt(this.getCodigoTipoEntidadAsString(), 16);
        }
        return this.codigoTipoEntidad;
    }

    public String getCodigoVariosAsString() {
        if (this.codigoVariosAsString == null) {
            this.codigoVariosAsString = this.coddef.substring(14, 16);
        }
        return this.codigoVariosAsString;
    }

    public int getCodigoVarios() {
        if (this.codigoVarios == -1) {
            this.codigoVarios = Integer.parseInt(this.getCodigoTipoEntidadAsString(), 16);
        }
        return this.codigoVarios;
    }

    public String getTipoEntidadComoString() {
        String string;
        switch (this.getCodigoTipoEntidad()) {
            case 32768: {
                string = "EECC";
                break;
            }
            case 33024: {
                string = "EECC (Inm)";
                break;
            }
            case 32769: {
                string = "EECC (Int)";
                break;
            }
            case 16640: {
                string = "AEAT";
                break;
            }
            case 8448: {
                string = "CCAA";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }
}

