/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.re14.datos.ecr;

import es.aeat.pare.aplicacion.Aplicacion;
import es.aeat.pare.componentes.AEATLogger;
import es.aeat.pare.re14.datos.ecr.AccesoImpresas;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.List;

public class AccesoImpresasTxt
implements AccesoImpresas {
    private static final int IMRESAS_TXT_SIZE = 24;
    private String entidad;
    private String sucursal;
    private String numeroPuesto;
    private String modelo100Impresas;
    private String modelo100Fichero;
    private String modelo100Presentadas;
    private File fImpresas;

    public AccesoImpresasTxt() {
        this.cargarValores();
    }

    private void cargarValores() {
        String string = "";
        if (Aplicacion.isEntornoIca()) {
            string = Aplicacion.getDirectorioRed();
        } else {
            string = Aplicacion.configuracion().dameEntrada("DirBDRed");
            if (string == null) {
                string = Aplicacion.configuracion().dameEntrada("DirBDLocal");
            }
            if (string == null) {
                string = "";
            }
        }
        if (!string.endsWith("/") && !string.endsWith("\\") && string.length() > 0) {
            string = string + "/";
        }
        this.fImpresas = new File(string + "impresas.txt");
        if (!this.fImpresas.exists()) {
            this.crearFicheroImpresas();
        } else {
            this.parse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(this.fImpresas);
            char[] cArray = new char[24];
            int n = fileReader.read(cArray);
            if (n != 24) {
                AEATLogger.getLogger().error((Object)("Imposible leer el fichero " + this.fImpresas));
                return;
            }
            this.entidad = Aplicacion.configuracion().dameEntrada("Entidad").trim();
            this.sucursal = Aplicacion.configuracion().dameEntrada("Sucursal").trim();
            this.numeroPuesto = Aplicacion.configuracion().dameEntrada("NumInst").trim();
            try {
                Integer.parseInt(new String(cArray, 9, 5));
                this.modelo100Impresas = new String(cArray, 9, 5);
            }
            catch (NumberFormatException numberFormatException) {
                AEATLogger.getLogger().error((Object)("fichero " + this.fImpresas + " corrupto. Se reinicia la cuenta de declaraciones impresas"));
                this.modelo100Impresas = "00000";
            }
            try {
                Integer.parseInt(new String(cArray, 14, 5));
                this.modelo100Fichero = new String(cArray, 14, 5);
            }
            catch (NumberFormatException numberFormatException) {
                AEATLogger.getLogger().error((Object)("fichero " + this.fImpresas + " corrupto. Se reinicia la cuenta de declaraciones obtenidas"));
                this.modelo100Fichero = "00000";
            }
            try {
                Integer.parseInt(new String(cArray, 19, 5));
                this.modelo100Presentadas = new String(cArray, 19, 5);
            }
            catch (NumberFormatException numberFormatException) {
                AEATLogger.getLogger().error((Object)("fichero " + this.fImpresas + " corrupto. Se reinicia la cuenta de declaraciones presentadas"));
                this.modelo100Presentadas = "00000";
            }
        }
        catch (Exception exception) {
            AEATLogger.getLogger().error((Object)("Imposible leer el fichero " + this.fImpresas), (Throwable)exception);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {
                    AEATLogger.getLogger().error((Object)("Error al intentar cerrar " + this.fImpresas), (Throwable)iOException);
                }
            }
        }
    }

    private void crearFicheroImpresas() {
        this.entidad = Aplicacion.configuracion().dameEntrada("Entidad").trim();
        this.sucursal = Aplicacion.configuracion().dameEntrada("Sucursal").trim();
        this.numeroPuesto = Aplicacion.configuracion().dameEntrada("NumInst").trim();
        this.modelo100Impresas = "00000";
        this.modelo100Fichero = "00000";
        this.modelo100Presentadas = "00000";
        this.grabarFichero();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grabarFichero() {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(this.fImpresas);
            String string = MessageFormat.format("{0,number,0000}{1,number,0000}{2,number,0}{3,number,00000}{4,number,00000}{5,number,00000}", Integer.parseInt(this.entidad), Integer.parseInt(this.sucursal), Integer.parseInt(this.numeroPuesto), Integer.parseInt(this.modelo100Impresas), Integer.parseInt(this.modelo100Fichero), Integer.parseInt(this.modelo100Presentadas));
            printWriter.write(string);
        }
        catch (Exception exception) {
            AEATLogger.getLogger().error((Object)("Imposible grabar el fichero " + this.fImpresas), (Throwable)exception);
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
            }
        }
    }

    @Override
    public String getEntidad() {
        return this.entidad;
    }

    @Override
    public String getSucursal() {
        return this.sucursal;
    }

    @Override
    public String getNumeroNumInst() {
        return this.numeroPuesto;
    }

    @Override
    public String getModelo100I() {
        return this.modelo100Impresas;
    }

    @Override
    public String getModelo100F() {
        return this.modelo100Fichero;
    }

    @Override
    public String getModelo100P() {
        return this.modelo100Presentadas;
    }

    @Override
    public void incrementaNumDeclaciones(int n) {
        switch (n) {
            case 1: 
            case 4: {
                this.incrementaImpresas();
                break;
            }
            case 3: 
            case 5: {
                this.incrementaFichero();
                break;
            }
            default: {
                if (n == 2) break;
                this.incrementaInmediata();
            }
        }
    }

    @Override
    public void incrementaImpresas() {
        this.modelo100Impresas = this.incrementa(this.modelo100Impresas);
        this.grabarFichero();
    }

    @Override
    public void incrementaInmediata() {
        this.modelo100Presentadas = this.incrementa(this.modelo100Presentadas);
        this.grabarFichero();
    }

    @Override
    public void incrementaFichero() {
        this.modelo100Fichero = this.incrementa(this.modelo100Fichero);
        this.grabarFichero();
    }

    private String incrementa(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            AEATLogger.getLogger().error((Object)"Error incrementando impresas.txt: ", (Throwable)numberFormatException);
        }
        return String.format("%05d", ++n);
    }

    @Override
    public String getModelo100Fichero_Totales() {
        return null;
    }

    @Override
    public String getModelo100Inmediata_Totales() {
        return null;
    }

    @Override
    public String getModelo100Papel_Totales() {
        return null;
    }

    @Override
    public List<String[]> getTodosLosUsuarios() {
        return null;
    }
}

