/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.re14.datos.ecr;

import es.aeat.pare.aplicacion.Aplicacion;
import es.aeat.pare.aplicacion.Constantes;
import es.aeat.pare.componentes.AEATHerramientas;
import es.aeat.pare.componentes.AEATLogger;
import es.aeat.pare.re14.datos.ecr.AccesoImpresas;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class AccesoImpresasDB
implements AccesoImpresas {
    private Connection mConection;
    private boolean tablaCreada;
    private static AccesoImpresasDB impresasDB = null;
    private static String entidad = Aplicacion.getEcrCFG().dameEntrada("Entidad");
    private static String sucursal = Aplicacion.getEcrCFG().dameEntrada("Sucursal");
    private static String numInst = Aplicacion.getEcrCFG().dameEntrada("NumInst");

    private AccesoImpresasDB() {
        this.conectar();
        this.desconectar();
    }

    public static AccesoImpresasDB getAccesoImpresasDB() {
        if (impresasDB == null) {
            impresasDB = new AccesoImpresasDB();
        }
        return impresasDB;
    }

    public final synchronized boolean conectar() {
        if (!Aplicacion.isECR()) {
            return false;
        }
        return this.conectarECR();
    }

    private synchronized boolean conectarECR() {
        String string = Aplicacion.getEcrCFG().dameEntrada("Puesto");
        if ("Multipuesto".equalsIgnoreCase(string)) {
            return this.conectarECRRed();
        }
        return this.conectarECREmbedded();
    }

    private synchronized boolean conectarECRRed() {
        String string = Aplicacion.getEcrCFG().dameEntrada("IP");
        String string2 = Aplicacion.getEcrCFG().dameEntrada("Puerto");
        String string3 = MessageFormat.format("jdbc:derby://{0}:{1}/CloudScape/Impresas;create=true", string, string2);
        AEATLogger.getLogger().info((Object)("\n------------------------------------\nRUTA DE LA BASE DE DATOS DE RED\n" + string3 + "\n--------------------------------------------\n"));
        try {
            this.mConection = DriverManager.getConnection(string3, "APP", "APP");
            if (this.mConection != null) {
                this.mConection.setTransactionIsolation(8);
                this.crearTabla();
                return true;
            }
            return false;
        }
        catch (SQLException sQLException) {
            AEATLogger.getLogger().fatal((Object)"\n---------------------------------CAUSA----------------------------------\n", (Throwable)sQLException);
            return false;
        }
    }

    private synchronized boolean conectarECREmbedded() {
        try {
            String string;
            this.mConection = null;
            if (Aplicacion.isEntornoIca()) {
                string = Aplicacion.getEcrCFG().dameEntrada(Constantes.getDirbdred());
                if (string == null) {
                    string = AEATHerramientas.obtenerDirectorioBase(this.getClass());
                }
                if (!string.endsWith("/") && !string.endsWith("\\")) {
                    string = string + "/";
                }
                string = string + "CloudScape/Impresas;create=true";
            } else {
                string = Aplicacion.getEcrCFG().dameEntrada("DirBDRed");
                if (string == null) {
                    string = Aplicacion.getEcrCFG().dameEntrada("DirBDLocal");
                }
                if (string == null) {
                    string = AEATHerramientas.obtenerDirectorioBase(this.getClass());
                }
                if (!string.endsWith("/") && !string.endsWith("\\")) {
                    string = string + "/";
                }
                string = string + "CloudScape/Impresas;create=true";
            }
            String string2 = "jdbc:derby:";
            string2 = string2 + string;
            AEATLogger.getLogger().info((Object)("\n------------------------------------\nRUTA DE LA BASE DE DATOS DE RED\n" + string2 + "\n--------------------------------------------\n"));
            this.mConection = DriverManager.getConnection(string2);
            if (this.mConection != null) {
                this.crearTabla();
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)"\n---------------------------------CAUSA----------------------------------\n", (Throwable)exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crearTabla() throws SQLException {
        if (this.tablaCreada) {
            return;
        }
        DatabaseMetaData databaseMetaData = null;
        String[] stringArray = new String[]{"TABLE"};
        databaseMetaData = this.mConection.getMetaData();
        ResultSet resultSet = databaseMetaData.getTables(null, null, null, stringArray);
        while (resultSet.next() && !this.tablaCreada) {
            if (!"IMPRESAS".equalsIgnoreCase(resultSet.getString("TABLE_NAME"))) continue;
            this.tablaCreada = true;
            return;
        }
        Statement statement = null;
        try {
            String string = "CREATE TABLE IMPRESAS (ENTIDAD VARCHAR(4) NOT NULL,SUCURSAL VARCHAR(4) NOT NULL,NUMINST VARCHAR(2) NOT NULL,USUARIO VARCHAR(100) NOT NULL,PAPEL INTEGER,FICHERO INTEGER,PRESENTADAS INTEGER)";
            statement = this.mConection.createStatement();
            if (statement.executeUpdate(string) == 0) {
                this.tablaCreada = true;
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    public void desconectar() {
        if (!Aplicacion.isECR()) {
            return;
        }
        String string = Aplicacion.getEcrCFG().dameEntrada("Puesto");
        if ("Multipuesto".equalsIgnoreCase(string)) {
            this.desconectarECRRed();
        } else {
            this.desconectarECREmbedded();
        }
    }

    private void desconectarECRRed() {
        try {
            if (this.mConection != null) {
                this.mConection.close();
            }
        }
        catch (SQLException sQLException) {
            AEATLogger.getLogger().fatal((Object)sQLException);
        }
        this.mConection = null;
    }

    private void desconectarECREmbedded() {
        block4: {
            try {
                String string = Aplicacion.getEcrCFG().dameEntrada(Constantes.getDirbdred());
                if (string == null) {
                    string = AEATHerramientas.obtenerDirectorioBase(this.getClass());
                }
                if (!string.endsWith("/") && !string.endsWith("\\")) {
                    string = string + "/";
                }
                string = string + "CloudScape/Impresas";
                String string2 = "jdbc:derby:";
                string2 = string2 + string;
                string2 = string2 + ";shutdown=true";
                AEATLogger.getLogger().info((Object)"\n------------------------------------\nDERBYDB CLOSED\n--------------------------------------------\n");
                this.mConection.close();
            }
            catch (Exception exception) {
                if (exception.getMessage().contains("shutdown")) break block4;
                AEATLogger.getLogger().fatal((Object)exception);
            }
        }
    }

    @Override
    public String getEntidad() {
        return this.dameValorPedidoString("ENTIDAD");
    }

    @Override
    public String getSucursal() {
        return this.dameValorPedidoString("SUCURSAL");
    }

    @Override
    public String getNumeroNumInst() {
        return this.dameValorPedidoString("NUMINST");
    }

    @Override
    public String getModelo100I() {
        return String.valueOf(this.dameValorPedidoInt("PAPEL"));
    }

    @Override
    public String getModelo100F() {
        return String.valueOf(this.dameValorPedidoInt("FICHERO"));
    }

    @Override
    public String getModelo100P() {
        return String.valueOf(this.dameValorPedidoInt("PRESENTADAS"));
    }

    @Override
    public void incrementaNumDeclaciones(int n) {
    }

    @Override
    public void incrementaImpresas() {
        this.conectar();
        ResultSet resultSet = null;
        int n = 0;
        try {
            this.mConection.setAutoCommit(false);
            resultSet = this.dameRegistroBDImpresas();
            if (!this.existenRegistros(resultSet)) {
                this.darDeAltaRegistroImpresas(++n, 0, 0);
            } else {
                n = resultSet.getInt("PAPEL") + 1;
                this.actualizarRegistroBD(n, 0, 0);
            }
            this.mConection.commit();
        }
        catch (SQLException sQLException) {
            try {
                this.mConection.rollback();
            }
            catch (SQLException sQLException2) {
                sQLException2.printStackTrace();
            }
            sQLException.printStackTrace();
        }
        this.desconectar();
    }

    @Override
    public void incrementaInmediata() {
        this.conectar();
        ResultSet resultSet = null;
        int n = 0;
        try {
            this.mConection.setAutoCommit(false);
            resultSet = this.dameRegistroBDImpresas();
            if (!this.existenRegistros(resultSet)) {
                this.darDeAltaRegistroImpresas(0, 0, ++n);
            } else {
                n = resultSet.getInt("PRESENTADAS") + 1;
                this.actualizarRegistroBD(0, 0, n);
            }
            this.mConection.commit();
        }
        catch (SQLException sQLException) {
            try {
                this.mConection.rollback();
            }
            catch (SQLException sQLException2) {
                sQLException2.printStackTrace();
            }
            sQLException.printStackTrace();
        }
        this.desconectar();
    }

    @Override
    public void incrementaFichero() {
        this.conectar();
        ResultSet resultSet = null;
        int n = 0;
        try {
            resultSet = this.dameRegistroBDImpresas();
            this.mConection.setAutoCommit(false);
            if (!this.existenRegistros(resultSet)) {
                this.darDeAltaRegistroImpresas(0, ++n, 0);
            } else {
                n = resultSet.getInt("FICHERO") + 1;
                this.actualizarRegistroBD(0, n, 0);
            }
            this.mConection.commit();
        }
        catch (SQLException sQLException) {
            try {
                this.mConection.rollback();
            }
            catch (SQLException sQLException2) {
                sQLException2.printStackTrace();
            }
            sQLException.printStackTrace();
        }
        this.desconectar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualizarRegistroBD(int n, int n2, int n3) {
        Statement statement = null;
        try {
            String string = System.getProperty("user.name");
            statement = this.mConection.createStatement(1004, 1008);
            String string2 = "";
            if (n > 0) {
                string2 = "UPDATE IMPRESAS SET PAPEL = " + n + " WHERE USUARIO = '" + string + "' " + "AND ENTIDAD='" + entidad + "' " + "AND SUCURSAL='" + sucursal + "' " + "AND NUMINST='" + numInst + "'";
            } else if (n2 > 0) {
                string2 = "UPDATE IMPRESAS SET FICHERO = " + n2 + " WHERE USUARIO = '" + string + "' " + "AND ENTIDAD='" + entidad + "' " + "AND SUCURSAL='" + sucursal + "' " + "AND NUMINST='" + numInst + "'";
            } else if (n3 > 0) {
                string2 = "UPDATE IMPRESAS SET PRESENTADAS = " + n3 + " WHERE USUARIO = '" + string + "' " + "AND ENTIDAD='" + entidad + "' " + "AND SUCURSAL='" + sucursal + "' " + "AND NUMINST='" + numInst + "'";
            }
            statement.execute(string2);
        }
        catch (SQLException sQLException) {
            AEATLogger.getLogger().error((Object)"", (Throwable)sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                AEATLogger.getLogger().error((Object)"", (Throwable)sQLException);
            }
        }
    }

    private boolean existenRegistros(ResultSet resultSet) {
        try {
            resultSet.first();
            resultSet.getObject(1);
            return true;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    private ResultSet dameRegistroBDImpresas() throws SQLException {
        String string = System.getProperty("user.name");
        Statement statement = this.mConection.createStatement(1004, 1008);
        String string2 = "SELECT * FROM IMPRESAS WHERE USUARIO = '" + string + "' " + "AND ENTIDAD='" + entidad + "' " + "AND SUCURSAL='" + sucursal + "' " + "AND NUMINST='" + numInst + "'";
        return statement.executeQuery(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void darDeAltaRegistroImpresas(int n, int n2, int n3) {
        Statement statement = null;
        try {
            String string = System.getProperty("user.name");
            statement = this.mConection.createStatement(1004, 1008);
            String string2 = "";
            string2 = "INSERT INTO IMPRESAS (ENTIDAD, SUCURSAL, NUMINST, USUARIO, PAPEL, FICHERO, PRESENTADAS) VALUES ('";
            string2 = string2 + entidad;
            string2 = string2 + "', '";
            string2 = string2 + sucursal;
            string2 = string2 + "', '";
            string2 = string2 + numInst;
            string2 = string2 + "', '";
            string2 = string2 + string;
            string2 = string2 + "', ";
            string2 = string2 + n;
            string2 = string2 + ", ";
            string2 = string2 + n2;
            string2 = string2 + ", ";
            string2 = string2 + n3;
            string2 = string2 + ")";
            statement.execute(string2);
        }
        catch (SQLException sQLException) {
            AEATLogger.getLogger().error((Object)"", (Throwable)sQLException);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    AEATLogger.getLogger().error((Object)"", (Throwable)sQLException);
                }
            }
        }
    }

    private String dameValorPedidoString(String string) {
        this.conectar();
        String string2 = "";
        try {
            ResultSet resultSet = this.dameRegistroBDImpresas();
            resultSet.first();
            if (this.existenRegistros(resultSet)) {
                string2 = resultSet.getString(string).toString();
            } else {
                this.darDeAltaRegistroImpresas(0, 0, 0);
                string2 = this.dameValorPedidoString(string);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.desconectar();
        return string2;
    }

    private int dameValorPedidoInt(String string) {
        this.conectar();
        int n = 0;
        try {
            ResultSet resultSet = this.dameRegistroBDImpresas();
            resultSet.first();
            if (this.existenRegistros(resultSet)) {
                n = resultSet.getInt(string);
            } else {
                this.darDeAltaRegistroImpresas(0, 0, 0);
                n = 0;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.desconectar();
        return n;
    }

    private int dameValorPedidoIntTotales(String string) {
        this.conectar();
        int n = 0;
        try {
            Statement statement = this.mConection.createStatement(1004, 1008);
            String string2 = "SELECT * FROM IMPRESAS ";
            ResultSet resultSet = statement.executeQuery(string2);
            resultSet.first();
            if (this.existenRegistros(resultSet)) {
                resultSet.first();
                while (true) {
                    n += resultSet.getInt(string);
                    if (!resultSet.isLast()) {
                        resultSet.next();
                        continue;
                    }
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.desconectar();
        return n;
    }

    @Override
    public String getModelo100Fichero_Totales() {
        return String.valueOf(this.dameValorPedidoIntTotales("FICHERO"));
    }

    @Override
    public String getModelo100Inmediata_Totales() {
        return String.valueOf(this.dameValorPedidoIntTotales("PRESENTADAS"));
    }

    @Override
    public String getModelo100Papel_Totales() {
        return String.valueOf(this.dameValorPedidoIntTotales("PAPEL"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String[]> getTodosLosUsuarios() {
        this.conectar();
        ResultSet resultSet = null;
        Statement statement = null;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        try {
            statement = this.mConection.createStatement(1004, 1008);
            String string = "SELECT * FROM IMPRESAS";
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                String[] stringArray = new String[]{resultSet.getString("USUARIO"), resultSet.getString("ENTIDAD"), resultSet.getString("SUCURSAL"), resultSet.getString("NUMINST"), resultSet.getInt("PAPEL") + "", resultSet.getInt("FICHERO") + "", resultSet.getInt("PRESENTADAS") + ""};
                arrayList.add(stringArray);
            }
        }
        catch (SQLException sQLException) {
            AEATLogger.getLogger().error((Object)"", (Throwable)sQLException);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                AEATLogger.getLogger().error((Object)"", (Throwable)sQLException);
            }
            this.desconectar();
        }
        return arrayList;
    }
}

