/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.re14.datos;

import es.aeat.pare.aplicacion.Aplicacion;
import es.aeat.pare.aplicacion.Constantes;
import es.aeat.pare.cc14.Declarantes;
import es.aeat.pare.componentes.AEATHerramientas;
import es.aeat.pare.componentes.AEATLogger;
import es.aeat.pare.re14.motor.FuncionesECR;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;

public class AccesoDec {
    private static boolean existeTablaDeclaraciones = false;
    private static boolean existeTablaDatosFisc = false;
    private Connection mConection;

    public final Connection getmConection() {
        return this.mConection;
    }

    public final void setmConection(Connection connection) {
        this.mConection = connection;
    }

    public final synchronized boolean conectar() {
        if (Aplicacion.isECR()) {
            return this.conectarECR();
        }
        return this.conectarContribuyentes();
    }

    private synchronized boolean conectarContribuyentes() {
        this.mConection = null;
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        catch (InstantiationException instantiationException) {
            AEATLogger.getLogger().fatal((Object)"\n---------------------------------CAUSA----------------------------------\n", (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            AEATLogger.getLogger().fatal((Object)"\n---------------------------------CAUSA----------------------------------\n", (Throwable)illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            AEATLogger.getLogger().fatal((Object)"\n---------------------------------CAUSA----------------------------------\n", (Throwable)classNotFoundException);
        }
        String string = Aplicacion.configuracion().dameEntrada(Constantes.getDirectorioRed());
        if (string == null) {
            string = AEATHerramientas.obtenerDirectorioBase(this.getClass());
        }
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            string = string + "/";
        }
        string = string + "CloudScape/Red";
        String string2 = "jdbc:derby:";
        string2 = string2 + string + ";create=true";
        AEATLogger.getLogger().info((Object)("\n------------------------------------\nRUTA DE LA BASE DE DATOS DE RED\n" + string + "\n--------------------------------------------\n"));
        try {
            this.mConection = DriverManager.getConnection(string2);
            if (!existeTablaDeclaraciones || !existeTablaDatosFisc) {
                this.creacionDeTablas();
            }
        }
        catch (SQLException sQLException) {
            AEATLogger.getLogger().fatal((Object)"\n---------------------------------CAUSA----------------------------------\n", sQLException.getNextException().getCause());
        }
        return this.mConection != null;
    }

    private void creacionDeTablas() {
        DatabaseMetaData databaseMetaData = null;
        String[] stringArray = new String[]{"TABLE"};
        try {
            String string;
            databaseMetaData = this.mConection.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, null, null, stringArray);
            while (!(!resultSet.next() || existeTablaDeclaraciones && existeTablaDatosFisc)) {
                if (resultSet.getString("TABLE_NAME").equalsIgnoreCase("DECLARACIONES")) {
                    existeTablaDeclaraciones = true;
                }
                if (resultSet.getString("TABLE_NAME").equalsIgnoreCase("DATOSFISC")) {
                    existeTablaDatosFisc = true;
                }
                if (!existeTablaDeclaraciones || !existeTablaDatosFisc) continue;
            }
            Statement statement = null;
            int n = -1;
            if (!existeTablaDeclaraciones) {
                string = "CREATE TABLE DECLARACIONES (TIPODEC\tINTEGER,CLAVE VARCHAR(50) NOT NULL,SUJETO\tINTEGER,DATOS CLOB(4194304),DESCRIPCION VARCHAR(512))";
                if (statement == null) {
                    statement = this.mConection.createStatement();
                }
                if ((n = statement.executeUpdate(string)) == 0) {
                    existeTablaDeclaraciones = true;
                    AEATLogger.getLogger().info((Object)"SE HA CREADO LA TABLA DECLARACIONES");
                } else {
                    AEATLogger.getLogger().fatal((Object)"Ha habido un error al crear las tablas de la base de datos");
                }
            }
            if (!existeTablaDatosFisc) {
                string = "CREATE TABLE DATOSFISC (CLAVE VARCHAR(50) NOT NULL, SUJETO\tINTEGER, DATOS_SI CLOB(1048576), DATOS_NO CLOB(1048576), AVISOS_N VARCHAR(1024),AVISOS_R VARCHAR(1024))";
                if (statement == null) {
                    statement = this.mConection.createStatement();
                }
                if ((n = statement.executeUpdate(string)) == 0) {
                    existeTablaDatosFisc = true;
                    AEATLogger.getLogger().info((Object)"SE HA CREADO LA TABLA DATOSFISC");
                } else {
                    AEATLogger.getLogger().fatal((Object)"Ha habido un error al crear las tablas de la base de datos");
                }
            }
        }
        catch (SQLException sQLException) {
            AEATLogger.getLogger().fatal((Object)sQLException);
        }
    }

    private synchronized boolean conectarECR() {
        String string = Aplicacion.getEcrCFG().dameEntrada("Puesto");
        if ("Multipuesto".equalsIgnoreCase(string)) {
            return this.conectarECRRed();
        }
        return this.conectarECREmbedded();
    }

    private synchronized boolean conectarECRRed() {
        String string = Aplicacion.getEcrCFG().dameEntrada("IP");
        String string2 = Aplicacion.getEcrCFG().dameEntrada("Puerto");
        String string3 = MessageFormat.format("jdbc:derby://{0}:{1}/CloudScape/Red", string, string2);
        AEATLogger.getLogger().info((Object)("\n------------------------------------\nRUTA DE LA BASE DE DATOS DE RED\n" + string3 + "\n--------------------------------------------\n"));
        try {
            this.mConection = DriverManager.getConnection(string3, "APP", "APP");
            return this.mConection != null;
        }
        catch (SQLException sQLException) {
            AEATLogger.getLogger().fatal((Object)"\n---------------------------------CAUSA----------------------------------\n", (Throwable)sQLException);
            return false;
        }
    }

    private synchronized boolean conectarECREmbedded() {
        try {
            String string;
            this.mConection = null;
            if (Aplicacion.isEntornoIca()) {
                string = Aplicacion.getEcrCFG().dameEntrada(Constantes.getDirbdred());
                if (string == null) {
                    string = AEATHerramientas.obtenerDirectorioBase(this.getClass());
                }
                if (!string.endsWith("/") && !string.endsWith("\\")) {
                    string = string + "/";
                }
                string = string + "CloudScape/Red";
            } else {
                string = Aplicacion.getEcrCFG().dameEntrada("DirBDRed");
                if (string == null) {
                    string = Aplicacion.getEcrCFG().dameEntrada("DirBDLocal");
                }
                if (string == null) {
                    string = AEATHerramientas.obtenerDirectorioBase(this.getClass());
                }
                if (!string.endsWith("/") && !string.endsWith("\\")) {
                    string = string + "/";
                }
                string = string + "CloudScape/Red";
            }
            String string2 = "jdbc:derby:";
            string2 = string2 + string;
            AEATLogger.getLogger().info((Object)("\n------------------------------------\nRUTA DE LA BASE DE DATOS DE RED\n" + string2 + "\n--------------------------------------------\n"));
            this.mConection = DriverManager.getConnection(string2);
            return this.mConection != null;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)"\n---------------------------------CAUSA----------------------------------\n", (Throwable)exception);
            return false;
        }
    }

    public final void desconectar() {
        if (Aplicacion.isECR()) {
            this.desconectarECR();
        } else {
            this.desconectarContribuyente();
        }
    }

    private void desconectarECR() {
        String string = Aplicacion.getEcrCFG().dameEntrada("Puesto");
        if ("Multipuesto".equalsIgnoreCase(string)) {
            this.desconectarECRRed();
        } else {
            this.desconectarECREmbedded();
        }
    }

    private void desconectarECRRed() {
        try {
            if (this.mConection != null) {
                this.mConection.close();
            }
        }
        catch (SQLException sQLException) {
            AEATLogger.getLogger().fatal((Object)sQLException);
        }
        this.mConection = null;
    }

    private void desconectarECREmbedded() {
        block4: {
            try {
                String string = Aplicacion.getEcrCFG().dameEntrada(Constantes.getDirbdred());
                if (string == null) {
                    string = AEATHerramientas.obtenerDirectorioBase(this.getClass());
                }
                if (!string.endsWith("/") && !string.endsWith("\\")) {
                    string = string + "/";
                }
                string = string + "CloudScape/Red";
                String string2 = "jdbc:derby:";
                string2 = string2 + string;
                string2 = string2 + ";shutdown=true";
                AEATLogger.getLogger().info((Object)"\n------------------------------------\nDERBYDB CLOSED\n--------------------------------------------\n");
                this.mConection.close();
            }
            catch (Exception exception) {
                if (exception.getMessage().contains("shutdown")) break block4;
                AEATLogger.getLogger().fatal((Object)exception);
            }
        }
    }

    private void desconectarContribuyente() {
        block4: {
            try {
                String string = Aplicacion.configuracion().dameEntrada(Constantes.getDirectorioRed());
                if (string == null) {
                    string = AEATHerramientas.obtenerDirectorioBase(this.getClass());
                }
                if (!string.endsWith("/") && !string.endsWith("\\")) {
                    string = string + "/";
                }
                string = string + "CloudScape/Red";
                String string2 = "jdbc:derby:";
                string2 = string2 + string;
                string2 = string2 + ";shutdown=true";
                AEATLogger.getLogger().info((Object)"\n------------------------------------\nDERBYDB CLOSED\n--------------------------------------------\n");
                this.mConection.close();
            }
            catch (Exception exception) {
                if (exception.getMessage().contains("shutdown")) break block4;
                AEATLogger.getLogger().fatal((Object)exception);
            }
        }
    }

    public final ResultSet dameListaDeclaraciones(String string) {
        try {
            ResultSet resultSet = null;
            Statement statement = null;
            statement = Aplicacion.isECR() && "Multipuesto".equalsIgnoreCase(Aplicacion.getEcrCFG().dameEntrada("Puesto")) ? this.mConection.createStatement() : this.mConection.createStatement(1004, 1008);
            String string2 = "SELECT * FROM DECLARACIONES";
            if (!"".equals(string)) {
                string2 = string2 + " WHERE TIPODEC = ";
                string2 = string2 + string;
            }
            string2 = string2 + " ORDER BY CLAVE";
            resultSet = statement.executeQuery(string2);
            return resultSet;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            return null;
        }
    }

    public final boolean nuevaDeclaracion(String string, String string2) {
        try {
            boolean bl = false;
            Statement statement = this.mConection.createStatement(1004, 1008);
            String string3 = "INSERT INTO DECLARACIONES (CLAVE, TIPODEC) VALUES ('";
            string3 = string3 + string.replaceAll("'", "''");
            string3 = string3 + "', ";
            string3 = string3 + string2;
            string3 = string3 + ")";
            bl = statement.execute(string3);
            return true;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            return false;
        }
    }

    public final boolean eliminaDeclaracion(String string) {
        try {
            boolean bl = false;
            Statement statement = this.mConection.createStatement(1004, 1008);
            String string2 = "DELETE FROM DECLARACIONES WHERE CLAVE = '";
            string2 = string2 + string.replaceAll("'", "''");
            string2 = string2 + "'";
            bl = statement.execute(string2);
            string2 = "DELETE FROM DATOSFISC WHERE CLAVE = '";
            string2 = string2 + string.replaceAll("'", "''");
            string2 = string2 + "'";
            bl = statement.execute(string2);
            return true;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            return false;
        }
    }

    public final boolean renombraDeclaracion(String string, String string2) {
        try {
            boolean bl = false;
            Statement statement = this.mConection.createStatement(1004, 1008);
            String string3 = "UPDATE DECLARACIONES SET CLAVE = '";
            string3 = string3 + string2.replaceAll("'", "''");
            string3 = string3 + "' WHERE CLAVE = '";
            string3 = string3 + string.replaceAll("'", "''");
            string3 = string3 + "'";
            bl = statement.execute(string3);
            string3 = "UPDATE DATOSFISC SET CLAVE = '";
            string3 = string3 + string2.replaceAll("'", "''");
            string3 = string3 + "' WHERE CLAVE = '";
            string3 = string3 + string.replaceAll("'", "''");
            string3 = string3 + "'";
            bl = statement.execute(string3);
            return bl;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            return false;
        }
    }

    public final int duplicarDeclaracion(String string) {
        try {
            ResultSet resultSet = this.dameDeclaracion(string);
            resultSet.next();
            String string2 = resultSet.getString("TIPODEC");
            String string3 = resultSet.getString("DATOS");
            String string4 = resultSet.getString("DESCRIPCION");
            String string5 = "COPIA DE " + string;
            int n = 0;
            if (string5.length() > 50) {
                n = 2;
            } else {
                ResultSet resultSet2 = this.dameDeclaracion(string5);
                if (resultSet2.next()) {
                    n = 1;
                }
                if (n == 0) {
                    String string6 = "";
                    String string7 = string3 == null ? "(CLAVE, DESCRIPCION, TIPODEC)" : "(CLAVE, DESCRIPCION, TIPODEC, DATOS)";
                    if (string3 != null) {
                        string6 = ",?";
                    }
                    PreparedStatement preparedStatement = this.mConection.prepareStatement("INSERT INTO DECLARACIONES " + string7 + " VALUES (?,?,?" + string6 + ")");
                    preparedStatement.setString(1, string5);
                    preparedStatement.setString(2, string4);
                    preparedStatement.setString(3, string2);
                    if (string3 != null) {
                        StringReader stringReader = new StringReader(string3);
                        preparedStatement.setCharacterStream(4, (Reader)stringReader, string3.length());
                    }
                    preparedStatement.execute();
                    this.duplicarDeclaracionDF(string);
                }
            }
            return n;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            return -1;
        }
    }

    public final boolean duplicarDeclaracionDF(String string) {
        try {
            ResultSet resultSet = this.dameDeclaracionDF(string);
            while (resultSet.next()) {
                StringReader stringReader;
                String string2 = resultSet.getString("SUJETO");
                int n = Integer.parseInt(string2);
                String string3 = resultSet.getString("DATOS_SI");
                String string4 = resultSet.getString("DATOS_NO");
                String string5 = resultSet.getString("AVISOS_N");
                String string6 = resultSet.getString("AVISOS_R");
                String string7 = "COPIA DE " + string;
                String string8 = "CLAVE, SUJETO";
                String string9 = "";
                if (string3 != null) {
                    string8 = string8 + ", DATOS_SI";
                    string9 = string9 + ",?";
                }
                if (string4 != null) {
                    string8 = string8 + ", DATOS_NO";
                    string9 = string9 + ",?";
                }
                if (string5 != null) {
                    string8 = string8 + ", AVISOS_N";
                    string9 = string9 + ",?";
                }
                if (string6 != null) {
                    string8 = string8 + ", AVISOS_R";
                    string9 = string9 + ",?";
                }
                PreparedStatement preparedStatement = this.mConection.prepareStatement("INSERT INTO DATOSFISC (" + string8 + ") VALUES (?,?" + string9 + ")");
                preparedStatement.setString(1, string7);
                preparedStatement.setInt(2, n);
                int n2 = 2;
                if (string3 != null) {
                    stringReader = new StringReader(string3);
                    preparedStatement.setCharacterStream(++n2, (Reader)stringReader, string3.length());
                }
                if (string4 != null) {
                    stringReader = new StringReader(string4);
                    preparedStatement.setCharacterStream(++n2, (Reader)stringReader, string4.length());
                }
                if (string5 != null) {
                    stringReader = new StringReader(string5);
                    preparedStatement.setCharacterStream(++n2, (Reader)stringReader, string5.length());
                }
                if (string6 != null) {
                    stringReader = new StringReader(string6);
                    preparedStatement.setCharacterStream(++n2, (Reader)stringReader, string6.length());
                }
                preparedStatement.execute();
            }
            return true;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            return false;
        }
    }

    public static final String dameClaveNuevaECR() {
        String string = "";
        try {
            long l = 0L;
            long l2 = 0L;
            AccesoDec accesoDec = new AccesoDec();
            accesoDec.conectar();
            ResultSet resultSet = accesoDec.dameTablaECR("");
            if (resultSet != null) {
                resultSet.first();
                l2 = resultSet.getInt("DECLARACION_ECR_ECR");
            }
            l = FuncionesECR.indiceDiaCampanya();
            accesoDec.actualizarECR(l, ++l2);
            Aplicacion.setDiaECR((int)l);
            Aplicacion.setOrdenECR(String.format("%04d", l2));
            string = String.format("%02d%04d", l, l2);
            return string;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().info((Object)exception);
            return "";
        }
    }

    public final boolean impresionRestoDatos(String string, String string2) {
        this.conectar();
        boolean bl = false;
        try {
            PreparedStatement preparedStatement = this.mConection.prepareStatement("UPDATE DECLARACIONES SET TIPO_ECR =? Where CLAVE =? ");
            preparedStatement.setString(2, string);
            preparedStatement.setString(1, string2);
            bl = preparedStatement.execute();
            this.desconectar();
            return bl;
        }
        catch (SQLException sQLException) {
            AEATLogger.getLogger().fatal((Object)sQLException);
            return false;
        }
    }

    public final boolean impresionDuplicadoDF(String string, String string2) {
        this.conectar();
        ResultSet resultSet = this.dameDeclaracionDF(string);
        try {
            while (resultSet.next()) {
                StringReader stringReader;
                String string3 = resultSet.getString("SUJETO");
                int n = Integer.parseInt(string3);
                String string4 = resultSet.getString("DATOS_SI");
                String string5 = resultSet.getString("DATOS_NO");
                String string6 = resultSet.getString("AVISOS_N");
                String string7 = resultSet.getString("AVISOS_R");
                String string8 = "CLAVE, SUJETO";
                String string9 = "";
                if (string4 != null) {
                    string8 = string8 + ", DATOS_SI";
                    string9 = string9 + ",?";
                }
                if (string5 != null) {
                    string8 = string8 + ", DATOS_NO";
                    string9 = string9 + ",?";
                }
                if (string6 != null) {
                    string6 = string6 + ", AVISOS_N";
                    string9 = string9 + ",?";
                }
                if (string7 != null) {
                    string7 = string7 + ", AVISOS_R";
                    string9 = string9 + ",?";
                }
                PreparedStatement preparedStatement = this.mConection.prepareStatement("INSERT INTO DATOSFISC (" + string8 + ") VALUES (?,?" + string9 + ")");
                preparedStatement.setString(1, string2);
                preparedStatement.setInt(2, n);
                int n2 = 2;
                if (string4 != null) {
                    stringReader = new StringReader(string4);
                    preparedStatement.setCharacterStream(++n2, (Reader)stringReader, string4.length());
                }
                if (string5 != null) {
                    stringReader = new StringReader(string5);
                    preparedStatement.setCharacterStream(++n2, (Reader)stringReader, string5.length());
                }
                if (string6 != null) {
                    stringReader = new StringReader(string6);
                    preparedStatement.setCharacterStream(++n2, (Reader)stringReader, string6.length());
                }
                if (string7 != null) {
                    stringReader = new StringReader(string7);
                    preparedStatement.setCharacterStream(++n2, (Reader)stringReader, string7.length());
                }
                preparedStatement.execute();
            }
        }
        catch (Exception exception) {
            return false;
        }
        this.desconectar();
        return true;
    }

    public final boolean duplicarDeclaracionDFECR(String string) {
        try {
            ResultSet resultSet = this.dameDeclaracionDF(string);
            String string2 = "";
            while (resultSet.next()) {
                Object object;
                String string3 = resultSet.getString("SUJETO");
                int n = Integer.parseInt(string3);
                String string4 = resultSet.getString("DATOS_SI");
                String string5 = resultSet.getString("DATOS_NO");
                String string6 = resultSet.getString("AVISOS_N");
                String string7 = resultSet.getString("AVISOS_R");
                try {
                    long l = 0L;
                    long l2 = 0L;
                    object = new AccesoDec();
                    ((AccesoDec)object).conectar();
                    ResultSet resultSet2 = ((AccesoDec)object).dameTablaECR("");
                    if (resultSet2 != null) {
                        resultSet2.first();
                        l2 = resultSet2.getInt("DECLARACION_ECR_ECR");
                    }
                    l = FuncionesECR.indiceDiaCampanya();
                    ((AccesoDec)object).actualizarECR(l, ++l2);
                    Aplicacion.setDiaECR((int)l);
                    Aplicacion.setOrdenECR(String.format("%04d", l2));
                    string2 = String.format("%02d%04d", l, l2);
                }
                catch (Exception exception) {
                    AEATLogger.getLogger().info((Object)exception);
                }
                String string8 = "CLAVE, SUJETO";
                String string9 = "";
                if (string4 != null) {
                    string8 = string8 + ", DATOS_SI";
                    string9 = string9 + ",?";
                }
                if (string5 != null) {
                    string8 = string8 + ", DATOS_NO";
                    string9 = string9 + ",?";
                }
                if (string6 != null) {
                    string8 = string8 + ", AVISOS_N";
                    string9 = string9 + ",?";
                }
                if (string7 != null) {
                    string8 = string8 + ", AVISOS_R";
                    string9 = string9 + ",?";
                }
                PreparedStatement preparedStatement = this.mConection.prepareStatement("INSERT INTO DATOSFISC (" + string8 + ") VALUES (?,?" + string9 + ")");
                if (string2.equals("")) {
                    return false;
                }
                preparedStatement.setString(1, string2);
                preparedStatement.setInt(2, n);
                int n2 = 2;
                if (string4 != null) {
                    object = new StringReader(string4);
                    preparedStatement.setCharacterStream(++n2, (Reader)object, string4.length());
                }
                if (string5 != null) {
                    object = new StringReader(string5);
                    preparedStatement.setCharacterStream(++n2, (Reader)object, string5.length());
                }
                if (string6 != null) {
                    object = new StringReader(string6);
                    preparedStatement.setCharacterStream(++n2, (Reader)object, string6.length());
                }
                if (string7 != null) {
                    object = new StringReader(string7);
                    preparedStatement.setCharacterStream(++n2, (Reader)object, string7.length());
                }
                preparedStatement.execute();
            }
            return true;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            return false;
        }
    }

    public final ResultSet dameDeclaracion(String string) {
        try {
            ResultSet resultSet = null;
            Statement statement = this.mConection.createStatement(1004, 1008);
            String string2 = "SELECT * FROM DECLARACIONES WHERE CLAVE = '";
            String string3 = string.trim().replaceAll("'", "''");
            string2 = string2 + string3;
            string2 = string2 + "'";
            resultSet = statement.executeQuery(string2);
            return resultSet;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            return null;
        }
    }

    public final ResultSet dameResultSetDatosFiscales(String string, Declarantes declarantes) throws ExceptionMotor {
        String string2 = String.valueOf(declarantes.toInt());
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.mConection.createStatement(1004, 1008);
            String string3 = "SELECT * FROM DATOSFISC WHERE CLAVE = '" + string + "' AND SUJETO = " + string2;
            resultSet = statement.executeQuery(string3);
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            return null;
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dameResultSetDatosFiscales(String string, Declarantes declarantes, boolean bl) throws ExceptionMotor {
        String string2 = String.valueOf(declarantes.toInt());
        boolean bl2 = false;
        Statement statement = null;
        ResultSet resultSet = null;
        if (!"".equalsIgnoreCase(string2)) {
            try {
                statement = this.mConection.createStatement(1004, 1008);
                String string3 = "SELECT * FROM DATOSFISC WHERE CLAVE = '" + string + "' AND SUJETO = " + string2;
                resultSet = statement.executeQuery(string3);
                if (resultSet.first()) {
                    if (bl && resultSet.getString("DATOS_SI") == null) {
                        bl2 = false;
                    } else if (bl && resultSet.getString("DATOS_SI") != null) {
                        bl2 = true;
                    } else if (!bl && resultSet.getString("DATOS_NO") == null) {
                        bl2 = false;
                    } else if (!bl && resultSet.getString("DATOS_NO") != null) {
                        bl2 = true;
                    }
                }
            }
            catch (Exception exception) {
                AEATLogger.getLogger().fatal((Object)exception);
                bl2 = false;
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        AEATLogger.getLogger().fatal((Object)sQLException);
                    }
                    statement = null;
                }
            }
        }
        return bl2;
    }

    public final ResultSet dameDeclaracionDF(String string) {
        try {
            ResultSet resultSet = null;
            Statement statement = this.mConection.createStatement(1004, 1008);
            String string2 = "SELECT * FROM DATOSFISC WHERE CLAVE = '";
            String string3 = string.trim().replaceAll("'", "''");
            string2 = string2 + string3;
            string2 = string2 + "'";
            resultSet = statement.executeQuery(string2);
            return resultSet;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hayAvisosDatosFiscales(String string, Declarantes declarantes) throws ExceptionMotor {
        String string2 = String.valueOf(declarantes.toInt());
        boolean bl = false;
        Statement statement = null;
        ResultSet resultSet = null;
        if (!"".equalsIgnoreCase(string2)) {
            try {
                statement = this.mConection.createStatement(1004, 1008);
                String string3 = "SELECT * FROM DATOSFISC WHERE CLAVE = '" + string + "' AND SUJETO = " + string2;
                resultSet = statement.executeQuery(string3);
                if (resultSet.first() && (resultSet.getString("AVISOS_N") != null || resultSet.getString("AVISOS_R") != null)) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                AEATLogger.getLogger().fatal((Object)exception);
                bl = false;
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        AEATLogger.getLogger().fatal((Object)sQLException);
                    }
                    statement = null;
                }
            }
        }
        return bl;
    }

    public final boolean actualizarDeclaracion(String string, String string2, String string3) {
        try {
            this.conectar();
            boolean bl = false;
            boolean bl2 = false;
            StringReader stringReader = new StringReader(string2);
            if (string3 == null) {
                string3 = "";
            }
            PreparedStatement preparedStatement = this.mConection.prepareStatement("UPDATE DECLARACIONES SET DATOS =?, DESCRIPCION = ? Where CLAVE =? ");
            preparedStatement.setCharacterStream(1, (Reader)stringReader, string2.length());
            preparedStatement.setString(2, string3);
            preparedStatement.setString(3, string);
            bl = preparedStatement.execute();
            preparedStatement = this.mConection.prepareCall("CALL SYSCS_UTIL.SYSCS_CHECKPOINT_DATABASE()");
            bl2 = preparedStatement.execute();
            return bl && bl2;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            return false;
        }
    }

    public final boolean actualizarDescripcion(String string, String string2) {
        try {
            boolean bl = false;
            Statement statement = this.mConection.createStatement(1004, 1008);
            String string3 = "UPDATE DECLARACIONES SET DESCRIPCION = '";
            string3 = string3 + string2;
            string3 = string3 + "' WHERE CLAVE = '";
            string3 = string3 + string.replaceAll("'", "''");
            string3 = string3 + "'";
            bl = statement.execute(string3);
            return bl;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            return false;
        }
    }

    public final boolean actualizarModelo(String string, String string2, String string3) {
        try {
            int n = Integer.parseInt(string2);
            boolean bl = false;
            Statement statement = this.mConection.createStatement(1004, 1008);
            String string4 = "UPDATE DECLARACIONES SET TIPODEC = ";
            string4 = string4 + n;
            string4 = string4 + ", DESCRIPCION = '";
            string4 = string4 + string3;
            string4 = string4 + "' WHERE CLAVE = '";
            string4 = string4 + string.replaceAll("'", "''");
            string4 = string4 + "'";
            bl = statement.execute(string4);
            return bl;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            return false;
        }
    }

    public final boolean actualizarDeclaracionesECR(String string, String string2, long l, long l2) {
        try {
            boolean bl = false;
            Statement statement = this.mConection.createStatement(1004, 1008);
            String string3 = "UPDATE DECLARACIONES SET FECHA_ECR = '";
            string3 = string3 + string2;
            string3 = string3 + "', DIA_ECR = ";
            string3 = string3 + l;
            string3 = string3 + ", DECLARACION_ECR = ";
            string3 = string3 + l2;
            string3 = string3 + " WHERE CLAVE = '";
            string3 = string3 + string.replaceAll("'", "''");
            string3 = string3 + "'";
            bl = statement.execute(string3);
            return bl;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean actualizarDeclaracionesECR(String string, String string2, Object object) {
        Statement statement = null;
        try {
            statement = this.mConection.createStatement();
            String string3 = "UPDATE DECLARACIONES SET " + string2 + " = ";
            if (object instanceof String) {
                string3 = string3 + "'";
            }
            string3 = string3 + object;
            if (object instanceof String) {
                string3 = string3 + "'";
            }
            string3 = string3 + " WHERE CLAVE='" + string.replaceAll("'", "''") + "'";
            statement.executeUpdate(string3);
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            boolean bl = false;
            return bl;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    AEATLogger.getLogger().fatal((Object)sQLException);
                }
                statement = null;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String obtenerDeclaracionesECR(String string, String string2) {
        Statement statement = null;
        ResultSet resultSet = null;
        String string3 = null;
        this.conectar();
        try {
            statement = this.mConection.createStatement();
            String string4 = "SELECT " + string2 + " FROM DECLARACIONES ";
            string4 = string4 + " WHERE CLAVE='" + string.replaceAll("'", "''") + "'";
            resultSet = statement.executeQuery(string4);
            resultSet.next();
            string3 = resultSet.getString(1);
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            String string5 = null;
            return string5;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    AEATLogger.getLogger().fatal((Object)sQLException);
                    string3 = null;
                }
                statement = null;
            }
        }
        this.desconectar();
        return string3;
    }

    public final boolean actualizarECR(long l, long l2) {
        try {
            boolean bl = false;
            Statement statement = this.mConection.createStatement(1004, 1008);
            String string = "UPDATE ECR SET DIA_ECR_ECR = ";
            string = string + l;
            string = string + ", DECLARACION_ECR_ECR = ";
            string = string + l2;
            bl = statement.execute(string);
            return bl;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            return false;
        }
    }

    public final ResultSet dameTablaECR(String string) {
        try {
            ResultSet resultSet = null;
            Statement statement = null;
            statement = Aplicacion.isECR() && "Multipuesto".equalsIgnoreCase(Aplicacion.getEcrCFG().dameEntrada("Puesto")) ? this.mConection.createStatement(1004, 1007) : this.mConection.createStatement(1004, 1008);
            String string2 = "SELECT * FROM ECR";
            resultSet = statement.executeQuery(string2);
            return resultSet;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            return null;
        }
    }

    public final boolean actualizarDF(String string, int n, String string2, String string3, String string4, String string5) {
        try {
            StringReader stringReader;
            String string6 = "CLAVE, SUJETO";
            String string7 = "";
            if (string2 != null) {
                string6 = string6 + ", DATOS_SI";
                string7 = string7 + ",?";
            }
            if (string3 != null) {
                string6 = string6 + ", DATOS_NO";
                string7 = string7 + ",?";
            }
            if (string4 != null) {
                string6 = string6 + ", AVISOS_N";
                string7 = string7 + ",?";
            }
            if (string4 != null) {
                string6 = string6 + ", AVISOS_R";
                string7 = string7 + ",?";
            }
            PreparedStatement preparedStatement = this.mConection.prepareStatement("INSERT INTO DATOSFISC (" + string6 + ") VALUES (?,?" + string7 + ")");
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            int n2 = 2;
            if (string2 != null) {
                stringReader = new StringReader(string2);
                preparedStatement.setCharacterStream(++n2, (Reader)stringReader, string2.length());
            }
            if (string3 != null) {
                stringReader = new StringReader(string3);
                preparedStatement.setCharacterStream(++n2, (Reader)stringReader, string3.length());
            }
            if (string4 != null) {
                stringReader = new StringReader(string4);
                preparedStatement.setCharacterStream(++n2, (Reader)stringReader, string4.length());
            }
            if (string5 != null) {
                stringReader = new StringReader(string5);
                preparedStatement.setCharacterStream(++n2, (Reader)stringReader, string5.length());
            }
            preparedStatement.execute();
            return true;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            return false;
        }
    }

    public boolean actualizarNIFECR(String string, String string2) {
        if (!Aplicacion.isECR()) {
            return true;
        }
        AEATLogger.getLogger().info((Object)("CLAVE: " + string2));
        AEATLogger.getLogger().info((Object)("NIF: " + string));
        try {
            boolean bl = false;
            Statement statement = this.mConection.createStatement(1004, 1008);
            String string3 = "UPDATE DECLARACIONES SET NIF = '";
            string3 = string3 + string + "' " + "WHERE CLAVE='" + string2 + "'";
            bl = statement.executeUpdate(string3) != 0;
            return bl;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            return false;
        }
    }
}

