/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.re14;

import es.aeat.pare.aplicacion.Aplicacion;
import es.aeat.pare.aplicacion.Constantes;
import es.aeat.pare.componentes.AEATHerramientas;
import es.aeat.pare.componentes.AEATLogger;
import es.aeat.pare.componentes.JMensajesProperties;
import es.aeat.pare.re14.AEAT100j;
import es.aeat.pare.re14.ICambioListaDeclaraciones;
import es.aeat.pare.re14.ICambioListaDeclaracionesRecientes;
import es.aeat.pare.re14.datos.AccesoDec;
import es.aeat.pare.re14.gui.JPanelVacio;
import es.aeat.pare.re14.motor.FuncionesECR;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.imp.utilidades.FuncionesUtiles;
import java.awt.Component;
import java.awt.EventQueue;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.w3c.dom.Document;

public class Declaraciones {
    private static AccesoDec mDatRed = new AccesoDec();
    private static Vector<TablaFila> declaraciones;
    private static Vector<ICambioListaDeclaraciones> listaListener;
    private static JMensajesProperties dialogoSeleccionar;
    private static Vector<String> declaracionesRecientes;
    private static Vector<ICambioListaDeclaracionesRecientes> listaListenerRecientes;
    private static final int numeroDeclaracionesRecientes = 5;
    private static Vector<String> listaDeclaraciones;

    public static Document obtenerDocumentosDOM(TablaFila tablaFila) {
        try {
            if (tablaFila.getDocumento() != null) {
                String string = tablaFila.getDocumento();
                if (string == null || string.equals("")) {
                    string = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?><DECLARACIONES><IRPF" + Constantes.getEjercicioString() + "></IRPF" + Constantes.getEjercicioString() + "></DECLARACIONES>";
                } else if (!string.startsWith("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>")) {
                    string = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>" + string;
                }
                Document document = AEATHerramientas.documento(string);
                Aplicacion.setmClaveDec(tablaFila.getClave());
                return document;
            }
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
        }
        return null;
    }

    protected static void obtenerDocumentoString(TablaFila tablaFila) {
        mDatRed.conectar();
        try {
            ResultSet resultSet = mDatRed.dameDeclaracion(tablaFila.getClave());
            if (resultSet != null) {
                resultSet.next();
                String string = resultSet.getString("DATOS");
                if (string == null || string.equals("")) {
                    string = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?><DECLARACIONES><IRPF" + Constantes.getEjercicioString() + "></IRPF" + Constantes.getEjercicioString() + "></DECLARACIONES>";
                }
                mDatRed.desconectar();
                tablaFila.setDocumento(string);
            }
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
        }
    }

    private static void cargaTablaDeclaraciones() {
        declaraciones = new Vector();
        try {
            mDatRed.conectar();
            ResultSet resultSet = mDatRed.dameListaDeclaraciones("");
            int n = 0;
            while (resultSet.next()) {
                TablaFila tablaFila = new TablaFila();
                String string = resultSet.getString("TIPODEC");
                tablaFila.setOrdenDeclaracion("" + (n + 1));
                if (!Aplicacion.isECR()) {
                    tablaFila.setClave(resultSet.getString("CLAVE"));
                    tablaFila.setDescripcion("" + resultSet.getString("DESCRIPCION"));
                    tablaFila.setDocumento(resultSet.getString("DATOS"));
                    tablaFila.setModelo("" + string);
                } else {
                    tablaFila.setDiaECR(resultSet.getInt("DIA_ECR"));
                    tablaFila.setDeclaracionECR(Declaraciones.formato(resultSet.getInt("DECLARACION_ECR")));
                    tablaFila.setNifECR(resultSet.getString("NIF") != null ? resultSet.getString("NIF") : "");
                    tablaFila.setFechaECR(resultSet.getString("FECHA_ECR") != null ? resultSet.getString("FECHA_ECR") : "");
                    tablaFila.setTipoECR(resultSet.getString("TIPO_ECR") != null ? resultSet.getString("TIPO_ECR") : "");
                    tablaFila.setConjECR(resultSet.getString("CONJ_ECR") != null ? resultSet.getString("CONJ_ECR") : "");
                    tablaFila.setDeclECR(resultSet.getString("DECL_ECR") != null ? resultSet.getString("DECL_ECR") : "");
                    tablaFila.setConyECR(resultSet.getString("CONY_ECR") != null ? resultSet.getString("CONY_ECR") : "");
                    tablaFila.setHijo1ECR(resultSet.getString("HIJO1_ECR") != null ? resultSet.getString("HIJO1_ECR") : "");
                    tablaFila.setHijo2ECR(resultSet.getString("HIJO2_ECR") != null ? resultSet.getString("HIJO2_ECR") : "");
                    tablaFila.setHijo3ECR(resultSet.getString("HIJO3_ECR") != null ? resultSet.getString("HIJO3_ECR") : "");
                    tablaFila.setHijo4ECR(resultSet.getString("HIJO4_ECR") != null ? resultSet.getString("HIJO4_ECR") : "");
                    tablaFila.setModECR("IRPF");
                    tablaFila.setClave(resultSet.getString("CLAVE"));
                    tablaFila.setModelo("" + string);
                    tablaFila.setDescripcion("" + resultSet.getString("DESCRIPCION"));
                    tablaFila.setDocumento(resultSet.getString("DATOS"));
                }
                declaraciones.add(tablaFila);
                ++n;
            }
            resultSet.close();
            mDatRed.desconectar();
            Declaraciones.firelistener();
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            mDatRed.desconectar();
        }
    }

    private static String formato(int n) {
        return String.format("%04d", n);
    }

    public static Vector<TablaFila> getDeclaraciones() {
        if (declaraciones == null) {
            Declaraciones.cargaTablaDeclaraciones();
        }
        return declaraciones;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean altaDeclaracion(String string, boolean bl) throws Exception {
        block15: {
            TablaFila tablaFila = null;
            try {
                if (!Aplicacion.isECR()) {
                    if (Declaraciones.getDeclaraciones().size() >= Constantes.getNumeroMaximoDeclaraciones()) {
                        JMensajesProperties jMensajesProperties = new JMensajesProperties("MAS50", 11);
                        jMensajesProperties.muestraMensaje();
                        return false;
                    }
                } else {
                    string = "";
                    Aplicacion.setNifECR("");
                    throw new NoExisteDeclaracionException();
                }
                tablaFila = Declaraciones.encontrarDeclaracion(string);
            }
            catch (NoExisteDeclaracionException noExisteDeclaracionException) {
                Object object;
                tablaFila = new TablaFila();
                tablaFila.setClave(string);
                tablaFila.setEstadoAlta(true);
                if (Aplicacion.isECR() && string.length() == 0) {
                    string = "ISECR";
                }
                if (!mDatRed.conectar() || string.trim().equals("")) break block15;
                long l = 0L;
                long l2 = 0L;
                if (Aplicacion.isECR()) {
                    try {
                        object = mDatRed.dameTablaECR("");
                        if (object != null) {
                            object.first();
                            l = object.getInt("DIA_ECR_ECR");
                            l2 = object.getInt("DECLARACION_ECR_ECR");
                        }
                        l = FuncionesECR.indiceDiaCampanya();
                        mDatRed.actualizarECR(l, ++l2);
                        Aplicacion.setDiaECR((int)l);
                        Aplicacion.setOrdenECR(String.format("%04d", l2));
                        string = String.format("%02d%04d", l, l2);
                        tablaFila.setClave(string);
                    }
                    catch (Exception exception) {
                        AEATLogger.getLogger().info((Object)exception);
                    }
                }
                if (!mDatRed.nuevaDeclaracion(string, Constantes.getModelo())) break block15;
                if (Aplicacion.isECR()) {
                    object = FuncionesECR.dameFechaSistema();
                    mDatRed.actualizarDeclaracionesECR(string, (String)object, l, l2);
                }
                Declaraciones.actualizarLista();
                tablaFila.setEstadoAlta(true);
                if (bl) {
                    Aplicacion.getmPanelBotones().setVisible(true);
                    Aplicacion.getmScroll().setViewportView(new JPanelVacio());
                    AEAT100j.setDeclaracionAbierta(tablaFila);
                    AEAT100j.setSalida(1);
                    object = new JPanel();
                    ((Component)object).setName("PanelBarra");
                    Aplicacion.getmPanelBotones().activarBotones();
                    Aplicacion.getmPanelBotones().ocultarBotones(false, false);
                    Aplicacion.getmPanelBotones().habilitarBotones(0);
                    Aplicacion.getmPanelBotones().getjButtonSiguiente().setIcon(new ImageIcon(AEAT100j.getFrame().getClass().getResource(Aplicacion.DIRECTORIO_IMAGES + "play.png")));
                    Aplicacion.getmScroll().setViewportView((Component)object);
                    Aplicacion.getmPanelBotones().setVisible(true);
                    Object object2 = AEAT100j.getLockhilo1();
                    synchronized (object2) {
                        AEAT100j.getLockhilo1().notify();
                    }
                }
                Declaraciones.listaDeclaracionRecienteAlta(string);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void impresionDuplicado(String string, String string2) {
        try {
            if (mDatRed.conectar() && mDatRed.nuevaDeclaracion(string, Constantes.getModelo())) {
                if (Aplicacion.isECR()) {
                    String string3 = FuncionesECR.dameFechaSistema();
                    mDatRed.actualizarDeclaracionesECR(string, string3, Aplicacion.getDiaECR(), Long.parseLong(Aplicacion.getOrdenECR()));
                    Declaraciones.actualizarLista();
                }
                Declaraciones.actualizarLista();
            }
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
        }
        finally {
            mDatRed.desconectar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int buscarDeclaracion(String string, String string2, String string3) throws NoExisteDeclaracionException {
        Vector<TablaFila> vector = Declaraciones.getDeclaraciones();
        int n = 0;
        int n2 = vector.size();
        mDatRed.conectar();
        Connection connection = mDatRed.getmConection();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            String string4 = "SELECT CLAVE FROM DECLARACIONES WHERE";
            if (!"".equals(string3)) {
                if (!string4.endsWith("WHERE")) {
                    string4 = string4 + " AND";
                }
                string4 = string4 + " NIF='" + string3 + "'";
            }
            if (!"".equals(string)) {
                if (!string4.endsWith("WHERE")) {
                    string4 = string4 + " AND";
                }
                string4 = string4 + " DIA_ECR=" + Integer.parseInt(string);
            }
            if (!"".equals(string2)) {
                if (!string4.endsWith("WHERE")) {
                    string4 = string4 + " AND";
                }
                string4 = string4 + " DECLARACION_ECR=" + Integer.parseInt(string2);
            }
            if ((resultSet = statement.executeQuery(string4)).next()) {
                String string5 = resultSet.getString("CLAVE");
                for (n = 0; n < n2; ++n) {
                    TablaFila tablaFila = (TablaFila)vector.get(n);
                    String string6 = tablaFila.getClave();
                    if (!string6.equals(string5)) continue;
                    int n3 = n;
                    return n3;
                }
            }
        }
        catch (SQLException sQLException) {
            AEATLogger.getLogger().warn((Object)sQLException);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            mDatRed.desconectar();
        }
        return -1;
    }

    public static TablaFila encontrarDeclaracion(String string) throws NoExisteDeclaracionException {
        TablaFila tablaFila;
        Vector<TablaFila> vector = Declaraciones.getDeclaraciones();
        TablaFila tablaFila2 = null;
        Iterator<TablaFila> iterator = vector.iterator();
        while (iterator.hasNext() && !(tablaFila2 = (tablaFila = iterator.next())).getClave().equals(string)) {
            tablaFila2 = null;
        }
        if (tablaFila2 == null) {
            throw new NoExisteDeclaracionException();
        }
        return tablaFila2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void abrirDeclaracion(String string) throws Exception {
        TablaFila tablaFila = Declaraciones.encontrarDeclaracion(string);
        if (tablaFila != null) {
            Aplicacion.getmScroll().setViewportView(new JPanelVacio());
            tablaFila.setEstadoAbierta();
            AEAT100j.setDeclaracionAbierta(tablaFila);
            AEAT100j.setSalida(1);
            Declaraciones.listaDeclaracionRecienteAbrir(string);
            JPanel jPanel = new JPanel();
            jPanel.setName("PanelBarra");
            Aplicacion.getmScroll().setViewportView(jPanel);
            Aplicacion.getmPanelBotones().activarBotones();
            Aplicacion.getmPanelBotones().setVisible(true);
            if (Aplicacion.isECR()) {
                Aplicacion.setDiaECR(tablaFila.getDiaECR());
                Aplicacion.setOrdenECR(tablaFila.getDeclaracionECR());
                Aplicacion.setNifECR(tablaFila.getNifECR());
            }
            Object object = AEAT100j.getLockhilo1();
            synchronized (object) {
                AEAT100j.getLockhilo1().notify();
            }
        }
    }

    public static boolean duplicarDeclaracion(String string) throws ExceptionMotor {
        if (declaraciones.size() < Constantes.getNumeroMaximoDeclaraciones()) {
            if ((string = string.trim()) != null && mDatRed.conectar()) {
                if (mDatRed.duplicarDeclaracion(string) == 1) {
                    JMensajesProperties jMensajesProperties = new JMensajesProperties("DECLEX");
                    jMensajesProperties.muestraMensaje();
                } else if (mDatRed.duplicarDeclaracion(string) == 2) {
                    JMensajesProperties jMensajesProperties = new JMensajesProperties("NMAS50");
                    jMensajesProperties.muestraMensaje();
                }
                mDatRed.desconectar();
            } else {
                JMensajesProperties jMensajesProperties = new JMensajesProperties("WIN013");
                jMensajesProperties.muestraMensaje();
            }
        } else {
            JMensajesProperties jMensajesProperties = new JMensajesProperties("MAS50");
            jMensajesProperties.muestraMensaje();
        }
        Declaraciones.actualizarLista();
        return true;
    }

    public static boolean borrarDeclaracion(String string) throws NoExisteDeclaracionException {
        TablaFila tablaFila = Declaraciones.encontrarDeclaracion(string);
        if (tablaFila == null) {
            throw new NoExisteDeclaracionException("No se ha encontrado " + string + " en la base de datos");
        }
        if (tablaFila != null && mDatRed.conectar() && mDatRed.eliminaDeclaracion(string)) {
            Declaraciones.actualizarLista();
            Declaraciones.listaDeclaracionRecienteBaja(string);
            return true;
        }
        return false;
    }

    public static boolean renombrarDeclaracion(String string, String string2) throws ExceptionMotor {
        String string3 = string;
        if (string2.length() != 0 && string3 != null) {
            int n = 0;
            JMensajesProperties jMensajesProperties = new JMensajesProperties(22, "WIN037", 2);
            n = jMensajesProperties.muestraMensaje();
            if (n == 0) {
                String string4 = string2;
                string4 = string4.trim();
                String string5 = string;
                if (!string5.equals("") && mDatRed.conectar()) {
                    mDatRed.renombraDeclaracion(string5, string4);
                    mDatRed.desconectar();
                    Declaraciones.listaDeclaracionRecienteRenombrar(string, string2);
                } else {
                    n = -1;
                    JMensajesProperties jMensajesProperties2 = new JMensajesProperties("100R130");
                    jMensajesProperties2.muestraMensaje();
                }
            }
        } else {
            int n = -1;
            JMensajesProperties jMensajesProperties = new JMensajesProperties("100R130");
            jMensajesProperties.muestraMensaje();
        }
        Declaraciones.actualizarLista();
        return true;
    }

    private static void firelistener() {
        for (ICambioListaDeclaraciones iCambioListaDeclaraciones : listaListener) {
            iCambioListaDeclaraciones.actualizarListaDeclaraciones(declaraciones);
        }
    }

    private static void firelistenerRecientes() {
        for (ICambioListaDeclaracionesRecientes iCambioListaDeclaracionesRecientes : listaListenerRecientes) {
            iCambioListaDeclaracionesRecientes.actualizarListaDeclaracionesRecientes(declaracionesRecientes);
        }
    }

    public static void addListener(ICambioListaDeclaraciones iCambioListaDeclaraciones) {
        listaListener.add(iCambioListaDeclaraciones);
    }

    public static void addListener(ICambioListaDeclaracionesRecientes iCambioListaDeclaracionesRecientes) {
        listaListenerRecientes.add(iCambioListaDeclaracionesRecientes);
        Declaraciones.firelistenerRecientes();
    }

    public static void removeListener(ICambioListaDeclaraciones iCambioListaDeclaraciones) {
        listaListener.remove(iCambioListaDeclaraciones);
    }

    public static void removeListenerRecientes(ICambioListaDeclaracionesRecientes iCambioListaDeclaracionesRecientes) {
        listaListener.remove(iCambioListaDeclaracionesRecientes);
    }

    public static void actualizarLista() {
        Declaraciones.cargaTablaDeclaraciones();
    }

    public static boolean existeDeclaracion(String string) {
        for (TablaFila tablaFila : Declaraciones.getDeclaraciones()) {
            if (!tablaFila.getClave().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static int siExisteDeclaracionDameFila(String string) {
        int n = 1;
        for (TablaFila tablaFila : Declaraciones.getDeclaraciones()) {
            int n2;
            if (Aplicacion.isECR() && (n2 = string.indexOf(" -")) != -1) {
                string = string.substring(0, n2).trim();
            }
            if (tablaFila.getClave().trim().equals(string.trim())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static void actualizarDeclaracion(String string, String string2, String string3) throws ExceptionMotor {
        String string4;
        Declaraciones.actualizarDatos(string, string2, string3);
        if (Aplicacion.isECR() && mDatRed.actualizarNIFECR(string4 = Aplicacion.getMotor().obtenerPartidaString("DPNIF_D"), string)) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Declaraciones.actualizarLista();
                }
            });
        }
    }

    public static void actualizarDatos(String string, String string2, String string3) throws ExceptionMotor {
        try {
            TablaFila tablaFila = Declaraciones.encontrarDeclaracion(string);
            String string4 = Declaraciones.limpiaCadena(string2);
            tablaFila.setDocumento(string4);
            tablaFila.setDescripcion(string3);
            tablaFila.setEstadoAlta(false);
            if (!string2.startsWith("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>")) {
                string2 = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>" + string2;
            }
            mDatRed.actualizarDeclaracion(string, string2, string3);
        }
        catch (NoExisteDeclaracionException noExisteDeclaracionException) {
            dialogoSeleccionar = new JMensajesProperties("APP007");
            dialogoSeleccionar.muestraMensaje();
        }
    }

    public static void actualizarDescripcion(String string, String string2) {
        mDatRed.conectar();
        try {
            TablaFila tablaFila = Declaraciones.encontrarDeclaracion(string);
            tablaFila.setDescripcion(string2);
            mDatRed.actualizarDescripcion(string, string2);
        }
        catch (NoExisteDeclaracionException noExisteDeclaracionException) {
            AEATLogger.getLogger().fatal((Object)noExisteDeclaracionException);
        }
    }

    public static void altaDeclaracion(String string) throws Exception {
        Declaraciones.altaDeclaracion(string, true);
    }

    public static void listaDeclaracionRecienteAlta(String string) {
        Declaraciones.getListaDeclaracionReciente().remove(string);
        Declaraciones.getListaDeclaracionReciente().add(0, string);
        Declaraciones.listaDeclaracionReciete2Properties();
        Declaraciones.firelistenerRecientes();
    }

    public static void listaDeclaracionRecienteBaja(String string) {
        Declaraciones.getListaDeclaracionReciente().remove(string);
        Declaraciones.listaDeclaracionReciete2Properties();
        Declaraciones.firelistenerRecientes();
    }

    public static void listaDeclaracionRecienteAbrir(String string) {
        Declaraciones.getListaDeclaracionReciente().remove(string);
        Declaraciones.getListaDeclaracionReciente().add(0, string);
        Declaraciones.listaDeclaracionReciete2Properties();
        Declaraciones.firelistenerRecientes();
    }

    public static void listaDeclaracionRecienteRenombrar(String string, String string2) {
        Declaraciones.getListaDeclaracionReciente().remove(string);
        Declaraciones.getListaDeclaracionReciente().add(0, string2);
        Declaraciones.listaDeclaracionReciete2Properties();
        Declaraciones.firelistenerRecientes();
    }

    private static void listaDeclaracionReciete2Properties() {
        for (int i = 0; i <= 5; ++i) {
            if (i < Declaraciones.getListaDeclaracionReciente().size()) {
                Aplicacion.configuracion().escribeEntrada("Recientes.declaracion" + i, Declaraciones.getListaDeclaracionReciente().get(i));
                continue;
            }
            Aplicacion.configuracion().escribeEntrada("Recientes.declaracion" + i, "");
        }
    }

    public static void borrarDeclaracionesRecientes() {
        for (int i = 0; i < 5; ++i) {
            Aplicacion.configuracion().escribeEntrada("Recientes.declaracion" + i, "");
        }
        declaracionesRecientes = new Vector();
        Declaraciones.firelistenerRecientes();
    }

    public static Vector<String> getListaDeclaracionReciente() {
        if (declaracionesRecientes == null) {
            declaracionesRecientes = new Vector(5);
            for (int i = 0; i < 5; ++i) {
                String string = Aplicacion.configuracion().dameEntrada("Recientes.declaracion" + i);
                try {
                    if (string == null || Declaraciones.encontrarDeclaracion(string) == null) continue;
                    declaracionesRecientes.add(string);
                    continue;
                }
                catch (NoExisteDeclaracionException noExisteDeclaracionException) {
                    // empty catch block
                }
            }
        }
        return declaracionesRecientes;
    }

    public static void actualiza(ICambioListaDeclaraciones iCambioListaDeclaraciones) {
        if (Declaraciones.getDeclaraciones() != null) {
            iCambioListaDeclaraciones.actualizarListaDeclaraciones(declaraciones);
        }
    }

    public static void actualiza(ICambioListaDeclaracionesRecientes iCambioListaDeclaracionesRecientes) {
        if (Declaraciones.getListaDeclaracionReciente() != null) {
            iCambioListaDeclaracionesRecientes.actualizarListaDeclaracionesRecientes(declaracionesRecientes);
        }
    }

    private static String limpiaCadena(String string) {
        String string2 = string;
        try {
            string2 = string2.replaceAll("<M2C1> - - -</M2C1>", "");
            string2 = string2.replaceAll("<M2C1 />", "");
            string2 = string2.replaceAll("<M2C2> - - -</M2C2>", "");
            string2 = string2.replaceAll("<M2C2 />", "");
            string2 = string2.replaceAll("<M3C1> - - -</M3C1>", "");
            string2 = string2.replaceAll("<M3C1 />", "");
            string2 = string2.replaceAll("<M4C1> - - -</M4C1>", "");
            string2 = string2.replaceAll("<M4C1 />", "");
            string2 = string2.replaceAll("<TCCC />", "");
            string2 = string2.replaceAll("<Y81 />", "");
            int n = string2.toUpperCase().indexOf("<INFORMACION>");
            int n2 = string2.toUpperCase().indexOf("</INFORMACION>");
            if (n != -1) {
                string2 = string2.substring(0, n) + string2.substring(n2 + "</INFORMACION>".length());
            }
            while (true) {
                n = string2.toUpperCase().indexOf("<NUMJUSTIFICANTE>");
                n2 = string2.toUpperCase().indexOf("</NUMJUSTIFICANTE>");
                if (n == -1) break;
                string2 = string2.substring(0, n) + string2.substring(n2 + "</NUMJUSTIFICANTE>".length());
            }
            while (true) {
                n = string2.toUpperCase().indexOf("<NUMREFERENCIA>");
                n2 = string2.toUpperCase().indexOf("</NUMREFERENCIA>");
                if (n == -1) break;
                string2 = string2.substring(0, n) + string2.substring(n2 + "</NUMREFERENCIA>".length());
            }
            return string2;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            return string2;
        }
    }

    private static boolean xmlIguales(String string, String string2) {
        try {
            return FuncionesUtiles.getFuncionesUtiles().sonIgualesXML(string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean declaracionesIguales(String string, String string2) {
        try {
            String string3 = Declaraciones.limpiaCadena(string);
            String string4 = Declaraciones.limpiaCadena(string2);
            return !"100".equals(string4) && Declaraciones.xmlIguales(string3, string4);
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            return false;
        }
    }

    static {
        listaListener = new Vector();
        listaListenerRecientes = new Vector();
        listaDeclaraciones = null;
    }

    public static class NoExisteDeclaracionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NoExisteDeclaracionException() {
        }

        public NoExisteDeclaracionException(String string) {
            super(string);
        }

        public NoExisteDeclaracionException(Throwable throwable) {
            super(throwable);
        }

        public NoExisteDeclaracionException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static class TablaFila {
        private String ordenDeclaracion;
        private String clave;
        private String descripcion;
        private String modelo;
        private int diaECR;
        private String declaracionECR;
        private String nifECR;
        private String fechaECR;
        private String tipoECR;
        private String conjECR;
        private String declECR;
        private String conyECR;
        private String hijo1ECR;
        private String hijo2ECR;
        private String hijo3ECR;
        private String hijo4ECR;
        private String modECR;
        private estado est;
        private String documento = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?><DECLARACIONES><IRPF" + Constantes.getEjercicioString() + "></IRPF" + Constantes.getEjercicioString() + "></DECLARACIONES>";

        public TablaFila(String string, String string2, String string3) {
            this.ordenDeclaracion = string;
            this.clave = string2;
            this.descripcion = string3;
        }

        public TablaFila copia() {
            TablaFila tablaFila = new TablaFila(this.getOrdenDeclaracion(), this.getClave(), this.getDescripcion());
            tablaFila.setDocumento(this.getDocumento());
            return tablaFila;
        }

        public TablaFila() {
        }

        public String getOrdenDeclaracion() {
            return this.ordenDeclaracion;
        }

        public void setOrdenDeclaracion(String string) {
            this.ordenDeclaracion = string;
        }

        public String getClave() {
            return this.clave;
        }

        public void setClave(String string) {
            this.clave = string;
        }

        public String getDescripcion() {
            return this.descripcion;
        }

        public void setDescripcion(String string) {
            this.descripcion = string;
        }

        public void setModelo(String string) {
            this.modelo = string;
        }

        public String getModelo() {
            return this.modelo;
        }

        public String getDocumento() {
            return this.documento;
        }

        public void setDocumento(String string) {
            this.documento = string;
        }

        public boolean esAlta() {
            return this.est.equals((Object)estado.alta);
        }

        public boolean estadoTAMaceptado() throws ExceptionMotor {
            return Aplicacion.getMotor().obtenerPartidaString("DF_ESTADO_TAM").equals("1");
        }

        public void setEstadoAlta(boolean bl) {
            this.est = bl ? estado.alta : estado.creada;
        }

        public void setEstadoAbierta() {
            this.est = estado.creada;
        }

        public int getDiaECR() {
            return this.diaECR;
        }

        public void setDiaECR(int n) {
            this.diaECR = n;
        }

        public String getDeclaracionECR() {
            return this.declaracionECR;
        }

        public void setDeclaracionECR(String string) {
            this.declaracionECR = String.valueOf(string);
        }

        public String getFechaECR() {
            return this.fechaECR;
        }

        public void setFechaECR(String string) {
            this.fechaECR = string;
        }

        public String getTipoECR() {
            return this.tipoECR;
        }

        public void setTipoECR(String string) {
            this.tipoECR = string;
        }

        public String getConjECR() {
            return this.conjECR;
        }

        public void setConjECR(String string) {
            this.conjECR = string;
        }

        public String getDeclECR() {
            return this.declECR;
        }

        public void setDeclECR(String string) {
            this.declECR = string;
        }

        public String getConyECR() {
            return this.conyECR;
        }

        public void setConyECR(String string) {
            this.conyECR = string;
        }

        public String getHijo1ECR() {
            return this.hijo1ECR;
        }

        public void setHijo1ECR(String string) {
            this.hijo1ECR = string;
        }

        public String getHijo2ECR() {
            return this.hijo2ECR;
        }

        public void setHijo2ECR(String string) {
            this.hijo2ECR = string;
        }

        public String getModECR() {
            return this.modECR;
        }

        public void setModECR(String string) {
            this.modECR = string;
        }

        public final String getHijo4ECR() {
            return this.hijo4ECR;
        }

        public final void setHijo4ECR(String string) {
            this.hijo4ECR = string;
        }

        public final String getNifECR() {
            return this.nifECR;
        }

        public final void setNifECR(String string) {
            this.nifECR = string;
        }

        public final String getHijo3ECR() {
            return this.hijo3ECR;
        }

        public final void setHijo3ECR(String string) {
            this.hijo3ECR = string;
        }

        public static enum estado {
            alta,
            baja,
            creada;

        }
    }
}

