/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.comunDF;

import es.aeat.pare.aplicacion.Aplicacion;
import es.aeat.pare.aplicacion.Constantes;
import es.aeat.pare.cc14.Declarantes;
import es.aeat.pare.comunDF.FuncionesDF;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class DatosGlobalesDF
implements Serializable {
    private static final long serialVersionUID = 8758840082278488824L;
    public static final int MODO_TRASLADO_SIN_INICIALIZAR = 0;
    public static final int MODO_TRASLADO_ESCRITORIO = 1;
    public static final int MODO_TRASLADO_WEB = 2;
    public static final int INT_CONJUNTA = 150;
    public static final boolean OS_WINDOWS = System.getProperty("os.name").toUpperCase().contains("WINDOWS");
    public static final int REGISTRO_NEGRO = 1;
    public static final int REGISTRO_AZUL = 2;
    public static final int REGISTRO_ROJO = 3;
    private FuncionesDF fDF;
    private static final String mNombreTablaHRescritorio = "DFHIJOSRENTAS";
    private static final String mNombreTablaMenoresWeb = "RWHIJOSMENOR18";
    private static final String mNombreTablaMayoresWeb = "RWHIJOSMAYOR18";
    public static int MAX_DE = 12;
    public static int MAX_AS = 4;
    private boolean bIndvOriginal = false;
    private HashMap<String, Integer> columnasTI = null;
    private String[][] tablaTIdeclarante;
    private String sNifConyuge = "";
    private boolean bHayLineaConyuge = false;
    private String sCA_declarante = "";
    private String sCA_conyuge = "";
    private String sEstadoCivilLineaDG = "";
    private boolean bHayHijoNacidoEnEjercicio = false;
    private boolean bConyugeNoResidente = false;
    private HashMap<Integer, String> mapaNifsOriginalesHR;
    private HashMap<String, Integer> columnasDE = null;
    private String[][] tablaDE;
    private int contDEvolRen1800;
    private int contDEmas24SinMinus;
    private int contHSRMas24SinMinus;
    private int contHRMas17MinusNo3OtrSituNo24;
    private int contDEMas17MinusNo3OtrSituNo24;
    private int contDEMenos25VolRenEntre1800_8000;
    private int contDEMenos25VolRenMayor8000;
    private HashMap<String, String> mapaNifCAhijosRentas;
    private HashMap<String, Boolean> mapaValidacionesHR;
    private HashMap<String, String> mapaNombresCompletos;
    private HashMap<String, Integer> columnasAS = null;
    private String[][] tablaAS;
    private HashMap<String, Integer> columnasPP = null;
    public static final int MAX_OCURR_PP_MINUS = 4;
    public static final int MAX_PP_MINUS_AUTO = 4;
    private HashMap<String, Double> mapaNifPPdiscapacitados;
    private int contPPdeclarantesClaves_1_5;
    private boolean bPPalgunoTrasladadoClave4;
    private double dRAOCdeclarante;
    private double dRAOCconyuge;
    private double dRAOCPdeclarante;
    private double dRAOCPconyuge;
    private ArrayList<String> listaNifesMinusPP;
    private String fechAdqTI_declarante = "";
    private String fechAdqModificada_declarante = "";
    private String numPH_declarante = "";
    private double porcAdqTI_declarante = 0.0;
    private int filaPermisoModifFechAdq_declarante = -1;
    private boolean seDedujoEjercicioAnterior_declarante = false;
    private String fechAdqTI_conyuge = "";
    private String fechAdqModificada_conyuge = "";
    private String mNumPH_conyuge = "";
    private double porcAdqTI_conyuge = 0.0;
    private int filaPermisoModifFechAdq_conyuge = -1;
    private boolean seDedujoEjercicioAnterior_conyuge = false;
    public static final int MAX_UR_NOAFECTOS_DECLA_CONYU = 60;
    public static final int MAX_UR_NOAFECTOS_HIJOS = 45;
    public static final int MAX_UR_AFECTOS = 60;
    public static final int MAX_UR_HAB_DECLA_CONYU = 8;
    public static final int MAX_UR_HAB_HIJOS = 1;
    private int contNoAfectos_decla;
    private int contNoAfectos_conyu;
    private int[] contNoAfectos_hijo = new int[Constantes.getNumhijosrentas()];
    private int contNoAfectos_comunes;
    private int contHabituales_decla;
    private int contHabituales_conyu;
    private int[] contHabituales_hijo = new int[Constantes.getNumhijosrentas()];
    private int contHabituales_comunes;
    private int contAfectos;
    private HashMap<String, Integer> columnasUR = null;
    private ArrayList<String[]> listaInmueblesRespuestaSi = new ArrayList();
    private ArrayList<String[]> listaInmueblesHabitualesRespuestaSi = new ArrayList();
    private String[][] tablaURdeclarante;
    private String[][] tablaURconyuge;
    private ArrayList<String[]> listaInmueblesComunesAusentesConyuge = new ArrayList();
    public static final int MAX_FIE = 54;
    private boolean bYaSeHaTrasladadoDM = false;
    private HashMap<String, Double> porcentajesVivHab_declarante = null;
    private HashMap<String, Double> porcentajesVivHab_conyuge = null;
    private HashMap<Integer, Boolean> mapaSeHaTrasladadoEAX;
    private HashMap<Integer, ArrayList<String[]>> mapaEAxNormales = null;

    public static final String getNombreTablaHRescritorio() {
        return mNombreTablaHRescritorio;
    }

    public static final String getNombreTablaMenoresWeb() {
        return mNombreTablaMenoresWeb;
    }

    public static final String getNombreTablaMayoresWeb() {
        return mNombreTablaMayoresWeb;
    }

    public DatosGlobalesDF() throws Exception {
        this.fDF = new FuncionesDF();
        this.iniciaizacionesGlobales();
    }

    public void iniciaizacionesGlobales() throws Exception {
        this.contDEmas24SinMinus = 0;
        this.contDEvolRen1800 = 0;
        this.contHRMas17MinusNo3OtrSituNo24 = 0;
        this.contDEMas17MinusNo3OtrSituNo24 = 0;
        this.contHSRMas24SinMinus = 0;
        this.bHayHijoNacidoEnEjercicio = false;
        this.bHayLineaConyuge = false;
        this.sEstadoCivilLineaDG = "";
        this.tablaTIdeclarante = null;
        this.fechAdqTI_declarante = "";
        this.fechAdqTI_conyuge = "";
        this.sNifConyuge = "";
        this.tablaDE = null;
        this.bYaSeHaTrasladadoDM = false;
        this.bPPalgunoTrasladadoClave4 = false;
        this.contPPdeclarantesClaves_1_5 = 0;
        this.mapaNifPPdiscapacitados = new HashMap();
        this.dRAOCdeclarante = 0.0;
        this.dRAOCconyuge = 0.0;
        this.listaNifesMinusPP = new ArrayList();
        this.contAfectos = 0;
        this.contHabituales_decla = 0;
        this.contHabituales_conyu = 0;
        this.contHabituales_comunes = 0;
        this.contNoAfectos_decla = 0;
        this.contNoAfectos_conyu = 0;
        this.contNoAfectos_comunes = 0;
        this.tablaURdeclarante = null;
        this.tablaURconyuge = null;
        this.listaInmueblesHabitualesRespuestaSi = new ArrayList();
        this.listaInmueblesRespuestaSi = new ArrayList();
        this.inicializaTablasVivHabitual(Declarantes.Declarante);
        Aplicacion.getMotor().partidaModificada("DF_PH_FADQ", "");
        this.filaPermisoModifFechAdq_declarante = -1;
        this.filaPermisoModifFechAdq_conyuge = -1;
        this.fechAdqTI_declarante = "";
    }

    public void iniciaizacionesPorDeclarante(Declarantes declarantes) throws Exception {
        if (declarantes.equals(Declarantes.Declarante)) {
            this.iniciaizacionesGlobales();
        } else if (declarantes.equals(Declarantes.Conyuge)) {
            this.contHabituales_conyu = 0;
            this.contNoAfectos_conyu = 0;
            this.tablaURconyuge = null;
            this.listaInmueblesComunesAusentesConyuge = new ArrayList();
            Aplicacion.getMotor().partidaModificada("DF_COMUNES_AUSENTES_CONYUGE", "false");
            this.inicializaTablasVivHabitual(Declarantes.Conyuge);
            this.filaPermisoModifFechAdq_conyuge = -1;
            Aplicacion.getMotor().partidaModificada("DF_PH_FADQ", "");
            this.dRAOCdeclarante = 0.0;
        } else {
            int n = 0;
            int n2 = 30;
            while (n < Constantes.getNumhijosrentas()) {
                if (declarantes.toInt() == n2) {
                    this.contNoAfectos_hijo[n] = 0;
                    this.contHabituales_hijo[n] = 0;
                }
                ++n;
                n2 += 10;
            }
        }
    }

    public void setIndvOriginal(boolean bl) {
        this.bIndvOriginal = bl;
    }

    public boolean seMarcoIndv() {
        return this.bIndvOriginal;
    }

    public HashMap<String, Integer> getColumnasTI() {
        if (null == this.columnasTI) {
            this.columnasTI = new HashMap();
            this.columnasTI.put("Tipo", 1);
            this.columnasTI.put("NIF", 3);
            this.columnasTI.put("NomComp", 4);
            this.columnasTI.put("Minus", 5);
            this.columnasTI.put("FechNac", 6);
            this.columnasTI.put("Sexo", 7);
            this.columnasTI.put("FechFal", 8);
            this.columnasTI.put("CA", 9);
            this.columnasTI.put("PrViLa", 10);
            this.columnasTI.put("MobGeo", 11);
            this.columnasTI.put("TrAcDis", 12);
            this.columnasTI.put("CCC", 13);
            this.columnasTI.put("NifOp", 15);
            this.columnasTI.put("NomCompOp", 16);
            this.columnasTI.put("NoNifOp", 17);
            this.columnasTI.put("FechAdq", 18);
            this.columnasTI.put("NumPH", 19);
            this.columnasTI.put("PorcPH", 20);
            this.columnasTI.put("SeDedujo", 21);
            this.columnasTI.put("Negativas", 22);
            this.columnasTI.put("Transmisiones", 23);
            this.columnasTI.put("Nombre", 24);
            this.columnasTI.put("Ape1", 25);
            this.columnasTI.put("Ape2", 26);
        }
        return this.columnasTI;
    }

    public String[][] getTablaTIdeclarante() {
        return this.tablaTIdeclarante;
    }

    public void setTablaTI(String[][] stringArray) throws Exception {
        this.tablaTIdeclarante = stringArray;
        if (null != stringArray) {
            this.fechAdqTI_declarante = this.fDF.formateaFecha(stringArray[0][this.getColumnasTI().get("FechAdq")]);
            this.numPH_declarante = stringArray[0][this.getColumnasTI().get("NumPH")];
            this.sCA_declarante = stringArray[0][this.getColumnasTI().get("CA")];
            try {
                this.porcAdqTI_declarante = Double.parseDouble(stringArray[0][this.getColumnasTI().get("PorcPH")]);
            }
            catch (NumberFormatException numberFormatException) {
                this.porcAdqTI_declarante = 0.0;
            }
            this.seDedujoEjercicioAnterior_declarante = stringArray[0][this.getColumnasTI().get("SeDedujo")].equalsIgnoreCase("S");
            if (stringArray.length > 1 && null != stringArray[1]) {
                this.bHayLineaConyuge = true;
                this.sNifConyuge = stringArray[1][this.getColumnasTI().get("NIF")];
                this.fechAdqTI_conyuge = this.fDF.formateaFecha(stringArray[1][this.getColumnasTI().get("FechAdq")]);
                this.mNumPH_conyuge = stringArray[1][this.getColumnasTI().get("NumPH")];
                this.sCA_conyuge = stringArray[1][this.getColumnasTI().get("CA")];
                try {
                    this.porcAdqTI_conyuge = Double.parseDouble(stringArray[1][this.getColumnasTI().get("PorcPH")]);
                }
                catch (NumberFormatException numberFormatException) {
                    this.porcAdqTI_conyuge = 0.0;
                }
                catch (NullPointerException nullPointerException) {
                    this.porcAdqTI_conyuge = 0.0;
                }
                try {
                    this.seDedujoEjercicioAnterior_conyuge = stringArray[1][this.getColumnasTI().get("SeDedujo")].equalsIgnoreCase("S");
                }
                catch (NullPointerException nullPointerException) {
                    this.seDedujoEjercicioAnterior_conyuge = false;
                }
            } else {
                this.bHayLineaConyuge = false;
                this.sNifConyuge = "";
                this.fechAdqTI_conyuge = "";
                this.mNumPH_conyuge = "";
                this.sCA_conyuge = "";
                this.porcAdqTI_conyuge = 0.0;
                this.seDedujoEjercicioAnterior_conyuge = false;
            }
        }
    }

    public void quitarConyuge() {
        String[][] stringArray = new String[1][this.tablaTIdeclarante[0].length];
        for (int i = 0; i < this.tablaTIdeclarante[0].length; ++i) {
            stringArray[0][i] = this.tablaTIdeclarante[0][i];
        }
        this.tablaTIdeclarante = stringArray;
    }

    public boolean hayFechaFallecimientoEnEjercicio(Declarantes declarantes) {
        String string;
        int n = 0;
        if (declarantes.equals(Declarantes.Conyuge)) {
            n = 1;
        }
        return null != this.tablaTIdeclarante && null != this.tablaTIdeclarante[n] && !"".equals(string = this.tablaTIdeclarante[n][this.getColumnasTI().get("FechFal")]) && string.substring(6, 10).equals(Constantes.getEjercicioString()) && !string.startsWith("31/12");
    }

    public String getNifLineaT02() {
        return this.sNifConyuge;
    }

    public boolean hayLineaConyuge() {
        return this.bHayLineaConyuge;
    }

    public String getCA(int n) throws Exception {
        String string = "";
        if (n == 10) {
            string = this.sCA_declarante;
        } else if (n == 20) {
            string = this.sCA_conyuge;
        } else if (n > 20 && n < Declarantes.UnidadFamiliar.toInt() && null != this.getTablaDE()) {
            for (int i = 0; i < this.getTablaDE().length; ++i) {
                if (!Aplicacion.getMotor().obtenerPartidaString("SPNIF").equals(this.getTablaDE()[i][this.getColumnasDE().get("NIF")])) continue;
                string = this.getTablaDE()[i][this.getColumnasDE().get("CA")];
            }
        }
        return string;
    }

    public String getEstadoCivilLineaDG() {
        return this.sEstadoCivilLineaDG;
    }

    public boolean hayHijoNacidoEnEjercicio() {
        return this.bHayHijoNacidoEnEjercicio;
    }

    public boolean hayConyugeNoResidente() {
        return this.bConyugeNoResidente;
    }

    public void setTablaDG(String[][] stringArray) {
        this.sEstadoCivilLineaDG = stringArray[0][1];
        this.bConyugeNoResidente = "X".equalsIgnoreCase(stringArray[0][2]);
        this.bHayHijoNacidoEnEjercicio = "S".equalsIgnoreCase(stringArray[0][3]);
    }

    public void setNifOriginalH(String string, int n) {
        if (null == this.mapaNifsOriginalesHR) {
            this.mapaNifsOriginalesHR = new HashMap();
        }
        this.mapaNifsOriginalesHR.put(n, string);
    }

    public HashMap<String, Integer> getColumnasDE() {
        if (null == this.columnasDE) {
            this.columnasDE = new HashMap();
            this.columnasDE.put("NumDes", 1);
            this.columnasDE.put("NIF", 3);
            this.columnasDE.put("NomApe", 4);
            this.columnasDE.put("Minus", 5);
            this.columnasDE.put("FechNac", 6);
            this.columnasDE.put("FechAdop", 7);
            this.columnasDE.put("Vincu", 8);
            this.columnasDE.put("OtrSitu", 9);
            this.columnasDE.put("CA", 10);
            this.columnasDE.put("Pertenece", 11);
            this.columnasDE.put("FechFal", 12);
            this.columnasDE.put("MobGeo", 13);
            this.columnasDE.put("TrAcDis", 14);
            this.columnasDE.put("VolRen", 15);
            this.columnasDE.put("Nombre", 16);
            this.columnasDE.put("Ape1", 17);
            this.columnasDE.put("Ape2", 18);
            this.columnasDE.put("FechAcog", 19);
            this.columnasDE.put("FallOP", 20);
        }
        return this.columnasDE;
    }

    public String[][] getTablaDE() {
        return this.tablaDE;
    }

    public void setTablaDE(String[][] stringArray) throws Exception {
        this.tablaDE = stringArray;
        if (null != stringArray) {
            for (int i = 0; i < this.tablaDE.length; ++i) {
                String string = this.fDF.comprobarCadenaNula(this.tablaDE[i][this.getColumnasDE().get("NIF")]);
                String string2 = this.fDF.comprobarCadenaNula(this.tablaDE[i][this.getColumnasDE().get("Minus")]);
                String string3 = this.fDF.comprobarFechaNula(this.tablaDE[i][this.getColumnasDE().get("FechNac")]);
                String string4 = this.fDF.comprobarFechaNula(this.tablaDE[i][this.getColumnasDE().get("FechFal")]);
                String string5 = this.fDF.comprobarFechaNula(this.getTablaTIdeclarante()[0][this.getColumnasTI().get("FechFal")]);
                int n = this.fDF.calculaEdadEfectivaHijo(string3, string4, string5);
                String string6 = this.fDF.comprobarCadenaNula(this.tablaDE[i][this.getColumnasDE().get("OtrSitu")]);
                double d = Double.parseDouble(this.tablaDE[i][this.getColumnasDE().get("VolRen")]);
                if (!(n <= 24 || "1".equals(string2) || "2".equals(string2) || "3".equals(string2))) {
                    ++this.contDEmas24SinMinus;
                }
                if (d > 1800.0) {
                    ++this.contDEvolRen1800;
                    if (n < 25 || n > 24 && ("1".equals(string2) || "2".equals(string2) || "3".equals(string2))) {
                        if (d <= 8000.0) {
                            ++this.contDEMenos25VolRenEntre1800_8000;
                        } else if (d > 800.0) {
                            ++this.contDEMenos25VolRenMayor8000;
                        }
                    }
                }
                if (n > 17 && !"3".equals(string2) || n > 17 && "3".equals(string2) && !"2".equals(string6) && !"4".equals(string6)) {
                    ++this.contDEMas17MinusNo3OtrSituNo24;
                }
                if (this.esHR(string)) {
                    String string7 = this.fDF.comprobarCadenaNula(this.tablaDE[i][this.getColumnasDE().get("CA")]);
                    this.hijoConRentasEncontrado(string, string7);
                    this.setValidacionHR(string, this.validaHR(n, string2, string6, d));
                    continue;
                }
                if (n <= 24 || "3".equals(string2) || "2".equals(string2) || "1".equals(string2)) continue;
                ++this.contHSRMas24SinMinus;
            }
        }
    }

    public int getContadorDEVolRen1800() {
        return this.contDEvolRen1800;
    }

    public int getContadorHijosMas24SinMinus() {
        return this.contDEmas24SinMinus;
    }

    public int getContadorHSRMas24SinMinus() {
        return this.contHSRMas24SinMinus;
    }

    public int getContadorHRMas17MinusNo3OtrSituNo24() {
        return this.contHRMas17MinusNo3OtrSituNo24;
    }

    public int getContadorDEMas17MinusNo3OtrSituNo24() {
        return this.contDEMas17MinusNo3OtrSituNo24;
    }

    public int getContadorDEMenos25VolRen1800_8000() {
        return this.contDEMenos25VolRenEntre1800_8000;
    }

    public int getContadorDEMenos25VolRenMayor8000() {
        return this.contDEMenos25VolRenMayor8000;
    }

    public HashMap<String, String> getMapaNifCAhijosRentas() {
        if (null == this.mapaNifCAhijosRentas) {
            this.mapaNifCAhijosRentas = new HashMap();
        }
        return this.mapaNifCAhijosRentas;
    }

    private void hijoConRentasEncontrado(String string, String string2) {
        if (null == this.mapaNifCAhijosRentas) {
            this.mapaNifCAhijosRentas = new HashMap();
        }
        this.mapaNifCAhijosRentas.put(string, string2);
    }

    public HashMap<String, Boolean> getMapaValidacionesHR() {
        if (null == this.mapaValidacionesHR) {
            this.mapaValidacionesHR = new HashMap();
        }
        return this.mapaValidacionesHR;
    }

    private void setValidacionHR(String string, boolean bl) {
        this.getMapaValidacionesHR().put(string, bl);
    }

    public boolean esHR(String string) throws ExceptionMotor {
        return this.mapaNifsOriginalesHR != null && this.mapaNifsOriginalesHR.containsValue(string);
    }

    public HashMap<String, String> getMapaNombresCompletos() {
        if (null == this.mapaNombresCompletos) {
            this.mapaNombresCompletos = new HashMap();
        }
        return this.mapaNombresCompletos;
    }

    public boolean validaHijo(String string, int n, String string2, String string3, double d) throws Exception {
        if (this.esHR(string)) {
            return this.validaHR(n, string2, string3, d);
        }
        return this.validaHSR(n, string2, string3, d);
    }

    public boolean validaHR(int n, String string, String string2, double d) throws ExceptionMotor {
        boolean bl = true;
        if (this.bIndvOriginal) {
            if (d > 1800.0) {
                bl = false;
            }
            if (!(n <= 24 || string.equalsIgnoreCase("1") || string.equalsIgnoreCase("2") || string.equalsIgnoreCase("3"))) {
                bl = false;
            }
        }
        if (this.hayFechaFallecimientoEnEjercicio(Declarantes.Declarante) && d > 1800.0) {
            bl = false;
        }
        if (n > 17 && !"3".equals(string) || n > 17 && "3".equals(string) && !"2".equals(string2) && !"4".equals(string2)) {
            ++this.contHRMas17MinusNo3OtrSituNo24;
            bl = false;
        }
        return bl;
    }

    public boolean validaHSR(int n, String string, String string2, double d) throws Exception {
        boolean bl = true;
        boolean bl2 = "1".equals(Aplicacion.getMotor().obtenerPartidaString("DF_PH18"));
        if (this.bIndvOriginal) {
            if (d > 1800.0) {
                bl = false;
            }
            if (!(n <= 24 || string.equalsIgnoreCase("1") || string.equalsIgnoreCase("2") || string.equalsIgnoreCase("3"))) {
                bl = false;
            }
        }
        if (this.hayFechaFallecimientoEnEjercicio(Declarantes.Declarante) && d > 1800.0) {
            bl = false;
        }
        if (!bl2) {
            if (!(n <= 24 || string.equalsIgnoreCase("1") || string.equalsIgnoreCase("2") || string.equalsIgnoreCase("3"))) {
                bl = false;
            }
            if (d > 8000.0 && (n < 25 || n > 24 && ("1".equals(string) || "2".equals(string) || "3".equals(string)))) {
                bl = false;
            }
        }
        return bl;
    }

    public HashMap<String, Integer> getColumnasAS() {
        if (null == this.columnasAS) {
            this.columnasAS = new HashMap();
            this.columnasAS.put("NumAs", 1);
            this.columnasAS.put("NIF", 3);
            this.columnasAS.put("NomApe", 4);
            this.columnasAS.put("Minus", 5);
            this.columnasAS.put("FechNac", 6);
            this.columnasAS.put("Vincu", 7);
            this.columnasAS.put("Conv", 8);
            this.columnasAS.put("Nombre", 9);
            this.columnasAS.put("Ape1", 10);
            this.columnasAS.put("Ape2", 11);
        }
        return this.columnasAS;
    }

    public String[][] getTablaAS() {
        return this.tablaAS;
    }

    public void setTablaAS(String[][] stringArray) {
        this.tablaAS = stringArray;
    }

    public int dameNumColumna(String string, String string2) {
        if ("DE".equals(string)) {
            return this.getColumnasDE().get(string2);
        }
        if ("AS".equals(string)) {
            return this.getColumnasAS().get(string2);
        }
        return 0;
    }

    public HashMap<String, Integer> getColumnasPP() {
        if (null == this.columnasPP) {
            this.columnasPP = new HashMap();
            this.columnasPP.put("Clave", 3);
            this.columnasPP.put("Subclave", 4);
            this.columnasPP.put("Aportacion", 5);
            this.columnasPP.put("NIF", 7);
        }
        return this.columnasPP;
    }

    public HashMap<String, Double> getMapaNifPPdiscapacitados() {
        return this.mapaNifPPdiscapacitados;
    }

    public boolean nuevoPPdiscapacitados(String string, double d) {
        boolean bl = false;
        if (this.mapaNifPPdiscapacitados.containsKey(string)) {
            double d2 = this.mapaNifPPdiscapacitados.get(string);
            this.mapaNifPPdiscapacitados.put(string, d2 + d);
            bl = true;
        } else if (this.mapaNifPPdiscapacitados.size() >= 4) {
            bl = false;
        } else {
            this.mapaNifPPdiscapacitados.put(string, d);
            bl = true;
        }
        return bl;
    }

    public void quitarPPdiscapacitados(String string, double d) {
        if (this.mapaNifPPdiscapacitados.containsKey(string)) {
            double d2 = this.mapaNifPPdiscapacitados.get(string);
            double d3 = d2 - d;
            if (d3 > 0.0) {
                this.mapaNifPPdiscapacitados.put(string, d3);
            } else {
                this.mapaNifPPdiscapacitados.remove(string);
            }
        }
    }

    public void reseteaMapaNifDiscapacitado() {
        this.mapaNifPPdiscapacitados = new HashMap();
    }

    public int getCuantosDeclarantesHanTrasladadoClavesPP_1_5() {
        return this.contPPdeclarantesClaves_1_5;
    }

    public void incrementaCuantosDeclarantesHanTrasladadoClavesPP_1_5() {
        ++this.contPPdeclarantesClaves_1_5;
    }

    public boolean getAlgunPPtrasladadoConClave4() {
        return this.bPPalgunoTrasladadoClave4;
    }

    public void setAlgunPPtrasladadoConClave4(boolean bl) {
        this.bPPalgunoTrasladadoClave4 = bl;
    }

    public double getRAOC(Declarantes declarantes) {
        if (declarantes.equals(Declarantes.Declarante)) {
            return this.dRAOCdeclarante;
        }
        if (declarantes.equals(Declarantes.Conyuge)) {
            return this.dRAOCconyuge;
        }
        System.out.println("Error en m\u00e9todo getRAOC(). No estamos ni en declarante ni en c\u00f3nyuge ");
        return 0.0;
    }

    public void setRAOC(Declarantes declarantes, double d) {
        if (declarantes.equals(Declarantes.Declarante)) {
            this.dRAOCdeclarante += d;
        } else if (declarantes.equals(Declarantes.Conyuge)) {
            this.dRAOCconyuge += d;
        } else {
            System.out.println("Error en m\u00e9todo setRAOC(). No estamos ni en declarante ni en c\u00f3nyuge ");
        }
    }

    public double getRAOCP(Declarantes declarantes) {
        if (declarantes.equals(Declarantes.Declarante)) {
            return this.dRAOCPdeclarante;
        }
        if (declarantes.equals(Declarantes.Conyuge)) {
            return this.dRAOCPconyuge;
        }
        System.out.println("Error en m\u00e9todo getRAOCP(). No estamos ni en declarante ni en c\u00f3nyuge ");
        return 0.0;
    }

    public void setRAOCP(Declarantes declarantes, double d) {
        if (declarantes.equals(Declarantes.Declarante)) {
            this.dRAOCPdeclarante += d;
        } else if (declarantes.equals(Declarantes.Conyuge)) {
            this.dRAOCPconyuge += d;
        } else {
            System.out.println("Error en m\u00e9todo setRAOCP(). No estamos ni en declarante ni en c\u00f3nyuge ");
        }
    }

    public ArrayList<String> getListaNifesMinusPP() {
        if (null == this.listaNifesMinusPP) {
            this.listaNifesMinusPP = new ArrayList();
        }
        return this.listaNifesMinusPP;
    }

    public void setFechaAdquisicionModificada(Declarantes declarantes, String string) {
        if (declarantes.equals(Declarantes.Declarante)) {
            this.fechAdqModificada_declarante = string;
        } else if (declarantes.equals(Declarantes.Conyuge)) {
            this.fechAdqModificada_conyuge = string;
        }
    }

    public String getFechaAdquisicionViVHab(Declarantes declarantes) {
        if (declarantes.equals(Declarantes.Declarante)) {
            return this.fechAdqTI_declarante;
        }
        if (declarantes.equals(Declarantes.Conyuge)) {
            return this.fechAdqTI_conyuge;
        }
        System.out.println("Se ha llamado a getFechaAdquisicionViVHab() con un declarante distinto de declarante o c\u00f3nyuge. " + declarantes.getNombreUnico());
        return "";
    }

    public String getFechaAdquisicionModificada(Declarantes declarantes) {
        if (declarantes.equals(Declarantes.Declarante)) {
            return this.fechAdqModificada_declarante;
        }
        if (declarantes.equals(Declarantes.Conyuge)) {
            return this.fechAdqModificada_conyuge;
        }
        System.out.println("Se ha llamado a getFechaAdquisicionModificada() con un declarante distinto de declarante o c\u00f3nyuge. " + declarantes.getNombreUnico());
        return "";
    }

    public String getNumPH(Declarantes declarantes) {
        if (declarantes.equals(Declarantes.Declarante)) {
            return this.numPH_declarante;
        }
        if (declarantes.equals(Declarantes.Conyuge)) {
            return this.mNumPH_conyuge;
        }
        System.out.println("Se ha llamado a getNumPH() con un declarante distinto de declarante o c\u00f3nyuge. " + declarantes.getNombreUnico());
        return "";
    }

    public int getFilaPermisoModifFechAdq(Declarantes declarantes) {
        if (declarantes.equals(Declarantes.Declarante)) {
            return this.filaPermisoModifFechAdq_declarante;
        }
        if (declarantes.equals(Declarantes.Conyuge)) {
            return this.filaPermisoModifFechAdq_conyuge;
        }
        System.out.println("Se ha llamado a getNumRegistroPermisoModifFechAdq() con un declarante distinto de declarante o c\u00f3nyuge. " + declarantes.getNombreUnico());
        return -9;
    }

    public void setFilaRegistroPermisoModifFechAdq(Declarantes declarantes, int n) {
        if (declarantes.equals(Declarantes.Declarante)) {
            this.filaPermisoModifFechAdq_declarante = n;
        } else if (declarantes.equals(Declarantes.Conyuge)) {
            this.filaPermisoModifFechAdq_conyuge = n;
        }
    }

    public double getPorcAdqTI(Declarantes declarantes) {
        if (declarantes.equals(Declarantes.Declarante)) {
            return this.porcAdqTI_declarante;
        }
        if (declarantes.equals(Declarantes.Conyuge)) {
            return this.porcAdqTI_conyuge;
        }
        System.out.println("Se ha llamado a getPorcentajePHvivHab() con un declarante distinto de declarante o c\u00f3nyuge. " + declarantes.getNombreUnico());
        return 0.0;
    }

    public void setSeDedujoEjercicioAnterior(Declarantes declarantes, boolean bl) {
        if (declarantes.equals(Declarantes.Declarante)) {
            this.seDedujoEjercicioAnterior_declarante = bl;
        } else if (declarantes.equals(Declarantes.Conyuge)) {
            this.seDedujoEjercicioAnterior_conyuge = bl;
        } else {
            System.out.println("Error en setSeDedujoEjercicioAnterior(). Declarante distinto de declarante o c\u00f3nyuge");
        }
    }

    public boolean getSeDedujoEjercicioAnterior(Declarantes declarantes) {
        if (declarantes.equals(Declarantes.Declarante)) {
            return this.seDedujoEjercicioAnterior_declarante;
        }
        if (declarantes.equals(Declarantes.Conyuge)) {
            return this.seDedujoEjercicioAnterior_conyuge;
        }
        System.out.println("Error en getSeDedujoEjercicioAnterior(). Declarante distinto de declarante o c\u00f3nyuge");
        return false;
    }

    public HashMap<String, Integer> getColumnasUR() {
        if (null == this.columnasUR) {
            this.columnasUR = new HashMap();
            this.columnasUR.put("RefCat", 1);
            this.columnasUR.put("TipoVia", 2);
            this.columnasUR.put("Via", 3);
            this.columnasUR.put("Numero", 4);
            this.columnasUR.put("Escalera", 5);
            this.columnasUR.put("Planta", 6);
            this.columnasUR.put("Puerta", 7);
            this.columnasUR.put("Municipio", 8);
            this.columnasUR.put("ClaseBien", 9);
            this.columnasUR.put("Clave", 10);
            this.columnasUR.put("ClasAlmacen", 11);
            this.columnasUR.put("Valor", 12);
            this.columnasUR.put("Revisado", 13);
            this.columnasUR.put("CodDer", 14);
            this.columnasUR.put("PorcParticip", 15);
            this.columnasUR.put("Dias", 16);
            this.columnasUR.put("MarcaUso", 17);
            this.columnasUR.put("Situacion", 18);
            this.columnasUR.put("Habitual", 19);
            this.columnasUR.put("OtroUso", 20);
            this.columnasUR.put("PorcPc", 21);
            this.columnasUR.put("PorcUsu", 22);
            this.columnasUR.put("Uso", 23);
            this.columnasUR.put("VariosUsos", 24);
            this.columnasUR.put("PorcDisp", 25);
            this.columnasUR.put("Copiar", 26);
            this.columnasUR.put("V02tip", 29);
            this.columnasUR.put("Porcf", 30);
            this.columnasUR.put("V02ii", 31);
            this.columnasUR.put("V02in", 32);
            this.columnasUR.put("V02gea", 33);
            this.columnasUR.put("V02og", 34);
            this.columnasUR.put("V02rir", 37);
            this.columnasUR.put("V02ret", 38);
            this.columnasUR.put("V02rmf", 39);
        }
        return this.columnasUR;
    }

    public int getMaximoInmueblesMarcaH(int n) {
        int n2 = 8;
        if (n != 10 && n != 20 && n != 150) {
            n2 = 1;
        }
        return n2;
    }

    public int getMaximoInmueblesNoAfectos(int n) {
        int n2 = 60;
        if (n != 10 && n != 20 && n != 150) {
            n2 = 45;
        }
        return n2;
    }

    public int getContadorHabituales(Declarantes declarantes) throws ExceptionMotor {
        if (declarantes.equals(Declarantes.Declarante)) {
            return this.contHabituales_decla;
        }
        if (declarantes.equals(Declarantes.Conyuge)) {
            return this.contHabituales_conyu + this.contHabituales_comunes;
        }
        int n = 0;
        int n2 = 30;
        while (n < Constantes.getNumhijosrentas()) {
            if (declarantes.toInt() == n2) {
                return this.contHabituales_hijo[n];
            }
            ++n;
            n2 += 10;
        }
        System.out.println("Error en getContadorHabituales(). Declarante no definido");
        return 0;
    }

    public void setContadorHabituales(Declarantes declarantes, boolean bl) {
        block7: {
            block8: {
                block9: {
                    block5: {
                        block6: {
                            if (!declarantes.equals(Declarantes.Declarante)) break block5;
                            if (!bl) break block6;
                            ++this.contHabituales_decla;
                            break block7;
                        }
                        if (this.contHabituales_decla <= 0) break block7;
                        --this.contHabituales_decla;
                        break block7;
                    }
                    if (!declarantes.equals(Declarantes.Conyuge)) break block8;
                    if (!bl) break block9;
                    ++this.contHabituales_conyu;
                    break block7;
                }
                if (this.contHabituales_conyu <= 0) break block7;
                --this.contHabituales_conyu;
                break block7;
            }
            int n = 0;
            int n2 = 30;
            while (n < Constantes.getNumhijosrentas()) {
                if (declarantes.toInt() == n2) {
                    if (bl) {
                        int n3 = n;
                        this.contHabituales_hijo[n3] = this.contHabituales_hijo[n3] + 1;
                    } else if (this.contHabituales_hijo[n] > 0) {
                        int n4 = n;
                        this.contHabituales_hijo[n4] = this.contHabituales_hijo[n4] - 1;
                    }
                }
                ++n;
                n2 += 10;
            }
        }
    }

    public void setContadorAfectos(boolean bl) {
        this.contAfectos = bl ? ++this.contAfectos : --this.contAfectos;
    }

    public int getContadorAfectos() throws Exception {
        return this.contAfectos;
    }

    public void setContadorNoAfectos(Declarantes declarantes, boolean bl) {
        block7: {
            block8: {
                block9: {
                    block5: {
                        block6: {
                            if (!declarantes.equals(Declarantes.Declarante)) break block5;
                            if (!bl) break block6;
                            ++this.contNoAfectos_decla;
                            break block7;
                        }
                        if (this.contNoAfectos_decla <= 0) break block7;
                        --this.contNoAfectos_decla;
                        break block7;
                    }
                    if (!declarantes.equals(Declarantes.Conyuge)) break block8;
                    if (!bl) break block9;
                    ++this.contNoAfectos_conyu;
                    break block7;
                }
                if (this.contNoAfectos_conyu <= 0) break block7;
                --this.contNoAfectos_conyu;
                break block7;
            }
            int n = 0;
            int n2 = 30;
            while (n < Constantes.getNumhijosrentas()) {
                if (declarantes.toInt() == n2) {
                    if (bl) {
                        int n3 = n;
                        this.contNoAfectos_hijo[n3] = this.contNoAfectos_hijo[n3] + 1;
                    } else if (this.contNoAfectos_hijo[n] > 0) {
                        int n4 = n;
                        this.contNoAfectos_hijo[n4] = this.contNoAfectos_hijo[n4] - 1;
                    }
                }
                ++n;
                n2 += 10;
            }
        }
    }

    public int getContadorNoAfectos(Declarantes declarantes) {
        if (declarantes.equals(Declarantes.Declarante)) {
            return this.contNoAfectos_decla;
        }
        if (declarantes.equals(Declarantes.Conyuge)) {
            return this.contNoAfectos_conyu + this.contNoAfectos_comunes;
        }
        int n = 0;
        int n2 = 30;
        while (n < Constantes.getNumhijosrentas()) {
            if (declarantes.toInt() == n2) {
                return this.contNoAfectos_hijo[n];
            }
            ++n;
            n2 += 10;
        }
        System.out.println("Error en getContadorAfectos(). Declarante no definido");
        return 0;
    }

    public ArrayList<String[]> getListaInmueblesRespuestaSi() {
        return this.listaInmueblesRespuestaSi;
    }

    public ArrayList<String[]> getListaInmueblesHabitualesRespuestaSi() {
        return this.listaInmueblesHabitualesRespuestaSi;
    }

    public String[][] getTablaURdeclarante() {
        return this.tablaURdeclarante;
    }

    public void setTablaURdeclarante(String[][] stringArray) throws Exception {
        this.listaInmueblesRespuestaSi.clear();
        this.listaInmueblesHabitualesRespuestaSi.clear();
        this.tablaURdeclarante = stringArray;
        for (int i = 0; i < this.tablaURdeclarante.length; ++i) {
            boolean bl = null != this.tablaURdeclarante[i][this.getColumnasUR().get("Copiar")] && this.tablaURdeclarante[i][this.getColumnasUR().get("Copiar")].indexOf("S") != -1;
            boolean bl2 = null != this.tablaURdeclarante[i][this.getColumnasUR().get("Habitual")] && this.tablaURdeclarante[i][this.getColumnasUR().get("Habitual")].indexOf("S") != -1;
            String string = this.tablaURdeclarante[i][this.getColumnasUR().get("Uso")];
            if (!bl) continue;
            this.listaInmueblesRespuestaSi.add(this.tablaURdeclarante[i]);
            if (bl2) {
                this.listaInmueblesHabitualesRespuestaSi.add(this.tablaURdeclarante[i]);
                ++this.contHabituales_comunes;
            }
            if (!"1".equals(string) && !"2".equals(string) && !"3".equals(string) && !"4".equals(string) && !"5".equals(string) && !"6".equals(string)) continue;
            ++this.contNoAfectos_comunes;
        }
        this.mirarInmueblesComunesAusntenEnConyuge();
    }

    public String[][] getTablaURconyuge() {
        return this.tablaURconyuge;
    }

    public void setTablaURconyuge(String[][] stringArray) throws Exception {
        this.tablaURconyuge = stringArray;
    }

    private void mirarInmueblesComunesAusntenEnConyuge() throws Exception {
        boolean bl = Boolean.parseBoolean(Aplicacion.getMotor().obtenerPartidaString("DF_COMUNES_AUSENTES_CONYUGE"));
        if (!this.listaInmueblesRespuestaSi.isEmpty()) {
            for (int i = 0; i < this.listaInmueblesRespuestaSi.size(); ++i) {
                boolean bl2 = true;
                if (null != this.tablaURconyuge) {
                    for (int j = 0; j < this.tablaURconyuge.length; ++j) {
                        if (!this.fDF.esMismoMismoInmueble(this.listaInmueblesRespuestaSi.get(i), this.tablaURconyuge[j])) continue;
                        bl2 = false;
                        break;
                    }
                }
                if (!bl2) continue;
                this.listaInmueblesComunesAusentesConyuge.add(this.listaInmueblesRespuestaSi.get(i));
                if (bl) continue;
                Aplicacion.getMotor().partidaModificada("DF_COMUNES_AUSENTES_CONYUGE", "true");
                bl = true;
            }
        }
    }

    public ArrayList<String[]> getListaInmueblesComunesAusentesConyuge() {
        return this.listaInmueblesComunesAusentesConyuge;
    }

    public void setYaSeHaTrasladadoDM(boolean bl) {
        this.bYaSeHaTrasladadoDM = true;
    }

    public boolean getYaSeHaTrasladadoDM() {
        return this.bYaSeHaTrasladadoDM;
    }

    public HashMap<String, Double> getMapaPorcentajesVivHab(Declarantes declarantes) {
        if (declarantes.equals(Declarantes.Declarante)) {
            return this.porcentajesVivHab_declarante;
        }
        if (declarantes.equals(Declarantes.Conyuge)) {
            return this.porcentajesVivHab_conyuge;
        }
        System.out.println("Error en getMapaPorcentajesVivHab(). Declarante actual ni declarante ni c\u00f3nyuge");
        return null;
    }

    private void inicializaTablasVivHabitual(Declarantes declarantes) {
        if (declarantes.equals(Declarantes.Declarante)) {
            this.porcentajesVivHab_declarante = new HashMap();
            this.porcentajesVivHab_conyuge = new HashMap();
        } else if (declarantes.equals(Declarantes.Conyuge)) {
            this.porcentajesVivHab_conyuge = new HashMap();
        } else {
            System.out.println("Error en inicializaTablasVivHabitual(). Declarante actual ni declarante ni c\u00f3nyuge");
        }
    }

    public boolean getMapaTrasladadosEAX(int n) {
        if (null == this.mapaSeHaTrasladadoEAX) {
            this.mapaSeHaTrasladadoEAX = new HashMap();
        }
        if (this.mapaSeHaTrasladadoEAX.containsKey(n)) {
            return this.mapaSeHaTrasladadoEAX.get(n);
        }
        return false;
    }

    public void setMapaSeHaTrasladadoEAX(int n, boolean bl) {
        this.mapaSeHaTrasladadoEAX.put(n, bl);
    }

    public int dameNumeroTotalEAX() {
        int n = 0;
        for (int i = 10; i < 150; i += 10) {
            if (null == this.mapaEAxNormales || null == this.mapaEAxNormales.get(i) || !this.mapaEAxNormales.containsKey(i)) continue;
            n += this.mapaEAxNormales.get(i).size();
        }
        return n;
    }

    public void compruebaEAXnormal(int n, String string, String string2) {
        if (null == this.mapaEAxNormales) {
            this.mapaEAxNormales = new HashMap();
        }
        if (null == this.mapaEAxNormales.get(n)) {
            this.mapaEAxNormales.put(n, new ArrayList());
        }
        for (int i = 0; i < this.mapaEAxNormales.get(n).size(); ++i) {
            if (!this.mapaEAxNormales.get(n).get(i)[0].equals(string) || !this.mapaEAxNormales.get(n).get(i)[1].equals(string2)) continue;
            return;
        }
        String[] stringArray = new String[]{string, string2};
        this.mapaEAxNormales.get(n).add(stringArray);
    }
}

