/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.comunDF;

import es.aeat.pare.aplicacion.Aplicacion;
import es.aeat.pare.aplicacion.Constantes;
import es.aeat.pare.cc14.Declarantes;
import es.aeat.pare.componentes.JMensajesProperties;
import es.aeat.pare.comunDF.AnalizadorDF;
import es.aeat.pare.comunDF.DatosGlobalesDF;
import es.aeat.pare.comunDF.FuncionesDF;
import es.aeat.pare.comunDF.InterfazAccesoDatosDF;
import es.aeat.pare.comunDF.ObjetoAtRentasDF;
import es.aeat.pare.comunDF.TransformardorDF;
import es.aeat.pare.comunDF.TrasladoComunDF;
import es.aeat.pare.comunDF.TrasladosDatosPersonales;
import es.aeat.pare.re14.motor.FuncionesRenta;
import es.aeat.pare.re14.motor.FuncionesRentaComun;
import es.aeat.pare.re14.motor.motorComun.ValidacionesAnxB4;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;

public class ControladorDF
implements Serializable {
    private static final long serialVersionUID = -7895797269397220294L;
    private Declarantes mDeclaranteActual;
    private int modo_traslado = 0;
    private String modo_traslado_string = "";
    private FuncionesDF fDF = new FuncionesDF();
    private FuncionesRentaComun fr = new FuncionesRentaComun();
    private TrasladoComunDF tc;
    private DatosGlobalesDF mDG;
    private InterfazAccesoDatosDF mAcc;
    private HashMap<Integer, HashMap<String, boolean[]>> mapaRegistrosMarcados;
    private HashMap<Integer, TransformardorDF> mapaTransformadores;
    private HashMap<Integer, AnalizadorDF> mapaAnalizadores;
    private int numHRdeclarados = 0;
    private boolean bSeHaDeclaradoConyuge;
    private HashMap<Integer, String> mapaUF;
    private HashMap<Integer, String> mapaApellidosUF;
    private HashMap<Integer, File> mapaFicheros;
    private HashMap<Integer, Boolean> mapaExistenciaFicheros;
    private HashMap<Integer, Boolean> mapaDatosCorrectos;
    private boolean bDeclaracionIndividualSobrevenida = false;
    private HashMap<Integer, String> mapaErroresPieza;
    private boolean bSalidaFuncionValidaDatosPersonales = false;
    private HashMap<Integer, Boolean> mapaDatosAzules;
    private HashMap<Integer, Boolean> mapaPreguntasUrbana;
    private HashMap<Integer, Boolean> mapaRespuestasUrbana;
    private HashMap<Integer, Boolean> mapaUrbanaPreguntada;
    private HashMap<Integer, Boolean> mapaTrasladosRealizados;
    private boolean bRamasXMLabiertas = false;

    public void setDeclarante(Declarantes declarantes) throws Exception {
        this.mDeclaranteActual = declarantes;
    }

    public Declarantes getDeclaranteActual() {
        return this.mDeclaranteActual;
    }

    public int getModoTraslado() {
        return this.modo_traslado;
    }

    public void setModoTraslado(int n) {
        this.modo_traslado = n;
        if (this.modo_traslado == 1) {
            this.modo_traslado_string = "ESCRITORIO";
        } else if (this.modo_traslado == 2) {
            this.modo_traslado_string = "WEB";
        }
    }

    public String getModoTrasladoString() {
        return this.modo_traslado_string;
    }

    public DatosGlobalesDF getDG() throws Exception {
        if (null == this.mDG) {
            this.mDG = new DatosGlobalesDF();
        }
        return this.mDG;
    }

    public InterfazAccesoDatosDF getAccesoDatos() {
        return this.mAcc;
    }

    public void setAccesoDatos(InterfazAccesoDatosDF interfazAccesoDatosDF) {
        this.mAcc = interfazAccesoDatosDF;
    }

    public void setMapaRegistrosMarcados(int n, String string, boolean[] blArray) {
        if (null == this.mapaRegistrosMarcados) {
            this.mapaRegistrosMarcados = new HashMap();
        }
        if (null == this.mapaRegistrosMarcados.get(n)) {
            this.mapaRegistrosMarcados.put(n, new HashMap());
        }
        this.mapaRegistrosMarcados.get(n).put(string, blArray);
    }

    public boolean[] getMapaRegistrosMarcados(int n, String string) {
        boolean[] blArray;
        if (null == this.mapaRegistrosMarcados) {
            this.mapaRegistrosMarcados = new HashMap();
        }
        if (null == this.mapaRegistrosMarcados.get(n)) {
            this.mapaRegistrosMarcados.put(n, new HashMap());
        }
        if (null == this.mapaRegistrosMarcados.get(n).get(string)) {
            blArray = this.fDF.devuelveTodosDesmarcados(this.getTransformador(n).getTablaContRegistros().get(string));
            this.mapaRegistrosMarcados.get(n).put(string, blArray);
        }
        blArray = this.mapaRegistrosMarcados.get(n).get(string);
        return blArray;
    }

    public HashMap<Integer, TransformardorDF> getMapaTransformadores() {
        if (null == this.mapaTransformadores) {
            this.mapaTransformadores = new HashMap();
        }
        return this.mapaTransformadores;
    }

    public void setTransformador(TransformardorDF transformardorDF, int n) {
        if (null == this.mapaTransformadores) {
            this.mapaTransformadores = new HashMap();
        }
        this.mapaTransformadores.put(n, transformardorDF);
    }

    public TransformardorDF getTransformador(int n) {
        if (null == this.mapaTransformadores) {
            this.mapaTransformadores = new HashMap();
        }
        return this.mapaTransformadores.get(n);
    }

    public HashMap<Integer, AnalizadorDF> getMapaAnalizadores() {
        if (null == this.mapaAnalizadores) {
            this.mapaAnalizadores = new HashMap();
        }
        return this.mapaAnalizadores;
    }

    public void setAnalizador(AnalizadorDF analizadorDF, Integer n) {
        if (null == this.mapaAnalizadores) {
            this.mapaAnalizadores = new HashMap();
        }
        this.mapaAnalizadores.put(n, analizadorDF);
    }

    public AnalizadorDF getAnalizador(Integer n) {
        if (null == this.mapaAnalizadores) {
            this.mapaAnalizadores = new HashMap();
        }
        return this.mapaAnalizadores.get(n);
    }

    public int getNumHRdeclarados() {
        return this.numHRdeclarados;
    }

    public void setNumHRdeclarados(int n) {
        this.numHRdeclarados = n;
    }

    public void setSeHaDeclaradoConyuge(boolean bl) {
        this.bSeHaDeclaradoConyuge = bl;
    }

    public boolean getSeHaDeclaradoConyuge() {
        return this.bSeHaDeclaradoConyuge;
    }

    public HashMap<Integer, String> getMapaUnidadFamiliar() {
        if (null == this.mapaUF) {
            this.mapaUF = new HashMap();
        }
        return this.mapaUF;
    }

    public HashMap<Integer, String> getMapaApellidosUnidadFamiliar() {
        if (null == this.mapaApellidosUF) {
            this.mapaApellidosUF = new HashMap();
        }
        return this.mapaApellidosUF;
    }

    public HashMap<Integer, File> getMapaFicheros() {
        if (null == this.mapaFicheros) {
            this.mapaFicheros = new HashMap();
            Object[] objectArray = this.getMapaUnidadFamiliar().keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                this.mapaFicheros.put(Integer.valueOf(objectArray[i].toString()), null);
            }
        }
        return this.mapaFicheros;
    }

    public HashMap<Integer, Boolean> getMapaExisteciaFicheros() {
        if (null == this.mapaExistenciaFicheros) {
            this.mapaExistenciaFicheros = new HashMap();
            Object[] objectArray = this.getMapaUnidadFamiliar().keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                this.mapaExistenciaFicheros.put(Integer.valueOf(objectArray[i].toString()), false);
            }
        }
        return this.mapaExistenciaFicheros;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFichero(File file, int n) throws Exception {
        try {
            if (null == this.mapaFicheros) {
                this.mapaFicheros = new HashMap();
            }
            this.mapaFicheros.put(n, file);
            this.getMapaExisteciaFicheros().put(n, true);
            this.setPartidaFichero(n, file.getAbsolutePath());
            boolean bl = true;
            String string = file.getName().substring(file.getName().lastIndexOf(".") + 1, file.getName().length());
            if (Declarantes.parseInt(n).equals(Declarantes.Declarante)) {
                if (!string.equalsIgnoreCase("dfp")) {
                    bl = false;
                }
            } else if (!string.equalsIgnoreCase("df")) {
                bl = false;
            }
            if (bl) {
                LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("ISO-8859-1")));
                LineNumberReader lineNumberReader2 = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("ISO-8859-1")));
                LineNumberReader lineNumberReader3 = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("ISO-8859-1")));
                this.iniciaTratamientoDatos(lineNumberReader, lineNumberReader2, lineNumberReader3, n);
                lineNumberReader.close();
                lineNumberReader = null;
                lineNumberReader2.close();
                lineNumberReader2 = null;
                lineNumberReader3.close();
                lineNumberReader3 = null;
            } else {
                System.out.println("\tERROR! Extensi\u00f3n de fichero incorrecta para " + Declarantes.parseInt(n).getNombreUnico());
                this.getMapaErroresPieza().put(n, "");
                this.setDatosCorrectos(n, false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (null != file) {
                file.setReadable(true);
                file.setWritable(true);
                file = null;
            }
        }
    }

    private void setPartidaFichero(Integer n, String string) throws Exception {
        string = string.replaceAll("\\\\", "/");
        string = string.toUpperCase();
        if (n == 10) {
            Aplicacion.getMotor().partidaModificada("DF_FICHERO_D", string);
        } else if (n == 20) {
            Aplicacion.getMotor().partidaModificada("DF_FICHERO_C", string);
        } else {
            int n2 = 1;
            int n3 = 30;
            while (n != n3) {
                n3 += 10;
                ++n2;
            }
            Aplicacion.getMotor().move(DatosGlobalesDF.getNombreTablaHRescritorio(), n2);
            Aplicacion.getMotor().partidaModificada("DF_FICHERO_HR", string);
        }
    }

    public void borrarFichero(Integer n) throws Exception {
        if (null == this.mapaFicheros) {
            this.mapaFicheros = new HashMap();
        }
        this.mapaFicheros.put(n, null);
        this.getMapaExisteciaFicheros().put(n, false);
        if (n < 30) {
            Aplicacion.getMotor().partidaModificada("DF_FICHERO_" + this.fDF.dameLetraDeclarante(n), "");
        } else {
            int n2 = 1;
            int n3 = 30;
            while (n2 <= Constantes.getNumhijosrentas()) {
                if (n == n3) {
                    Aplicacion.getMotor().move(DatosGlobalesDF.getNombreTablaHRescritorio(), n2);
                    Aplicacion.getMotor().partidaModificada("DF_FICHERO_HR", "");
                }
                ++n2;
                n3 += 10;
            }
            Aplicacion.getMotor().move(DatosGlobalesDF.getNombreTablaHRescritorio(), 1L);
        }
    }

    public File getFichero(Integer n) {
        if (null == this.mapaFicheros) {
            this.mapaFicheros = new HashMap();
        }
        if (this.mapaFicheros.containsKey(n)) {
            return this.mapaFicheros.get(n);
        }
        return null;
    }

    public String getNombreFichero(int n) {
        if (null == this.getFichero(n)) {
            return "";
        }
        return this.getFichero(n).getName();
    }

    public HashMap<Integer, Boolean> getMapaDatosCorrectos() {
        if (null == this.mapaDatosCorrectos) {
            this.mapaDatosCorrectos = new HashMap();
        }
        return this.mapaDatosCorrectos;
    }

    public boolean getTieneDatosCorrectos(Integer n) {
        if (null == this.mapaDatosCorrectos) {
            this.mapaDatosCorrectos = new HashMap();
        }
        return this.mapaDatosCorrectos.get(n);
    }

    public void setDatosCorrectos(Integer n, boolean bl) {
        if (null == this.mapaDatosCorrectos) {
            this.mapaDatosCorrectos = new HashMap();
        }
        this.mapaDatosCorrectos.put(n, bl);
    }

    public boolean hayDeclaracionIndividualSobrevenida() {
        return this.bDeclaracionIndividualSobrevenida;
    }

    public HashMap<Integer, String> getMapaErroresPieza() {
        if (null == this.mapaErroresPieza) {
            this.mapaErroresPieza = new HashMap();
            this.mapaErroresPieza.put(10, "");
            if (this.getMapaUnidadFamiliar().containsKey(20)) {
                this.mapaErroresPieza.put(20, "");
            }
            for (int i = 30; i < 150; i += 10) {
                if (!this.getMapaUnidadFamiliar().containsKey(i)) continue;
                this.mapaErroresPieza.put(i, "");
            }
        }
        return this.mapaErroresPieza;
    }

    public boolean getSalidaFuncionValidaDatosPersonales() {
        return this.bSalidaFuncionValidaDatosPersonales;
    }

    public HashMap<Integer, Boolean> getMapaDatosAzules() {
        if (null == this.mapaDatosAzules) {
            this.mapaDatosAzules = new HashMap();
        }
        return this.mapaDatosAzules;
    }

    public boolean getTieneDatosAzules(Integer n) {
        if (null == this.mapaDatosAzules) {
            this.mapaDatosAzules = new HashMap();
        }
        if (null == this.mapaDatosAzules.get(n)) {
            this.mapaDatosAzules.put(n, Boolean.FALSE);
        }
        return this.mapaDatosAzules.get(n);
    }

    public void setTieneDatosAzules(Integer n, boolean bl) {
        if (null == this.mapaDatosAzules) {
            this.mapaDatosAzules = new HashMap();
        }
        this.mapaDatosAzules.put(n, bl);
    }

    public HashMap<Integer, Boolean> getMapaPreguntasUrbana() {
        if (null == this.mapaPreguntasUrbana) {
            this.mapaPreguntasUrbana = new HashMap();
        }
        return this.mapaPreguntasUrbana;
    }

    public boolean getTienePreguntaUrbana(Integer n) {
        if (null == this.mapaPreguntasUrbana) {
            this.mapaPreguntasUrbana = new HashMap();
        }
        if (null == this.mapaPreguntasUrbana.get(n)) {
            this.mapaPreguntasUrbana.put(n, Boolean.FALSE);
        }
        return this.mapaPreguntasUrbana.get(n);
    }

    public void setTienePreguntaUrbana(Integer n, boolean bl) {
        if (null == this.mapaPreguntasUrbana) {
            this.mapaPreguntasUrbana = new HashMap();
        }
        this.mapaPreguntasUrbana.put(n, bl);
    }

    public boolean getRespuestaUrbana(Integer n) {
        return this.mapaRespuestasUrbana.get(n);
    }

    public void setRespuestaUrbana(Integer n, boolean bl) throws Exception {
        if (null == this.mapaRespuestasUrbana) {
            this.mapaRespuestasUrbana = new HashMap();
        }
        this.mapaRespuestasUrbana.put(n, bl);
    }

    public boolean getUrbanaPreguntada(Integer n) {
        if (null == this.mapaUrbanaPreguntada) {
            return false;
        }
        if (null == this.mapaUrbanaPreguntada.get(n)) {
            return false;
        }
        return this.mapaUrbanaPreguntada.get(n);
    }

    public void setUrbanaPreguntada(Integer n) {
        if (null == this.mapaUrbanaPreguntada) {
            this.mapaUrbanaPreguntada = new HashMap();
        }
        this.mapaUrbanaPreguntada.put(n, Boolean.TRUE);
    }

    public HashMap<Integer, Boolean> getMapaTrasladosRealizados() {
        if (null == this.mapaTrasladosRealizados) {
            this.mapaTrasladosRealizados = new HashMap();
        }
        return this.mapaTrasladosRealizados;
    }

    public boolean getMapaTrasladosRealizados(Integer n) {
        if (null == this.mapaTrasladosRealizados) {
            this.mapaTrasladosRealizados = new HashMap();
        }
        if (null == this.mapaTrasladosRealizados.get(n)) {
            this.mapaTrasladosRealizados.put(n, Boolean.FALSE);
        }
        return this.mapaTrasladosRealizados.get(n);
    }

    public boolean getRamasAbiertas() {
        return this.bRamasXMLabiertas;
    }

    public void setRamasAbiertas(boolean bl) {
        this.bRamasXMLabiertas = bl;
    }

    public void lanzarTrasladoUnDeclarante(TransformardorDF transformardorDF) throws Exception {
        int n = -1;
        this.fr.irDeclaracion(this.getDeclaranteActual());
        n = this.ejecutaTraslados(transformardorDF, this.getModoTraslado());
        if (n == 0) {
            Aplicacion.getMotor().partidaModificada("DF_FIN_" + this.fDF.dameLetraDeclarante(this.getDeclaranteActual()), "true");
            Aplicacion.getMotor().partidaModificada("DF_FICHERO_" + this.fDF.dameLetraDeclarante(this.getDeclaranteActual()), this.getNombreFichero(this.getDeclaranteActual().toInt()));
        } else {
            Aplicacion.getMotor().partidaModificada("DF_FIN_" + this.fDF.dameLetraDeclarante(this.getDeclaranteActual()), "true");
            Aplicacion.getMotor().partidaModificada("DF_FICHERO_" + this.fDF.dameLetraDeclarante(this.getDeclaranteActual()), this.getNombreFichero(this.getDeclaranteActual().toInt()));
        }
        if (this.getDeclaranteActual().toInt() == 10 && null != transformardorDF.seleccionaTabla("UR")) {
            this.getDG().setTablaURdeclarante(transformardorDF.seleccionaTabla("UR"));
            if (null != this.getTransformador(20)) {
                this.getTransformador(20).copiarCamposInmueblesComunesEnConyuge();
            }
        }
    }

    private int ejecutaTraslados(TransformardorDF transformardorDF, int n) throws Exception {
        String string = "";
        if (n == 1) {
            string = "ESCRITORIO";
        } else if (n == 2) {
            string = "WEB";
        }
        System.out.println("\nTrasladando datos para " + this.mDeclaranteActual.getNombreUnico() + ", en modo " + string + "...");
        String string2 = "";
        boolean bl = this.getAnalizador(10).hayAnulacionDatosPersonales();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this.tc = new TrasladoComunDF(this, this.mDeclaranteActual, n);
        for (int i = 0; i < this.getAnalizador(this.mDeclaranteActual.toInt()).getListaClavesPresentes().size(); ++i) {
            string2 = this.getAnalizador(this.mDeclaranteActual.toInt()).getListaClavesPresentes().get(i);
            if (null == transformardorDF.seleccionaTabla(string2)) continue;
            ++n5;
            if (!this.getAccesoDatos().esClaveTrasladable(string2) || this.conceptoInvalidadoEntero(string2)) continue;
            ++n3;
            boolean[] blArray = this.getMapaRegistrosMarcados(this.mDeclaranteActual.toInt(), string2);
            transformardorDF.limpiaNulosEnTabla(string2);
            String[][] stringArray = transformardorDF.seleccionaTabla(string2);
            if (this.fDF.hayAlgunMarcado(blArray)) {
                int n6 = -1;
                String string3 = "- Desconocido (-1)";
                try {
                    if (string2.equalsIgnoreCase("DI")) {
                        n6 = this.tc.ejecutaTrasladoDI(stringArray);
                    } else if (string2.equalsIgnoreCase("DG") && !bl) {
                        n6 = this.tc.ejecutaTrasladoDG(stringArray, blArray);
                    } else if (string2.equalsIgnoreCase("TI")) {
                        n6 = this.tc.ejecutaTrasladoTI(stringArray, blArray, bl);
                    } else if (string2.equalsIgnoreCase("DE") && !bl) {
                        n6 = this.tc.ejecutaTrasladoDE(stringArray, blArray);
                    } else if (string2.equalsIgnoreCase("AS") && !bl && n != 2) {
                        n6 = this.tc.ejecutaTrasladoAS(stringArray, blArray);
                    } else if (string2.equalsIgnoreCase("DOM")) {
                        n6 = this.tc.ejecutaTrasladoDOM(stringArray, blArray);
                    } else if (string2.equalsIgnoreCase("DEX")) {
                        n6 = this.tc.ejecutaTrasladoDEX(stringArray, blArray);
                    } else if (string2.equalsIgnoreCase("RTA")) {
                        n6 = this.tc.ejecutaTrasladoRTA(stringArray, blArray);
                    } else if (string2.equalsIgnoreCase("RTD")) {
                        n6 = this.tc.ejecutaTrasladoRTD(stringArray, blArray);
                    } else if (string2.equalsIgnoreCase("RTB")) {
                        n6 = this.tc.ejecutaTrasladoRTB(stringArray, blArray);
                    } else if (string2.equalsIgnoreCase("PP")) {
                        n6 = this.tc.ejecutaTrasladoPP(stringArray, this.getDG().getTablaTIdeclarante(), blArray);
                    } else if (string2.equalsIgnoreCase("EV")) {
                        n6 = this.tc.ejecutaTrasladoEV(stringArray, blArray);
                    } else if (string2.equalsIgnoreCase("CB")) {
                        n6 = this.tc.ejecutaTrasladoCB(stringArray, blArray);
                    } else if (string2.equalsIgnoreCase("LT")) {
                        n6 = this.tc.ejecutaTrasladoLT(stringArray, blArray);
                    } else if (string2.equalsIgnoreCase("FIE")) {
                        n6 = this.tc.ejecutaTrasladoFIE(stringArray, blArray);
                    } else if (string2.equalsIgnoreCase("REA")) {
                        n6 = this.tc.ejecutaTrasladoREA(stringArray, blArray);
                    } else if (string2.equalsIgnoreCase("REG")) {
                        n6 = this.tc.ejecutaTrasladoREG(stringArray, blArray);
                    } else if (string2.equalsIgnoreCase("RI")) {
                        n6 = this.tc.ejecutaTrasladoRI(stringArray, blArray);
                    } else if (string2.equalsIgnoreCase("SG")) {
                        n6 = this.tc.ejecutaTrasladoSG(stringArray, blArray);
                    } else if (string2.startsWith("EA")) {
                        if (!this.mDG.getMapaTrasladadosEAX(this.mDeclaranteActual.toInt())) {
                            n6 = this.tc.ejecutaTrasladoEAX(this.rellenaListaObjetosAtRentas(this.mDeclaranteActual.toInt()));
                            this.mDG.setMapaSeHaTrasladadoEAX(this.mDeclaranteActual.toInt(), true);
                        } else {
                            n6 = this.tc.trasOK();
                        }
                    } else if (string2.equalsIgnoreCase("DN")) {
                        n6 = this.tc.ejecutaTrasladoDN(stringArray, blArray);
                    } else if (string2.equalsIgnoreCase("PH")) {
                        n6 = this.tc.ejecutaTrasladoPH(stringArray, blArray);
                    } else if (string2.equalsIgnoreCase("PF")) {
                        n6 = this.tc.ejecutaTrasladoPF(stringArray, blArray);
                    } else if (string2.equalsIgnoreCase("UR")) {
                        n6 = this.tc.ejecutaTrasladoUR(stringArray, blArray);
                    } else if (string2.equalsIgnoreCase("DM")) {
                        n6 = this.tc.ejecutaTrasladoDM(stringArray, blArray);
                    } else if (string2.equalsIgnoreCase("CC")) {
                        n6 = this.tc.ejecutaTrasladoCC(stringArray, blArray);
                    } else if (string2.equalsIgnoreCase("RTC")) {
                        n6 = this.tc.ejecutaTrasladoRTC(stringArray, blArray);
                    } else if (string2.equalsIgnoreCase("IP")) {
                        n6 = this.tc.ejecutaTrasladoIP(stringArray, blArray);
                    } else if (string2.equalsIgnoreCase("TV")) {
                        n6 = this.tc.ejecutaTrasladoTV(stringArray, blArray);
                    } else {
                        string3 = "- Clave no contemplada";
                    }
                    if (n6 >= 0) {
                        if (string2.toString().length() == 2) {
                            System.out.println("\t" + string2 + " -----> Trasladado ok!");
                        } else {
                            System.out.println("\t" + string2 + "-----> Trasladado ok!");
                        }
                        ++n2;
                        continue;
                    }
                    if (n6 >= 0) continue;
                    ++n4;
                    if (string2.toString().length() == 2) {
                        System.out.println("\t" + string2 + " --------> Error!!!! " + string3);
                        continue;
                    }
                    System.out.println("\t" + string2 + "--------> Error!!!! " + string3);
                }
                catch (Exception exception) {
                    System.out.println("Error trasladando clave " + string2);
                    exception.printStackTrace();
                }
                continue;
            }
            if (string2.toString().length() == 2) {
                System.out.println("\t" + string2 + " -----> No hay traslado");
                continue;
            }
            System.out.println("\t" + string2 + "-----> No hay traslado");
        }
        System.out.println("Resumen traslados para " + this.mDeclaranteActual.getNombreUnico() + ", en modo " + string + ":\n\t" + "Total " + n5 + " conceptos encontrados, " + n3 + " trasladables: \n\t\t" + n2 + " trasladados ok, " + n4 + " con errores.\n");
        if (n4 == 0) {
            return 0;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lanzarTrasladoCompletoUnidadFamiliar() throws Exception {
        try {
            for (int i = 10; i < 150; i += 10) {
                if (!this.getMapaDatosCorrectos().containsKey(i) || !this.getMapaDatosCorrectos().get(i).booleanValue() || this.getMapaTrasladosRealizados(i)) continue;
                this.setDeclarante(Declarantes.parseInt(i));
                this.generaMapasRegistrosMarcados(i);
                this.lanzarTrasladoUnDeclarante(this.getTransformador(i));
                this.getMapaTrasladosRealizados().put(i, Boolean.TRUE);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.setDeclarante(Declarantes.Declarante);
        }
    }

    public void terminarDatosFiscalesRentaWeb() throws Exception {
        this.ultimasOperacionesDF();
        this.lanzaCaluclosYValidaciones();
        this.trasladarIBAN();
        this.guardarDatosFiscales();
        FuncionesRentaComun funcionesRentaComun = new FuncionesRentaComun();
        Declarantes declarantes = funcionesRentaComun.cualDeclaracion();
        funcionesRentaComun.irDeclaracion(Declarantes.Declarante);
        funcionesRentaComun.habilitarOtroProgenitor();
        if (FuncionesRentaComun.isBConyuge()) {
            funcionesRentaComun.irDeclaracion(Declarantes.Conyuge);
            funcionesRentaComun.habilitarOtroProgenitor();
        }
        if (FuncionesRentaComun.isBConjunta()) {
            funcionesRentaComun.irDeclaracion(Declarantes.UnidadFamiliar);
            funcionesRentaComun.habilitarOtroProgenitor();
        }
        funcionesRentaComun.irDeclaracion(declarantes);
        new TrasladosDatosPersonales().trasladarADeclaracion();
        ValidacionesAnxB4 validacionesAnxB4 = new ValidacionesAnxB4();
        validacionesAnxB4.comprobarMaternidadValencia();
    }

    public void construirUnidadFamiliar() throws Exception {
        int n;
        this.getMapaUnidadFamiliar().clear();
        boolean bl = Boolean.parseBoolean(Aplicacion.getMotor().obtenerPartidaString("DF_INDV"));
        this.getDG().setIndvOriginal(bl);
        String string = "DF_NIF_D";
        String string2 = "DF_APE1_D";
        String string3 = "DF_NIF_C";
        String string4 = "DF_APE1_C";
        if (this.getModoTraslado() == 2) {
            string = "DPNIF_D";
            string2 = "DPAPE1_D";
            string3 = "DPNIF_C";
            string4 = "DPAPE1_C";
        }
        boolean bl2 = !Aplicacion.getMotor().obtenerPartidaString(string3).equalsIgnoreCase("");
        Aplicacion.getMotor().establecerEstado("DF_NIF_D", 254);
        Aplicacion.getMotor().establecerEstado("DF_NIF_C", 254);
        this.getMapaUnidadFamiliar().put(10, Aplicacion.getMotor().obtenerPartidaString(string));
        this.getMapaApellidosUnidadFamiliar().put(10, Aplicacion.getMotor().obtenerPartidaString(string2));
        if (bl2 && !bl) {
            this.getMapaUnidadFamiliar().put(20, Aplicacion.getMotor().obtenerPartidaString(string3));
            this.getMapaApellidosUnidadFamiliar().put(20, Aplicacion.getMotor().obtenerPartidaString(string4));
        }
        String string5 = "";
        String string6 = "";
        String string7 = "";
        if (this.getModoTraslado() == 1) {
            string5 = DatosGlobalesDF.getNombreTablaHRescritorio();
            string6 = "DF_NIF_HR";
            string7 = "DF_APE_HR";
        } else if (this.getModoTraslado() == 2) {
            string5 = DatosGlobalesDF.getNombreTablaMenoresWeb();
            string6 = "NIFHMEN";
            string7 = "APE1HMEN";
        }
        int n2 = 1;
        for (n = 1; n <= Constantes.getNumhijosrentas(); ++n) {
            if ((long)n2 > Aplicacion.getMotor().recordCount(string5)) continue;
            Aplicacion.getMotor().move(string5, n2);
            if ("".equals(Aplicacion.getMotor().obtenerPartidaString(string6)) && "".equals(Aplicacion.getMotor().obtenerPartidaString(string7))) {
                Aplicacion.getMotor().borrarRegistro(string5);
                continue;
            }
            ++n2;
        }
        n = 0;
        if (!bl) {
            n2 = 30;
            int n3 = 1;
            while ((long)n3 <= Aplicacion.getMotor().recordCount(string5)) {
                Aplicacion.getMotor().move(string5, n3);
                String string8 = Aplicacion.getMotor().obtenerPartidaString(string6);
                String string9 = Aplicacion.getMotor().obtenerPartidaString(string7);
                if (this.getModoTraslado() != 2 || this.getModoTraslado() == 2 && "1".equals(Aplicacion.getMotor().obtenerPartidaString("RENTASHMEN"))) {
                    this.getMapaUnidadFamiliar().put(n2, string8);
                    this.getMapaApellidosUnidadFamiliar().put(n2, string9);
                    if (!this.getMapaAnalizadores().containsKey(n2)) {
                        this.getMapaAnalizadores().put(n2, null);
                    }
                    if (!this.getMapaTransformadores().containsKey(n2)) {
                        this.getMapaTransformadores().put(n2, null);
                    }
                    if (!this.getMapaDatosCorrectos().containsKey(n2)) {
                        this.getMapaDatosCorrectos().put(n2, Boolean.FALSE);
                    }
                    this.getDG().setNifOriginalH(string8, n3);
                    ++n;
                    n2 += 10;
                }
                Aplicacion.getMotor().establecerEstado(string6, 254);
                ++n3;
            }
        }
        this.setNumHRdeclarados(n);
        if (n > 0) {
            Aplicacion.getMotor().move(string5, 1L);
        }
        this.setSeHaDeclaradoConyuge(bl2);
    }

    public void iniciaTratamientoDatos(LineNumberReader lineNumberReader, LineNumberReader lineNumberReader2, LineNumberReader lineNumberReader3, int n) throws Exception {
        AnalizadorDF analizadorDF = new AnalizadorDF(lineNumberReader, Declarantes.parseInt(n), this);
        this.setAnalizador(analizadorDF, n);
        int n2 = this.getAnalizador(n).analisisEstructuraDatos();
        if (n2 != 0) {
            if (n2 == -4) {
                System.out.println("ERROR: NIF no coincide!");
            } else {
                System.out.println("ERROR! Estructura incorrecta para " + Declarantes.parseInt(n).getNombreUnico());
            }
            this.getMapaErroresPieza().put(n, "");
            this.setDatosCorrectos(n, false);
        } else {
            System.out.println("\tEstructura correcta");
            this.setDatosCorrectos(n, true);
            this.transformaDatos(lineNumberReader2, lineNumberReader3, n);
            this.getAnalizador(n).setTrans(this.getTransformador(n));
            if (this.getModoTraslado() == 2) {
                this.getAnalizador(n).analisisTrasladoWeb();
            }
            if (this.getModoTraslado() == 1 && n == 10) {
                this.getAnalizador(10).analisisDatosPersonales();
                System.out.println(this.getAnalizador(10).informeAnalisisDatosPersonales());
                if (this.getAnalizador(10).hayDeclaracionIndividualSobrevenida()) {
                    this.declaracionIndividualSobrevenida();
                }
                if (this.getAnalizador(10).hayAnulacionDatosPersonales()) {
                    System.out.println(this.getAnalizador(10).getPorqueHayAnulacionDatosPersonales());
                }
            }
        }
    }

    private void transformaDatos(LineNumberReader lineNumberReader, LineNumberReader lineNumberReader2, int n) throws Exception {
        TransformardorDF transformardorDF = new TransformardorDF(lineNumberReader, lineNumberReader2, Declarantes.parseInt(n), this.getAccesoDatos(), this.getDG());
        this.setTransformador(transformardorDF, n);
    }

    private void declaracionIndividualSobrevenida() throws Exception {
        int n;
        this.bDeclaracionIndividualSobrevenida = true;
        Aplicacion.getMotor().partidaModificada("INDV", "true");
        if (Boolean.parseBoolean(Aplicacion.getMotor().obtenerPartidaString("DF_TRAS_C"))) {
            Aplicacion.getMotor().partidaModificada("DF_TRAS_C", "false");
        }
        for (n = 1; n <= this.numHRdeclarados; ++n) {
            Aplicacion.getMotor().move(DatosGlobalesDF.getNombreTablaHRescritorio(), n);
            Aplicacion.getMotor().partidaModificada("DF_TRAS_HR", "false");
            Aplicacion.getMotor().partidaModificada("DF_FIN_HR", "true");
            Aplicacion.getMotor().borrarRegistro(DatosGlobalesDF.getNombreTablaHRescritorio());
        }
        this.numHRdeclarados = 0;
        for (n = 20; n < 150; n += 10) {
            if (this.getMapaUnidadFamiliar().containsKey(n)) {
                this.getMapaUnidadFamiliar().remove(n);
            }
            if (this.mapaAnalizadores.containsKey(n)) {
                this.mapaAnalizadores.remove(n);
            }
            if (this.mapaApellidosUF.containsKey(n)) {
                this.mapaApellidosUF.remove(n);
            }
            if (this.mapaFicheros.containsKey(n)) {
                this.mapaFicheros.remove(n);
            }
            if (this.getMapaExisteciaFicheros().containsKey(n)) {
                this.getMapaExisteciaFicheros().remove(n);
            }
            if (this.getMapaDatosCorrectos().containsKey(n)) {
                this.getMapaDatosCorrectos().remove(n);
            }
            if (!this.mapaTransformadores.containsKey(n)) continue;
            this.mapaTransformadores.remove(n);
        }
        String string = "";
        if (this.getAnalizador(10).hayCaso3()) {
            string = JMensajesProperties.dameMensaje("DFP_FAL");
            JMensajesProperties jMensajesProperties = new JMensajesProperties(string, true);
            jMensajesProperties.muestraMensaje();
        }
    }

    public void initMotoresyXML(int n) {
        if (n != 10) {
            try {
                if (n == 20) {
                    if (!Aplicacion.getMotor().existsPtr("CONYUGE")) {
                        Aplicacion.getMotor().anniadirRegistro(Constantes.getImpuesto() + Constantes.getEjercicioString());
                        Aplicacion.getMotor().establecerPartida("TITULAR", "CONYUGE");
                        if (!FuncionesRenta.isBConyuge()) {
                            FuncionesRenta.setBConyuge(true);
                        }
                    }
                } else if (n > 20 && n < 150) {
                    int n2 = this.fDF.dameNumeroHijoQueToca(n);
                    String string = "HIJO" + String.valueOf(n2);
                    if (!Aplicacion.getMotor().existsPtr(string)) {
                        Aplicacion.getMotor().anniadirRegistro(Constantes.getImpuesto() + Constantes.getEjercicioString());
                        Aplicacion.getMotor().establecerPartida("TITULAR", string);
                        FuncionesRenta.setBHijos(true, n2);
                    }
                } else if (n == 150 && !Aplicacion.getMotor().existsPtr("CONJUNTA")) {
                    Aplicacion.getMotor().anniadirRegistro(Constantes.getImpuesto() + Constantes.getEjercicioString());
                    Aplicacion.getMotor().establecerPartida("TITULAR", "CONJUNTA");
                    if (!FuncionesRenta.isBConjunta()) {
                        FuncionesRenta.setBConjunta(true);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void lanzaCaluclosYValidaciones() throws Exception {
        if (!Boolean.parseBoolean(Aplicacion.getMotor().obtenerPartidaString("ENTORNOWEB"))) {
            Object object = Aplicacion.getMotor().ejecutarFuncion("calculoRenta", new Object[]{"ValidacionesDatosPersonales", "validaDatosPersonales"});
            this.bSalidaFuncionValidaDatosPersonales = (Boolean)object;
        }
        Aplicacion.getMotor().ejecutarFuncion("calculoRenta", new Object[]{"CalculosRenta", "calculaRenta"});
    }

    public void ultimasOperacionesDF() throws Exception {
        int n;
        boolean bl = Boolean.parseBoolean(Aplicacion.getMotor().obtenerPartidaString("INDV"));
        this.fr.irDeclaracion(Declarantes.Declarante);
        this.fr.habilitarOtroProgenitor();
        this.fr.irDeclaracion(Declarantes.Declarante);
        if (FuncionesRenta.isBConyuge()) {
            Aplicacion.getMotor().partidaModificada("ECIVIL", Aplicacion.getString("JDlgAceptacionDatosPersonales.3").toUpperCase());
            Aplicacion.getMotor().partidaModificada("ECIVILC", "2");
            if (this.getModoTraslado() != 2) {
                Aplicacion.getMotor().partidaModificada("DPNIF_C", Aplicacion.getMotor().obtenerPartidaString("DF_NIF_C"));
            }
            if (!bl) {
                this.trasladarVivHabComunes();
                this.cruzarPorcentajesViviendaHabitual();
                Declarantes declarantes = this.fr.cualDeclaracion();
                this.fr.irDeclaracion(Declarantes.Conyuge);
                this.fr.habilitarOtroProgenitor();
                this.fr.irDeclaracion(declarantes);
            }
        }
        if (this.getDG().getRAOC(Declarantes.Declarante) > 0.0) {
            Aplicacion.getMotor().partidaModificada("RAOC", this.getDG().getRAOC(Declarantes.Declarante));
        }
        if (this.getDG().getRAOCP(Declarantes.Declarante) > 0.0) {
            Aplicacion.getMotor().partidaModificada("RAOCP", this.getDG().getRAOC(Declarantes.Declarante));
        }
        if (this.getDG().getRAOC(Declarantes.Conyuge) > 0.0 && FuncionesRenta.isBConyuge()) {
            this.fr.irDeclaracion(Declarantes.Conyuge);
            Aplicacion.getMotor().partidaModificada("RAOC", this.getDG().getRAOC(Declarantes.Conyuge));
            this.fr.irDeclaracion(Declarantes.Declarante);
        }
        if (this.getDG().getRAOCP(Declarantes.Conyuge) > 0.0 && FuncionesRenta.isBConyuge()) {
            this.fr.irDeclaracion(Declarantes.Conyuge);
            Aplicacion.getMotor().partidaModificada("RAOCP", this.getDG().getRAOCP(Declarantes.Conyuge));
            this.fr.irDeclaracion(Declarantes.Declarante);
        }
        if (bl) {
            Aplicacion.getMotor().partidaModificada("HIJREN", "0");
            Aplicacion.getMotor().partidaModificada("PH18", "-1");
        } else {
            if (this.getModoTraslado() != 2 && !Aplicacion.getMotor().obtenerPartidaString("PH18").equals(Aplicacion.getMotor().obtenerPartidaString("DF_PH18"))) {
                Aplicacion.getMotor().partidaModificada("PH18", Aplicacion.getMotor().obtenerPartidaString("DF_PH18"));
            }
            if (this.getNumHRdeclarados() > 0) {
                Aplicacion.getMotor().establecerPartida("HIJREN", String.valueOf(this.getNumHRdeclarados()));
            }
        }
        this.fr.irDeclaracion(Declarantes.Declarante);
        if (FuncionesRentaComun.isBConjunta()) {
            this.fDF.copiarViviendaAConjunta();
        }
        if (Aplicacion.getMotor().obtenerEstadoPartida("CAOD") == 255 && !this.getAnalizador(10).hayAnulacionDatosPersonales()) {
            Aplicacion.getMotor().partidaModificada("CAOC", Aplicacion.getMotor().obtenerPartidaString("CAC_D"));
            Aplicacion.getMotor().partidaModificada("CAOD", Aplicacion.getMotor().obtenerPartidaString("CAD_D"));
        }
        if (!bl && this.getNumHRdeclarados() > 0) {
            Aplicacion.getMotor().move(DatosGlobalesDF.getNombreTablaHRescritorio(), 1L);
            this.fr.copiaHijosPag2();
        }
        this.fr.irDeclaracion(Declarantes.Declarante);
        for (n = 10; n < 150; n += 10) {
            if (!this.mapaDatosCorrectos.containsKey(n) || !this.mapaDatosCorrectos.get(n).booleanValue() || null == this.getTransformador(n).seleccionaTabla("DOM") && null == this.getTransformador(n).seleccionaTabla("DEX")) continue;
            this.fDF.copiarDomDF(true, Declarantes.parseInt(n));
        }
        this.fr.irDeclaracion(Declarantes.Declarante);
        n = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = "";
        if (null != this.mDG.getTablaTIdeclarante()) {
            n = "1".equals(this.mDG.getTablaTIdeclarante()[0][this.mDG.getColumnasTI().get("PrViLa")]) ? 1 : 0;
            bl2 = "1".equals(this.mDG.getTablaTIdeclarante()[0][this.mDG.getColumnasTI().get("MobGeo")]);
            string = this.mDG.getTablaTIdeclarante()[0][this.mDG.getColumnasTI().get("TrAcDis")];
            boolean bl4 = bl3 = !"".equals(string) && !" ".equals(string) && !"0".equals(string);
            if (n != 0 || bl2 || bl3) {
                this.fr.irDeclaracion(Declarantes.Declarante);
                if (n != 0) {
                    Aplicacion.getMotor().partidaModificada("PALDLG", "true");
                }
                if (bl2) {
                    Aplicacion.getMotor().partidaModificada("MGDLG", "true");
                }
                if (bl3) {
                    if (string.equalsIgnoreCase("3")) {
                        Aplicacion.getMotor().partidaModificada("TADDLG", "2");
                    } else {
                        Aplicacion.getMotor().partidaModificada("TADDLG", string);
                    }
                }
            }
            if (FuncionesRenta.isBConyuge() && this.mDG.hayLineaConyuge()) {
                n = "1".equals(this.mDG.getTablaTIdeclarante()[1][this.mDG.getColumnasTI().get("PrViLa")]) ? 1 : 0;
                bl2 = "1".equals(this.mDG.getTablaTIdeclarante()[1][this.mDG.getColumnasTI().get("MobGeo")]);
                string = this.mDG.getTablaTIdeclarante()[1][this.mDG.getColumnasTI().get("TrAcDis")];
                boolean bl5 = bl3 = !"".equals(string) && !" ".equals(string) && !"0".equals(string);
                if (n != 0 || bl2 || bl3) {
                    this.fr.irDeclaracion(Declarantes.Conyuge);
                    if (n != 0) {
                        Aplicacion.getMotor().partidaModificada("PALDLG", "true");
                    }
                    if (bl2) {
                        Aplicacion.getMotor().partidaModificada("MGDLG", "true");
                    }
                    if (bl3) {
                        if (string.equalsIgnoreCase("3")) {
                            Aplicacion.getMotor().partidaModificada("TADDLG", "2");
                        } else {
                            Aplicacion.getMotor().partidaModificada("TADDLG", string);
                        }
                    }
                }
            }
        }
        if (this.getNumHRdeclarados() > 0) {
            int n2 = 30;
            long l = Aplicacion.getMotor().obtenerClaveActiva("DESCENDIENTESRENTAS");
            int n3 = 1;
            while ((long)n3 <= Aplicacion.getMotor().recordCount("DESCENDIENTESRENTAS")) {
                if (FuncionesRenta.isBHijos(n3)) {
                    Aplicacion.getMotor().move("DESCENDIENTESRENTAS", n3);
                    String string2 = Aplicacion.getMotor().obtenerPartidaString("NIFHR");
                    for (int i = 0; i < this.mDG.getTablaDE().length; ++i) {
                        String string3 = this.mDG.getTablaDE()[i][this.mDG.getColumnasDE().get("NIF")];
                        if (!string3.equals(string2)) continue;
                        bl2 = "1".equals(this.mDG.getTablaDE()[i][this.mDG.getColumnasDE().get("MobGeo")]);
                        string = this.mDG.getTablaDE()[i][this.mDG.getColumnasDE().get("TrAcDis")];
                        boolean bl6 = bl3 = !"".equals(string) && !" ".equals(string) && !"0".equals(string);
                        if (!bl2 && !bl3) break;
                        this.fr.irDeclaracion(Declarantes.parseInt(n2));
                        n2 += 10;
                        if (bl2) {
                            Aplicacion.getMotor().partidaModificada("MGDLG", "true");
                        }
                        if (!bl3) break;
                        if (string.equalsIgnoreCase("3")) {
                            Aplicacion.getMotor().partidaModificada("TADDLG", "2");
                            break;
                        }
                        Aplicacion.getMotor().partidaModificada("TADDLG", string);
                        break;
                    }
                }
                ++n3;
            }
            Aplicacion.getMotor().move("DESCENDIENTESRENTAS", l);
        }
        this.fr.irDeclaracion(Declarantes.Declarante);
    }

    public void trasladarIBAN() throws Exception {
        String string = Aplicacion.getMotor().obtenerPartidaString("DF_CCC_D");
        String string2 = Aplicacion.getMotor().obtenerPartidaString("DF_CCC_C");
        String string3 = "";
        if (this.getModoTraslado() == 1) {
            string3 = "Y81";
        } else if (this.getModoTraslado() == 2) {
            string3 = "T1_CUENTACORRIENTE";
        }
        if (!"".equals(string) || !"".equals(string2)) {
            if (!"".equals(string) && Double.parseDouble(Aplicacion.getMotor().obtenerPartidaString("RESINGDEV")) != 0.0) {
                Aplicacion.getMotor().partidaModificada(string3, string);
            }
            if (FuncionesRenta.isBConyuge()) {
                this.fr.irDeclaracion(Declarantes.Conyuge);
                if (!"".equals(string2) && Double.parseDouble(Aplicacion.getMotor().obtenerPartidaString("RESINGDEV")) != 0.0) {
                    Aplicacion.getMotor().partidaModificada(string3, string2);
                }
                this.fr.irDeclaracion(Declarantes.Declarante);
            }
        }
    }

    private void trasladarVivHabComunes() throws Exception {
        if (!this.getDG().getListaInmueblesHabitualesRespuestaSi().isEmpty()) {
            this.fr.irDeclaracion(Declarantes.Conyuge);
            for (int i = 0; i < this.getDG().getListaInmueblesHabitualesRespuestaSi().size(); ++i) {
                double d;
                double d2;
                double d3;
                String string = this.getDG().getListaInmueblesHabitualesRespuestaSi().get(i)[this.getDG().getColumnasUR().get("RefCat")];
                try {
                    d3 = Double.parseDouble(this.getDG().getListaInmueblesHabitualesRespuestaSi().get(i)[this.getDG().getColumnasUR().get("PorcParticip")]);
                }
                catch (Exception exception) {
                    d3 = 0.0;
                }
                try {
                    d2 = Double.parseDouble(this.getDG().getListaInmueblesHabitualesRespuestaSi().get(i)[this.getDG().getColumnasUR().get("PorcPc")]);
                }
                catch (Exception exception) {
                    d2 = 0.0;
                }
                try {
                    d = Double.parseDouble(this.getDG().getListaInmueblesHabitualesRespuestaSi().get(i)[this.getDG().getColumnasUR().get("PorcUsu")]);
                }
                catch (Exception exception) {
                    d = 0.0;
                }
                double d4 = d3;
                String string2 = this.getDG().getListaInmueblesHabitualesRespuestaSi().get(i)[this.getDG().getColumnasUR().get("Situacion")];
                String string3 = this.getDG().getListaInmueblesHabitualesRespuestaSi().get(i)[this.getDG().getColumnasUR().get("CodDer")];
                String string4 = "";
                if (string3.equalsIgnoreCase("PR")) {
                    d4 = d2;
                    string4 = "1";
                } else if (string3.equalsIgnoreCase("US")) {
                    d4 = d;
                    string4 = "2";
                } else if (string3.equalsIgnoreCase("CA") || string3.equalsIgnoreCase("DS") || string3.equalsIgnoreCase("NP")) {
                    string4 = "4";
                }
                int n = this.fDF.dameIndiceSiguienteInmueble(Declarantes.Conyuge);
                if (0 >= n || n > 8) continue;
                String string5 = String.valueOf(n);
                Aplicacion.getMotor().partidaModificada("ZT" + string5 + "DLG", string4);
                if (!"4".equals(string4)) {
                    Aplicacion.getMotor().partidaModificada("PORD" + string5 + "DLG", d4);
                }
                Aplicacion.getMotor().partidaModificada("SIT" + string5 + "DLG", string2);
                if ("1".equals(string2) || "2".equals(string2)) {
                    Aplicacion.getMotor().establecerPartida("RFC" + string5 + "DLG", string);
                }
                Aplicacion.getMotor().partidaModificada("ZT" + string5, string4);
                if (!"4".equals(string4)) {
                    Aplicacion.getMotor().partidaModificada("PORD" + string5, Aplicacion.getMotor().obtenerPartidaString("PORD" + string5 + "DLG"));
                }
                Aplicacion.getMotor().partidaModificada("SIT" + string5, string2);
                if (!"1".equals(string2) && !"2".equals(string2)) continue;
                Aplicacion.getMotor().establecerPartida("RFC" + string5, string);
            }
        }
        this.fr.irDeclaracion(Declarantes.Declarante);
    }

    private void cruzarPorcentajesViviendaHabitual() throws Exception {
        String string = "";
        String string2 = "";
        Double d = 0.0;
        Double d2 = 0.0;
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        Declarantes declarantes = Declarantes.Declarante;
        Declarantes declarantes2 = Declarantes.Conyuge;
        block0: for (int i = 1; i <= 8; ++i) {
            this.fr.irDeclaracion(declarantes);
            string5 = String.valueOf(i);
            string3 = string5 + "DLG";
            string = Aplicacion.getMotor().obtenerPartidaString("RFC" + string3);
            d = Double.parseDouble(Aplicacion.getMotor().obtenerPartidaString("PORD" + string3));
            for (int j = 1; j <= 8; ++j) {
                this.fr.irDeclaracion(declarantes2);
                string6 = String.valueOf(j);
                string4 = string6 + "DLG";
                string2 = Aplicacion.getMotor().obtenerPartidaString("RFC" + string4);
                d2 = Double.parseDouble(Aplicacion.getMotor().obtenerPartidaString("PORD" + string4));
                if (!string.equals(string2) || !d.equals(d2)) continue;
                Aplicacion.getMotor().partidaModificada("PORC" + string4, d);
                Aplicacion.getMotor().partidaModificada("PORC" + string6, d);
                this.fr.irDeclaracion(declarantes);
                Aplicacion.getMotor().partidaModificada("PORC" + string3, d2);
                Aplicacion.getMotor().partidaModificada("PORC" + string5, d2);
                continue block0;
            }
        }
        this.fr.irDeclaracion(Declarantes.Declarante);
    }

    public void arreglarHijosConRentasNoValidos() throws Exception {
        int n;
        int n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (n = 30; n < 150; n += 10) {
            if (!this.getMapaUnidadFamiliar().containsKey(n)) continue;
            ++n2;
        }
        if (n2 > 0) {
            for (n = 30; n < 150; n += 10) {
                if (!this.getMapaUnidadFamiliar().containsKey(n) || !this.mDG.getMapaValidacionesHR().containsKey(this.getMapaUnidadFamiliar().get(n))) continue;
                if (this.mDG.getMapaValidacionesHR().get(this.getMapaUnidadFamiliar().get(n)).booleanValue()) {
                    arrayList2.add(n);
                    continue;
                }
                if (this.mDG.getMapaValidacionesHR().get(this.getMapaUnidadFamiliar().get(n)).booleanValue()) continue;
                arrayList.add(n);
            }
        }
        n = n2 - arrayList.size();
        if (arrayList.size() > 0) {
            if (arrayList2.size() == 0) {
                for (int i = 30; i < 150; i += 10) {
                    if (!this.getMapaUnidadFamiliar().containsKey(i)) continue;
                    this.borrarHijo(i);
                }
            } else {
                int n3;
                int n4;
                boolean bl = true;
                ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                while (bl) {
                    arrayList3 = new ArrayList();
                    for (n4 = 30; n4 < 70; n4 += 10) {
                        if (arrayList2.contains(n4)) continue;
                        arrayList3.add(n4);
                        bl = true;
                    }
                    if (arrayList3.size() == 0) {
                        bl = false;
                    }
                    if (!bl) continue;
                    n4 = this.primerHijoParaMover(arrayList2);
                    if (n4 <= 0) break;
                    this.correrHijo(n4, (Integer)arrayList3.get(0));
                    arrayList2.remove(new Integer(n4));
                    arrayList2.add((Integer)arrayList3.get(0));
                    arrayList3.remove(0);
                }
                for (n3 = n4 = 30 + 10 * n; n3 < 150; n3 += 10) {
                    this.borrarHijo(n3);
                }
                for (n3 = 0; n3 < n2 - n; ++n3) {
                    Aplicacion.getMotor().move(DatosGlobalesDF.getNombreTablaHRescritorio(), Aplicacion.getMotor().recordCount(DatosGlobalesDF.getNombreTablaHRescritorio()));
                    Aplicacion.getMotor().borrarRegistro(DatosGlobalesDF.getNombreTablaHRescritorio());
                }
            }
        }
        this.setNumHRdeclarados(n);
    }

    private int primerHijoParaMover(ArrayList<Integer> arrayList) {
        int n = 0;
        for (int i = 30; i < 70; i += 10) {
            try {
                if (n < arrayList.size() && arrayList.get(n) != i) {
                    return arrayList.get(n);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return 0;
            }
            ++n;
        }
        return 0;
    }

    private void borrarHijo(int n) throws Exception {
        if (this.mapaUF.containsKey(n)) {
            this.mapaUF.remove(n);
        }
        if (this.mapaAnalizadores.containsKey(n)) {
            this.mapaAnalizadores.remove(n);
        }
        if (this.mapaApellidosUF.containsKey(n)) {
            this.mapaApellidosUF.remove(n);
        }
        if (this.mapaDatosCorrectos.containsKey(n)) {
            this.mapaDatosCorrectos.remove(n);
            this.borrarFichero(n);
        }
        if (this.mapaTransformadores.containsKey(n)) {
            this.mapaTransformadores.remove(n);
        }
    }

    private void correrHijo(int n, int n2) throws Exception {
        if (null != this.mapaUF.get(n)) {
            this.mapaUF.put(n2, this.getMapaUnidadFamiliar().get(n));
            this.mapaUF.remove(n);
        }
        if (null != this.mapaAnalizadores.get(n)) {
            this.mapaAnalizadores.put(n2, this.mapaAnalizadores.get(n));
            this.mapaAnalizadores.remove(n);
        }
        if (null != this.mapaApellidosUF.get(n)) {
            this.mapaApellidosUF.put(n2, this.mapaApellidosUF.get(n));
            this.mapaApellidosUF.remove(n);
        }
        if (null != this.mapaDatosCorrectos.get(n)) {
            this.mapaDatosCorrectos.put(n2, this.mapaDatosCorrectos.get(n));
            this.mapaDatosCorrectos.remove(n);
        }
        if (null != this.mapaExistenciaFicheros.get(n)) {
            this.mapaExistenciaFicheros.put(n2, this.mapaExistenciaFicheros.get(n));
            this.mapaExistenciaFicheros.remove(n);
        }
        if (null != this.mapaFicheros.get(n)) {
            this.mapaFicheros.put(n2, this.mapaFicheros.get(n));
            this.mapaFicheros.remove(n);
        }
        if (null != this.mapaTransformadores.get(n)) {
            this.mapaTransformadores.put(n2, this.mapaTransformadores.get(n));
            this.mapaTransformadores.remove(n);
        }
        int n3 = n / 10 - 2;
        int n4 = n2 / 10 - 2;
        Aplicacion.getMotor().move(DatosGlobalesDF.getNombreTablaHRescritorio(), n3);
        boolean bl = Boolean.parseBoolean(Aplicacion.getMotor().obtenerPartidaString("DF_HOMBRE_HR"));
        boolean bl2 = Boolean.parseBoolean(Aplicacion.getMotor().obtenerPartidaString("DF_MUJER_HR"));
        boolean bl3 = Boolean.parseBoolean(Aplicacion.getMotor().obtenerPartidaString("DF_TRAS_HR"));
        boolean bl4 = Boolean.parseBoolean(Aplicacion.getMotor().obtenerPartidaString("DF_FIN_HR"));
        String string = Aplicacion.getMotor().obtenerPartidaString("DF_FICHERO_HR");
        String string2 = Aplicacion.getMotor().obtenerPartidaString("DF_NIF_HR");
        String string3 = Aplicacion.getMotor().obtenerPartidaString("DF_APE_HR");
        Aplicacion.getMotor().move(DatosGlobalesDF.getNombreTablaHRescritorio(), n4);
        Aplicacion.getMotor().partidaModificada("DF_NIF_HR", string2);
        Aplicacion.getMotor().partidaModificada("DF_APE_HR", string3);
        if (bl) {
            Aplicacion.getMotor().partidaModificada("DF_HOMBRE_HR", "true");
            Aplicacion.getMotor().partidaModificada("DF_MUJER_HR", "false");
        } else if (bl2) {
            Aplicacion.getMotor().partidaModificada("DF_HOMBRE_HR", "false");
            Aplicacion.getMotor().partidaModificada("DF_MUJER_HR", "true");
        }
        if (bl3) {
            Aplicacion.getMotor().partidaModificada("DF_TRAS_HR", "true");
            Aplicacion.getMotor().partidaModificada("DF_FIN_HR", "false");
        }
        if (bl4) {
            Aplicacion.getMotor().partidaModificada("DF_TRAS_HR", "false");
            Aplicacion.getMotor().partidaModificada("DF_FIN_HR", "true");
        }
        Aplicacion.getMotor().partidaModificada("DF_FICHERO_HR", string);
    }

    public void abirRamasXML() throws Exception {
        boolean bl = Boolean.parseBoolean(Aplicacion.getMotor().obtenerPartidaString("INDV"));
        boolean bl2 = Aplicacion.getMotor().obtenerPartidaString("DF_PH18").equals("1");
        boolean bl3 = !bl && bl2;
        this.initMotoresyXML(10);
        if (!bl && this.getMapaUnidadFamiliar().containsKey(20)) {
            this.initMotoresyXML(20);
            if (!bl3) {
                bl3 = true;
            }
        }
        for (int i = 30; i < 150; i += 10) {
            if (!this.getMapaUnidadFamiliar().containsKey(i)) continue;
            Aplicacion.getMotor().anniadirRegistro("DESCENDIENTESRENTAS");
            this.initMotoresyXML(i);
            if (bl3) continue;
            bl3 = true;
        }
        if (bl3) {
            this.initMotoresyXML(150);
        }
        ControladorDF.initMotores();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initMotores() {
        try {
            if (FuncionesRenta.isBConyuge()) {
                Aplicacion.getMotor().setCurrentPtr("DEFAULT");
                if (!ControladorDF.colocateEnDeclaracion(Declarantes.Conyuge)) {
                    throw new Exception("Imposible colocarme en Conyuge...");
                }
                Aplicacion.getMotor().createPtr("CONYUGE", "IRPF" + Constantes.getEjercicio());
                Aplicacion.getMotor().setCurrentPtr("DEFAULT");
            }
            int n = 1;
            while ((long)n <= Aplicacion.getMotor().recordCount("DESCENDIENTESRENTAS")) {
                if (FuncionesRenta.isBHijos(n)) {
                    Aplicacion.getMotor().setCurrentPtr("DEFAULT");
                    if (!ControladorDF.colocateEnDeclaracion(Declarantes.parseInt(20 + n * 10))) {
                        throw new Exception("Imposible colocarme en Hijo " + String.valueOf(n));
                    }
                    Aplicacion.getMotor().createPtr("HIJO" + n, "IRPF" + Constantes.getEjercicio());
                    Aplicacion.getMotor().setCurrentPtr("DEFAULT");
                }
                ++n;
            }
            if (FuncionesRenta.isBConjunta()) {
                Aplicacion.getMotor().setCurrentPtr("DEFAULT");
                if (!ControladorDF.colocateEnDeclaracion(Declarantes.UnidadFamiliar)) {
                    throw new Exception("Imposible colocarme en Conjunta...");
                }
                Aplicacion.getMotor().createPtr("CONJUNTA", "IRPF" + Constantes.getEjercicio());
                Aplicacion.getMotor().setCurrentPtr("DEFAULT");
            }
        }
        catch (Exception exception) {
            System.out.println("InitMotores : " + exception);
        }
        finally {
            try {
                Aplicacion.getMotor().setCurrentPtr("DEFAULT");
            }
            catch (Exception exception) {}
            try {
                Aplicacion.getMotor().moveFirst("IRPF" + Constantes.getEjercicio());
            }
            catch (Exception exception) {}
        }
    }

    public static boolean colocateEnDeclaracion(Declarantes declarantes) throws Exception {
        long l = Aplicacion.getMotor().obtenerClaveActiva("IRPF" + Constantes.getEjercicio());
        try {
            long l2 = Aplicacion.getMotor().recordCount("IRPF" + Constantes.getEjercicio());
            long l3 = Aplicacion.getMotor().moveFirst("IRPF" + Constantes.getEjercicio());
            long l4 = -1L;
            while (l3 != l4) {
                String string = declarantes.getNombreUnico();
                if (declarantes.equals(Declarantes.Conyuge)) {
                    string = "Conyuge";
                }
                if (Aplicacion.getMotor().obtenerPartidaString("TITULAR").equalsIgnoreCase(string)) {
                    return true;
                }
                if (l3 == l2) {
                    return false;
                }
                l4 = l3;
                l3 = Aplicacion.getMotor().moveNext("IRPF" + Constantes.getEjercicio());
            }
        }
        catch (Exception exception) {
            System.out.println("Error" + exception);
            Aplicacion.getMotor().move("IRPF" + Constantes.getEjercicio(), l);
        }
        return true;
    }

    public void controlRegistrosEAX() throws Exception {
        String[][] stringArray = null;
        String[] stringArray2 = new String[]{"EAA", "EAB", "EAD", "EAE"};
        for (int i = 10; i < 150; i += 10) {
            this.setDeclarante(Declarantes.parseInt(i));
            if (!this.getMapaDatosCorrectos().containsKey(i) || !this.getMapaDatosCorrectos().get(i).booleanValue()) continue;
            stringArray = this.getTransformador(i).seleccionaTabla("EAC");
            for (int j = 0; j < stringArray2.length; ++j) {
                String string = stringArray2[j];
                stringArray = this.getTransformador(i).seleccionaTabla(string);
                if (null == stringArray) continue;
                for (int k = 0; k < stringArray.length; ++k) {
                    if (this.dameColorRegistro(stringArray[k], string) == 3) continue;
                    this.mDG.compruebaEAXnormal(i, stringArray[k][1], stringArray[k][3]);
                }
            }
        }
        Aplicacion.getMotor().partidaModificada("DF_CONT_EAX", this.mDG.dameNumeroTotalEAX());
        this.setDeclarante(Declarantes.Declarante);
    }

    private ObjetoAtRentasDF[] rellenaListaObjetosAtRentas(int n) throws NumberFormatException, Exception {
        ObjetoAtRentasDF[] objetoAtRentasDFArray = new ObjetoAtRentasDF[Constantes.getMaxEARentas()];
        String[] stringArray = new String[]{"EAA", "EAB", "EAD", "EAE"};
        String[][] stringArray2 = null;
        boolean[] blArray = null;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        double d = 0.0;
        boolean bl = false;
        int n2 = 0;
        if (this.getMapaDatosCorrectos().containsKey(n) && this.getMapaDatosCorrectos().get(n).booleanValue()) {
            for (int i = 0; i < stringArray.length; ++i) {
                string = stringArray[i];
                stringArray2 = this.getTransformador(n).seleccionaTabla(string);
                if (null == stringArray2 || !this.fDF.hayAlgunMarcado(blArray = this.getMapaRegistrosMarcados(n, string))) continue;
                for (int j = 0; j < stringArray2.length; ++j) {
                    double d2;
                    double d3;
                    double d4;
                    double d5;
                    if (!blArray[j]) continue;
                    string2 = stringArray2[j][1];
                    try {
                        d = Double.parseDouble(stringArray2[j][3]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                        d = 0.0;
                    }
                    for (int k = 0; k < objetoAtRentasDFArray.length; ++k) {
                        if (null == objetoAtRentasDFArray[k]) {
                            bl = false;
                            n2 = k;
                            break;
                        }
                        if (null == objetoAtRentasDFArray[k] || null == objetoAtRentasDFArray[k].getsNIF() || !objetoAtRentasDFArray[k].getsNIF().equals(string2) || objetoAtRentasDFArray[k].getdPorc() != d) continue;
                        bl = true;
                        n2 = k;
                        break;
                    }
                    if (!bl) {
                        objetoAtRentasDFArray[n2] = new ObjetoAtRentasDF();
                        objetoAtRentasDFArray[n2].setsNIF(string2);
                        objetoAtRentasDFArray[n2].setdPorc(d);
                    }
                    if ("EAA".equals(string)) {
                        double d6 = Double.parseDouble(stringArray2[j][5]);
                        d5 = Double.parseDouble(stringArray2[j][6]);
                        string4 = stringArray2[j][4];
                        if ("02".equals(string4)) {
                            objetoAtRentasDFArray[n2].setDf1ea(objetoAtRentasDFArray[n2].getDf1ea() + d6);
                            objetoAtRentasDFArray[n2].setDf1eb(objetoAtRentasDFArray[n2].getDf1eb() + d5);
                            continue;
                        }
                        if (!"01".equals(string4)) continue;
                        d4 = this.fDF.calculaDoubleCualquierCadena(stringArray2[j][7], 2);
                        d3 = this.fDF.calculaDoubleCualquierCadena(stringArray2[j][8], 2);
                        d2 = this.fDF.calculaDoubleCualquierCadena(stringArray2[j][9], 2);
                        double d7 = this.fDF.calculaDoubleCualquierCadena(stringArray2[j][10], 2);
                        if (d4 != 0.0) {
                            objetoAtRentasDFArray[n2].setdDivex(objetoAtRentasDFArray[n2].getdDivex() + d4);
                        }
                        if (d3 != 0.0) {
                            objetoAtRentasDFArray[n2].setdOrbo(objetoAtRentasDFArray[n2].getdOrbo() + d3);
                        }
                        if (d2 != 0.0) {
                            objetoAtRentasDFArray[n2].setDf1pf(objetoAtRentasDFArray[n2].getDf1pf() + d2);
                        }
                        if (d7 == 0.0) continue;
                        objetoAtRentasDFArray[n2].setDf1pn(objetoAtRentasDFArray[n2].getDf1pn() + d7);
                        continue;
                    }
                    if ("EAB".equals(string)) {
                        double d8 = Double.parseDouble(stringArray2[j][4]);
                        d5 = Double.parseDouble(stringArray2[j][5]);
                        objetoAtRentasDFArray[n2].setdImp1(objetoAtRentasDFArray[n2].getdImp1() + d8);
                        objetoAtRentasDFArray[n2].setdImp2(objetoAtRentasDFArray[n2].getdImp2() + d5);
                        continue;
                    }
                    if ("EAD".equals(string)) {
                        double d9 = Double.parseDouble(stringArray2[j][6]);
                        string3 = stringArray2[j][4];
                        string4 = stringArray2[j][5];
                        if (string4.length() > 2) {
                            string4 = string4.substring(0, 2);
                        }
                        if ("G".equals(string3) && ("01".equals(string4) || "02".equals(string4))) {
                            d5 = this.fDF.calculaDoubleCualquierCadena(stringArray2[j][7], 2);
                            d4 = this.fDF.calculaDoubleCualquierCadena(stringArray2[j][8], 2);
                            d3 = this.fDF.calculaDoubleCualquierCadena(stringArray2[j][9], 2);
                            d2 = this.fDF.calculaDoubleCualquierCadena(stringArray2[j][10], 2);
                            if (d5 != 0.0) {
                                objetoAtRentasDFArray[n2].setDf1em(objetoAtRentasDFArray[n2].getDf1em() + d5);
                            }
                            if (d4 != 0.0) {
                                objetoAtRentasDFArray[n2].setDf1empf(objetoAtRentasDFArray[n2].getDf1empf() + d4);
                            }
                            if (d3 != 0.0) {
                                objetoAtRentasDFArray[n2].setDf1en(objetoAtRentasDFArray[n2].getDf1en() + d3);
                            }
                            if (d2 == 0.0) continue;
                            objetoAtRentasDFArray[n2].setDf1enpf(objetoAtRentasDFArray[n2].getDf1enpf() + d2);
                            continue;
                        }
                        if ((!"H".equals(string3) || !"01".equals(string4) && !"02".equals(string4)) && (!"F".equals(string3) || !"01".equals(string4) && !"02".equals(string4))) continue;
                        if (string3.equals("H") && string4.equals("01")) {
                            objetoAtRentasDFArray[n2].setDf1ekt(objetoAtRentasDFArray[n2].getDf1ekt() + d9);
                            continue;
                        }
                        if (string3.equals("H") && string4.equals("02")) {
                            objetoAtRentasDFArray[n2].setDf1el(objetoAtRentasDFArray[n2].getDf1el() + d9);
                            continue;
                        }
                        if (string3.equals("F") && string4.equals("01")) {
                            objetoAtRentasDFArray[n2].setDf1ek(objetoAtRentasDFArray[n2].getDf1ek() + d9);
                            continue;
                        }
                        if (!string3.equals("F") || !string4.equals("02")) continue;
                        objetoAtRentasDFArray[n2].setDf1el(objetoAtRentasDFArray[n2].getDf1el() + d9);
                        continue;
                    }
                    if (!"EAE".equals(string)) continue;
                    double d10 = Double.parseDouble(stringArray2[j][5]);
                    objetoAtRentasDFArray[n2].setdRetea(objetoAtRentasDFArray[n2].getdRetea() + d10);
                }
            }
        }
        return objetoAtRentasDFArray;
    }

    public void generaMapasRegistrosMarcados(int n) throws Exception {
        String string = "";
        boolean bl = !this.getTienePreguntaUrbana(n) || this.getTienePreguntaUrbana(n) && this.getUrbanaPreguntada(n) && !this.getRespuestaUrbana(n);
        for (int i = 0; i < this.getAnalizador(n).getListaClavesPresentes().size(); ++i) {
            string = this.getAnalizador(n).getListaClavesPresentes().get(i);
            int n2 = this.getTransformador(n).getTablaContRegistros().get(string);
            if (n2 <= 0) continue;
            boolean[] blArray = new boolean[n2];
            if (!this.mAcc.esClaveTrasladable(string)) {
                blArray = this.fDF.devuelveTodosDesmarcados(n2);
            } else {
                int n3;
                String[][] stringArray = this.getTransformador(n).seleccionaTabla(string);
                if (this.mAcc.esClaveNegra(string) || "UR".equals(string) && bl) {
                    n3 = 0;
                    for (int j = 0; j < stringArray.length; ++j) {
                        try {
                            if (null == stringArray[j]) continue;
                            if (this.registroExcedeOcurrenciasMaximas(stringArray[j], string, n3)) {
                                blArray[j] = Boolean.FALSE;
                                continue;
                            }
                            if (this.dameColorRegistro(stringArray[j], string) == 3) {
                                blArray[j] = Boolean.FALSE;
                                continue;
                            }
                            blArray[j] = Boolean.TRUE;
                            ++n3;
                            this.contarOcurrencias(stringArray[j], string);
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            blArray[j] = Boolean.FALSE;
                        }
                    }
                } else if (this.mAcc.esClaveAzul(string)) {
                    if (this.conceptoInvalidadoEntero(string)) {
                        blArray = this.fDF.devuelveTodosDesmarcados(n2);
                    } else {
                        blArray = this.getMapaRegistrosMarcados(n, string);
                        if (null != blArray) {
                            for (n3 = 0; n3 < stringArray.length; ++n3) {
                                try {
                                    if (null == stringArray[n3]) continue;
                                    if (this.dameColorRegistro(stringArray[n3], string) == 3) {
                                        blArray[n3] = Boolean.FALSE;
                                        continue;
                                    }
                                    if (this.dameColorRegistro(stringArray[n3], string) != 1 && !this.registroInmuebleComun(stringArray[n3])) continue;
                                    blArray[n3] = Boolean.TRUE;
                                    continue;
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    // empty catch block
                                }
                            }
                        } else {
                            blArray = this.fDF.devuelveTodosDesmarcados(n2);
                        }
                    }
                }
            }
            this.setMapaRegistrosMarcados(n, string, blArray);
        }
    }

    public void marcarRegistro(int n, String string, int n2) {
        boolean[] blArray = this.getMapaRegistrosMarcados(n, string);
        blArray[n2] = Boolean.TRUE;
        this.setMapaRegistrosMarcados(n, string, blArray);
    }

    public void desMarcarRegistro(int n, String string, int n2) {
        boolean[] blArray = this.getMapaRegistrosMarcados(n, string);
        blArray[n2] = Boolean.FALSE;
        this.setMapaRegistrosMarcados(n, string, blArray);
    }

    public void generaMapaDatosAzules() throws Exception {
        String string = "";
        for (int i = 10; i < 150; i += 10) {
            boolean bl = false;
            if (!this.mapaAnalizadores.containsKey(i) || null == this.mapaAnalizadores.get(i) || !this.mapaDatosCorrectos.get(i).booleanValue()) continue;
            this.setDeclarante(Declarantes.parseInt(i));
            for (int j = 0; j < this.mapaAnalizadores.get(i).getListaClavesPresentes().size(); ++j) {
                string = this.mapaAnalizadores.get(i).getListaClavesPresentes().get(j);
                if (!this.conceptoDebeMostrarseEnCarrusel(string, Declarantes.parseInt(i))) continue;
                this.getMapaDatosAzules().put(i, Boolean.TRUE);
                bl = true;
                break;
            }
            if (bl) continue;
            this.getMapaDatosAzules().put(i, Boolean.FALSE);
        }
        this.setDeclarante(Declarantes.Declarante);
    }

    public void generaMapaPreguntasUrbana() throws Exception {
        for (int i = 10; i < 150; i += 10) {
            if (!this.mapaAnalizadores.containsKey(i) || null == this.mapaAnalizadores.get(i)) continue;
            if (this.mapaAnalizadores.get(i).getListaClavesPresentes().contains("UR")) {
                if (this.getAnalizador(i).getAlgunInmuebleSinMarcaH() || this.getAnalizador(i).getContInmueblesMarcaH() > this.mDG.getMaximoInmueblesMarcaH(i)) {
                    this.setTienePreguntaUrbana(i, Boolean.TRUE);
                    continue;
                }
                this.setTienePreguntaUrbana(i, Boolean.FALSE);
                continue;
            }
            this.setTienePreguntaUrbana(i, Boolean.FALSE);
        }
    }

    public boolean conceptoDebeMostrarseEnCarrusel(String string, Declarantes declarantes) throws Exception {
        boolean bl = false;
        if (!this.mAcc.esClaveAzul(string) && !"DM".equals(string)) {
            return false;
        }
        if (this.conceptoInvalidadoEntero(string)) {
            return false;
        }
        String[][] stringArray = this.getTransformador(declarantes.toInt()).seleccionaTabla(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.dameColorRegistro(stringArray[i], string) != 2) continue;
            return true;
        }
        return bl;
    }

    public boolean conceptoInvalidadoEntero(String string) throws Exception {
        boolean bl = false;
        int n = 0;
        int n2 = 30;
        while (n < Constantes.getNumhijosrentas()) {
            if (this.mDeclaranteActual.toInt() == n2) {
                bl = true;
                break;
            }
            ++n;
            n2 += 10;
        }
        if (bl) {
            if ("PH".equals(string) || "DN".equals(string) || "CC".equals(string) || "PP".equals(string) || "DM".equals(string) || "TI".equals(string) || "DE".equals(string) || "AS".equals(string) || "DG".equals(string)) {
                return true;
            }
        } else {
            if (this.getAnalizador(10).hayAnulacionDatosPersonales() && ("DE".equals(string) || "AS".equals(string) || "DG".equals(string))) {
                return true;
            }
            if ("DM".equals(string) && this.getDG().getYaSeHaTrasladadoDM()) {
                return true;
            }
        }
        return false;
    }

    public boolean registroObligatorio(String[] stringArray, String string) throws Exception {
        boolean bl = false;
        if (string.equals("DI")) {
            bl = true;
        } else if (string.equals("TI")) {
            String string2 = stringArray[1];
            if (string2.equals("T01")) {
                bl = true;
            }
        } else if ("CC".equals(string)) {
            String string3 = stringArray[3];
            boolean bl2 = false;
            if (null != this.getDG().getTablaTIdeclarante() && this.mDeclaranteActual.equals(Declarantes.Declarante)) {
                bl2 = !"".equals(this.getDG().getTablaTIdeclarante()[0][this.getDG().getColumnasTI().get("Minus")]);
            } else if (null != this.getDG().getTablaTIdeclarante() && this.mDeclaranteActual.equals(Declarantes.Conyuge) && this.getDG().getTablaTIdeclarante().length > 1) {
                boolean bl3 = bl2 = !"".equals(this.getDG().getTablaTIdeclarante()[1][this.getDG().getColumnasTI().get("Minus")]);
            }
            if (bl2 && ("748".equals(string3) || "805".equals(string3) || "834".equals(string3) || "835".equals(string3) || "848".equals(string3))) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean registroInmuebleComun(String[] stringArray) throws Exception {
        boolean bl = false;
        if (null != this.getDG().getTablaURdeclarante() && this.mDeclaranteActual.equals(Declarantes.Conyuge)) {
            for (int i = 0; i < this.getDG().getTablaURdeclarante().length; ++i) {
                if (this.getDG().getTablaURdeclarante()[i][this.getDG().getColumnasUR().get("Copiar")].indexOf("S") == -1 || !this.fDF.esMismoMismoInmueble(stringArray, this.getDG().getTablaURdeclarante()[i]) || this.dameColorRegistro(stringArray, "UR") == 3) continue;
                return true;
            }
        }
        return bl;
    }

    public boolean registroExcedeOcurrenciasMaximas(String[] stringArray, String string, int n) throws Exception {
        boolean bl = false;
        if ("DE".equals(string) && n >= DatosGlobalesDF.MAX_DE) {
            bl = true;
        } else if ("AS".equals(string) && n >= DatosGlobalesDF.MAX_AS) {
            bl = true;
        } else if ("FIE".equals(string) && n >= 54) {
            bl = true;
        } else if ("UR".equals(string)) {
            if ("H".equals(stringArray[this.mDG.getColumnasUR().get("MarcaUso")]) && this.getDG().getContadorHabituales(this.mDeclaranteActual) >= this.getDG().getMaximoInmueblesMarcaH(this.mDeclaranteActual.toInt())) {
                bl = true;
            } else if (this.getDG().getContadorNoAfectos(this.mDeclaranteActual) >= this.getDG().getMaximoInmueblesNoAfectos(this.mDeclaranteActual.toInt())) {
                bl = true;
            }
        }
        return bl;
    }

    public int dameColorRegistro(String[] stringArray, String string) throws Exception {
        String string2;
        String string3;
        String string4;
        boolean bl;
        boolean bl2 = bl = this.mDeclaranteActual.toInt() > Declarantes.Conyuge.toInt() && this.mDeclaranteActual.toInt() < Declarantes.UnidadFamiliar.toInt();
        if ("AG".equals(string) || "FIC".equals(string) || "AR".equals(string) || "AE".equals(string) || "EAC".equals(string) || "EAF".equals(string) || "CT".equals(string) || "NO".equals(string) || "SC".equals(string) || "AA".equals(string)) {
            return 3;
        }
        if ("DI".equals(string) || "DOM".equals(string) || "DEX".equals(string) || "RTA".equals(string) || "RTD".equals(string) || "EV".equals(string) || "CB".equals(string) || "SG".equals(string) || "PF".equals(string)) {
            return 1;
        }
        if ("IP".equals(string) || "LT".equals(string) || "RI".equals(string)) {
            return 2;
        }
        if (bl && ("PH".equals(string) || "DN".equals(string) || "PP".equals(string) || "DM".equals(string))) {
            return 3;
        }
        if ("DG".equals(string) || "TI".equals(string) || "DE".equals(string) || "AS".equals(string)) {
            if (this.mDeclaranteActual.equals(Declarantes.Declarante)) {
                if ("TI".equals(string)) {
                    string4 = stringArray[this.mDG.getColumnasTI().get("Tipo")];
                    if ("T01".equals(string4)) {
                        return 1;
                    }
                    if ("T02".equals(string4) || "C01".equals(string4)) {
                        if (this.getAnalizador(10).hayAnulacionDatosPersonales()) {
                            return 3;
                        }
                        return 1;
                    }
                } else {
                    if ("DG".equals(string) || "AS".equals(string)) {
                        if (this.getAnalizador(10).hayAnulacionDatosPersonales()) {
                            return 3;
                        }
                        return 1;
                    }
                    if ("DE".equals(string)) {
                        double d;
                        String string5;
                        String string6;
                        if (this.getAnalizador(10).hayAnulacionDatosPersonales()) {
                            return 3;
                        }
                        String string7 = this.fDF.comprobarCadenaNula(stringArray[this.mDG.getColumnasDE().get("NIF")]);
                        String string8 = this.fDF.comprobarCadenaNula(stringArray[this.mDG.getColumnasDE().get("Minus")]);
                        String string9 = this.fDF.comprobarCadenaNula(stringArray[this.mDG.getColumnasDE().get("OtrSitu")]);
                        String string10 = this.fDF.comprobarFechaNula(stringArray[this.mDG.getColumnasDE().get("FechNac")]);
                        int n = this.fDF.calculaEdadEfectivaHijo(string10, string6 = this.fDF.comprobarFechaNula(stringArray[this.mDG.getColumnasDE().get("FechFal")]), string5 = this.fDF.comprobarFechaNula(this.mDG.getTablaTIdeclarante()[0][this.mDG.getColumnasTI().get("FechFal")]));
                        if (this.mDG.validaHijo(string7, n, string8, string9, d = Double.parseDouble(stringArray[this.mDG.getColumnasDE().get("VolRen")]))) {
                            return 1;
                        }
                        return 3;
                    }
                }
            } else {
                return 3;
            }
        }
        if ("DM".equals(string)) {
            if (this.mDG.getYaSeHaTrasladadoDM()) {
                return 3;
            }
            return 2;
        }
        if ("CC".equals(string) && !this.mDeclaranteActual.equals(Declarantes.Declarante) && !this.mDeclaranteActual.equals(Declarantes.Conyuge) && ("762".equals(string4 = stringArray[3]) || "848".equals(string4) || "880".equals(string4) || "881".equals(string4) || "888".equals(string4)) && null != (string3 = this.mapaUF.get(this.mDeclaranteActual.toInt())) && null != (string2 = this.getDG().getMapaNifCAhijosRentas().get(string3)) && ("02".equals(string2) || "09".equals(string2))) {
            return 3;
        }
        if ("RTB".equals(string)) {
            string4 = stringArray[3];
            if (!string4.equals("K1")) {
                return 1;
            }
            return 2;
        }
        if ("RTC".equals(string)) {
            string4 = stringArray[3];
            if (!string4.startsWith("G")) {
                return 3;
            }
            return 2;
        }
        if ("PP".equals(string)) {
            string4 = stringArray[this.getDG().getColumnasPP().get("Clave")].toUpperCase();
            if (!("A".equals(string4) || "C".equals(string4) || "F".equals(string4) || "G".equals(string4) || "H".equals(string4) || "J".equals(string4) || "K".equals(string4) || "L".equals(string4))) {
                return 3;
            }
            return 1;
        }
        if ("FIE".equals(string)) {
            string4 = stringArray[11];
            if ("O".equals(string4)) {
                return 3;
            }
            return 1;
        }
        if ("TV".equals(string)) {
            double d = Double.parseDouble(stringArray[9]);
            string2 = stringArray[6];
            String string11 = stringArray[10];
            if (d == 0.0) {
                return 3;
            }
            if ("K".equals(string2) && "B".equals(string11)) {
                return 1;
            }
            if (!"K".equals(string2) && !"B".equals(string11)) {
                return 1;
            }
            return 3;
        }
        if ("REA".equals(string)) {
            string4 = stringArray[5];
            if (!(string4.equals("A01") || string4.equals("A02") || string4.equals("A03") || string4.equals("A04") || string4.equals("A05") || string4.equals("A07") || string4.equals("A08") || string4.equals("B01") || string4.equals("B02") || string4.equals("B03") || string4.equals("B04") || string4.equals("B05") || string4.equals("B06") || string4.equals("C05") || string4.equals("GAS"))) {
                return 3;
            }
            return 1;
        }
        if ("REG".equals(string)) {
            string4 = stringArray[5];
            if (string4.equals("C01") || string4.equals("C02") || string4.equals("C07") || string4.equals("C06")) {
                return 1;
            }
            if (string4.equals("C03") || string4.equals("C04") || string4.equals("C12") || string4.equals("D01") || string4.equals("D02") || string4.equals("D03") || string4.equals("D04") || string4.equals("D05") || string4.equals("D06")) {
                return 2;
            }
            return 3;
        }
        if ("EAA".equals(string)) {
            string4 = stringArray[4];
            if (this.getDG().dameNumeroTotalEAX() > Constantes.getMaxEARentas()) {
                return 3;
            }
            if ("02".equals(string4)) {
                return 1;
            }
            if ("01".equals(string4)) {
                return 2;
            }
            return 3;
        }
        if ("EAB".equals(string)) {
            if (this.getDG().dameNumeroTotalEAX() > Constantes.getMaxEARentas()) {
                return 3;
            }
            return 1;
        }
        if ("EAD".equals(string)) {
            string4 = stringArray[4] + stringArray[5];
            if (string4.length() > 3) {
                string4 = string4.substring(0, 3);
            }
            if (this.getDG().dameNumeroTotalEAX() > Constantes.getMaxEARentas()) {
                return 3;
            }
            if ("H01".equals(string4) || "H02".equals(string4) || "F01".equals(string4) || "F02".equals(string4)) {
                return 1;
            }
            if ("G01".equals(string4)) {
                return 2;
            }
            if ("G02".equals(string4) && this.getModoTraslado() == 1) {
                return 2;
            }
            if ("G02".equals(string4) && this.getModoTraslado() == 2) {
                return 3;
            }
            return 3;
        }
        if ("EAE".equals(string)) {
            string4 = stringArray[4];
            if (this.getDG().dameNumeroTotalEAX() > Constantes.getMaxEARentas()) {
                return 3;
            }
            if ("01".equals(string4) || "02".equals(string4) || "04".equals(string4)) {
                return 1;
            }
            return 3;
        }
        if ("DN".equals(string)) {
            string4 = stringArray[4];
            string3 = stringArray[5];
            string2 = stringArray[6];
            if ("".equals(string3) && "".equals(string2)) {
                return 3;
            }
            if ("E".equals(string4)) {
                return 3;
            }
            if ("08".equals(this.getDG().getCA(this.mDeclaranteActual.toInt())) && "08".equals(string2)) {
                return 2;
            }
            return 1;
        }
        if ("PH".equals(string)) {
            if (this.getTransformador(this.mDeclaranteActual.toInt()).seleccionaTabla("PH").length > 1) {
                return 2;
            }
            string4 = stringArray[5];
            string3 = stringArray[3];
            string2 = "";
            String string12 = "";
            String string13 = "";
            String string14 = "";
            int n = 0;
            if (null != this.mDG.getTablaTIdeclarante()) {
                if (this.getDeclaranteActual().equals(Declarantes.Conyuge) && !this.mDG.hayLineaConyuge()) {
                    return 2;
                }
                if (this.getDeclaranteActual().equals(Declarantes.Conyuge) && this.mDG.hayLineaConyuge()) {
                    n = 1;
                }
                string2 = this.mDG.getTablaTIdeclarante()[n][this.mDG.getColumnasTI().get("PorcPH")];
                string12 = this.mDG.getTablaTIdeclarante()[n][this.mDG.getColumnasTI().get("FechAdq")];
                string13 = this.mDG.getTablaTIdeclarante()[n][this.mDG.getColumnasTI().get("SeDedujo")].toUpperCase();
                string14 = this.mDG.getTablaTIdeclarante()[n][this.mDG.getColumnasTI().get("NumPH")];
                if (!"".equals(string12) && "S".equals(string13) && -1 == (Integer)Aplicacion.getMotor().ejecutarFuncion("comparaFechas", new Object[]{string12, "31122012"}) && !"".equals(string4) && string4.equals(string2) && !"".equals(string3) && string3.equals(string14)) {
                    return 1;
                }
                return 2;
            }
            return 2;
        }
        if ("UR".equals(string)) {
            string4 = stringArray[this.getDG().getColumnasUR().get("RefCat")];
            string3 = stringArray[this.getDG().getColumnasUR().get("Clave")];
            string2 = stringArray[this.getDG().getColumnasUR().get("CodDer")];
            String string15 = stringArray[this.getDG().getColumnasUR().get("MarcaUso")];
            if (string4.equalsIgnoreCase("") || string4.length() < 1 || string3.equalsIgnoreCase("M") || string2.equalsIgnoreCase("DF")) {
                return 3;
            }
            if (this.getTienePreguntaUrbana(this.mDeclaranteActual.toInt()) && this.getUrbanaPreguntada(this.mDeclaranteActual.toInt()) && !this.getRespuestaUrbana(this.mDeclaranteActual.toInt()) && !"H".equals(string15) && ("CA".equals(string2) || "DS".equals(string2) || "NP".equals(string2))) {
                return 3;
            }
            if (!this.getTienePreguntaUrbana(this.mDeclaranteActual.toInt()) || this.getTienePreguntaUrbana(this.mDeclaranteActual.toInt()) && this.getUrbanaPreguntada(this.mDeclaranteActual.toInt()) && !this.getRespuestaUrbana(this.mDeclaranteActual.toInt())) {
                return 1;
            }
            if (this.getTienePreguntaUrbana(this.mDeclaranteActual.toInt()) && this.getUrbanaPreguntada(this.mDeclaranteActual.toInt()) && this.getRespuestaUrbana(this.mDeclaranteActual.toInt())) {
                return 2;
            }
        } else if ("CC".equals(string)) {
            string4 = stringArray[3];
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            String string16 = this.getDG().getCA(this.mDeclaranteActual.toInt());
            bl3 = "09".equals(string16) && ("880".equals(string4) || "881".equals(string4) || "888".equals(string4));
            bl4 = "02".equals(string16) && "762".equals(string4);
            bl5 = "08".equals(string16) && "848".equals(string4);
            boolean bl7 = bl6 = "748".equals(string4) || "805".equals(string4) || "834".equals(string4) || "835".equals(string4) || "848".equals(string4);
            if (!(bl3 || bl4 || bl5 || bl6)) {
                return 3;
            }
            return 1;
        }
        return 1;
    }

    private void contarOcurrencias(String[] stringArray, String string) throws Exception {
        if ("UR".equals(string)) {
            if ("H".equals(stringArray[this.mDG.getColumnasUR().get("MarcaUso")])) {
                this.getDG().setContadorHabituales(this.mDeclaranteActual, true);
            } else {
                this.getDG().setContadorNoAfectos(this.mDeclaranteActual, true);
            }
        }
    }

    public boolean registroDebeMostrarseEnCarrusel(String[] stringArray, String string) throws Exception {
        return this.dameColorRegistro(stringArray, string) == 2 && !this.registroObligatorio(stringArray, string);
    }

    public String decideClaveTrasladoPP(String[] stringArray) throws Exception {
        String string = "0";
        String string2 = "";
        String string3 = "";
        if (null != this.getDG().getTablaTIdeclarante()) {
            string2 = this.getDG().getTablaTIdeclarante()[0][this.getDG().getColumnasDE().get("NIF")];
            string3 = "";
            if (this.getDG().getTablaTIdeclarante().length > 1) {
                string3 = this.getDG().getTablaTIdeclarante()[1][this.getDG().getColumnasDE().get("NIF")];
            }
        }
        String string4 = stringArray[this.getDG().getColumnasPP().get("Clave")];
        String string5 = stringArray[this.getDG().getColumnasPP().get("Subclave")];
        String string6 = stringArray[this.getDG().getColumnasPP().get("NIF")];
        Double d = Double.parseDouble(stringArray[this.getDG().getColumnasPP().get("Aportacion")]);
        if (string4.equals("A") || string4.equals("F") || string4.equals("H") || string4.equals("K") || string4.equals("J") && string5.equals("08")) {
            if ("".equals(this.fDF.comprobarNIFnulo(string6))) {
                string = "1";
            } else if (string6.equals(string2) && this.mDeclaranteActual.equals(Declarantes.Declarante)) {
                string = "2";
            } else if (string6.equals(string3) && this.mDeclaranteActual.equals(Declarantes.Conyuge)) {
                string = "2";
            } else if (!"".equals(this.fDF.comprobarNIFnulo(string6))) {
                string = "3";
                this.getDG().nuevoPPdiscapacitados(string6, d);
            }
        } else if (string4.equals("C") && string5.equals("01") || string4.equals("G") || string4.equals("J") && string5.equals("09")) {
            if ("".equals(this.fDF.comprobarNIFnulo(string6))) {
                string = "1";
            } else if (string6.equals(string2) && this.mDeclaranteActual.equals(Declarantes.Declarante)) {
                string = "2";
            } else if (string6.equals(string3) && this.mDeclaranteActual.equals(Declarantes.Conyuge)) {
                string = "2";
            }
        } else if (string4.equals("L") && string5.equals("00")) {
            string = "1";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void guardarDatosFiscales() throws Exception {
        String string = "";
        String string2 = "";
        String string3 = "";
        String[][] stringArray = null;
        String string4 = "";
        boolean[] blArray = null;
        System.out.println("Guardando datos fiscales incorporados y no incorporados...");
        try {
            for (int i = 10; i < 100; i += 10) {
                if (!this.getMapaDatosCorrectos().containsKey(i) || !this.getMapaDatosCorrectos().get(i).booleanValue()) continue;
                this.setDeclarante(Declarantes.parseInt(i));
                this.fr.irDeclaracion(this.getDeclaranteActual());
                string2 = "";
                string3 = "";
                for (int j = 0; j < this.getAnalizador(i).getListaClavesPresentes().size(); ++j) {
                    string4 = this.getAnalizador(i).getListaClavesPresentes().get(j);
                    stringArray = this.getTransformador(i).seleccionaTabla(string4);
                    if (null == stringArray) continue;
                    blArray = this.getMapaRegistrosMarcados(i, string4);
                    for (int k = 0; k < blArray.length; ++k) {
                        string = string4 + "\t";
                        for (int i2 = 0; i2 < stringArray[k].length; ++i2) {
                            string = string + stringArray[k][i2] + "\t";
                        }
                        if (blArray[k]) {
                            string2 = string2 + string + "\n";
                            continue;
                        }
                        string3 = string3 + string + "\n";
                    }
                }
                Aplicacion.getMotor().partidaModificada("DF_DATOS_SI", string2);
                Aplicacion.getMotor().partidaModificada("DF_DATOS_NO", string3);
                if (null != string2 && string2.length() > 0) {
                    System.out.println("\t" + Declarantes.parseInt(i).getNombreUnico() + "... ok!");
                    continue;
                }
                System.out.println("\t" + Declarantes.parseInt(i).getNombreUnico() + "... vac\u00edo!");
            }
        }
        catch (Exception exception) {
            System.out.println("\nERROR!!!!! M\u00e9todo guardarDatosFiscales()");
            exception.printStackTrace();
        }
        finally {
            this.fr.irDeclaracion(Declarantes.Declarante);
            this.setDeclarante(Declarantes.Declarante);
        }
    }

    public String[][] seleccionaTablaSoloConRegistrosQueDebenMostrarse(String string, int n) throws Exception {
        int n2;
        int n3 = 0;
        int n4 = this.getTransformador(n).seleccionaTabla(string).length;
        int n5 = this.getAccesoDatos().getTablaContColumnas().get(string);
        String[][] stringArray = new String[n4][n5];
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.registroDebeMostrarseEnCarrusel(this.getTransformador(n).seleccionaTabla(string)[i], string)) {
                ++n3;
            }
            for (n2 = 0; n2 < stringArray[i].length; ++n2) {
                stringArray[i][n2] = this.getTransformador(n).seleccionaTabla(string)[i][n2];
            }
        }
        String[][] stringArray2 = new String[n4 - n3][n5];
        n2 = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.registroDebeMostrarseEnCarrusel(stringArray[i], string)) continue;
            ++n2;
            for (int j = 0; j < stringArray[i].length; ++j) {
                stringArray2[n2][j] = stringArray[i][j];
            }
        }
        return stringArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operacionesDespuesDeGuardarDatosFiscales() throws Exception {
        String[][] stringArray = null;
        try {
            for (int i = 10; i < Declarantes.UnidadFamiliar.toInt(); ++i) {
                if (!this.getMapaDatosCorrectos().containsKey(i) || !this.getMapaDatosCorrectos().get(i).booleanValue()) continue;
                stringArray = this.getTransformador(i).seleccionaTabla("RTC");
                if (null != stringArray) {
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (stringArray[j][9].indexOf("ACT") == -1) continue;
                        this.fr.irDeclaracion(Declarantes.parseInt(i));
                        Aplicacion.getMotor().partidaModificada("DF_HAYRTCAE", "true");
                        break;
                    }
                }
                if (null == (stringArray = this.getTransformador(i).seleccionaTabla("EAC"))) continue;
                this.fr.irDeclaracion(Declarantes.parseInt(i));
                Aplicacion.getMotor().partidaModificada("DF_HAYEARAE", "true");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.fr.irDeclaracion(Declarantes.Declarante);
        }
    }

    public int getFilaReal(String string, int n, int n2) throws Exception {
        int n3 = 0;
        int n4 = n;
        String[][] stringArray = this.getTransformador(n2).seleccionaTabla(string);
        if (null != stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.registroDebeMostrarseEnCarrusel(stringArray[i], string)) continue;
                if (n3 == n) {
                    return i;
                }
                ++n3;
            }
        }
        return n4;
    }

    public boolean declaranteAutorizadoRentaWeb(int n) throws Exception {
        if (n == 10) {
            return true;
        }
        if (n == 20) {
            return "1".equals(Aplicacion.getMotor().obtenerPartidaString("ISAUTORIZCONYU"));
        }
        long l = Aplicacion.getMotor().obtenerClaveActiva("RWHIJOSMENOR18");
        Aplicacion.getMotor().move("RWHIJOSMENOR18", (long)(n / 10) - 2L);
        String string = Aplicacion.getMotor().obtenerPartidaString("ISAUTORIZHMEN");
        Aplicacion.getMotor().move("RWHIJOSMENOR18", l);
        return "1".equals(string);
    }
}

