/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.comunDF;

import es.aeat.pare.aplicacion.Aplicacion;
import es.aeat.pare.aplicacion.Constantes;
import es.aeat.pare.cc14.Declarantes;
import es.aeat.pare.comunDF.ControladorDF;
import es.aeat.pare.comunDF.DatosGlobalesDF;
import es.aeat.pare.comunDF.FuncionesDF;
import es.aeat.pare.comunDF.InterfazAccesoDatosDF;
import es.aeat.pare.comunDF.TransformardorDF;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class AnalizadorDF
implements Serializable {
    private static final long serialVersionUID = 2405247484630891953L;
    public static final String REG_CABECERA = "0DDFF2014";
    public static final String REG_FIN = "999";
    private transient LineNumberReader mLnr;
    private FuncionesDF fDF;
    private Declarantes mDeclarante;
    private InterfazAccesoDatosDF mAcc;
    private DatosGlobalesDF mDG;
    private ControladorDF mCTR;
    private TransformardorDF trans;
    public static final int FICH_OK = 0;
    public static final int FICH_ERROR_EXTENSION = -1;
    public static final int FICH_ERROR_CABECERA = -2;
    public static final int FICH_ERROR_LINEA = -3;
    public static final int FICH_ERROR_NIF = -4;
    public static final int FICH_ERROR_DE_AS = -5;
    public static final int FICH_ERROR_IOEXCEPTION = -9;
    public static final int FICH_SIN_ANALIZAR = -999;
    private int mRetornoAnalisisFichero = -999;
    private String mLineaErronea = "";
    private ArrayList<String> listaClavesPresentesEnEsteFichero;
    private boolean bAnulacionDatosPersonales = false;
    private String sPorqueHayAnulacionDatosPersonales = "";
    private boolean bDeclaracionIndividualSobrevenida = false;
    private boolean bCaso1 = false;
    private boolean bCaso2 = false;
    private boolean bCaso3 = false;
    private boolean bCaso4 = false;
    private boolean bCaso5 = false;
    private boolean bCaso6 = false;
    private boolean bCaso7 = false;
    private boolean bCaso8 = false;
    private boolean bCaso9 = false;
    private boolean bCaso10 = false;
    private boolean bCaso11 = false;
    private boolean bCaso12 = false;
    private boolean bCaso13 = false;
    private boolean bCaso14 = false;
    private boolean bCaso15 = false;
    private boolean bCaso16 = false;
    private boolean bTrasladoWebPermitido = true;
    private String sPorqueNoSePuedeTrasladoWeb = "";
    private boolean bFicheroConClaveOT = false;
    private int contInmueblesMarcaH = 0;
    private boolean bAlgunInmuebleSinMarcaH = false;

    public void setTrans(TransformardorDF transformardorDF) {
        this.trans = transformardorDF;
    }

    public int getRetornoAnalisisFichero() {
        return this.mRetornoAnalisisFichero;
    }

    public String getLineaErronea() {
        return this.mLineaErronea;
    }

    public ArrayList<String> getListaClavesPresentes() {
        return this.listaClavesPresentesEnEsteFichero;
    }

    public boolean hayAnulacionDatosPersonales() {
        return this.bAnulacionDatosPersonales;
    }

    public String getPorqueHayAnulacionDatosPersonales() {
        return this.sPorqueHayAnulacionDatosPersonales;
    }

    public boolean hayDeclaracionIndividualSobrevenida() {
        return this.bDeclaracionIndividualSobrevenida;
    }

    public boolean hayCaso3() {
        return this.bCaso3;
    }

    public boolean hayCaso4() {
        return this.bCaso4;
    }

    public boolean hayCaso11() {
        return this.bCaso11;
    }

    public boolean trasladoWebPermitido() {
        return this.bTrasladoWebPermitido;
    }

    public String getPorqueNoSePuedeTrasladoWeb() {
        return this.sPorqueNoSePuedeTrasladoWeb;
    }

    public int getContInmueblesMarcaH() {
        return this.contInmueblesMarcaH;
    }

    public boolean getAlgunInmuebleSinMarcaH() {
        return this.bAlgunInmuebleSinMarcaH;
    }

    public AnalizadorDF(LineNumberReader lineNumberReader, Declarantes declarantes, ControladorDF controladorDF) throws Exception {
        this.mLnr = lineNumberReader;
        this.constructorComun(declarantes, controladorDF);
    }

    private void constructorComun(Declarantes declarantes, ControladorDF controladorDF) throws Exception {
        this.mDeclarante = declarantes;
        this.mCTR = controladorDF;
        this.mAcc = controladorDF.getAccesoDatos();
        this.mDG = controladorDF.getDG();
        this.fDF = new FuncionesDF();
        this.listaClavesPresentesEnEsteFichero = new ArrayList();
    }

    public int analisisEstructuraDatos() throws Exception {
        System.out.println("\nAnalizando datos fiscales para " + this.mDeclarante.getNombreUnico() + "...");
        try {
            String string = this.mLnr.readLine();
            if (string == null || !string.equals(REG_CABECERA)) {
                System.out.println("Error de cabecera en fichero datos fiscales: " + string);
                this.mRetornoAnalisisFichero = -2;
                return -2;
            }
            string = this.mLnr.readLine();
            String string2 = string.substring(1);
            while (!string.equalsIgnoreCase(REG_FIN)) {
                String string3 = this.fDF.obtenerClave(string);
                if ("OT".equals(string3)) {
                    this.bFicheroConClaveOT = true;
                }
                if (this.mAcc.getListaTodasClaves().contains(string3)) {
                    String string4;
                    if (!this.comprobarLinea(string, string3, this.mDeclarante)) {
                        System.out.println("El siguiente registro tiene formato incorrecto: \n\t" + string2);
                        this.mLineaErronea = string2;
                        this.mRetornoAnalisisFichero = -3;
                        return -3;
                    }
                    if (!this.listaClavesPresentesEnEsteFichero.contains(string3)) {
                        this.listaClavesPresentesEnEsteFichero.add(string3);
                    }
                    if ("DI".equals(string3)) {
                        string4 = string.substring(1, 10);
                        if (!Aplicacion.getMotor().obtenerPartidaString(this.fDF.damePartidaNif(this.mDeclarante, this.mCTR.getModoTraslado())).equals(string4)) {
                            this.mRetornoAnalisisFichero = -4;
                            return -4;
                        }
                    }
                    if ("UR".equals(string3)) {
                        string4 = string.substring(115, 116);
                        if ("H".equals(string4)) {
                            ++this.contInmueblesMarcaH;
                        } else {
                            this.bAlgunInmuebleSinMarcaH = true;
                        }
                    }
                } else if (!string.startsWith("//") && !"OT".equals(string3)) {
                    System.out.println("ERROR! Imposible recuperar la clave de concepto en l\u00ednea: " + string);
                    this.mLineaErronea = string2;
                    this.mRetornoAnalisisFichero = -3;
                    return -3;
                }
                if ("".equals(string = this.mLnr.readLine())) {
                    System.out.println("ERROR! L\u00ednea vac\u00eda");
                    this.mRetornoAnalisisFichero = -3;
                    return -3;
                }
                string2 = string.substring(1);
            }
        }
        catch (IOException iOException) {
            this.mRetornoAnalisisFichero = -9;
            return -9;
        }
        this.mRetornoAnalisisFichero = 0;
        return 0;
    }

    private boolean comprobarLinea(String string, String string2, Declarantes declarantes) throws Exception {
        if (string.startsWith("//")) {
            return true;
        }
        if (string == null || string.length() < 3) {
            return false;
        }
        if ((string2.equalsIgnoreCase("DG") || string2.equalsIgnoreCase("TI") || string2.equalsIgnoreCase("DE") || string2.equalsIgnoreCase("AS")) && !declarantes.equals(Declarantes.Declarante)) {
            return false;
        }
        string = string.substring(1);
        double d = 0.0;
        double d2 = 0.0;
        String string3 = "";
        int n = 0;
        int n2 = 0;
        Object[][] objectArray = this.mAcc.getDfCamposX().get(string2);
        for (int i = 0; i < objectArray.length; ++i) {
            d = ((Integer)objectArray[i][0]).intValue();
            d2 = ((Integer)objectArray[i][1]).intValue();
            string3 = (String)objectArray[i][2];
            boolean bl = (Boolean)objectArray[i][3];
            if (!bl) continue;
            if (string3.equalsIgnoreCase("N")) {
                n = (int)((double)n + (d + d2));
                if (!this.comprobarCampoNumerico(string, n2, d, d2)) {
                    return false;
                }
                n2 += (int)d + (int)d2;
                continue;
            }
            if (string3.equalsIgnoreCase("D")) {
                n = (int)((double)n + d);
                if (!this.comprobarCampoFecha(string, n2, d)) {
                    return false;
                }
                n2 = (int)((double)n2 + d);
                continue;
            }
            if (!string3.equalsIgnoreCase("X")) continue;
            n = (int)((double)n + d);
            n2 = (int)((double)n2 + d);
        }
        return string.length() == n;
    }

    private boolean comprobarCampoNumerico(String string, int n, double d, double d2) {
        try {
            String string2 = string.substring(n, n + (int)d + (int)d2);
            char[] cArray = string2.toCharArray();
            Character c = Character.valueOf(cArray[0]);
            if (!c.toString().equalsIgnoreCase("N")) {
                if (!Character.isDigit(c.charValue()) && !string2.substring(0, 1).equalsIgnoreCase(" ")) {
                    return false;
                }
            }
            for (int i = 1; i < cArray.length; ++i) {
                Character c2 = Character.valueOf(cArray[i]);
                if (Character.isDigit(c2.charValue()) || c2.toString().equalsIgnoreCase(" ")) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean comprobarCampoFecha(String string, int n, double d) {
        String string2 = "";
        try {
            string2 = string.substring(n, n + (int)d);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            stringIndexOutOfBoundsException.printStackTrace();
            return false;
        }
        char[] cArray = string2.toCharArray();
        for (int i = 1; i < cArray.length; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (Character.isDigit(c.charValue()) || c.toString().equalsIgnoreCase(" ")) continue;
            return false;
        }
        return true;
    }

    public void analisisDatosPersonales() throws Exception {
        String string;
        boolean bl = this.mDG.seMarcoIndv();
        boolean bl2 = "1".equals(Aplicacion.getMotor().obtenerPartidaString("DF_PH18"));
        String string2 = "DF_NIF_C";
        if (this.mCTR.getModoTraslado() == 2) {
            string2 = "DPNIF_C";
        }
        String string3 = Aplicacion.getMotor().obtenerPartidaString(string2);
        boolean bl3 = Boolean.parseBoolean(Aplicacion.getMotor().obtenerPartidaString("INDV"));
        if (bl3 && this.mDG.getContadorDEVolRen1800() > 0) {
            this.bCaso1 = true;
        }
        if (bl3 && this.mDG.getContadorHijosMas24SinMinus() > 0) {
            this.bCaso2 = true;
        }
        if (!bl && this.mDG.hayFechaFallecimientoEnEjercicio(Declarantes.Declarante)) {
            this.bCaso3 = true;
        }
        if (this.mDG.hayFechaFallecimientoEnEjercicio(Declarantes.Declarante) && this.mDG.getContadorDEVolRen1800() > 0) {
            this.bCaso4 = true;
        }
        if (this.mCTR.getSeHaDeclaradoConyuge() && !this.mDG.hayLineaConyuge() || !this.mCTR.getSeHaDeclaradoConyuge() && this.mDG.hayLineaConyuge() && !bl3) {
            this.bCaso5 = true;
        }
        if (this.mCTR.getSeHaDeclaradoConyuge() && !this.mDG.getNifLineaT02().equals(string3)) {
            this.bCaso6 = true;
        }
        if (bl2 && null != this.mDG.getTablaDE() && this.mDG.getContadorDEMas17MinusNo3OtrSituNo24() == this.mDG.getTablaDE().length) {
            this.bCaso7 = true;
        }
        if (bl2 && this.mCTR.getNumHRdeclarados() > 0) {
            if (null == this.mDG.getTablaDE() || this.mDG.getTablaDE().length == 0) {
                this.bCaso8 = true;
            } else {
                HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                int n = 0;
                int n2 = 30;
                while (n < this.mCTR.getNumHRdeclarados()) {
                    if (this.mCTR.getMapaUnidadFamiliar().containsKey(n2)) {
                        hashMap.put(this.mCTR.getMapaUnidadFamiliar().get(n2), Boolean.FALSE);
                    }
                    ++n;
                    n2 += 10;
                }
                String string4 = "";
                for (n2 = 0; n2 < this.mDG.getTablaDE().length; ++n2) {
                    string4 = this.mDG.getTablaDE()[n2][this.mDG.getColumnasDE().get("NIF")];
                    if (!hashMap.containsKey(string4)) continue;
                    hashMap.put(string4, Boolean.TRUE);
                }
                if (hashMap.containsValue(Boolean.FALSE)) {
                    this.bCaso8 = true;
                }
            }
        }
        if (bl2 && this.mDG.getContadorDEVolRen1800() > Constantes.getNumhijosrentas()) {
            this.bCaso9 = true;
        }
        if (bl2 && null != this.mDG.getTablaDE()) {
            for (int i = 0; i < this.mDG.getTablaDE().length; ++i) {
                double d = Double.parseDouble(this.mDG.getTablaDE()[i][this.mDG.getColumnasDE().get("VolRen")]);
                string = this.mDG.getTablaDE()[i][this.mDG.getColumnasDE().get("NIF")];
                if (!(d > 1800.0) || "".equals(string) || this.mCTR.getMapaUnidadFamiliar().containsValue(string)) continue;
                this.bCaso10 = true;
                break;
            }
        }
        if (bl2 && this.mDG.getContadorHRMas17MinusNo3OtrSituNo24() > 0) {
            this.bCaso11 = true;
        }
        if (!bl2 && this.mDG.getContadorHSRMas24SinMinus() > 0) {
            this.bCaso12 = true;
        }
        if (!bl2 && this.mDG.getContadorDEMenos25VolRen1800_8000() > 0) {
            this.bCaso13 = true;
        }
        if (!bl2 && this.mDG.getContadorDEMenos25VolRenMayor8000() > 0) {
            this.bCaso14 = true;
        }
        if (null != this.mDG.getTablaDE()) {
            int n = 0;
            for (int i = 0; i < this.mDG.getTablaDE().length; ++i) {
                double d;
                String string5;
                String string6;
                String string7 = this.fDF.comprobarCadenaNula(this.mDG.getTablaDE()[i][this.mDG.getColumnasDE().get("NIF")]);
                string = this.fDF.comprobarCadenaNula(this.mDG.getTablaDE()[i][this.mDG.getColumnasDE().get("Minus")]);
                String string8 = this.fDF.comprobarCadenaNula(this.mDG.getTablaDE()[i][this.mDG.getColumnasDE().get("OtrSitu")]);
                String string9 = this.fDF.comprobarFechaNula(this.mDG.getTablaDE()[i][this.mDG.getColumnasDE().get("FechNac")]);
                int n3 = this.fDF.calculaEdadEfectivaHijo(string9, string6 = this.fDF.comprobarFechaNula(this.mDG.getTablaDE()[i][this.mDG.getColumnasDE().get("FechFal")]), string5 = this.fDF.comprobarFechaNula(this.mDG.getTablaTIdeclarante()[0][this.mDG.getColumnasTI().get("FechFal")]));
                if (!this.mDG.validaHijo(string7, n3, string, string8, d = Double.parseDouble(this.mDG.getTablaDE()[i][this.mDG.getColumnasDE().get("VolRen")]))) continue;
                ++n;
            }
            if (n > Constantes.getNumMaxHijos()) {
                this.bCaso15 = true;
            }
        }
        if (null != this.mDG.getTablaAS() && this.mDG.getTablaAS().length > Constantes.getCascendientes()) {
            this.bCaso16 = true;
        }
        if (this.bCaso5 || this.bCaso6 || this.bCaso7 || this.bCaso8 || this.bCaso9 || this.bCaso10) {
            this.bAnulacionDatosPersonales = true;
            this.sPorqueNoSePuedeTrasladoWeb = this.informeAnulacionDatosPersonales();
        }
        if (this.bCaso3 || this.bCaso4) {
            this.bDeclaracionIndividualSobrevenida = true;
        }
    }

    public void analisisTrasladoWeb() throws Exception {
        try {
            int n;
            String string;
            if (this.bFicheroConClaveOT) {
                this.bTrasladoWebPermitido = false;
                this.sPorqueNoSePuedeTrasladoWeb = this.sPorqueNoSePuedeTrasladoWeb + "\n\t- En sus datos fiscales figuran rentas procedentes de otros paises";
            }
            if (this.getListaClavesPresentes().contains("AG")) {
                this.bTrasladoWebPermitido = false;
                this.sPorqueNoSePuedeTrasladoWeb = this.sPorqueNoSePuedeTrasladoWeb + "\n\t- En sus datos fiscales figuran subvenciones e indemnizaciones satisfechas a agricultores, ganaderos o forestales";
            }
            if (this.getListaClavesPresentes().contains("FIC")) {
                this.bTrasladoWebPermitido = false;
                this.sPorqueNoSePuedeTrasladoWeb = this.sPorqueNoSePuedeTrasladoWeb + "\n\t- En sus datos fiscales figuran ventas de fondos de inversi\u00f3n cotizados sin retenci\u00f3n";
            }
            if (this.getListaClavesPresentes().contains("AE")) {
                this.bTrasladoWebPermitido = false;
                this.sPorqueNoSePuedeTrasladoWeb = this.sPorqueNoSePuedeTrasladoWeb + "\n\t- En sus datos fiscales figura informaci\u00f3n censal respecto al alta en alg\u00fan ep\u00edgrafe de actividad econ\u00f3mica";
            }
            if (this.getListaClavesPresentes().contains("EAC")) {
                this.bTrasladoWebPermitido = false;
                this.sPorqueNoSePuedeTrasladoWeb = this.sPorqueNoSePuedeTrasladoWeb + "\n\t- En sus datos fiscales figuran rendimientos de actividades econ\u00f3micas de entidades en r\u00e9gimen de atribuci\u00f3n de rentas";
            }
            if (this.getListaClavesPresentes().contains("PF")) {
                this.bTrasladoWebPermitido = false;
                this.sPorqueNoSePuedeTrasladoWeb = this.sPorqueNoSePuedeTrasladoWeb + "\n\t- En sus datos fiscales figuran pagos fraccionados";
            }
            if (this.getListaClavesPresentes().contains("NO")) {
                this.bTrasladoWebPermitido = false;
                this.sPorqueNoSePuedeTrasladoWeb = this.sPorqueNoSePuedeTrasladoWeb + "\n\t- En sus datos fiscales figuran transmisiones patrimoniales";
            }
            if (this.getListaClavesPresentes().contains("RTC")) {
                string = "";
                for (n = 0; n < this.trans.seleccionaTabla("RTC").length; ++n) {
                    string = this.trans.seleccionaTabla("RTC")[n][3];
                    if (string.startsWith("G")) continue;
                    this.bTrasladoWebPermitido = false;
                    this.sPorqueNoSePuedeTrasladoWeb = this.sPorqueNoSePuedeTrasladoWeb + "\n\t- En sus datos fiscales figuran rendimientos de actividades econ\u00f3micas";
                    break;
                }
            }
            if (this.getListaClavesPresentes().contains("PP")) {
                string = "";
                for (n = 0; n < this.trans.seleccionaTabla("PP").length; ++n) {
                    string = this.trans.seleccionaTabla("PP")[n][3];
                    if (!"E".equals(string)) continue;
                    this.bTrasladoWebPermitido = false;
                    this.sPorqueNoSePuedeTrasladoWeb = this.sPorqueNoSePuedeTrasladoWeb + "\n\t- En sus datos fiscales figuran planes de pensiones de profesionales o empresarios";
                    break;
                }
            }
            if (this.getListaClavesPresentes().contains("FIE")) {
                string = "";
                for (n = 0; n < this.trans.seleccionaTabla("FIE").length; ++n) {
                    string = this.trans.seleccionaTabla("FIE")[n][11];
                    if (!"O".equals(string)) continue;
                    this.bTrasladoWebPermitido = false;
                    this.sPorqueNoSePuedeTrasladoWeb = this.sPorqueNoSePuedeTrasladoWeb + "\n\t- En sus datos fiscales figuran ventas de fondos de inversi\u00f3n con retenci\u00f3n con tipo de resultado = 'O'";
                    break;
                }
            }
            if (this.getListaClavesPresentes().contains("TV")) {
                for (int i = 0; i < this.trans.seleccionaTabla("TV").length; ++i) {
                    String string2 = this.trans.seleccionaTabla("TV")[i][6];
                    double d = Double.parseDouble(this.fDF.comprobarCadenaNula(this.trans.seleccionaTabla("TV")[i][9]));
                    String string3 = this.trans.seleccionaTabla("TV")[i][10];
                    if (d == 0.0 && !"H".equals(string2) && !"J".equals(string2)) {
                        this.bTrasladoWebPermitido = false;
                        this.sPorqueNoSePuedeTrasladoWeb = this.sPorqueNoSePuedeTrasladoWeb + "\n\t- En sus datos fiscales figuran determinadas ventas de activos financieros y otros valores mobiliarios";
                        continue;
                    }
                    if (!(d < 0.0) || !"B".equals(string3) || !"K".equals(string2)) continue;
                    this.bTrasladoWebPermitido = false;
                    this.sPorqueNoSePuedeTrasladoWeb = this.sPorqueNoSePuedeTrasladoWeb + "\n\t- En sus datos fiscales figuran determinadas ventas de activos financieros y otros valores mobiliarios";
                }
            }
            if (this.getListaClavesPresentes().contains("EAE")) {
                String string4 = "";
                for (n = 0; n < this.trans.seleccionaTabla("EAE").length; ++n) {
                    string4 = this.trans.seleccionaTabla("EAE")[n][4];
                    if (!"03".equals(string4) && !"05".equals(string4)) continue;
                    this.bTrasladoWebPermitido = false;
                    this.sPorqueNoSePuedeTrasladoWeb = this.sPorqueNoSePuedeTrasladoWeb + "\n\t- En sus datos fiscales figuran retenciones de actividades econ\u00f3micas de entidades en r\u00e9gimen de atribuci\u00f3n de rentas";
                    break;
                }
            }
            if (this.getListaClavesPresentes().contains("EAF")) {
                String string5 = "";
                for (n = 0; n < this.trans.seleccionaTabla("EAF").length; ++n) {
                    string5 = this.trans.seleccionaTabla("EAF")[n][4];
                    if (!"04".equals(string5) && !"05".equals(string5)) continue;
                    this.bTrasladoWebPermitido = false;
                    this.sPorqueNoSePuedeTrasladoWeb = this.sPorqueNoSePuedeTrasladoWeb + "\n\t- En sus datos fiscales figuran deducciones por  actividades econ\u00f3micas o por doble imposici\u00f3n de entidades en r\u00e9gimen de atribuci\u00f3n de rentas";
                    break;
                }
            }
            if (this.getListaClavesPresentes().contains("TI")) {
                String string6 = "";
                n = 0;
                String string7 = "";
                boolean bl = false;
                for (int i = 0; i < this.trans.seleccionaTabla("TI").length; ++i) {
                    string6 = this.trans.seleccionaTabla("TI")[i][22];
                    string7 = this.trans.seleccionaTabla("TI")[i][23];
                    if ("S".equals(string6) && n == 0) {
                        this.bTrasladoWebPermitido = false;
                        this.sPorqueNoSePuedeTrasladoWeb = this.sPorqueNoSePuedeTrasladoWeb + "\n\t- En sus datos fiscales figuran partidas negativas de ejercicios anteriores pendientes de compensar";
                        n = 1;
                    }
                    if (!"S".equals(string7) || bl) continue;
                    this.bTrasladoWebPermitido = false;
                    this.sPorqueNoSePuedeTrasladoWeb = this.sPorqueNoSePuedeTrasladoWeb + "\n\t- En sus datos fiscales figuran transmisiones de inmuebles";
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            this.sPorqueNoSePuedeTrasladoWeb = this.sPorqueNoSePuedeTrasladoWeb + "\n\t- Se han producido errores desconocidos";
            this.bTrasladoWebPermitido = false;
            exception.printStackTrace();
        }
    }

    public String informeAnalisisDatosPersonales() {
        String string = "\nAn\u00e1lisis consistencia datos personales en datos DECLARANTE...\n";
        if (!(this.bCaso1 || this.bCaso2 || this.bCaso3 || this.bCaso4 || this.bCaso5 || this.bCaso6 || this.bCaso7 || this.bCaso8 || this.bCaso9 || this.bCaso10 || this.bCaso11 || this.bCaso12 || this.bCaso13 || this.bCaso14 || this.bCaso15 || this.bCaso16)) {
            string = string + "\t- No se ha detectado ninguna inconsistencia\n";
        } else {
            if (this.bCaso1) {
                string = string + "\t- El usuario marc\u00f3 INDV=true y en los datos hay alg\u00fan hijo con vol\u00famen de rentas superior a 1800\u0080\n";
            }
            if (this.bCaso2) {
                string = string + "\t- El usuario marc\u00f3 INDV=true y en los datos hay alg\u00fan hijo mayor de 24 a\u00f1os sin minusval\u00eda\n";
            }
            if (this.bCaso3) {
                string = string + "\t- El usuario no marc\u00f3 INDV y en los datos consta que el declarante ha fallecido durante el ejercicio\n";
            }
            if (this.bCaso4) {
                string = string + "\t- En los datos consta que el declarante ha fallecido durante el ejercicio, y existe alg\u00fan hijo con vol\u00famen de rentas mayor que 1800\u0080\n";
            }
            if (this.bCaso5) {
                string = string + "\t- Se ha rellenado c\u00f3nyuge pero no hay ning\u00fan registro TI de c\u00f3nyuge en los datos\n";
            }
            if (this.bCaso6) {
                string = string + "\t- Se ha rellenado c\u00f3nyuge pero el campo NIF del registro TI del c\u00f3nyuge no coincide con el indicado\n";
            }
            if (this.bCaso7) {
                string = string + "\t- El usuario marc\u00f3 SI en la pregunta de existencia de hijos en unidad familiar, y en los datos todos los hijos son mayores de edad sin minusval\u00eda >=65%, o con minusval\u00eda>=65% y con otras situaciones distinto de 2 \u00f3 4\n";
            }
            if (this.bCaso8) {
                string = string + "\t- El usuario rellen\u00f3 alg\u00fan NIF de hijo con rentas que no est\u00e1 presente en ning\u00fan registro de descendiente\n";
            }
            if (this.bCaso9) {
                string = string + "\t- En los datos existen m\u00e1s de 4 hijos con vol\u00famen de rentas mayor que 1800\u0080 \n";
            }
            if (this.bCaso10) {
                string = string + "\t- En los datos, existe alg\u00fan hijo con vol\u00famen de rentas mayor que 1800\u0080 cuyo NIF no se ha reflejado en la situaci\u00f3n familiar\n";
            }
            if (this.bCaso11) {
                string = string + "\t- En los datos existe alg\u00fan hijo de los reflejados en hijos con rentas, que es mayor de edad sin minusval\u00eda >=65%, o con minusval\u00eda>=65% y con otras situaciones distinto de 2 \u00f3 4\n";
            }
            if (this.bCaso12) {
                string = string + "\t- El usuario marc\u00f3 NO en la pregunta de existencia de hijos en unidad familiar, y existe alg\u00fan hijo mayor de 24 a\u00f1os sin discapacidad\n";
            }
            if (this.bCaso13) {
                string = string + "\t- El usuario marc\u00f3 NO en la pregunta de existencia de hijos en unidad familiar, y existe alg\u00fan hijo con vol\u00famen de rentas entre 1800 y 8000\u0080 que, o bien es menor de 25 a\u00f1os, o bien es mayor de 24 a\u00f1os con discapacidad>=65%\n";
            }
            if (this.bCaso14) {
                string = string + "\t- El usuario marc\u00f3 NO en la pregunta de existencia de hijos en unidad familiar, y existe alg\u00fan hijo con vol\u00famen de rentas mayor que 8000\u0080 que, o bien es menor de 25 a\u00f1os, o bien es mayor de 24 a\u00f1os con discapacidad>=65%\n";
            }
            if (this.bCaso15) {
                string = string + "\t- En los datos existen m\u00e1s de 12 hijos trasladables\n";
            }
            if (this.bCaso16) {
                string = string + "\t- En los datos existen m\u00e1s de 4 ascendientes\n";
            }
        }
        return string;
    }

    private String informeAnulacionDatosPersonales() {
        String string = "Se han detectado las siguientes insonsistencias en datos personales que impiden el traslado de los mismos:\n";
        if (this.bCaso5) {
            string = string + "\t- Se ha rellenado c\u00f3nyuge pero no hay ning\u00fan registro TI de c\u00f3nyuge en los datos\n";
        }
        if (this.bCaso6) {
            string = string + "\t- Se ha rellenado c\u00f3nyuge pero el campo NIF del registro TI del c\u00f3nyuge no coincide con el indicado\n";
        }
        if (this.bCaso7) {
            string = string + "\t- El usuario marc\u00f3 SI en la pregunta de existencia de hijos en unidad familiar, y en los datos todos los hijos son mayores de edad sin minusval\u00eda >=65%, o con minusval\u00eda>=65% y con otras situaciones distinto de 2 \u00f3 4\n";
        }
        if (this.bCaso8) {
            string = string + "\t- El usuario rellen\u00f3 alg\u00fan NIF de hijo con rentas que no est\u00e1 presente en ning\u00fan registro de descendiente\n";
        }
        if (this.bCaso9) {
            string = string + "\t- En los datos existen m\u00e1s de 4 hijos con vol\u00famen de rentas mayor que 1800\u0080 \n";
        }
        if (this.bCaso10) {
            string = string + "\t- En los datos, existe alg\u00fan hijo con vol\u00famen de rentas mayor que 1800\u0080 cuyo NIF no se ha reflejado en la situaci\u00f3n familiar\n";
        }
        return string;
    }
}

