/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.componentes.motorvisual;

import es.aeat.pare.componentes.AEATLogger;
import es.aeat.pare.componentes.motorvisual.Documento;
import java.util.Map;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentoXMLHandler
extends DefaultHandler {
    private StringBuffer charactersBuffer = new StringBuffer();
    private boolean tragaCaracteres = false;
    private final Map<String, Documento> mapaDocumentos;
    private Documento documento;

    public DocumentoXMLHandler(Map<String, Documento> map) {
        this(map, Logger.getAnonymousLogger());
    }

    public DocumentoXMLHandler(Map<String, Documento> map, Logger logger) {
        this.mapaDocumentos = map;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.tragaCaracteres) {
            this.charactersBuffer.append(cArray, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        block17: {
            try {
                if (string3.equals("Nombre")) {
                    this.documento.setClaveConfiguracion(this.charactersBuffer.toString().trim());
                    this.tragaCaracteres = false;
                }
                if (string3.equals("idVariable")) {
                    if (this.documento != null) {
                        this.documento.setIdVariable(this.charactersBuffer.toString().trim());
                        this.tragaCaracteres = false;
                    }
                    break block17;
                }
                if (string3.equals("porDefecto")) {
                    Boolean bl = new Boolean(this.charactersBuffer.toString().trim());
                    this.documento.setConfiguracionPorDefecto(bl);
                    this.tragaCaracteres = false;
                    break block17;
                }
                if (string3.equals("nombreClaseDocumento")) {
                    this.documento.setNombreClaseDocumento(this.charactersBuffer.toString().trim());
                    this.tragaCaracteres = false;
                    break block17;
                }
                if (string3.equals("nombreClaseFormateadora")) {
                    this.documento.setNombreClaseFormateadora(this.charactersBuffer.toString().trim());
                    this.tragaCaracteres = false;
                    break block17;
                }
                if (!string3.equals("Documento")) break block17;
                try {
                    if (this.mapaDocumentos.containsKey(this.documento.getIdVariable())) {
                        Documento documento = this.mapaDocumentos.get(this.documento.getIdVariable());
                        if (this.documento.isConfiguracionPorDefecto()) {
                            this.documento.addDocAlternativo(documento);
                            this.documento.setClaveConfiguracionAlternativa(documento.getClaveConfiguracion());
                            this.mapaDocumentos.put(this.documento.getIdVariable(), this.documento);
                        } else {
                            documento.addDocAlternativo(this.documento);
                            documento.setClaveConfiguracionAlternativa(this.documento.getClaveConfiguracion());
                            this.mapaDocumentos.put(this.documento.getIdVariable(), documento);
                        }
                    } else {
                        this.mapaDocumentos.put(this.documento.getIdVariable(), this.documento);
                    }
                    this.documento = null;
                }
                catch (Exception exception) {
                    AEATLogger.getLogger().fatal((Object)("Error en " + string3 + " (IdVariable = " + this.documento.getIdVariable() + ")"));
                }
                finally {
                    this.documento = null;
                }
            }
            catch (Exception exception) {
                AEATLogger.getLogger().fatal((Object)("Error en " + string3), (Throwable)exception);
            }
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("Documento")) {
            this.documento = new Documento();
        } else if (string3.equals("Nombre") || string3.equals("idVariable") || string3.equals("porDefecto") || string3.equals("nombreClaseDocumento") || string3.equals("nombreClaseFormateadora")) {
            this.tragaCaracteres = true;
            this.charactersBuffer.setLength(0);
        }
    }
}

