/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.componentes;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;

public class MulticolumnRenderer
extends JPanel
implements ListCellRenderer {
    private static final long serialVersionUID = 1L;
    public static final int COL_VISIBLE_IZQUIERDA = 0;
    public static final int COL_VISIBLE_DERECHA = 1;
    public static final int COL_VISIBLE_AMBAS = 2;
    public static final int COL_SOLO_ARRIBA_DERECHA = 3;
    protected int colVisible = 1;
    protected JLabel izquierda = new JLabel();
    protected JLabel derecha = new JLabel();
    protected Border borde = BorderFactory.createLineBorder(Color.lightGray);
    protected boolean filtrado;
    protected boolean filtrable;

    public MulticolumnRenderer() {
        this(1);
    }

    public MulticolumnRenderer(int n) {
        this.colVisible = n;
        this.setLayout(new GridBagLayout());
        this.izquierda.setOpaque(true);
        this.derecha.setOpaque(true);
        this.izquierda.setBorder(this.borde);
        this.derecha.setBorder(this.borde);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.add((Component)this.izquierda, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.add((Component)this.derecha, gridBagConstraints);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (object != null) {
            this.izquierda.setText((String)((ArrayList)object).get(0));
            this.derecha.setText((String)((ArrayList)object).get(1));
            Border border = BorderFactory.createLineBorder(bl ? jList.getSelectionBackground() : jList.getBackground());
            if (jList.isShowing()) {
                if (this.colVisible == 3) {
                    this.izquierda.setVisible(false);
                } else {
                    this.izquierda.setVisible(true);
                }
                this.derecha.setVisible(true);
                this.izquierda.setBorder(this.borde);
                this.derecha.setBorder(this.borde);
            } else {
                switch (this.colVisible) {
                    case 2: {
                        this.izquierda.setVisible(true);
                        this.derecha.setVisible(true);
                        this.derecha.setBorder(border);
                        this.izquierda.setBorder(border);
                        break;
                    }
                    case 1: {
                        this.izquierda.setVisible(false);
                        this.derecha.setVisible(true);
                        this.derecha.setBorder(border);
                        break;
                    }
                    case 3: {
                        this.izquierda.setVisible(false);
                        this.derecha.setVisible(true);
                        this.derecha.setBorder(border);
                        break;
                    }
                    case 0: {
                        this.izquierda.setVisible(true);
                        this.izquierda.setBorder(border);
                        this.derecha.setVisible(false);
                        break;
                    }
                }
            }
            if (bl) {
                this.izquierda.setBackground(jList.getSelectionBackground());
                this.izquierda.setForeground(jList.getSelectionForeground());
                this.derecha.setBackground(jList.getSelectionBackground());
                this.derecha.setForeground(jList.getSelectionForeground());
            } else {
                this.izquierda.setBackground(jList.getBackground());
                this.izquierda.setForeground(jList.getForeground());
                this.derecha.setBackground(jList.getBackground());
                this.derecha.setForeground(jList.getForeground());
                Component component = this.getComponenteVisible();
                Color color = Color.white;
                if (component != null) {
                    component.setBackground(color);
                } else {
                    this.izquierda.setBackground(color);
                    this.derecha.setBackground(color);
                }
            }
            this.setFont(jList.getFont());
            return this;
        }
        return new DefaultListCellRenderer();
    }

    protected Component getComponenteVisible() {
        JLabel jLabel = null;
        switch (this.getColVisible()) {
            case 1: {
                jLabel = this.derecha;
                break;
            }
            case 0: {
                jLabel = this.izquierda;
            }
        }
        return jLabel;
    }

    public int getColVisible() {
        return this.colVisible;
    }

    public void setColVisible(int n) {
        this.colVisible = n;
    }
}

