/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.componentes;

import es.aeat.pare.componentes.LabelBarra;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

public class MemoryMonitorBar
extends JPanel {
    private static final long serialVersionUID = 3191167293808777382L;
    Logger logger = Logger.getLogger(MemoryMonitorBar.class.getName());
    private JLabel label;
    private int peso;
    private SwingWorker<Void, Void> monitorWorker;
    private boolean go;

    public MemoryMonitorBar() {
        this.setLayout(new FlowLayout(1, 5, 0));
        this.label = new LabelBarra();
        this.add(this.label);
        this.go = true;
        this.monitorWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                while (MemoryMonitorBar.this.go) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MemoryMonitorBar.this.repaint();
                        }
                    });
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {}
                }
                return null;
            }

            @Override
            protected void done() {
                MemoryMonitorBar.this.logger.log(Level.INFO, "Monitor memoria finalizado.");
            }
        };
        this.monitorWorker.execute();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        long l = Runtime.getRuntime().freeMemory();
        long l2 = Runtime.getRuntime().totalMemory();
        long l3 = Runtime.getRuntime().maxMemory();
        long l4 = l2 - l;
        long l5 = l4 / 0x100000L;
        long l6 = l3 / 0x100000L;
        this.label.setText("Usados " + l5 + " de " + l6 + " MB (" + l5 * 100L / l6 + "%)");
        Insets insets = this.getInsets();
        int n = this.getWidth() - insets.left - insets.right;
        int n2 = this.getHeight() - insets.top - insets.bottom;
        int n3 = insets.left;
        int n4 = insets.left + (int)((long)n * l4 / l3);
        int n5 = insets.left + (int)((long)n * l2 / l3);
        int n6 = insets.left + n;
        int n7 = insets.top;
        int n8 = insets.top + n2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, n2, new Color(29366)));
        graphics2D.fillRect(n3, n7, n4, n8);
        graphics2D.setPaint(paint);
        graphics2D.setColor(new Color(0x999999));
        graphics2D.fillRect(n4, n7, n5, n8);
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(n5, n7, n6, n8);
    }

    public void addAction(AbstractAction abstractAction) {
    }

    public void delAction(AbstractAction abstractAction) {
    }

    public JComponent getComponente() {
        return this;
    }

    public Object getElemento() {
        return null;
    }

    public String getEtiqueta() {
        return null;
    }

    public int getPeso() {
        return this.peso;
    }

    public void setElemento(Object object) {
    }

    public void setEtiqeta(String string) {
    }

    public void setPeso(int n) {
        this.peso = n;
    }

    public void stopMonitor() {
        this.go = false;
    }
}

