/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.componentes;

import es.aeat.pare.aplicacion.Constantes;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JTextPane;
import javax.swing.plaf.FontUIResource;

public final class JTextPaneRaya
extends JTextPane {
    private static final long serialVersionUID = -8261064968860521116L;
    private Color colorAsignado;
    private Color colorRemarcado;
    private boolean rayado = true;
    private boolean subrayado = false;
    private boolean cursiva = false;
    private boolean llave = false;
    private int estilo = 0;
    private static final int ANCHO_LLAVE = 20;
    private String imagen = "llave5.png";
    private int x1 = 0;
    private int x2 = 0;
    private int y1 = 10;

    public JTextPaneRaya() {
        this.setBackground(Color.black);
        this.setText("*** Label_raya relleno por defecto ****");
        this.setFocusable(false);
    }

    public boolean isRayado() {
        return this.rayado;
    }

    public void setRayado(boolean bl) {
        this.rayado = bl;
        this.updateUI();
    }

    public boolean isSubrayado() {
        return this.subrayado;
    }

    public void setSubrayado(boolean bl) {
        this.subrayado = bl;
        this.updateUI();
    }

    public void setCursiva(boolean bl) {
        this.cursiva = bl;
        this.updateUI();
    }

    public boolean isCursiva() {
        return this.cursiva;
    }

    public boolean isLlave() {
        return this.llave;
    }

    public void setLlave(boolean bl) {
        this.llave = bl;
        this.updateUI();
    }

    public void setEstilo(int n) {
        this.estilo = n;
        this.updateUI();
    }

    public String getImagen() {
        return this.imagen;
    }

    public void setImagen(String string) {
        this.imagen = string;
        this.updateUI();
    }

    public int getEstilo() {
        return this.estilo;
    }

    public void setFormato(int n, boolean bl, boolean bl2) {
        this.setFormato(n, bl, bl2, false, false);
    }

    public void setFormato(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.estilo = n;
        this.subrayado = bl;
        this.rayado = bl2;
        this.cursiva = bl3;
        this.llave = bl4;
        this.updateUI();
    }

    protected void arreglacolor() {
        if (this.colorAsignado != null) {
            this.colorRemarcado = this.colorAsignado;
        }
        super.setBackground(this.colorRemarcado);
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = this.getText();
        String string2 = this.filtradoUltimoTag(string);
        Rectangle rectangle = this.getBounds();
        if (string2.equals(" ")) {
            this.x1 = 0;
        } else {
            int n2 = fontMetrics.charsWidth(string2.toCharArray(), 0, string2.length());
            this.x1 = n2 + 5;
        }
        if (this.llave) {
            n = rectangle.width - 1;
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = ImageIO.read(this.getClass().getResource(Constantes.getDirectorioImagenes() + this.imagen));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            graphics.drawImage(bufferedImage, n - 20, 0, 20, rectangle.height, null);
        }
        if (this.subrayado) {
            this.y1 = rectangle.height - 3;
            graphics.drawLine(3, this.y1, this.x1 - 3, this.y1);
        }
        if (this.rayado) {
            this.x2 = rectangle.width;
            if (this.llave) {
                this.x2 -= 20;
            }
            this.y1 = rectangle.height - 6;
            for (n = this.x1; n <= this.x2; n += 5) {
                graphics.drawLine(n, this.y1, n + 1, this.y1);
            }
        }
        super.paint(graphics);
    }

    private String filtradoUltimoTag(String string) {
        boolean bl = true;
        String[] stringArray = string.split("<\\s*br/?\\s*>");
        if (stringArray.length == 1) {
            stringArray = string.split("\\n");
        }
        String string2 = stringArray[stringArray.length - 1];
        char[] cArray = string2.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '<') {
                bl = false;
                continue;
            }
            if (cArray[i] == '>') {
                bl = true;
                continue;
            }
            if (!bl) continue;
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    @Override
    public void setBackground(Color color) {
        this.colorAsignado = color;
        super.setBackground(color);
    }

    @Override
    public void setFont(Font font) {
        int n = 0;
        int n2 = font.getSize();
        if (this.estilo == 1 || this.estilo == 2 || this.estilo == 3) {
            ++n;
            if (this.estilo == 1) {
                n2 += 7;
            } else if (this.estilo == 2) {
                n2 += 5;
            }
        } else if (this.estilo == 10 || this.estilo == 11) {
            ++n;
            if (this.estilo == 10) {
                n2 += 4;
            } else if (this.estilo == 11) {
                n2 += 2;
            }
        } else if (this.estilo == 4) {
            n2 -= 2;
        }
        if (this.cursiva) {
            n += 2;
        }
        super.setFont(new FontUIResource(font.deriveFont(n, n2)));
    }

    @Override
    public Dimension getPreferredSize() {
        try {
            return super.getPreferredSize();
        }
        catch (Exception exception) {
            return new Dimension();
        }
    }
}

