/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.componentes;

import com.Ostermiller.util.Browser;
import es.aeat.pare.componentes.AEATLogger;
import es.aeat.pare.re14.AEAT100j;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class JHyperlink
extends JButton {
    private static final long serialVersionUID = 1L;
    private static final BrowseAction defaultBrowseAction = new BrowseAction();
    private URI targetURI;
    private boolean visited;
    private Color normalForeground = UIManager.getColor("Hyperlink.foreground");
    private Color activeForeground = UIManager.getColor("Hyperlink.activeForeground");
    private Color inactiveForeground = UIManager.getColor("Hyperlink.inactiveForeground");
    private Color visitedForeground = UIManager.getColor("Hyperlink.visitedForeground");
    private boolean drawUnderline = true;
    private Font fontUnderline;
    private Font fontClean;
    private boolean esSub;

    public JHyperlink() {
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setForeground(this.normalForeground);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setMargin(new Insets(0, 0, 0, 2));
        this.setAction(defaultBrowseAction);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (AEAT100j.getFrame() != null) {
                    AEAT100j.getFrame().setCursor(Cursor.getDefaultCursor());
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (AEAT100j.getFrame() != null) {
                    AEAT100j.getFrame().setCursor(Cursor.getDefaultCursor());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (AEAT100j.getFrame() != null) {
                    AEAT100j.getFrame().setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }
        });
    }

    public JHyperlink(String string) {
        this();
        this.setText(string);
    }

    public JHyperlink(String string, String string2) throws URISyntaxException {
        this(string, new URI(string2));
    }

    public JHyperlink(String string, URI uRI) {
        this(string);
        this.setTarget(uRI);
    }

    public JHyperlink(String string, Action action) {
        this(string);
        this.setAction(action);
        this.setText(string);
    }

    public JHyperlink(String string, Icon icon) {
        this(string);
        this.setIcon(icon);
    }

    public JHyperlink(Icon icon, String string) throws URISyntaxException {
        this(null, icon, string);
    }

    public JHyperlink(String string, Icon icon, String string2) throws URISyntaxException {
        this(string, new URI(string2));
        this.setIcon(icon);
    }

    public JHyperlink(String string, Icon icon, URI uRI) {
        this(string);
        this.setIcon(icon);
        this.setTarget(uRI);
    }

    public void setTarget(URI uRI) {
        this.targetURI = uRI;
        this.setToolTipText(uRI.toASCIIString());
    }

    public URI getTarget() {
        return this.targetURI;
    }

    public void setVisited(boolean bl) {
        this.visited = bl;
    }

    public boolean isVisited() {
        return this.visited;
    }

    @Override
    public void setForeground(Color color) {
        this.normalForeground = color;
        super.setForeground(color);
    }

    public void setVisitedForeground(Color color) {
        this.visitedForeground = color;
    }

    public void setDrawUnderline(boolean bl) {
        this.drawUnderline = bl;
    }

    public boolean getDrawUnderline() {
        return this.drawUnderline;
    }

    public Font getFontUnderline() {
        if (this.fontUnderline == null) {
            HashMap<TextAttribute, Integer> hashMap = new HashMap<TextAttribute, Integer>();
            hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            this.fontUnderline = this.getFont().deriveFont(hashMap);
            this.fontClean = null;
        }
        return this.fontUnderline;
    }

    public void setFontUnderline(Font font) {
        this.fontUnderline = font;
    }

    public Font getFontClean() {
        if (this.fontClean == null) {
            HashMap hashMap = new HashMap();
            hashMap.remove(TextAttribute.UNDERLINE);
            this.fontClean = this.getFont().deriveFont(hashMap);
            this.fontUnderline = null;
        }
        return this.fontClean;
    }

    public void setFontClean(Font font) {
        this.fontClean = font;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        ButtonModel buttonModel = this.getModel();
        if (!this.isEnabled()) {
            super.setForeground(this.inactiveForeground);
        } else if (buttonModel.isArmed()) {
            super.setForeground(this.activeForeground);
        } else if (this.visited) {
            super.setForeground(this.visitedForeground);
        } else {
            super.setForeground(this.normalForeground);
        }
        if (this.drawUnderline) {
            if (!this.esSub) {
                this.esSub = true;
                this.setFont(new FontUIResource(this.getFontUnderline()));
            }
        } else if (this.esSub) {
            this.esSub = false;
            this.setFont(new FontUIResource(this.getFontClean()));
        }
        super.paintComponent(graphics);
    }

    static {
        UIManager.put("Hyperlink.foreground", Color.blue);
        UIManager.put("Hyperlink.activeForeground", Color.red);
        UIManager.put("Hyperlink.inactiveForeground", Color.DARK_GRAY);
        UIManager.put("Hyperlink.visitedForeground", new Color(85, 145, 90));
    }

    private static class BrowseAction
    extends AbstractAction {
        private static final long serialVersionUID = -8184360153910562144L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JHyperlink jHyperlink = (JHyperlink)actionEvent.getSource();
            URI uRI = jHyperlink.getTarget();
            if (uRI != null) {
                try {
                    String string = uRI.toString();
                    boolean bl = true;
                    Browser.init();
                    if (bl) {
                        Browser.displayURL((String)string);
                    } else {
                        Browser.displayURLinNew((String)string);
                    }
                    jHyperlink.setVisited(true);
                }
                catch (Exception exception) {
                    AEATLogger.getLogger().fatal((Object)"\n\r");
                    AEATLogger.getLogger().fatal((Object)exception);
                }
            }
        }
    }
}

