/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.componentes;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class DashedBorder
implements Border {
    private int THICKNESS = 1;
    private Color color;
    private int dashWidth;
    private int dashHeight;
    private int margen = 4;

    public DashedBorder() {
        this(Color.black, 2, 2);
    }

    public DashedBorder(Color color, int n, int n2) {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid width: " + n);
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Invalid height: " + n2);
        }
        this.color = color;
        this.dashWidth = n;
        this.dashHeight = n2;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        graphics.setColor(this.color);
        int n7 = Math.round((n3 - this.margen * 2) / this.dashWidth);
        int n8 = Math.round((n4 - this.margen * 2) / this.dashHeight);
        for (n6 = 0; n6 <= n7; n6 += 2) {
            n5 = n + this.margen + this.dashWidth * n6;
            graphics.fillRect(n5, n2 + this.margen, this.dashWidth, this.THICKNESS);
            graphics.fillRect(n5, n2 + n4 - this.margen, this.dashWidth, this.THICKNESS);
        }
        for (n6 = 0; n6 <= n8; n6 += 2) {
            n5 = n + this.margen + this.dashHeight * n6;
            graphics.fillRect(n + this.margen, n5, this.THICKNESS, this.dashHeight);
            graphics.fillRect(n + n3 - this.margen, n5, this.THICKNESS, this.dashHeight);
        }
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return new Insets(this.THICKNESS, this.THICKNESS, this.THICKNESS, this.THICKNESS);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public void setMargen(int n) {
        this.margen = n;
    }
}

