/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.componentes;

import es.aeat.pare.aplicacion.Aplicacion;
import es.aeat.pare.componentes.AEATmotorCtrlDocument;
import es.aeat.pare.componentes.motorvisual.Documento;
import es.aeat.pftw.mtrc.api.configuracion.RegEntrada;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;

public class AEATTextField
extends JTextField {
    private boolean bdesarrollo = false;
    List<AEATTextField> listaFormateable = new ArrayList<AEATTextField>();
    private static final long serialVersionUID = 1L;
    private static AEATmotorCtrlDocument.AEATStringDocument dString = new AEATmotorCtrlDocument.AEATStringDocument(15, null);
    private static AEATmotorCtrlDocument.AEATCadNumericaDocument dCadNum = new AEATmotorCtrlDocument.AEATCadNumericaDocument(15, null);
    private static AEATmotorCtrlDocument.AEATAlfabeticoDocument dAlfab = new AEATmotorCtrlDocument.AEATAlfabeticoDocument(15);
    private static AEATmotorCtrlDocument.AEATBooleanDocument dBoolean = new AEATmotorCtrlDocument.AEATBooleanDocument(1);
    private static AEATmotorCtrlDocument.AEATEnteroDocument dInt = new AEATmotorCtrlDocument.AEATEnteroDocument(10);
    private static AEATmotorCtrlDocument.AEATDobleDocument dDbl = new AEATmotorCtrlDocument.AEATDobleDocument(11, 2);
    private static AEATmotorCtrlDocument.AEATFechaDocument dFecha = new AEATmotorCtrlDocument.AEATFechaDocument(10);

    public AEATTextField() {
        if (this.bdesarrollo) {
            this.setOpaque(false);
        }
    }

    public AEATTextField(int n) {
        super(n);
        if (this.bdesarrollo) {
            this.setOpaque(false);
        }
    }

    @Override
    public void setName(String string) {
        try {
            Document document = this.instalaDocumento(string, "");
            if (document != null) {
                this.setDocument(document);
            }
            super.setName(string);
        }
        catch (ExceptionMotor exceptionMotor) {
            exceptionMotor.printStackTrace();
        }
    }

    private Document instalaDocumento(String string, String string2) throws ExceptionMotor {
        RegEntrada regEntrada = (RegEntrada)Aplicacion.getMotor().obtenerCaracteristicasPartida(string);
        if (regEntrada == null) {
            return new DefaultStyledDocument();
        }
        String string3 = regEntrada.getTipoDato();
        if (Aplicacion.getMapaDocumentos() != null) {
            Documento documento = Aplicacion.getMapaDocumentos().get(string);
            String string4 = "";
            if (documento != null && !string2.equals("")) {
                string4 = documento.getNombreClaseDocumento();
                if (documento.getClaveConfiguracion().equals(string2)) {
                    string4 = documento.getNombreClaseDocumento();
                }
                if (documento.getClaveConfiguracionAlternativa().equals(string2)) {
                    string4 = documento.getDocAltenativos().get(0).getNombreClaseDocumento();
                }
            }
            if (string3.equalsIgnoreCase("CADENA") && string4.equalsIgnoreCase("") || string4.endsWith("StringAlfanumerico")) {
                dString = new AEATmotorCtrlDocument.AEATStringDocument(regEntrada.getTamannioCampo(), null);
                dString.setNomControl(string);
                dString.setbAdmiteNegativo(regEntrada.getAdmiteNegativo());
                dString.setbMultilinea(false);
                dString.setLanzaVentana("");
                return dString;
            }
            if ((string3.equalsIgnoreCase("CADENA_NUMERICA") || string3.equalsIgnoreCase("CADENA_NUMERICA_2")) && string4.equalsIgnoreCase("")) {
                dCadNum = new AEATmotorCtrlDocument.AEATCadNumericaDocument(regEntrada.getTamannioCampo(), null);
                dCadNum.setNomControl(string);
                dCadNum.setbAdmiteNegativo(regEntrada.getAdmiteNegativo());
                return dCadNum;
            }
            if (string3.equalsIgnoreCase("ALFABETICO") && string4.equalsIgnoreCase("") || string4.endsWith("StringAlfabetico")) {
                dAlfab = new AEATmotorCtrlDocument.AEATAlfabeticoDocument(regEntrada.getTamannioCampo());
                dAlfab.setNomControl(string);
                dAlfab.setbAdmiteNegativo(regEntrada.getAdmiteNegativo());
                return dAlfab;
            }
            if (string3.equalsIgnoreCase("LOGICO")) {
                dBoolean = new AEATmotorCtrlDocument.AEATBooleanDocument(regEntrada.getTamannioCampo());
                dBoolean.setNomControl(string);
                this.setHorizontalAlignment(0);
                return dBoolean;
            }
            if (string3.equalsIgnoreCase("ENTERO") && string4.equalsIgnoreCase("")) {
                int n = regEntrada.getTamannioCampo();
                if (n == 0) {
                    String string5 = regEntrada.getPropiedad("NumeroEnteros");
                    n = Integer.valueOf(string5);
                }
                dInt = new AEATmotorCtrlDocument.AEATEnteroDocument(n);
                dInt.setNomControl(string);
                dInt.setNomTabla(regEntrada.getIdTabla());
                this.setHorizontalAlignment(4);
                return dInt;
            }
            if ((string3.equalsIgnoreCase("DOBLE") || string3.equalsIgnoreCase("BIGDECIMAL")) && string4.equalsIgnoreCase("")) {
                int n = -1;
                int n2 = -1;
                String[] stringArray = regEntrada.getPropiedad("LongitudBigDecimal").split(",");
                n = Integer.valueOf(stringArray[0]);
                n2 = Integer.valueOf(stringArray[1]);
                dDbl = new AEATmotorCtrlDocument.AEATDobleDocument(n, n2);
                if (regEntrada.getPropiedad("AdmiteNegativo").toString().equals("True")) {
                    dDbl.setbAdmiteNegativo(1);
                } else {
                    dDbl.setbAdmiteNegativo(0);
                }
            } else {
                dDbl = new AEATmotorCtrlDocument.AEATDobleDocument(regEntrada.getTamannioCampo(), regEntrada.getNumDecimales());
                dDbl.setbAdmiteNegativo(regEntrada.getAdmiteNegativo());
            }
            dDbl.setNomTabla(regEntrada.getIdTabla());
            dDbl.setNomControl(string);
            dDbl.setLanzaVentana(regEntrada.getLanzaVentana());
            this.setHorizontalAlignment(4);
            return dDbl;
        }
        if (string3.equalsIgnoreCase("FECHA")) {
            dFecha = new AEATmotorCtrlDocument.AEATFechaDocument(regEntrada.getTamannioCampo());
            dFecha.setNomControl(string);
            return dFecha;
        }
        return null;
    }

    public void accesibilidad(String string) {
        this.setToolTipText(string);
        this.getAccessibleContext().setAccessibleName(string);
        this.getAccessibleContext().setAccessibleDescription(string);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.bdesarrollo) {
            String string = this.getName();
            if (this.isEnabled()) {
                graphics.setColor(Color.white);
            } else {
                graphics.setColor(Color.yellow);
            }
            Rectangle rectangle = this.getBounds();
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
            graphics.setColor(Color.blue);
            if (string != null) {
                graphics.drawChars(string.toCharArray(), 0, string.length(), 5, 15);
            }
        }
        super.paint(graphics);
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip jToolTip = super.createToolTip();
        jToolTip.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                super.mousePressed(mouseEvent);
            }
        });
        return jToolTip;
    }

    public void setFormateador(String string) throws ExceptionMotor {
        String string2 = Aplicacion.getMotor().obtenerPartidaString(this.getName());
        Document document = this.instalaDocumento(this.getName(), string);
        if (document != null) {
            this.setDocument(document);
            final String string3 = string2;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AEATTextField.this.setText(string3);
                }
            });
        }
    }

    @Override
    public void setText(String string) {
        if (this.listaFormateable != null && this.listaFormateable.size() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        AEATTextField.this.fireFormateable();
                    }
                    catch (ExceptionMotor exceptionMotor) {
                        exceptionMotor.printStackTrace();
                    }
                }
            });
        }
        super.setText(string);
    }

    public void addListenerFormateable(AEATTextField aEATTextField) {
        this.listaFormateable.add(aEATTextField);
    }

    public void removeListenerFormateable(AEATTextField aEATTextField) {
        this.listaFormateable.remove(aEATTextField);
    }

    private void fireFormateable() throws ExceptionMotor {
        for (AEATTextField aEATTextField : this.listaFormateable) {
            aEATTextField.setFormateador(this.getText().trim());
        }
    }

    @Override
    public void setColumns(int n) {
        super.setColumns(n);
        this.setMinimumSize(this.getPreferredSize());
    }
}

