/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.componentes;

import es.aeat.pare.componentes.AEATLogger;
import es.aeat.pare.componentes.Excepcion;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.jdesktop.jxlayer.plaf.ext.LockableUI;
import org.jdesktop.swingx.painter.BusyPainter;

public class AEATLockableUI {
    private JEspera espera = null;

    public void stop() {
        try {
            if (this.espera != null) {
                this.espera.stop();
                this.espera = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean estableceUI(Object object) {
        BusyPainterUI busyPainterUI = new BusyPainterUI();
        try {
            ((JXLayer)object).setUI((LayerUI)busyPainterUI);
            return true;
        }
        catch (Exception exception) {
            try {
                ((JXLayer)object).setUI((LayerUI)busyPainterUI);
                return true;
            }
            catch (Exception exception2) {
                return false;
            }
        }
    }

    public boolean metodoAInvocar(JXLayer<?> jXLayer, final Object object, final Method method, final Object[] objectArray) {
        try {
            boolean bl;
            if (jXLayer == null) {
                throw new Excepcion("Parametro lockablecomponent es nulo!!!!");
            }
            objectArray.clone();
            boolean bl2 = bl = jXLayer.getUI() != null;
            if (!bl && this.estableceUI(jXLayer)) {
                bl = true;
            }
            if (bl) {
                this.espera = new JEspera(jXLayer.getUI());
            }
            SwingWorker swingWorker = new SwingWorker(1){

                @Override
                public Object construct() {
                    if (AEATLockableUI.this.espera != null) {
                        AEATLockableUI.this.espera.show();
                    }
                    return null;
                }
            };
            swingWorker.start();
            SwingWorker swingWorker2 = new SwingWorker(10){

                @Override
                public Object construct() {
                    try {
                        method.invoke(object, objectArray);
                    }
                    catch (Exception exception) {
                        AEATLogger.getLogger().fatal((Object)("Funci\u00f3n no ejecutada (Reflection)... " + exception.toString()));
                    }
                    if (AEATLockableUI.this.espera != null) {
                        AEATLockableUI.this.espera.stop();
                        AEATLockableUI.this.espera = null;
                    }
                    return null;
                }
            };
            swingWorker2.start();
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception.toString());
            return false;
        }
        return true;
    }

    public class JEspera {
        private HiloEsperaThread hiloEspera;
        private boolean running = false;
        private LockableUI lockablecomponent = null;

        public JEspera(Object object) {
            this.lockablecomponent = (LockableUI)object;
        }

        public JEspera(LockableUI lockableUI) {
            this.lockablecomponent = lockableUI;
        }

        public void show() {
            this.hiloEspera = null;
            this.hiloEspera = new HiloEsperaThread();
            this.hiloEspera.start();
        }

        public boolean running() {
            return this.running;
        }

        public void stop() {
            this.hiloEspera.interrupt();
            this.running = false;
        }

        class HiloEsperaThread
        extends Thread {
            public HiloEsperaThread() {
                this.setPriority(1);
            }

            @Override
            public void run() {
                while (true) {
                    JEspera.this.lockablecomponent.setLocked(true);
                    JEspera.this.running = true;
                    try {
                        HiloEsperaThread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        if (JEspera.this.lockablecomponent != null) {
                            JEspera.this.lockablecomponent.setLocked(false);
                        }
                        JEspera.this.running = false;
                        return;
                    }
                }
            }
        }
    }

    public static class BusyPainterUI
    extends LockableUI
    implements ActionListener {
        private static final long serialVersionUID = -2237034937881491750L;
        private BusyPainter busyPainter = new BusyPainter(){

            protected void doPaint(Graphics2D graphics2D, JComponent jComponent, int n, int n2) {
                Rectangle rectangle = this.getTrajectory().getBounds();
                int n3 = n - rectangle.width - 2 * rectangle.x;
                int n4 = n2 - rectangle.height - 2 * rectangle.y;
                graphics2D.translate(n3 / 2, n4 / 2);
                super.doPaint(graphics2D, (Object)jComponent, n, n2);
            }
        };
        private Timer timer;
        private int frameNumber;

        public BusyPainterUI() {
            this.busyPainter.setPointShape((Shape)new Ellipse2D.Double(0.0, 0.0, 20.0, 20.0));
            this.busyPainter.setTrajectory((Shape)new Ellipse2D.Double(0.0, 0.0, 100.0, 100.0));
            this.timer = new Timer(100, this);
        }

        protected void paintLayer(Graphics2D graphics2D, JXLayer<? extends JComponent> jXLayer) {
            super.paintLayer(graphics2D, jXLayer);
            if (this.isLocked()) {
                this.busyPainter.paint(graphics2D, jXLayer, jXLayer.getWidth(), jXLayer.getHeight());
            }
        }

        public void setLocked(boolean bl) {
            super.setLocked(bl);
            if (bl) {
                this.timer.start();
            } else {
                this.timer.stop();
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.frameNumber = (this.frameNumber + 1) % 8;
            this.busyPainter.setFrame(this.frameNumber);
            this.setDirty(true);
        }
    }

    public abstract class SwingWorker {
        private Object value;
        private ThreadVar threadVar;

        protected synchronized Object getValue() {
            return this.value;
        }

        private synchronized void setValue(Object object) {
            this.value = object;
        }

        public abstract Object construct();

        public void finished() {
        }

        public void interrupt() {
            Thread thread = this.threadVar.get();
            if (thread != null) {
                thread.interrupt();
            }
            this.threadVar.clear();
        }

        public Object get() {
            Thread thread;
            while ((thread = this.threadVar.get()) != null) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
            return this.getValue();
        }

        public SwingWorker(int n) {
            final Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SwingWorker.this.finished();
                }
            };
            Runnable runnable2 = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        SwingWorker.this.setValue(SwingWorker.this.construct());
                    }
                    catch (Exception exception) {
                        AEATLogger.getLogger().debug((Object)("SwingWorker : " + exception.toString()));
                    }
                    finally {
                        SwingWorker.this.threadVar.clear();
                    }
                    SwingUtilities.invokeLater(runnable);
                }
            };
            Thread thread = new Thread(runnable2);
            thread.setPriority(n);
            this.threadVar = new ThreadVar(thread);
        }

        public void start() {
            Thread thread = this.threadVar.get();
            if (thread != null) {
                thread.start();
            }
        }
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread thread) {
            this.thread = thread;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

