/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.componentes;

import es.aeat.pare.aplicacion.Aplicacion;
import es.aeat.pare.componentes.AEATHerramientas;
import es.aeat.pare.componentes.AEATListaConMotor;
import es.aeat.pare.componentes.AEATLogger;
import es.aeat.pare.componentes.AEATcontenedores;
import es.aeat.pare.componentes.AEATlistaComponentes;
import es.aeat.pare.componentes.AEATmotorCtrlDocument;
import es.aeat.pare.componentes.AEATmotorListener;
import es.aeat.pare.componentes.JDialogo;
import es.aeat.pare.componentes.JDlgContenedorDlg;
import es.aeat.pare.componentes.Lanzable;
import es.aeat.pare.re14.Irpf2014;
import es.aeat.pare.re14.gui.Dialogos.JDlgGestor;
import es.aeat.pftw.mtrc.api.configuracion.RegEntrada;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class AEATLanzaVentana
extends JPanel
implements AEATcontenedores {
    static final long serialVersionUID = 0L;
    protected AEATlistaComponentes mlComponentes = new AEATListaConMotor();
    static AEATmotorCtrlDocument.AEATBooleanDocument dBoolean = new AEATmotorCtrlDocument.AEATBooleanDocument(1);
    protected JTextField texto;
    protected HashMap<String, Object> parametros = new HashMap();
    protected boolean oculta = false;
    protected boolean bVisible = false;
    protected boolean esDesglose = false;
    protected boolean esGestor = false;
    protected JButton boton;
    protected JLabel jl;
    Object[] mParametrosContructor;

    public JTextField texto() {
        return this.texto;
    }

    public JButton boton() {
        return this.boton;
    }

    public AEATLanzaVentana() {
        this.init();
        this.mlComponentes.contenedor(this);
        AEATmotorListener.annadirListeners(this);
        this.cargar();
    }

    public AEATLanzaVentana(boolean bl) {
        this.oculta = bl;
        this.init();
        this.mlComponentes.contenedor(this);
        AEATmotorListener.annadirListeners(this);
        this.cargar();
    }

    public AEATLanzaVentana(boolean bl, boolean bl2) {
        this.oculta = bl;
        this.esDesglose = bl2;
        this.init();
        this.mlComponentes.contenedor(this);
        AEATmotorListener.annadirListeners(this);
        this.cargar();
    }

    public abstract JDialogo creaDlg() throws ExceptionMotor, Exception;

    abstract void cuerpoFuncionkeyPressed(KeyEvent var1) throws ExceptionMotor, Exception;

    protected void init() {
        this.texto = new JTextField();
        this.texto.setColumns(8);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.add((Component)this.texto, gridBagConstraints);
        this.boton = new JButton();
        this.boton.setFocusable(false);
        if (this.esDesglose) {
            this.boton.setIcon(new ImageIcon(this.getClass().getResource(Aplicacion.DIRECTORIO_IMAGES + "epi1.gif")));
            this.boton.setText(Aplicacion.getmResource().getString("boton.desglose"));
        } else {
            this.boton.setIcon(new ImageIcon(this.getClass().getResource(Aplicacion.DIRECTORIO_IMAGES + "epi1.gif")));
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.add((Component)this.boton, gridBagConstraints);
        this.jl = new JLabel();
        this.add((Component)this.jl, gridBagConstraints);
        this.redibujaLV();
        this.texto.addPropertyChangeListener("font", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AEATLanzaVentana.this.redibujaLV();
            }
        });
        this.texto.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AEATLanzaVentana.this.boton.setEnabled(AEATLanzaVentana.this.texto.isEnabled());
            }
        });
        this.boton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    AEATLanzaVentana.this.ejecutaDialogo();
                }
                catch (ExceptionMotor exceptionMotor) {
                    exceptionMotor.printStackTrace();
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.texto.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                try {
                    AEATLanzaVentana.this.cuerpoFuncionkeyPressed(keyEvent);
                }
                catch (ExceptionMotor exceptionMotor) {
                    exceptionMotor.printStackTrace();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        if (this.oculta) {
            this.boton.setVisible(false);
            this.texto.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    if (!Aplicacion.isAccesible() || Aplicacion.isAccesible() && AEATLanzaVentana.this.texto().isEditable()) {
                        AEATLanzaVentana.this.boton.setVisible(true);
                    } else {
                        AEATLanzaVentana.this.boton.setVisible(false);
                    }
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    AEATLanzaVentana.this.boton.setVisible(false);
                }
            });
        }
    }

    private void redibujaLV() {
        int n;
        JTextField jTextField = new JTextField(this.texto.getColumns());
        int n2 = n = jTextField.getPreferredSize().height;
        if (this.esDesglose) {
            n2 = this.boton.getPreferredSize().width;
        }
        this.boton.setPreferredSize(new Dimension(n2, n));
        this.jl.setPreferredSize(new Dimension(n2, n));
    }

    public Object parametroDialogo(String string, Object object) {
        return this.parametros.put(string, object);
    }

    public void initDlg(Object[] objectArray) {
        this.mParametrosContructor = (Object[])objectArray.clone();
    }

    @Override
    public synchronized void addFocusListener(FocusListener focusListener) {
        if (this.texto != null) {
            this.texto.addFocusListener(focusListener);
        }
        super.addFocusListener(focusListener);
    }

    public boolean getOculta() {
        return this.oculta;
    }

    public void setOculta(boolean bl) {
        this.oculta = bl;
    }

    @Override
    public void setToolTipText(String string) {
        this.texto.setToolTipText(string);
    }

    @Override
    public String getToolTipText() {
        return this.texto.getToolTipText();
    }

    protected boolean ejecutaDialogo() throws NumberFormatException, Exception {
        JDialogo jDialogo = this.creaDlg();
        if (jDialogo == null) {
            System.out.println("La partida " + this.texto.getName() + " no tiene asignado nombre de ventana");
            return false;
        }
        Object[] objectArray = this.parametros.entrySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((Lanzable)((Object)jDialogo)).setParametro((String)objectArray[i], this.parametros.get(objectArray[i]));
        }
        if (this.bVisible) {
            return false;
        }
        this.bVisible = true;
        if (this.esGestor) {
            try {
                ((JDlgGestor)jDialogo).ponTopic((String)this.getClientProperty("HELPTOPIC"));
                Irpf2014.setjGestorActual((JDlgGestor)jDialogo);
            }
            catch (Exception exception) {
                AEATLogger.getLogger().fatal((Object)"Error al establecer la ayuda del gestor", (Throwable)exception);
            }
            jDialogo.setVisible(true);
            Irpf2014.setjGestorActual(null);
        } else if (jDialogo.isDF()) {
            AEATHerramientas.visualizarDialogo(jDialogo, (String)this.getClientProperty("HELPTOPIC"), true);
        } else {
            AEATHerramientas.visualizarDialogo(jDialogo, (String)this.getClientProperty("HELPTOPIC"));
        }
        this.bVisible = false;
        this.texto.setText(((Lanzable)((Object)jDialogo)).devolucion());
        this.texto.requestFocusInWindow();
        Aplicacion.getMotor().partidaModificada(this.texto.getName(), ((Lanzable)((Object)jDialogo)).devolucion());
        if (jDialogo.getParent() instanceof JDlgContenedorDlg) {
            ((JDlgContenedorDlg)jDialogo.getParent()).dispose();
            AEATLogger.getLogger().debug((Object)"AEAT_LanzaVentana.ejecutaDialogo()");
        }
        jDialogo.dispose();
        jDialogo = null;
        return true;
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.texto.setName(string);
        AEATmotorListener.annadirListeners(this);
        try {
            RegEntrada regEntrada = (RegEntrada)Aplicacion.getMotor().obtenerCaracteristicasPartida(this.texto.getName());
            if (regEntrada == null) {
                return;
            }
            if (regEntrada.getTipoDato().equalsIgnoreCase("DOBLE")) {
                AEATmotorCtrlDocument.AEATDobleDocument aEATDobleDocument = new AEATmotorCtrlDocument.AEATDobleDocument(regEntrada.getTamannioCampo(), regEntrada.getNumDecimales());
                aEATDobleDocument.setbAdmiteNegativo(regEntrada.getAdmiteNegativo());
                aEATDobleDocument.setNomTabla(regEntrada.getIdTabla());
                aEATDobleDocument.setNomControl(string);
                aEATDobleDocument.setLanzaVentana(regEntrada.getLanzaVentana());
                this.texto.setHorizontalAlignment(4);
                this.texto.setDocument(aEATDobleDocument);
            } else if (regEntrada.getTipoDato().equalsIgnoreCase("LOGICO")) {
                dBoolean = new AEATmotorCtrlDocument.AEATBooleanDocument(regEntrada.getTamannioCampo());
                dBoolean.setNomControl(this.getName());
                this.texto.setDocument(dBoolean);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean cargar() {
        return this.mlComponentes.cargar();
    }

    public void setColumns(int n) {
        this.texto.setColumns(n);
        this.redibujaLV();
    }

    public int getColumns() {
        return this.texto.getColumns();
    }

    @Override
    public void setInitialFocus() {
    }

    @Override
    public void restaurarValoresIniciales() {
        this.cargar();
    }

    @Override
    public void liberaRecursos() {
    }

    public String raiz() {
        return this.mlComponentes.raiz();
    }

    @Override
    public void requestFocus() {
        if (this.texto.isEnabled()) {
            this.texto.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.texto.isEnabled()) {
            return this.texto.requestFocusInWindow();
        }
        return false;
    }
}

