/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.componentes;

import es.aeat.pare.componentes.AEATLogger;
import es.aeat.pare.componentes.JTextPaneRaya;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;

public final class AEATJTextPane
extends JPanel {
    private static final long serialVersionUID = 7684819566848894809L;
    public static final int NORMAL = 0;
    public static final int TIT_1 = 1;
    public static final int TIT_2 = 2;
    public static final int NEGRITA = 3;
    public static final int PEQUENYA = 4;
    private int items = 0;

    public int getItems() {
        return this.items;
    }

    public void setItems(int n) {
        this.items = n;
    }

    public AEATJTextPane(String string, int n) {
        this.setName(string);
        this.items = n;
        this.init();
    }

    public String getText() {
        String string = "";
        for (int i = 0; i < this.items; ++i) {
            string = string + ((JTextPaneRaya)this.getComponent(i)).getText();
        }
        return string;
    }

    public List<String> getTextos() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.items; ++i) {
            arrayList.add(((JTextPaneRaya)this.getComponent(i)).getText());
        }
        return arrayList;
    }

    public int getFormato(int n) {
        return ((JTextPaneRaya)this.getComponent(n)).getEstilo();
    }

    public boolean getRayado(int n) {
        return ((JTextPaneRaya)this.getComponent(n)).isRayado();
    }

    public void setText(int n, String string) {
        try {
            ((JTextPaneRaya)this.getComponent(n)).setText(string);
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)("No existe el componente " + n + " en " + this.getName()));
        }
    }

    public void setFormato(int n, int n2, boolean bl, boolean bl2) {
        this.setFormato(n, n2, bl, bl2, false, false);
    }

    public void setFormato(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        JTextPaneRaya jTextPaneRaya = new JTextPaneRaya();
        try {
            jTextPaneRaya = (JTextPaneRaya)this.getComponent(n);
            jTextPaneRaya.setFormato(n2, bl, bl2, bl3, bl4);
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)("No existe el componente " + n + " en " + this.getName()));
        }
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        for (int i = 0; i < this.items; ++i) {
            JTextPaneRaya jTextPaneRaya = new JTextPaneRaya();
            jTextPaneRaya.setOpaque(false);
            jTextPaneRaya.setName(this.getName() + i);
            jTextPaneRaya.setText("");
            gridBagConstraints.gridx = i;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            if (i == this.items - 1) {
                gridBagConstraints.weightx = 1.0;
            }
            if (i > 0 && UIManager.getLookAndFeel().getDescription().toUpperCase().contains("MAC OS")) {
                gridBagConstraints.insets.left = 5;
            }
            this.add((Component)jTextPaneRaya, gridBagConstraints);
        }
    }

    @Override
    public void setToolTipText(String string) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((JComponent)this.getComponent(i)).setToolTipText(string);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((JComponent)this.getComponent(i)).setEnabled(bl);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((JComponent)this.getComponent(i)).setForeground(color);
        }
    }
}

