/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.componentes;

import es.aeat.pare.aplicacion.Aplicacion;
import es.aeat.pare.aplicacion.Constantes;
import es.aeat.pare.componentes.AEATJTextPane;
import es.aeat.pare.componentes.DashedBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class AEATJCheckBox
extends JPanel {
    private static final long serialVersionUID = 4141921354617324715L;
    private JCheckBox jcb = null;
    private JComponent jcomponent = null;

    public AEATJCheckBox() {
        this.getJcb();
        this.init();
    }

    public AEATJCheckBox(String string) {
        this.getJcb().setText(string);
        this.init();
    }

    public AEATJCheckBox(JComponent jComponent) {
        this.setJcomponent(jComponent);
        this.init();
    }

    private void init() {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        if (Aplicacion.isAccesible()) {
            gridBagConstraints.weightx = 0.5;
        }
        this.add((Component)this.jcb, gridBagConstraints);
        if (this.getJcomponent() != null) {
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets.left = -4;
            this.add((Component)this.jcomponent, gridBagConstraints);
        }
        this.actualiza();
    }

    public JCheckBox getJcb() {
        if (this.jcb == null) {
            this.jcb = new JCheckBox();
            this.jcb.setOpaque(false);
            this.jcb.addComponentListener(new ComponentListener(){

                @Override
                public void componentShown(ComponentEvent componentEvent) {
                    AEATJCheckBox.this.actualiza();
                }

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    AEATJCheckBox.this.actualiza();
                }

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                    AEATJCheckBox.this.actualiza();
                }

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                    AEATJCheckBox.this.actualiza();
                }
            });
        }
        return this.jcb;
    }

    protected void actualiza() {
        this.setVisible(this.getJcb().isVisible());
        if (!Aplicacion.isAccesible()) {
            this.setFocusable(this.getJcb().isEnabled());
            this.setFocusTraversalPolicyProvider(this.getJcb().isEnabled());
            if (this.getJcomponent() != null) {
                this.getJcomponent().setEnabled(this.getJcb().isEnabled());
            }
        }
        this.updateUI();
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.getJcb().setName(string);
    }

    public void setJcomponent(JComponent jComponent) {
        if (Aplicacion.isAccesible()) {
            return;
        }
        this.jcomponent = jComponent;
        final DashedBorder dashedBorder = new DashedBorder(Constantes.getColorBkClaro(), 1, 1);
        this.getJcomponent().setBorder(dashedBorder);
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    AEATJCheckBox.this.getJcb().setSelected(!AEATJCheckBox.this.getJcb().isSelected());
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                AEATJCheckBox.this.getJcomponent().setBorder(dashedBorder);
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AEATJCheckBox.this.getJcomponent().setBorder(new DashedBorder(Color.BLACK, 1, 1));
            }
        });
        this.getJcb().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                AEATJCheckBox.this.requestFocusInWindow();
            }
        });
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            this.getJcomponent().getComponent(i).addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (AEATJCheckBox.this.getJcb().isEnabled()) {
                        AEATJCheckBox.this.getJcb().setSelected(!AEATJCheckBox.this.getJcb().isSelected());
                        AEATJCheckBox.this.requestFocusInWindow();
                    }
                }
            });
        }
        this.init();
    }

    public JComponent getJcomponent() {
        return this.jcomponent;
    }

    @Override
    public void setToolTipText(String string) {
        if (Aplicacion.isAccesible()) {
            this.getJcb().setText(string);
        }
        this.getJcb().setToolTipText(string);
        this.getAccessibleContext().setAccessibleName(string);
        this.getAccessibleContext().setAccessibleDescription(string);
        super.setToolTipText(string);
        if (this.getJcomponent() != null) {
            if (this.getJcomponent() instanceof AEATJTextPane) {
                ((AEATJTextPane)this.getJcomponent()).setToolTipText(string);
            } else {
                this.getJcomponent().setToolTipText(string);
            }
        }
    }

    public boolean isSelected() {
        return this.getJcb().isSelected();
    }

    public void setSelected(boolean bl) {
        this.getJcb().setSelected(bl);
    }
}

