/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.componentes;

import es.aeat.pare.aplicacion.Aplicacion;
import es.aeat.pare.cc14.Declarantes;
import es.aeat.pare.componentes.AEATConectoresMotor;
import es.aeat.pare.componentes.AEATExcepcionCon;
import es.aeat.pare.componentes.AEATFactoriaDeConectores;
import es.aeat.pare.componentes.AEATHerramientas;
import es.aeat.pare.componentes.AEATLogger;
import es.aeat.pare.componentes.AEATgestorComponentes;
import es.aeat.pare.componentes.JMensajesProperties;
import es.aeat.pare.re14.motor.FuncionesRenta;
import es.aeat.pare.re14.motor.FuncionesRentaComun;
import es.aeat.pftw.mtrc.api.configuracion.RegEntrada;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrc.api.tipos.ITipoDatosRegistro;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Document;

public final class AEATGestorConMotor
extends AEATgestorComponentes {
    private static boolean logTrazaCambioMotores = false;
    private boolean bErrorGestorConMotor = false;
    private boolean bTieneContenidoGestorConMotor = false;
    private String mTabla;
    private HashSet<Object> mIdsNoNueva = new HashSet<Object>(){
        static final long serialVersionUID = 0L;
        {
            this.add("ID");
        }
    };
    private String partidaOrden;
    private List<Double> arrayOrdenado;
    private List<Double> arrayNormal;
    private ArrayList<Integer> arrayOrdenadoANormal;
    private ArrayList<Integer> arrayNormalAOrdenado;

    public static boolean isLogTrazaCambioMotores() {
        return logTrazaCambioMotores;
    }

    public static void setLogTrazaCambioMotores(boolean bl) {
        logTrazaCambioMotores = bl;
    }

    @Override
    public String fuente() {
        return this.mTabla;
    }

    @Override
    public void annadirIdNoNueva(String string) {
        if (string != null && string.length() > 0) {
            this.mIdsNoNueva.add(string);
        }
    }

    @Override
    public Object valorAct(int n) {
        return this.componente(n).valorAct();
    }

    @Override
    public String valorAct(int n, int n2) {
        try {
            String string = this.componente(n).cogerTabla();
            String string2 = AEATGestorConMotor.cogerValorDelMotor(string, this.componente(n).cogerCampo(), n2);
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String cogerValorDelMotor(String string, String string2, int n) throws ExceptionMotor {
        List<ITipoDatosRegistro> list = Aplicacion.getMotor().obtenerRegistroTabla(string, n);
        String string3 = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!string2.equalsIgnoreCase(list.get(i).getNombreEntrada())) continue;
            string3 = list.get(i).getValor().toString();
            break;
        }
        return string3;
    }

    @Override
    public String valorAct(String string, int n) throws ExceptionMotor {
        long l = Aplicacion.getMotor().obtenerClaveActiva(this.mTabla);
        try {
            Aplicacion.getMotor().move(this.mTabla, n);
            String string2 = Aplicacion.getMotor().obtenerPartidaString(string);
            Aplicacion.getMotor().move(this.mTabla, l);
            return string2;
        }
        catch (Exception exception) {
            Aplicacion.getMotor().move(this.mTabla, l);
            return null;
        }
    }

    @Override
    public String nombre(int n) {
        return this.componente(n).nombre();
    }

    @Override
    public boolean contenedor(Container container) {
        boolean bl = super.contenedor(container);
        this.definicion();
        return bl;
    }

    @Override
    public boolean incluir(Component component) {
        try {
            AEATConectoresMotor aEATConectoresMotor = AEATFactoriaDeConectores.generarConectorMotor(component);
            if (aEATConectoresMotor != null && component.getName() != null) {
                return this.getmListacomponentes().add(aEATConectoresMotor);
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void definicionXML(String string) {
        AEATHerramientas.marcarObsoleta();
    }

    public void definicion() {
        for (int i = 0; i < this.getmListacomponentes().size(); ++i) {
            this.componente(i).ponerCampo(this.componente(i).nombre());
            this.componente(i).ponerTabla(this.mTabla);
        }
    }

    public void definicionMotor(String string) {
        for (int i = 0; i < this.getmListacomponentes().size(); ++i) {
            this.componente(i).ponerTabla(string);
            this.componente(i).ponerCampo(this.componente(i).nombre());
        }
    }

    protected AEATConectoresMotor componente(int n) {
        return (AEATConectoresMotor)this.getmListacomponentes().get(n);
    }

    @Override
    public boolean cargar() {
        boolean bl = true;
        this.bTieneContenidoGestorConMotor = false;
        for (int i = 0; i < this.getmListacomponentes().size(); ++i) {
            try {
                boolean bl2 = this.componente(i).aComponente();
                if (this.bTieneContenidoGestorConMotor || !bl2 || this.componente(i).cogerCampo().startsWith("OCURRE_")) continue;
                this.bTieneContenidoGestorConMotor = bl2;
                continue;
            }
            catch (AEATExcepcionCon aEATExcepcionCon) {
                bl = false;
            }
        }
        this.bErrorGestorConMotor = !bl;
        return bl;
    }

    public AEATGestorConMotor(String string) {
        this.mTabla = string;
    }

    private boolean compruebaNueva(List<ITipoDatosRegistro> list) {
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i).getNombreEntrada();
            String string2 = list.get(i).getTipoDato();
            String string3 = list.get(i).getValor().toString();
            if (!(string2.equalsIgnoreCase("CADENA") || string2.equalsIgnoreCase("ALFABETICO") || string2.equalsIgnoreCase("FECHA") || string2.equalsIgnoreCase("CADENA_NUMERICA") || string2.equalsIgnoreCase("CADENA_NUMERICA_2") ? string3 != null && string3.length() > 0 && !string.startsWith("NUMACT") && !string.startsWith("TIT_C") : (string2.equalsIgnoreCase("ENTERO") ? !string.equals("IDINF") && !string.equals("ID") && !string.startsWith("INDICE") && !string.startsWith("IND_C") && (string.startsWith("IP0") || string.startsWith("V01MULTI") ? string3 != null && !string3.equals("-1") : string3 != null && !string3.equals("0")) : string2.equalsIgnoreCase("DOBLE") && string3 != null && !"0.0".equals(string3) && !string.startsWith("NUMACT") && !string.equals("V01PCD")))) continue;
            return true;
        }
        return false;
    }

    private int validarCuantos(String string, Declarantes declarantes) throws Exception {
        int n = (Integer)Aplicacion.getMotor().ejecutarFuncion("calculoRenta", new Object[]{"ValidacionesTablas", "dameCuantosDelDeclaranteActualHayEnConjunta", string, declarantes.toInt()});
        return n;
    }

    private int validarCuantos2(Declarantes declarantes, String string) throws Exception {
        int n = (Integer)Aplicacion.getMotor().ejecutarFuncion("calculoRenta", new Object[]{"ValidacionesTablas", "dameCuantosDelDeclaranteActualHayEnConjuntaINMATRENTAS", this.mTabla, declarantes.toInt(), string});
        return n;
    }

    private int validarComprobar() throws Exception {
        int n = (Integer)Aplicacion.getMotor().ejecutarFuncion("calculoRenta", new Object[]{"ValidacionesTablas", "comprobarTablaINMARENTAS"});
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int puedoNuevoRegistro() throws Exception {
        Declarantes declarantes = null;
        FuncionesRenta funcionesRenta = new FuncionesRenta();
        try {
            declarantes = (Declarantes)Aplicacion.getMotor().ejecutarFuncion("cualDeclaracion", new Object[0]);
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)"", (Throwable)exception);
        }
        try {
            long l = Aplicacion.getMotor().obtenerClaveActiva(this.mTabla);
            String string = "";
            long l2 = -1L;
            if (this.mTabla.equalsIgnoreCase("E2REGESTOBJ")) {
                string = "MODULOOBJ";
                l2 = Aplicacion.getMotor().obtenerClaveActiva(string);
            } else if (this.mTabla.equalsIgnoreCase("E3REGESTAGR")) {
                string = "MODULOAGR";
                l2 = Aplicacion.getMotor().obtenerClaveActiva(string);
            } else if (this.mTabla.equalsIgnoreCase("INMUEBLES")) {
                string = "ARRENDAMIENTO";
                l2 = Aplicacion.getMotor().obtenerClaveActiva(string);
            }
            if (Aplicacion.getMotor().recordCount(this.mTabla) > 0L) {
                Aplicacion.getMotor().moveLast(this.mTabla);
            }
            List<ITipoDatosRegistro> list = Aplicacion.getMotor().obtenerRegistroTabla(this.mTabla);
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (this.maximoEnConjunta && FuncionesRentaComun.isBConjunta()) {
                Declarantes declarantes2 = (Declarantes)Aplicacion.getMotor().ejecutarFuncion("cualDeclaracion", null);
                Aplicacion.getMotor().ejecutarFuncion("irDeclaracion", new Object[]{Declarantes.UnidadFamiliar});
                n5 = (int)Aplicacion.getMotor().recordCount(this.mTabla);
                Aplicacion.getMotor().ejecutarFuncion("irDeclaracion", new Object[]{declarantes2});
            }
            int n6 = n4 + n + n2 + n3;
            boolean bl = true;
            int n7 = 1;
            int n8 = 0;
            boolean bl2 = false;
            try {
                declarantes = (Declarantes)Aplicacion.getMotor().ejecutarFuncion("cualDeclaracion", null);
            }
            catch (Exception exception) {
                AEATLogger.getLogger().fatal((Object)exception);
            }
            int n9 = 0;
            int n10 = (int)Aplicacion.getMotor().recordCount(this.mTabla);
            int n11 = this.validarCuantos(this.mTabla, declarantes);
            if (this.mTabla.equalsIgnoreCase("INMATRENTAS")) {
                String string2;
                bl2 = true;
                if (FuncionesRentaComun.isBConjunta()) {
                    string2 = Aplicacion.getMotor().obtenerPartidaString("INDICE_F1");
                    Aplicacion.getMotor().ejecutarFuncion("irDeclaracion", new Object[]{Declarantes.UnidadFamiliar});
                    n11 = this.validarCuantos2(declarantes, string2);
                    n5 = this.validarComprobar();
                    Aplicacion.getMotor().ejecutarFuncion("irDeclaracion", new Object[]{Declarantes.UnidadFamiliar});
                    funcionesRenta.irDeclaracion(declarantes);
                    n9 = n5;
                } else {
                    string2 = Aplicacion.getMotor().obtenerPartidaString("INDICE_F1");
                    n11 = this.validarCuantos2(declarantes, string2);
                    n9 = n5 = this.validarComprobar();
                }
            } else if (this.mTabla.equalsIgnoreCase("INMAFECTO")) {
                bl2 = true;
            }
            n8 = this.mTabla.equalsIgnoreCase("INMATRENTAS") ? this.mMaximo - (n9 - n11) : this.mMaximo - n5 + n11;
            if (list.size() != 0) {
                bl = this.compruebaNueva(list);
                if (bl) {
                    if (this.mMaximo != 0 && (n10 >= this.mMaximo || this.maximoEnConjunta && n5 > this.mMaximo - 1)) {
                        n7 = -1;
                    }
                } else {
                    n7 = 0;
                }
            } else if (this.mMaximo != 0 && (n10 >= this.mMaximo || this.maximoEnConjunta && n6 > this.mMaximo - 1)) {
                n7 = -1;
            }
            if (bl2 && n10 >= n8) {
                n7 = -1;
            }
            Aplicacion.getMotor().move(this.mTabla, l);
            if (l2 != -1L) {
                Aplicacion.getMotor().move(string, l2);
            }
            int n12 = n7;
            return n12;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            int n = 0;
            return n;
        }
        finally {
            funcionesRenta.irDeclaracion(declarantes);
        }
    }

    @Override
    public boolean nueva() {
        try {
            int n = this.puedoNuevoRegistro();
            if (n == 1) {
                Aplicacion.getMotor().anniadirRegistro(this.mTabla);
                Aplicacion.getMotor().moveLast(this.mTabla);
            } else if (n == 0 || n == -1) {
                int n2 = this.cuantas();
                this.irA(n2);
                if (n == -1) {
                    JMensajesProperties jMensajesProperties = new JMensajesProperties("Se ha superado el n\u00famero m\u00e1ximo de elementos relativos a este concepto para el conjunto de los declarantes");
                    jMensajesProperties.muestraMensaje();
                }
            }
            this.cargar();
            return n == 1;
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
            return false;
        }
    }

    public boolean borrar(Document document) throws ExceptionMotor {
        return this.borrar();
    }

    @Override
    public boolean borrar() throws ExceptionMotor {
        long l = Aplicacion.getMotor().borrarRegistro(this.mTabla);
        this.irA(1);
        return l > 0L;
    }

    @Override
    public int posicion() throws Exception {
        Declarantes declarantes = null;
        FuncionesRenta funcionesRenta = new FuncionesRenta();
        try {
            declarantes = (Declarantes)Aplicacion.getMotor().ejecutarFuncion("cualDeclaracion", null);
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
        }
        funcionesRenta.irDeclaracion(declarantes);
        try {
            declarantes = (Declarantes)Aplicacion.getMotor().ejecutarFuncion("cualDeclaracion", null);
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)exception);
        }
        if (this.partidaOrden != null && declarantes.toInt() == Declarantes.UnidadFamiliar.toInt()) {
            this.ordenar();
            int n = (int)Aplicacion.getMotor().obtenerClaveActiva(this.mTabla);
            Integer n2 = n == 0 ? Integer.valueOf(0) : Integer.valueOf(this.getArrayNormalAOrdenado().get(n - 1) + 1);
            return n2;
        }
        return (int)Aplicacion.getMotor().obtenerClaveActiva(this.mTabla);
    }

    @Override
    public boolean irA(int n) throws ExceptionMotor {
        long l = -1L;
        int n2 = 1;
        Declarantes declarantes = null;
        try {
            declarantes = (Declarantes)Aplicacion.getMotor().ejecutarFuncion("cualDeclaracion", null);
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)"", (Throwable)exception);
        }
        if (this.partidaOrden != null && declarantes.toInt() == Declarantes.UnidadFamiliar.toInt()) {
            this.ordenar();
            if (!this.getArrayOrdenado().isEmpty()) {
                Double d = this.getArrayOrdenado().get(n - 1);
                n2 = this.getArrayNormal().indexOf(d) + 1;
            }
        } else {
            n2 = n;
        }
        Aplicacion.getMotor().move(this.mTabla, n2);
        this.cargar();
        return l == (long)n;
    }

    public int avanzar(Document document) throws ExceptionMotor {
        return this.avanzar();
    }

    public int retroceder(Document document) throws ExceptionMotor {
        return this.retroceder();
    }

    public int primera(Document document) throws ExceptionMotor {
        return this.primera();
    }

    public int ultima(Document document) throws ExceptionMotor {
        return this.ultima();
    }

    @Override
    public int avanzar() throws ExceptionMotor {
        long l;
        Declarantes declarantes = null;
        try {
            declarantes = (Declarantes)Aplicacion.getMotor().ejecutarFuncion("cualDeclaracion", null);
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)"", (Throwable)exception);
        }
        if (this.partidaOrden != null && declarantes.toInt() == Declarantes.UnidadFamiliar.toInt()) {
            this.ordenar();
            int n = (int)Aplicacion.getMotor().obtenerClaveActiva(this.mTabla);
            l = this.getArrayOrdenadoANormal().get(this.getArrayNormalAOrdenado().get(n - 1) + 1) + 1;
            Aplicacion.getMotor().move(this.mTabla, l);
        } else {
            l = Aplicacion.getMotor().moveNext(this.mTabla);
        }
        this.cargar();
        return (int)l;
    }

    @Override
    public int primera() throws ExceptionMotor {
        long l;
        Declarantes declarantes = null;
        try {
            declarantes = (Declarantes)Aplicacion.getMotor().ejecutarFuncion("cualDeclaracion", null);
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)"", (Throwable)exception);
        }
        if (this.partidaOrden != null && declarantes.toInt() == Declarantes.UnidadFamiliar.toInt()) {
            this.ordenar();
            l = this.getArrayOrdenadoANormal().get(0) + 1;
            Aplicacion.getMotor().move(this.mTabla, l);
        } else {
            l = Aplicacion.getMotor().moveFirst(this.mTabla);
        }
        this.cargar();
        return (int)l;
    }

    @Override
    public int ultima() throws ExceptionMotor {
        long l;
        Declarantes declarantes = null;
        try {
            declarantes = (Declarantes)Aplicacion.getMotor().ejecutarFuncion("cualDeclaracion", null);
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)"", (Throwable)exception);
        }
        if (this.partidaOrden != null && declarantes.toInt() == Declarantes.UnidadFamiliar.toInt()) {
            this.ordenar();
            l = this.getArrayOrdenadoANormal().get(this.getArrayOrdenado().size() - 1) + 1;
            Aplicacion.getMotor().move(this.mTabla, l);
        } else {
            l = Aplicacion.getMotor().moveLast(this.mTabla);
        }
        this.cargar();
        return (int)l;
    }

    @Override
    public boolean hay(int n) throws ExceptionMotor {
        return Aplicacion.getMotor().recordCount(this.mTabla) >= (long)n;
    }

    public boolean hay(Document document, int n) throws ExceptionMotor {
        return this.hay(n);
    }

    @Override
    public int retroceder() throws ExceptionMotor {
        long l;
        Declarantes declarantes = null;
        try {
            declarantes = (Declarantes)Aplicacion.getMotor().ejecutarFuncion("cualDeclaracion", null);
        }
        catch (Exception exception) {
            AEATLogger.getLogger().fatal((Object)"", (Throwable)exception);
        }
        if (this.partidaOrden != null && declarantes.toInt() == Declarantes.UnidadFamiliar.toInt()) {
            this.ordenar();
            int n = (int)Aplicacion.getMotor().obtenerClaveActiva(this.mTabla);
            l = this.getArrayOrdenadoANormal().get(this.getArrayNormalAOrdenado().get(n - 1) - 1) + 1;
            Aplicacion.getMotor().move(this.mTabla, l);
        } else {
            l = Aplicacion.getMotor().movePrevious(this.mTabla);
        }
        this.cargar();
        return (int)l;
    }

    public boolean cargar(Document document) {
        AEATHerramientas.marcarObsoleta();
        boolean bl = this.cargar();
        return bl;
    }

    @Override
    public int cuantas() throws ExceptionMotor {
        return (int)Aplicacion.getMotor().recordCount(this.mTabla);
    }

    @Override
    public boolean getError() {
        return this.bErrorGestorConMotor;
    }

    @Override
    public boolean tieneContenido() {
        return this.bTieneContenidoGestorConMotor;
    }

    @Override
    public void ordenarSegun(String string) throws ExceptionMotor {
        this.partidaOrden = string;
        RegEntrada regEntrada = (RegEntrada)Aplicacion.getMotor().obtenerCaracteristicasPartida(string);
        if (regEntrada == null) {
            this.partidaOrden = null;
            AEATLogger.getLogger().error((Object)(this.getClass().getName() + "::ordenarSegun()" + " La partida [" + string + "] no existe"));
        } else if (!regEntrada.getIdTabla().equalsIgnoreCase(this.mTabla)) {
            this.partidaOrden = null;
            AEATLogger.getLogger().error((Object)(this.getClass().getName() + "::ordenarSegun()" + " La partida [" + string + "] no petenece a este gestor"));
        }
    }

    private void ordenar() throws ExceptionMotor {
        this.ordenar(null);
    }

    public void ordenar(String string) throws ExceptionMotor {
        ArrayList<Double> arrayList;
        if (string != null) {
            this.partidaOrden = string;
        }
        int n = (int)Aplicacion.getMotor().recordCount(this.mTabla);
        int n2 = (int)Aplicacion.getMotor().obtenerClaveActiva(this.mTabla);
        Double[] doubleArray = new Double[n];
        Aplicacion.getMotor().moveFirst(this.mTabla);
        for (int i = 0; i <= n - 1; ++i) {
            String string2 = Aplicacion.getMotor().obtenerPartidaString(this.partidaOrden);
            if (string2 != null && !string2.equalsIgnoreCase("")) {
                doubleArray[i] = Double.parseDouble(string2);
            }
            if (Aplicacion.getMotor().obtenerClaveActiva(this.mTabla) == (long)n) break;
            Aplicacion.getMotor().moveNext(this.mTabla);
        }
        Aplicacion.getMotor().move(this.mTabla, n2);
        Object[] objectArray = Arrays.copyOf(doubleArray, doubleArray.length);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length / 2; ++i) {
            arrayList = objectArray[i];
            objectArray[i] = objectArray[objectArray.length - 1 - i];
            objectArray[objectArray.length - 1 - i] = arrayList;
        }
        this.setArrayOrdenado(Arrays.asList(objectArray));
        this.setArrayNormal(Arrays.asList(doubleArray));
        this.setArrayOrdenadoANormal(new ArrayList<Integer>());
        this.setArrayNormalAOrdenado(new ArrayList<Integer>());
        ArrayList<Double> arrayList2 = new ArrayList<Double>(this.getArrayOrdenado());
        arrayList = new ArrayList<Double>(this.getArrayNormal());
        for (int i = 0; i < this.getArrayNormal().size(); ++i) {
            int n3 = arrayList.indexOf(this.getArrayOrdenado().get(i));
            this.getArrayOrdenadoANormal().add(n3);
            arrayList.remove(n3);
            arrayList.add(n3, Double.NaN);
            n3 = arrayList2.indexOf(this.getArrayNormal().get(i));
            this.getArrayNormalAOrdenado().add(n3);
            arrayList2.remove(n3);
            arrayList2.add(n3, Double.NaN);
        }
    }

    public void setArrayNormal(List<Double> list) {
        this.arrayNormal = list;
    }

    public List<Double> getArrayNormal() {
        return this.arrayNormal;
    }

    public void setArrayOrdenadoANormal(ArrayList<Integer> arrayList) {
        this.arrayOrdenadoANormal = arrayList;
    }

    public ArrayList<Integer> getArrayOrdenadoANormal() {
        return this.arrayOrdenadoANormal;
    }

    public void setArrayNormalAOrdenado(ArrayList<Integer> arrayList) {
        this.arrayNormalAOrdenado = arrayList;
    }

    public ArrayList<Integer> getArrayNormalAOrdenado() {
        return this.arrayNormalAOrdenado;
    }

    public void setArrayOrdenado(List<Double> list) {
        this.arrayOrdenado = list;
    }

    public List<Double> getArrayOrdenado() {
        return this.arrayOrdenado;
    }
}

