/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.componentes;

import es.aeat.pare.aplicacion.Aplicacion;
import es.aeat.pare.componentes.AEATLogger;
import es.aeat.pare.componentes.JMensajesProperties;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class AEATControlIBAN
extends JPanel {
    static final long serialVersionUID = 0L;
    private static boolean bIBANOK;
    private static boolean bCuentaOK;
    private JTextField[] ncuenta = new JTextField[]{null, null, null, null, null, null};
    private JTextPane jTPIBAN = new JTextPane();
    private boolean nodesdetotal = true;
    private boolean bOculto;
    private KeyAdapter[] ka = new KeyAdapter[]{null, null, null, null, null, null};
    private FocusAdapter[] fa = new FocusAdapter[]{null, null, null, null, null, null};
    private Total total = new Total();

    public AEATControlIBAN() {
        this.initControl();
    }

    private JTextField getNCuenta(int n) {
        final int n2 = n;
        if (this.ncuenta[n] == null) {
            this.ncuenta[n] = new JTextField(){
                static final long serialVersionUID = 0L;

                @Override
                public void setText(String string) {
                    try {
                        if (AEATControlIBAN.this.nodesdetotal || AEATControlIBAN.this.total.setText(string, n2)) {
                            super.setText(string);
                        }
                    }
                    catch (ExceptionMotor exceptionMotor) {
                        exceptionMotor.printStackTrace();
                    }
                }
            };
        }
        return this.ncuenta[n];
    }

    public JTextField sCCC() {
        return this.total;
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        if (this.bOculto) {
            this.redibujaOculto();
        }
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        if (this.bOculto) {
            this.redibujaOculto();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        for (int i = 0; i < this.ncuenta.length; ++i) {
            this.getNCuenta(i).setEditable(bl);
        }
    }

    void initControl() {
        this.setLayout(null);
        this.getNCuenta(0).addPropertyChangeListener("font", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (AEATControlIBAN.this.bOculto) {
                    AEATControlIBAN.this.redibujaOculto();
                }
            }
        });
        this.jTPIBAN.setText("N\u00ba de cuenta IBAN");
        this.jTPIBAN.setName("IBAN");
        this.jTPIBAN.setEditable(false);
        this.jTPIBAN.setFocusable(false);
        for (int i = 0; i < this.ncuenta.length; ++i) {
            this.getNCuenta(i).setDocument(new Digitos(4, i));
            this.getNCuenta(i).setColumns(4);
            this.getNCuenta(i).addKeyListener(this.getKa(i));
            this.getNCuenta(i).addFocusListener(this.getFa(i));
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        for (int i = 0; i < this.ncuenta.length; ++i) {
            gridBagConstraints.gridx = i;
            this.add((Component)this.getNCuenta(i), gridBagConstraints);
            this.getNCuenta(i).setHorizontalAlignment(0);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.jTPIBAN, gridBagConstraints);
    }

    private KeyAdapter getKa(int n) {
        if (this.ka[n] == null) {
            this.ka[n] = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        ((Component)keyEvent.getSource()).transferFocus();
                    }
                    if (keyEvent.getSource() instanceof JTextField) {
                        JTextField jTextField = (JTextField)keyEvent.getSource();
                        if ((keyEvent.getKeyCode() == 8 || keyEvent.getKeyCode() == 127) && jTextField.getText().equals("ES")) {
                            keyEvent.consume();
                        }
                    }
                }
            };
        }
        return this.ka[n];
    }

    private FocusAdapter getFa(int n) {
        final int n2 = n;
        if (this.fa[n] == null) {
            this.fa[n] = new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    JTextField jTextField = (JTextField)focusEvent.getSource();
                    int n = jTextField.getText().length();
                    int n22 = jTextField.getColumns();
                    if (n2 == 0) {
                        if (jTextField.getText().equals("ES")) {
                            return;
                        }
                        if (jTextField.getText().length() == 0) {
                            jTextField.setText("ES");
                        }
                    }
                    if (n > 0 && n < n22) {
                        if (n2 == 0) {
                            jTextField.setText("ES");
                        } else {
                            jTextField.setText("");
                        }
                        try {
                            JMensajesProperties jMensajesProperties = new JMensajesProperties("WIN099");
                            jMensajesProperties.muestraMensaje();
                        }
                        catch (ExceptionMotor exceptionMotor) {
                            exceptionMotor.printStackTrace();
                        }
                        jTextField.requestFocusInWindow();
                    }
                }
            };
        }
        return this.fa[n];
    }

    private void redibujaOculto() {
        JTextPane[] jTextPaneArray = new JTextPane[]{this.jTPIBAN};
        for (int i = 0; i < jTextPaneArray.length; ++i) {
            JTextPane jTextPane = new JTextPane();
            jTextPane.setText(jTextPaneArray[i].getText());
            jTextPaneArray[i].setPreferredSize(new Dimension(jTextPane.getPreferredSize().width, 0));
        }
    }

    private static boolean valCntaPCampos(String string, String string2) {
        String string3 = "";
        if (string.trim().length() == 0 || string2.trim().length() == 0) {
            return true;
        }
        if (!string.contains("ES")) {
            return false;
        }
        string3 = string + string2;
        if (string3.replace('0', ' ').trim().length() == 0) {
            return false;
        }
        bIBANOK = AEATControlIBAN.validaIBAN(string3);
        bCuentaOK = AEATControlIBAN.controlaCuenta(string2) == 0;
        return bIBANOK && bCuentaOK;
    }

    public static int controlaCuentaIBAN(String string) {
        bIBANOK = AEATControlIBAN.validaIBAN(string);
        if (!bIBANOK) {
            return 2;
        }
        String string2 = string.substring(4);
        return AEATControlIBAN.controlaCuenta(string2);
    }

    public static boolean validaIBAN(String string) {
        try {
            if (string.length() <= 4 || string.length() > 34) {
                return false;
            }
            if (!(Character.isLetter(string.charAt(0)) && Character.isLetter(string.charAt(1)) && Character.isDigit(string.charAt(2)) && Character.isDigit(string.charAt(3)))) {
                return false;
            }
            for (int i = 4; i < string.length(); ++i) {
                if (Character.isLetter(string.charAt(i)) || Character.isDigit(string.charAt(i))) continue;
                return false;
            }
            String string2 = string.substring(4) + string.substring(0, 2) + "00";
            String string3 = "";
            for (byte by : string2.getBytes()) {
                string3 = Character.isDigit((char)by) ? string3 + (char)by : string3 + String.valueOf(by - 55);
            }
            Object object = new BigDecimal(string3);
            object = ((BigDecimal)object).divideAndRemainder(new BigDecimal(97))[1];
            return ((BigDecimal)(object = new BigDecimal(98).subtract((BigDecimal)object))).intValue() == Integer.valueOf(string.substring(2, 4)).intValue();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int controlaCuenta(String string) {
        if (string.endsWith("0000000000")) {
            return 2;
        }
        if (string.equals("00000000000000000000")) {
            return 2;
        }
        if (string.endsWith("00000000000000000000")) {
            return 2;
        }
        int[] nArray = new int[]{6, 3, 7, 9, 10, 5, 8, 4, 2, 1};
        long l = 0L;
        long l2 = 0L;
        char[] cArray = string.toCharArray();
        try {
            int n = 7;
            int n2 = 0;
            while (n >= 0) {
                l += (long)((cArray[n] - 48) * nArray[n2]);
                --n;
                ++n2;
            }
            l2 = Math.abs(l % 11L - 11L);
            if (l2 == 10L) {
                l2 = 1L;
            }
            if (l2 == 11L) {
                l2 = 0L;
            }
            if (l2 != (long)(cArray[8] - 48)) {
                return 1;
            }
            l = 0L;
            n = 19;
            n2 = 0;
            while (n >= 10) {
                l += (long)((cArray[n] - 48) * nArray[n2]);
                --n;
                ++n2;
            }
            l2 = Math.abs(l % 11L - 11L);
            if (l2 == 10L) {
                l2 = 1L;
            }
            if (l2 == 11L) {
                l2 = 0L;
            }
            if (l2 != (long)(cArray[9] - 48)) {
                return 2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            AEATLogger.getLogger().fatal((Object)"Fuera de los l\u00edmites del Array");
            return -1;
        }
        return 0;
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.total.setName(string);
    }

    public static void main(String[] stringArray) {
        JDialog jDialog = new JDialog((Frame)null, true);
        AEATControlIBAN aEATControlIBAN = new AEATControlIBAN();
        aEATControlIBAN.setSize(100, 30);
        jDialog.getContentPane().add(aEATControlIBAN);
        jDialog.setSize(400, 100);
        jDialog.setLocation(300, 300);
        aEATControlIBAN.sCCC().setText("ES35-0000-0000-0011-1111-1111");
        jDialog.setVisible(true);
        System.exit(3);
    }

    public void ocultarTexto() {
        try {
            this.bOculto = true;
            JTextPane[] jTextPaneArray = new JTextPane[]{this.jTPIBAN};
            for (int i = 0; i < jTextPaneArray.length; ++i) {
                if (jTextPaneArray[i] == null) {
                    return;
                }
                JTextPane jTextPane = new JTextPane();
                jTextPane.setText(jTextPaneArray[i].getText());
                jTextPaneArray[i].setPreferredSize(new Dimension(jTextPane.getPreferredSize().width, 0));
            }
        }
        catch (Exception exception) {
            AEATLogger.getLogger().debug((Object)exception);
        }
    }

    @Override
    public void requestFocus() {
        if (this.getNCuenta(0).isEnabled()) {
            this.getNCuenta(0).requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.getNCuenta(0).isEnabled()) {
            return this.getNCuenta(0).requestFocusInWindow();
        }
        return false;
    }

    class Total
    extends JTextField {
        static final long serialVersionUID = 0L;

        public Total() {
            for (int i = 0; i < AEATControlIBAN.this.ncuenta.length; ++i) {
                AEATControlIBAN.this.getNCuenta(i).setName("cuenta" + i);
            }
            this.setVisible(false);
        }

        @Override
        public void setEnabled(boolean bl) {
            if (!Aplicacion.isAccesible()) {
                for (int i = 0; i < AEATControlIBAN.this.ncuenta.length; ++i) {
                    AEATControlIBAN.this.getNCuenta(i).setEnabled(bl);
                }
            } else if (!bl) {
                for (int i = 0; i < AEATControlIBAN.this.ncuenta.length; ++i) {
                    AEATControlIBAN.this.getNCuenta(i).setEditable(false);
                }
            } else {
                for (int i = 0; i < AEATControlIBAN.this.ncuenta.length; ++i) {
                    AEATControlIBAN.this.getNCuenta(i).setEditable(true);
                }
            }
        }

        @Override
        public void setVisible(boolean bl) {
            for (int i = 0; i < AEATControlIBAN.this.ncuenta.length; ++i) {
                AEATControlIBAN.this.getNCuenta(i).setVisible(bl);
            }
        }

        protected boolean setText(String string, int n) throws ExceptionMotor {
            String string2;
            String string3 = this.getText();
            if (string3.length() == 0) {
                string3 = " - ";
            } else {
                if ((string3 = string3.replaceAll("--", "- -")).startsWith("-")) {
                    string3 = "ES" + string3;
                }
                if (string3.endsWith("-")) {
                    string3 = string3 + " ";
                } else if (string3.equals("ES- ")) {
                    string3 = "ES- - - - - ";
                }
            }
            String[] stringArray = string3.split("-");
            stringArray[n] = string2 = string.replace('\n', ' ').trim();
            String string4 = "";
            for (int i = 1; i < stringArray.length; ++i) {
                string4 = string4 + stringArray[i];
            }
            if (stringArray[0].length() + string4.length() < 24 || AEATControlIBAN.valCntaPCampos(stringArray[0], string4)) {
                String string5 = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    string5 = string5 + stringArray[i];
                    if (i == stringArray.length - 1) continue;
                    string5 = string5 + "-";
                }
                super.setText(string5);
                if (string2.length() == 0 || (string2.length() == 4 || string2.length() == 2) && n == 0 || string2.length() == 4 && n > 0 && n < 6) {
                    Aplicacion.getMotor().partidaModificada(this.getName(), string5);
                }
                return true;
            }
            JMensajesProperties jMensajesProperties = new JMensajesProperties("WIN099");
            jMensajesProperties.muestraMensaje();
            if (!bCuentaOK) {
                for (int i = 1; i < AEATControlIBAN.this.ncuenta.length; ++i) {
                    AEATControlIBAN.this.getNCuenta(i).setText("");
                }
            } else {
                AEATControlIBAN.this.getNCuenta(0).setText("ES");
                String string6 = "ES-";
                for (int i = 1; i < stringArray.length; ++i) {
                    string6 = string6 + stringArray[i];
                    if (i == stringArray.length - 1) continue;
                    string6 = string6 + "-";
                }
                super.setText(string6);
                Aplicacion.getMotor().partidaModificada(this.getName(), string6);
                AEATControlIBAN.this.getNCuenta(0).requestFocusInWindow();
            }
            return false;
        }

        @Override
        public void setText(String string) {
            String[] stringArray;
            String[] stringArray2;
            String string2 = string;
            if (string2 == null || string2.length() == 0 || string2.equals("ES-")) {
                string2 = "ES- - - - - ";
            }
            if ((string2 = string2.replaceAll("--", "- -")).startsWith("-")) {
                string2 = "ES" + string2;
            }
            if (string2.endsWith("-")) {
                string2 = string2 + " ";
            }
            if ((stringArray2 = string2.split("-")).length == 2) {
                try {
                    string2 = string2.substring(0, 5) + string2.substring(5, 9) + "-" + string2.substring(9, 13) + "-" + string2.substring(13, 17) + "-" + string2.substring(17, 21) + "-" + string2.substring(21, 25);
                }
                catch (Exception exception) {
                    AEATLogger.getLogger().fatal((Object)"Formato de cuenta erroneo");
                    return;
                }
            }
            if ((stringArray = string2.split("-")).length != 6) {
                AEATLogger.getLogger().fatal((Object)"Formato de cuenta erroneo");
                return;
            }
            super.setText(string2);
            AEATControlIBAN.this.nodesdetotal = false;
            for (int i = 0; i < AEATControlIBAN.this.ncuenta.length; ++i) {
                AEATControlIBAN.this.getNCuenta(i).setText(stringArray[i]);
            }
            AEATControlIBAN.this.nodesdetotal = true;
        }
    }

    private class Digitos
    extends PlainDocument {
        static final long serialVersionUID = 0L;
        int mmax;
        int mpos;

        public Digitos(int n, int n2) {
            this.mmax = n;
            this.mpos = n2;
        }

        @Override
        public void remove(int n, int n2) throws BadLocationException {
            super.remove(n, n2);
            for (int i = 0; i < AEATControlIBAN.this.ncuenta.length; ++i) {
                AEATControlIBAN.this.getNCuenta(i).setForeground(Color.RED);
            }
            String string = "";
            string = this.getText(0, this.getLength());
            try {
                AEATControlIBAN.this.total.setText(string, this.mpos);
            }
            catch (ExceptionMotor exceptionMotor) {
                exceptionMotor.printStackTrace();
            }
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            boolean bl = true;
            for (int i = 0; i < string.length(); ++i) {
                if (this.mpos == 0) {
                    if (string.length() == 4) {
                        if (i < 2) {
                            bl = bl && Character.isLetter(string.charAt(i));
                            continue;
                        }
                        bl = bl && Character.isDigit(string.charAt(i));
                        continue;
                    }
                    if (n == 0 || n == 1) {
                        bl = bl && Character.isLetter(string.charAt(i));
                        continue;
                    }
                    bl = bl && Character.isDigit(string.charAt(i));
                    continue;
                }
                bl = bl && Character.isDigit(string.charAt(i));
            }
            if (bl && this.getLength() + string.length() <= this.mmax) {
                super.insertString(n, string.toUpperCase(), attributeSet);
                String string2 = "";
                string2 = this.getText(0, this.getLength());
                try {
                    AEATControlIBAN.this.total.setText(string2, this.mpos);
                }
                catch (ExceptionMotor exceptionMotor) {
                    exceptionMotor.printStackTrace();
                }
            }
            String string3 = "";
            for (int i = 1; i < AEATControlIBAN.this.ncuenta.length; ++i) {
                string3 = string3 + AEATControlIBAN.this.getNCuenta(i).getText();
            }
            String string4 = AEATControlIBAN.this.getNCuenta(0).getText() + string3;
            if (string4.length() < 24) {
                for (int i = 0; i < AEATControlIBAN.this.ncuenta.length; ++i) {
                    AEATControlIBAN.this.getNCuenta(i).setForeground(Color.RED);
                }
            } else if (AEATControlIBAN.valCntaPCampos(AEATControlIBAN.this.getNCuenta(0).getText(), string3)) {
                for (int i = 0; i < AEATControlIBAN.this.ncuenta.length; ++i) {
                    AEATControlIBAN.this.getNCuenta(i).setForeground(Color.BLACK);
                }
            } else {
                super.remove(0, this.mmax);
            }
        }
    }
}

