/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.componentes;

import es.aeat.pare.aplicacion.Aplicacion;
import es.aeat.pare.componentes.AEATLogger;
import es.aeat.pare.componentes.JMensajesProperties;
import es.aeat.pftw.mtrc.api.excepciones.ExceptionMotor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class AEATControlCuenta
extends JPanel {
    static final long serialVersionUID = 0L;
    private JTextField entidad = new JTextField(){
        static final long serialVersionUID = 0L;

        @Override
        public void setText(String string) {
            try {
                if (AEATControlCuenta.this.nodesdetotal || AEATControlCuenta.this.total.setText(string, 0)) {
                    super.setText(string);
                }
            }
            catch (ExceptionMotor exceptionMotor) {
                exceptionMotor.printStackTrace();
            }
        }
    };
    private JTextField sucursal = new JTextField(){
        static final long serialVersionUID = 0L;

        @Override
        public void setText(String string) {
            try {
                if (AEATControlCuenta.this.nodesdetotal || AEATControlCuenta.this.total.setText(string, 1)) {
                    super.setText(string);
                }
            }
            catch (ExceptionMotor exceptionMotor) {
                exceptionMotor.printStackTrace();
            }
        }
    };
    private JTextField digitoscontrol = new JTextField(){
        static final long serialVersionUID = 0L;

        @Override
        public void setText(String string) {
            try {
                if (AEATControlCuenta.this.nodesdetotal || AEATControlCuenta.this.total.setText(string, 2)) {
                    super.setText(string);
                }
            }
            catch (ExceptionMotor exceptionMotor) {
                exceptionMotor.printStackTrace();
            }
        }
    };
    private JTextField numerocuenta = new JTextField(){
        static final long serialVersionUID = 0L;

        @Override
        public void setText(String string) {
            try {
                if (AEATControlCuenta.this.nodesdetotal || AEATControlCuenta.this.total.setText(string, 3)) {
                    super.setText(string);
                }
            }
            catch (ExceptionMotor exceptionMotor) {
                exceptionMotor.printStackTrace();
            }
        }
    };
    private Total total = new Total();
    private JTextPane jTPEntidad = new JTextPane();
    private JTextPane jTPSucursal = new JTextPane();
    private JTextPane jTPDC = new JTextPane();
    private JTextPane jTPCuenta = new JTextPane();
    private boolean nodesdetotal = true;
    private boolean bOculto;

    public AEATControlCuenta() {
        this.initControl();
    }

    public JTextField sCCC() {
        return this.total;
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        if (this.bOculto) {
            this.redibujaOculto();
        }
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        if (this.bOculto) {
            this.redibujaOculto();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this.entidad.setEditable(bl);
        this.sucursal.setEditable(bl);
        this.digitoscontrol.setEditable(bl);
        this.numerocuenta.setEditable(bl);
    }

    void initControl() {
        this.setLayout(null);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    ((Component)keyEvent.getSource()).transferFocus();
                }
            }
        };
        this.entidad.addPropertyChangeListener("font", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (AEATControlCuenta.this.bOculto) {
                    AEATControlCuenta.this.redibujaOculto();
                }
            }
        });
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                JTextField jTextField = (JTextField)focusEvent.getSource();
                int n = jTextField.getText().length();
                int n2 = jTextField.getColumns();
                if (n > 0 && n < n2) {
                    jTextField.setText("");
                    try {
                        JMensajesProperties jMensajesProperties = new JMensajesProperties("WIN012");
                        jMensajesProperties.muestraMensaje();
                    }
                    catch (ExceptionMotor exceptionMotor) {
                        exceptionMotor.printStackTrace();
                    }
                    jTextField.requestFocusInWindow();
                }
            }
        };
        this.jTPCuenta.setText("N\u00ba de cuenta");
        this.jTPCuenta.setName("Cuenta");
        this.jTPCuenta.setEditable(false);
        this.jTPCuenta.setFocusable(false);
        this.jTPDC.setText("DC");
        this.jTPDC.setName("DC");
        this.jTPDC.setEditable(false);
        this.jTPDC.setFocusable(false);
        this.jTPEntidad.setText("Entidad");
        this.jTPEntidad.setName("Entidad");
        this.jTPEntidad.setEditable(false);
        this.jTPEntidad.setFocusable(false);
        this.jTPSucursal.setText("Oficina");
        this.jTPSucursal.setName("Oficina");
        this.jTPSucursal.setEditable(false);
        this.jTPSucursal.setFocusable(false);
        this.entidad.setDocument(new Digitos(4, 0));
        this.sucursal.setDocument(new Digitos(4, 1));
        this.digitoscontrol.setDocument(new Digitos(2, 2));
        this.numerocuenta.setDocument(new Digitos(10, 3));
        this.entidad.setColumns(4);
        this.sucursal.setColumns(4);
        this.digitoscontrol.setColumns(2);
        this.numerocuenta.setColumns(10);
        this.entidad.addKeyListener(keyAdapter);
        this.sucursal.addKeyListener(keyAdapter);
        this.digitoscontrol.addKeyListener(keyAdapter);
        this.numerocuenta.addKeyListener(keyAdapter);
        this.entidad.addFocusListener(focusAdapter);
        this.sucursal.addFocusListener(focusAdapter);
        this.digitoscontrol.addFocusListener(focusAdapter);
        this.numerocuenta.addFocusListener(focusAdapter);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.entidad, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.sucursal, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.add((Component)this.digitoscontrol, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        this.add((Component)this.numerocuenta, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jTPEntidad, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.jTPSucursal, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.add((Component)this.jTPDC, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        this.add((Component)this.jTPCuenta, gridBagConstraints);
        this.entidad.setHorizontalAlignment(0);
        this.sucursal.setHorizontalAlignment(0);
        this.digitoscontrol.setHorizontalAlignment(0);
        this.numerocuenta.setHorizontalAlignment(0);
    }

    private void redibujaOculto() {
        JTextPane[] jTextPaneArray = new JTextPane[]{this.jTPEntidad, this.jTPSucursal, this.jTPDC, this.jTPCuenta};
        for (int i = 0; i < jTextPaneArray.length; ++i) {
            JTextPane jTextPane = new JTextPane();
            jTextPane.setText(jTextPaneArray[i].getText());
            jTextPaneArray[i].setPreferredSize(new Dimension(jTextPane.getPreferredSize().width, 0));
        }
    }

    private static boolean valCntaPCampos(String string, String string2, String string3, String string4) {
        String string5 = "";
        if (string.trim().length() == 0 || string2.trim().length() == 0 || string3.trim().length() == 0 || string4.trim().length() == 0) {
            return true;
        }
        string5 = string + string2 + string3 + string4;
        if (string5.replace('0', ' ').trim().length() == 0) {
            return false;
        }
        return AEATControlCuenta.controlaCuenta(string5) == 0;
    }

    public static int controlaCuenta(String string) {
        if (string.equals("00000000000000000000")) {
            return 2;
        }
        if (string.endsWith("0000000000")) {
            return 2;
        }
        int[] nArray = new int[]{6, 3, 7, 9, 10, 5, 8, 4, 2, 1};
        long l = 0L;
        long l2 = 0L;
        char[] cArray = string.toCharArray();
        try {
            int n = 7;
            int n2 = 0;
            while (n >= 0) {
                l += (long)((cArray[n] - 48) * nArray[n2]);
                --n;
                ++n2;
            }
            l2 = Math.abs(l % 11L - 11L);
            if (l2 == 10L) {
                l2 = 1L;
            }
            if (l2 == 11L) {
                l2 = 0L;
            }
            if (l2 != (long)(cArray[8] - 48)) {
                return 1;
            }
            l = 0L;
            n = 19;
            n2 = 0;
            while (n >= 10) {
                l += (long)((cArray[n] - 48) * nArray[n2]);
                --n;
                ++n2;
            }
            l2 = Math.abs(l % 11L - 11L);
            if (l2 == 10L) {
                l2 = 1L;
            }
            if (l2 == 11L) {
                l2 = 0L;
            }
            if (l2 != (long)(cArray[9] - 48)) {
                return 2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            AEATLogger.getLogger().fatal((Object)"Fuera de los l\u00edmites del Array");
            return -1;
        }
        return 0;
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.total.setName(string);
    }

    public static void main(String[] stringArray) {
        JDialog jDialog = new JDialog((Frame)null, true);
        AEATControlCuenta aEATControlCuenta = new AEATControlCuenta();
        aEATControlCuenta.setSize(100, 30);
        jDialog.getContentPane().add(aEATControlCuenta);
        jDialog.setSize(400, 100);
        jDialog.setLocation(300, 300);
        aEATControlCuenta.sCCC().setText("0000-0000-00-1111111111");
        aEATControlCuenta.sCCC().setText(" ");
        jDialog.setVisible(true);
        System.exit(3);
    }

    public void ocultarTexto() {
        try {
            this.bOculto = true;
            JTextPane[] jTextPaneArray = new JTextPane[]{this.jTPEntidad, this.jTPSucursal, this.jTPDC, this.jTPCuenta};
            for (int i = 0; i < jTextPaneArray.length; ++i) {
                if (jTextPaneArray[i] == null) {
                    return;
                }
                JTextPane jTextPane = new JTextPane();
                jTextPane.setText(jTextPaneArray[i].getText());
                jTextPaneArray[i].setPreferredSize(new Dimension(jTextPane.getPreferredSize().width, 0));
            }
        }
        catch (Exception exception) {
            AEATLogger.getLogger().debug((Object)exception);
        }
    }

    @Override
    public void requestFocus() {
        if (this.entidad.isEnabled()) {
            this.entidad.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.entidad.isEnabled()) {
            return this.entidad.requestFocusInWindow();
        }
        return false;
    }

    public JTextPane getEntidad() {
        return this.jTPEntidad;
    }

    public JTextPane getSucursal() {
        return this.jTPSucursal;
    }

    public JTextPane getDC() {
        return this.jTPDC;
    }

    public JTextPane getNcuenta() {
        return this.jTPCuenta;
    }

    class Total
    extends JTextField {
        static final long serialVersionUID = 0L;

        public Total() {
            AEATControlCuenta.this.entidad.setName("entidad");
            AEATControlCuenta.this.sucursal.setName("sucursal");
            AEATControlCuenta.this.digitoscontrol.setName("digitoscontrol");
            AEATControlCuenta.this.numerocuenta.setName("numerocuenta");
            this.setVisible(false);
        }

        @Override
        public void setEnabled(boolean bl) {
            if (!Aplicacion.isAccesible()) {
                AEATControlCuenta.this.entidad.setEnabled(bl);
                AEATControlCuenta.this.sucursal.setEnabled(bl);
                AEATControlCuenta.this.digitoscontrol.setEnabled(bl);
                AEATControlCuenta.this.numerocuenta.setEnabled(bl);
            } else if (!bl) {
                AEATControlCuenta.this.entidad.setEditable(false);
                AEATControlCuenta.this.sucursal.setEditable(false);
                AEATControlCuenta.this.digitoscontrol.setEditable(false);
                AEATControlCuenta.this.numerocuenta.setEditable(false);
            } else {
                AEATControlCuenta.this.entidad.setEditable(true);
                AEATControlCuenta.this.sucursal.setEditable(true);
                AEATControlCuenta.this.digitoscontrol.setEditable(true);
                AEATControlCuenta.this.numerocuenta.setEditable(true);
            }
        }

        @Override
        public void setVisible(boolean bl) {
            AEATControlCuenta.this.entidad.setVisible(bl);
            AEATControlCuenta.this.sucursal.setVisible(bl);
            AEATControlCuenta.this.digitoscontrol.setVisible(bl);
            AEATControlCuenta.this.numerocuenta.setVisible(bl);
        }

        protected boolean setText(String string, int n) throws ExceptionMotor {
            String string2 = this.getText();
            if (string2.length() == 0) {
                string2 = " - - - ";
            } else {
                if ((string2 = string2.replaceAll("--", "- -")).startsWith("-")) {
                    string2 = " " + string2;
                }
                if (string2.endsWith("-")) {
                    string2 = string2 + " ";
                }
            }
            String[] stringArray = string2.split("-");
            stringArray[n] = string = string.replace('\n', ' ').trim();
            if (stringArray[0].length() + stringArray[1].length() + stringArray[2].length() + stringArray[3].length() < 20 || AEATControlCuenta.valCntaPCampos(stringArray[0], stringArray[1], stringArray[2], stringArray[3])) {
                String string3 = stringArray[0] + "-" + stringArray[1] + "-" + stringArray[2] + "-" + stringArray[3];
                super.setText(string3);
                if (string.length() == 0 || string.length() == 4 && n < 2 || string.length() == 2 && n == 2 || string.length() == 10 && n == 3) {
                    Aplicacion.getMotor().partidaModificada(this.getName(), string3);
                }
                return true;
            }
            JMensajesProperties jMensajesProperties = new JMensajesProperties("WIN012");
            jMensajesProperties.muestraMensaje();
            if (n == 0) {
                AEATControlCuenta.this.entidad.setText("");
            } else if (n == 1) {
                AEATControlCuenta.this.sucursal.setText("");
            } else if (n == 2) {
                AEATControlCuenta.this.digitoscontrol.setText("");
            } else if (n == 3) {
                AEATControlCuenta.this.numerocuenta.setText("");
            }
            return false;
        }

        @Override
        public void setText(String string) {
            String[] stringArray;
            if (string == null || string.length() == 0) {
                string = " - - - ";
            }
            if ((string = string.replaceAll("--", "- -")).startsWith("-")) {
                string = " " + string;
            }
            if (string.endsWith("-")) {
                string = string + " ";
            }
            if ((stringArray = string.split("-")).length != 4) {
                AEATLogger.getLogger().fatal((Object)"Formato de cuenta erroneo");
                return;
            }
            super.setText(string);
            AEATControlCuenta.this.nodesdetotal = false;
            AEATControlCuenta.this.entidad.setText(stringArray[0]);
            AEATControlCuenta.this.sucursal.setText(stringArray[1]);
            AEATControlCuenta.this.digitoscontrol.setText(stringArray[2]);
            AEATControlCuenta.this.numerocuenta.setText(stringArray[3]);
            AEATControlCuenta.this.nodesdetotal = true;
        }
    }

    private class Digitos
    extends PlainDocument {
        static final long serialVersionUID = 0L;
        int mmax;
        int mpos;

        public Digitos(int n, int n2) {
            this.mmax = n;
            this.mpos = n2;
        }

        @Override
        public void remove(int n, int n2) throws BadLocationException {
            super.remove(n, n2);
            AEATControlCuenta.this.sucursal.setForeground(Color.RED);
            AEATControlCuenta.this.entidad.setForeground(Color.RED);
            AEATControlCuenta.this.digitoscontrol.setForeground(Color.RED);
            AEATControlCuenta.this.numerocuenta.setForeground(Color.RED);
            String string = "";
            string = this.getText(0, this.getLength());
            try {
                AEATControlCuenta.this.total.setText(string, this.mpos);
            }
            catch (ExceptionMotor exceptionMotor) {
                exceptionMotor.printStackTrace();
            }
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2;
            boolean bl = true;
            for (int i = 0; i < string.length(); ++i) {
                bl = bl && Character.isDigit(string.charAt(i));
            }
            if (bl && this.getLength() + string.length() <= this.mmax) {
                super.insertString(n, string, attributeSet);
                String string3 = "";
                string3 = this.getText(0, this.getLength());
                try {
                    AEATControlCuenta.this.total.setText(string3, this.mpos);
                }
                catch (ExceptionMotor exceptionMotor) {
                    exceptionMotor.printStackTrace();
                }
            }
            if ((string2 = AEATControlCuenta.this.entidad.getText() + AEATControlCuenta.this.sucursal.getText() + AEATControlCuenta.this.digitoscontrol.getText() + AEATControlCuenta.this.numerocuenta.getText()).length() < 20) {
                AEATControlCuenta.this.sucursal.setForeground(Color.RED);
                AEATControlCuenta.this.entidad.setForeground(Color.RED);
                AEATControlCuenta.this.digitoscontrol.setForeground(Color.RED);
                AEATControlCuenta.this.numerocuenta.setForeground(Color.RED);
            } else if (AEATControlCuenta.controlaCuenta(string2) == 0) {
                AEATControlCuenta.this.sucursal.setForeground(Color.BLACK);
                AEATControlCuenta.this.entidad.setForeground(Color.BLACK);
                AEATControlCuenta.this.digitoscontrol.setForeground(Color.BLACK);
                AEATControlCuenta.this.numerocuenta.setForeground(Color.BLACK);
            } else {
                super.remove(0, this.mmax);
            }
        }
    }
}

