/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.componentes;

import es.aeat.pare.aplicacion.Constantes;
import es.aeat.pare.componentes.AEATmotorListener;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.UIManager;

public class AEATCheckField
extends JCheckBox {
    private static boolean bTexto = false;
    private static String sDeco = "<<";
    private static final long serialVersionUID = 1L;
    protected boolean puedeSerReadOnly;
    private final FocusListener fl = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent focusEvent) {
            AEATmotorListener.setComponentePierdeFoco(AEATCheckField.this);
            UIManager.put("CheckBox.background", UIManager.getLookAndFeel().getDefaults().get("CheckBox.background"));
            String string = AEATCheckField.this.getText();
            if (string.startsWith("<html>")) {
                string = string.substring(0, "<html>".length());
            }
            if (string.endsWith("</html>")) {
                string = string.substring(0, "</html>".length());
            }
            AEATCheckField.this.setText(string);
            if (!bTexto) {
                AEATCheckField.this.setForeground(Color.BLACK);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!bTexto) {
                AEATCheckField.this.setForeground(AEATCheckField.this.getParent().getBackground());
            }
        }
    };

    public AEATCheckField() {
        this.initCheckField("");
    }

    public AEATCheckField(String string) {
        this.initCheckField(string);
    }

    private void initCheckField(String string) {
        bTexto = !"null".equals(string) && !string.equals("");
        URL uRL = this.getClass().getResource(Constantes.getDirectorioImagenes() + "checkboxEnabled.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.setIcon(imageIcon);
        uRL = this.getClass().getResource(Constantes.getDirectorioImagenes() + "checkboxHover.png");
        ImageIcon imageIcon2 = new ImageIcon(uRL);
        this.setRolloverIcon(imageIcon2);
        uRL = this.getClass().getResource(Constantes.getDirectorioImagenes() + "checkboxHoverActive.png");
        ImageIcon imageIcon3 = new ImageIcon(uRL);
        this.setRolloverSelectedIcon(imageIcon3);
        uRL = this.getClass().getResource(Constantes.getDirectorioImagenes() + "checkboxActive.png");
        ImageIcon imageIcon4 = new ImageIcon(uRL);
        this.setSelectedIcon(imageIcon4);
        uRL = this.getClass().getResource(Constantes.getDirectorioImagenes() + "checkboxDisabledActive.png");
        ImageIcon imageIcon5 = new ImageIcon(uRL);
        this.setDisabledSelectedIcon(imageIcon5);
        this.addFocusListener(this.fl);
        this.setOpaque(false);
        if (bTexto) {
            this.setText(string);
        } else {
            this.setForeground(Constantes.getColorBkClaro());
            this.setText(sDeco);
        }
    }

    public boolean setPuedeSerReadOnly() {
        return this.puedeSerReadOnly;
    }

    public void setPuedeSerReadOnly(boolean bl) {
        this.puedeSerReadOnly = bl;
    }

    public Object getValor() {
        return this.isSelected() + "";
    }

    public Object getEstado() {
        return "IMotor.HABILITADO";
    }

    public void accesibilidad(String string) {
        this.setToolTipText(string);
        this.getAccessibleContext().setAccessibleName(string);
        this.getAccessibleContext().setAccessibleDescription(string);
    }

    public static boolean isbTexto() {
        return bTexto;
    }

    public static void setbTexto(boolean bl) {
        bTexto = bl;
    }
}

