/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pare.cc14;

import es.aeat.pare.aplicacion.Aplicacion;
import es.aeat.pare.aplicacion.Constantes;
import java.io.Serializable;

public class Declarantes
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int CTE1 = 10;
    protected static final int CTE2 = 20;
    protected static final int CTE5 = 150;
    protected int dec;
    public static final Declarantes Declarante = new Declarantes(10);
    public static final Declarantes Conyuge = new Declarantes(20);
    public static final Declarantes UnidadFamiliar = new Declarantes(150);
    public static final Declarantes Vacio = new Declarantes(0);

    private Declarantes() {
    }

    private Declarantes(int n) {
        this.dec = n;
    }

    public int toInt() {
        return this.dec;
    }

    public static Declarantes parseInt(int n) {
        return new Declarantes(n);
    }

    public static Declarantes parseString(String string) {
        if (string.equalsIgnoreCase("Declarante") || string.equalsIgnoreCase("Default")) {
            return Declarante;
        }
        if (string.equalsIgnoreCase("Conyuge")) {
            return Conyuge;
        }
        if (string.equalsIgnoreCase("C\u00f3nyuge")) {
            return Conyuge;
        }
        for (int i = 1; i <= Constantes.getNumhijosrentas(); ++i) {
            if (!string.equalsIgnoreCase("Hijo" + i)) continue;
            return new Declarantes(20 + i * 10);
        }
        if (string.equalsIgnoreCase("Unidad familiar") || string.equalsIgnoreCase("Conjunta")) {
            return UnidadFamiliar;
        }
        return Vacio;
    }

    public String getNombreUnico() {
        switch (this.dec) {
            case 10: {
                return "DECLARANTE";
            }
            case 20: {
                return "CONYUGE";
            }
            case 150: {
                return "CONJUNTA";
            }
        }
        for (int i = 1; i <= Constantes.getNumhijosrentas(); ++i) {
            if (this.dec != 20 + i * 10) continue;
            return "HIJO" + i;
        }
        return "ERROR";
    }

    public String getNombreUnicoTraducido() {
        switch (this.dec) {
            case 10: {
                return Aplicacion.getString("menu.declarante").toUpperCase();
            }
            case 20: {
                return Aplicacion.getString("menu.conyuge").toUpperCase();
            }
            case 150: {
                return Aplicacion.getString("JDlgResumen.cj").toUpperCase();
            }
        }
        for (int i = 1; i <= Constantes.getNumhijosrentas(); ++i) {
            if (this.dec != 20 + i * 10) continue;
            return Aplicacion.getString("menu.hijo").toUpperCase() + String.valueOf(i);
        }
        return "ERROR";
    }

    public boolean equals(Object object) {
        return this.toInt() == ((Declarantes)object).toInt();
    }

    public String toString() {
        return this.getNombreUnico();
    }
}

